# Firava

Firava adapts Mozilla's open source [Fira Sans](https://github.com/mozilla/Fira) typeface into a variable version.

**[View the sample page.](https://firava.netlify.app/)**

**Download the .woff2, .tff, and Base64 (embedded in .css) fonts from [the /fonts folder](https://github.com/hellogreg/firava/tree/main/fonts) here.**

## Features

* The typeface includes regular and italic styles.
* Currently, the typeface has a single variable axis, weight, which ranges from 100 (Thin) to 900 (Black), with a default weight of 400.
* The source version of Fira has nearly 1,700 characters. Firava is currently limited to just over 450.
* Current version: 5.000 (Previous Fira Sans version was 4.202).

## Tools

I'm using the following tools to produce Firava:
* [Glyphs 2.6.5](https://glyphsapp.com/)
* [FontLab 7](https://www.fontlab.com/font-editor/fontlab/)
* [Glyphhanger](https://github.com/filamentgroup/glyphhanger)
* [woff2](https://github.com/google/woff2)

I've found Travis Kochel's [I Can Variable Font](https://github.com/scribbletone/i-can-variable-font) super-helpful throughout this process.

[Wakamai Fondue](https://wakamaifondue.com/) is indispensable for testing variable fonts.

And I used [my own Glytter tool](https://hellogreg.github.io/glytter/) to view/copy/paste the full character set for the sample page.

## Credits/Licensing

Firava and Fira Sans are licensed under the [SIL Open Font License, Version 1.1](http://scripts.sil.org/OFL).

Fira Sans digital data is ©2012-15, The Mozilla Foundation and Telefonica S.A.

Firava was produced by Greg Gibson ([hellogreg.org](https://hellogreg.org)). I generated it for a simple reason: I love Fira Sans and wanted to use it for a project, but I needed a variable font!
