# 𝕏 Profile Card

> [!NOTE]
> Working on version 2 with a lot of features. [Have a look by clicking here](https://github.com/Youth-Icon/xprofile)
> also [join Discord](https://discord.gg/vUHMxPvege) to discuss upcoming features

A website to list your Twitter ( 𝕏 ) and Github profile to the world


![image](https://github.com/hellofaizan/xprofile/assets/84437051/5b463c7d-4488-4743-8e56-f0cf31c6ba3d)



## Languages/Tools

<a href="https://discord.gg/EHthxHRUmr">
    <img src="https://skillicons.dev/icons?i=next,js,react,firebase" />
  </a>

## 👩🏽‍💻 Demo

Check out the website: [𝕏 Profiles](https://x.hellofaizan.me)

## 👇🏽 File Format
```json
    ,{
        "username": "hellofaizaan",
        "name": "Hello Faizan",
        "github": "hellofaizan",
        "banner_color": "#ff2500",
        "about": "I am a full stack developer and a competitive programmer. I love Chess♟️ also https://hellofaizan.me/"
    }
```

| Key  | Value                                                                                  |
| ---- | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------ |
| username | This value should be your Twitter (𝕏) username.|
| name | This value should be your real name. |
| github | The value should be your Github username                   |
| banner_color | The value should contain any hex code for background just like Twitter eg: #fff, #000   |
| about | Short simple `max 2 lines` about yourself, You can also include links which are clickable   |
    

## 🛠️ Installation Steps

### 🔥 Add your profile using

1. Fork the project:

- [Fork](https://github.com/hellofaizan/xprofile/fork) the project. Click on the <a href="https://github.com/hellofaizan/xprofile/fork"><img src="https://i.imgur.com/G4z1kEe.png" height="15" width="15"></a> icon in the top right to get started.

2. Create a New Branch:

- On your new repository's page, click the gray `main` button in the upper left to reveal a dropdown menu.
- Enter the name of your new branch in the text box. (Branch names usually make a reference to what is being changed. Example: `profileAdd`).
- Click on `Create branch <new branch name>` and this will automatically take you to your new branch. You can make edits on the main branch, but this may cause issues down the line. Best practice is to create a new branch for each separate issue you work on. That way, your `main` branch remains in sync with `xprofile` `main` branch.

3. Navigate to file:

- Navigate to the `data/users.json` file.

4. Edit:

- On the top right of the JSON file, click on the pencil icon to edit the file by adding your image, name and username.
- You can add JSON object wherever you want in the file, it will automatically arrange according to alphabetical order.
- After editing the JSON file, add a commit message and click on the green button saying "Commit Changes". Make sure you have selected the branch you have created.

5. Raise a Pull Request:

- And finally, create a [Pull Request](https://help.github.com/en/github/collaborating-with-issues-and-pull-requests/creating-a-pull-request)!
- Great job! You did it!
- Remember to PR in ```addProfile branch of repository```


## 🚀 Running locally
To run locally, just `cd` into the project and run the following commands to run node modules and serve the website locally.
```bash
yarn
```

```bash
yarn run dev
```

## 💪🏽 Contributors

Thank you all so much for spending your time to improve 𝕏 Profile.

<a href="https://github.com/hellofaizan/xprofile/graphs/contributors">
  <img src="https://contrib.rocks/image?repo=hellofaizan/xprofile" />
</a>

## Repository Activity

![Alt](https://repobeats.axiom.co/api/embed/3c905c2b26fc447eb080acba085a899468acd7e3.svg "Repobeats analytics image")

## Star History

<a href="https://star-history.com/#hellofaizan/xprofile&Date">
  <picture>
    <source media="(prefers-color-scheme: dark)" srcset="https://api.star-history.com/svg?repos=hellofaizan/xprofile&type=Date&theme=dark" />
    <source media="(prefers-color-scheme: light)" srcset="https://api.star-history.com/svg?repos=hellofaizan/xprofile&type=Date" />
    <img alt="Star History Chart" src="https://api.star-history.com/svg?repos=hellofaizan/xprofile&type=Date" />
  </picture>
</a>


# Join Discord 💻

<a href="https://discord.gg/vUHMxPvege">
     <img src="https://invidget.switchblade.xyz/vUHMxPvege" width="400" height="100" />
</a>
<hr/>

## Drop a ⭐ if you like this project
