# Contributing Guide

## Issues & Pull Requests (not for Profiles)

### Creating an Issue

Before **creating** an Issue for `features`/`bugs`/`improvements` please follow these steps:

> _Note: this does not apply to creating/editing your profile_

1. search existing Issues before creating a new issue (has someone raised this already)
1. if it doesn't exist create a new issue giving as much context as possible (please select the correct Issue type, for example `bug` or `feature`)
1. if you wish to work on the Issue once it has been opened, please include this in your Issue description

### Working on an Issue (get it assigned to you)

Before working on an existing Issue please follow these steps:

1. only ask to be assigned 1 issue at a time
1. comment asking for the issue to be assigned to you (do not tag maintainers on GitHub or Discord as all maintainers receive your comment notifications)
1. after the Issue is assigned to you, you can start working on it
1. **only** start working on this Issue (and open a Pull Request) when it has been assigned to you - this will prevent confusion, multiple people working on the same issue and work not being used
1. do **not** enable GitHub Actions on your fork
1. reference the Issue in your Pull Request (for example `closes #123`)

> Notes:
>
> - check the `Assignees` box at the top of the page to see if the issue has been assigned to someone else before requesting this be assigned to you
> - if an Issue is unclear, ask questions to get more clarity before asking to have the Issue assigned to you
> - only request to be assigned an Issue if you know how to work on it
> - an Issue can be assigned to multiple people, if you all agree to collaborate on the issue (the Pull Request can contain commits from different collaborators)
> - any Issues that have no activity after 2 weeks will be unassigned and re-assigned to someone else

## Reviewing Pull Requests

We welcome everyone to review Pull Requests, it is a great way to learn, network and support each other.

### DOs

- be kind and respectful, we use inclusive, gender neutral language (for example `they/them` instead of `guy/man`)
- use inline comments to explain your suggestions
- use inline suggestions to propose changes

### DON'Ts

- do not be rude, disrespectful or aggressive
- do not repeat feedback, this creates more noise than value (check the existing conversation), use GitHub reactions if you agree/disagree with a comment
- do not blindly approve pull requests to improve your GitHub contributors graph

---

Please refer to the `Contributing` section of the website's documentation for more details https://x.hellofaizan.me

---

> Note: Persistent non-compliance with this Contributing Guide can lead to a warning and/or ban under the [Code of Conduct](https://github.com/EddieHubCommunity/BioDrop/blob/main/CODE_OF_CONDUCT.md)
