create table session (
  id varchar(255) PRIMARY KEY,
  -- name that goes in the UI - ideally autogenerated by AI but for now can be named manually
  name varchar(255),
  created timestamp default current_timestamp,
  updated timestamp default current_timestamp,
  -- e.g. create, finetune
  mode varchar(255) NOT NULL,
  -- e.g. text, images
  type varchar(255) NOT NULL,
  -- huggingface model name e.g. mistralai/Mistral-7B-Instruct-v0.1 or
  -- stabilityai/stable-diffusion-xl-base-1.0
  model_name varchar(255) NOT NULL,
  -- if type == finetune, we record a filestore path to e.g. lora file here
  -- currently the only place you can do inference on a finetune is within the
  -- session where the finetune was generated
  finetune_file varchar(255) NOT NULL,
  -- for now we just whack the entire history of the interaction in here, json style
  interactions json not null,
  owner varchar(255) NOT NULL,
  -- e.g. user, system, org
  owner_type varchar(255) NOT NULL
);