// Package server Code generated by swaggo/swag. DO NOT EDIT
package server

import "github.com/swaggo/swag"

const docTemplate = `{
    "schemes": {{ marshal .Schemes }},
    "swagger": "2.0",
    "info": {
        "description": "{{escape .Description}}",
        "title": "{{.Title}}",
        "contact": {
            "name": "Helix support",
            "url": "https://app.tryhelix.ai/",
            "email": "info@helix.ml"
        },
        "version": "{{.Version}}",
        "x-logo": {
            "altText": "Helix logo",
            "url": "https://avatars.githubusercontent.com/u/149581110?s=200\u0026v=4"
        }
    },
    "host": "{{.Host}}",
    "basePath": "{{.BasePath}}",
    "paths": {
        "/api/v1/apps": {
            "get": {
                "security": [
                    {
                        "BearerAuth": []
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "type": "array",
                            "items": {
                                "$ref": "#/definitions/types.App"
                            }
                        }
                    }
                }
            },
            "post": {
                "security": [
                    {
                        "BearerAuth": []
                    }
                ],
                "parameters": [
                    {
                        "description": "Request body with app configuration.",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/types.App"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/types.App"
                        }
                    }
                }
            }
        },
        "/api/v1/apps/github/{id}": {
            "put": {
                "security": [
                    {
                        "BearerAuth": []
                    }
                ],
                "parameters": [
                    {
                        "description": "Request body with app configuration.",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/types.App"
                        }
                    },
                    {
                        "type": "string",
                        "description": "Tool ID",
                        "name": "id",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/types.App"
                        }
                    }
                }
            }
        },
        "/api/v1/apps/{id}": {
            "get": {
                "security": [
                    {
                        "BearerAuth": []
                    }
                ],
                "parameters": [
                    {
                        "type": "string",
                        "description": "App ID",
                        "name": "id",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/types.App"
                        }
                    }
                }
            },
            "put": {
                "security": [
                    {
                        "BearerAuth": []
                    }
                ],
                "parameters": [
                    {
                        "description": "Request body with app configuration.",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/types.App"
                        }
                    },
                    {
                        "type": "string",
                        "description": "Tool ID",
                        "name": "id",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/types.App"
                        }
                    }
                }
            },
            "delete": {
                "security": [
                    {
                        "BearerAuth": []
                    }
                ],
                "parameters": [
                    {
                        "type": "string",
                        "description": "App ID",
                        "name": "id",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    }
                }
            }
        },
        "/api/v1/apps/{id}/gptscript": {
            "post": {
                "security": [
                    {
                        "BearerAuth": []
                    }
                ],
                "parameters": [
                    {
                        "description": "Request body with script configuration.",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/types.GptScriptRequest"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/types.GptScriptResponse"
                        }
                    }
                }
            }
        },
        "/api/v1/llm_calls": {
            "get": {
                "security": [
                    {
                        "BearerAuth": []
                    }
                ],
                "description": "List LLM calls with pagination and optional session filtering",
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "llm_calls"
                ],
                "summary": "List LLM calls",
                "parameters": [
                    {
                        "type": "integer",
                        "description": "Page number",
                        "name": "page",
                        "in": "query"
                    },
                    {
                        "type": "integer",
                        "description": "Page size",
                        "name": "pageSize",
                        "in": "query"
                    },
                    {
                        "type": "string",
                        "description": "Filter by session ID",
                        "name": "sessionFilter",
                        "in": "query"
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/types.PaginatedLLMCalls"
                        }
                    }
                }
            }
        },
        "/api/v1/secrets": {
            "get": {
                "security": [
                    {
                        "BearerAuth": []
                    }
                ],
                "description": "List secrets for the user.",
                "tags": [
                    "secrets"
                ],
                "summary": "List secrets",
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "type": "array",
                            "items": {
                                "$ref": "#/definitions/types.Secret"
                            }
                        }
                    }
                }
            },
            "post": {
                "security": [
                    {
                        "BearerAuth": []
                    }
                ],
                "description": "Create a new secret for the user.",
                "tags": [
                    "secrets"
                ],
                "summary": "Create new secret",
                "parameters": [
                    {
                        "description": "Request body with secret configuration.",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/types.Secret"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/types.Secret"
                        }
                    }
                }
            }
        },
        "/api/v1/secrets/{id}": {
            "put": {
                "security": [
                    {
                        "BearerAuth": []
                    }
                ],
                "description": "Update an existing secret for the user.",
                "tags": [
                    "secrets"
                ],
                "summary": "Update an existing secret",
                "parameters": [
                    {
                        "description": "Request body with updated secret configuration.",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/types.Secret"
                        }
                    },
                    {
                        "type": "string",
                        "description": "Secret ID",
                        "name": "id",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/types.Secret"
                        }
                    }
                }
            },
            "delete": {
                "security": [
                    {
                        "BearerAuth": []
                    }
                ],
                "description": "Delete a secret for the user.",
                "tags": [
                    "secrets"
                ],
                "summary": "Delete a secret",
                "parameters": [
                    {
                        "type": "string",
                        "description": "Secret ID",
                        "name": "id",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/types.Secret"
                        }
                    }
                }
            }
        },
        "/api/v1/sessions/chat": {
            "post": {
                "security": [
                    {
                        "BearerAuth": []
                    }
                ],
                "parameters": [
                    {
                        "description": "Request body with the message and model to start chat completion.",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/types.SessionChatRequest"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/types.OpenAIResponse"
                        }
                    }
                }
            }
        },
        "/api/v1/sessions/learn": {
            "post": {
                "security": [
                    {
                        "BearerAuth": []
                    }
                ],
                "parameters": [
                    {
                        "description": "Request body with settings for the learn session.",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/types.SessionLearnRequest"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/types.Session"
                        }
                    }
                }
            }
        },
        "/v1/chat/completions": {
            "post": {
                "security": [
                    {
                        "BearerAuth": []
                    }
                ],
                "description": "Creates a model response for the given chat conversation.",
                "tags": [
                    "chat"
                ],
                "summary": "Stream responses for chat",
                "parameters": [
                    {
                        "description": "Request body with options for conversational AI.",
                        "name": "request",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/github_com_sashabaranov_go-openai.ChatCompletionRequest"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/github_com_sashabaranov_go-openai.ChatCompletionResponse"
                        }
                    }
                }
            }
        }
    },
    "definitions": {
        "github_com_helixml_helix_api_pkg_types.Tool": {
            "type": "object",
            "properties": {
                "config": {
                    "$ref": "#/definitions/types.ToolConfig"
                },
                "created": {
                    "type": "string"
                },
                "description": {
                    "type": "string"
                },
                "global": {
                    "type": "boolean"
                },
                "id": {
                    "type": "string"
                },
                "name": {
                    "type": "string"
                },
                "owner": {
                    "description": "uuid of owner entity",
                    "type": "string"
                },
                "owner_type": {
                    "description": "e.g. user, system, org",
                    "allOf": [
                        {
                            "$ref": "#/definitions/types.OwnerType"
                        }
                    ]
                },
                "tool_type": {
                    "$ref": "#/definitions/github_com_helixml_helix_api_pkg_types.ToolType"
                },
                "updated": {
                    "type": "string"
                }
            }
        },
        "github_com_helixml_helix_api_pkg_types.ToolType": {
            "type": "string",
            "enum": [
                "api",
                "gptscript",
                "zapier"
            ],
            "x-enum-varnames": [
                "ToolTypeAPI",
                "ToolTypeGPTScript",
                "ToolTypeZapier"
            ]
        },
        "github_com_helixml_helix_api_pkg_types.Usage": {
            "type": "object",
            "properties": {
                "completion_tokens": {
                    "type": "integer"
                },
                "duration_ms": {
                    "description": "How long the request took in milliseconds",
                    "type": "integer"
                },
                "prompt_tokens": {
                    "type": "integer"
                },
                "total_tokens": {
                    "type": "integer"
                }
            }
        },
        "github_com_sashabaranov_go-openai.ChatCompletionChoice": {
            "type": "object",
            "properties": {
                "finish_reason": {
                    "description": "FinishReason\nstop: API returned complete message,\nor a message terminated by one of the stop sequences provided via the stop parameter\nlength: Incomplete model output due to max_tokens parameter or token limit\nfunction_call: The model decided to call a function\ncontent_filter: Omitted content due to a flag from our content filters\nnull: API response still in progress or incomplete",
                    "allOf": [
                        {
                            "$ref": "#/definitions/github_com_sashabaranov_go-openai.FinishReason"
                        }
                    ]
                },
                "index": {
                    "type": "integer"
                },
                "logprobs": {
                    "$ref": "#/definitions/github_com_sashabaranov_go-openai.LogProbs"
                },
                "message": {
                    "$ref": "#/definitions/github_com_sashabaranov_go-openai.ChatCompletionMessage"
                }
            }
        },
        "github_com_sashabaranov_go-openai.ChatCompletionMessage": {
            "type": "object",
            "properties": {
                "content": {
                    "type": "string"
                },
                "function_call": {
                    "$ref": "#/definitions/github_com_sashabaranov_go-openai.FunctionCall"
                },
                "multiContent": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/github_com_sashabaranov_go-openai.ChatMessagePart"
                    }
                },
                "name": {
                    "description": "This property isn't in the official documentation, but it's in\nthe documentation for the official library for python:\n- https://github.com/openai/openai-python/blob/main/chatml.md\n- https://github.com/openai/openai-cookbook/blob/main/examples/How_to_count_tokens_with_tiktoken.ipynb",
                    "type": "string"
                },
                "refusal": {
                    "type": "string"
                },
                "role": {
                    "type": "string"
                },
                "tool_call_id": {
                    "description": "For Role=tool prompts this should be set to the ID given in the assistant's prior request to call a tool.",
                    "type": "string"
                },
                "tool_calls": {
                    "description": "For Role=assistant prompts this may be set to the tool calls generated by the model, such as function calls.",
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/github_com_sashabaranov_go-openai.ToolCall"
                    }
                }
            }
        },
        "github_com_sashabaranov_go-openai.ChatCompletionRequest": {
            "type": "object",
            "properties": {
                "frequency_penalty": {
                    "type": "number"
                },
                "function_call": {
                    "description": "Deprecated: use ToolChoice instead."
                },
                "functions": {
                    "description": "Deprecated: use Tools instead.",
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/github_com_sashabaranov_go-openai.FunctionDefinition"
                    }
                },
                "logit_bias": {
                    "description": "LogitBias is must be a token id string (specified by their token ID in the tokenizer), not a word string.\nincorrect: ` + "`" + `\"logit_bias\":{\"You\": 6}` + "`" + `, correct: ` + "`" + `\"logit_bias\":{\"1639\": 6}` + "`" + `\nrefs: https://platform.openai.com/docs/api-reference/chat/create#chat/create-logit_bias",
                    "type": "object",
                    "additionalProperties": {
                        "type": "integer"
                    }
                },
                "logprobs": {
                    "description": "LogProbs indicates whether to return log probabilities of the output tokens or not.\nIf true, returns the log probabilities of each output token returned in the content of message.\nThis option is currently not available on the gpt-4-vision-preview model.",
                    "type": "boolean"
                },
                "max_completion_tokens": {
                    "description": "MaxCompletionsTokens An upper bound for the number of tokens that can be generated for a completion,\nincluding visible output tokens and reasoning tokens https://platform.openai.com/docs/guides/reasoning",
                    "type": "integer"
                },
                "max_tokens": {
                    "description": "MaxTokens The maximum number of tokens that can be generated in the chat completion.\nThis value can be used to control costs for text generated via API.\nThis value is now deprecated in favor of max_completion_tokens, and is not compatible with o1 series models.\nrefs: https://platform.openai.com/docs/api-reference/chat/create#chat-create-max_tokens",
                    "type": "integer"
                },
                "messages": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/github_com_sashabaranov_go-openai.ChatCompletionMessage"
                    }
                },
                "model": {
                    "type": "string"
                },
                "n": {
                    "type": "integer"
                },
                "parallel_tool_calls": {
                    "description": "Disable the default behavior of parallel tool calls by setting it: false."
                },
                "presence_penalty": {
                    "type": "number"
                },
                "response_format": {
                    "$ref": "#/definitions/github_com_sashabaranov_go-openai.ChatCompletionResponseFormat"
                },
                "seed": {
                    "type": "integer"
                },
                "stop": {
                    "type": "array",
                    "items": {
                        "type": "string"
                    }
                },
                "stream": {
                    "type": "boolean"
                },
                "stream_options": {
                    "description": "Options for streaming response. Only set this when you set stream: true.",
                    "allOf": [
                        {
                            "$ref": "#/definitions/github_com_sashabaranov_go-openai.StreamOptions"
                        }
                    ]
                },
                "temperature": {
                    "type": "number"
                },
                "tool_choice": {
                    "description": "This can be either a string or an ToolChoice object."
                },
                "tools": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/github_com_sashabaranov_go-openai.Tool"
                    }
                },
                "top_logprobs": {
                    "description": "TopLogProbs is an integer between 0 and 5 specifying the number of most likely tokens to return at each\ntoken position, each with an associated log probability.\nlogprobs must be set to true if this parameter is used.",
                    "type": "integer"
                },
                "top_p": {
                    "type": "number"
                },
                "user": {
                    "type": "string"
                }
            }
        },
        "github_com_sashabaranov_go-openai.ChatCompletionResponse": {
            "type": "object",
            "properties": {
                "choices": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/github_com_sashabaranov_go-openai.ChatCompletionChoice"
                    }
                },
                "created": {
                    "type": "integer"
                },
                "id": {
                    "type": "string"
                },
                "model": {
                    "type": "string"
                },
                "object": {
                    "type": "string"
                },
                "system_fingerprint": {
                    "type": "string"
                },
                "usage": {
                    "$ref": "#/definitions/github_com_sashabaranov_go-openai.Usage"
                }
            }
        },
        "github_com_sashabaranov_go-openai.ChatCompletionResponseFormat": {
            "type": "object",
            "properties": {
                "json_schema": {
                    "$ref": "#/definitions/openai.ChatCompletionResponseFormatJSONSchema"
                },
                "type": {
                    "$ref": "#/definitions/github_com_sashabaranov_go-openai.ChatCompletionResponseFormatType"
                }
            }
        },
        "github_com_sashabaranov_go-openai.ChatCompletionResponseFormatType": {
            "type": "string",
            "enum": [
                "json_object",
                "json_schema",
                "text"
            ],
            "x-enum-varnames": [
                "ChatCompletionResponseFormatTypeJSONObject",
                "ChatCompletionResponseFormatTypeJSONSchema",
                "ChatCompletionResponseFormatTypeText"
            ]
        },
        "github_com_sashabaranov_go-openai.ChatMessageImageURL": {
            "type": "object",
            "properties": {
                "detail": {
                    "$ref": "#/definitions/github_com_sashabaranov_go-openai.ImageURLDetail"
                },
                "url": {
                    "type": "string"
                }
            }
        },
        "github_com_sashabaranov_go-openai.ChatMessagePart": {
            "type": "object",
            "properties": {
                "image_url": {
                    "$ref": "#/definitions/github_com_sashabaranov_go-openai.ChatMessageImageURL"
                },
                "text": {
                    "type": "string"
                },
                "type": {
                    "$ref": "#/definitions/github_com_sashabaranov_go-openai.ChatMessagePartType"
                }
            }
        },
        "github_com_sashabaranov_go-openai.ChatMessagePartType": {
            "type": "string",
            "enum": [
                "text",
                "image_url"
            ],
            "x-enum-varnames": [
                "ChatMessagePartTypeText",
                "ChatMessagePartTypeImageURL"
            ]
        },
        "github_com_sashabaranov_go-openai.FinishReason": {
            "type": "string",
            "enum": [
                "stop",
                "length",
                "function_call",
                "tool_calls",
                "content_filter",
                "null"
            ],
            "x-enum-varnames": [
                "FinishReasonStop",
                "FinishReasonLength",
                "FinishReasonFunctionCall",
                "FinishReasonToolCalls",
                "FinishReasonContentFilter",
                "FinishReasonNull"
            ]
        },
        "github_com_sashabaranov_go-openai.FunctionCall": {
            "type": "object",
            "properties": {
                "arguments": {
                    "description": "call function with arguments in JSON format",
                    "type": "string"
                },
                "name": {
                    "type": "string"
                }
            }
        },
        "github_com_sashabaranov_go-openai.FunctionDefinition": {
            "type": "object",
            "properties": {
                "description": {
                    "type": "string"
                },
                "name": {
                    "type": "string"
                },
                "parameters": {
                    "description": "Parameters is an object describing the function.\nYou can pass json.RawMessage to describe the schema,\nor you can pass in a struct which serializes to the proper JSON schema.\nThe jsonschema package is provided for convenience, but you should\nconsider another specialized library if you require more complex schemas."
                },
                "strict": {
                    "type": "boolean"
                }
            }
        },
        "github_com_sashabaranov_go-openai.ImageURLDetail": {
            "type": "string",
            "enum": [
                "high",
                "low",
                "auto"
            ],
            "x-enum-varnames": [
                "ImageURLDetailHigh",
                "ImageURLDetailLow",
                "ImageURLDetailAuto"
            ]
        },
        "github_com_sashabaranov_go-openai.LogProb": {
            "type": "object",
            "properties": {
                "bytes": {
                    "description": "Omitting the field if it is null",
                    "type": "array",
                    "items": {
                        "type": "integer"
                    }
                },
                "logprob": {
                    "type": "number"
                },
                "token": {
                    "type": "string"
                },
                "top_logprobs": {
                    "description": "TopLogProbs is a list of the most likely tokens and their log probability, at this token position.\nIn rare cases, there may be fewer than the number of requested top_logprobs returned.",
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/github_com_sashabaranov_go-openai.TopLogProbs"
                    }
                }
            }
        },
        "github_com_sashabaranov_go-openai.LogProbs": {
            "type": "object",
            "properties": {
                "content": {
                    "description": "Content is a list of message content tokens with log probability information.",
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/github_com_sashabaranov_go-openai.LogProb"
                    }
                }
            }
        },
        "github_com_sashabaranov_go-openai.StreamOptions": {
            "type": "object",
            "properties": {
                "include_usage": {
                    "description": "If set, an additional chunk will be streamed before the data: [DONE] message.\nThe usage field on this chunk shows the token usage statistics for the entire request,\nand the choices field will always be an empty array.\nAll other chunks will also include a usage field, but with a null value.",
                    "type": "boolean"
                }
            }
        },
        "github_com_sashabaranov_go-openai.Tool": {
            "type": "object",
            "properties": {
                "function": {
                    "$ref": "#/definitions/github_com_sashabaranov_go-openai.FunctionDefinition"
                },
                "type": {
                    "$ref": "#/definitions/github_com_sashabaranov_go-openai.ToolType"
                }
            }
        },
        "github_com_sashabaranov_go-openai.ToolCall": {
            "type": "object",
            "properties": {
                "function": {
                    "$ref": "#/definitions/github_com_sashabaranov_go-openai.FunctionCall"
                },
                "id": {
                    "type": "string"
                },
                "index": {
                    "description": "Index is not nil only in chat completion chunk object",
                    "type": "integer"
                },
                "type": {
                    "$ref": "#/definitions/github_com_sashabaranov_go-openai.ToolType"
                }
            }
        },
        "github_com_sashabaranov_go-openai.ToolType": {
            "type": "string",
            "enum": [
                "function"
            ],
            "x-enum-varnames": [
                "ToolTypeFunction"
            ]
        },
        "github_com_sashabaranov_go-openai.TopLogProbs": {
            "type": "object",
            "properties": {
                "bytes": {
                    "type": "array",
                    "items": {
                        "type": "integer"
                    }
                },
                "logprob": {
                    "type": "number"
                },
                "token": {
                    "type": "string"
                }
            }
        },
        "github_com_sashabaranov_go-openai.Usage": {
            "type": "object",
            "properties": {
                "completion_tokens": {
                    "type": "integer"
                },
                "completion_tokens_details": {
                    "$ref": "#/definitions/openai.CompletionTokensDetails"
                },
                "prompt_tokens": {
                    "type": "integer"
                },
                "total_tokens": {
                    "type": "integer"
                }
            }
        },
        "openai.ChatCompletionResponseFormatJSONSchema": {
            "type": "object",
            "properties": {
                "description": {
                    "type": "string"
                },
                "name": {
                    "type": "string"
                },
                "schema": {},
                "strict": {
                    "type": "boolean"
                }
            }
        },
        "openai.CompletionTokensDetails": {
            "type": "object",
            "properties": {
                "reasoning_tokens": {
                    "type": "integer"
                }
            }
        },
        "types.App": {
            "type": "object",
            "properties": {
                "app_source": {
                    "$ref": "#/definitions/types.AppSource"
                },
                "config": {
                    "$ref": "#/definitions/types.AppConfig"
                },
                "created": {
                    "type": "string"
                },
                "global": {
                    "type": "boolean"
                },
                "id": {
                    "type": "string"
                },
                "owner": {
                    "description": "uuid of owner entity",
                    "type": "string"
                },
                "owner_type": {
                    "description": "e.g. user, system, org",
                    "allOf": [
                        {
                            "$ref": "#/definitions/types.OwnerType"
                        }
                    ]
                },
                "shared": {
                    "type": "boolean"
                },
                "updated": {
                    "type": "string"
                }
            }
        },
        "types.AppConfig": {
            "type": "object",
            "properties": {
                "allowed_domains": {
                    "type": "array",
                    "items": {
                        "type": "string"
                    }
                },
                "github": {
                    "$ref": "#/definitions/types.AppGithubConfig"
                },
                "helix": {
                    "$ref": "#/definitions/types.AppHelixConfig"
                },
                "secrets": {
                    "type": "object",
                    "additionalProperties": {
                        "type": "string"
                    }
                }
            }
        },
        "types.AppGithubConfig": {
            "type": "object",
            "properties": {
                "hash": {
                    "type": "string"
                },
                "key_pair": {
                    "$ref": "#/definitions/types.KeyPair"
                },
                "last_update": {
                    "$ref": "#/definitions/types.AppGithubConfigUpdate"
                },
                "repo": {
                    "type": "string"
                },
                "webhook_secret": {
                    "type": "string"
                }
            }
        },
        "types.AppGithubConfigUpdate": {
            "type": "object",
            "properties": {
                "error": {
                    "type": "string"
                },
                "hash": {
                    "type": "string"
                },
                "updated": {
                    "type": "string"
                }
            }
        },
        "types.AppHelixConfig": {
            "type": "object",
            "properties": {
                "assistants": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/types.AssistantConfig"
                    }
                },
                "avatar": {
                    "type": "string"
                },
                "description": {
                    "type": "string"
                },
                "external_url": {
                    "type": "string"
                },
                "image": {
                    "type": "string"
                },
                "name": {
                    "type": "string"
                },
                "triggers": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/types.Trigger"
                    }
                }
            }
        },
        "types.AppSource": {
            "type": "string",
            "enum": [
                "helix",
                "github"
            ],
            "x-enum-varnames": [
                "AppSourceHelix",
                "AppSourceGithub"
            ]
        },
        "types.AssistantAPI": {
            "type": "object",
            "properties": {
                "description": {
                    "type": "string"
                },
                "headers": {
                    "type": "object",
                    "additionalProperties": {
                        "type": "string"
                    }
                },
                "name": {
                    "type": "string"
                },
                "query": {
                    "type": "object",
                    "additionalProperties": {
                        "type": "string"
                    }
                },
                "request_prep_template": {
                    "description": "Template for request preparation, leave empty for default",
                    "type": "string"
                },
                "response_error_template": {
                    "description": "Template for error response, leave empty for default",
                    "type": "string"
                },
                "response_success_template": {
                    "description": "Template for successful response, leave empty for default",
                    "type": "string"
                },
                "schema": {
                    "type": "string"
                },
                "url": {
                    "type": "string"
                }
            }
        },
        "types.AssistantConfig": {
            "type": "object",
            "properties": {
                "apis": {
                    "description": "the list of api tools this assistant will use",
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/types.AssistantAPI"
                    }
                },
                "avatar": {
                    "type": "string"
                },
                "description": {
                    "type": "string"
                },
                "gptscripts": {
                    "description": "the list of gpt scripts this assistant will use",
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/types.AssistantGPTScript"
                    }
                },
                "id": {
                    "type": "string"
                },
                "image": {
                    "type": "string"
                },
                "is_actionable_template": {
                    "description": "Template for determining if the request is actionable or informative",
                    "type": "string"
                },
                "knowledge": {
                    "description": "Knowledge available to the assistant",
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/types.AssistantKnowledge"
                    }
                },
                "lora_id": {
                    "description": "the data entity ID that we have created for the lora fine tune",
                    "type": "string"
                },
                "model": {
                    "type": "string"
                },
                "name": {
                    "type": "string"
                },
                "provider": {
                    "description": "openai, togetherai, helix, etc.",
                    "allOf": [
                        {
                            "$ref": "#/definitions/types.Provider"
                        }
                    ]
                },
                "rag_source_id": {
                    "description": "the data entity ID that we have created as the RAG source",
                    "type": "string"
                },
                "system_prompt": {
                    "type": "string"
                },
                "tools": {
                    "description": "these are populated from the APIs and GPTScripts on create and update\nwe include tools in the JSON that we send to the browser\nbut we don't include it in the yaml which feeds this struct because\nwe populate the tools array from the APIs and GPTScripts arrays\nso - Tools is readonly - hence only JSON for the frontend to see",
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/github_com_helixml_helix_api_pkg_types.Tool"
                    }
                },
                "type": {
                    "description": "so we can have fine tuned image assistants or system prompt augmentedimage inference\ndefaults to text",
                    "allOf": [
                        {
                            "$ref": "#/definitions/types.SessionType"
                        }
                    ]
                },
                "zapier": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/types.AssistantZapier"
                    }
                }
            }
        },
        "types.AssistantGPTScript": {
            "type": "object",
            "properties": {
                "content": {
                    "type": "string"
                },
                "description": {
                    "description": "When to use this tool (required)",
                    "type": "string"
                },
                "file": {
                    "type": "string"
                },
                "name": {
                    "type": "string"
                }
            }
        },
        "types.AssistantKnowledge": {
            "type": "object",
            "properties": {
                "description": {
                    "description": "Description of the knowledge, will be used in the prompt\nto explain the knowledge to the assistant",
                    "type": "string"
                },
                "name": {
                    "description": "Name of the knowledge, will be unique within the Helix app",
                    "type": "string"
                },
                "rag_settings": {
                    "description": "RAGSettings defines the settings for the RAG system, how\nchunking is configured and where the index/query service is\nhosted.",
                    "allOf": [
                        {
                            "$ref": "#/definitions/types.RAGSettings"
                        }
                    ]
                },
                "refresh_enabled": {
                    "description": "RefreshEnabled defines if the knowledge should be refreshed periodically\nor on events. For example a Google Drive knowledge can be refreshed\nevery 24 hours.",
                    "type": "boolean"
                },
                "refresh_schedule": {
                    "description": "RefreshSchedule defines the schedule for refreshing the knowledge.\nIt can be specified in cron format or as a duration for example '@every 2h'\nor 'every 5m' or '0 0 * * *' for daily at midnight.",
                    "type": "string"
                },
                "source": {
                    "description": "Source defines where the raw data is fetched from. It can be\ndirectly uploaded files, S3, GCS, Google Drive, Gmail, etc.",
                    "allOf": [
                        {
                            "$ref": "#/definitions/types.KnowledgeSource"
                        }
                    ]
                }
            }
        },
        "types.AssistantZapier": {
            "type": "object",
            "properties": {
                "api_key": {
                    "type": "string"
                },
                "description": {
                    "type": "string"
                },
                "max_iterations": {
                    "type": "integer"
                },
                "model": {
                    "type": "string"
                },
                "name": {
                    "type": "string"
                }
            }
        },
        "types.Choice": {
            "type": "object",
            "properties": {
                "delta": {
                    "$ref": "#/definitions/types.OpenAIMessage"
                },
                "finish_reason": {
                    "type": "string"
                },
                "index": {
                    "type": "integer"
                },
                "message": {
                    "$ref": "#/definitions/types.OpenAIMessage"
                },
                "text": {
                    "type": "string"
                }
            }
        },
        "types.CreatorType": {
            "type": "string",
            "enum": [
                "system",
                "assistant",
                "user",
                "tool"
            ],
            "x-enum-varnames": [
                "CreatorTypeSystem",
                "CreatorTypeAssistant",
                "CreatorTypeUser",
                "CreatorTypeTool"
            ]
        },
        "types.CronTrigger": {
            "type": "object",
            "properties": {
                "input": {
                    "type": "string"
                },
                "schedule": {
                    "type": "string"
                }
            }
        },
        "types.DataPrepChunk": {
            "type": "object",
            "properties": {
                "error": {
                    "type": "string"
                },
                "index": {
                    "type": "integer"
                },
                "prompt_name": {
                    "type": "string"
                },
                "question_count": {
                    "type": "integer"
                }
            }
        },
        "types.DiscordTrigger": {
            "type": "object",
            "properties": {
                "server_name": {
                    "type": "string"
                }
            }
        },
        "types.Firecrawl": {
            "type": "object",
            "properties": {
                "api_key": {
                    "type": "string"
                },
                "api_url": {
                    "type": "string"
                }
            }
        },
        "types.GptScriptRequest": {
            "type": "object",
            "properties": {
                "file_path": {
                    "type": "string"
                },
                "input": {
                    "type": "string"
                }
            }
        },
        "types.GptScriptResponse": {
            "type": "object",
            "properties": {
                "error": {
                    "type": "string"
                },
                "output": {
                    "type": "string"
                },
                "retries": {
                    "type": "integer"
                }
            }
        },
        "types.Interaction": {
            "type": "object",
            "properties": {
                "completed": {
                    "type": "string"
                },
                "created": {
                    "type": "string"
                },
                "creator": {
                    "description": "e.g. User",
                    "allOf": [
                        {
                            "$ref": "#/definitions/types.CreatorType"
                        }
                    ]
                },
                "data_prep_chunks": {
                    "type": "object",
                    "additionalProperties": {
                        "type": "array",
                        "items": {
                            "$ref": "#/definitions/types.DataPrepChunk"
                        }
                    }
                },
                "data_prep_limit": {
                    "description": "If true, the data prep is limited to a certain number of chunks due to quotas",
                    "type": "integer"
                },
                "data_prep_limited": {
                    "description": "If true, the data prep is limited to a certain number of chunks due to quotas",
                    "type": "boolean"
                },
                "data_prep_stage": {
                    "$ref": "#/definitions/types.TextDataPrepStage"
                },
                "data_prep_total_chunks": {
                    "type": "integer"
                },
                "display_message": {
                    "description": "if this is defined, the UI will always display it instead of the message (so we can augment the internal prompt with RAG context)",
                    "type": "string"
                },
                "error": {
                    "type": "string"
                },
                "files": {
                    "description": "list of filepath paths",
                    "type": "array",
                    "items": {
                        "type": "string"
                    }
                },
                "finished": {
                    "description": "if true, the message has finished being written to, and is ready for a response (e.g. from the other participant)",
                    "type": "boolean"
                },
                "id": {
                    "type": "string"
                },
                "lora_dir": {
                    "description": "we hoist this from files so a single interaction knows that it \"Created a finetune file\"",
                    "type": "string"
                },
                "message": {
                    "description": "e.g. Prove pythagoras",
                    "type": "string"
                },
                "metadata": {
                    "description": "different modes and models can put values here - for example, the image fine tuning will keep labels here to display in the frontend",
                    "type": "object",
                    "additionalProperties": {
                        "type": "string"
                    }
                },
                "mode": {
                    "description": "this let's us know if this interaction is part of the fine tuning process\nor if it's a chat interaction that the user is using to interact with the model\nonce it's been fine-tuned\nfor fine-tune models, we can filter out inference interactions\nto get down to what actually matters",
                    "allOf": [
                        {
                            "$ref": "#/definitions/types.SessionMode"
                        }
                    ]
                },
                "progress": {
                    "description": "e.g. 0-100",
                    "type": "integer"
                },
                "rag_results": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/types.SessionRAGResult"
                    }
                },
                "response_format": {
                    "description": "e.g. json",
                    "allOf": [
                        {
                            "$ref": "#/definitions/types.ResponseFormat"
                        }
                    ]
                },
                "runner": {
                    "description": "the ID of the runner that processed this interaction",
                    "type": "string"
                },
                "scheduled": {
                    "type": "string"
                },
                "state": {
                    "$ref": "#/definitions/types.InteractionState"
                },
                "status": {
                    "type": "string"
                },
                "tool_call_id": {
                    "description": "For Role=tool prompts this should be set to the ID given in the assistant's prior request to call a tool.",
                    "type": "string"
                },
                "tool_calls": {
                    "description": "For Role=assistant prompts this may be set to the tool calls generated by the model, such as function calls.",
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/github_com_sashabaranov_go-openai.ToolCall"
                    }
                },
                "tool_choice": {
                    "description": "This can be either a string or an ToolChoice object."
                },
                "tools": {
                    "description": "Model function calling, not to be mistaken with Helix tools",
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/github_com_sashabaranov_go-openai.Tool"
                    }
                },
                "updated": {
                    "type": "string"
                },
                "usage": {
                    "$ref": "#/definitions/github_com_helixml_helix_api_pkg_types.Usage"
                }
            }
        },
        "types.InteractionState": {
            "type": "string",
            "enum": [
                "",
                "waiting",
                "editing",
                "complete",
                "error"
            ],
            "x-enum-varnames": [
                "InteractionStateNone",
                "InteractionStateWaiting",
                "InteractionStateEditing",
                "InteractionStateComplete",
                "InteractionStateError"
            ]
        },
        "types.Item": {
            "type": "object",
            "properties": {
                "b64_json": {
                    "type": "string"
                },
                "embedding": {
                    "type": "array",
                    "items": {
                        "type": "number"
                    }
                },
                "index": {
                    "type": "integer"
                },
                "object": {
                    "type": "string"
                },
                "url": {
                    "description": "Images",
                    "type": "string"
                }
            }
        },
        "types.KeyPair": {
            "type": "object",
            "properties": {
                "privateKey": {
                    "type": "string"
                },
                "publicKey": {
                    "type": "string"
                },
                "type": {
                    "type": "string"
                }
            }
        },
        "types.KnowledgeSource": {
            "type": "object",
            "properties": {
                "filestore": {
                    "$ref": "#/definitions/types.KnowledgeSourceHelixFilestore"
                },
                "gcs": {
                    "$ref": "#/definitions/types.KnowledgeSourceGCS"
                },
                "s3": {
                    "$ref": "#/definitions/types.KnowledgeSourceS3"
                },
                "text": {
                    "type": "string"
                },
                "web": {
                    "$ref": "#/definitions/types.KnowledgeSourceWeb"
                }
            }
        },
        "types.KnowledgeSourceGCS": {
            "type": "object",
            "properties": {
                "bucket": {
                    "type": "string"
                },
                "path": {
                    "type": "string"
                }
            }
        },
        "types.KnowledgeSourceHelixFilestore": {
            "type": "object",
            "properties": {
                "path": {
                    "type": "string"
                }
            }
        },
        "types.KnowledgeSourceS3": {
            "type": "object",
            "properties": {
                "bucket": {
                    "type": "string"
                },
                "path": {
                    "type": "string"
                }
            }
        },
        "types.KnowledgeSourceWeb": {
            "type": "object",
            "properties": {
                "auth": {
                    "$ref": "#/definitions/types.KnowledgeSourceWebAuth"
                },
                "crawler": {
                    "description": "Additional options for the crawler",
                    "allOf": [
                        {
                            "$ref": "#/definitions/types.WebsiteCrawler"
                        }
                    ]
                },
                "excludes": {
                    "type": "array",
                    "items": {
                        "type": "string"
                    }
                },
                "urls": {
                    "type": "array",
                    "items": {
                        "type": "string"
                    }
                }
            }
        },
        "types.KnowledgeSourceWebAuth": {
            "type": "object",
            "properties": {
                "password": {
                    "type": "string"
                },
                "username": {
                    "type": "string"
                }
            }
        },
        "types.LLMCall": {
            "type": "object",
            "properties": {
                "completionTokens": {
                    "type": "integer"
                },
                "created": {
                    "type": "string"
                },
                "duration_ms": {
                    "type": "integer"
                },
                "id": {
                    "type": "string"
                },
                "interaction_id": {
                    "type": "string"
                },
                "model": {
                    "type": "string"
                },
                "original_request": {
                    "type": "array",
                    "items": {
                        "type": "integer"
                    }
                },
                "promptTokens": {
                    "type": "integer"
                },
                "provider": {
                    "type": "string"
                },
                "request": {
                    "type": "array",
                    "items": {
                        "type": "integer"
                    }
                },
                "response": {
                    "type": "array",
                    "items": {
                        "type": "integer"
                    }
                },
                "session_id": {
                    "type": "string"
                },
                "step": {
                    "$ref": "#/definitions/types.LLMCallStep"
                },
                "totalTokens": {
                    "type": "integer"
                },
                "updated": {
                    "type": "string"
                },
                "user_id": {
                    "type": "string"
                }
            }
        },
        "types.LLMCallStep": {
            "type": "string",
            "enum": [
                "default",
                "is_actionable",
                "prepare_api_request",
                "interpret_response",
                "generate_title"
            ],
            "x-enum-varnames": [
                "LLMCallStepDefault",
                "LLMCallStepIsActionable",
                "LLMCallStepPrepareAPIRequest",
                "LLMCallStepInterpretResponse",
                "LLMCallStepGenerateTitle"
            ]
        },
        "types.Message": {
            "type": "object",
            "properties": {
                "content": {
                    "$ref": "#/definitions/types.MessageContent"
                },
                "created_at": {
                    "type": "string"
                },
                "id": {
                    "description": "Interaction ID",
                    "type": "string"
                },
                "role": {
                    "$ref": "#/definitions/types.CreatorType"
                },
                "state": {
                    "$ref": "#/definitions/types.InteractionState"
                },
                "updated_at": {
                    "type": "string"
                }
            }
        },
        "types.MessageContent": {
            "type": "object",
            "properties": {
                "content_type": {
                    "description": "text, image, multimodal_text",
                    "allOf": [
                        {
                            "$ref": "#/definitions/types.MessageContentType"
                        }
                    ]
                },
                "parts": {
                    "description": "Parts is a list of strings or objects. For example for text, it's a list of strings, for\nmulti-modal it can be an object:\n\"parts\": [\n\t\t{\n\t\t\t\t\"content_type\": \"image_asset_pointer\",\n\t\t\t\t\"asset_pointer\": \"file-service://file-28uHss2LgJ8HUEEVAnXa70Tg\",\n\t\t\t\t\"size_bytes\": 185427,\n\t\t\t\t\"width\": 2048,\n\t\t\t\t\"height\": 1020,\n\t\t\t\t\"fovea\": null,\n\t\t\t\t\"metadata\": null\n\t\t},\n\t\t\"what is in the image?\"\n]",
                    "type": "array",
                    "items": {}
                }
            }
        },
        "types.MessageContentType": {
            "type": "string",
            "enum": [
                "text"
            ],
            "x-enum-varnames": [
                "MessageContentTypeText"
            ]
        },
        "types.OpenAIMessage": {
            "type": "object",
            "properties": {
                "content": {
                    "description": "The message content",
                    "type": "string"
                },
                "role": {
                    "description": "The message role",
                    "type": "string"
                },
                "tool_call_id": {
                    "description": "For Role=tool prompts this should be set to the ID given in the assistant's prior request to call a tool.",
                    "type": "string"
                },
                "tool_calls": {
                    "description": "For Role=assistant prompts this may be set to the tool calls generated by the model, such as function calls.",
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/github_com_sashabaranov_go-openai.ToolCall"
                    }
                }
            }
        },
        "types.OpenAIResponse": {
            "type": "object",
            "properties": {
                "choices": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/types.Choice"
                    }
                },
                "created": {
                    "type": "integer"
                },
                "data": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/types.Item"
                    }
                },
                "id": {
                    "type": "string"
                },
                "model": {
                    "type": "string"
                },
                "object": {
                    "type": "string"
                },
                "usage": {
                    "$ref": "#/definitions/types.OpenAIUsage"
                }
            }
        },
        "types.OpenAIUsage": {
            "type": "object",
            "properties": {
                "completion_tokens": {
                    "type": "integer"
                },
                "prompt_tokens": {
                    "type": "integer"
                },
                "total_tokens": {
                    "type": "integer"
                }
            }
        },
        "types.OwnerType": {
            "type": "string",
            "enum": [
                "user",
                "system"
            ],
            "x-enum-varnames": [
                "OwnerTypeUser",
                "OwnerTypeSystem"
            ]
        },
        "types.PaginatedLLMCalls": {
            "type": "object",
            "properties": {
                "calls": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/types.LLMCall"
                    }
                },
                "page": {
                    "type": "integer"
                },
                "pageSize": {
                    "type": "integer"
                },
                "totalCount": {
                    "type": "integer"
                },
                "totalPages": {
                    "type": "integer"
                }
            }
        },
        "types.Provider": {
            "type": "string",
            "enum": [
                "openai",
                "togetherai",
                "helix"
            ],
            "x-enum-varnames": [
                "ProviderOpenAI",
                "ProviderTogetherAI",
                "ProviderHelix"
            ]
        },
        "types.RAGSettings": {
            "type": "object",
            "properties": {
                "chunk_overflow": {
                    "description": "the amount of overlap between chunks - will default to 32 bytes",
                    "type": "integer"
                },
                "chunk_size": {
                    "description": "the size of each text chunk - will default to 2000 bytes",
                    "type": "integer"
                },
                "delete_url": {
                    "description": "the URL of the delete endpoint (defaults to Helix RAG_DELETE_URL env var)",
                    "type": "string"
                },
                "disable_chunking": {
                    "description": "if true, we will not chunk the text and send the entire file to the RAG indexing endpoint",
                    "type": "boolean"
                },
                "disable_downloading": {
                    "description": "if true, we will not download the file and send the URL to the RAG indexing endpoint",
                    "type": "boolean"
                },
                "distance_function": {
                    "description": "this is one of l2, inner_product or cosine - will default to cosine",
                    "type": "string"
                },
                "index_url": {
                    "description": "RAG endpoint configuration if used with a custom RAG service",
                    "type": "string"
                },
                "prompt_template": {
                    "description": "the prompt template to use for the RAG query",
                    "type": "string"
                },
                "query_url": {
                    "description": "the URL of the query endpoint (defaults to Helix RAG_QUERY_URL env var)",
                    "type": "string"
                },
                "results_count": {
                    "description": "this is the max number of results to return - will default to 3",
                    "type": "integer"
                },
                "text_splitter": {
                    "description": "Markdown if empty or 'text'",
                    "allOf": [
                        {
                            "$ref": "#/definitions/types.TextSplitterType"
                        }
                    ]
                },
                "threshold": {
                    "description": "this is the threshold for a \"good\" answer - will default to 0.2",
                    "type": "number"
                },
                "typesense": {
                    "type": "object",
                    "properties": {
                        "api_key": {
                            "type": "string"
                        },
                        "collection": {
                            "type": "string"
                        },
                        "url": {
                            "type": "string"
                        }
                    }
                }
            }
        },
        "types.ResponseFormat": {
            "type": "object",
            "properties": {
                "schema": {
                    "$ref": "#/definitions/openai.ChatCompletionResponseFormatJSONSchema"
                },
                "type": {
                    "$ref": "#/definitions/types.ResponseFormatType"
                }
            }
        },
        "types.ResponseFormatType": {
            "type": "string",
            "enum": [
                "json_object",
                "text"
            ],
            "x-enum-varnames": [
                "ResponseFormatTypeJSONObject",
                "ResponseFormatTypeText"
            ]
        },
        "types.Secret": {
            "type": "object",
            "properties": {
                "app_id": {
                    "description": "optional, if set, the secret will be available to the specified app",
                    "type": "string"
                },
                "created": {
                    "type": "string"
                },
                "id": {
                    "type": "string"
                },
                "name": {
                    "type": "string"
                },
                "owner": {
                    "type": "string"
                },
                "ownerType": {
                    "$ref": "#/definitions/types.OwnerType"
                },
                "updated": {
                    "type": "string"
                },
                "value": {
                    "type": "array",
                    "items": {
                        "type": "integer"
                    }
                }
            }
        },
        "types.Session": {
            "type": "object",
            "properties": {
                "config": {
                    "description": "named config for backward compat",
                    "allOf": [
                        {
                            "$ref": "#/definitions/types.SessionMetadata"
                        }
                    ]
                },
                "created": {
                    "type": "string"
                },
                "id": {
                    "type": "string"
                },
                "interactions": {
                    "description": "for now we just whack the entire history of the interaction in here, json\nstyle",
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/types.Interaction"
                    }
                },
                "lora_dir": {
                    "description": "if type == finetune, we record a filestore path to e.g. lora file here\ncurrently the only place you can do inference on a finetune is within the\nsession where the finetune was generated",
                    "type": "string"
                },
                "mode": {
                    "description": "e.g. inference, finetune",
                    "allOf": [
                        {
                            "$ref": "#/definitions/types.SessionMode"
                        }
                    ]
                },
                "model_name": {
                    "description": "huggingface model name e.g. mistralai/Mistral-7B-Instruct-v0.1 or\nstabilityai/stable-diffusion-xl-base-1.0",
                    "type": "string"
                },
                "name": {
                    "description": "name that goes in the UI - ideally autogenerated by AI but for now can be\nnamed manually",
                    "type": "string"
                },
                "owner": {
                    "description": "uuid of owner entity",
                    "type": "string"
                },
                "owner_type": {
                    "description": "e.g. user, system, org",
                    "allOf": [
                        {
                            "$ref": "#/definitions/types.OwnerType"
                        }
                    ]
                },
                "parent_app": {
                    "description": "the app this session was spawned from",
                    "type": "string"
                },
                "parent_session": {
                    "type": "string"
                },
                "type": {
                    "description": "e.g. text, image",
                    "allOf": [
                        {
                            "$ref": "#/definitions/types.SessionType"
                        }
                    ]
                },
                "updated": {
                    "type": "string"
                }
            }
        },
        "types.SessionChatRequest": {
            "type": "object",
            "properties": {
                "app_id": {
                    "description": "Assign the session settings from the specified app",
                    "type": "string"
                },
                "assistant_id": {
                    "description": "Which assistant are we speaking to?",
                    "type": "string"
                },
                "lora_dir": {
                    "type": "string"
                },
                "lora_id": {
                    "description": "the fine tuned data entity we produced from this session",
                    "type": "string"
                },
                "messages": {
                    "description": "Initial messages",
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/types.Message"
                    }
                },
                "model": {
                    "description": "The model to use",
                    "type": "string"
                },
                "provider": {
                    "description": "The provider to use",
                    "allOf": [
                        {
                            "$ref": "#/definitions/types.Provider"
                        }
                    ]
                },
                "rag_source_id": {
                    "type": "string"
                },
                "session_id": {
                    "description": "If empty, we will start a new session",
                    "type": "string"
                },
                "stream": {
                    "description": "If true, we will stream the response",
                    "type": "boolean"
                },
                "system": {
                    "description": "System message, only applicable when starting a new session",
                    "type": "string"
                },
                "tools": {
                    "description": "Available tools to use in the session",
                    "type": "array",
                    "items": {
                        "type": "string"
                    }
                },
                "type": {
                    "description": "e.g. text, image",
                    "allOf": [
                        {
                            "$ref": "#/definitions/types.SessionType"
                        }
                    ]
                }
            }
        },
        "types.SessionLearnRequest": {
            "type": "object",
            "properties": {
                "data_entity_id": {
                    "description": "FINE-TUNE MODE ONLY",
                    "type": "string"
                },
                "default_rag_model": {
                    "description": "When doing RAG, allow the resulting inference session model to be specified",
                    "type": "string"
                },
                "rag_enabled": {
                    "description": "Do we want to create a RAG data entity from this session?\nYou must provide a data entity ID for the uploaded documents if yes",
                    "type": "boolean"
                },
                "rag_settings": {
                    "description": "The settings we use for the RAG source",
                    "allOf": [
                        {
                            "$ref": "#/definitions/types.RAGSettings"
                        }
                    ]
                },
                "text_finetune_enabled": {
                    "description": "Do we want to create a lora output from this session?\nYou must provide a data entity ID for the uploaded documents if yes",
                    "type": "boolean"
                },
                "type": {
                    "description": "e.g. text, image",
                    "allOf": [
                        {
                            "$ref": "#/definitions/types.SessionType"
                        }
                    ]
                }
            }
        },
        "types.SessionMetadata": {
            "type": "object",
            "properties": {
                "active_tools": {
                    "type": "array",
                    "items": {
                        "type": "string"
                    }
                },
                "app_query_params": {
                    "description": "Passing through user defined app params",
                    "type": "object",
                    "additionalProperties": {
                        "type": "string"
                    }
                },
                "assistant_id": {
                    "description": "which assistant are we talking to?",
                    "type": "string"
                },
                "avatar": {
                    "type": "string"
                },
                "document_group_id": {
                    "type": "string"
                },
                "document_ids": {
                    "type": "object",
                    "additionalProperties": {
                        "type": "string"
                    }
                },
                "eval_automatic_reason": {
                    "type": "string"
                },
                "eval_automatic_score": {
                    "type": "string"
                },
                "eval_manual_reason": {
                    "type": "string"
                },
                "eval_manual_score": {
                    "type": "string"
                },
                "eval_original_user_prompts": {
                    "type": "array",
                    "items": {
                        "type": "string"
                    }
                },
                "eval_run_id": {
                    "description": "Evals are cool. Scores are strings of floats so we can distinguish \"\"\n(not rated) from \"0.0\"",
                    "type": "string"
                },
                "eval_user_reason": {
                    "type": "string"
                },
                "eval_user_score": {
                    "type": "string"
                },
                "finetune_data_entity_id": {
                    "description": "the fine tuned data entity we produced from this session",
                    "type": "string"
                },
                "helix_version": {
                    "type": "string"
                },
                "manually_review_questions": {
                    "type": "boolean"
                },
                "origin": {
                    "$ref": "#/definitions/types.SessionOrigin"
                },
                "original_mode": {
                    "$ref": "#/definitions/types.SessionMode"
                },
                "priority": {
                    "type": "boolean"
                },
                "rag_enabled": {
                    "description": "these settings control which features of a session we want to use\neven if we have a Lora file and RAG indexed prepared\nwe might choose to not use them (this will help our eval framework know what works the best)\nwe well as activate RAG - we also get to control some properties, e.g. which distance function to use,\nand what the threshold for a \"good\" answer is",
                    "type": "boolean"
                },
                "rag_settings": {
                    "$ref": "#/definitions/types.RAGSettings"
                },
                "rag_source_data_entity_id": {
                    "description": "the RAG source data entity we produced from this session",
                    "type": "string"
                },
                "shared": {
                    "type": "boolean"
                },
                "stream": {
                    "type": "boolean"
                },
                "system_prompt": {
                    "type": "string"
                },
                "text_finetune_enabled": {
                    "description": "without any user input, this will default to true",
                    "type": "boolean"
                },
                "uploaded_data_entity_id": {
                    "description": "when we do fine tuning or RAG, we need to know which data entity we used",
                    "type": "string"
                }
            }
        },
        "types.SessionMode": {
            "type": "string",
            "enum": [
                "",
                "inference",
                "finetune",
                "action"
            ],
            "x-enum-comments": {
                "SessionModeAction": "Running tool actions (e.g. API, function calls)"
            },
            "x-enum-varnames": [
                "SessionModeNone",
                "SessionModeInference",
                "SessionModeFinetune",
                "SessionModeAction"
            ]
        },
        "types.SessionOrigin": {
            "type": "object",
            "properties": {
                "cloned_interaction_id": {
                    "type": "string"
                },
                "cloned_session_id": {
                    "type": "string"
                },
                "type": {
                    "$ref": "#/definitions/types.SessionOriginType"
                }
            }
        },
        "types.SessionOriginType": {
            "type": "string",
            "enum": [
                "",
                "user_created",
                "cloned"
            ],
            "x-enum-varnames": [
                "SessionOriginTypeNone",
                "SessionOriginTypeUserCreated",
                "SessionOriginTypeCloned"
            ]
        },
        "types.SessionRAGResult": {
            "type": "object",
            "properties": {
                "content": {
                    "type": "string"
                },
                "content_offset": {
                    "type": "integer"
                },
                "distance": {
                    "type": "number"
                },
                "document_group_id": {
                    "type": "string"
                },
                "document_id": {
                    "type": "string"
                },
                "filename": {
                    "type": "string"
                },
                "id": {
                    "type": "string"
                },
                "interaction_id": {
                    "type": "string"
                },
                "session_id": {
                    "type": "string"
                },
                "source": {
                    "type": "string"
                }
            }
        },
        "types.SessionType": {
            "type": "string",
            "enum": [
                "",
                "text",
                "image"
            ],
            "x-enum-varnames": [
                "SessionTypeNone",
                "SessionTypeText",
                "SessionTypeImage"
            ]
        },
        "types.TextDataPrepStage": {
            "type": "string",
            "enum": [
                "",
                "edit_files",
                "extract_text",
                "index_rag",
                "generate_questions",
                "edit_questions",
                "finetune",
                "complete"
            ],
            "x-enum-varnames": [
                "TextDataPrepStageNone",
                "TextDataPrepStageEditFiles",
                "TextDataPrepStageExtractText",
                "TextDataPrepStageIndexRag",
                "TextDataPrepStageGenerateQuestions",
                "TextDataPrepStageEditQuestions",
                "TextDataPrepStageFineTune",
                "TextDataPrepStageComplete"
            ]
        },
        "types.TextSplitterType": {
            "type": "string",
            "enum": [
                "markdown",
                "text"
            ],
            "x-enum-varnames": [
                "TextSplitterTypeMarkdown",
                "TextSplitterTypeText"
            ]
        },
        "types.ToolApiAction": {
            "type": "object",
            "properties": {
                "description": {
                    "type": "string"
                },
                "method": {
                    "type": "string"
                },
                "name": {
                    "type": "string"
                },
                "path": {
                    "type": "string"
                }
            }
        },
        "types.ToolApiConfig": {
            "type": "object",
            "properties": {
                "actions": {
                    "description": "Read-only, parsed from schema on creation",
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/types.ToolApiAction"
                    }
                },
                "headers": {
                    "description": "Headers (authentication, etc)",
                    "type": "object",
                    "additionalProperties": {
                        "type": "string"
                    }
                },
                "model": {
                    "type": "string"
                },
                "query": {
                    "description": "Query parameters that will be always set",
                    "type": "object",
                    "additionalProperties": {
                        "type": "string"
                    }
                },
                "request_prep_template": {
                    "description": "Template for request preparation, leave empty for default",
                    "type": "string"
                },
                "response_error_template": {
                    "description": "Template for error response, leave empty for default",
                    "type": "string"
                },
                "response_success_template": {
                    "description": "Template for successful response, leave empty for default",
                    "type": "string"
                },
                "schema": {
                    "type": "string"
                },
                "url": {
                    "description": "Server override",
                    "type": "string"
                }
            }
        },
        "types.ToolConfig": {
            "type": "object",
            "properties": {
                "api": {
                    "$ref": "#/definitions/types.ToolApiConfig"
                },
                "gptscript": {
                    "$ref": "#/definitions/types.ToolGPTScriptConfig"
                },
                "zapier": {
                    "$ref": "#/definitions/types.ToolZapierConfig"
                }
            }
        },
        "types.ToolGPTScriptConfig": {
            "type": "object",
            "properties": {
                "script": {
                    "description": "Program code",
                    "type": "string"
                },
                "script_url": {
                    "description": "URL to download the script",
                    "type": "string"
                }
            }
        },
        "types.ToolZapierConfig": {
            "type": "object",
            "properties": {
                "api_key": {
                    "type": "string"
                },
                "max_iterations": {
                    "type": "integer"
                },
                "model": {
                    "type": "string"
                }
            }
        },
        "types.Trigger": {
            "type": "object",
            "properties": {
                "cron": {
                    "$ref": "#/definitions/types.CronTrigger"
                },
                "discord": {
                    "$ref": "#/definitions/types.DiscordTrigger"
                }
            }
        },
        "types.WebsiteCrawler": {
            "type": "object",
            "properties": {
                "enabled": {
                    "type": "boolean"
                },
                "firecrawl": {
                    "$ref": "#/definitions/types.Firecrawl"
                },
                "max_depth": {
                    "description": "Limit crawl depth to avoid infinite crawling",
                    "type": "integer"
                },
                "max_pages": {
                    "description": "Limit number of pages to crawl to avoid infinite crawling (max 500 by default)",
                    "type": "integer"
                },
                "readability": {
                    "description": "Apply readability middleware to the HTML content",
                    "type": "boolean"
                },
                "user_agent": {
                    "type": "string"
                }
            }
        }
    }
}`

// SwaggerInfo holds exported Swagger Info so clients can modify it
var SwaggerInfo = &swag.Spec{
	Version:          "0.1",
	Host:             "app.tryhelix.ai",
	BasePath:         "",
	Schemes:          []string{"https"},
	Title:            "HelixML API reference",
	Description:      "This is a HelixML AI API.",
	InfoInstanceName: "swagger",
	SwaggerTemplate:  docTemplate,
	LeftDelim:        "{{",
	RightDelim:       "}}",
}

func init() {
	swag.Register(SwaggerInfo.InstanceName(), SwaggerInfo)
}
