
class Person {
    constructor(public id: number, public firstName: string, public lastName: string, public email: string, public gender: string, public company: string) {

    }
}

class Company {
    constructor(public id: number, public name: string, public street: string, public email: string) { }
}

class AddressBook {
    public static loadPersons(): Person[] {
        const contactsData = [{
            "id": 1,
            "first_name": "Burg",
            "last_name": "Legg",
            "email": "blegg0@elpais.com",
            "gender": "Male",
            "company": "Zoozzy"
        }, {
            "id": 2,
            "first_name": "Erminia",
            "last_name": "Heersema",
            "email": "eheersema1@jugem.jp",
            "gender": "Female",
            "company": "Skipfire"
        }, {
            "id": 3,
            "first_name": "Penrod",
            "last_name": "Claxton",
            "email": "pclaxton2@furl.net",
            "gender": "Male",
            "company": "Dabvine"
        }, {
            "id": 4,
            "first_name": "Peterus",
            "last_name": "Alabone",
            "email": "palabone3@icio.us",
            "gender": "Male",
            "company": "Gabtune"
        }, {
            "id": 5,
            "first_name": "Rickie",
            "last_name": "Belsher",
            "email": "rbelsher4@marketwatch.com",
            "gender": "Male",
            "company": "Digitube"
        }, {
            "id": 6,
            "first_name": "Griffie",
            "last_name": "Poulsum",
            "email": "gpoulsum5@printfriendly.com",
            "gender": "Male",
            "company": "Mymm"
        }, {
            "id": 7,
            "first_name": "Fidelio",
            "last_name": "Gateland",
            "email": "fgateland6@intel.com",
            "gender": "Male",
            "company": "Meeveo"
        }, {
            "id": 8,
            "first_name": "Fayth",
            "last_name": "D'Oyly",
            "email": "fdoyly7@twitter.com",
            "gender": "Female",
            "company": "Podcat"
        }, {
            "id": 9,
            "first_name": "Janela",
            "last_name": "Shelton",
            "email": "jshelton8@dion.ne.jp",
            "gender": "Female",
            "company": "Kayveo"
        }, {
            "id": 10,
            "first_name": "Yance",
            "last_name": "Vatcher",
            "email": "yvatcher9@ask.com",
            "gender": "Male",
            "company": "Photobug"
        }, {
            "id": 11,
            "first_name": "Filippo",
            "last_name": "Timoney",
            "email": "ftimoneya@spotify.com",
            "gender": "Male",
            "company": "Rhyzio"
        }, {
            "id": 12,
            "first_name": "Helli",
            "last_name": "Friskey",
            "email": "hfriskeyb@usa.gov",
            "gender": "Female",
            "company": "Eare"
        }, {
            "id": 13,
            "first_name": "Enos",
            "last_name": "Connick",
            "email": "econnickc@sitemeter.com",
            "gender": "Male",
            "company": "Meetz"
        }, {
            "id": 14,
            "first_name": "Lorri",
            "last_name": "Chessun",
            "email": "lchessund@wp.com",
            "gender": "Female",
            "company": "Jaxworks"
        }, {
            "id": 15,
            "first_name": "Justina",
            "last_name": "Spedroni",
            "email": "jspedronie@abc.net.au",
            "gender": "Female",
            "company": "Rhyzio"
        }, {
            "id": 16,
            "first_name": "Odilia",
            "last_name": "Ealden",
            "email": "oealdenf@fastcompany.com",
            "gender": "Female",
            "company": "Blognation"
        }, {
            "id": 17,
            "first_name": "Dale",
            "last_name": "Bretherick",
            "email": "dbretherickg@dmoz.org",
            "gender": "Male",
            "company": "Skipfire"
        }, {
            "id": 18,
            "first_name": "Syman",
            "last_name": "Lawdham",
            "email": "slawdhamh@so-net.ne.jp",
            "gender": "Male",
            "company": "Wordify"
        }, {
            "id": 19,
            "first_name": "Catarina",
            "last_name": "Stoile",
            "email": "cstoilei@hud.gov",
            "gender": "Female",
            "company": "Avaveo"
        }, {
            "id": 20,
            "first_name": "Simonette",
            "last_name": "Danett",
            "email": "sdanettj@eepurl.com",
            "gender": "Female",
            "company": "Realblab"
        }, {
            "id": 21,
            "first_name": "Fielding",
            "last_name": "MacHarg",
            "email": "fmachargk@blogtalkradio.com",
            "gender": "Male",
            "company": "Photolist"
        }, {
            "id": 22,
            "first_name": "Anni",
            "last_name": "Hounsom",
            "email": "ahounsoml@wikia.com",
            "gender": "Female",
            "company": "Devify"
        }, {
            "id": 23,
            "first_name": "Evelin",
            "last_name": "Gaytor",
            "email": "egaytorm@myspace.com",
            "gender": "Male",
            "company": "Aivee"
        }, {
            "id": 24,
            "first_name": "Lynde",
            "last_name": "Itscowicz",
            "email": "litscowiczn@fc2.com",
            "gender": "Female",
            "company": "Skipfire"
        }, {
            "id": 25,
            "first_name": "Reta",
            "last_name": "Felipe",
            "email": "rfelipeo@free.fr",
            "gender": "Female",
            "company": "Ainyx"
        }, {
            "id": 26,
            "first_name": "Bar",
            "last_name": "Shillingford",
            "email": "bshillingfordp@sun.com",
            "gender": "Male",
            "company": "Skilith"
        }, {
            "id": 27,
            "first_name": "Mel",
            "last_name": "Cooch",
            "email": "mcoochq@icq.com",
            "gender": "Female",
            "company": "Meevee"
        }, {
            "id": 28,
            "first_name": "Wheeler",
            "last_name": "Kettlesting",
            "email": "wkettlestingr@miitbeian.gov.cn",
            "gender": "Male",
            "company": "Mybuzz"
        }, {
            "id": 29,
            "first_name": "Corabel",
            "last_name": "Pordall",
            "email": "cpordalls@sourceforge.net",
            "gender": "Female",
            "company": "Blogtag"
        }, {
            "id": 30,
            "first_name": "Merrily",
            "last_name": "Weatherhill",
            "email": "mweatherhillt@printfriendly.com",
            "gender": "Female",
            "company": "Divape"
        }, {
            "id": 31,
            "first_name": "Reynard",
            "last_name": "Osgodby",
            "email": "rosgodbyu@eepurl.com",
            "gender": "Male",
            "company": "Yakijo"
        }, {
            "id": 32,
            "first_name": "Guilbert",
            "last_name": "Bilston",
            "email": "gbilstonv@devhub.com",
            "gender": "Male",
            "company": "Vinder"
        }, {
            "id": 33,
            "first_name": "Farr",
            "last_name": "Skehan",
            "email": "fskehanw@t-online.de",
            "gender": "Male",
            "company": "Linkbuzz"
        }, {
            "id": 34,
            "first_name": "Roger",
            "last_name": "Langelay",
            "email": "rlangelayx@pcworld.com",
            "gender": "Male",
            "company": "Tekfly"
        }, {
            "id": 35,
            "first_name": "Jemmy",
            "last_name": "Yggo",
            "email": "jyggoy@ifeng.com",
            "gender": "Female",
            "company": "Jabberstorm"
        }, {
            "id": 36,
            "first_name": "Cybill",
            "last_name": "Chastaing",
            "email": "cchastaingz@mayoclinic.com",
            "gender": "Female",
            "company": "Riffpedia"
        }, {
            "id": 37,
            "first_name": "Samuele",
            "last_name": "Zorzoni",
            "email": "szorzoni10@opensource.org",
            "gender": "Male",
            "company": "Devcast"
        }, {
            "id": 38,
            "first_name": "Svend",
            "last_name": "Hamill",
            "email": "shamill11@google.co.jp",
            "gender": "Male",
            "company": "Kwilith"
        }, {
            "id": 39,
            "first_name": "Carlin",
            "last_name": "Roote",
            "email": "croote12@gov.uk",
            "gender": "Male",
            "company": "Twitterlist"
        }, {
            "id": 40,
            "first_name": "Dawna",
            "last_name": "Lanfer",
            "email": "dlanfer13@mlb.com",
            "gender": "Female",
            "company": "Jayo"
        }, {
            "id": 41,
            "first_name": "Melissa",
            "last_name": "Chappelow",
            "email": "mchappelow14@usa.gov",
            "gender": "Female",
            "company": "Skibox"
        }, {
            "id": 42,
            "first_name": "George",
            "last_name": "Hargreaves",
            "email": "ghargreaves15@pagesperso-orange.fr",
            "gender": "Female",
            "company": "Zazio"
        }, {
            "id": 43,
            "first_name": "Sampson",
            "last_name": "Steaning",
            "email": "ssteaning16@state.gov",
            "gender": "Male",
            "company": "Jaxworks"
        }, {
            "id": 44,
            "first_name": "Brana",
            "last_name": "Wims",
            "email": "bwims17@icio.us",
            "gender": "Female",
            "company": "Flashset"
        }, {
            "id": 45,
            "first_name": "Shawn",
            "last_name": "Saffen",
            "email": "ssaffen18@shutterfly.com",
            "gender": "Male",
            "company": "Twitterwire"
        }, {
            "id": 46,
            "first_name": "Alessandro",
            "last_name": "Gasker",
            "email": "agasker19@slashdot.org",
            "gender": "Male",
            "company": "Dabtype"
        }, {
            "id": 47,
            "first_name": "Bobby",
            "last_name": "Mulcock",
            "email": "bmulcock1a@time.com",
            "gender": "Female",
            "company": "Quamba"
        }, {
            "id": 48,
            "first_name": "Ashlen",
            "last_name": "Midner",
            "email": "amidner1b@devhub.com",
            "gender": "Female",
            "company": "Thoughtstorm"
        }, {
            "id": 49,
            "first_name": "Mallory",
            "last_name": "Joel",
            "email": "mjoel1c@upenn.edu",
            "gender": "Male",
            "company": "Twitterbeat"
        }, {
            "id": 50,
            "first_name": "Maximilian",
            "last_name": "Scraggs",
            "email": "mscraggs1d@ucla.edu",
            "gender": "Male",
            "company": "Twiyo"
        }, {
            "id": 51,
            "first_name": "Beverlie",
            "last_name": "Pittet",
            "email": "bpittet1e@github.io",
            "gender": "Female",
            "company": "Riffpath"
        }, {
            "id": 52,
            "first_name": "Enrique",
            "last_name": "Rentilll",
            "email": "erentilll1f@smugmug.com",
            "gender": "Male",
            "company": "Blognation"
        }, {
            "id": 53,
            "first_name": "Cathrin",
            "last_name": "McKendry",
            "email": "cmckendry1g@hc360.com",
            "gender": "Female",
            "company": "Shuffledrive"
        }, {
            "id": 54,
            "first_name": "Isabeau",
            "last_name": "Quincey",
            "email": "iquincey1h@msn.com",
            "gender": "Female",
            "company": "Tagcat"
        }, {
            "id": 55,
            "first_name": "Geoffrey",
            "last_name": "Grzegorczyk",
            "email": "ggrzegorczyk1i@loc.gov",
            "gender": "Male",
            "company": "Youfeed"
        }, {
            "id": 56,
            "first_name": "Ruggiero",
            "last_name": "Vaar",
            "email": "rvaar1j@unesco.org",
            "gender": "Male",
            "company": "Babbleset"
        }, {
            "id": 57,
            "first_name": "Alfonso",
            "last_name": "Tarzey",
            "email": "atarzey1k@weebly.com",
            "gender": "Male",
            "company": "Pixonyx"
        }, {
            "id": 58,
            "first_name": "Marylin",
            "last_name": "Bissex",
            "email": "mbissex1l@microsoft.com",
            "gender": "Female",
            "company": "Tagfeed"
        }, {
            "id": 59,
            "first_name": "Cathryn",
            "last_name": "Morhall",
            "email": "cmorhall1m@irs.gov",
            "gender": "Female",
            "company": "Tagopia"
        }, {
            "id": 60,
            "first_name": "Terza",
            "last_name": "Easey",
            "email": "teasey1n@thetimes.co.uk",
            "gender": "Female",
            "company": "Devcast"
        }, {
            "id": 61,
            "first_name": "Hale",
            "last_name": "Gaudon",
            "email": "hgaudon1o@webnode.com",
            "gender": "Male",
            "company": "Quinu"
        }, {
            "id": 62,
            "first_name": "Hadley",
            "last_name": "Elwood",
            "email": "helwood1p@japanpost.jp",
            "gender": "Male",
            "company": "Plajo"
        }, {
            "id": 63,
            "first_name": "Seamus",
            "last_name": "Straker",
            "email": "sstraker1q@live.com",
            "gender": "Male",
            "company": "Yoveo"
        }, {
            "id": 64,
            "first_name": "Urbano",
            "last_name": "Gisbey",
            "email": "ugisbey1r@sitemeter.com",
            "gender": "Male",
            "company": "Quinu"
        }, {
            "id": 65,
            "first_name": "Gerri",
            "last_name": "McInulty",
            "email": "gmcinulty1s@businessinsider.com",
            "gender": "Male",
            "company": "Agimba"
        }, {
            "id": 66,
            "first_name": "Lena",
            "last_name": "Gonthier",
            "email": "lgonthier1t@newsvine.com",
            "gender": "Female",
            "company": "Geba"
        }, {
            "id": 67,
            "first_name": "Ameline",
            "last_name": "Wheatcroft",
            "email": "awheatcroft1u@163.com",
            "gender": "Female",
            "company": "Twitternation"
        }, {
            "id": 68,
            "first_name": "Kathryn",
            "last_name": "Castelli",
            "email": "kcastelli1v@about.com",
            "gender": "Female",
            "company": "Photospace"
        }, {
            "id": 69,
            "first_name": "Terrell",
            "last_name": "Walicki",
            "email": "twalicki1w@amazon.co.jp",
            "gender": "Male",
            "company": "Babblestorm"
        }, {
            "id": 70,
            "first_name": "Claudianus",
            "last_name": "Tremathack",
            "email": "ctremathack1x@walmart.com",
            "gender": "Male",
            "company": "Skyndu"
        }, {
            "id": 71,
            "first_name": "Sanford",
            "last_name": "Devinn",
            "email": "sdevinn1y@ehow.com",
            "gender": "Male",
            "company": "Dynazzy"
        }, {
            "id": 72,
            "first_name": "Gwendolen",
            "last_name": "Turfrey",
            "email": "gturfrey1z@va.gov",
            "gender": "Female",
            "company": "Yacero"
        }, {
            "id": 73,
            "first_name": "Alta",
            "last_name": "Leap",
            "email": "aleap20@ezinearticles.com",
            "gender": "Female",
            "company": "Twitterlist"
        }, {
            "id": 74,
            "first_name": "Johnath",
            "last_name": "Andrzejowski",
            "email": "jandrzejowski21@google.com.hk",
            "gender": "Female",
            "company": "Lazzy"
        }, {
            "id": 75,
            "first_name": "Yancy",
            "last_name": "Askham",
            "email": "yaskham22@sciencedaily.com",
            "gender": "Male",
            "company": "Yabox"
        }, {
            "id": 76,
            "first_name": "Paula",
            "last_name": "Warder",
            "email": "pwarder23@harvard.edu",
            "gender": "Female",
            "company": "Zooxo"
        }, {
            "id": 77,
            "first_name": "Grannie",
            "last_name": "Hauxley",
            "email": "ghauxley24@symantec.com",
            "gender": "Male",
            "company": "Yakidoo"
        }, {
            "id": 78,
            "first_name": "Enid",
            "last_name": "Grealy",
            "email": "egrealy25@homestead.com",
            "gender": "Female",
            "company": "Gabcube"
        }, {
            "id": 79,
            "first_name": "Lazarus",
            "last_name": "Itscowicz",
            "email": "litscowicz26@epa.gov",
            "gender": "Male",
            "company": "Demizz"
        }, {
            "id": 80,
            "first_name": "Marmaduke",
            "last_name": "Gilligan",
            "email": "mgilligan27@tiny.cc",
            "gender": "Male",
            "company": "Yombu"
        }, {
            "id": 81,
            "first_name": "Linnell",
            "last_name": "Chree",
            "email": "lchree28@ocn.ne.jp",
            "gender": "Female",
            "company": "Buzzshare"
        }, {
            "id": 82,
            "first_name": "Pavia",
            "last_name": "Pocke",
            "email": "ppocke29@newsvine.com",
            "gender": "Female",
            "company": "Eidel"
        }, {
            "id": 83,
            "first_name": "Golda",
            "last_name": "Stuchburie",
            "email": "gstuchburie2a@oaic.gov.au",
            "gender": "Female",
            "company": "Flipstorm"
        }, {
            "id": 84,
            "first_name": "Trace",
            "last_name": "Lodge",
            "email": "tlodge2b@whitehouse.gov",
            "gender": "Male",
            "company": "Zazio"
        }, {
            "id": 85,
            "first_name": "Nikolia",
            "last_name": "Bartolomivis",
            "email": "nbartolomivis2c@opensource.org",
            "gender": "Female",
            "company": "Devshare"
        }, {
            "id": 86,
            "first_name": "Dela",
            "last_name": "Wimp",
            "email": "dwimp2d@miitbeian.gov.cn",
            "gender": "Female",
            "company": "Wordware"
        }, {
            "id": 87,
            "first_name": "Rustie",
            "last_name": "Drury",
            "email": "rdrury2e@sun.com",
            "gender": "Male",
            "company": "Youbridge"
        }, {
            "id": 88,
            "first_name": "Phedra",
            "last_name": "Shrimptone",
            "email": "pshrimptone2f@unicef.org",
            "gender": "Female",
            "company": "Realcube"
        }, {
            "id": 89,
            "first_name": "Alaster",
            "last_name": "Vittori",
            "email": "avittori2g@senate.gov",
            "gender": "Male",
            "company": "Livepath"
        }, {
            "id": 90,
            "first_name": "Pascal",
            "last_name": "Neissen",
            "email": "pneissen2h@mediafire.com",
            "gender": "Male",
            "company": "Mydo"
        }, {
            "id": 91,
            "first_name": "Brian",
            "last_name": "Manuel",
            "email": "bmanuel2i@blog.com",
            "gender": "Male",
            "company": "Roomm"
        }, {
            "id": 92,
            "first_name": "Jen",
            "last_name": "Laydon",
            "email": "jlaydon2j@hubpages.com",
            "gender": "Female",
            "company": "Plambee"
        }, {
            "id": 93,
            "first_name": "Beltran",
            "last_name": "Brandoni",
            "email": "bbrandoni2k@digg.com",
            "gender": "Male",
            "company": "Yacero"
        }, {
            "id": 94,
            "first_name": "Sarene",
            "last_name": "Gaymar",
            "email": "sgaymar2l@surveymonkey.com",
            "gender": "Female",
            "company": "Katz"
        }, {
            "id": 95,
            "first_name": "Iormina",
            "last_name": "Peedell",
            "email": "ipeedell2m@seattletimes.com",
            "gender": "Female",
            "company": "Youfeed"
        }, {
            "id": 96,
            "first_name": "Abigail",
            "last_name": "Kielty",
            "email": "akielty2n@npr.org",
            "gender": "Female",
            "company": "Reallinks"
        }, {
            "id": 97,
            "first_name": "Hallie",
            "last_name": "Toomey",
            "email": "htoomey2o@google.com.au",
            "gender": "Female",
            "company": "Flipbug"
        }, {
            "id": 98,
            "first_name": "Sergeant",
            "last_name": "Pourveer",
            "email": "spourveer2p@amazon.co.uk",
            "gender": "Male",
            "company": "Skinix"
        }, {
            "id": 99,
            "first_name": "Elfie",
            "last_name": "McKinlay",
            "email": "emckinlay2q@xrea.com",
            "gender": "Female",
            "company": "Devcast"
        }, {
            "id": 100,
            "first_name": "Wainwright",
            "last_name": "Juggins",
            "email": "wjuggins2r@tamu.edu",
            "gender": "Male",
            "company": "Topiclounge"
        }];



        const contacts = contactsData.map(d => new Person(d.id, d.first_name, d.last_name, d.email, d.gender, d.company));
        return contacts;
    }

    public static loadCompanies() {
        const companies = [{
            "id": 101,
            "city": "Lakshmīpur",
            "street": "36300 Lake View Center",
            "email": "ogovier0@gmpg.org",
            "company": "Fiveclub"
        }, {
            "id": 102,
            "city": "El Quetzal",
            "street": "551 New Castle Parkway",
            "email": "elander1@g.co",
            "company": "Twitterwire"
        }, {
            "id": 103,
            "city": "Mayakovski",
            "street": "1 Norway Maple Center",
            "email": "dcustance2@hostgator.com",
            "company": "Jabbersphere"
        }, {
            "id": 104,
            "city": "Al Jawādīyah",
            "street": "02 Carey Hill",
            "email": "evanoort3@sciencedaily.com",
            "company": "Zoovu"
        }, {
            "id": 105,
            "city": "Girona",
            "street": "3 Lillian Center",
            "email": "dducker4@cbsnews.com",
            "company": "Innojam"
        }, {
            "id": 106,
            "city": "Vouani",
            "street": "5165 Vera Avenue",
            "email": "orzehorz5@arizona.edu",
            "company": "Zoovu"
        }, {
            "id": 107,
            "city": "Caibarién",
            "street": "3739 Burrows Drive",
            "email": "ltrahair6@pinterest.com",
            "company": "Quamba"
        }, {
            "id": 108,
            "city": "Wushi",
            "street": "88 Bay Hill",
            "email": "plebourn7@springer.com",
            "company": "Feednation"
        }, {
            "id": 109,
            "city": "Zbýšov",
            "street": "38 Dovetail Place",
            "email": "slace8@netscape.com",
            "company": "Zoomzone"
        }, {
            "id": 110,
            "city": "Nová Cerekev",
            "street": "90194 Dixon Avenue",
            "email": "mdoxey9@goo.gl",
            "company": "Devpoint"
        }];

        return companies.map(c => new Company(c.id, c.company, c.street, c.email));
    }

    public static loadContacts() {
        const result = new Array<Person | Company>();
        result.push(...this.loadPersons());
        result.push(...this.loadCompanies());
        let idx = 0;
        while (idx++ < 1000) {
            const i = Math.round(Math.random() * (result.length - 1));
            const j = Math.round(Math.random() * (result.length - 1));
            const temp = result[i];
            result[i] = result[j];
            result[j] = temp;
        }
        return result;
    }
}


const contacts = AddressBook.loadContacts();

debugger;
