import { CleanWebpackPlugin } from "clean-webpack-plugin";
import * as path from "path";
import * as webpack from "webpack";

const r = (file: string) => path.resolve(__dirname, file);

module.exports = {
	target: "node",
	entry: r("./src/index"),
	output: {
		path: r("./dist"),
		filename: "index.js",
		libraryTarget: "commonjs2",
		devtoolModuleFilenameTemplate: "../[resource-path]",
	},
	devtool: "source-map",
	resolve: {
		extensions: [".ts", ".js"],
	},
	module: {
		rules: [
			{
				test: /\.ts$/,
				exclude: /node_modules/,
				use: [
					{
						loader: "ts-loader",
					},
				],
			},
		],
	},
	node: {
		__dirname: false,
		__filename: false,
	},
	plugins: [
		new CleanWebpackPlugin({
			//protectWebpackAssets: true,
			cleanAfterEveryBuildPatterns: ["!**/*.d.ts", "!**/*.d.ts.map"],
		}),
	],
} as webpack.Configuration;
