﻿using FlexFetcher.Models.Queries;
using System.Linq.Expressions;

namespace FlexFetcher.ExpressionBuilders.FilterExpressionHandlers;

public class NotEqualFilterExpressionHandler : BaseFilterExpressionHandler
{
    public override string Operator => DataFilterOperator.NotEqual;

    public override Expression BuildExpression(Expression property, DataFilter filter)
    {
        var value = BuildValueExpression(property, filter);
        var propertyExpression = GetPropertyExpression(property, value);

        return Expression.NotEqual(propertyExpression, value);
    }
}