﻿using System.Linq.Expressions;
using FlexFetcher.Models.Queries;

namespace FlexFetcher.ExpressionBuilders.FilterExpressionHandlers;

public class EndsWithFilterExpressionHandler : BaseFilterExpressionHandler
{
    public override string Operator => DataFilterOperator.EndsWith;

    public override Expression BuildExpression(Expression property, DataFilter filter)
    {
        var value = BuildValueExpression(filter);
        return Expression.Call(property, "EndsWith", null, value);
    }
}