/*!-----------------------------------------------------------------------------
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Version: 0.32.1(29a273516805a852aa8edc5e05059f119b13eff0)
 * Released under the MIT license
 * https://github.com/microsoft/monaco-editor/blob/main/LICENSE.txt
 *-----------------------------------------------------------------------------*/
define("vs/language/html/htmlWorker",["require","require"],(_=>(()=>{var _,S,x,L,z,C,H,W,D,O,q,P,V,K,X,Y,Q,Z,ee,te,ne,re,oe,se,ce,he,de,ue=Object.defineProperty,me=Object.getOwnPropertyDescriptor,be=Object.getOwnPropertyNames,_e=Object.prototype.hasOwnProperty,we=(_="undefined"!=typeof WeakMap?new WeakMap:0,(S,x)=>_&&_.get(S)||(x=((_,S,x,L)=>{if(S&&"object"==typeof S||"function"==typeof S)for(let z of be(S))!_e.call(_,z)&&(x||"default"!==z)&&ue(_,z,{get:()=>S[z],enumerable:!(L=me(S,z))||L.enumerable});return _})((_=>ue(_,"__esModule",{value:!0}))({}),S,1),_&&_.set(S,x),x)),ve={};function Hn(_,S,...x){return function zn(_,S){let x;return x=0===S.length?_:_.replace(/\{(\d+)\}/g,((_,x)=>{let L=x[0];return typeof S[L]<"u"?S[L]:_})),x}(S,x)}function ge(_){return Hn}((_,S)=>{for(var x in S)ue(_,x,{get:S[x],enumerable:!0})})(ve,{HTMLWorker:()=>Dn,create:()=>Ri}),function(_){_.MIN_VALUE=-2147483648,_.MAX_VALUE=2147483647}(S||(S={})),function(_){_.MIN_VALUE=0,_.MAX_VALUE=2147483647}(x||(x={})),function(_){_.create=function i(_,S){return _===Number.MAX_VALUE&&(_=x.MAX_VALUE),S===Number.MAX_VALUE&&(S=x.MAX_VALUE),{line:_,character:S}},_.is=function o(_){var S=_;return rt.objectLiteral(S)&&rt.uinteger(S.line)&&rt.uinteger(S.character)}}(L||(L={})),function(_){_.create=function i(_,S,x,z){if(rt.uinteger(_)&&rt.uinteger(S)&&rt.uinteger(x)&&rt.uinteger(z))return{start:L.create(_,S),end:L.create(x,z)};if(L.is(_)&&L.is(S))return{start:_,end:S};throw new Error("Range#create called with invalid arguments["+_+", "+S+", "+x+", "+z+"]")},_.is=function o(_){var S=_;return rt.objectLiteral(S)&&L.is(S.start)&&L.is(S.end)}}(z||(z={})),function(_){_.create=function i(_,S){return{uri:_,range:S}},_.is=function o(_){var S=_;return rt.defined(S)&&z.is(S.range)&&(rt.string(S.uri)||rt.undefined(S.uri))}}(C||(C={})),function(_){_.create=function i(_,S,x,L){return{targetUri:_,targetRange:S,targetSelectionRange:x,originSelectionRange:L}},_.is=function o(_){var S=_;return rt.defined(S)&&z.is(S.targetRange)&&rt.string(S.targetUri)&&(z.is(S.targetSelectionRange)||rt.undefined(S.targetSelectionRange))&&(z.is(S.originSelectionRange)||rt.undefined(S.originSelectionRange))}}(H||(H={})),function(_){_.create=function i(_,S,x,L){return{red:_,green:S,blue:x,alpha:L}},_.is=function o(_){var S=_;return rt.numberRange(S.red,0,1)&&rt.numberRange(S.green,0,1)&&rt.numberRange(S.blue,0,1)&&rt.numberRange(S.alpha,0,1)}}(W||(W={})),function(_){_.create=function i(_,S){return{range:_,color:S}},_.is=function o(_){var S=_;return z.is(S.range)&&W.is(S.color)}}(D||(D={})),function(_){_.create=function i(_,S,x){return{label:_,textEdit:S,additionalTextEdits:x}},_.is=function o(_){var S=_;return rt.string(S.label)&&(rt.undefined(S.textEdit)||ee.is(S))&&(rt.undefined(S.additionalTextEdits)||rt.typedArray(S.additionalTextEdits,ee.is))}}(O||(O={})),function(_){_.Comment="comment",_.Imports="imports",_.Region="region"}(q||(q={})),function(_){_.create=function i(_,S,x,L,z){var C={startLine:_,endLine:S};return rt.defined(x)&&(C.startCharacter=x),rt.defined(L)&&(C.endCharacter=L),rt.defined(z)&&(C.kind=z),C},_.is=function o(_){var S=_;return rt.uinteger(S.startLine)&&rt.uinteger(S.startLine)&&(rt.undefined(S.startCharacter)||rt.uinteger(S.startCharacter))&&(rt.undefined(S.endCharacter)||rt.uinteger(S.endCharacter))&&(rt.undefined(S.kind)||rt.string(S.kind))}}(P||(P={})),function(_){_.create=function i(_,S){return{location:_,message:S}},_.is=function o(_){var S=_;return rt.defined(S)&&C.is(S.location)&&rt.string(S.message)}}(V||(V={})),function(_){_.Error=1,_.Warning=2,_.Information=3,_.Hint=4}(K||(K={})),function(_){_.Unnecessary=1,_.Deprecated=2}(X||(X={})),function(_){_.is=function i(_){var S=_;return null!=S&&rt.string(S.href)}}(Y||(Y={})),function(_){_.create=function i(_,S,x,L,z,C){var H={range:_,message:S};return rt.defined(x)&&(H.severity=x),rt.defined(L)&&(H.code=L),rt.defined(z)&&(H.source=z),rt.defined(C)&&(H.relatedInformation=C),H},_.is=function o(_){var S,x=_;return rt.defined(x)&&z.is(x.range)&&rt.string(x.message)&&(rt.number(x.severity)||rt.undefined(x.severity))&&(rt.integer(x.code)||rt.string(x.code)||rt.undefined(x.code))&&(rt.undefined(x.codeDescription)||rt.string(null===(S=x.codeDescription)||void 0===S?void 0:S.href))&&(rt.string(x.source)||rt.undefined(x.source))&&(rt.undefined(x.relatedInformation)||rt.typedArray(x.relatedInformation,V.is))}}(Q||(Q={})),function(_){_.create=function i(_,S){for(var x=[],L=2;L<arguments.length;L++)x[L-2]=arguments[L];var z={title:_,command:S};return rt.defined(x)&&x.length>0&&(z.arguments=x),z},_.is=function o(_){var S=_;return rt.defined(S)&&rt.string(S.title)&&rt.string(S.command)}}(Z||(Z={})),function(_){_.replace=function i(_,S){return{range:_,newText:S}},_.insert=function o(_,S){return{range:{start:_,end:_},newText:S}},_.del=function n(_){return{range:_,newText:""}},_.is=function e(_){var S=_;return rt.objectLiteral(S)&&rt.string(S.newText)&&z.is(S.range)}}(ee||(ee={})),function(_){_.create=function i(_,S,x){var L={label:_};return void 0!==S&&(L.needsConfirmation=S),void 0!==x&&(L.description=x),L},_.is=function o(_){var S=_;return void 0!==S&&rt.objectLiteral(S)&&rt.string(S.label)&&(rt.boolean(S.needsConfirmation)||void 0===S.needsConfirmation)&&(rt.string(S.description)||void 0===S.description)}}(te||(te={})),function(_){_.is=function i(_){return"string"==typeof _}}(ne||(ne={})),function(_){_.replace=function i(_,S,x){return{range:_,newText:S,annotationId:x}},_.insert=function o(_,S,x){return{range:{start:_,end:_},newText:S,annotationId:x}},_.del=function n(_,S){return{range:_,newText:"",annotationId:S}},_.is=function e(_){var S=_;return ee.is(S)&&(te.is(S.annotationId)||ne.is(S.annotationId))}}(re||(re={})),function(_){_.create=function i(_,S){return{textDocument:_,edits:S}},_.is=function o(_){var S=_;return rt.defined(S)&&ke.is(S.textDocument)&&Array.isArray(S.edits)}}(oe||(oe={})),function(_){_.create=function i(_,S,x){var L={kind:"create",uri:_};return void 0!==S&&(void 0!==S.overwrite||void 0!==S.ignoreIfExists)&&(L.options=S),void 0!==x&&(L.annotationId=x),L},_.is=function o(_){var S=_;return S&&"create"===S.kind&&rt.string(S.uri)&&(void 0===S.options||(void 0===S.options.overwrite||rt.boolean(S.options.overwrite))&&(void 0===S.options.ignoreIfExists||rt.boolean(S.options.ignoreIfExists)))&&(void 0===S.annotationId||ne.is(S.annotationId))}}(se||(se={})),function(_){_.create=function i(_,S,x,L){var z={kind:"rename",oldUri:_,newUri:S};return void 0!==x&&(void 0!==x.overwrite||void 0!==x.ignoreIfExists)&&(z.options=x),void 0!==L&&(z.annotationId=L),z},_.is=function o(_){var S=_;return S&&"rename"===S.kind&&rt.string(S.oldUri)&&rt.string(S.newUri)&&(void 0===S.options||(void 0===S.options.overwrite||rt.boolean(S.options.overwrite))&&(void 0===S.options.ignoreIfExists||rt.boolean(S.options.ignoreIfExists)))&&(void 0===S.annotationId||ne.is(S.annotationId))}}(ce||(ce={})),function(_){_.create=function i(_,S,x){var L={kind:"delete",uri:_};return void 0!==S&&(void 0!==S.recursive||void 0!==S.ignoreIfNotExists)&&(L.options=S),void 0!==x&&(L.annotationId=x),L},_.is=function o(_){var S=_;return S&&"delete"===S.kind&&rt.string(S.uri)&&(void 0===S.options||(void 0===S.options.recursive||rt.boolean(S.options.recursive))&&(void 0===S.options.ignoreIfNotExists||rt.boolean(S.options.ignoreIfNotExists)))&&(void 0===S.annotationId||ne.is(S.annotationId))}}(he||(he={})),function(_){_.is=function i(_){var S=_;return S&&(void 0!==S.changes||void 0!==S.documentChanges)&&(void 0===S.documentChanges||S.documentChanges.every((function(_){return rt.string(_.kind)?se.is(_)||ce.is(_)||he.is(_):oe.is(_)})))}}(de||(de={}));var ye,Te,ke,Se,xe,Le,Ee,Me,Re,Ce,Ie,He,Ue,We,De,Oe,Ne,qe,Pe,Fe,Be,Ge,$e,Je,Ke,Xe,Ye,Qe,Ze,et,tt,nt=function(){function t(_,S){this.edits=_,this.changeAnnotations=S}return t.prototype.insert=function(_,S,x){var L,z;if(void 0===x?L=ee.insert(_,S):ne.is(x)?(z=x,L=re.insert(_,S,x)):(this.assertChangeAnnotations(this.changeAnnotations),z=this.changeAnnotations.manage(x),L=re.insert(_,S,z)),this.edits.push(L),void 0!==z)return z},t.prototype.replace=function(_,S,x){var L,z;if(void 0===x?L=ee.replace(_,S):ne.is(x)?(z=x,L=re.replace(_,S,x)):(this.assertChangeAnnotations(this.changeAnnotations),z=this.changeAnnotations.manage(x),L=re.replace(_,S,z)),this.edits.push(L),void 0!==z)return z},t.prototype.delete=function(_,S){var x,L;if(void 0===S?x=ee.del(_):ne.is(S)?(L=S,x=re.del(_,S)):(this.assertChangeAnnotations(this.changeAnnotations),L=this.changeAnnotations.manage(S),x=re.del(_,L)),this.edits.push(x),void 0!==L)return L},t.prototype.add=function(_){this.edits.push(_)},t.prototype.all=function(){return this.edits},t.prototype.clear=function(){this.edits.splice(0,this.edits.length)},t.prototype.assertChangeAnnotations=function(_){if(void 0===_)throw new Error("Text edit change is not configured to manage change annotations.")},t}(),it=function(){function t(_){this._annotations=void 0===_?Object.create(null):_,this._counter=0,this._size=0}return t.prototype.all=function(){return this._annotations},Object.defineProperty(t.prototype,"size",{get:function(){return this._size},enumerable:!1,configurable:!0}),t.prototype.manage=function(_,S){var x;if(ne.is(_)?x=_:(x=this.nextId(),S=_),void 0!==this._annotations[x])throw new Error("Id "+x+" is already in use.");if(void 0===S)throw new Error("No annotation provided for id "+x);return this._annotations[x]=S,this._size++,x},t.prototype.nextId=function(){return this._counter++,this._counter.toString()},t}();!function(){function t(_){var S=this;this._textEditChanges=Object.create(null),void 0!==_?(this._workspaceEdit=_,_.documentChanges?(this._changeAnnotations=new it(_.changeAnnotations),_.changeAnnotations=this._changeAnnotations.all(),_.documentChanges.forEach((function(_){if(oe.is(_)){var x=new nt(_.edits,S._changeAnnotations);S._textEditChanges[_.textDocument.uri]=x}}))):_.changes&&Object.keys(_.changes).forEach((function(x){var L=new nt(_.changes[x]);S._textEditChanges[x]=L}))):this._workspaceEdit={}}Object.defineProperty(t.prototype,"edit",{get:function(){return this.initDocumentChanges(),void 0!==this._changeAnnotations&&(0===this._changeAnnotations.size?this._workspaceEdit.changeAnnotations=void 0:this._workspaceEdit.changeAnnotations=this._changeAnnotations.all()),this._workspaceEdit},enumerable:!1,configurable:!0}),t.prototype.getTextEditChange=function(_){if(ke.is(_)){if(this.initDocumentChanges(),void 0===this._workspaceEdit.documentChanges)throw new Error("Workspace edit is not configured for document changes.");var S={uri:_.uri,version:_.version};if(!(L=this._textEditChanges[S.uri])){var x={textDocument:S,edits:z=[]};this._workspaceEdit.documentChanges.push(x),L=new nt(z,this._changeAnnotations),this._textEditChanges[S.uri]=L}return L}if(this.initChanges(),void 0===this._workspaceEdit.changes)throw new Error("Workspace edit is not configured for normal text edit changes.");var L;if(!(L=this._textEditChanges[_])){var z=[];this._workspaceEdit.changes[_]=z,L=new nt(z),this._textEditChanges[_]=L}return L},t.prototype.initDocumentChanges=function(){void 0===this._workspaceEdit.documentChanges&&void 0===this._workspaceEdit.changes&&(this._changeAnnotations=new it,this._workspaceEdit.documentChanges=[],this._workspaceEdit.changeAnnotations=this._changeAnnotations.all())},t.prototype.initChanges=function(){void 0===this._workspaceEdit.documentChanges&&void 0===this._workspaceEdit.changes&&(this._workspaceEdit.changes=Object.create(null))},t.prototype.createFile=function(_,S,x){if(this.initDocumentChanges(),void 0===this._workspaceEdit.documentChanges)throw new Error("Workspace edit is not configured for document changes.");var L,z,C;if(te.is(S)||ne.is(S)?L=S:x=S,void 0===L?z=se.create(_,x):(C=ne.is(L)?L:this._changeAnnotations.manage(L),z=se.create(_,x,C)),this._workspaceEdit.documentChanges.push(z),void 0!==C)return C},t.prototype.renameFile=function(_,S,x,L){if(this.initDocumentChanges(),void 0===this._workspaceEdit.documentChanges)throw new Error("Workspace edit is not configured for document changes.");var z,C,H;if(te.is(x)||ne.is(x)?z=x:L=x,void 0===z?C=ce.create(_,S,L):(H=ne.is(z)?z:this._changeAnnotations.manage(z),C=ce.create(_,S,L,H)),this._workspaceEdit.documentChanges.push(C),void 0!==H)return H},t.prototype.deleteFile=function(_,S,x){if(this.initDocumentChanges(),void 0===this._workspaceEdit.documentChanges)throw new Error("Workspace edit is not configured for document changes.");var L,z,C;if(te.is(S)||ne.is(S)?L=S:x=S,void 0===L?z=he.create(_,x):(C=ne.is(L)?L:this._changeAnnotations.manage(L),z=he.create(_,x,C)),this._workspaceEdit.documentChanges.push(z),void 0!==C)return C}}();!function(_){_.create=function i(_){return{uri:_}},_.is=function o(_){var S=_;return rt.defined(S)&&rt.string(S.uri)}}(ye||(ye={})),function(_){_.create=function i(_,S){return{uri:_,version:S}},_.is=function o(_){var S=_;return rt.defined(S)&&rt.string(S.uri)&&rt.integer(S.version)}}(Te||(Te={})),function(_){_.create=function i(_,S){return{uri:_,version:S}},_.is=function o(_){var S=_;return rt.defined(S)&&rt.string(S.uri)&&(null===S.version||rt.integer(S.version))}}(ke||(ke={})),function(_){_.create=function i(_,S,x,L){return{uri:_,languageId:S,version:x,text:L}},_.is=function o(_){var S=_;return rt.defined(S)&&rt.string(S.uri)&&rt.string(S.languageId)&&rt.integer(S.version)&&rt.string(S.text)}}(Se||(Se={})),function(_){_.PlainText="plaintext",_.Markdown="markdown"}(xe||(xe={})),function(_){_.is=function i(S){var x=S;return x===_.PlainText||x===_.Markdown}}(xe||(xe={})),function(_){_.is=function i(_){var S=_;return rt.objectLiteral(_)&&xe.is(S.kind)&&rt.string(S.value)}}(Le||(Le={})),function(_){_.Text=1,_.Method=2,_.Function=3,_.Constructor=4,_.Field=5,_.Variable=6,_.Class=7,_.Interface=8,_.Module=9,_.Property=10,_.Unit=11,_.Value=12,_.Enum=13,_.Keyword=14,_.Snippet=15,_.Color=16,_.File=17,_.Reference=18,_.Folder=19,_.EnumMember=20,_.Constant=21,_.Struct=22,_.Event=23,_.Operator=24,_.TypeParameter=25}(Ee||(Ee={})),function(_){_.PlainText=1,_.Snippet=2}(Me||(Me={})),function(_){_.Deprecated=1}(Re||(Re={})),function(_){_.create=function i(_,S,x){return{newText:_,insert:S,replace:x}},_.is=function o(_){var S=_;return S&&rt.string(S.newText)&&z.is(S.insert)&&z.is(S.replace)}}(Ce||(Ce={})),function(_){_.asIs=1,_.adjustIndentation=2}(Ie||(Ie={})),function(_){_.create=function i(_){return{label:_}}}(He||(He={})),function(_){_.create=function i(_,S){return{items:_||[],isIncomplete:!!S}}}(Ue||(Ue={})),function(_){_.fromPlainText=function i(_){return _.replace(/[\\`*_{}[\]()#+\-.!]/g,"\\$&")},_.is=function o(_){var S=_;return rt.string(S)||rt.objectLiteral(S)&&rt.string(S.language)&&rt.string(S.value)}}(We||(We={})),function(_){_.is=function i(_){var S=_;return!!S&&rt.objectLiteral(S)&&(Le.is(S.contents)||We.is(S.contents)||rt.typedArray(S.contents,We.is))&&(void 0===_.range||z.is(_.range))}}(De||(De={})),function(_){_.create=function i(_,S){return S?{label:_,documentation:S}:{label:_}}}(Oe||(Oe={})),function(_){_.create=function i(_,S){for(var x=[],L=2;L<arguments.length;L++)x[L-2]=arguments[L];var z={label:_};return rt.defined(S)&&(z.documentation=S),rt.defined(x)?z.parameters=x:z.parameters=[],z}}(Ne||(Ne={})),function(_){_.Text=1,_.Read=2,_.Write=3}(qe||(qe={})),function(_){_.create=function i(_,S){var x={range:_};return rt.number(S)&&(x.kind=S),x}}(Pe||(Pe={})),function(_){_.File=1,_.Module=2,_.Namespace=3,_.Package=4,_.Class=5,_.Method=6,_.Property=7,_.Field=8,_.Constructor=9,_.Enum=10,_.Interface=11,_.Function=12,_.Variable=13,_.Constant=14,_.String=15,_.Number=16,_.Boolean=17,_.Array=18,_.Object=19,_.Key=20,_.Null=21,_.EnumMember=22,_.Struct=23,_.Event=24,_.Operator=25,_.TypeParameter=26}(Fe||(Fe={})),function(_){_.Deprecated=1}(Be||(Be={})),function(_){_.create=function i(_,S,x,L,z){var C={name:_,kind:S,location:{uri:L,range:x}};return z&&(C.containerName=z),C}}(Ge||(Ge={})),function(_){_.create=function i(_,S,x,L,z,C){var H={name:_,detail:S,kind:x,range:L,selectionRange:z};return void 0!==C&&(H.children=C),H},_.is=function o(_){var S=_;return S&&rt.string(S.name)&&rt.number(S.kind)&&z.is(S.range)&&z.is(S.selectionRange)&&(void 0===S.detail||rt.string(S.detail))&&(void 0===S.deprecated||rt.boolean(S.deprecated))&&(void 0===S.children||Array.isArray(S.children))&&(void 0===S.tags||Array.isArray(S.tags))}}($e||($e={})),function(_){_.Empty="",_.QuickFix="quickfix",_.Refactor="refactor",_.RefactorExtract="refactor.extract",_.RefactorInline="refactor.inline",_.RefactorRewrite="refactor.rewrite",_.Source="source",_.SourceOrganizeImports="source.organizeImports",_.SourceFixAll="source.fixAll"}(Je||(Je={})),function(_){_.create=function i(_,S){var x={diagnostics:_};return null!=S&&(x.only=S),x},_.is=function o(_){var S=_;return rt.defined(S)&&rt.typedArray(S.diagnostics,Q.is)&&(void 0===S.only||rt.typedArray(S.only,rt.string))}}(Ke||(Ke={})),function(_){_.create=function i(_,S,x){var L={title:_},z=!0;return"string"==typeof S?(z=!1,L.kind=S):Z.is(S)?L.command=S:L.edit=S,z&&void 0!==x&&(L.kind=x),L},_.is=function o(_){var S=_;return S&&rt.string(S.title)&&(void 0===S.diagnostics||rt.typedArray(S.diagnostics,Q.is))&&(void 0===S.kind||rt.string(S.kind))&&(void 0!==S.edit||void 0!==S.command)&&(void 0===S.command||Z.is(S.command))&&(void 0===S.isPreferred||rt.boolean(S.isPreferred))&&(void 0===S.edit||de.is(S.edit))}}(Xe||(Xe={})),function(_){_.create=function i(_,S){var x={range:_};return rt.defined(S)&&(x.data=S),x},_.is=function o(_){var S=_;return rt.defined(S)&&z.is(S.range)&&(rt.undefined(S.command)||Z.is(S.command))}}(Ye||(Ye={})),function(_){_.create=function i(_,S){return{tabSize:_,insertSpaces:S}},_.is=function o(_){var S=_;return rt.defined(S)&&rt.uinteger(S.tabSize)&&rt.boolean(S.insertSpaces)}}(Qe||(Qe={})),function(_){_.create=function i(_,S,x){return{range:_,target:S,data:x}},_.is=function o(_){var S=_;return rt.defined(S)&&z.is(S.range)&&(rt.undefined(S.target)||rt.string(S.target))}}(Ze||(Ze={})),function(_){_.create=function i(_,S){return{range:_,parent:S}},_.is=function o(S){var x=S;return void 0!==x&&z.is(x.range)&&(void 0===x.parent||_.is(x.parent))}}(et||(et={})),function(_){function e(_,S){if(_.length<=1)return _;var x=_.length/2|0,L=_.slice(0,x),z=_.slice(x);e(L,S),e(z,S);for(var C=0,H=0,W=0;C<L.length&&H<z.length;){var D=S(L[C],z[H]);_[W++]=D<=0?L[C++]:z[H++]}for(;C<L.length;)_[W++]=L[C++];for(;H<z.length;)_[W++]=z[H++];return _}_.create=function i(_,S,x,L){return new at(_,S,x,L)},_.is=function o(_){var S=_;return!!(rt.defined(S)&&rt.string(S.uri)&&(rt.undefined(S.languageId)||rt.string(S.languageId))&&rt.uinteger(S.lineCount)&&rt.func(S.getText)&&rt.func(S.positionAt)&&rt.func(S.offsetAt))},_.applyEdits=function n(_,S){for(var x=_.getText(),L=e(S,(function(_,S){var x=_.range.start.line-S.range.start.line;return 0===x?_.range.start.character-S.range.start.character:x})),z=x.length,C=L.length-1;C>=0;C--){var H=L[C],W=_.offsetAt(H.range.start),D=_.offsetAt(H.range.end);if(!(D<=z))throw new Error("Overlapping edit");x=x.substring(0,W)+H.newText+x.substring(D,x.length),z=W}return x}}(tt||(tt={}));var rt,at=function(){function t(_,S,x,L){this._uri=_,this._languageId=S,this._version=x,this._content=L,this._lineOffsets=void 0}return Object.defineProperty(t.prototype,"uri",{get:function(){return this._uri},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"languageId",{get:function(){return this._languageId},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"version",{get:function(){return this._version},enumerable:!1,configurable:!0}),t.prototype.getText=function(_){if(_){var S=this.offsetAt(_.start),x=this.offsetAt(_.end);return this._content.substring(S,x)}return this._content},t.prototype.update=function(_,S){this._content=_.text,this._version=S,this._lineOffsets=void 0},t.prototype.getLineOffsets=function(){if(void 0===this._lineOffsets){for(var _=[],S=this._content,x=!0,L=0;L<S.length;L++){x&&(_.push(L),x=!1);var z=S.charAt(L);x="\r"===z||"\n"===z,"\r"===z&&L+1<S.length&&"\n"===S.charAt(L+1)&&L++}x&&S.length>0&&_.push(S.length),this._lineOffsets=_}return this._lineOffsets},t.prototype.positionAt=function(_){_=Math.max(Math.min(_,this._content.length),0);var S=this.getLineOffsets(),x=0,z=S.length;if(0===z)return L.create(0,_);for(;x<z;){var C=Math.floor((x+z)/2);S[C]>_?z=C:x=C+1}var H=x-1;return L.create(H,_-S[H])},t.prototype.offsetAt=function(_){var S=this.getLineOffsets();if(_.line>=S.length)return this._content.length;if(_.line<0)return 0;var x=S[_.line],L=_.line+1<S.length?S[_.line+1]:this._content.length;return Math.max(Math.min(x+_.character,L),x)},Object.defineProperty(t.prototype,"lineCount",{get:function(){return this.getLineOffsets().length},enumerable:!1,configurable:!0}),t}();!function(_){var S=Object.prototype.toString;_.defined=function o(_){return typeof _<"u"},_.undefined=function n(_){return typeof _>"u"},_.boolean=function e(_){return!0===_||!1===_},_.string=function a(_){return"[object String]"===S.call(_)},_.number=function c(_){return"[object Number]"===S.call(_)},_.numberRange=function l(_,x,L){return"[object Number]"===S.call(_)&&x<=_&&_<=L},_.integer=function r(_){return"[object Number]"===S.call(_)&&-2147483648<=_&&_<=2147483647},_.uinteger=function s(_){return"[object Number]"===S.call(_)&&0<=_&&_<=2147483647},_.func=function u(_){return"[object Function]"===S.call(_)},_.objectLiteral=function h(_){return null!==_&&"object"==typeof _},_.typedArray=function d(_,S){return Array.isArray(_)&&_.every(S)}}(rt||(rt={}));var ot,st,lt,ct,gt,bt=class{constructor(_,S,x,L){this._uri=_,this._languageId=S,this._version=x,this._content=L,this._lineOffsets=void 0}get uri(){return this._uri}get languageId(){return this._languageId}get version(){return this._version}getText(_){if(_){let S=this.offsetAt(_.start),x=this.offsetAt(_.end);return this._content.substring(S,x)}return this._content}update(_,S){for(let S of _)if(bt.isIncremental(S)){let _=Pt(S.range),x=this.offsetAt(_.start),L=this.offsetAt(_.end);this._content=this._content.substring(0,x)+S.text+this._content.substring(L,this._content.length);let z=Math.max(_.start.line,0),C=Math.max(_.end.line,0),H=this._lineOffsets,W=Ft(S.text,!1,x);if(C-z===W.length)for(let _=0,S=W.length;_<S;_++)H[_+z+1]=W[_];else W.length<1e4?H.splice(z+1,C-z,...W):this._lineOffsets=H=H.slice(0,z+1).concat(W,H.slice(C+1));let D=S.text.length-(L-x);if(0!==D)for(let _=z+1+W.length,S=H.length;_<S;_++)H[_]=H[_]+D}else{if(!bt.isFull(S))throw new Error("Unknown change event received");this._content=S.text,this._lineOffsets=void 0}this._version=S}getLineOffsets(){return void 0===this._lineOffsets&&(this._lineOffsets=Ft(this._content,!0)),this._lineOffsets}positionAt(_){_=Math.max(Math.min(_,this._content.length),0);let S=this.getLineOffsets(),x=0,L=S.length;if(0===L)return{line:0,character:_};for(;x<L;){let z=Math.floor((x+L)/2);S[z]>_?L=z:x=z+1}let z=x-1;return{line:z,character:_-S[z]}}offsetAt(_){let S=this.getLineOffsets();if(_.line>=S.length)return this._content.length;if(_.line<0)return 0;let x=S[_.line],L=_.line+1<S.length?S[_.line+1]:this._content.length;return Math.max(Math.min(x+_.character,L),x)}get lineCount(){return this.getLineOffsets().length}static isIncremental(_){let S=_;return null!=S&&"string"==typeof S.text&&void 0!==S.range&&(void 0===S.rangeLength||"number"==typeof S.rangeLength)}static isFull(_){let S=_;return null!=S&&"string"==typeof S.text&&void 0===S.range&&void 0===S.rangeLength}};function ut(_,S){if(_.length<=1)return _;let x=_.length/2|0,L=_.slice(0,x),z=_.slice(x);ut(L,S),ut(z,S);let C=0,H=0,W=0;for(;C<L.length&&H<z.length;)S(L[C],z[H])<=0?_[W++]=L[C++]:_[W++]=z[H++];for(;C<L.length;)_[W++]=L[C++];for(;H<z.length;)_[W++]=z[H++];return _}function Ft(_,S,x=0){let L=S?[x]:[];for(let S=0;S<_.length;S++){let z=_.charCodeAt(S);(13===z||10===z)&&(13===z&&S+1<_.length&&10===_.charCodeAt(S+1)&&S++,L.push(x+S+1))}return L}function Pt(_){let S=_.start,x=_.end;return S.line>x.line||S.line===x.line&&S.character>x.character?{start:x,end:S}:_}function Un(_){let S=Pt(_.range);return S!==_.range?{newText:_.newText,range:S}:_}!function(_){_.create=function i(_,S,x,L){return new bt(_,S,x,L)},_.update=function o(_,S,x){if(_ instanceof bt)return _.update(S,x),_;throw new Error("TextDocument.update: document must be created by TextDocument.create")},_.applyEdits=function n(_,S){let x=_.getText(),L=ut(S.map(Un),((_,S)=>{let x=_.range.start.line-S.range.start.line;return 0===x?_.range.start.character-S.range.start.character:x})),z=0,C=[];for(let S of L){let L=_.offsetAt(S.range.start);if(L<z)throw new Error("Overlapping edit");L>z&&C.push(x.substring(z,L)),S.newText.length&&C.push(S.newText),z=_.offsetAt(S.range.end)}return C.push(x.substr(z)),C.join("")}}(ot||(ot={})),function(_){_[_.StartCommentTag=0]="StartCommentTag",_[_.Comment=1]="Comment",_[_.EndCommentTag=2]="EndCommentTag",_[_.StartTagOpen=3]="StartTagOpen",_[_.StartTagClose=4]="StartTagClose",_[_.StartTagSelfClose=5]="StartTagSelfClose",_[_.StartTag=6]="StartTag",_[_.EndTagOpen=7]="EndTagOpen",_[_.EndTagClose=8]="EndTagClose",_[_.EndTag=9]="EndTag",_[_.DelimiterAssign=10]="DelimiterAssign",_[_.AttributeName=11]="AttributeName",_[_.AttributeValue=12]="AttributeValue",_[_.StartDoctypeTag=13]="StartDoctypeTag",_[_.Doctype=14]="Doctype",_[_.EndDoctypeTag=15]="EndDoctypeTag",_[_.Content=16]="Content",_[_.Whitespace=17]="Whitespace",_[_.Unknown=18]="Unknown",_[_.Script=19]="Script",_[_.Styles=20]="Styles",_[_.EOS=21]="EOS"}(st||(st={})),function(_){_[_.WithinContent=0]="WithinContent",_[_.AfterOpeningStartTag=1]="AfterOpeningStartTag",_[_.AfterOpeningEndTag=2]="AfterOpeningEndTag",_[_.WithinDoctype=3]="WithinDoctype",_[_.WithinTag=4]="WithinTag",_[_.WithinEndTag=5]="WithinEndTag",_[_.WithinComment=6]="WithinComment",_[_.WithinScriptContent=7]="WithinScriptContent",_[_.WithinStyleContent=8]="WithinStyleContent",_[_.AfterAttributeName=9]="AfterAttributeName",_[_.BeforeAttributeValue=10]="BeforeAttributeValue"}(lt||(lt={})),function(_){_.LATEST={textDocument:{completion:{completionItem:{documentationFormat:[xe.Markdown,xe.PlainText]}},hover:{contentFormat:[xe.Markdown,xe.PlainText]}}}}(ct||(ct={})),function(_){_[_.Unknown=0]="Unknown",_[_.File=1]="File",_[_.Directory=2]="Directory",_[_.SymbolicLink=64]="SymbolicLink"}(gt||(gt={}));var _t=ge(),wt=function(){function t(_,S){this.source=_,this.len=_.length,this.position=S}return t.prototype.eos=function(){return this.len<=this.position},t.prototype.getSource=function(){return this.source},t.prototype.pos=function(){return this.position},t.prototype.goBackTo=function(_){this.position=_},t.prototype.goBack=function(_){this.position-=_},t.prototype.advance=function(_){this.position+=_},t.prototype.goToEnd=function(){this.position=this.source.length},t.prototype.nextChar=function(){return this.source.charCodeAt(this.position++)||0},t.prototype.peekChar=function(_){return void 0===_&&(_=0),this.source.charCodeAt(this.position+_)||0},t.prototype.advanceIfChar=function(_){return _===this.source.charCodeAt(this.position)&&(this.position++,!0)},t.prototype.advanceIfChars=function(_){var S;if(this.position+_.length>this.source.length)return!1;for(S=0;S<_.length;S++)if(this.source.charCodeAt(this.position+S)!==_[S])return!1;return this.advance(S),!0},t.prototype.advanceIfRegExp=function(_){var S=this.source.substr(this.position).match(_);return S?(this.position=this.position+S.index+S[0].length,S[0]):""},t.prototype.advanceUntilRegExp=function(_){var S=this.source.substr(this.position).match(_);return S?(this.position=this.position+S.index,S[0]):(this.goToEnd(),"")},t.prototype.advanceUntilChar=function(_){for(;this.position<this.source.length;){if(this.source.charCodeAt(this.position)===_)return!0;this.advance(1)}return!1},t.prototype.advanceUntilChars=function(_){for(;this.position+_.length<=this.source.length;){for(var S=0;S<_.length&&this.source.charCodeAt(this.position+S)===_[S];S++);if(S===_.length)return!0;this.advance(1)}return this.goToEnd(),!1},t.prototype.skipWhitespace=function(){return this.advanceWhileChar((function(_){return _===Rt||_===Ct||_===Et||_===zt||_===Mt}))>0},t.prototype.advanceWhileChar=function(_){for(var S=this.position;this.position<this.len&&_(this.source.charCodeAt(this.position));)this.position++;return this.position-S},t}(),vt="!".charCodeAt(0),yt="-".charCodeAt(0),Tt="<".charCodeAt(0),kt=">".charCodeAt(0),St="/".charCodeAt(0),xt="=".charCodeAt(0),At='"'.charCodeAt(0),Lt="'".charCodeAt(0),Et="\n".charCodeAt(0),Mt="\r".charCodeAt(0),zt="\f".charCodeAt(0),Rt=" ".charCodeAt(0),Ct="\t".charCodeAt(0),It={"text/x-handlebars-template":!0,"text/html":!0};function $(_,S,x,L){void 0===S&&(S=0),void 0===x&&(x=lt.WithinContent),void 0===L&&(L=!1);var z,C,H,W,D,O=new wt(_,S),q=x,P=0,V=st.Unknown;function g(){return O.advanceIfRegExp(/^[_:\w][_:\w-.\d]*/).toLowerCase()}function m(_,S,x){return V=S,P=_,z=x,S}function E(){var _,S=O.pos();if(O.eos())return m(S,st.EOS);switch(q){case lt.WithinComment:return O.advanceIfChars([yt,yt,kt])?(q=lt.WithinContent,m(S,st.EndCommentTag)):(O.advanceUntilChars([yt,yt,kt]),m(S,st.Comment));case lt.WithinDoctype:return O.advanceIfChar(kt)?(q=lt.WithinContent,m(S,st.EndDoctypeTag)):(O.advanceUntilChar(kt),m(S,st.Doctype));case lt.WithinContent:if(O.advanceIfChar(Tt)){if(!O.eos()&&O.peekChar()===vt){if(O.advanceIfChars([vt,yt,yt]))return q=lt.WithinComment,m(S,st.StartCommentTag);if(O.advanceIfRegExp(/^!doctype/i))return q=lt.WithinDoctype,m(S,st.StartDoctypeTag)}return O.advanceIfChar(St)?(q=lt.AfterOpeningEndTag,m(S,st.EndTagOpen)):(q=lt.AfterOpeningStartTag,m(S,st.StartTagOpen))}return O.advanceUntilChar(Tt),m(S,st.Content);case lt.AfterOpeningEndTag:return g().length>0?(q=lt.WithinEndTag,m(S,st.EndTag)):O.skipWhitespace()?m(S,st.Whitespace,_t("error.unexpectedWhitespace","Tag name must directly follow the open bracket.")):(q=lt.WithinEndTag,O.advanceUntilChar(kt),S<O.pos()?m(S,st.Unknown,_t("error.endTagNameExpected","End tag name expected.")):E());case lt.WithinEndTag:if(O.skipWhitespace())return m(S,st.Whitespace);if(O.advanceIfChar(kt))return q=lt.WithinContent,m(S,st.EndTagClose);if(L&&O.peekChar()===Tt)return q=lt.WithinContent,m(S,st.EndTagClose,_t("error.closingBracketMissing","Closing bracket missing."));_=_t("error.closingBracketExpected","Closing bracket expected.");break;case lt.AfterOpeningStartTag:return H=g(),D=void 0,W=void 0,H.length>0?(C=!1,q=lt.WithinTag,m(S,st.StartTag)):O.skipWhitespace()?m(S,st.Whitespace,_t("error.unexpectedWhitespace","Tag name must directly follow the open bracket.")):(q=lt.WithinTag,O.advanceUntilChar(kt),S<O.pos()?m(S,st.Unknown,_t("error.startTagNameExpected","Start tag name expected.")):E());case lt.WithinTag:return O.skipWhitespace()?(C=!0,m(S,st.Whitespace)):C&&(W=function y(){return O.advanceIfRegExp(/^[^\s"'></=\x00-\x0F\x7F\x80-\x9F]*/).toLowerCase()}()).length>0?(q=lt.AfterAttributeName,C=!1,m(S,st.AttributeName)):O.advanceIfChars([St,kt])?(q=lt.WithinContent,m(S,st.StartTagSelfClose)):O.advanceIfChar(kt)?(q="script"===H?D&&It[D]?lt.WithinContent:lt.WithinScriptContent:"style"===H?lt.WithinStyleContent:lt.WithinContent,m(S,st.StartTagClose)):L&&O.peekChar()===Tt?(q=lt.WithinContent,m(S,st.StartTagClose,_t("error.closingBracketMissing","Closing bracket missing."))):(O.advance(1),m(S,st.Unknown,_t("error.unexpectedCharacterInTag","Unexpected character in tag.")));case lt.AfterAttributeName:return O.skipWhitespace()?(C=!0,m(S,st.Whitespace)):O.advanceIfChar(xt)?(q=lt.BeforeAttributeValue,m(S,st.DelimiterAssign)):(q=lt.WithinTag,E());case lt.BeforeAttributeValue:if(O.skipWhitespace())return m(S,st.Whitespace);var x=O.advanceIfRegExp(/^[^\s"'`=<>]+/);if(x.length>0)return O.peekChar()===kt&&O.peekChar(-1)===St&&(O.goBack(1),x=x.substr(0,x.length-1)),"type"===W&&(D=x),q=lt.WithinTag,C=!1,m(S,st.AttributeValue);var z=O.peekChar();return z===Lt||z===At?(O.advance(1),O.advanceUntilChar(z)&&O.advance(1),"type"===W&&(D=O.getSource().substring(S+1,O.pos()-1)),q=lt.WithinTag,C=!1,m(S,st.AttributeValue)):(q=lt.WithinTag,C=!1,E());case lt.WithinScriptContent:for(var P=1;!O.eos();){var V=O.advanceIfRegExp(/<!--|-->|<\/?script\s*\/?>?/i);if(0===V.length)return O.goToEnd(),m(S,st.Script);if("\x3c!--"===V)1===P&&(P=2);else if("--\x3e"===V)P=1;else if("/"!==V[1])2===P&&(P=3);else{if(3!==P){O.goBack(V.length);break}P=2}}return q=lt.WithinContent,S<O.pos()?m(S,st.Script):E();case lt.WithinStyleContent:return O.advanceUntilRegExp(/<\/style/i),q=lt.WithinContent,S<O.pos()?m(S,st.Styles):E()}return O.advance(1),q=lt.WithinContent,m(S,st.Unknown,_)}return{scan:function A(){var _=O.pos(),S=q,x=E();return x===st.EOS||_!==O.pos()||L&&(x===st.StartTagClose||x===st.EndTagClose)?x:(console.log("Scanner.scan has not advanced at offset "+_+", state before: "+S+" after: "+q),O.advance(1),m(_,st.Unknown))},getTokenType:function(){return V},getTokenOffset:function(){return P},getTokenLength:function(){return O.pos()-P},getTokenEnd:function(){return O.pos()},getTokenText:function(){return O.getSource().substring(P,O.pos())},getScannerState:function(){return q},getTokenError:function(){return z}}}function ht(_,S){var x=0,L=_.length;if(0===L)return 0;for(;x<L;){var z=Math.floor((x+L)/2);S(_[z])?L=z:x=z+1}return x}var Ht=["area","base","br","col","embed","hr","img","input","keygen","link","menuitem","meta","param","source","track","wbr"];function pe(_){return!!_&&function qt(_,S,x){for(var L=0,z=_.length-1;L<=z;){var C=(L+z)/2|0,H=x(_[C],S);if(H<0)L=C+1;else{if(!(H>0))return C;z=C-1}}return-(L+1)}(Ht,_.toLowerCase(),(function(_,S){return _.localeCompare(S)}))>=0}var Ut=function(){function t(_,S,x,L){this.start=_,this.end=S,this.children=x,this.parent=L,this.closed=!1}return Object.defineProperty(t.prototype,"attributeNames",{get:function(){return this.attributes?Object.keys(this.attributes):[]},enumerable:!1,configurable:!0}),t.prototype.isSameTag=function(_){return void 0===this.tag?void 0===_:void 0!==_&&this.tag.length===_.length&&this.tag.toLowerCase()===_},Object.defineProperty(t.prototype,"firstChild",{get:function(){return this.children[0]},enumerable:!1,configurable:!0}),Object.defineProperty(t.prototype,"lastChild",{get:function(){return this.children.length?this.children[this.children.length-1]:void 0},enumerable:!1,configurable:!0}),t.prototype.findNodeBefore=function(_){var S=ht(this.children,(function(S){return _<=S.start}))-1;if(S>=0){var x=this.children[S];if(_>x.start){if(_<x.end)return x.findNodeBefore(_);var L=x.lastChild;return L&&L.end===x.end?x.findNodeBefore(_):x}}return this},t.prototype.findNodeAt=function(_){var S=ht(this.children,(function(S){return _<=S.start}))-1;if(S>=0){var x=this.children[S];if(_>x.start&&_<=x.end)return x.findNodeAt(_)}return this},t}();function je(_){for(var S=$(_,void 0,void 0,!0),x=new Ut(0,_.length,[],void 0),L=x,z=-1,C=void 0,H=null,W=S.scan();W!==st.EOS;){switch(W){case st.StartTagOpen:var D=new Ut(S.getTokenOffset(),_.length,[],L);L.children.push(D),L=D;break;case st.StartTag:L.tag=S.getTokenText();break;case st.StartTagClose:L.parent&&(L.end=S.getTokenEnd(),S.getTokenLength()?(L.startTagEnd=S.getTokenEnd(),L.tag&&pe(L.tag)&&(L.closed=!0,L=L.parent)):L=L.parent);break;case st.StartTagSelfClose:L.parent&&(L.closed=!0,L.end=S.getTokenEnd(),L.startTagEnd=S.getTokenEnd(),L=L.parent);break;case st.EndTagOpen:z=S.getTokenOffset(),C=void 0;break;case st.EndTag:C=S.getTokenText().toLowerCase();break;case st.EndTagClose:for(var O=L;!O.isSameTag(C)&&O.parent;)O=O.parent;if(O.parent){for(;L!==O;)L.end=z,L.closed=!1,L=L.parent;L.closed=!0,L.endTagStart=z,L.end=S.getTokenEnd(),L=L.parent}break;case st.AttributeName:H=S.getTokenText(),(q=L.attributes)||(L.attributes=q={}),q[H]=null;break;case st.AttributeValue:var q,P=S.getTokenText();(q=L.attributes)&&H&&(q[H]=P,H=null)}W=S.scan()}for(;L.parent;)L.end=_.length,L.closed=!1,L=L.parent;return{roots:x.children,findNodeBefore:x.findNodeBefore.bind(x),findNodeAt:x.findNodeAt.bind(x)}}var Wt={"Aacute;":"Á",Aacute:"Á","aacute;":"á",aacute:"á","Abreve;":"Ă","abreve;":"ă","ac;":"∾","acd;":"∿","acE;":"∾̳","Acirc;":"Â",Acirc:"Â","acirc;":"â",acirc:"â","acute;":"´",acute:"´","Acy;":"А","acy;":"а","AElig;":"Æ",AElig:"Æ","aelig;":"æ",aelig:"æ","af;":"⁡","Afr;":"𝔄","afr;":"𝔞","Agrave;":"À",Agrave:"À","agrave;":"à",agrave:"à","alefsym;":"ℵ","aleph;":"ℵ","Alpha;":"Α","alpha;":"α","Amacr;":"Ā","amacr;":"ā","amalg;":"⨿","AMP;":"&",AMP:"&","amp;":"&",amp:"&","And;":"⩓","and;":"∧","andand;":"⩕","andd;":"⩜","andslope;":"⩘","andv;":"⩚","ang;":"∠","ange;":"⦤","angle;":"∠","angmsd;":"∡","angmsdaa;":"⦨","angmsdab;":"⦩","angmsdac;":"⦪","angmsdad;":"⦫","angmsdae;":"⦬","angmsdaf;":"⦭","angmsdag;":"⦮","angmsdah;":"⦯","angrt;":"∟","angrtvb;":"⊾","angrtvbd;":"⦝","angsph;":"∢","angst;":"Å","angzarr;":"⍼","Aogon;":"Ą","aogon;":"ą","Aopf;":"𝔸","aopf;":"𝕒","ap;":"≈","apacir;":"⩯","apE;":"⩰","ape;":"≊","apid;":"≋","apos;":"'","ApplyFunction;":"⁡","approx;":"≈","approxeq;":"≊","Aring;":"Å",Aring:"Å","aring;":"å",aring:"å","Ascr;":"𝒜","ascr;":"𝒶","Assign;":"≔","ast;":"*","asymp;":"≈","asympeq;":"≍","Atilde;":"Ã",Atilde:"Ã","atilde;":"ã",atilde:"ã","Auml;":"Ä",Auml:"Ä","auml;":"ä",auml:"ä","awconint;":"∳","awint;":"⨑","backcong;":"≌","backepsilon;":"϶","backprime;":"‵","backsim;":"∽","backsimeq;":"⋍","Backslash;":"∖","Barv;":"⫧","barvee;":"⊽","Barwed;":"⌆","barwed;":"⌅","barwedge;":"⌅","bbrk;":"⎵","bbrktbrk;":"⎶","bcong;":"≌","Bcy;":"Б","bcy;":"б","bdquo;":"„","becaus;":"∵","Because;":"∵","because;":"∵","bemptyv;":"⦰","bepsi;":"϶","bernou;":"ℬ","Bernoullis;":"ℬ","Beta;":"Β","beta;":"β","beth;":"ℶ","between;":"≬","Bfr;":"𝔅","bfr;":"𝔟","bigcap;":"⋂","bigcirc;":"◯","bigcup;":"⋃","bigodot;":"⨀","bigoplus;":"⨁","bigotimes;":"⨂","bigsqcup;":"⨆","bigstar;":"★","bigtriangledown;":"▽","bigtriangleup;":"△","biguplus;":"⨄","bigvee;":"⋁","bigwedge;":"⋀","bkarow;":"⤍","blacklozenge;":"⧫","blacksquare;":"▪","blacktriangle;":"▴","blacktriangledown;":"▾","blacktriangleleft;":"◂","blacktriangleright;":"▸","blank;":"␣","blk12;":"▒","blk14;":"░","blk34;":"▓","block;":"█","bne;":"=⃥","bnequiv;":"≡⃥","bNot;":"⫭","bnot;":"⌐","Bopf;":"𝔹","bopf;":"𝕓","bot;":"⊥","bottom;":"⊥","bowtie;":"⋈","boxbox;":"⧉","boxDL;":"╗","boxDl;":"╖","boxdL;":"╕","boxdl;":"┐","boxDR;":"╔","boxDr;":"╓","boxdR;":"╒","boxdr;":"┌","boxH;":"═","boxh;":"─","boxHD;":"╦","boxHd;":"╤","boxhD;":"╥","boxhd;":"┬","boxHU;":"╩","boxHu;":"╧","boxhU;":"╨","boxhu;":"┴","boxminus;":"⊟","boxplus;":"⊞","boxtimes;":"⊠","boxUL;":"╝","boxUl;":"╜","boxuL;":"╛","boxul;":"┘","boxUR;":"╚","boxUr;":"╙","boxuR;":"╘","boxur;":"└","boxV;":"║","boxv;":"│","boxVH;":"╬","boxVh;":"╫","boxvH;":"╪","boxvh;":"┼","boxVL;":"╣","boxVl;":"╢","boxvL;":"╡","boxvl;":"┤","boxVR;":"╠","boxVr;":"╟","boxvR;":"╞","boxvr;":"├","bprime;":"‵","Breve;":"˘","breve;":"˘","brvbar;":"¦",brvbar:"¦","Bscr;":"ℬ","bscr;":"𝒷","bsemi;":"⁏","bsim;":"∽","bsime;":"⋍","bsol;":"\\","bsolb;":"⧅","bsolhsub;":"⟈","bull;":"•","bullet;":"•","bump;":"≎","bumpE;":"⪮","bumpe;":"≏","Bumpeq;":"≎","bumpeq;":"≏","Cacute;":"Ć","cacute;":"ć","Cap;":"⋒","cap;":"∩","capand;":"⩄","capbrcup;":"⩉","capcap;":"⩋","capcup;":"⩇","capdot;":"⩀","CapitalDifferentialD;":"ⅅ","caps;":"∩︀","caret;":"⁁","caron;":"ˇ","Cayleys;":"ℭ","ccaps;":"⩍","Ccaron;":"Č","ccaron;":"č","Ccedil;":"Ç",Ccedil:"Ç","ccedil;":"ç",ccedil:"ç","Ccirc;":"Ĉ","ccirc;":"ĉ","Cconint;":"∰","ccups;":"⩌","ccupssm;":"⩐","Cdot;":"Ċ","cdot;":"ċ","cedil;":"¸",cedil:"¸","Cedilla;":"¸","cemptyv;":"⦲","cent;":"¢",cent:"¢","CenterDot;":"·","centerdot;":"·","Cfr;":"ℭ","cfr;":"𝔠","CHcy;":"Ч","chcy;":"ч","check;":"✓","checkmark;":"✓","Chi;":"Χ","chi;":"χ","cir;":"○","circ;":"ˆ","circeq;":"≗","circlearrowleft;":"↺","circlearrowright;":"↻","circledast;":"⊛","circledcirc;":"⊚","circleddash;":"⊝","CircleDot;":"⊙","circledR;":"®","circledS;":"Ⓢ","CircleMinus;":"⊖","CirclePlus;":"⊕","CircleTimes;":"⊗","cirE;":"⧃","cire;":"≗","cirfnint;":"⨐","cirmid;":"⫯","cirscir;":"⧂","ClockwiseContourIntegral;":"∲","CloseCurlyDoubleQuote;":"”","CloseCurlyQuote;":"’","clubs;":"♣","clubsuit;":"♣","Colon;":"∷","colon;":":","Colone;":"⩴","colone;":"≔","coloneq;":"≔","comma;":",","commat;":"@","comp;":"∁","compfn;":"∘","complement;":"∁","complexes;":"ℂ","cong;":"≅","congdot;":"⩭","Congruent;":"≡","Conint;":"∯","conint;":"∮","ContourIntegral;":"∮","Copf;":"ℂ","copf;":"𝕔","coprod;":"∐","Coproduct;":"∐","COPY;":"©",COPY:"©","copy;":"©",copy:"©","copysr;":"℗","CounterClockwiseContourIntegral;":"∳","crarr;":"↵","Cross;":"⨯","cross;":"✗","Cscr;":"𝒞","cscr;":"𝒸","csub;":"⫏","csube;":"⫑","csup;":"⫐","csupe;":"⫒","ctdot;":"⋯","cudarrl;":"⤸","cudarrr;":"⤵","cuepr;":"⋞","cuesc;":"⋟","cularr;":"↶","cularrp;":"⤽","Cup;":"⋓","cup;":"∪","cupbrcap;":"⩈","CupCap;":"≍","cupcap;":"⩆","cupcup;":"⩊","cupdot;":"⊍","cupor;":"⩅","cups;":"∪︀","curarr;":"↷","curarrm;":"⤼","curlyeqprec;":"⋞","curlyeqsucc;":"⋟","curlyvee;":"⋎","curlywedge;":"⋏","curren;":"¤",curren:"¤","curvearrowleft;":"↶","curvearrowright;":"↷","cuvee;":"⋎","cuwed;":"⋏","cwconint;":"∲","cwint;":"∱","cylcty;":"⌭","Dagger;":"‡","dagger;":"†","daleth;":"ℸ","Darr;":"↡","dArr;":"⇓","darr;":"↓","dash;":"‐","Dashv;":"⫤","dashv;":"⊣","dbkarow;":"⤏","dblac;":"˝","Dcaron;":"Ď","dcaron;":"ď","Dcy;":"Д","dcy;":"д","DD;":"ⅅ","dd;":"ⅆ","ddagger;":"‡","ddarr;":"⇊","DDotrahd;":"⤑","ddotseq;":"⩷","deg;":"°",deg:"°","Del;":"∇","Delta;":"Δ","delta;":"δ","demptyv;":"⦱","dfisht;":"⥿","Dfr;":"𝔇","dfr;":"𝔡","dHar;":"⥥","dharl;":"⇃","dharr;":"⇂","DiacriticalAcute;":"´","DiacriticalDot;":"˙","DiacriticalDoubleAcute;":"˝","DiacriticalGrave;":"`","DiacriticalTilde;":"˜","diam;":"⋄","Diamond;":"⋄","diamond;":"⋄","diamondsuit;":"♦","diams;":"♦","die;":"¨","DifferentialD;":"ⅆ","digamma;":"ϝ","disin;":"⋲","div;":"÷","divide;":"÷",divide:"÷","divideontimes;":"⋇","divonx;":"⋇","DJcy;":"Ђ","djcy;":"ђ","dlcorn;":"⌞","dlcrop;":"⌍","dollar;":"$","Dopf;":"𝔻","dopf;":"𝕕","Dot;":"¨","dot;":"˙","DotDot;":"⃜","doteq;":"≐","doteqdot;":"≑","DotEqual;":"≐","dotminus;":"∸","dotplus;":"∔","dotsquare;":"⊡","doublebarwedge;":"⌆","DoubleContourIntegral;":"∯","DoubleDot;":"¨","DoubleDownArrow;":"⇓","DoubleLeftArrow;":"⇐","DoubleLeftRightArrow;":"⇔","DoubleLeftTee;":"⫤","DoubleLongLeftArrow;":"⟸","DoubleLongLeftRightArrow;":"⟺","DoubleLongRightArrow;":"⟹","DoubleRightArrow;":"⇒","DoubleRightTee;":"⊨","DoubleUpArrow;":"⇑","DoubleUpDownArrow;":"⇕","DoubleVerticalBar;":"∥","DownArrow;":"↓","Downarrow;":"⇓","downarrow;":"↓","DownArrowBar;":"⤓","DownArrowUpArrow;":"⇵","DownBreve;":"̑","downdownarrows;":"⇊","downharpoonleft;":"⇃","downharpoonright;":"⇂","DownLeftRightVector;":"⥐","DownLeftTeeVector;":"⥞","DownLeftVector;":"↽","DownLeftVectorBar;":"⥖","DownRightTeeVector;":"⥟","DownRightVector;":"⇁","DownRightVectorBar;":"⥗","DownTee;":"⊤","DownTeeArrow;":"↧","drbkarow;":"⤐","drcorn;":"⌟","drcrop;":"⌌","Dscr;":"𝒟","dscr;":"𝒹","DScy;":"Ѕ","dscy;":"ѕ","dsol;":"⧶","Dstrok;":"Đ","dstrok;":"đ","dtdot;":"⋱","dtri;":"▿","dtrif;":"▾","duarr;":"⇵","duhar;":"⥯","dwangle;":"⦦","DZcy;":"Џ","dzcy;":"џ","dzigrarr;":"⟿","Eacute;":"É",Eacute:"É","eacute;":"é",eacute:"é","easter;":"⩮","Ecaron;":"Ě","ecaron;":"ě","ecir;":"≖","Ecirc;":"Ê",Ecirc:"Ê","ecirc;":"ê",ecirc:"ê","ecolon;":"≕","Ecy;":"Э","ecy;":"э","eDDot;":"⩷","Edot;":"Ė","eDot;":"≑","edot;":"ė","ee;":"ⅇ","efDot;":"≒","Efr;":"𝔈","efr;":"𝔢","eg;":"⪚","Egrave;":"È",Egrave:"È","egrave;":"è",egrave:"è","egs;":"⪖","egsdot;":"⪘","el;":"⪙","Element;":"∈","elinters;":"⏧","ell;":"ℓ","els;":"⪕","elsdot;":"⪗","Emacr;":"Ē","emacr;":"ē","empty;":"∅","emptyset;":"∅","EmptySmallSquare;":"◻","emptyv;":"∅","EmptyVerySmallSquare;":"▫","emsp;":" ","emsp13;":" ","emsp14;":" ","ENG;":"Ŋ","eng;":"ŋ","ensp;":" ","Eogon;":"Ę","eogon;":"ę","Eopf;":"𝔼","eopf;":"𝕖","epar;":"⋕","eparsl;":"⧣","eplus;":"⩱","epsi;":"ε","Epsilon;":"Ε","epsilon;":"ε","epsiv;":"ϵ","eqcirc;":"≖","eqcolon;":"≕","eqsim;":"≂","eqslantgtr;":"⪖","eqslantless;":"⪕","Equal;":"⩵","equals;":"=","EqualTilde;":"≂","equest;":"≟","Equilibrium;":"⇌","equiv;":"≡","equivDD;":"⩸","eqvparsl;":"⧥","erarr;":"⥱","erDot;":"≓","Escr;":"ℰ","escr;":"ℯ","esdot;":"≐","Esim;":"⩳","esim;":"≂","Eta;":"Η","eta;":"η","ETH;":"Ð",ETH:"Ð","eth;":"ð",eth:"ð","Euml;":"Ë",Euml:"Ë","euml;":"ë",euml:"ë","euro;":"€","excl;":"!","exist;":"∃","Exists;":"∃","expectation;":"ℰ","ExponentialE;":"ⅇ","exponentiale;":"ⅇ","fallingdotseq;":"≒","Fcy;":"Ф","fcy;":"ф","female;":"♀","ffilig;":"ﬃ","fflig;":"ﬀ","ffllig;":"ﬄ","Ffr;":"𝔉","ffr;":"𝔣","filig;":"ﬁ","FilledSmallSquare;":"◼","FilledVerySmallSquare;":"▪","fjlig;":"fj","flat;":"♭","fllig;":"ﬂ","fltns;":"▱","fnof;":"ƒ","Fopf;":"𝔽","fopf;":"𝕗","ForAll;":"∀","forall;":"∀","fork;":"⋔","forkv;":"⫙","Fouriertrf;":"ℱ","fpartint;":"⨍","frac12;":"½",frac12:"½","frac13;":"⅓","frac14;":"¼",frac14:"¼","frac15;":"⅕","frac16;":"⅙","frac18;":"⅛","frac23;":"⅔","frac25;":"⅖","frac34;":"¾",frac34:"¾","frac35;":"⅗","frac38;":"⅜","frac45;":"⅘","frac56;":"⅚","frac58;":"⅝","frac78;":"⅞","frasl;":"⁄","frown;":"⌢","Fscr;":"ℱ","fscr;":"𝒻","gacute;":"ǵ","Gamma;":"Γ","gamma;":"γ","Gammad;":"Ϝ","gammad;":"ϝ","gap;":"⪆","Gbreve;":"Ğ","gbreve;":"ğ","Gcedil;":"Ģ","Gcirc;":"Ĝ","gcirc;":"ĝ","Gcy;":"Г","gcy;":"г","Gdot;":"Ġ","gdot;":"ġ","gE;":"≧","ge;":"≥","gEl;":"⪌","gel;":"⋛","geq;":"≥","geqq;":"≧","geqslant;":"⩾","ges;":"⩾","gescc;":"⪩","gesdot;":"⪀","gesdoto;":"⪂","gesdotol;":"⪄","gesl;":"⋛︀","gesles;":"⪔","Gfr;":"𝔊","gfr;":"𝔤","Gg;":"⋙","gg;":"≫","ggg;":"⋙","gimel;":"ℷ","GJcy;":"Ѓ","gjcy;":"ѓ","gl;":"≷","gla;":"⪥","glE;":"⪒","glj;":"⪤","gnap;":"⪊","gnapprox;":"⪊","gnE;":"≩","gne;":"⪈","gneq;":"⪈","gneqq;":"≩","gnsim;":"⋧","Gopf;":"𝔾","gopf;":"𝕘","grave;":"`","GreaterEqual;":"≥","GreaterEqualLess;":"⋛","GreaterFullEqual;":"≧","GreaterGreater;":"⪢","GreaterLess;":"≷","GreaterSlantEqual;":"⩾","GreaterTilde;":"≳","Gscr;":"𝒢","gscr;":"ℊ","gsim;":"≳","gsime;":"⪎","gsiml;":"⪐","GT;":">",GT:">","Gt;":"≫","gt;":">",gt:">","gtcc;":"⪧","gtcir;":"⩺","gtdot;":"⋗","gtlPar;":"⦕","gtquest;":"⩼","gtrapprox;":"⪆","gtrarr;":"⥸","gtrdot;":"⋗","gtreqless;":"⋛","gtreqqless;":"⪌","gtrless;":"≷","gtrsim;":"≳","gvertneqq;":"≩︀","gvnE;":"≩︀","Hacek;":"ˇ","hairsp;":" ","half;":"½","hamilt;":"ℋ","HARDcy;":"Ъ","hardcy;":"ъ","hArr;":"⇔","harr;":"↔","harrcir;":"⥈","harrw;":"↭","Hat;":"^","hbar;":"ℏ","Hcirc;":"Ĥ","hcirc;":"ĥ","hearts;":"♥","heartsuit;":"♥","hellip;":"…","hercon;":"⊹","Hfr;":"ℌ","hfr;":"𝔥","HilbertSpace;":"ℋ","hksearow;":"⤥","hkswarow;":"⤦","hoarr;":"⇿","homtht;":"∻","hookleftarrow;":"↩","hookrightarrow;":"↪","Hopf;":"ℍ","hopf;":"𝕙","horbar;":"―","HorizontalLine;":"─","Hscr;":"ℋ","hscr;":"𝒽","hslash;":"ℏ","Hstrok;":"Ħ","hstrok;":"ħ","HumpDownHump;":"≎","HumpEqual;":"≏","hybull;":"⁃","hyphen;":"‐","Iacute;":"Í",Iacute:"Í","iacute;":"í",iacute:"í","ic;":"⁣","Icirc;":"Î",Icirc:"Î","icirc;":"î",icirc:"î","Icy;":"И","icy;":"и","Idot;":"İ","IEcy;":"Е","iecy;":"е","iexcl;":"¡",iexcl:"¡","iff;":"⇔","Ifr;":"ℑ","ifr;":"𝔦","Igrave;":"Ì",Igrave:"Ì","igrave;":"ì",igrave:"ì","ii;":"ⅈ","iiiint;":"⨌","iiint;":"∭","iinfin;":"⧜","iiota;":"℩","IJlig;":"Ĳ","ijlig;":"ĳ","Im;":"ℑ","Imacr;":"Ī","imacr;":"ī","image;":"ℑ","ImaginaryI;":"ⅈ","imagline;":"ℐ","imagpart;":"ℑ","imath;":"ı","imof;":"⊷","imped;":"Ƶ","Implies;":"⇒","in;":"∈","incare;":"℅","infin;":"∞","infintie;":"⧝","inodot;":"ı","Int;":"∬","int;":"∫","intcal;":"⊺","integers;":"ℤ","Integral;":"∫","intercal;":"⊺","Intersection;":"⋂","intlarhk;":"⨗","intprod;":"⨼","InvisibleComma;":"⁣","InvisibleTimes;":"⁢","IOcy;":"Ё","iocy;":"ё","Iogon;":"Į","iogon;":"į","Iopf;":"𝕀","iopf;":"𝕚","Iota;":"Ι","iota;":"ι","iprod;":"⨼","iquest;":"¿",iquest:"¿","Iscr;":"ℐ","iscr;":"𝒾","isin;":"∈","isindot;":"⋵","isinE;":"⋹","isins;":"⋴","isinsv;":"⋳","isinv;":"∈","it;":"⁢","Itilde;":"Ĩ","itilde;":"ĩ","Iukcy;":"І","iukcy;":"і","Iuml;":"Ï",Iuml:"Ï","iuml;":"ï",iuml:"ï","Jcirc;":"Ĵ","jcirc;":"ĵ","Jcy;":"Й","jcy;":"й","Jfr;":"𝔍","jfr;":"𝔧","jmath;":"ȷ","Jopf;":"𝕁","jopf;":"𝕛","Jscr;":"𝒥","jscr;":"𝒿","Jsercy;":"Ј","jsercy;":"ј","Jukcy;":"Є","jukcy;":"є","Kappa;":"Κ","kappa;":"κ","kappav;":"ϰ","Kcedil;":"Ķ","kcedil;":"ķ","Kcy;":"К","kcy;":"к","Kfr;":"𝔎","kfr;":"𝔨","kgreen;":"ĸ","KHcy;":"Х","khcy;":"х","KJcy;":"Ќ","kjcy;":"ќ","Kopf;":"𝕂","kopf;":"𝕜","Kscr;":"𝒦","kscr;":"𝓀","lAarr;":"⇚","Lacute;":"Ĺ","lacute;":"ĺ","laemptyv;":"⦴","lagran;":"ℒ","Lambda;":"Λ","lambda;":"λ","Lang;":"⟪","lang;":"⟨","langd;":"⦑","langle;":"⟨","lap;":"⪅","Laplacetrf;":"ℒ","laquo;":"«",laquo:"«","Larr;":"↞","lArr;":"⇐","larr;":"←","larrb;":"⇤","larrbfs;":"⤟","larrfs;":"⤝","larrhk;":"↩","larrlp;":"↫","larrpl;":"⤹","larrsim;":"⥳","larrtl;":"↢","lat;":"⪫","lAtail;":"⤛","latail;":"⤙","late;":"⪭","lates;":"⪭︀","lBarr;":"⤎","lbarr;":"⤌","lbbrk;":"❲","lbrace;":"{","lbrack;":"[","lbrke;":"⦋","lbrksld;":"⦏","lbrkslu;":"⦍","Lcaron;":"Ľ","lcaron;":"ľ","Lcedil;":"Ļ","lcedil;":"ļ","lceil;":"⌈","lcub;":"{","Lcy;":"Л","lcy;":"л","ldca;":"⤶","ldquo;":"“","ldquor;":"„","ldrdhar;":"⥧","ldrushar;":"⥋","ldsh;":"↲","lE;":"≦","le;":"≤","LeftAngleBracket;":"⟨","LeftArrow;":"←","Leftarrow;":"⇐","leftarrow;":"←","LeftArrowBar;":"⇤","LeftArrowRightArrow;":"⇆","leftarrowtail;":"↢","LeftCeiling;":"⌈","LeftDoubleBracket;":"⟦","LeftDownTeeVector;":"⥡","LeftDownVector;":"⇃","LeftDownVectorBar;":"⥙","LeftFloor;":"⌊","leftharpoondown;":"↽","leftharpoonup;":"↼","leftleftarrows;":"⇇","LeftRightArrow;":"↔","Leftrightarrow;":"⇔","leftrightarrow;":"↔","leftrightarrows;":"⇆","leftrightharpoons;":"⇋","leftrightsquigarrow;":"↭","LeftRightVector;":"⥎","LeftTee;":"⊣","LeftTeeArrow;":"↤","LeftTeeVector;":"⥚","leftthreetimes;":"⋋","LeftTriangle;":"⊲","LeftTriangleBar;":"⧏","LeftTriangleEqual;":"⊴","LeftUpDownVector;":"⥑","LeftUpTeeVector;":"⥠","LeftUpVector;":"↿","LeftUpVectorBar;":"⥘","LeftVector;":"↼","LeftVectorBar;":"⥒","lEg;":"⪋","leg;":"⋚","leq;":"≤","leqq;":"≦","leqslant;":"⩽","les;":"⩽","lescc;":"⪨","lesdot;":"⩿","lesdoto;":"⪁","lesdotor;":"⪃","lesg;":"⋚︀","lesges;":"⪓","lessapprox;":"⪅","lessdot;":"⋖","lesseqgtr;":"⋚","lesseqqgtr;":"⪋","LessEqualGreater;":"⋚","LessFullEqual;":"≦","LessGreater;":"≶","lessgtr;":"≶","LessLess;":"⪡","lesssim;":"≲","LessSlantEqual;":"⩽","LessTilde;":"≲","lfisht;":"⥼","lfloor;":"⌊","Lfr;":"𝔏","lfr;":"𝔩","lg;":"≶","lgE;":"⪑","lHar;":"⥢","lhard;":"↽","lharu;":"↼","lharul;":"⥪","lhblk;":"▄","LJcy;":"Љ","ljcy;":"љ","Ll;":"⋘","ll;":"≪","llarr;":"⇇","llcorner;":"⌞","Lleftarrow;":"⇚","llhard;":"⥫","lltri;":"◺","Lmidot;":"Ŀ","lmidot;":"ŀ","lmoust;":"⎰","lmoustache;":"⎰","lnap;":"⪉","lnapprox;":"⪉","lnE;":"≨","lne;":"⪇","lneq;":"⪇","lneqq;":"≨","lnsim;":"⋦","loang;":"⟬","loarr;":"⇽","lobrk;":"⟦","LongLeftArrow;":"⟵","Longleftarrow;":"⟸","longleftarrow;":"⟵","LongLeftRightArrow;":"⟷","Longleftrightarrow;":"⟺","longleftrightarrow;":"⟷","longmapsto;":"⟼","LongRightArrow;":"⟶","Longrightarrow;":"⟹","longrightarrow;":"⟶","looparrowleft;":"↫","looparrowright;":"↬","lopar;":"⦅","Lopf;":"𝕃","lopf;":"𝕝","loplus;":"⨭","lotimes;":"⨴","lowast;":"∗","lowbar;":"_","LowerLeftArrow;":"↙","LowerRightArrow;":"↘","loz;":"◊","lozenge;":"◊","lozf;":"⧫","lpar;":"(","lparlt;":"⦓","lrarr;":"⇆","lrcorner;":"⌟","lrhar;":"⇋","lrhard;":"⥭","lrm;":"‎","lrtri;":"⊿","lsaquo;":"‹","Lscr;":"ℒ","lscr;":"𝓁","Lsh;":"↰","lsh;":"↰","lsim;":"≲","lsime;":"⪍","lsimg;":"⪏","lsqb;":"[","lsquo;":"‘","lsquor;":"‚","Lstrok;":"Ł","lstrok;":"ł","LT;":"<",LT:"<","Lt;":"≪","lt;":"<",lt:"<","ltcc;":"⪦","ltcir;":"⩹","ltdot;":"⋖","lthree;":"⋋","ltimes;":"⋉","ltlarr;":"⥶","ltquest;":"⩻","ltri;":"◃","ltrie;":"⊴","ltrif;":"◂","ltrPar;":"⦖","lurdshar;":"⥊","luruhar;":"⥦","lvertneqq;":"≨︀","lvnE;":"≨︀","macr;":"¯",macr:"¯","male;":"♂","malt;":"✠","maltese;":"✠","Map;":"⤅","map;":"↦","mapsto;":"↦","mapstodown;":"↧","mapstoleft;":"↤","mapstoup;":"↥","marker;":"▮","mcomma;":"⨩","Mcy;":"М","mcy;":"м","mdash;":"—","mDDot;":"∺","measuredangle;":"∡","MediumSpace;":" ","Mellintrf;":"ℳ","Mfr;":"𝔐","mfr;":"𝔪","mho;":"℧","micro;":"µ",micro:"µ","mid;":"∣","midast;":"*","midcir;":"⫰","middot;":"·",middot:"·","minus;":"−","minusb;":"⊟","minusd;":"∸","minusdu;":"⨪","MinusPlus;":"∓","mlcp;":"⫛","mldr;":"…","mnplus;":"∓","models;":"⊧","Mopf;":"𝕄","mopf;":"𝕞","mp;":"∓","Mscr;":"ℳ","mscr;":"𝓂","mstpos;":"∾","Mu;":"Μ","mu;":"μ","multimap;":"⊸","mumap;":"⊸","nabla;":"∇","Nacute;":"Ń","nacute;":"ń","nang;":"∠⃒","nap;":"≉","napE;":"⩰̸","napid;":"≋̸","napos;":"ŉ","napprox;":"≉","natur;":"♮","natural;":"♮","naturals;":"ℕ","nbsp;":" ",nbsp:" ","nbump;":"≎̸","nbumpe;":"≏̸","ncap;":"⩃","Ncaron;":"Ň","ncaron;":"ň","Ncedil;":"Ņ","ncedil;":"ņ","ncong;":"≇","ncongdot;":"⩭̸","ncup;":"⩂","Ncy;":"Н","ncy;":"н","ndash;":"–","ne;":"≠","nearhk;":"⤤","neArr;":"⇗","nearr;":"↗","nearrow;":"↗","nedot;":"≐̸","NegativeMediumSpace;":"​","NegativeThickSpace;":"​","NegativeThinSpace;":"​","NegativeVeryThinSpace;":"​","nequiv;":"≢","nesear;":"⤨","nesim;":"≂̸","NestedGreaterGreater;":"≫","NestedLessLess;":"≪","NewLine;":"\n","nexist;":"∄","nexists;":"∄","Nfr;":"𝔑","nfr;":"𝔫","ngE;":"≧̸","nge;":"≱","ngeq;":"≱","ngeqq;":"≧̸","ngeqslant;":"⩾̸","nges;":"⩾̸","nGg;":"⋙̸","ngsim;":"≵","nGt;":"≫⃒","ngt;":"≯","ngtr;":"≯","nGtv;":"≫̸","nhArr;":"⇎","nharr;":"↮","nhpar;":"⫲","ni;":"∋","nis;":"⋼","nisd;":"⋺","niv;":"∋","NJcy;":"Њ","njcy;":"њ","nlArr;":"⇍","nlarr;":"↚","nldr;":"‥","nlE;":"≦̸","nle;":"≰","nLeftarrow;":"⇍","nleftarrow;":"↚","nLeftrightarrow;":"⇎","nleftrightarrow;":"↮","nleq;":"≰","nleqq;":"≦̸","nleqslant;":"⩽̸","nles;":"⩽̸","nless;":"≮","nLl;":"⋘̸","nlsim;":"≴","nLt;":"≪⃒","nlt;":"≮","nltri;":"⋪","nltrie;":"⋬","nLtv;":"≪̸","nmid;":"∤","NoBreak;":"⁠","NonBreakingSpace;":" ","Nopf;":"ℕ","nopf;":"𝕟","Not;":"⫬","not;":"¬",not:"¬","NotCongruent;":"≢","NotCupCap;":"≭","NotDoubleVerticalBar;":"∦","NotElement;":"∉","NotEqual;":"≠","NotEqualTilde;":"≂̸","NotExists;":"∄","NotGreater;":"≯","NotGreaterEqual;":"≱","NotGreaterFullEqual;":"≧̸","NotGreaterGreater;":"≫̸","NotGreaterLess;":"≹","NotGreaterSlantEqual;":"⩾̸","NotGreaterTilde;":"≵","NotHumpDownHump;":"≎̸","NotHumpEqual;":"≏̸","notin;":"∉","notindot;":"⋵̸","notinE;":"⋹̸","notinva;":"∉","notinvb;":"⋷","notinvc;":"⋶","NotLeftTriangle;":"⋪","NotLeftTriangleBar;":"⧏̸","NotLeftTriangleEqual;":"⋬","NotLess;":"≮","NotLessEqual;":"≰","NotLessGreater;":"≸","NotLessLess;":"≪̸","NotLessSlantEqual;":"⩽̸","NotLessTilde;":"≴","NotNestedGreaterGreater;":"⪢̸","NotNestedLessLess;":"⪡̸","notni;":"∌","notniva;":"∌","notnivb;":"⋾","notnivc;":"⋽","NotPrecedes;":"⊀","NotPrecedesEqual;":"⪯̸","NotPrecedesSlantEqual;":"⋠","NotReverseElement;":"∌","NotRightTriangle;":"⋫","NotRightTriangleBar;":"⧐̸","NotRightTriangleEqual;":"⋭","NotSquareSubset;":"⊏̸","NotSquareSubsetEqual;":"⋢","NotSquareSuperset;":"⊐̸","NotSquareSupersetEqual;":"⋣","NotSubset;":"⊂⃒","NotSubsetEqual;":"⊈","NotSucceeds;":"⊁","NotSucceedsEqual;":"⪰̸","NotSucceedsSlantEqual;":"⋡","NotSucceedsTilde;":"≿̸","NotSuperset;":"⊃⃒","NotSupersetEqual;":"⊉","NotTilde;":"≁","NotTildeEqual;":"≄","NotTildeFullEqual;":"≇","NotTildeTilde;":"≉","NotVerticalBar;":"∤","npar;":"∦","nparallel;":"∦","nparsl;":"⫽⃥","npart;":"∂̸","npolint;":"⨔","npr;":"⊀","nprcue;":"⋠","npre;":"⪯̸","nprec;":"⊀","npreceq;":"⪯̸","nrArr;":"⇏","nrarr;":"↛","nrarrc;":"⤳̸","nrarrw;":"↝̸","nRightarrow;":"⇏","nrightarrow;":"↛","nrtri;":"⋫","nrtrie;":"⋭","nsc;":"⊁","nsccue;":"⋡","nsce;":"⪰̸","Nscr;":"𝒩","nscr;":"𝓃","nshortmid;":"∤","nshortparallel;":"∦","nsim;":"≁","nsime;":"≄","nsimeq;":"≄","nsmid;":"∤","nspar;":"∦","nsqsube;":"⋢","nsqsupe;":"⋣","nsub;":"⊄","nsubE;":"⫅̸","nsube;":"⊈","nsubset;":"⊂⃒","nsubseteq;":"⊈","nsubseteqq;":"⫅̸","nsucc;":"⊁","nsucceq;":"⪰̸","nsup;":"⊅","nsupE;":"⫆̸","nsupe;":"⊉","nsupset;":"⊃⃒","nsupseteq;":"⊉","nsupseteqq;":"⫆̸","ntgl;":"≹","Ntilde;":"Ñ",Ntilde:"Ñ","ntilde;":"ñ",ntilde:"ñ","ntlg;":"≸","ntriangleleft;":"⋪","ntrianglelefteq;":"⋬","ntriangleright;":"⋫","ntrianglerighteq;":"⋭","Nu;":"Ν","nu;":"ν","num;":"#","numero;":"№","numsp;":" ","nvap;":"≍⃒","nVDash;":"⊯","nVdash;":"⊮","nvDash;":"⊭","nvdash;":"⊬","nvge;":"≥⃒","nvgt;":">⃒","nvHarr;":"⤄","nvinfin;":"⧞","nvlArr;":"⤂","nvle;":"≤⃒","nvlt;":"<⃒","nvltrie;":"⊴⃒","nvrArr;":"⤃","nvrtrie;":"⊵⃒","nvsim;":"∼⃒","nwarhk;":"⤣","nwArr;":"⇖","nwarr;":"↖","nwarrow;":"↖","nwnear;":"⤧","Oacute;":"Ó",Oacute:"Ó","oacute;":"ó",oacute:"ó","oast;":"⊛","ocir;":"⊚","Ocirc;":"Ô",Ocirc:"Ô","ocirc;":"ô",ocirc:"ô","Ocy;":"О","ocy;":"о","odash;":"⊝","Odblac;":"Ő","odblac;":"ő","odiv;":"⨸","odot;":"⊙","odsold;":"⦼","OElig;":"Œ","oelig;":"œ","ofcir;":"⦿","Ofr;":"𝔒","ofr;":"𝔬","ogon;":"˛","Ograve;":"Ò",Ograve:"Ò","ograve;":"ò",ograve:"ò","ogt;":"⧁","ohbar;":"⦵","ohm;":"Ω","oint;":"∮","olarr;":"↺","olcir;":"⦾","olcross;":"⦻","oline;":"‾","olt;":"⧀","Omacr;":"Ō","omacr;":"ō","Omega;":"Ω","omega;":"ω","Omicron;":"Ο","omicron;":"ο","omid;":"⦶","ominus;":"⊖","Oopf;":"𝕆","oopf;":"𝕠","opar;":"⦷","OpenCurlyDoubleQuote;":"“","OpenCurlyQuote;":"‘","operp;":"⦹","oplus;":"⊕","Or;":"⩔","or;":"∨","orarr;":"↻","ord;":"⩝","order;":"ℴ","orderof;":"ℴ","ordf;":"ª",ordf:"ª","ordm;":"º",ordm:"º","origof;":"⊶","oror;":"⩖","orslope;":"⩗","orv;":"⩛","oS;":"Ⓢ","Oscr;":"𝒪","oscr;":"ℴ","Oslash;":"Ø",Oslash:"Ø","oslash;":"ø",oslash:"ø","osol;":"⊘","Otilde;":"Õ",Otilde:"Õ","otilde;":"õ",otilde:"õ","Otimes;":"⨷","otimes;":"⊗","otimesas;":"⨶","Ouml;":"Ö",Ouml:"Ö","ouml;":"ö",ouml:"ö","ovbar;":"⌽","OverBar;":"‾","OverBrace;":"⏞","OverBracket;":"⎴","OverParenthesis;":"⏜","par;":"∥","para;":"¶",para:"¶","parallel;":"∥","parsim;":"⫳","parsl;":"⫽","part;":"∂","PartialD;":"∂","Pcy;":"П","pcy;":"п","percnt;":"%","period;":".","permil;":"‰","perp;":"⊥","pertenk;":"‱","Pfr;":"𝔓","pfr;":"𝔭","Phi;":"Φ","phi;":"φ","phiv;":"ϕ","phmmat;":"ℳ","phone;":"☎","Pi;":"Π","pi;":"π","pitchfork;":"⋔","piv;":"ϖ","planck;":"ℏ","planckh;":"ℎ","plankv;":"ℏ","plus;":"+","plusacir;":"⨣","plusb;":"⊞","pluscir;":"⨢","plusdo;":"∔","plusdu;":"⨥","pluse;":"⩲","PlusMinus;":"±","plusmn;":"±",plusmn:"±","plussim;":"⨦","plustwo;":"⨧","pm;":"±","Poincareplane;":"ℌ","pointint;":"⨕","Popf;":"ℙ","popf;":"𝕡","pound;":"£",pound:"£","Pr;":"⪻","pr;":"≺","prap;":"⪷","prcue;":"≼","prE;":"⪳","pre;":"⪯","prec;":"≺","precapprox;":"⪷","preccurlyeq;":"≼","Precedes;":"≺","PrecedesEqual;":"⪯","PrecedesSlantEqual;":"≼","PrecedesTilde;":"≾","preceq;":"⪯","precnapprox;":"⪹","precneqq;":"⪵","precnsim;":"⋨","precsim;":"≾","Prime;":"″","prime;":"′","primes;":"ℙ","prnap;":"⪹","prnE;":"⪵","prnsim;":"⋨","prod;":"∏","Product;":"∏","profalar;":"⌮","profline;":"⌒","profsurf;":"⌓","prop;":"∝","Proportion;":"∷","Proportional;":"∝","propto;":"∝","prsim;":"≾","prurel;":"⊰","Pscr;":"𝒫","pscr;":"𝓅","Psi;":"Ψ","psi;":"ψ","puncsp;":" ","Qfr;":"𝔔","qfr;":"𝔮","qint;":"⨌","Qopf;":"ℚ","qopf;":"𝕢","qprime;":"⁗","Qscr;":"𝒬","qscr;":"𝓆","quaternions;":"ℍ","quatint;":"⨖","quest;":"?","questeq;":"≟","QUOT;":'"',QUOT:'"',"quot;":'"',quot:'"',"rAarr;":"⇛","race;":"∽̱","Racute;":"Ŕ","racute;":"ŕ","radic;":"√","raemptyv;":"⦳","Rang;":"⟫","rang;":"⟩","rangd;":"⦒","range;":"⦥","rangle;":"⟩","raquo;":"»",raquo:"»","Rarr;":"↠","rArr;":"⇒","rarr;":"→","rarrap;":"⥵","rarrb;":"⇥","rarrbfs;":"⤠","rarrc;":"⤳","rarrfs;":"⤞","rarrhk;":"↪","rarrlp;":"↬","rarrpl;":"⥅","rarrsim;":"⥴","Rarrtl;":"⤖","rarrtl;":"↣","rarrw;":"↝","rAtail;":"⤜","ratail;":"⤚","ratio;":"∶","rationals;":"ℚ","RBarr;":"⤐","rBarr;":"⤏","rbarr;":"⤍","rbbrk;":"❳","rbrace;":"}","rbrack;":"]","rbrke;":"⦌","rbrksld;":"⦎","rbrkslu;":"⦐","Rcaron;":"Ř","rcaron;":"ř","Rcedil;":"Ŗ","rcedil;":"ŗ","rceil;":"⌉","rcub;":"}","Rcy;":"Р","rcy;":"р","rdca;":"⤷","rdldhar;":"⥩","rdquo;":"”","rdquor;":"”","rdsh;":"↳","Re;":"ℜ","real;":"ℜ","realine;":"ℛ","realpart;":"ℜ","reals;":"ℝ","rect;":"▭","REG;":"®",REG:"®","reg;":"®",reg:"®","ReverseElement;":"∋","ReverseEquilibrium;":"⇋","ReverseUpEquilibrium;":"⥯","rfisht;":"⥽","rfloor;":"⌋","Rfr;":"ℜ","rfr;":"𝔯","rHar;":"⥤","rhard;":"⇁","rharu;":"⇀","rharul;":"⥬","Rho;":"Ρ","rho;":"ρ","rhov;":"ϱ","RightAngleBracket;":"⟩","RightArrow;":"→","Rightarrow;":"⇒","rightarrow;":"→","RightArrowBar;":"⇥","RightArrowLeftArrow;":"⇄","rightarrowtail;":"↣","RightCeiling;":"⌉","RightDoubleBracket;":"⟧","RightDownTeeVector;":"⥝","RightDownVector;":"⇂","RightDownVectorBar;":"⥕","RightFloor;":"⌋","rightharpoondown;":"⇁","rightharpoonup;":"⇀","rightleftarrows;":"⇄","rightleftharpoons;":"⇌","rightrightarrows;":"⇉","rightsquigarrow;":"↝","RightTee;":"⊢","RightTeeArrow;":"↦","RightTeeVector;":"⥛","rightthreetimes;":"⋌","RightTriangle;":"⊳","RightTriangleBar;":"⧐","RightTriangleEqual;":"⊵","RightUpDownVector;":"⥏","RightUpTeeVector;":"⥜","RightUpVector;":"↾","RightUpVectorBar;":"⥔","RightVector;":"⇀","RightVectorBar;":"⥓","ring;":"˚","risingdotseq;":"≓","rlarr;":"⇄","rlhar;":"⇌","rlm;":"‏","rmoust;":"⎱","rmoustache;":"⎱","rnmid;":"⫮","roang;":"⟭","roarr;":"⇾","robrk;":"⟧","ropar;":"⦆","Ropf;":"ℝ","ropf;":"𝕣","roplus;":"⨮","rotimes;":"⨵","RoundImplies;":"⥰","rpar;":")","rpargt;":"⦔","rppolint;":"⨒","rrarr;":"⇉","Rrightarrow;":"⇛","rsaquo;":"›","Rscr;":"ℛ","rscr;":"𝓇","Rsh;":"↱","rsh;":"↱","rsqb;":"]","rsquo;":"’","rsquor;":"’","rthree;":"⋌","rtimes;":"⋊","rtri;":"▹","rtrie;":"⊵","rtrif;":"▸","rtriltri;":"⧎","RuleDelayed;":"⧴","ruluhar;":"⥨","rx;":"℞","Sacute;":"Ś","sacute;":"ś","sbquo;":"‚","Sc;":"⪼","sc;":"≻","scap;":"⪸","Scaron;":"Š","scaron;":"š","sccue;":"≽","scE;":"⪴","sce;":"⪰","Scedil;":"Ş","scedil;":"ş","Scirc;":"Ŝ","scirc;":"ŝ","scnap;":"⪺","scnE;":"⪶","scnsim;":"⋩","scpolint;":"⨓","scsim;":"≿","Scy;":"С","scy;":"с","sdot;":"⋅","sdotb;":"⊡","sdote;":"⩦","searhk;":"⤥","seArr;":"⇘","searr;":"↘","searrow;":"↘","sect;":"§",sect:"§","semi;":";","seswar;":"⤩","setminus;":"∖","setmn;":"∖","sext;":"✶","Sfr;":"𝔖","sfr;":"𝔰","sfrown;":"⌢","sharp;":"♯","SHCHcy;":"Щ","shchcy;":"щ","SHcy;":"Ш","shcy;":"ш","ShortDownArrow;":"↓","ShortLeftArrow;":"←","shortmid;":"∣","shortparallel;":"∥","ShortRightArrow;":"→","ShortUpArrow;":"↑","shy;":"­",shy:"­","Sigma;":"Σ","sigma;":"σ","sigmaf;":"ς","sigmav;":"ς","sim;":"∼","simdot;":"⩪","sime;":"≃","simeq;":"≃","simg;":"⪞","simgE;":"⪠","siml;":"⪝","simlE;":"⪟","simne;":"≆","simplus;":"⨤","simrarr;":"⥲","slarr;":"←","SmallCircle;":"∘","smallsetminus;":"∖","smashp;":"⨳","smeparsl;":"⧤","smid;":"∣","smile;":"⌣","smt;":"⪪","smte;":"⪬","smtes;":"⪬︀","SOFTcy;":"Ь","softcy;":"ь","sol;":"/","solb;":"⧄","solbar;":"⌿","Sopf;":"𝕊","sopf;":"𝕤","spades;":"♠","spadesuit;":"♠","spar;":"∥","sqcap;":"⊓","sqcaps;":"⊓︀","sqcup;":"⊔","sqcups;":"⊔︀","Sqrt;":"√","sqsub;":"⊏","sqsube;":"⊑","sqsubset;":"⊏","sqsubseteq;":"⊑","sqsup;":"⊐","sqsupe;":"⊒","sqsupset;":"⊐","sqsupseteq;":"⊒","squ;":"□","Square;":"□","square;":"□","SquareIntersection;":"⊓","SquareSubset;":"⊏","SquareSubsetEqual;":"⊑","SquareSuperset;":"⊐","SquareSupersetEqual;":"⊒","SquareUnion;":"⊔","squarf;":"▪","squf;":"▪","srarr;":"→","Sscr;":"𝒮","sscr;":"𝓈","ssetmn;":"∖","ssmile;":"⌣","sstarf;":"⋆","Star;":"⋆","star;":"☆","starf;":"★","straightepsilon;":"ϵ","straightphi;":"ϕ","strns;":"¯","Sub;":"⋐","sub;":"⊂","subdot;":"⪽","subE;":"⫅","sube;":"⊆","subedot;":"⫃","submult;":"⫁","subnE;":"⫋","subne;":"⊊","subplus;":"⪿","subrarr;":"⥹","Subset;":"⋐","subset;":"⊂","subseteq;":"⊆","subseteqq;":"⫅","SubsetEqual;":"⊆","subsetneq;":"⊊","subsetneqq;":"⫋","subsim;":"⫇","subsub;":"⫕","subsup;":"⫓","succ;":"≻","succapprox;":"⪸","succcurlyeq;":"≽","Succeeds;":"≻","SucceedsEqual;":"⪰","SucceedsSlantEqual;":"≽","SucceedsTilde;":"≿","succeq;":"⪰","succnapprox;":"⪺","succneqq;":"⪶","succnsim;":"⋩","succsim;":"≿","SuchThat;":"∋","Sum;":"∑","sum;":"∑","sung;":"♪","Sup;":"⋑","sup;":"⊃","sup1;":"¹",sup1:"¹","sup2;":"²",sup2:"²","sup3;":"³",sup3:"³","supdot;":"⪾","supdsub;":"⫘","supE;":"⫆","supe;":"⊇","supedot;":"⫄","Superset;":"⊃","SupersetEqual;":"⊇","suphsol;":"⟉","suphsub;":"⫗","suplarr;":"⥻","supmult;":"⫂","supnE;":"⫌","supne;":"⊋","supplus;":"⫀","Supset;":"⋑","supset;":"⊃","supseteq;":"⊇","supseteqq;":"⫆","supsetneq;":"⊋","supsetneqq;":"⫌","supsim;":"⫈","supsub;":"⫔","supsup;":"⫖","swarhk;":"⤦","swArr;":"⇙","swarr;":"↙","swarrow;":"↙","swnwar;":"⤪","szlig;":"ß",szlig:"ß","Tab;":"\t","target;":"⌖","Tau;":"Τ","tau;":"τ","tbrk;":"⎴","Tcaron;":"Ť","tcaron;":"ť","Tcedil;":"Ţ","tcedil;":"ţ","Tcy;":"Т","tcy;":"т","tdot;":"⃛","telrec;":"⌕","Tfr;":"𝔗","tfr;":"𝔱","there4;":"∴","Therefore;":"∴","therefore;":"∴","Theta;":"Θ","theta;":"θ","thetasym;":"ϑ","thetav;":"ϑ","thickapprox;":"≈","thicksim;":"∼","ThickSpace;":"  ","thinsp;":" ","ThinSpace;":" ","thkap;":"≈","thksim;":"∼","THORN;":"Þ",THORN:"Þ","thorn;":"þ",thorn:"þ","Tilde;":"∼","tilde;":"˜","TildeEqual;":"≃","TildeFullEqual;":"≅","TildeTilde;":"≈","times;":"×",times:"×","timesb;":"⊠","timesbar;":"⨱","timesd;":"⨰","tint;":"∭","toea;":"⤨","top;":"⊤","topbot;":"⌶","topcir;":"⫱","Topf;":"𝕋","topf;":"𝕥","topfork;":"⫚","tosa;":"⤩","tprime;":"‴","TRADE;":"™","trade;":"™","triangle;":"▵","triangledown;":"▿","triangleleft;":"◃","trianglelefteq;":"⊴","triangleq;":"≜","triangleright;":"▹","trianglerighteq;":"⊵","tridot;":"◬","trie;":"≜","triminus;":"⨺","TripleDot;":"⃛","triplus;":"⨹","trisb;":"⧍","tritime;":"⨻","trpezium;":"⏢","Tscr;":"𝒯","tscr;":"𝓉","TScy;":"Ц","tscy;":"ц","TSHcy;":"Ћ","tshcy;":"ћ","Tstrok;":"Ŧ","tstrok;":"ŧ","twixt;":"≬","twoheadleftarrow;":"↞","twoheadrightarrow;":"↠","Uacute;":"Ú",Uacute:"Ú","uacute;":"ú",uacute:"ú","Uarr;":"↟","uArr;":"⇑","uarr;":"↑","Uarrocir;":"⥉","Ubrcy;":"Ў","ubrcy;":"ў","Ubreve;":"Ŭ","ubreve;":"ŭ","Ucirc;":"Û",Ucirc:"Û","ucirc;":"û",ucirc:"û","Ucy;":"У","ucy;":"у","udarr;":"⇅","Udblac;":"Ű","udblac;":"ű","udhar;":"⥮","ufisht;":"⥾","Ufr;":"𝔘","ufr;":"𝔲","Ugrave;":"Ù",Ugrave:"Ù","ugrave;":"ù",ugrave:"ù","uHar;":"⥣","uharl;":"↿","uharr;":"↾","uhblk;":"▀","ulcorn;":"⌜","ulcorner;":"⌜","ulcrop;":"⌏","ultri;":"◸","Umacr;":"Ū","umacr;":"ū","uml;":"¨",uml:"¨","UnderBar;":"_","UnderBrace;":"⏟","UnderBracket;":"⎵","UnderParenthesis;":"⏝","Union;":"⋃","UnionPlus;":"⊎","Uogon;":"Ų","uogon;":"ų","Uopf;":"𝕌","uopf;":"𝕦","UpArrow;":"↑","Uparrow;":"⇑","uparrow;":"↑","UpArrowBar;":"⤒","UpArrowDownArrow;":"⇅","UpDownArrow;":"↕","Updownarrow;":"⇕","updownarrow;":"↕","UpEquilibrium;":"⥮","upharpoonleft;":"↿","upharpoonright;":"↾","uplus;":"⊎","UpperLeftArrow;":"↖","UpperRightArrow;":"↗","Upsi;":"ϒ","upsi;":"υ","upsih;":"ϒ","Upsilon;":"Υ","upsilon;":"υ","UpTee;":"⊥","UpTeeArrow;":"↥","upuparrows;":"⇈","urcorn;":"⌝","urcorner;":"⌝","urcrop;":"⌎","Uring;":"Ů","uring;":"ů","urtri;":"◹","Uscr;":"𝒰","uscr;":"𝓊","utdot;":"⋰","Utilde;":"Ũ","utilde;":"ũ","utri;":"▵","utrif;":"▴","uuarr;":"⇈","Uuml;":"Ü",Uuml:"Ü","uuml;":"ü",uuml:"ü","uwangle;":"⦧","vangrt;":"⦜","varepsilon;":"ϵ","varkappa;":"ϰ","varnothing;":"∅","varphi;":"ϕ","varpi;":"ϖ","varpropto;":"∝","vArr;":"⇕","varr;":"↕","varrho;":"ϱ","varsigma;":"ς","varsubsetneq;":"⊊︀","varsubsetneqq;":"⫋︀","varsupsetneq;":"⊋︀","varsupsetneqq;":"⫌︀","vartheta;":"ϑ","vartriangleleft;":"⊲","vartriangleright;":"⊳","Vbar;":"⫫","vBar;":"⫨","vBarv;":"⫩","Vcy;":"В","vcy;":"в","VDash;":"⊫","Vdash;":"⊩","vDash;":"⊨","vdash;":"⊢","Vdashl;":"⫦","Vee;":"⋁","vee;":"∨","veebar;":"⊻","veeeq;":"≚","vellip;":"⋮","Verbar;":"‖","verbar;":"|","Vert;":"‖","vert;":"|","VerticalBar;":"∣","VerticalLine;":"|","VerticalSeparator;":"❘","VerticalTilde;":"≀","VeryThinSpace;":" ","Vfr;":"𝔙","vfr;":"𝔳","vltri;":"⊲","vnsub;":"⊂⃒","vnsup;":"⊃⃒","Vopf;":"𝕍","vopf;":"𝕧","vprop;":"∝","vrtri;":"⊳","Vscr;":"𝒱","vscr;":"𝓋","vsubnE;":"⫋︀","vsubne;":"⊊︀","vsupnE;":"⫌︀","vsupne;":"⊋︀","Vvdash;":"⊪","vzigzag;":"⦚","Wcirc;":"Ŵ","wcirc;":"ŵ","wedbar;":"⩟","Wedge;":"⋀","wedge;":"∧","wedgeq;":"≙","weierp;":"℘","Wfr;":"𝔚","wfr;":"𝔴","Wopf;":"𝕎","wopf;":"𝕨","wp;":"℘","wr;":"≀","wreath;":"≀","Wscr;":"𝒲","wscr;":"𝓌","xcap;":"⋂","xcirc;":"◯","xcup;":"⋃","xdtri;":"▽","Xfr;":"𝔛","xfr;":"𝔵","xhArr;":"⟺","xharr;":"⟷","Xi;":"Ξ","xi;":"ξ","xlArr;":"⟸","xlarr;":"⟵","xmap;":"⟼","xnis;":"⋻","xodot;":"⨀","Xopf;":"𝕏","xopf;":"𝕩","xoplus;":"⨁","xotime;":"⨂","xrArr;":"⟹","xrarr;":"⟶","Xscr;":"𝒳","xscr;":"𝓍","xsqcup;":"⨆","xuplus;":"⨄","xutri;":"△","xvee;":"⋁","xwedge;":"⋀","Yacute;":"Ý",Yacute:"Ý","yacute;":"ý",yacute:"ý","YAcy;":"Я","yacy;":"я","Ycirc;":"Ŷ","ycirc;":"ŷ","Ycy;":"Ы","ycy;":"ы","yen;":"¥",yen:"¥","Yfr;":"𝔜","yfr;":"𝔶","YIcy;":"Ї","yicy;":"ї","Yopf;":"𝕐","yopf;":"𝕪","Yscr;":"𝒴","yscr;":"𝓎","YUcy;":"Ю","yucy;":"ю","Yuml;":"Ÿ","yuml;":"ÿ",yuml:"ÿ","Zacute;":"Ź","zacute;":"ź","Zcaron;":"Ž","zcaron;":"ž","Zcy;":"З","zcy;":"з","Zdot;":"Ż","zdot;":"ż","zeetrf;":"ℨ","ZeroWidthSpace;":"​","Zeta;":"Ζ","zeta;":"ζ","Zfr;":"ℨ","zfr;":"𝔷","ZHcy;":"Ж","zhcy;":"ж","zigrarr;":"⇝","Zopf;":"ℤ","zopf;":"𝕫","Zscr;":"𝒵","zscr;":"𝓏","zwj;":"‍","zwnj;":"‌"};function ae(_,S){if(_.length<S.length)return!1;for(var x=0;x<S.length;x++)if(_[x]!==S[x])return!1;return!0}function Gt(_,S){var x=_.length-S.length;return x>0?_.lastIndexOf(S)===x:0===x&&_===S}function dt(_,S){for(var x="";S>0;)!(1&~S)&&(x+=_),_+=_,S>>>=1;return x}var Dt="a".charCodeAt(0),Ot="z".charCodeAt(0),Nt="A".charCodeAt(0),jt="Z".charCodeAt(0),Bt="0".charCodeAt(0),Yt="9".charCodeAt(0);function fe(_,S){var x=_.charCodeAt(S);return Dt<=x&&x<=Ot||Nt<=x&&x<=jt||Bt<=x&&x<=Yt}function Ae(_){return typeof _<"u"}var Qt=function(){function t(_,S){var x=this;this.id=_,this._tags=[],this._tagMap={},this._valueSetMap={},this._tags=S.tags||[],this._globalAttributes=S.globalAttributes||[],this._tags.forEach((function(_){x._tagMap[_.name.toLowerCase()]=_})),S.valueSets&&S.valueSets.forEach((function(_){x._valueSetMap[_.name]=_.values}))}return t.prototype.isApplicable=function(){return!0},t.prototype.getId=function(){return this.id},t.prototype.provideTags=function(){return this._tags},t.prototype.provideAttributes=function(_){var S=[],n=function(_){S.push(_)},x=this._tagMap[_.toLowerCase()];return x&&x.attributes.forEach(n),this._globalAttributes.forEach(n),S},t.prototype.provideValues=function(_,S){var x=this,L=[];S=S.toLowerCase();var a=function(_){_.forEach((function(_){_.name.toLowerCase()===S&&(_.values&&_.values.forEach((function(_){L.push(_)})),_.valueSet&&x._valueSetMap[_.valueSet]&&x._valueSetMap[_.valueSet].forEach((function(_){L.push(_)})))}))},z=this._tagMap[_.toLowerCase()];return z&&a(z.attributes),a(this._globalAttributes),L},t}();function le(_,S,x){void 0===S&&(S={});var L={kind:x?"markdown":"plaintext",value:""};if(_.description&&!1!==S.documentation){var z=function Vt(_){if(_)return"string"==typeof _?{kind:"markdown",value:_}:{kind:"markdown",value:_.value}}(_.description);z&&(L.value+=z.value)}if(_.references&&_.references.length>0&&!1!==S.references&&(L.value.length&&(L.value+="\n\n"),L.value+=x?_.references.map((function(_){return"["+_.name+"]("+_.url+")"})).join(" | "):_.references.map((function(_){return _.name+": "+_.url})).join("\n")),""!==L.value)return L}var Jt=function(_,S,x,L){return new(x||(x=Promise))((function(z,C){function l(_){try{s(L.next(_))}catch(_){C(_)}}function r(_){try{s(L.throw(_))}catch(_){C(_)}}function s(_){_.done?z(_.value):function e(_){return _ instanceof x?_:new x((function(S){S(_)}))}(_.value).then(l,r)}s((L=L.apply(_,S||[])).next())}))},Xt=function(_,S){var x,L,z,C,H={label:0,sent:function(){if(1&z[0])throw z[1];return z[1]},trys:[],ops:[]};return C={next:l(0),throw:l(1),return:l(2)},"function"==typeof Symbol&&(C[Symbol.iterator]=function(){return this}),C;function l(C){return function(W){return function r(C){if(x)throw new TypeError("Generator is already executing.");for(;H;)try{if(x=1,L&&(z=2&C[0]?L.return:C[0]?L.throw||((z=L.return)&&z.call(L),0):L.next)&&!(z=z.call(L,C[1])).done)return z;switch(L=0,z&&(C=[2&C[0],z.value]),C[0]){case 0:case 1:z=C;break;case 4:return H.label++,{value:C[1],done:!1};case 5:H.label++,L=C[1],C=[0];continue;case 7:C=H.ops.pop(),H.trys.pop();continue;default:if(!(z=(z=H.trys).length>0&&z[z.length-1])&&(6===C[0]||2===C[0])){H=0;continue}if(3===C[0]&&(!z||C[1]>z[0]&&C[1]<z[3])){H.label=C[1];break}if(6===C[0]&&H.label<z[1]){H.label=z[1],z=C;break}if(z&&H.label<z[2]){H.label=z[2],H.ops.push(C);break}z[2]&&H.ops.pop(),H.trys.pop();continue}C=S.call(_,H)}catch(_){C=[6,_],L=0}finally{x=z=0}if(5&C[0])throw C[1];return{value:C[0]?C[1]:void 0,done:!0}}([C,W])}}},Zt=function(){function t(_){this.readDirectory=_,this.atributeCompletions=[]}return t.prototype.onHtmlAttributeValue=function(_){(function ai(_,S){if("src"===S||"href"===S)return!0;var x=tn[_];return!!x&&("string"==typeof x?x===S:-1!==x.indexOf(S))})(_.tag,_.attribute)&&this.atributeCompletions.push(_)},t.prototype.computeCompletions=function(_,S){return Jt(this,void 0,void 0,(function(){var x,L,C,H,W,D,O,q,P,V;return Xt(this,(function(K){switch(K.label){case 0:x={items:[],isIncomplete:!1},L=0,C=this.atributeCompletions,K.label=1;case 1:return L<C.length?(H=C[L],W=function ii(_){return ae(_,"'")||ae(_,'"')?_.slice(1,-1):_}(_.getText(H.range)),function ri(_){return!(ae(_,"http")||ae(_,"https")||ae(_,"//"))}(W)?"."===W||".."===W?(x.isIncomplete=!0,[3,4]):[3,2]:[3,4]):[3,5];case 2:return D=function oi(_,S,x){var L,C=_.lastIndexOf("/");if(-1===C)L=function li(_,S,x){var L=ze(_.start,S),C=ze(_.end,x);return z.create(L,C)}(x,1,-1);else{var H=S.slice(C+1),W=ze(x.end,-1-H.length),D=H.indexOf(" "),O=void 0;O=-1!==D?ze(W,D):ze(x.end,-1),L=z.create(W,O)}return L}(H.value,W,H.range),[4,this.providePathSuggestions(H.value,D,_,S)];case 3:for(O=K.sent(),q=0,P=O;q<P.length;q++)V=P[q],x.items.push(V);K.label=4;case 4:return L++,[3,1];case 5:return[2,x]}}))}))},t.prototype.providePathSuggestions=function(_,S,x,L){return Jt(this,void 0,void 0,(function(){var z,C,H,W,D,O,q,P,V;return Xt(this,(function(K){switch(K.label){case 0:if(z=_.substring(0,_.lastIndexOf("/")+1),!(C=L.resolveReference(z||".",x.uri)))return[3,4];K.label=1;case 1:return K.trys.push([1,3,,4]),H=[],[4,this.readDirectory(C)];case 2:for(W=K.sent(),D=0,O=W;D<O.length;D++)q=O[D],P=q[0],V=q[1],P.charCodeAt(0)!==en&&H.push(si(P,V===gt.Directory,S));return[2,H];case 3:return K.sent(),[3,4];case 4:return[2,[]]}}))}))},t}(),en=".".charCodeAt(0);function si(_,S,x){return S?{label:_+="/",kind:Ee.Folder,textEdit:ee.replace(x,_),command:{title:"Suggest",command:"editor.action.triggerSuggest"}}:{label:_,kind:Ee.File,textEdit:ee.replace(x,_)}}function ze(_,S){return L.create(_.line,_.character+S)}var tn={a:"href",area:"href",body:"background",del:"cite",form:"action",frame:["src","longdesc"],img:["src","longdesc"],ins:"cite",link:"href",object:"data",q:"cite",script:"src",audio:"src",button:"formaction",command:"icon",embed:"src",html:"manifest",input:["src","formaction"],source:"src",track:"src",video:["src","poster"]},ci=function(_,S,x,L){return new(x||(x=Promise))((function(z,C){function l(_){try{s(L.next(_))}catch(_){C(_)}}function r(_){try{s(L.throw(_))}catch(_){C(_)}}function s(_){_.done?z(_.value):function e(_){return _ instanceof x?_:new x((function(S){S(_)}))}(_.value).then(l,r)}s((L=L.apply(_,S||[])).next())}))},hi=function(_,S){var x,L,z,C,H={label:0,sent:function(){if(1&z[0])throw z[1];return z[1]},trys:[],ops:[]};return C={next:l(0),throw:l(1),return:l(2)},"function"==typeof Symbol&&(C[Symbol.iterator]=function(){return this}),C;function l(C){return function(W){return function r(C){if(x)throw new TypeError("Generator is already executing.");for(;H;)try{if(x=1,L&&(z=2&C[0]?L.return:C[0]?L.throw||((z=L.return)&&z.call(L),0):L.next)&&!(z=z.call(L,C[1])).done)return z;switch(L=0,z&&(C=[2&C[0],z.value]),C[0]){case 0:case 1:z=C;break;case 4:return H.label++,{value:C[1],done:!1};case 5:H.label++,L=C[1],C=[0];continue;case 7:C=H.ops.pop(),H.trys.pop();continue;default:if(!(z=(z=H.trys).length>0&&z[z.length-1])&&(6===C[0]||2===C[0])){H=0;continue}if(3===C[0]&&(!z||C[1]>z[0]&&C[1]<z[3])){H.label=C[1];break}if(6===C[0]&&H.label<z[1]){H.label=z[1],z=C;break}if(z&&H.label<z[2]){H.label=z[2],H.ops.push(C);break}z[2]&&H.ops.pop(),H.trys.pop();continue}C=S.call(_,H)}catch(_){C=[6,_],L=0}finally{x=z=0}if(5&C[0])throw C[1];return{value:C[0]?C[1]:void 0,done:!0}}([C,W])}}},nn=ge(),ln=function(){function t(_,S){this.lsOptions=_,this.dataManager=S,this.completionParticipants=[]}return t.prototype.setCompletionParticipants=function(_){this.completionParticipants=_||[]},t.prototype.doComplete2=function(_,S,x,L,z){return ci(this,void 0,void 0,(function(){var C,H,W,D;return hi(this,(function(O){switch(O.label){case 0:if(!this.lsOptions.fileSystemProvider||!this.lsOptions.fileSystemProvider.readDirectory)return[2,this.doComplete(_,S,x,z)];C=new Zt(this.lsOptions.fileSystemProvider.readDirectory),H=this.completionParticipants,this.completionParticipants=[C].concat(H),W=this.doComplete(_,S,x,z),O.label=1;case 1:return O.trys.push([1,,3,4]),[4,C.computeCompletions(_,L)];case 2:return D=O.sent(),[2,{isIncomplete:W.isIncomplete||D.isIncomplete,items:D.items.concat(W.items)}];case 3:return this.completionParticipants=H,[7];case 4:return[2]}}))}))},t.prototype.doComplete=function(_,S,x,L){var z=this._doComplete(_,S,x,L);return this.convertCompletionList(z)},t.prototype._doComplete=function(_,S,x,C){var H={isIncomplete:!1,items:[]},W=this.completionParticipants,D=this.dataManager.getDataProviders().filter((function(S){return S.isApplicable(_.languageId)&&(!C||!1!==C[S.getId()])})),O=this.doesSupportMarkdown(),q=_.getText(),P=_.offsetAt(S),V=x.findNodeBefore(P);if(!V)return H;var K,X,Y=$(q,V.start),Q="";function m(S,x){return void 0===x&&(x=P),S>P&&(S=P),{start:_.positionAt(S),end:_.positionAt(x)}}function A(_,S){var x=m(_,S);return D.forEach((function(_){_.provideTags().forEach((function(_){H.items.push({label:_.name,kind:Ee.Property,documentation:le(_,void 0,O),textEdit:ee.replace(x,_.name),insertTextFormat:Me.PlainText})}))})),H}function E(_){for(var S=_;S>0;){var x=q.charAt(S-1);if("\n\r".indexOf(x)>=0)return q.substring(S,_);if(!Ve(x))return null;S--}return q.substring(0,_)}function w(_,S,x){void 0===x&&(x=P);var L=m(_,x),z=$t(q,x,lt.WithinEndTag,st.EndTagClose)?"":">",C=V;for(S&&(C=C.parent);C;){var W=C.tag;if(W&&(!C.closed||C.endTagStart&&C.endTagStart>P)){var K={label:"/"+W,kind:Ee.Property,filterText:"/"+W,textEdit:ee.replace(L,"/"+W+z),insertTextFormat:Me.PlainText},X=E(C.start),Y=E(_-1);if(null!==X&&null!==Y&&X!==Y){var Q=X+"</"+W+z;K.textEdit=ee.replace(m(_-1-Y.length),Q),K.filterText=Y+"</"+W}return H.items.push(K),H}C=C.parent}return S||D.forEach((function(_){_.provideTags().forEach((function(_){H.items.push({label:"/"+_.name,kind:Ee.Property,documentation:le(_,void 0,O),filterText:"/"+_.name+z,textEdit:ee.replace(L,"/"+_.name+z),insertTextFormat:Me.PlainText})}))})),H}function M(S,x){if(C&&C.hideAutoCompleteProposals)return H;if(!pe(x)){var L=_.positionAt(S);H.items.push({label:"</"+x+">",kind:Ee.Property,filterText:"</"+x+">",textEdit:ee.insert(L,"$0</"+x+">"),insertTextFormat:Me.Snippet})}return H}function B(_,S){return A(_,S),w(_,!0,S),H}function J(_,S){var L;void 0===S&&(S=P);for(var z=P;z<S&&"<"!==q[z];)z++;var W=q.substring(_,S),K=m(_,z),X="";if(!$t(q,S,lt.AfterAttributeName,st.DelimiterAssign)){var Y=null!==(L=null==C?void 0:C.attributeDefaultValue)&&void 0!==L?L:"doublequotes";X="empty"===Y?"=$1":"singlequotes"===Y?"='$1'":'="$1"'}var Z=function G(){var _=Object.create(null);return V.attributeNames.forEach((function(S){_[S]=!0})),_}();return Z[W]=!1,D.forEach((function(_){_.provideAttributes(Q).forEach((function(_){if(!Z[_.name]){Z[_.name]=!0;var S,x=_.name;"v"!==_.valueSet&&X.length&&(x+=X,(_.valueSet||"style"===_.name)&&(S={title:"Suggest",command:"editor.action.triggerSuggest"})),H.items.push({label:_.name,kind:"handler"===_.valueSet?Ee.Function:Ee.Value,documentation:le(_,void 0,O),textEdit:ee.replace(K,x),insertTextFormat:Me.Snippet,command:S})}}))})),function f(_,S){var L="data-",z={};function j(_){_.attributeNames.forEach((function(_){ae(_,L)&&!z[_]&&!S[_]&&(z[_]=_+'="$1"')})),_.children.forEach((function(_){return j(_)}))}z[L]=L+'$1="$2"',x&&x.roots.forEach((function(_){return j(_)})),Object.keys(z).forEach((function(S){return H.items.push({label:S,kind:Ee.Value,textEdit:ee.replace(_,z[S]),insertTextFormat:Me.Snippet})}))}(K,Z),H}function p(x,L){var z,C,V;if(void 0===L&&(L=P),P>x&&P<=L&&function pi(_){return/^["']*$/.test(_)}(q[x])){var X=x+1,Y=L;L>x&&q[L-1]===q[x]&&Y--;var Z=function mi(_,S,x){for(;S>x&&!Ve(_[S-1]);)S--;return S}(q,P,X),te=function fi(_,S,x){for(;S<x&&!Ve(_[S]);)S++;return S}(q,P,Y);z=m(Z,te),V=P>=X&&P<=Y?q.substring(X,P):"",C=!1}else z=m(x,L),V=q.substring(x,P),C=!0;if(W.length>0)for(var ne=Q.toLowerCase(),re=K.toLowerCase(),oe=m(x,L),se=0,ce=W;se<ce.length;se++){var he=ce[se];he.onHtmlAttributeValue&&he.onHtmlAttributeValue({document:_,position:S,tag:ne,attribute:re,value:V,range:oe})}return D.forEach((function(_){_.provideValues(Q,K).forEach((function(_){var S=C?'"'+_.name+'"':_.name;H.items.push({label:_.name,filterText:S,kind:Ee.Unit,documentation:le(_,void 0,O),textEdit:ee.replace(z,S),insertTextFormat:Me.PlainText})}))})),R(),H}function b(_){return P===Y.getTokenEnd()&&((Z=Y.scan())===_&&Y.getTokenOffset()===P)?Y.getTokenEnd():P}function N(){for(var x=0,L=W;x<L.length;x++){var z=L[x];z.onHtmlContent&&z.onHtmlContent({document:_,position:S})}return R()}function R(){for(var _=P-1,x=S.character;_>=0&&fe(q,_);)_--,x--;if(_>=0&&"&"===q[_]){var C=z.create(L.create(S.line,x-1),S);for(var W in Wt)if(Gt(W,";")){var D="&"+W;H.items.push({label:D,kind:Ee.Keyword,documentation:nn("entity.propose","Character entity representing '"+Wt[W]+"'"),textEdit:ee.replace(C,D),insertTextFormat:Me.PlainText})}}return H}for(var Z=Y.scan();Z!==st.EOS&&Y.getTokenOffset()<=P;){switch(Z){case st.StartTagOpen:if(Y.getTokenEnd()===P){var te=b(st.StartTag);return 0===S.line&&(X=void 0,X=m(P,te),H.items.push({label:"!DOCTYPE",kind:Ee.Property,documentation:"A preamble for an HTML document.",textEdit:ee.replace(X,"!DOCTYPE html>"),insertTextFormat:Me.PlainText})),B(P,te)}break;case st.StartTag:if(Y.getTokenOffset()<=P&&P<=Y.getTokenEnd())return A(Y.getTokenOffset(),Y.getTokenEnd());Q=Y.getTokenText();break;case st.AttributeName:if(Y.getTokenOffset()<=P&&P<=Y.getTokenEnd())return J(Y.getTokenOffset(),Y.getTokenEnd());K=Y.getTokenText();break;case st.DelimiterAssign:if(Y.getTokenEnd()===P){te=b(st.AttributeValue);return p(P,te)}break;case st.AttributeValue:if(Y.getTokenOffset()<=P&&P<=Y.getTokenEnd())return p(Y.getTokenOffset(),Y.getTokenEnd());break;case st.Whitespace:if(P<=Y.getTokenEnd())switch(Y.getScannerState()){case lt.AfterOpeningStartTag:return B(Y.getTokenOffset(),b(st.StartTag));case lt.WithinTag:case lt.AfterAttributeName:return J(Y.getTokenEnd());case lt.BeforeAttributeValue:return p(Y.getTokenEnd());case lt.AfterOpeningEndTag:return w(Y.getTokenOffset()-1,!1);case lt.WithinContent:return N()}break;case st.EndTagOpen:if(P<=Y.getTokenEnd())return w(Y.getTokenOffset()+1,!1,b(st.EndTag));break;case st.EndTag:if(P<=Y.getTokenEnd())for(var ne=Y.getTokenOffset()-1;ne>=0;){var re=q.charAt(ne);if("/"===re)return w(ne,!1,Y.getTokenEnd());if(!Ve(re))break;ne--}break;case st.StartTagClose:if(P<=Y.getTokenEnd()&&Q)return M(Y.getTokenEnd(),Q);break;case st.Content:if(P<=Y.getTokenEnd())return N();break;default:if(P<=Y.getTokenEnd())return H}Z=Y.scan()}return H},t.prototype.doQuoteComplete=function(_,S,x,L){var z,C=_.offsetAt(S);if(C<=0)return null;var H=null!==(z=null==L?void 0:L.attributeDefaultValue)&&void 0!==z?z:"doublequotes";if("empty"===H)return null;if("="!==_.getText().charAt(C-1))return null;var W="doublequotes"===H?'"$1"':"'$1'",D=x.findNodeBefore(C);if(D&&D.attributes&&D.start<C&&(!D.endTagStart||D.endTagStart>C))for(var O=$(_.getText(),D.start),q=O.scan();q!==st.EOS&&O.getTokenEnd()<=C;){if(q===st.AttributeName&&O.getTokenEnd()===C-1)return(q=O.scan())!==st.DelimiterAssign||((q=O.scan())===st.Unknown||q===st.AttributeValue)?null:W;q=O.scan()}return null},t.prototype.doTagComplete=function(_,S,x){var L=_.offsetAt(S);if(L<=0)return null;var z=_.getText().charAt(L-1);if(">"===z){if((H=x.findNodeBefore(L))&&H.tag&&!pe(H.tag)&&H.start<L&&(!H.endTagStart||H.endTagStart>L))for(var C=(W=$(_.getText(),H.start)).scan();C!==st.EOS&&W.getTokenEnd()<=L;){if(C===st.StartTagClose&&W.getTokenEnd()===L)return"$0</"+H.tag+">";C=W.scan()}}else if("/"===z){for(var H=x.findNodeBefore(L);H&&H.closed&&!(H.endTagStart&&H.endTagStart>L);)H=H.parent;if(H&&H.tag){var W;for(C=(W=$(_.getText(),H.start)).scan();C!==st.EOS&&W.getTokenEnd()<=L;){if(C===st.EndTagOpen&&W.getTokenEnd()===L)return H.tag+">";C=W.scan()}}}return null},t.prototype.convertCompletionList=function(_){return this.doesSupportMarkdown()||_.items.forEach((function(_){_.documentation&&"string"!=typeof _.documentation&&(_.documentation={kind:"plaintext",value:_.documentation.value})})),_},t.prototype.doesSupportMarkdown=function(){var _,S,x;if(!Ae(this.supportsMarkdown)){if(!Ae(this.lsOptions.clientCapabilities))return this.supportsMarkdown=!0,this.supportsMarkdown;var L=null===(x=null===(S=null===(_=this.lsOptions.clientCapabilities.textDocument)||void 0===_?void 0:_.completion)||void 0===S?void 0:S.completionItem)||void 0===x?void 0:x.documentationFormat;this.supportsMarkdown=Array.isArray(L)&&-1!==L.indexOf(xe.Markdown)}return this.supportsMarkdown},t}();function Ve(_){return/^\s*$/.test(_)}function $t(_,S,x,L){for(var z=$(_,S,x),C=z.scan();C===st.Whitespace;)C=z.scan();return C===L}var un,Tn=ge(),xn=function(){function t(_,S){this.lsOptions=_,this.dataManager=S}return t.prototype.doHover=function(_,S,x,C){var H=this.convertContents.bind(this),W=this.doesSupportMarkdown(),D=_.offsetAt(S),O=x.findNodeAt(D),q=_.getText();if(!O||!O.tag)return null;var P=this.dataManager.getDataProviders().filter((function(S){return S.isApplicable(_.languageId)}));function h(_,S,x){for(var I=function(x){var L=null;if(x.provideTags().forEach((function(x){if(x.name.toLowerCase()===_.toLowerCase()){var z=le(x,C,W);z||(z={kind:W?"markdown":"plaintext",value:""}),L={contents:z,range:S}}})),L)return L.contents=H(L.contents),{value:L}},L=0,z=P;L<z.length;L++){var D=I(z[L]);if("object"==typeof D)return D.value}return null}function m(S,x){for(var L=$(_.getText(),x),z=L.scan();z!==st.EOS&&(L.getTokenEnd()<D||L.getTokenEnd()===D&&z!==S);)z=L.scan();return z===S&&D<=L.getTokenEnd()?{start:_.positionAt(L.getTokenOffset()),end:_.positionAt(L.getTokenEnd())}:null}if(O.endTagStart&&D>=O.endTagStart){var V=m(st.EndTag,O.endTagStart);return V?h(O.tag,V):null}var K=m(st.StartTag,O.start);if(K)return h(O.tag,K);var X=m(st.AttributeName,O.start);if(X)return function d(_,S,x){for(var I=function(L){var z=null;if(L.provideAttributes(_).forEach((function(_){if(S===_.name&&_.description){var L=le(_,C,W);z=L?{contents:L,range:x}:null}})),z)return z.contents=H(z.contents),{value:z}},L=0,z=P;L<z.length;L++){var D=I(z[L]);if("object"==typeof D)return D.value}return null}(Z=O.tag,_.getText(X),X);var Y=function A(){for(var _=D-1,x=S.character;_>=0&&fe(q,_);)_--,x--;for(var C=_+1,H=x;fe(q,C);)C++,H++;if(_>=0&&"&"===q[_]){return";"===q[C]?z.create(L.create(S.line,x),L.create(S.line,H+1)):z.create(L.create(S.line,x),L.create(S.line,H))}return null}();if(Y)return function y(_,S){var x=function E(_){for(var S=D-1,x="&";S>=0&&fe(_,S);)S--;for(S+=1;fe(_,S);)x+=_[S],S+=1;return x+=";",x}(_);for(var L in Wt){var z=null;if(x==="&"+L){var C=Wt[L].charCodeAt(0).toString(16).toUpperCase(),W="U+";if(C.length<4)for(var O=4-C.length,q=0;q<O;)W+="0",q+=1;W+=C;var P=Tn("entity.propose","Character entity representing '"+Wt[L]+"', unicode equivalent '"+W+"'");z=P?{contents:P,range:S}:null}if(z)return z.contents=H(z.contents),z}return null}(q,Y);var Q=m(st.AttributeValue,O.start);if(Q){var Z=O.tag,ee=function bi(_){return _.length<=1?_.replace(/['"]/,""):(("'"===_[0]||'"'===_[0])&&(_=_.slice(1)),("'"===_[_.length-1]||'"'===_[_.length-1])&&(_=_.slice(0,-1)),_)}(_.getText(Q)),te=function p(S,x){for(var L=$(_.getText(),S),z=L.scan(),C=void 0;z!==st.EOS&&L.getTokenEnd()<=x;)(z=L.scan())===st.AttributeName&&(C=L.getTokenText());return C}(O.start,_.offsetAt(Q.start));if(te)return function g(_,S,x,L){for(var F=function(z){var D=null;if(z.provideValues(_,S).forEach((function(_){if(x===_.name&&_.description){var S=le(_,C,W);D=S?{contents:S,range:L}:null}})),D)return D.contents=H(D.contents),{value:D}},z=0,D=P;z<D.length;z++){var O=F(D[z]);if("object"==typeof O)return O.value}return null}(Z,te,ee,Q)}return null},t.prototype.convertContents=function(_){if(!this.doesSupportMarkdown()){if("string"==typeof _)return _;if("kind"in _)return{kind:"plaintext",value:_.value};if(!Array.isArray(_))return _.value;_.map((function(_){return"string"==typeof _?_:_.value}))}return _},t.prototype.doesSupportMarkdown=function(){var _,S,x;if(!Ae(this.supportsMarkdown)){if(!Ae(this.lsOptions.clientCapabilities))return this.supportsMarkdown=!0,this.supportsMarkdown;var L=null===(x=null===(S=null===(_=this.lsOptions.clientCapabilities)||void 0===_?void 0:_.textDocument)||void 0===S?void 0:S.hover)||void 0===x?void 0:x.contentFormat;this.supportsMarkdown=Array.isArray(L)&&-1!==L.indexOf(xe.Markdown)}return this.supportsMarkdown},t}();function Kt(_,S){return _}!function(){var _=[,,function(_){function a(_){this.__parent=_,this.__character_count=0,this.__indent_count=-1,this.__alignment_count=0,this.__wrap_point_index=0,this.__wrap_point_character_count=0,this.__wrap_point_indent_count=-1,this.__wrap_point_alignment_count=0,this.__items=[]}function c(_,S){this.__cache=[""],this.__indent_size=_.indent_size,this.__indent_string=_.indent_char,_.indent_with_tabs||(this.__indent_string=new Array(_.indent_size+1).join(_.indent_char)),S=S||"",_.indent_level>0&&(S=new Array(_.indent_level+1).join(this.__indent_string)),this.__base_string=S,this.__base_string_length=S.length}function l(_,S){this.__indent_cache=new c(_,S),this.raw=!1,this._end_with_newline=_.end_with_newline,this.indent_size=_.indent_size,this.wrap_line_length=_.wrap_line_length,this.indent_empty_lines=_.indent_empty_lines,this.__lines=[],this.previous_line=null,this.current_line=null,this.next_line=new a(this),this.space_before_token=!1,this.non_breaking_space=!1,this.previous_token_wrapped=!1,this.__add_outputline()}a.prototype.clone_empty=function(){var _=new a(this.__parent);return _.set_indent(this.__indent_count,this.__alignment_count),_},a.prototype.item=function(_){return _<0?this.__items[this.__items.length+_]:this.__items[_]},a.prototype.has_match=function(_){for(var S=this.__items.length-1;S>=0;S--)if(this.__items[S].match(_))return!0;return!1},a.prototype.set_indent=function(_,S){this.is_empty()&&(this.__indent_count=_||0,this.__alignment_count=S||0,this.__character_count=this.__parent.get_indent_size(this.__indent_count,this.__alignment_count))},a.prototype._set_wrap_point=function(){this.__parent.wrap_line_length&&(this.__wrap_point_index=this.__items.length,this.__wrap_point_character_count=this.__character_count,this.__wrap_point_indent_count=this.__parent.next_line.__indent_count,this.__wrap_point_alignment_count=this.__parent.next_line.__alignment_count)},a.prototype._should_wrap=function(){return this.__wrap_point_index&&this.__character_count>this.__parent.wrap_line_length&&this.__wrap_point_character_count>this.__parent.next_line.__character_count},a.prototype._allow_wrap=function(){if(this._should_wrap()){this.__parent.add_new_line();var _=this.__parent.current_line;return _.set_indent(this.__wrap_point_indent_count,this.__wrap_point_alignment_count),_.__items=this.__items.slice(this.__wrap_point_index),this.__items=this.__items.slice(0,this.__wrap_point_index),_.__character_count+=this.__character_count-this.__wrap_point_character_count,this.__character_count=this.__wrap_point_character_count," "===_.__items[0]&&(_.__items.splice(0,1),_.__character_count-=1),!0}return!1},a.prototype.is_empty=function(){return 0===this.__items.length},a.prototype.last=function(){return this.is_empty()?null:this.__items[this.__items.length-1]},a.prototype.push=function(_){this.__items.push(_);var S=_.lastIndexOf("\n");-1!==S?this.__character_count=_.length-S:this.__character_count+=_.length},a.prototype.pop=function(){var _=null;return this.is_empty()||(_=this.__items.pop(),this.__character_count-=_.length),_},a.prototype._remove_indent=function(){this.__indent_count>0&&(this.__indent_count-=1,this.__character_count-=this.__parent.indent_size)},a.prototype._remove_wrap_indent=function(){this.__wrap_point_indent_count>0&&(this.__wrap_point_indent_count-=1)},a.prototype.trim=function(){for(;" "===this.last();)this.__items.pop(),this.__character_count-=1},a.prototype.toString=function(){var _="";return this.is_empty()?this.__parent.indent_empty_lines&&(_=this.__parent.get_indent_string(this.__indent_count)):(_=this.__parent.get_indent_string(this.__indent_count,this.__alignment_count),_+=this.__items.join("")),_},c.prototype.get_indent_size=function(_,S){var x=this.__base_string_length;return S=S||0,_<0&&(x=0),x+=_*this.__indent_size,x+=S},c.prototype.get_indent_string=function(_,S){var x=this.__base_string;return S=S||0,_<0&&(_=0,x=""),S+=_*this.__indent_size,this.__ensure_cache(S),x+=this.__cache[S]},c.prototype.__ensure_cache=function(_){for(;_>=this.__cache.length;)this.__add_column()},c.prototype.__add_column=function(){var _=this.__cache.length,S=0,x="";this.__indent_size&&_>=this.__indent_size&&(_-=(S=Math.floor(_/this.__indent_size))*this.__indent_size,x=new Array(S+1).join(this.__indent_string)),_&&(x+=new Array(_+1).join(" ")),this.__cache.push(x)},l.prototype.__add_outputline=function(){this.previous_line=this.current_line,this.current_line=this.next_line.clone_empty(),this.__lines.push(this.current_line)},l.prototype.get_line_number=function(){return this.__lines.length},l.prototype.get_indent_string=function(_,S){return this.__indent_cache.get_indent_string(_,S)},l.prototype.get_indent_size=function(_,S){return this.__indent_cache.get_indent_size(_,S)},l.prototype.is_empty=function(){return!this.previous_line&&this.current_line.is_empty()},l.prototype.add_new_line=function(_){return!(this.is_empty()||!_&&this.just_added_newline())&&(this.raw||this.__add_outputline(),!0)},l.prototype.get_code=function(_){this.trim(!0);var S=this.current_line.pop();S&&("\n"===S[S.length-1]&&(S=S.replace(/\n+$/g,"")),this.current_line.push(S)),this._end_with_newline&&this.__add_outputline();var x=this.__lines.join("\n");return"\n"!==_&&(x=x.replace(/[\n]/g,_)),x},l.prototype.set_wrap_point=function(){this.current_line._set_wrap_point()},l.prototype.set_indent=function(_,S){return _=_||0,S=S||0,this.next_line.set_indent(_,S),this.__lines.length>1?(this.current_line.set_indent(_,S),!0):(this.current_line.set_indent(),!1)},l.prototype.add_raw_token=function(_){for(var S=0;S<_.newlines;S++)this.__add_outputline();this.current_line.set_indent(-1),this.current_line.push(_.whitespace_before),this.current_line.push(_.text),this.space_before_token=!1,this.non_breaking_space=!1,this.previous_token_wrapped=!1},l.prototype.add_token=function(_){this.__add_space_before_token(),this.current_line.push(_),this.space_before_token=!1,this.non_breaking_space=!1,this.previous_token_wrapped=this.current_line._allow_wrap()},l.prototype.__add_space_before_token=function(){this.space_before_token&&!this.just_added_newline()&&(this.non_breaking_space||this.set_wrap_point(),this.current_line.push(" "))},l.prototype.remove_indent=function(_){for(var S=this.__lines.length;_<S;)this.__lines[_]._remove_indent(),_++;this.current_line._remove_wrap_indent()},l.prototype.trim=function(_){for(_=void 0!==_&&_,this.current_line.trim();_&&this.__lines.length>1&&this.current_line.is_empty();)this.__lines.pop(),this.current_line=this.__lines[this.__lines.length-1],this.current_line.trim();this.previous_line=this.__lines.length>1?this.__lines[this.__lines.length-2]:null},l.prototype.just_added_newline=function(){return this.current_line.is_empty()},l.prototype.just_added_blankline=function(){return this.is_empty()||this.current_line.is_empty()&&this.previous_line.is_empty()},l.prototype.ensure_empty_line_above=function(_,S){for(var x=this.__lines.length-2;x>=0;){var L=this.__lines[x];if(L.is_empty())break;if(0!==L.item(0).indexOf(_)&&L.item(-1)!==S){this.__lines.splice(x+1,0,new a(this)),this.previous_line=this.__lines[this.__lines.length-2];break}x--}},_.exports.Output=l},,,,function(_){function a(_,S){this.raw_options=c(_,S),this.disabled=this._get_boolean("disabled"),this.eol=this._get_characters("eol","auto"),this.end_with_newline=this._get_boolean("end_with_newline"),this.indent_size=this._get_number("indent_size",4),this.indent_char=this._get_characters("indent_char"," "),this.indent_level=this._get_number("indent_level"),this.preserve_newlines=this._get_boolean("preserve_newlines",!0),this.max_preserve_newlines=this._get_number("max_preserve_newlines",32786),this.preserve_newlines||(this.max_preserve_newlines=0),this.indent_with_tabs=this._get_boolean("indent_with_tabs","\t"===this.indent_char),this.indent_with_tabs&&(this.indent_char="\t",1===this.indent_size&&(this.indent_size=4)),this.wrap_line_length=this._get_number("wrap_line_length",this._get_number("max_char")),this.indent_empty_lines=this._get_boolean("indent_empty_lines"),this.templating=this._get_selection_list("templating",["auto","none","django","erb","handlebars","php","smarty"],["auto"])}function c(_,S){var x,L={};for(x in _=l(_))x!==S&&(L[x]=_[x]);if(S&&_[S])for(x in _[S])L[x]=_[S][x];return L}function l(_){var S,x={};for(S in _){x[S.replace(/-/g,"_")]=_[S]}return x}a.prototype._get_array=function(_,S){var x=this.raw_options[_],L=S||[];return"object"==typeof x?null!==x&&"function"==typeof x.concat&&(L=x.concat()):"string"==typeof x&&(L=x.split(/[^a-zA-Z0-9_\/\-]+/)),L},a.prototype._get_boolean=function(_,S){var x=this.raw_options[_];return void 0===x?!!S:!!x},a.prototype._get_characters=function(_,S){var x=this.raw_options[_],L=S||"";return"string"==typeof x&&(L=x.replace(/\\r/,"\r").replace(/\\n/,"\n").replace(/\\t/,"\t")),L},a.prototype._get_number=function(_,S){var x=this.raw_options[_];S=parseInt(S,10),isNaN(S)&&(S=0);var L=parseInt(x,10);return isNaN(L)&&(L=S),L},a.prototype._get_selection=function(_,S,x){var L=this._get_selection_list(_,S,x);if(1!==L.length)throw new Error("Invalid Option Value: The option '"+_+"' can only be one of the following values:\n"+S+"\nYou passed in: '"+this.raw_options[_]+"'");return L[0]},a.prototype._get_selection_list=function(_,S,x){if(!S||0===S.length)throw new Error("Selection list cannot be empty.");if(x=x||[S[0]],!this._is_valid_selection(x,S))throw new Error("Invalid Default Value!");var L=this._get_array(_,x);if(!this._is_valid_selection(L,S))throw new Error("Invalid Option Value: The option '"+_+"' can contain only the following values:\n"+S+"\nYou passed in: '"+this.raw_options[_]+"'");return L},a.prototype._is_valid_selection=function(_,S){return _.length&&S.length&&!_.some((function(_){return-1===S.indexOf(_)}))},_.exports.Options=a,_.exports.normalizeOpts=l,_.exports.mergeOpts=c},,function(_){var S=RegExp.prototype.hasOwnProperty("sticky");function c(_){this.__input=_||"",this.__input_length=this.__input.length,this.__position=0}c.prototype.restart=function(){this.__position=0},c.prototype.back=function(){this.__position>0&&(this.__position-=1)},c.prototype.hasNext=function(){return this.__position<this.__input_length},c.prototype.next=function(){var _=null;return this.hasNext()&&(_=this.__input.charAt(this.__position),this.__position+=1),_},c.prototype.peek=function(_){var S=null;return _=_||0,(_+=this.__position)>=0&&_<this.__input_length&&(S=this.__input.charAt(_)),S},c.prototype.__match=function(_,x){_.lastIndex=x;var L=_.exec(this.__input);return L&&!(S&&_.sticky)&&L.index!==x&&(L=null),L},c.prototype.test=function(_,S){return S=S||0,(S+=this.__position)>=0&&S<this.__input_length&&!!this.__match(_,S)},c.prototype.testChar=function(_,S){var x=this.peek(S);return _.lastIndex=0,null!==x&&_.test(x)},c.prototype.match=function(_){var S=this.__match(_,this.__position);return S?this.__position+=S[0].length:S=null,S},c.prototype.read=function(_,S,x){var L,z="";return _&&((L=this.match(_))&&(z+=L[0])),S&&(L||!_)&&(z+=this.readUntil(S,x)),z},c.prototype.readUntil=function(_,S){var x,L=this.__position;_.lastIndex=this.__position;var z=_.exec(this.__input);return z?(L=z.index,S&&(L+=z[0].length)):L=this.__input_length,x=this.__input.substring(this.__position,L),this.__position=L,x},c.prototype.readUntilAfter=function(_){return this.readUntil(_,!0)},c.prototype.get_regexp=function(_,x){var L=null,z="g";return x&&S&&(z="y"),"string"==typeof _&&""!==_?L=new RegExp(_,z):_&&(L=new RegExp(_.source,z)),L},c.prototype.get_literal_regexp=function(_){return RegExp(_.replace(/[-\/\\^$*+?.()|[\]{}]/g,"\\$&"))},c.prototype.peekUntilAfter=function(_){var S=this.__position,x=this.readUntilAfter(_);return this.__position=S,x},c.prototype.lookBack=function(_){var S=this.__position-1;return S>=_.length&&this.__input.substring(S-_.length,S).toLowerCase()===_},_.exports.InputScanner=c},,,,,function(_){function a(_,S){_="string"==typeof _?_:_.source,S="string"==typeof S?S:S.source,this.__directives_block_pattern=new RegExp(_+/ beautify( \w+[:]\w+)+ /.source+S,"g"),this.__directive_pattern=/ (\w+)[:](\w+)/g,this.__directives_end_ignore_pattern=new RegExp(_+/\sbeautify\signore:end\s/.source+S,"g")}a.prototype.get_directives=function(_){if(!_.match(this.__directives_block_pattern))return null;var S={};this.__directive_pattern.lastIndex=0;for(var x=this.__directive_pattern.exec(_);x;)S[x[1]]=x[2],x=this.__directive_pattern.exec(_);return S},a.prototype.readIgnored=function(_){return _.readUntilAfter(this.__directives_end_ignore_pattern)},_.exports.Directives=a},,function(_,S,x){var L=x(16).Beautifier,z=x(17).Options;_.exports=function s(_,S){return new L(_,S).beautify()},_.exports.defaultOptions=function(){return new z}},function(_,S,x){var L=x(17).Options,z=x(2).Output,C=x(8).InputScanner,H=new(0,x(13).Directives)(/\/\*/,/\*\//),W=/\r\n|[\r\n]/,D=/\r\n|[\r\n]/g,O=/\s/,q=/(?:\s|\n)+/g,P=/\/\*(?:[\s\S]*?)((?:\*\/)|$)/g,V=/\/\/(?:[^\n\r\u2028\u2029]*)/g;function w(_,S){this._source_text=_||"",this._options=new L(S),this._ch=null,this._input=null,this.NESTED_AT_RULE={"@page":!0,"@font-face":!0,"@keyframes":!0,"@media":!0,"@supports":!0,"@document":!0},this.CONDITIONAL_GROUP_RULE={"@media":!0,"@supports":!0,"@document":!0}}w.prototype.eatString=function(_){var S="";for(this._ch=this._input.next();this._ch;){if(S+=this._ch,"\\"===this._ch)S+=this._input.next();else if(-1!==_.indexOf(this._ch)||"\n"===this._ch)break;this._ch=this._input.next()}return S},w.prototype.eatWhitespace=function(_){for(var S=O.test(this._input.peek()),x=0;O.test(this._input.peek());)this._ch=this._input.next(),_&&"\n"===this._ch&&(0===x||x<this._options.max_preserve_newlines)&&(x++,this._output.add_new_line(!0));return S},w.prototype.foundNestedPseudoClass=function(){for(var _=0,S=1,x=this._input.peek(S);x;){if("{"===x)return!0;if("("===x)_+=1;else if(")"===x){if(0===_)return!1;_-=1}else if(";"===x||"}"===x)return!1;S++,x=this._input.peek(S)}return!1},w.prototype.print_string=function(_){this._output.set_indent(this._indentLevel),this._output.non_breaking_space=!0,this._output.add_token(_)},w.prototype.preserveSingleSpace=function(_){_&&(this._output.space_before_token=!0)},w.prototype.indent=function(){this._indentLevel++},w.prototype.outdent=function(){this._indentLevel>0&&this._indentLevel--},w.prototype.beautify=function(){if(this._options.disabled)return this._source_text;var _=this._source_text,S=this._options.eol;"auto"===S&&(S="\n",_&&W.test(_||"")&&(S=_.match(W)[0]));var x=(_=_.replace(D,"\n")).match(/^[\t ]*/)[0];this._output=new z(this._options,x),this._input=new C(_),this._indentLevel=0,this._nestedLevel=0,this._ch=null;for(var L,K,X=0,Y=!1,Q=!1,Z=!1,ee=!1,te=!1,ne=this._ch;L=""!==this._input.read(q),K=ne,this._ch=this._input.next(),"\\"===this._ch&&this._input.hasNext()&&(this._ch+=this._input.next()),ne=this._ch,this._ch;)if("/"===this._ch&&"*"===this._input.peek()){this._output.add_new_line(),this._input.back();var re=this._input.read(P),oe=H.get_directives(re);oe&&"start"===oe.ignore&&(re+=H.readIgnored(this._input)),this.print_string(re),this.eatWhitespace(!0),this._output.add_new_line()}else if("/"===this._ch&&"/"===this._input.peek())this._output.space_before_token=!0,this._input.back(),this.print_string(this._input.read(V)),this.eatWhitespace(!0);else if("@"===this._ch)if(this.preserveSingleSpace(L),"{"===this._input.peek())this.print_string(this._ch+this.eatString("}"));else{this.print_string(this._ch);var se=this._input.peekUntilAfter(/[: ,;{}()[\]\/='"]/g);se.match(/[ :]$/)&&(se=this.eatString(": ").replace(/\s$/,""),this.print_string(se),this._output.space_before_token=!0),"extend"===(se=se.replace(/\s$/,""))?ee=!0:"import"===se&&(te=!0),se in this.NESTED_AT_RULE?(this._nestedLevel+=1,se in this.CONDITIONAL_GROUP_RULE&&(Z=!0)):!Y&&0===X&&-1!==se.indexOf(":")&&(Q=!0,this.indent())}else"#"===this._ch&&"{"===this._input.peek()?(this.preserveSingleSpace(L),this.print_string(this._ch+this.eatString("}"))):"{"===this._ch?(Q&&(Q=!1,this.outdent()),Z?(Z=!1,Y=this._indentLevel>=this._nestedLevel):Y=this._indentLevel>=this._nestedLevel-1,this._options.newline_between_rules&&Y&&this._output.previous_line&&"{"!==this._output.previous_line.item(-1)&&this._output.ensure_empty_line_above("/",","),this._output.space_before_token=!0,"expand"===this._options.brace_style?(this._output.add_new_line(),this.print_string(this._ch),this.indent(),this._output.set_indent(this._indentLevel)):(this.indent(),this.print_string(this._ch)),this.eatWhitespace(!0),this._output.add_new_line()):"}"===this._ch?(this.outdent(),this._output.add_new_line(),"{"===K&&this._output.trim(!0),te=!1,ee=!1,Q&&(this.outdent(),Q=!1),this.print_string(this._ch),Y=!1,this._nestedLevel&&this._nestedLevel--,this.eatWhitespace(!0),this._output.add_new_line(),this._options.newline_between_rules&&!this._output.just_added_blankline()&&"}"!==this._input.peek()&&this._output.add_new_line(!0)):":"===this._ch?!Y&&!Z||this._input.lookBack("&")||this.foundNestedPseudoClass()||this._input.lookBack("(")||ee||0!==X?(this._input.lookBack(" ")&&(this._output.space_before_token=!0),":"===this._input.peek()?(this._ch=this._input.next(),this.print_string("::")):this.print_string(":")):(this.print_string(":"),Q||(Q=!0,this._output.space_before_token=!0,this.eatWhitespace(!0),this.indent())):'"'===this._ch||"'"===this._ch?(this.preserveSingleSpace(L),this.print_string(this._ch+this.eatString(this._ch)),this.eatWhitespace(!0)):";"===this._ch?0===X?(Q&&(this.outdent(),Q=!1),ee=!1,te=!1,this.print_string(this._ch),this.eatWhitespace(!0),"/"!==this._input.peek()&&this._output.add_new_line()):(this.print_string(this._ch),this.eatWhitespace(!0),this._output.space_before_token=!0):"("===this._ch?this._input.lookBack("url")?(this.print_string(this._ch),this.eatWhitespace(),X++,this.indent(),this._ch=this._input.next(),")"===this._ch||'"'===this._ch||"'"===this._ch?this._input.back():this._ch&&(this.print_string(this._ch+this.eatString(")")),X&&(X--,this.outdent()))):(this.preserveSingleSpace(L),this.print_string(this._ch),this.eatWhitespace(),X++,this.indent()):")"===this._ch?(X&&(X--,this.outdent()),this.print_string(this._ch)):","===this._ch?(this.print_string(this._ch),this.eatWhitespace(!0),!this._options.selector_separator_newline||Q||0!==X||te||ee?this._output.space_before_token=!0:this._output.add_new_line()):">"!==this._ch&&"+"!==this._ch&&"~"!==this._ch||Q||0!==X?"]"===this._ch?this.print_string(this._ch):"["===this._ch?(this.preserveSingleSpace(L),this.print_string(this._ch)):"="===this._ch?(this.eatWhitespace(),this.print_string("="),O.test(this._ch)&&(this._ch="")):"!"!==this._ch||this._input.lookBack("\\")?(this.preserveSingleSpace(L),this.print_string(this._ch)):(this.print_string(" "),this.print_string(this._ch)):this._options.space_around_combinator?(this._output.space_before_token=!0,this.print_string(this._ch),this._output.space_before_token=!0):(this.print_string(this._ch),this.eatWhitespace(),this._ch&&O.test(this._ch)&&(this._ch=""));return this._output.get_code(S)},_.exports.Beautifier=w},function(_,S,x){var L=x(6).Options;function r(_){L.call(this,_,"css"),this.selector_separator_newline=this._get_boolean("selector_separator_newline",!0),this.newline_between_rules=this._get_boolean("newline_between_rules",!0);var S=this._get_boolean("space_around_selector_separator");this.space_around_combinator=this._get_boolean("space_around_combinator")||S;var x=this._get_selection_list("brace_style",["collapse","expand","end-expand","none","preserve-inline"]);this.brace_style="collapse";for(var z=0;z<x.length;z++)"expand"!==x[z]?this.brace_style="collapse":this.brace_style=x[z]}r.prototype=new L,_.exports.Options=r}],S={};var x=function o(x){var L=S[x];if(void 0!==L)return L.exports;var z=S[x]={exports:{}};return _[x](z,z.exports,o),z.exports}(15);un=x}();var An,Ln,En=un;function sn(_,S,x){var C=_.getText(),H=!0,W=0,D=x.tabSize||4;if(S){for(var O=_.offsetAt(S.start),q=O;q>0&&on(C,q-1);)q--;0===q||an(C,q-1)?O=q:q<O&&(O=q+1);for(var P=_.offsetAt(S.end),V=P;V<C.length&&on(C,V);)V++;(V===C.length||an(C,V))&&(P=V),S=z.create(_.positionAt(O),_.positionAt(P));var K=C.substring(0,O);if(new RegExp(/.*[<][^>]*$/).test(K))return[{range:S,newText:C=C.substring(O,P)}];if(H=P===C.length,C=C.substring(O,P),0!==O){var X=_.offsetAt(L.create(S.start.line,0));W=function _i(_,S,x){for(var L=S,z=0,C=x.tabSize||4;L<_.length;){var H=_.charAt(L);if(" "===H)z++;else{if("\t"!==H)break;z+=C}L++}return Math.floor(z/C)}(_.getText(),X,x)}}else S=z.create(L.create(0,0),_.positionAt(C.length));var Y={indent_size:D,indent_char:x.insertSpaces?" ":"\t",indent_empty_lines:ie(x,"indentEmptyLines",!1),wrap_line_length:ie(x,"wrapLineLength",120),unformatted:pt(x,"unformatted",void 0),content_unformatted:pt(x,"contentUnformatted",void 0),indent_inner_html:ie(x,"indentInnerHtml",!1),preserve_newlines:ie(x,"preserveNewLines",!0),max_preserve_newlines:ie(x,"maxPreserveNewLines",32786),indent_handlebars:ie(x,"indentHandlebars",!1),end_with_newline:H&&ie(x,"endWithNewline",!1),extra_liners:pt(x,"extraLiners",void 0),wrap_attributes:ie(x,"wrapAttributes","auto"),wrap_attributes_indent_size:ie(x,"wrapAttributesIndentSize",void 0),eol:"\n",indent_scripts:ie(x,"indentScripts","normal"),templating:wi(x,"all"),unformatted_content_delimiter:ie(x,"unformattedContentDelimiter","")},Q=function rn(_,S){return An(_,S,Kt,En)}(function vi(_){return _.replace(/^\s+/,"")}(C),Y);if(W>0){var Z=x.insertSpaces?dt(" ",D*W):dt("\t",W);Q=Q.split("\n").join("\n"+Z),0===S.start.character&&(Q=Z+Q)}return[{range:S,newText:Q}]}function ie(_,S,x){if(_&&_.hasOwnProperty(S)){var L=_[S];if(null!==L)return L}return x}function pt(_,S,x){var L=ie(_,S,null);return"string"==typeof L?L.length>0?L.split(",").map((function(_){return _.trim().toLowerCase()})):[]:x}function wi(_,S){return!0===ie(_,"templating",S)?["auto"]:["none"]}function an(_,S){return-1!=="\r\n".indexOf(_.charAt(S))}function on(_,S){return-1!==" \t".indexOf(_.charAt(S))}!function(){var _=[,,function(_){function a(_){this.__parent=_,this.__character_count=0,this.__indent_count=-1,this.__alignment_count=0,this.__wrap_point_index=0,this.__wrap_point_character_count=0,this.__wrap_point_indent_count=-1,this.__wrap_point_alignment_count=0,this.__items=[]}function c(_,S){this.__cache=[""],this.__indent_size=_.indent_size,this.__indent_string=_.indent_char,_.indent_with_tabs||(this.__indent_string=new Array(_.indent_size+1).join(_.indent_char)),S=S||"",_.indent_level>0&&(S=new Array(_.indent_level+1).join(this.__indent_string)),this.__base_string=S,this.__base_string_length=S.length}function l(_,S){this.__indent_cache=new c(_,S),this.raw=!1,this._end_with_newline=_.end_with_newline,this.indent_size=_.indent_size,this.wrap_line_length=_.wrap_line_length,this.indent_empty_lines=_.indent_empty_lines,this.__lines=[],this.previous_line=null,this.current_line=null,this.next_line=new a(this),this.space_before_token=!1,this.non_breaking_space=!1,this.previous_token_wrapped=!1,this.__add_outputline()}a.prototype.clone_empty=function(){var _=new a(this.__parent);return _.set_indent(this.__indent_count,this.__alignment_count),_},a.prototype.item=function(_){return _<0?this.__items[this.__items.length+_]:this.__items[_]},a.prototype.has_match=function(_){for(var S=this.__items.length-1;S>=0;S--)if(this.__items[S].match(_))return!0;return!1},a.prototype.set_indent=function(_,S){this.is_empty()&&(this.__indent_count=_||0,this.__alignment_count=S||0,this.__character_count=this.__parent.get_indent_size(this.__indent_count,this.__alignment_count))},a.prototype._set_wrap_point=function(){this.__parent.wrap_line_length&&(this.__wrap_point_index=this.__items.length,this.__wrap_point_character_count=this.__character_count,this.__wrap_point_indent_count=this.__parent.next_line.__indent_count,this.__wrap_point_alignment_count=this.__parent.next_line.__alignment_count)},a.prototype._should_wrap=function(){return this.__wrap_point_index&&this.__character_count>this.__parent.wrap_line_length&&this.__wrap_point_character_count>this.__parent.next_line.__character_count},a.prototype._allow_wrap=function(){if(this._should_wrap()){this.__parent.add_new_line();var _=this.__parent.current_line;return _.set_indent(this.__wrap_point_indent_count,this.__wrap_point_alignment_count),_.__items=this.__items.slice(this.__wrap_point_index),this.__items=this.__items.slice(0,this.__wrap_point_index),_.__character_count+=this.__character_count-this.__wrap_point_character_count,this.__character_count=this.__wrap_point_character_count," "===_.__items[0]&&(_.__items.splice(0,1),_.__character_count-=1),!0}return!1},a.prototype.is_empty=function(){return 0===this.__items.length},a.prototype.last=function(){return this.is_empty()?null:this.__items[this.__items.length-1]},a.prototype.push=function(_){this.__items.push(_);var S=_.lastIndexOf("\n");-1!==S?this.__character_count=_.length-S:this.__character_count+=_.length},a.prototype.pop=function(){var _=null;return this.is_empty()||(_=this.__items.pop(),this.__character_count-=_.length),_},a.prototype._remove_indent=function(){this.__indent_count>0&&(this.__indent_count-=1,this.__character_count-=this.__parent.indent_size)},a.prototype._remove_wrap_indent=function(){this.__wrap_point_indent_count>0&&(this.__wrap_point_indent_count-=1)},a.prototype.trim=function(){for(;" "===this.last();)this.__items.pop(),this.__character_count-=1},a.prototype.toString=function(){var _="";return this.is_empty()?this.__parent.indent_empty_lines&&(_=this.__parent.get_indent_string(this.__indent_count)):(_=this.__parent.get_indent_string(this.__indent_count,this.__alignment_count),_+=this.__items.join("")),_},c.prototype.get_indent_size=function(_,S){var x=this.__base_string_length;return S=S||0,_<0&&(x=0),x+=_*this.__indent_size,x+=S},c.prototype.get_indent_string=function(_,S){var x=this.__base_string;return S=S||0,_<0&&(_=0,x=""),S+=_*this.__indent_size,this.__ensure_cache(S),x+=this.__cache[S]},c.prototype.__ensure_cache=function(_){for(;_>=this.__cache.length;)this.__add_column()},c.prototype.__add_column=function(){var _=this.__cache.length,S=0,x="";this.__indent_size&&_>=this.__indent_size&&(_-=(S=Math.floor(_/this.__indent_size))*this.__indent_size,x=new Array(S+1).join(this.__indent_string)),_&&(x+=new Array(_+1).join(" ")),this.__cache.push(x)},l.prototype.__add_outputline=function(){this.previous_line=this.current_line,this.current_line=this.next_line.clone_empty(),this.__lines.push(this.current_line)},l.prototype.get_line_number=function(){return this.__lines.length},l.prototype.get_indent_string=function(_,S){return this.__indent_cache.get_indent_string(_,S)},l.prototype.get_indent_size=function(_,S){return this.__indent_cache.get_indent_size(_,S)},l.prototype.is_empty=function(){return!this.previous_line&&this.current_line.is_empty()},l.prototype.add_new_line=function(_){return!(this.is_empty()||!_&&this.just_added_newline())&&(this.raw||this.__add_outputline(),!0)},l.prototype.get_code=function(_){this.trim(!0);var S=this.current_line.pop();S&&("\n"===S[S.length-1]&&(S=S.replace(/\n+$/g,"")),this.current_line.push(S)),this._end_with_newline&&this.__add_outputline();var x=this.__lines.join("\n");return"\n"!==_&&(x=x.replace(/[\n]/g,_)),x},l.prototype.set_wrap_point=function(){this.current_line._set_wrap_point()},l.prototype.set_indent=function(_,S){return _=_||0,S=S||0,this.next_line.set_indent(_,S),this.__lines.length>1?(this.current_line.set_indent(_,S),!0):(this.current_line.set_indent(),!1)},l.prototype.add_raw_token=function(_){for(var S=0;S<_.newlines;S++)this.__add_outputline();this.current_line.set_indent(-1),this.current_line.push(_.whitespace_before),this.current_line.push(_.text),this.space_before_token=!1,this.non_breaking_space=!1,this.previous_token_wrapped=!1},l.prototype.add_token=function(_){this.__add_space_before_token(),this.current_line.push(_),this.space_before_token=!1,this.non_breaking_space=!1,this.previous_token_wrapped=this.current_line._allow_wrap()},l.prototype.__add_space_before_token=function(){this.space_before_token&&!this.just_added_newline()&&(this.non_breaking_space||this.set_wrap_point(),this.current_line.push(" "))},l.prototype.remove_indent=function(_){for(var S=this.__lines.length;_<S;)this.__lines[_]._remove_indent(),_++;this.current_line._remove_wrap_indent()},l.prototype.trim=function(_){for(_=void 0!==_&&_,this.current_line.trim();_&&this.__lines.length>1&&this.current_line.is_empty();)this.__lines.pop(),this.current_line=this.__lines[this.__lines.length-1],this.current_line.trim();this.previous_line=this.__lines.length>1?this.__lines[this.__lines.length-2]:null},l.prototype.just_added_newline=function(){return this.current_line.is_empty()},l.prototype.just_added_blankline=function(){return this.is_empty()||this.current_line.is_empty()&&this.previous_line.is_empty()},l.prototype.ensure_empty_line_above=function(_,S){for(var x=this.__lines.length-2;x>=0;){var L=this.__lines[x];if(L.is_empty())break;if(0!==L.item(0).indexOf(_)&&L.item(-1)!==S){this.__lines.splice(x+1,0,new a(this)),this.previous_line=this.__lines[this.__lines.length-2];break}x--}},_.exports.Output=l},function(_){_.exports.Token=function a(_,S,x,L){this.type=_,this.text=S,this.comments_before=null,this.newlines=x||0,this.whitespace_before=L||"",this.parent=null,this.next=null,this.previous=null,this.opened=null,this.closed=null,this.directives=null}},,,function(_){function a(_,S){this.raw_options=c(_,S),this.disabled=this._get_boolean("disabled"),this.eol=this._get_characters("eol","auto"),this.end_with_newline=this._get_boolean("end_with_newline"),this.indent_size=this._get_number("indent_size",4),this.indent_char=this._get_characters("indent_char"," "),this.indent_level=this._get_number("indent_level"),this.preserve_newlines=this._get_boolean("preserve_newlines",!0),this.max_preserve_newlines=this._get_number("max_preserve_newlines",32786),this.preserve_newlines||(this.max_preserve_newlines=0),this.indent_with_tabs=this._get_boolean("indent_with_tabs","\t"===this.indent_char),this.indent_with_tabs&&(this.indent_char="\t",1===this.indent_size&&(this.indent_size=4)),this.wrap_line_length=this._get_number("wrap_line_length",this._get_number("max_char")),this.indent_empty_lines=this._get_boolean("indent_empty_lines"),this.templating=this._get_selection_list("templating",["auto","none","django","erb","handlebars","php","smarty"],["auto"])}function c(_,S){var x,L={};for(x in _=l(_))x!==S&&(L[x]=_[x]);if(S&&_[S])for(x in _[S])L[x]=_[S][x];return L}function l(_){var S,x={};for(S in _){x[S.replace(/-/g,"_")]=_[S]}return x}a.prototype._get_array=function(_,S){var x=this.raw_options[_],L=S||[];return"object"==typeof x?null!==x&&"function"==typeof x.concat&&(L=x.concat()):"string"==typeof x&&(L=x.split(/[^a-zA-Z0-9_\/\-]+/)),L},a.prototype._get_boolean=function(_,S){var x=this.raw_options[_];return void 0===x?!!S:!!x},a.prototype._get_characters=function(_,S){var x=this.raw_options[_],L=S||"";return"string"==typeof x&&(L=x.replace(/\\r/,"\r").replace(/\\n/,"\n").replace(/\\t/,"\t")),L},a.prototype._get_number=function(_,S){var x=this.raw_options[_];S=parseInt(S,10),isNaN(S)&&(S=0);var L=parseInt(x,10);return isNaN(L)&&(L=S),L},a.prototype._get_selection=function(_,S,x){var L=this._get_selection_list(_,S,x);if(1!==L.length)throw new Error("Invalid Option Value: The option '"+_+"' can only be one of the following values:\n"+S+"\nYou passed in: '"+this.raw_options[_]+"'");return L[0]},a.prototype._get_selection_list=function(_,S,x){if(!S||0===S.length)throw new Error("Selection list cannot be empty.");if(x=x||[S[0]],!this._is_valid_selection(x,S))throw new Error("Invalid Default Value!");var L=this._get_array(_,x);if(!this._is_valid_selection(L,S))throw new Error("Invalid Option Value: The option '"+_+"' can contain only the following values:\n"+S+"\nYou passed in: '"+this.raw_options[_]+"'");return L},a.prototype._is_valid_selection=function(_,S){return _.length&&S.length&&!_.some((function(_){return-1===S.indexOf(_)}))},_.exports.Options=a,_.exports.normalizeOpts=l,_.exports.mergeOpts=c},,function(_){var S=RegExp.prototype.hasOwnProperty("sticky");function c(_){this.__input=_||"",this.__input_length=this.__input.length,this.__position=0}c.prototype.restart=function(){this.__position=0},c.prototype.back=function(){this.__position>0&&(this.__position-=1)},c.prototype.hasNext=function(){return this.__position<this.__input_length},c.prototype.next=function(){var _=null;return this.hasNext()&&(_=this.__input.charAt(this.__position),this.__position+=1),_},c.prototype.peek=function(_){var S=null;return _=_||0,(_+=this.__position)>=0&&_<this.__input_length&&(S=this.__input.charAt(_)),S},c.prototype.__match=function(_,x){_.lastIndex=x;var L=_.exec(this.__input);return L&&!(S&&_.sticky)&&L.index!==x&&(L=null),L},c.prototype.test=function(_,S){return S=S||0,(S+=this.__position)>=0&&S<this.__input_length&&!!this.__match(_,S)},c.prototype.testChar=function(_,S){var x=this.peek(S);return _.lastIndex=0,null!==x&&_.test(x)},c.prototype.match=function(_){var S=this.__match(_,this.__position);return S?this.__position+=S[0].length:S=null,S},c.prototype.read=function(_,S,x){var L,z="";return _&&((L=this.match(_))&&(z+=L[0])),S&&(L||!_)&&(z+=this.readUntil(S,x)),z},c.prototype.readUntil=function(_,S){var x,L=this.__position;_.lastIndex=this.__position;var z=_.exec(this.__input);return z?(L=z.index,S&&(L+=z[0].length)):L=this.__input_length,x=this.__input.substring(this.__position,L),this.__position=L,x},c.prototype.readUntilAfter=function(_){return this.readUntil(_,!0)},c.prototype.get_regexp=function(_,x){var L=null,z="g";return x&&S&&(z="y"),"string"==typeof _&&""!==_?L=new RegExp(_,z):_&&(L=new RegExp(_.source,z)),L},c.prototype.get_literal_regexp=function(_){return RegExp(_.replace(/[-\/\\^$*+?.()|[\]{}]/g,"\\$&"))},c.prototype.peekUntilAfter=function(_){var S=this.__position,x=this.readUntilAfter(_);return this.__position=S,x},c.prototype.lookBack=function(_){var S=this.__position-1;return S>=_.length&&this.__input.substring(S-_.length,S).toLowerCase()===_},_.exports.InputScanner=c},function(_,S,x){var L=x(8).InputScanner,z=x(3).Token,C=x(10).TokenStream,H=x(11).WhitespacePattern,W={START:"TK_START",RAW:"TK_RAW",EOF:"TK_EOF"},d=function(_,S){this._input=new L(_),this._options=S||{},this.__tokens=null,this._patterns={},this._patterns.whitespace=new H(this._input)};d.prototype.tokenize=function(){this._input.restart(),this.__tokens=new C,this._reset();for(var _,S=new z(W.START,""),x=null,L=[],H=new C;S.type!==W.EOF;){for(_=this._get_next_token(S,x);this._is_comment(_);)H.add(_),_=this._get_next_token(S,x);H.isEmpty()||(_.comments_before=H,H=new C),_.parent=x,this._is_opening(_)?(L.push(x),x=_):x&&this._is_closing(_,x)&&(_.opened=x,x.closed=_,x=L.pop(),_.parent=x),_.previous=S,S.next=_,this.__tokens.add(_),S=_}return this.__tokens},d.prototype._is_first_token=function(){return this.__tokens.isEmpty()},d.prototype._reset=function(){},d.prototype._get_next_token=function(_,S){this._readWhitespace();var x=this._input.read(/.+/g);return x?this._create_token(W.RAW,x):this._create_token(W.EOF,"")},d.prototype._is_comment=function(_){return!1},d.prototype._is_opening=function(_){return!1},d.prototype._is_closing=function(_,S){return!1},d.prototype._create_token=function(_,S){return new z(_,S,this._patterns.whitespace.newline_count,this._patterns.whitespace.whitespace_before_token)},d.prototype._readWhitespace=function(){return this._patterns.whitespace.read()},_.exports.Tokenizer=d,_.exports.TOKEN=W},function(_){function a(_){this.__tokens=[],this.__tokens_length=this.__tokens.length,this.__position=0,this.__parent_token=_}a.prototype.restart=function(){this.__position=0},a.prototype.isEmpty=function(){return 0===this.__tokens_length},a.prototype.hasNext=function(){return this.__position<this.__tokens_length},a.prototype.next=function(){var _=null;return this.hasNext()&&(_=this.__tokens[this.__position],this.__position+=1),_},a.prototype.peek=function(_){var S=null;return _=_||0,(_+=this.__position)>=0&&_<this.__tokens_length&&(S=this.__tokens[_]),S},a.prototype.add=function(_){this.__parent_token&&(_.parent=this.__parent_token),this.__tokens.push(_),this.__tokens_length+=1},_.exports.TokenStream=a},function(_,S,x){var L=x(12).Pattern;function r(_,S){L.call(this,_,S),S?this._line_regexp=this._input.get_regexp(S._line_regexp):this.__set_whitespace_patterns("",""),this.newline_count=0,this.whitespace_before_token=""}r.prototype=new L,r.prototype.__set_whitespace_patterns=function(_,S){_+="\\t ",S+="\\n\\r",this._match_pattern=this._input.get_regexp("["+_+S+"]+",!0),this._newline_regexp=this._input.get_regexp("\\r\\n|["+S+"]")},r.prototype.read=function(){this.newline_count=0,this.whitespace_before_token="";var _=this._input.read(this._match_pattern);if(" "===_)this.whitespace_before_token=" ";else if(_){var S=this.__split(this._newline_regexp,_);this.newline_count=S.length-1,this.whitespace_before_token=S[this.newline_count]}return _},r.prototype.matching=function(_,S){var x=this._create();return x.__set_whitespace_patterns(_,S),x._update(),x},r.prototype._create=function(){return new r(this._input,this)},r.prototype.__split=function(_,S){_.lastIndex=0;for(var x=0,L=[],z=_.exec(S);z;)L.push(S.substring(x,z.index)),x=z.index+z[0].length,z=_.exec(S);return x<S.length?L.push(S.substring(x,S.length)):L.push(""),L},_.exports.WhitespacePattern=r},function(_){function a(_,S){this._input=_,this._starting_pattern=null,this._match_pattern=null,this._until_pattern=null,this._until_after=!1,S&&(this._starting_pattern=this._input.get_regexp(S._starting_pattern,!0),this._match_pattern=this._input.get_regexp(S._match_pattern,!0),this._until_pattern=this._input.get_regexp(S._until_pattern),this._until_after=S._until_after)}a.prototype.read=function(){var _=this._input.read(this._starting_pattern);return(!this._starting_pattern||_)&&(_+=this._input.read(this._match_pattern,this._until_pattern,this._until_after)),_},a.prototype.read_match=function(){return this._input.match(this._match_pattern)},a.prototype.until_after=function(_){var S=this._create();return S._until_after=!0,S._until_pattern=this._input.get_regexp(_),S._update(),S},a.prototype.until=function(_){var S=this._create();return S._until_after=!1,S._until_pattern=this._input.get_regexp(_),S._update(),S},a.prototype.starting_with=function(_){var S=this._create();return S._starting_pattern=this._input.get_regexp(_,!0),S._update(),S},a.prototype.matching=function(_){var S=this._create();return S._match_pattern=this._input.get_regexp(_,!0),S._update(),S},a.prototype._create=function(){return new a(this._input,this)},a.prototype._update=function(){},_.exports.Pattern=a},function(_){function a(_,S){_="string"==typeof _?_:_.source,S="string"==typeof S?S:S.source,this.__directives_block_pattern=new RegExp(_+/ beautify( \w+[:]\w+)+ /.source+S,"g"),this.__directive_pattern=/ (\w+)[:](\w+)/g,this.__directives_end_ignore_pattern=new RegExp(_+/\sbeautify\signore:end\s/.source+S,"g")}a.prototype.get_directives=function(_){if(!_.match(this.__directives_block_pattern))return null;var S={};this.__directive_pattern.lastIndex=0;for(var x=this.__directive_pattern.exec(_);x;)S[x[1]]=x[2],x=this.__directive_pattern.exec(_);return S},a.prototype.readIgnored=function(_){return _.readUntilAfter(this.__directives_end_ignore_pattern)},_.exports.Directives=a},function(_,S,x){var L=x(12).Pattern,z={django:!1,erb:!1,handlebars:!1,php:!1,smarty:!1};function s(_,S){L.call(this,_,S),this.__template_pattern=null,this._disabled=Object.assign({},z),this._excluded=Object.assign({},z),S&&(this.__template_pattern=this._input.get_regexp(S.__template_pattern),this._excluded=Object.assign(this._excluded,S._excluded),this._disabled=Object.assign(this._disabled,S._disabled));var x=new L(_);this.__patterns={handlebars_comment:x.starting_with(/{{!--/).until_after(/--}}/),handlebars_unescaped:x.starting_with(/{{{/).until_after(/}}}/),handlebars:x.starting_with(/{{/).until_after(/}}/),php:x.starting_with(/<\?(?:[= ]|php)/).until_after(/\?>/),erb:x.starting_with(/<%[^%]/).until_after(/[^%]%>/),django:x.starting_with(/{%/).until_after(/%}/),django_value:x.starting_with(/{{/).until_after(/}}/),django_comment:x.starting_with(/{#/).until_after(/#}/),smarty:x.starting_with(/{(?=[^}{\s\n])/).until_after(/[^\s\n]}/),smarty_comment:x.starting_with(/{\*/).until_after(/\*}/),smarty_literal:x.starting_with(/{literal}/).until_after(/{\/literal}/)}}s.prototype=new L,s.prototype._create=function(){return new s(this._input,this)},s.prototype._update=function(){this.__set_templated_pattern()},s.prototype.disable=function(_){var S=this._create();return S._disabled[_]=!0,S._update(),S},s.prototype.read_options=function(_){var S=this._create();for(var x in z)S._disabled[x]=-1===_.templating.indexOf(x);return S._update(),S},s.prototype.exclude=function(_){var S=this._create();return S._excluded[_]=!0,S._update(),S},s.prototype.read=function(){var _="";_=this._match_pattern?this._input.read(this._starting_pattern):this._input.read(this._starting_pattern,this.__template_pattern);for(var S=this._read_template();S;)this._match_pattern?S+=this._input.read(this._match_pattern):S+=this._input.readUntil(this.__template_pattern),_+=S,S=this._read_template();return this._until_after&&(_+=this._input.readUntilAfter(this._until_pattern)),_},s.prototype.__set_templated_pattern=function(){var _=[];this._disabled.php||_.push(this.__patterns.php._starting_pattern.source),this._disabled.handlebars||_.push(this.__patterns.handlebars._starting_pattern.source),this._disabled.erb||_.push(this.__patterns.erb._starting_pattern.source),this._disabled.django||(_.push(this.__patterns.django._starting_pattern.source),_.push(this.__patterns.django_value._starting_pattern.source),_.push(this.__patterns.django_comment._starting_pattern.source)),this._disabled.smarty||_.push(this.__patterns.smarty._starting_pattern.source),this._until_pattern&&_.push(this._until_pattern.source),this.__template_pattern=this._input.get_regexp("(?:"+_.join("|")+")")},s.prototype._read_template=function(){var _="",S=this._input.peek();if("<"===S){var x=this._input.peek(1);!this._disabled.php&&!this._excluded.php&&"?"===x&&(_=_||this.__patterns.php.read()),!this._disabled.erb&&!this._excluded.erb&&"%"===x&&(_=_||this.__patterns.erb.read())}else"{"===S&&(!this._disabled.handlebars&&!this._excluded.handlebars&&(_=(_=(_=_||this.__patterns.handlebars_comment.read())||this.__patterns.handlebars_unescaped.read())||this.__patterns.handlebars.read()),this._disabled.django||(!this._excluded.django&&!this._excluded.handlebars&&(_=_||this.__patterns.django_value.read()),this._excluded.django||(_=(_=_||this.__patterns.django_comment.read())||this.__patterns.django.read())),this._disabled.smarty||this._disabled.django&&this._disabled.handlebars&&(_=(_=(_=_||this.__patterns.smarty_comment.read())||this.__patterns.smarty_literal.read())||this.__patterns.smarty.read()));return _},_.exports.TemplatablePattern=s},,,,function(_,S,x){var L=x(19).Beautifier,z=x(20).Options;_.exports=function s(_,S,x,z){return new L(_,S,x,z).beautify()},_.exports.defaultOptions=function(){return new z}},function(_,S,x){var L=x(20).Options,z=x(2).Output,C=x(21).Tokenizer,H=x(21).TOKEN,W=/\r\n|[\r\n]/,D=/\r\n|[\r\n]/g,g=function(_,S){this.indent_level=0,this.alignment_size=0,this.max_preserve_newlines=_.max_preserve_newlines,this.preserve_newlines=_.preserve_newlines,this._output=new z(_,S)};g.prototype.current_line_has_match=function(_){return this._output.current_line.has_match(_)},g.prototype.set_space_before_token=function(_,S){this._output.space_before_token=_,this._output.non_breaking_space=S},g.prototype.set_wrap_point=function(){this._output.set_indent(this.indent_level,this.alignment_size),this._output.set_wrap_point()},g.prototype.add_raw_token=function(_){this._output.add_raw_token(_)},g.prototype.print_preserved_newlines=function(_){var S=0;_.type!==H.TEXT&&_.previous.type!==H.TEXT&&(S=_.newlines?1:0),this.preserve_newlines&&(S=_.newlines<this.max_preserve_newlines+1?_.newlines:this.max_preserve_newlines+1);for(var x=0;x<S;x++)this.print_newline(x>0);return 0!==S},g.prototype.traverse_whitespace=function(_){return!(!_.whitespace_before&&!_.newlines)&&(this.print_preserved_newlines(_)||(this._output.space_before_token=!0),!0)},g.prototype.previous_token_wrapped=function(){return this._output.previous_token_wrapped},g.prototype.print_newline=function(_){this._output.add_new_line(_)},g.prototype.print_token=function(_){_.text&&(this._output.set_indent(this.indent_level,this.alignment_size),this._output.add_token(_.text))},g.prototype.indent=function(){this.indent_level++},g.prototype.get_full_indent=function(_){return(_=this.indent_level+(_||0))<1?"":this._output.get_indent_string(_)};var m=function(_,S){var x=null,L=null;return S.closed?("script"===_?x="text/javascript":"style"===_&&(x="text/css"),x=function(_){for(var S=null,x=_.next;x.type!==H.EOF&&_.closed!==x;){if(x.type===H.ATTRIBUTE&&"type"===x.text){x.next&&x.next.type===H.EQUALS&&x.next.next&&x.next.next.type===H.VALUE&&(S=x.next.next.text);break}x=x.next}return S}(S)||x,x.search("text/css")>-1?L="css":x.search(/module|((text|application|dojo)\/(x-)?(javascript|ecmascript|jscript|livescript|(ld\+)?json|method|aspect))/)>-1?L="javascript":x.search(/(text|application|dojo)\/(x-)?(html)/)>-1?L="html":x.search(/test\/null/)>-1&&(L="null"),L):null};function A(_,S){return-1!==S.indexOf(_)}function E(_,S,x){this.parent=_||null,this.tag=S?S.tag_name:"",this.indent_level=x||0,this.parser_token=S||null}function w(_){this._printer=_,this._current_frame=null}function M(_,S,x,z){this._source_text=_||"",S=S||{},this._js_beautify=x,this._css_beautify=z,this._tag_stack=null;var C=new L(S,"html");this._options=C,this._is_wrap_attributes_force="force"===this._options.wrap_attributes.substr(0,5),this._is_wrap_attributes_force_expand_multiline="force-expand-multiline"===this._options.wrap_attributes,this._is_wrap_attributes_force_aligned="force-aligned"===this._options.wrap_attributes,this._is_wrap_attributes_aligned_multiple="aligned-multiple"===this._options.wrap_attributes,this._is_wrap_attributes_preserve="preserve"===this._options.wrap_attributes.substr(0,8),this._is_wrap_attributes_preserve_aligned="preserve-aligned"===this._options.wrap_attributes}w.prototype.get_parser_token=function(){return this._current_frame?this._current_frame.parser_token:null},w.prototype.record_tag=function(_){var S=new E(this._current_frame,_,this._printer.indent_level);this._current_frame=S},w.prototype._try_pop_frame=function(_){var S=null;return _&&(S=_.parser_token,this._printer.indent_level=_.indent_level,this._current_frame=_.parent),S},w.prototype._get_frame=function(_,S){for(var x=this._current_frame;x&&-1===_.indexOf(x.tag);){if(S&&-1!==S.indexOf(x.tag)){x=null;break}x=x.parent}return x},w.prototype.try_pop=function(_,S){var x=this._get_frame([_],S);return this._try_pop_frame(x)},w.prototype.indent_to_tag=function(_){var S=this._get_frame(_);S&&(this._printer.indent_level=S.indent_level)},M.prototype.beautify=function(){if(this._options.disabled)return this._source_text;var _=this._source_text,S=this._options.eol;"auto"===this._options.eol&&(S="\n",_&&W.test(_)&&(S=_.match(W)[0]));var x=(_=_.replace(D,"\n")).match(/^[\t ]*/)[0],L={text:"",type:""},z=new B,O=new g(this._options,x),q=new C(_,this._options).tokenize();this._tag_stack=new w(O);for(var P=null,V=q.next();V.type!==H.EOF;)V.type===H.TAG_OPEN||V.type===H.COMMENT?z=P=this._handle_tag_open(O,V,z,L):V.type===H.ATTRIBUTE||V.type===H.EQUALS||V.type===H.VALUE||V.type===H.TEXT&&!z.tag_complete?P=this._handle_inside_tag(O,V,z,q):V.type===H.TAG_CLOSE?P=this._handle_tag_close(O,V,z):V.type===H.TEXT?P=this._handle_text(O,V,z):O.add_raw_token(V),L=P,V=q.next();return O._output.get_code(S)},M.prototype._handle_tag_close=function(_,S,x){var L={text:S.text,type:S.type};return _.alignment_size=0,x.tag_complete=!0,_.set_space_before_token(S.newlines||""!==S.whitespace_before,!0),x.is_unformatted?_.add_raw_token(S):("<"===x.tag_start_char&&(_.set_space_before_token("/"===S.text[0],!0),this._is_wrap_attributes_force_expand_multiline&&x.has_wrapped_attrs&&_.print_newline(!1)),_.print_token(S)),x.indent_content&&!(x.is_unformatted||x.is_content_unformatted)&&(_.indent(),x.indent_content=!1),!x.is_inline_element&&!(x.is_unformatted||x.is_content_unformatted)&&_.set_wrap_point(),L},M.prototype._handle_inside_tag=function(_,S,x,L){var z=x.has_wrapped_attrs,C={text:S.text,type:S.type};if(_.set_space_before_token(S.newlines||""!==S.whitespace_before,!0),x.is_unformatted)_.add_raw_token(S);else if("{"===x.tag_start_char&&S.type===H.TEXT)_.print_preserved_newlines(S)?(S.newlines=0,_.add_raw_token(S)):_.print_token(S);else{if(S.type===H.ATTRIBUTE?(_.set_space_before_token(!0),x.attr_count+=1):(S.type===H.EQUALS||S.type===H.VALUE&&S.previous.type===H.EQUALS)&&_.set_space_before_token(!1),S.type===H.ATTRIBUTE&&"<"===x.tag_start_char&&((this._is_wrap_attributes_preserve||this._is_wrap_attributes_preserve_aligned)&&(_.traverse_whitespace(S),z=z||0!==S.newlines),this._is_wrap_attributes_force)){var W=x.attr_count>1;if(this._is_wrap_attributes_force_expand_multiline&&1===x.attr_count){var D,O=!0,q=0;do{if((D=L.peek(q)).type===H.ATTRIBUTE){O=!1;break}q+=1}while(q<4&&D.type!==H.EOF&&D.type!==H.TAG_CLOSE);W=!O}W&&(_.print_newline(!1),z=!0)}_.print_token(S),z=z||_.previous_token_wrapped(),x.has_wrapped_attrs=z}return C},M.prototype._handle_text=function(_,S,x){var L={text:S.text,type:"TK_CONTENT"};return x.custom_beautifier_name?this._print_custom_beatifier_text(_,S,x):x.is_unformatted||x.is_content_unformatted?_.add_raw_token(S):(_.traverse_whitespace(S),_.print_token(S)),L},M.prototype._print_custom_beatifier_text=function(_,S,x){var L=this;if(""!==S.text){var z,C=S.text,H=1,W="",D="";"javascript"===x.custom_beautifier_name&&"function"==typeof this._js_beautify?z=this._js_beautify:"css"===x.custom_beautifier_name&&"function"==typeof this._css_beautify?z=this._css_beautify:"html"===x.custom_beautifier_name&&(z=function(_,S){return new M(_,S,L._js_beautify,L._css_beautify).beautify()}),"keep"===this._options.indent_scripts?H=0:"separate"===this._options.indent_scripts&&(H=-_.indent_level);var O=_.get_full_indent(H);if(C=C.replace(/\n[ \t]*$/,""),"html"!==x.custom_beautifier_name&&"<"===C[0]&&C.match(/^(<!--|<!\[CDATA\[)/)){var q=/^(<!--[^\n]*|<!\[CDATA\[)(\n?)([ \t\n]*)([\s\S]*)(-->|]]>)$/.exec(C);if(!q)return void _.add_raw_token(S);W=O+q[1]+"\n",C=q[4],q[5]&&(D=O+q[5]),C=C.replace(/\n[ \t]*$/,""),(q[2]||-1!==q[3].indexOf("\n"))&&((q=q[3].match(/[ \t]+$/))&&(S.whitespace_before=q[0]))}if(C)if(z){var v=function(){this.eol="\n"};v.prototype=this._options.raw_options,C=z(O+C,new v)}else{var P=S.whitespace_before;P&&(C=C.replace(new RegExp("\n("+P+")?","g"),"\n")),C=O+C.replace(/\n/g,"\n"+O)}W&&(C=C?W+C+"\n"+D:W+D),_.print_newline(!1),C&&(S.text=C,S.whitespace_before="",S.newlines=0,_.add_raw_token(S),_.print_newline(!0))}},M.prototype._handle_tag_open=function(_,S,x,L){var z=this._get_tag_open_token(S);return!x.is_unformatted&&!x.is_content_unformatted||x.is_empty_element||S.type!==H.TAG_OPEN||0!==S.text.indexOf("</")?(_.traverse_whitespace(S),this._set_tag_position(_,S,z,x,L),z.is_inline_element||_.set_wrap_point(),_.print_token(S)):(_.add_raw_token(S),z.start_tag_token=this._tag_stack.try_pop(z.tag_name)),(this._is_wrap_attributes_force_aligned||this._is_wrap_attributes_aligned_multiple||this._is_wrap_attributes_preserve_aligned)&&(z.alignment_size=S.text.length+1),!z.tag_complete&&!z.is_unformatted&&(_.alignment_size=z.alignment_size),z};var B=function(_,S){var x;(this.parent=_||null,this.text="",this.type="TK_TAG_OPEN",this.tag_name="",this.is_inline_element=!1,this.is_unformatted=!1,this.is_content_unformatted=!1,this.is_empty_element=!1,this.is_start_tag=!1,this.is_end_tag=!1,this.indent_content=!1,this.multiline_content=!1,this.custom_beautifier_name=null,this.start_tag_token=null,this.attr_count=0,this.has_wrapped_attrs=!1,this.alignment_size=0,this.tag_complete=!1,this.tag_start_char="",this.tag_check="",S)?(this.tag_start_char=S.text[0],this.text=S.text,"<"===this.tag_start_char?(x=S.text.match(/^<([^\s>]*)/),this.tag_check=x?x[1]:""):(x=S.text.match(/^{{(?:[\^]|#\*?)?([^\s}]+)/),this.tag_check=x?x[1]:"","{{#>"===S.text&&">"===this.tag_check&&null!==S.next&&(this.tag_check=S.next.text)),this.tag_check=this.tag_check.toLowerCase(),S.type===H.COMMENT&&(this.tag_complete=!0),this.is_start_tag="/"!==this.tag_check.charAt(0),this.tag_name=this.is_start_tag?this.tag_check:this.tag_check.substr(1),this.is_end_tag=!this.is_start_tag||S.closed&&"/>"===S.closed.text,this.is_end_tag=this.is_end_tag||"{"===this.tag_start_char&&(this.text.length<3||/[^#\^]/.test(this.text.charAt(2)))):this.tag_complete=!0};M.prototype._get_tag_open_token=function(_){var S=new B(this._tag_stack.get_parser_token(),_);return S.alignment_size=this._options.wrap_attributes_indent_size,S.is_end_tag=S.is_end_tag||A(S.tag_check,this._options.void_elements),S.is_empty_element=S.tag_complete||S.is_start_tag&&S.is_end_tag,S.is_unformatted=!S.tag_complete&&A(S.tag_check,this._options.unformatted),S.is_content_unformatted=!S.is_empty_element&&A(S.tag_check,this._options.content_unformatted),S.is_inline_element=A(S.tag_name,this._options.inline)||"{"===S.tag_start_char,S},M.prototype._set_tag_position=function(_,S,x,L,z){if(x.is_empty_element||(x.is_end_tag?x.start_tag_token=this._tag_stack.try_pop(x.tag_name):(this._do_optional_end_element(x)&&(x.is_inline_element||_.print_newline(!1)),this._tag_stack.record_tag(x),("script"===x.tag_name||"style"===x.tag_name)&&!(x.is_unformatted||x.is_content_unformatted)&&(x.custom_beautifier_name=m(x.tag_check,S)))),A(x.tag_check,this._options.extra_liners)&&(_.print_newline(!1),_._output.just_added_blankline()||_.print_newline(!0)),x.is_empty_element){if("{"===x.tag_start_char&&"else"===x.tag_check)this._tag_stack.indent_to_tag(["if","unless","each"]),x.indent_content=!0,_.current_line_has_match(/{{#if/)||_.print_newline(!1);"!--"===x.tag_name&&z.type===H.TAG_CLOSE&&L.is_end_tag&&-1===x.text.indexOf("\n")||(x.is_inline_element||x.is_unformatted||_.print_newline(!1),this._calcluate_parent_multiline(_,x))}else if(x.is_end_tag){var C=!1;C=(C=x.start_tag_token&&x.start_tag_token.multiline_content)||!x.is_inline_element&&!(L.is_inline_element||L.is_unformatted)&&!(z.type===H.TAG_CLOSE&&x.start_tag_token===L)&&"TK_CONTENT"!==z.type,(x.is_content_unformatted||x.is_unformatted)&&(C=!1),C&&_.print_newline(!1)}else x.indent_content=!x.custom_beautifier_name,"<"===x.tag_start_char&&("html"===x.tag_name?x.indent_content=this._options.indent_inner_html:"head"===x.tag_name?x.indent_content=this._options.indent_head_inner_html:"body"===x.tag_name&&(x.indent_content=this._options.indent_body_inner_html)),!(x.is_inline_element||x.is_unformatted)&&("TK_CONTENT"!==z.type||x.is_content_unformatted)&&_.print_newline(!1),this._calcluate_parent_multiline(_,x)},M.prototype._calcluate_parent_multiline=function(_,S){S.parent&&_._output.just_added_newline()&&(!S.is_inline_element&&!S.is_unformatted||!S.parent.is_inline_element)&&(S.parent.multiline_content=!0)};var O=["address","article","aside","blockquote","details","div","dl","fieldset","figcaption","figure","footer","form","h1","h2","h3","h4","h5","h6","header","hr","main","nav","ol","p","pre","section","table","ul"],q=["a","audio","del","ins","map","noscript","video"];M.prototype._do_optional_end_element=function(_){var S=null;if(!_.is_empty_element&&_.is_start_tag&&_.parent){if("body"===_.tag_name)S=S||this._tag_stack.try_pop("head");else if("li"===_.tag_name)S=S||this._tag_stack.try_pop("li",["ol","ul"]);else if("dd"===_.tag_name||"dt"===_.tag_name)S=(S=S||this._tag_stack.try_pop("dt",["dl"]))||this._tag_stack.try_pop("dd",["dl"]);else if("p"===_.parent.tag_name&&-1!==O.indexOf(_.tag_name)){var x=_.parent.parent;(!x||-1===q.indexOf(x.tag_name))&&(S=S||this._tag_stack.try_pop("p"))}else"rp"===_.tag_name||"rt"===_.tag_name?S=(S=S||this._tag_stack.try_pop("rt",["ruby","rtc"]))||this._tag_stack.try_pop("rp",["ruby","rtc"]):"optgroup"===_.tag_name?S=S||this._tag_stack.try_pop("optgroup",["select"]):"option"===_.tag_name?S=S||this._tag_stack.try_pop("option",["select","datalist","optgroup"]):"colgroup"===_.tag_name?S=S||this._tag_stack.try_pop("caption",["table"]):"thead"===_.tag_name?S=(S=S||this._tag_stack.try_pop("caption",["table"]))||this._tag_stack.try_pop("colgroup",["table"]):"tbody"===_.tag_name||"tfoot"===_.tag_name?S=(S=(S=(S=S||this._tag_stack.try_pop("caption",["table"]))||this._tag_stack.try_pop("colgroup",["table"]))||this._tag_stack.try_pop("thead",["table"]))||this._tag_stack.try_pop("tbody",["table"]):"tr"===_.tag_name?S=(S=(S=S||this._tag_stack.try_pop("caption",["table"]))||this._tag_stack.try_pop("colgroup",["table"]))||this._tag_stack.try_pop("tr",["table","thead","tbody","tfoot"]):("th"===_.tag_name||"td"===_.tag_name)&&(S=(S=S||this._tag_stack.try_pop("td",["table","thead","tbody","tfoot","tr"]))||this._tag_stack.try_pop("th",["table","thead","tbody","tfoot","tr"]));return _.parent=this._tag_stack.get_parser_token(),S}},_.exports.Beautifier=M},function(_,S,x){var L=x(6).Options;function r(_){L.call(this,_,"html"),1===this.templating.length&&"auto"===this.templating[0]&&(this.templating=["django","erb","handlebars","php"]),this.indent_inner_html=this._get_boolean("indent_inner_html"),this.indent_body_inner_html=this._get_boolean("indent_body_inner_html",!0),this.indent_head_inner_html=this._get_boolean("indent_head_inner_html",!0),this.indent_handlebars=this._get_boolean("indent_handlebars",!0),this.wrap_attributes=this._get_selection("wrap_attributes",["auto","force","force-aligned","force-expand-multiline","aligned-multiple","preserve","preserve-aligned"]),this.wrap_attributes_indent_size=this._get_number("wrap_attributes_indent_size",this.indent_size),this.extra_liners=this._get_array("extra_liners",["head","body","/html"]),this.inline=this._get_array("inline",["a","abbr","area","audio","b","bdi","bdo","br","button","canvas","cite","code","data","datalist","del","dfn","em","embed","i","iframe","img","input","ins","kbd","keygen","label","map","mark","math","meter","noscript","object","output","progress","q","ruby","s","samp","select","small","span","strong","sub","sup","svg","template","textarea","time","u","var","video","wbr","text","acronym","big","strike","tt"]),this.void_elements=this._get_array("void_elements",["area","base","br","col","embed","hr","img","input","keygen","link","menuitem","meta","param","source","track","wbr","!doctype","?xml","basefont","isindex"]),this.unformatted=this._get_array("unformatted",[]),this.content_unformatted=this._get_array("content_unformatted",["pre","textarea"]),this.unformatted_content_delimiter=this._get_characters("unformatted_content_delimiter"),this.indent_scripts=this._get_selection("indent_scripts",["normal","keep","separate"])}r.prototype=new L,_.exports.Options=r},function(_,S,x){var L=x(9).Tokenizer,z=x(9).TOKEN,C=x(13).Directives,H=x(14).TemplatablePattern,W=x(12).Pattern,D={TAG_OPEN:"TK_TAG_OPEN",TAG_CLOSE:"TK_TAG_CLOSE",ATTRIBUTE:"TK_ATTRIBUTE",EQUALS:"TK_EQUALS",VALUE:"TK_VALUE",COMMENT:"TK_COMMENT",TEXT:"TK_TEXT",UNKNOWN:"TK_UNKNOWN",START:z.START,RAW:z.RAW,EOF:z.EOF},O=new C(/<\!--/,/-->/),y=function(_,S){L.call(this,_,S),this._current_tag_name="";var x=new H(this._input).read_options(this._options),z=new W(this._input);if(this.__patterns={word:x.until(/[\n\r\t <]/),single_quote:x.until_after(/'/),double_quote:x.until_after(/"/),attribute:x.until(/[\n\r\t =>]|\/>/),element_name:x.until(/[\n\r\t >\/]/),handlebars_comment:z.starting_with(/{{!--/).until_after(/--}}/),handlebars:z.starting_with(/{{/).until_after(/}}/),handlebars_open:z.until(/[\n\r\t }]/),handlebars_raw_close:z.until(/}}/),comment:z.starting_with(/<!--/).until_after(/-->/),cdata:z.starting_with(/<!\[CDATA\[/).until_after(/]]>/),conditional_comment:z.starting_with(/<!\[/).until_after(/]>/),processing:z.starting_with(/<\?/).until_after(/\?>/)},this._options.indent_handlebars&&(this.__patterns.word=this.__patterns.word.exclude("handlebars")),this._unformatted_content_delimiter=null,this._options.unformatted_content_delimiter){var C=this._input.get_literal_regexp(this._options.unformatted_content_delimiter);this.__patterns.unformatted_content_delimiter=z.matching(C).until_after(C)}};(y.prototype=new L)._is_comment=function(_){return!1},y.prototype._is_opening=function(_){return _.type===D.TAG_OPEN},y.prototype._is_closing=function(_,S){return _.type===D.TAG_CLOSE&&S&&((">"===_.text||"/>"===_.text)&&"<"===S.text[0]||"}}"===_.text&&"{"===S.text[0]&&"{"===S.text[1])},y.prototype._reset=function(){this._current_tag_name=""},y.prototype._get_next_token=function(_,S){var x=null;this._readWhitespace();var L=this._input.peek();return null===L?this._create_token(D.EOF,""):x=(x=(x=(x=(x=(x=(x=(x=(x=x||this._read_open_handlebars(L,S))||this._read_attribute(L,_,S))||this._read_close(L,S))||this._read_raw_content(L,_,S))||this._read_content_word(L))||this._read_comment_or_cdata(L))||this._read_processing(L))||this._read_open(L,S))||this._create_token(D.UNKNOWN,this._input.next())},y.prototype._read_comment_or_cdata=function(_){var S=null,x=null,L=null;"<"===_&&("!"===this._input.peek(1)&&((x=this.__patterns.comment.read())?(L=O.get_directives(x))&&"start"===L.ignore&&(x+=O.readIgnored(this._input)):x=this.__patterns.cdata.read()),x&&((S=this._create_token(D.COMMENT,x)).directives=L));return S},y.prototype._read_processing=function(_){var S=null,x=null;if("<"===_){var L=this._input.peek(1);("!"===L||"?"===L)&&(x=(x=this.__patterns.conditional_comment.read())||this.__patterns.processing.read()),x&&((S=this._create_token(D.COMMENT,x)).directives=null)}return S},y.prototype._read_open=function(_,S){var x=null,L=null;return S||"<"===_&&(x=this._input.next(),"/"===this._input.peek()&&(x+=this._input.next()),x+=this.__patterns.element_name.read(),L=this._create_token(D.TAG_OPEN,x)),L},y.prototype._read_open_handlebars=function(_,S){var x=null,L=null;return S||this._options.indent_handlebars&&"{"===_&&"{"===this._input.peek(1)&&("!"===this._input.peek(2)?(x=(x=this.__patterns.handlebars_comment.read())||this.__patterns.handlebars.read(),L=this._create_token(D.COMMENT,x)):(x=this.__patterns.handlebars_open.read(),L=this._create_token(D.TAG_OPEN,x))),L},y.prototype._read_close=function(_,S){var x=null,L=null;return S&&("<"===S.text[0]&&(">"===_||"/"===_&&">"===this._input.peek(1))?(x=this._input.next(),"/"===_&&(x+=this._input.next()),L=this._create_token(D.TAG_CLOSE,x)):"{"===S.text[0]&&"}"===_&&"}"===this._input.peek(1)&&(this._input.next(),this._input.next(),L=this._create_token(D.TAG_CLOSE,"}}"))),L},y.prototype._read_attribute=function(_,S,x){var L=null,z="";if(x&&"<"===x.text[0])if("="===_)L=this._create_token(D.EQUALS,this._input.next());else if('"'===_||"'"===_){var C=this._input.next();C+='"'===_?this.__patterns.double_quote.read():this.__patterns.single_quote.read(),L=this._create_token(D.VALUE,C)}else(z=this.__patterns.attribute.read())&&(L=S.type===D.EQUALS?this._create_token(D.VALUE,z):this._create_token(D.ATTRIBUTE,z));return L},y.prototype._is_content_unformatted=function(_){return-1===this._options.void_elements.indexOf(_)&&(-1!==this._options.content_unformatted.indexOf(_)||-1!==this._options.unformatted.indexOf(_))},y.prototype._read_raw_content=function(_,S,x){var L="";if(x&&"{"===x.text[0])L=this.__patterns.handlebars_raw_close.read();else if(S.type===D.TAG_CLOSE&&"<"===S.opened.text[0]&&"/"!==S.text[0]){var z=S.opened.text.substr(1).toLowerCase();if("script"===z||"style"===z){var C=this._read_comment_or_cdata(_);if(C)return C.type=D.TEXT,C;L=this._input.readUntil(new RegExp("</"+z+"[\\n\\r\\t ]*?>","ig"))}else this._is_content_unformatted(z)&&(L=this._input.readUntil(new RegExp("</"+z+"[\\n\\r\\t ]*?>","ig")))}return L?this._create_token(D.TEXT,L):null},y.prototype._read_content_word=function(_){var S="";if(this._options.unformatted_content_delimiter&&_===this._options.unformatted_content_delimiter[0]&&(S=this.__patterns.unformatted_content_delimiter.read()),S||(S=this.__patterns.word.read()),S)return this._create_token(D.TEXT,S)},_.exports.Tokenizer=y,_.exports.TOKEN=D}],S={};var x=function o(x){var L=S[x];if(void 0!==L)return L.exports;var z=S[x]={exports:{}};return _[x](z,z.exports,o),z.exports}(18);An=x}(),Ln=(()=>{var _={470:_=>{function e(_){if("string"!=typeof _)throw new TypeError("Path must be a string. Received "+JSON.stringify(_))}function a(_,S){for(var x,L="",z=0,C=-1,H=0,W=0;W<=_.length;++W){if(W<_.length)x=_.charCodeAt(W);else{if(47===x)break;x=47}if(47===x){if(C!==W-1&&1!==H)if(C!==W-1&&2===H){if(L.length<2||2!==z||46!==L.charCodeAt(L.length-1)||46!==L.charCodeAt(L.length-2))if(L.length>2){var D=L.lastIndexOf("/");if(D!==L.length-1){-1===D?(L="",z=0):z=(L=L.slice(0,D)).length-1-L.lastIndexOf("/"),C=W,H=0;continue}}else if(2===L.length||1===L.length){L="",z=0,C=W,H=0;continue}S&&(L.length>0?L+="/..":L="..",z=2)}else L.length>0?L+="/"+_.slice(C+1,W):L=_.slice(C+1,W),z=W-C-1;C=W,H=0}else 46===x&&-1!==H?++H:H=-1}return L}var S={resolve:function(){for(var _,S="",x=!1,L=arguments.length-1;L>=-1&&!x;L--){var z;L>=0?z=arguments[L]:(void 0===_&&(_=process.cwd()),z=_),e(z),0!==z.length&&(S=z+"/"+S,x=47===z.charCodeAt(0))}return S=a(S,!x),x?S.length>0?"/"+S:"/":S.length>0?S:"."},normalize:function(_){if(e(_),0===_.length)return".";var S=47===_.charCodeAt(0),x=47===_.charCodeAt(_.length-1);return 0!==(_=a(_,!S)).length||S||(_="."),_.length>0&&x&&(_+="/"),S?"/"+_:_},isAbsolute:function(_){return e(_),_.length>0&&47===_.charCodeAt(0)},join:function(){if(0===arguments.length)return".";for(var _,x=0;x<arguments.length;++x){var L=arguments[x];e(L),L.length>0&&(void 0===_?_=L:_+="/"+L)}return void 0===_?".":S.normalize(_)},relative:function(_,x){if(e(_),e(x),_===x||(_=S.resolve(_))===(x=S.resolve(x)))return"";for(var L=1;L<_.length&&47===_.charCodeAt(L);++L);for(var z=_.length,C=z-L,H=1;H<x.length&&47===x.charCodeAt(H);++H);for(var W=x.length-H,D=C<W?C:W,O=-1,q=0;q<=D;++q){if(q===D){if(W>D){if(47===x.charCodeAt(H+q))return x.slice(H+q+1);if(0===q)return x.slice(H+q)}else C>D&&(47===_.charCodeAt(L+q)?O=q:0===q&&(O=0));break}var P=_.charCodeAt(L+q);if(P!==x.charCodeAt(H+q))break;47===P&&(O=q)}var V="";for(q=L+O+1;q<=z;++q)q!==z&&47!==_.charCodeAt(q)||(0===V.length?V+="..":V+="/..");return V.length>0?V+x.slice(H+O):(H+=O,47===x.charCodeAt(H)&&++H,x.slice(H))},_makeLong:function(_){return _},dirname:function(_){if(e(_),0===_.length)return".";for(var S=_.charCodeAt(0),x=47===S,L=-1,z=!0,C=_.length-1;C>=1;--C)if(47===(S=_.charCodeAt(C))){if(!z){L=C;break}}else z=!1;return-1===L?x?"/":".":x&&1===L?"//":_.slice(0,L)},basename:function(_,S){if(void 0!==S&&"string"!=typeof S)throw new TypeError('"ext" argument must be a string');e(_);var x,L=0,z=-1,C=!0;if(void 0!==S&&S.length>0&&S.length<=_.length){if(S.length===_.length&&S===_)return"";var H=S.length-1,W=-1;for(x=_.length-1;x>=0;--x){var D=_.charCodeAt(x);if(47===D){if(!C){L=x+1;break}}else-1===W&&(C=!1,W=x+1),H>=0&&(D===S.charCodeAt(H)?-1==--H&&(z=x):(H=-1,z=W))}return L===z?z=W:-1===z&&(z=_.length),_.slice(L,z)}for(x=_.length-1;x>=0;--x)if(47===_.charCodeAt(x)){if(!C){L=x+1;break}}else-1===z&&(C=!1,z=x+1);return-1===z?"":_.slice(L,z)},extname:function(_){e(_);for(var S=-1,x=0,L=-1,z=!0,C=0,H=_.length-1;H>=0;--H){var W=_.charCodeAt(H);if(47!==W)-1===L&&(z=!1,L=H+1),46===W?-1===S?S=H:1!==C&&(C=1):-1!==S&&(C=-1);else if(!z){x=H+1;break}}return-1===S||-1===L||0===C||1===C&&S===L-1&&S===x+1?"":_.slice(S,L)},format:function(_){if(null===_||"object"!=typeof _)throw new TypeError('The "pathObject" argument must be of type Object. Received type '+typeof _);return x=(S=_).dir||S.root,L=S.base||(S.name||"")+(S.ext||""),x?x===S.root?x+L:x+"/"+L:L;var S,x,L},parse:function(_){e(_);var S={root:"",dir:"",base:"",ext:"",name:""};if(0===_.length)return S;var x,L=_.charCodeAt(0),z=47===L;z?(S.root="/",x=1):x=0;for(var C=-1,H=0,W=-1,D=!0,O=_.length-1,q=0;O>=x;--O)if(47!==(L=_.charCodeAt(O)))-1===W&&(D=!1,W=O+1),46===L?-1===C?C=O:1!==q&&(q=1):-1!==C&&(q=-1);else if(!D){H=O+1;break}return-1===C||-1===W||0===q||1===q&&C===W-1&&C===H+1?-1!==W&&(S.base=S.name=0===H&&z?_.slice(1,W):_.slice(H,W)):(0===H&&z?(S.name=_.slice(1,C),S.base=_.slice(1,W)):(S.name=_.slice(H,C),S.base=_.slice(H,W)),S.ext=_.slice(C,W)),H>0?S.dir=_.slice(0,H-1):z&&(S.dir="/"),S},sep:"/",delimiter:":",win32:null,posix:null};S.posix=S,_.exports=S},447:(_,S,x)=>{var L;if(x.r(S),x.d(S,{URI:()=>X,Utils:()=>te}),"object"==typeof process)L="win32"===process.platform;else if("object"==typeof navigator){var z=navigator.userAgent;L=z.indexOf("Windows")>=0}var C,H,W=(C=function(_,S){return(C=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(_,S){_.__proto__=S}||function(_,S){for(var x in S)Object.prototype.hasOwnProperty.call(S,x)&&(_[x]=S[x])})(_,S)},function(_,S){if("function"!=typeof S&&null!==S)throw new TypeError("Class extends value "+String(S)+" is not a constructor or null");function k(){this.constructor=_}C(_,S),_.prototype=null===S?Object.create(S):(k.prototype=S.prototype,new k)}),D=/^\w[\w\d+.-]*$/,O=/^\//,q=/^\/\//;function y(_,S){if(!_.scheme&&S)throw new Error('[UriError]: Scheme is missing: {scheme: "", authority: "'.concat(_.authority,'", path: "').concat(_.path,'", query: "').concat(_.query,'", fragment: "').concat(_.fragment,'"}'));if(_.scheme&&!D.test(_.scheme))throw new Error("[UriError]: Scheme contains illegal characters.");if(_.path)if(_.authority){if(!O.test(_.path))throw new Error('[UriError]: If a URI contains an authority component, then the path component must either be empty or begin with a slash ("/") character')}else if(q.test(_.path))throw new Error('[UriError]: If a URI does not contain an authority component, then the path cannot begin with two slash characters ("//")')}var P="",V="/",K=/^(([^:/?#]+?):)?(\/\/([^/?#]*))?([^?#]*)(\?([^#]*))?(#(.*))?/,X=function(){function T(_,S,x,L,z,C){var H,W;void 0===C&&(C=!1),"object"==typeof _?(this.scheme=_.scheme||P,this.authority=_.authority||P,this.path=_.path||P,this.query=_.query||P,this.fragment=_.fragment||P):(this.scheme=(W=C,(H=_)||W?H:"file"),this.authority=S||P,this.path=function(_,S){switch(_){case"https":case"http":case"file":S?S[0]!==V&&(S=V+S):S=V}return S}(this.scheme,x||P),this.query=L||P,this.fragment=z||P,y(this,C))}return T.isUri=function(_){return _ instanceof T||!!_&&"string"==typeof _.authority&&"string"==typeof _.fragment&&"string"==typeof _.path&&"string"==typeof _.query&&"string"==typeof _.scheme&&"string"==typeof _.fsPath&&"function"==typeof _.with&&"function"==typeof _.toString},Object.defineProperty(T.prototype,"fsPath",{get:function(){return p(this,!1)},enumerable:!1,configurable:!0}),T.prototype.with=function(_){if(!_)return this;var S=_.scheme,x=_.authority,L=_.path,z=_.query,C=_.fragment;return void 0===S?S=this.scheme:null===S&&(S=P),void 0===x?x=this.authority:null===x&&(x=P),void 0===L?L=this.path:null===L&&(L=P),void 0===z?z=this.query:null===z&&(z=P),void 0===C?C=this.fragment:null===C&&(C=P),S===this.scheme&&x===this.authority&&L===this.path&&z===this.query&&C===this.fragment?this:new Q(S,x,L,z,C)},T.parse=function(_,S){void 0===S&&(S=!1);var x=K.exec(_);return x?new Q(x[2]||P,U(x[4]||P),U(x[5]||P),U(x[7]||P),U(x[9]||P),S):new Q(P,P,P,P,P)},T.file=function(_){var S=P;if(L&&(_=_.replace(/\\/g,V)),_[0]===V&&_[1]===V){var x=_.indexOf(V,2);-1===x?(S=_.substring(2),_=V):(S=_.substring(2,x),_=_.substring(x)||V)}return new Q("file",S,_,P,P)},T.from=function(_){var S=new Q(_.scheme,_.authority,_.path,_.query,_.fragment);return y(S,!0),S},T.prototype.toString=function(_){return void 0===_&&(_=!1),b(this,_)},T.prototype.toJSON=function(){return this},T.revive=function(_){if(_){if(_ instanceof T)return _;var S=new Q(_);return S._formatted=_.external,S._fsPath=_._sep===Y?_.fsPath:null,S}return _},T}(),Y=L?1:void 0,Q=function(_){function v(){var S=null!==_&&_.apply(this,arguments)||this;return S._formatted=null,S._fsPath=null,S}return W(v,_),Object.defineProperty(v.prototype,"fsPath",{get:function(){return this._fsPath||(this._fsPath=p(this,!1)),this._fsPath},enumerable:!1,configurable:!0}),v.prototype.toString=function(_){return void 0===_&&(_=!1),_?b(this,!0):(this._formatted||(this._formatted=b(this,!1)),this._formatted)},v.prototype.toJSON=function(){var _={$mid:1};return this._fsPath&&(_.fsPath=this._fsPath,_._sep=Y),this._formatted&&(_.external=this._formatted),this.path&&(_.path=this.path),this.scheme&&(_.scheme=this.scheme),this.authority&&(_.authority=this.authority),this.query&&(_.query=this.query),this.fragment&&(_.fragment=this.fragment),_},v}(X),Z=((H={})[58]="%3A",H[47]="%2F",H[63]="%3F",H[35]="%23",H[91]="%5B",H[93]="%5D",H[64]="%40",H[33]="%21",H[36]="%24",H[38]="%26",H[39]="%27",H[40]="%28",H[41]="%29",H[42]="%2A",H[43]="%2B",H[44]="%2C",H[59]="%3B",H[61]="%3D",H[32]="%20",H);function J(_,S){for(var x=void 0,L=-1,z=0;z<_.length;z++){var C=_.charCodeAt(z);if(C>=97&&C<=122||C>=65&&C<=90||C>=48&&C<=57||45===C||46===C||95===C||126===C||S&&47===C)-1!==L&&(x+=encodeURIComponent(_.substring(L,z)),L=-1),void 0!==x&&(x+=_.charAt(z));else{void 0===x&&(x=_.substr(0,z));var H=Z[C];void 0!==H?(-1!==L&&(x+=encodeURIComponent(_.substring(L,z)),L=-1),x+=H):-1===L&&(L=z)}}return-1!==L&&(x+=encodeURIComponent(_.substring(L))),void 0!==x?x:_}function f(_){for(var S=void 0,x=0;x<_.length;x++){var L=_.charCodeAt(x);35===L||63===L?(void 0===S&&(S=_.substr(0,x)),S+=Z[L]):void 0!==S&&(S+=_[x])}return void 0!==S?S:_}function p(_,S){var x;return x=_.authority&&_.path.length>1&&"file"===_.scheme?"//".concat(_.authority).concat(_.path):47===_.path.charCodeAt(0)&&(_.path.charCodeAt(1)>=65&&_.path.charCodeAt(1)<=90||_.path.charCodeAt(1)>=97&&_.path.charCodeAt(1)<=122)&&58===_.path.charCodeAt(2)?S?_.path.substr(1):_.path[1].toLowerCase()+_.path.substr(2):_.path,L&&(x=x.replace(/\//g,"\\")),x}function b(_,S){var x=S?f:J,L="",z=_.scheme,C=_.authority,H=_.path,W=_.query,D=_.fragment;if(z&&(L+=z,L+=":"),(C||"file"===z)&&(L+=V,L+=V),C){var O=C.indexOf("@");if(-1!==O){var q=C.substr(0,O);C=C.substr(O+1),-1===(O=q.indexOf(":"))?L+=x(q,!1):(L+=x(q.substr(0,O),!1),L+=":",L+=x(q.substr(O+1),!1)),L+="@"}-1===(O=(C=C.toLowerCase()).indexOf(":"))?L+=x(C,!1):(L+=x(C.substr(0,O),!1),L+=C.substr(O))}if(H){if(H.length>=3&&47===H.charCodeAt(0)&&58===H.charCodeAt(2))(P=H.charCodeAt(1))>=65&&P<=90&&(H="/".concat(String.fromCharCode(P+32),":").concat(H.substr(3)));else if(H.length>=2&&58===H.charCodeAt(1)){var P;(P=H.charCodeAt(0))>=65&&P<=90&&(H="".concat(String.fromCharCode(P+32),":").concat(H.substr(2)))}L+=x(H,!0)}return W&&(L+="?",L+=x(W,!1)),D&&(L+="#",L+=S?D:J(D,!1)),L}function N(_){try{return decodeURIComponent(_)}catch{return _.length>3?_.substr(0,3)+N(_.substr(3)):_}}var ee=/(%[0-9A-Za-z][0-9A-Za-z])+/g;function U(_){return _.match(ee)?_.replace(ee,(function(_){return N(_)})):_}var te,ne,re=x(470),I=function(_,S,x){if(x||2===arguments.length)for(var L,z=0,C=S.length;z<C;z++)!L&&z in S||(L||(L=Array.prototype.slice.call(S,0,z)),L[z]=S[z]);return _.concat(L||Array.prototype.slice.call(S))},oe=re.posix||re;(ne=te||(te={})).joinPath=function(_){for(var S=[],x=1;x<arguments.length;x++)S[x-1]=arguments[x];return _.with({path:oe.join.apply(oe,I([_.path],S,!1))})},ne.resolvePath=function(_){for(var S=[],x=1;x<arguments.length;x++)S[x-1]=arguments[x];var L=_.path||"/";return _.with({path:oe.resolve.apply(oe,I([L],S,!1))})},ne.dirname=function(_){var S=oe.dirname(_.path);return 1===S.length&&46===S.charCodeAt(0)?_:_.with({path:S})},ne.basename=function(_){return oe.basename(_.path)},ne.extname=function(_){return oe.extname(_.path)}}},S={};function o(x){if(S[x])return S[x].exports;var L=S[x]={exports:{}};return _[x](L,L.exports,o),L.exports}return o.d=(_,S)=>{for(var x in S)o.o(S,x)&&!o.o(_,x)&&Object.defineProperty(_,x,{enumerable:!0,get:S[x]})},o.o=(_,S)=>Object.prototype.hasOwnProperty.call(_,S),o.r=_=>{typeof Symbol<"u"&&Symbol.toStringTag&&Object.defineProperty(_,Symbol.toStringTag,{value:"Module"}),Object.defineProperty(_,"__esModule",{value:!0})},o(447)})();var{URI:Mn,Utils:Rn}=Ln;function mt(_){var S=_[0];return S===_[_.length-1]&&("'"===S||'"'===S)&&(_=_.substr(1,_.length-2)),_}function ki(_,S,x,L,C,H){var W=mt(x);if(function yi(_,S){return!(!_.length||"handlebars"===S&&/{{|}}/.test(_))&&/\b(w[\w\d+.-]*:\/\/)?[^\s()<>]+(?:\([\w\d]+\)|([^[:punct:]\s]|\/?))/.test(_)}(W,_.languageId)){W.length<x.length&&(L++,C--);var D=function Ti(_,S,x,L){if(!/^\s*javascript\:/i.test(S)&&!/[\n\r]/.test(S))return S=S.replace(/^\s*/g,""),/^https?:\/\//i.test(S)||/^file:\/\//i.test(S)?S:/^\#/i.test(S)?_+S:/^\/\//i.test(S)?(ae(_,"https://")?"https":"http")+":"+S.replace(/^\s*/g,""):x?x.resolveReference(S,L||_):S}(_.uri,W,S,H);if(D&&function Si(_){try{return Mn.parse(_),!0}catch{return!1}}(D))return{range:z.create(_.positionAt(L),_.positionAt(C)),target:D}}}function cn(_,S){for(var x=[],L=$(_.getText(),0),z=L.scan(),C=void 0,H=!1,W=void 0,D={};z!==st.EOS;){switch(z){case st.StartTag:if(!W)H="base"===L.getTokenText().toLowerCase();break;case st.AttributeName:C=L.getTokenText().toLowerCase();break;case st.AttributeValue:if("src"===C||"href"===C){var O=L.getTokenText();if(!H)(V=ki(_,S,O,L.getTokenOffset(),L.getTokenEnd(),W))&&x.push(V);H&&typeof W>"u"&&((W=mt(O))&&S&&(W=S.resolveReference(W,_.uri))),H=!1,C=void 0}else if("id"===C){D[mt(L.getTokenText())]=L.getTokenOffset()}}z=L.scan()}for(var q=0,P=x;q<P.length;q++){var V=P[q],K=_.uri+"#";if(V.target&&ae(V.target,K)){var X=D[V.target.substr(K.length)];if(void 0!==X){var Y=_.positionAt(X);V.target=""+K+(Y.line+1)+","+(Y.character+1)}}}return x}function mn(_,S,x){var L=_.offsetAt(S),z=x.findNodeAt(L);if(!z.tag)return[];var C=[],H=pn(st.StartTag,_,z.start),W="number"==typeof z.endTagStart&&pn(st.EndTag,_,z.endTagStart);return(H&&dn(H,S)||W&&dn(W,S))&&(H&&C.push({kind:qe.Read,range:H}),W&&C.push({kind:qe.Read,range:W})),C}function hn(_,S){return _.line<S.line||_.line===S.line&&_.character<=S.character}function dn(_,S){return hn(_.start,S)&&hn(S,_.end)}function pn(_,S,x){for(var L=$(S.getText(),x),z=L.scan();z!==st.EOS&&z!==_;)z=L.scan();return z!==st.EOS?{start:S.positionAt(L.getTokenOffset()),end:S.positionAt(L.getTokenEnd())}:null}function fn(_,S){var x=[];return S.roots.forEach((function(S){gn(_,S,"",x)})),x}function gn(_,S,x,L){var H=function Ai(_){var S=_.tag;if(_.attributes){var x=_.attributes.id,L=_.attributes.class;x&&(S+="#"+x.replace(/[\"\']/g,"")),L&&(S+=L.replace(/[\"\']/g,"").split(/\s+/).map((function(_){return"."+_})).join(""))}return S||"?"}(S),W=C.create(_.uri,z.create(_.positionAt(S.start),_.positionAt(S.end))),D={name:H,location:W,containerName:x,kind:Fe.Field};L.push(D),S.children.forEach((function(S){gn(_,S,H,L)}))}function bn(_,S,x,L){var z,C=_.offsetAt(S),H=L.findNodeAt(C);if(!H.tag||!function xi(_,S,x){return!!(_.endTagStart&&_.endTagStart+2<=S&&S<=_.endTagStart+2+x.length)||_.start+1<=S&&S<=_.start+1+x.length}(H,C,H.tag))return null;var W=[],D={start:_.positionAt(H.start+1),end:_.positionAt(H.start+1+H.tag.length)};if(W.push({range:D,newText:x}),H.endTagStart){var O={start:_.positionAt(H.endTagStart+2),end:_.positionAt(H.endTagStart+2+H.tag.length)};W.push({range:O,newText:x})}return{changes:((z={})[_.uri.toString()]=W,z)}}function vn(_,S,x){var L=_.offsetAt(S),z=x.findNodeAt(L);if(!z.tag||!z.endTagStart)return null;if(z.start+1<=L&&L<=z.start+1+z.tag.length){var C=L-1-z.start+z.endTagStart+2;return _.positionAt(C)}if(z.endTagStart+2<=L&&L<=z.endTagStart+2+z.tag.length){C=L-2-z.endTagStart+z.start+1;return _.positionAt(C)}return null}function ft(_,S,x){var L=_.offsetAt(S),C=x.findNodeAt(L),H=C.tag?C.tag.length:0;return C.endTagStart&&(C.start+1<=L&&L<=C.start+1+H||C.endTagStart+2<=L&&L<=C.endTagStart+2+H)?[z.create(_.positionAt(C.start+1),_.positionAt(C.start+1+H)),z.create(_.positionAt(C.endTagStart+2),_.positionAt(C.endTagStart+2+H))]:null}function wn(_,S){var x=$(_.getText()),L=x.scan(),z=[],C=[],H=null,W=-1;function r(_){z.push(_),W=_.startLine}for(;L!==st.EOS;){switch(L){case st.StartTag:var D=x.getTokenText(),O=_.positionAt(x.getTokenOffset()).line;C.push({startLine:O,tagName:D}),H=D;break;case st.EndTag:H=x.getTokenText();break;case st.StartTagClose:if(!H||!pe(H))break;case st.EndTagClose:case st.StartTagSelfClose:for(var P=C.length-1;P>=0&&C[P].tagName!==H;)P--;if(P>=0){var V=C[P];C.length=P,(X=_.positionAt(x.getTokenOffset()).line-1)>(O=V.startLine)&&W!==O&&r({startLine:O,endLine:X})}break;case st.Comment:O=_.positionAt(x.getTokenOffset()).line;var K=x.getTokenText().match(/^\s*#(region\b)|(endregion\b)/);if(K)if(K[1])C.push({startLine:O,tagName:""});else{for(P=C.length-1;P>=0&&C[P].tagName.length;)P--;if(P>=0){var X;V=C[P];C.length=P,(X=O)>(O=V.startLine)&&W!==O&&r({startLine:O,endLine:X,kind:q.Region})}}else O<(X=_.positionAt(x.getTokenOffset()+x.getTokenLength()).line)&&r({startLine:O,endLine:X,kind:q.Comment})}L=x.scan()}var Y=S&&S.rangeLimit||Number.MAX_VALUE;return z.length>Y?function Di(_,S){_=_.sort((function(_,S){var x=_.startLine-S.startLine;return 0===x&&(x=_.endLine-S.endLine),x}));for(var x=void 0,L=[],z=[],C=[],c=function(_,S){z[_]=S,S<30&&(C[S]=(C[S]||0)+1)},H=0;H<_.length;H++){var W=_[H];if(x){if(W.startLine>x.startLine)if(W.endLine<=x.endLine)L.push(x),x=W,c(H,L.length);else if(W.startLine>x.endLine){do{x=L.pop()}while(x&&W.startLine>x.endLine);x&&L.push(x),x=W,c(H,L.length)}}else x=W,c(H,0)}var D=0,O=0;for(H=0;H<C.length;H++){var q=C[H];if(q){if(q+D>S){O=H;break}D+=q}}var P=[];for(H=0;H<_.length;H++){var V=z[H];"number"==typeof V&&(V<O||V===O&&D++<S)&&P.push(_[H])}return P}(z,Y):z}function yn(_,S){return S.map((function o(S){for(var x=function Ei(_,S){var x=je(_.getText()),L=_.offsetAt(S),C=x.findNodeAt(L),H=function Ci(_){for(var S=_,o=function(_){return _.startTagEnd&&_.endTagStart&&_.startTagEnd<_.endTagStart?[[_.startTagEnd,_.endTagStart],[_.start,_.end]]:[[_.start,_.end]]},x=[];S.parent;)S=S.parent,o(S).forEach((function(_){return x.push(_)}));return x}(C);if(C.startTagEnd&&!C.endTagStart){if(C.startTagEnd!==C.end)return[[C.start,C.end]];var W=z.create(_.positionAt(C.startTagEnd-2),_.positionAt(C.startTagEnd));return"/>"===_.getText(W)?H.unshift([C.start+1,C.startTagEnd-2]):H.unshift([C.start+1,C.startTagEnd-1]),H=_n(_,C,L).concat(H)}if(!C.startTagEnd||!C.endTagStart)return H;return H.unshift([C.start,C.end]),C.start<L&&L<C.startTagEnd?(H.unshift([C.start+1,C.startTagEnd-1]),H=_n(_,C,L).concat(H)):C.startTagEnd<=L&&L<=C.endTagStart?(H.unshift([C.startTagEnd,C.endTagStart]),H):(L>=C.endTagStart+2&&H.unshift([C.endTagStart+2,C.end-1]),H)}(_,S),L=void 0,C=void 0,H=x.length-1;H>=0;H--){var W=x[H];(!L||W[0]!==L[0]||W[1]!==L[1])&&(C=et.create(z.create(_.positionAt(x[H][0]),_.positionAt(x[H][1])),C)),L=W}return C||(C=et.create(z.create(S,S))),C}))}function _n(_,S,x){for(var L=z.create(_.positionAt(S.start),_.positionAt(S.end)),C=_.getText(L),H=x-S.start,W=$(C),D=W.scan(),O=S.start,q=[],P=!1,V=-1;D!==st.EOS;){switch(D){case st.AttributeName:if(H<W.getTokenOffset()){P=!1;break}H<=W.getTokenEnd()&&q.unshift([W.getTokenOffset(),W.getTokenEnd()]),P=!0,V=W.getTokenOffset();break;case st.AttributeValue:if(!P)break;var K=W.getTokenText();if(H<W.getTokenOffset()){q.push([V,W.getTokenEnd()]);break}H>=W.getTokenOffset()&&H<=W.getTokenEnd()&&(q.unshift([W.getTokenOffset(),W.getTokenEnd()]),('"'===K[0]&&'"'===K[K.length-1]||"'"===K[0]&&"'"===K[K.length-1])&&H>=W.getTokenOffset()+1&&H<=W.getTokenEnd()-1&&q.unshift([W.getTokenOffset()+1,W.getTokenEnd()-1]),q.push([V,W.getTokenEnd()]))}D=W.scan()}return q.map((function(_){return[_[0]+O,_[1]+O]}))}var Cn={version:1.1,tags:[{name:"html",description:{kind:"markdown",value:"The html element represents the root of an HTML document."},attributes:[{name:"manifest",description:{kind:"markdown",value:"Specifies the URI of a resource manifest indicating resources that should be cached locally. See [Using the application cache](https://developer.mozilla.org/en-US/docs/Web/HTML/Using_the_application_cache) for details."}},{name:"version",description:'Specifies the version of the HTML [Document Type Definition](https://developer.mozilla.org/en-US/docs/Glossary/DTD "Document Type Definition: In HTML, the doctype is the required "<!DOCTYPE html>" preamble found at the top of all documents. Its sole purpose is to prevent a browser from switching into so-called “quirks mode” when rendering a document; that is, the "<!DOCTYPE html>" doctype ensures that the browser makes a best-effort attempt at following the relevant specifications, rather than using a different rendering mode that is incompatible with some specifications.") that governs the current document. This attribute is not needed, because it is redundant with the version information in the document type declaration.'},{name:"xmlns",description:'Specifies the XML Namespace of the document. Default value is `"http://www.w3.org/1999/xhtml"`. This is required in documents parsed with XML parsers, and optional in text/html documents.'}],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/HTML/Element/html"}]},{name:"head",description:{kind:"markdown",value:"The head element represents a collection of metadata for the Document."},attributes:[{name:"profile",description:"The URIs of one or more metadata profiles, separated by white space."}],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/HTML/Element/head"}]},{name:"title",description:{kind:"markdown",value:"The title element represents the document's title or name. Authors should use titles that identify their documents even when they are used out of context, for example in a user's history or bookmarks, or in search results. The document's title is often different from its first heading, since the first heading does not have to stand alone when taken out of context."},attributes:[],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/HTML/Element/title"}]},{name:"base",description:{kind:"markdown",value:"The base element allows authors to specify the document base URL for the purposes of resolving relative URLs, and the name of the default browsing context for the purposes of following hyperlinks. The element does not represent any content beyond this information."},attributes:[{name:"href",description:{kind:"markdown",value:"The base URL to be used throughout the document for relative URL addresses. If this attribute is specified, this element must come before any other elements with attributes whose values are URLs. Absolute and relative URLs are allowed."}},{name:"target",description:{kind:"markdown",value:"A name or keyword indicating the default location to display the result when hyperlinks or forms cause navigation, for elements that do not have an explicit target reference. It is a name of, or keyword for, a _browsing context_ (for example: tab, window, or inline frame). The following keywords have special meanings:\n\n*   `_self`: Load the result into the same browsing context as the current one. This value is the default if the attribute is not specified.\n*   `_blank`: Load the result into a new unnamed browsing context.\n*   `_parent`: Load the result into the parent browsing context of the current one. If there is no parent, this option behaves the same way as `_self`.\n*   `_top`: Load the result into the top-level browsing context (that is, the browsing context that is an ancestor of the current one, and has no parent). If there is no parent, this option behaves the same way as `_self`.\n\nIf this attribute is specified, this element must come before any other elements with attributes whose values are URLs."}}],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/HTML/Element/base"}]},{name:"link",description:{kind:"markdown",value:"The link element allows authors to link their document to other resources."},attributes:[{name:"href",description:{kind:"markdown",value:'This attribute specifies the [URL](https://developer.mozilla.org/en-US/docs/Glossary/URL "URL: Uniform Resource Locator (URL) is a text string specifying where a resource can be found on the Internet.") of the linked resource. A URL can be absolute or relative.'}},{name:"crossorigin",valueSet:"xo",description:{kind:"markdown",value:'This enumerated attribute indicates whether [CORS](https://developer.mozilla.org/en-US/docs/Glossary/CORS "CORS: CORS (Cross-Origin Resource Sharing) is a system, consisting of transmitting HTTP headers, that determines whether browsers block frontend JavaScript code from accessing responses for cross-origin requests.") must be used when fetching the resource. [CORS-enabled images](https://developer.mozilla.org/en-US/docs/Web/HTML/CORS_Enabled_Image) can be reused in the [`<canvas>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/canvas "Use the HTML <canvas> element with either the canvas scripting API or the WebGL API to draw graphics and animations.") element without being _tainted_. The allowed values are:\n\n`anonymous`\n\nA cross-origin request (i.e. with an [`Origin`](https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Origin "The Origin request header indicates where a fetch originates from. It doesn\'t include any path information, but only the server name. It is sent with CORS requests, as well as with POST requests. It is similar to the Referer header, but, unlike this header, it doesn\'t disclose the whole path.") HTTP header) is performed, but no credential is sent (i.e. no cookie, X.509 certificate, or HTTP Basic authentication). If the server does not give credentials to the origin site (by not setting the [`Access-Control-Allow-Origin`](https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Access-Control-Allow-Origin "The Access-Control-Allow-Origin response header indicates whether the response can be shared with requesting code from the given origin.") HTTP header) the image will be tainted and its usage restricted.\n\n`use-credentials`\n\nA cross-origin request (i.e. with an `Origin` HTTP header) is performed along with a credential sent (i.e. a cookie, certificate, and/or HTTP Basic authentication is performed). If the server does not give credentials to the origin site (through [`Access-Control-Allow-Credentials`](https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Access-Control-Allow-Credentials "The Access-Control-Allow-Credentials response header tells browsers whether to expose the response to frontend JavaScript code when the request\'s credentials mode (Request.credentials) is "include".") HTTP header), the resource will be _tainted_ and its usage restricted.\n\nIf the attribute is not present, the resource is fetched without a [CORS](https://developer.mozilla.org/en-US/docs/Glossary/CORS "CORS: CORS (Cross-Origin Resource Sharing) is a system, consisting of transmitting HTTP headers, that determines whether browsers block frontend JavaScript code from accessing responses for cross-origin requests.") request (i.e. without sending the `Origin` HTTP header), preventing its non-tainted usage. If invalid, it is handled as if the enumerated keyword **anonymous** was used. See [CORS settings attributes](https://developer.mozilla.org/en-US/docs/Web/HTML/CORS_settings_attributes) for additional information.'}},{name:"rel",description:{kind:"markdown",value:"This attribute names a relationship of the linked document to the current document. The attribute must be a space-separated list of the [link types values](https://developer.mozilla.org/en-US/docs/Web/HTML/Link_types)."}},{name:"media",description:{kind:"markdown",value:"This attribute specifies the media that the linked resource applies to. Its value must be a media type / [media query](https://developer.mozilla.org/en-US/docs/Web/CSS/Media_queries). This attribute is mainly useful when linking to external stylesheets — it allows the user agent to pick the best adapted one for the device it runs on.\n\n**Notes:**\n\n*   In HTML 4, this can only be a simple white-space-separated list of media description literals, i.e., [media types and groups](https://developer.mozilla.org/en-US/docs/Web/CSS/@media), where defined and allowed as values for this attribute, such as `print`, `screen`, `aural`, `braille`. HTML5 extended this to any kind of [media queries](https://developer.mozilla.org/en-US/docs/Web/CSS/Media_queries), which are a superset of the allowed values of HTML 4.\n*   Browsers not supporting [CSS3 Media Queries](https://developer.mozilla.org/en-US/docs/Web/CSS/Media_queries) won't necessarily recognize the adequate link; do not forget to set fallback links, the restricted set of media queries defined in HTML 4."}},{name:"hreflang",description:{kind:"markdown",value:"This attribute indicates the language of the linked resource. It is purely advisory. Allowed values are determined by [BCP47](https://www.ietf.org/rfc/bcp/bcp47.txt). Use this attribute only if the [`href`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/a#attr-href) attribute is present."}},{name:"type",description:{kind:"markdown",value:'This attribute is used to define the type of the content linked to. The value of the attribute should be a MIME type such as **text/html**, **text/css**, and so on. The common use of this attribute is to define the type of stylesheet being referenced (such as **text/css**), but given that CSS is the only stylesheet language used on the web, not only is it possible to omit the `type` attribute, but is actually now recommended practice. It is also used on `rel="preload"` link types, to make sure the browser only downloads file types that it supports.'}},{name:"sizes",description:{kind:"markdown",value:"This attribute defines the sizes of the icons for visual media contained in the resource. It must be present only if the [`rel`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/link#attr-rel) contains a value of `icon` or a non-standard type such as Apple's `apple-touch-icon`. It may have the following values:\n\n*   `any`, meaning that the icon can be scaled to any size as it is in a vector format, like `image/svg+xml`.\n*   a white-space separated list of sizes, each in the format `_<width in pixels>_x_<height in pixels>_` or `_<width in pixels>_X_<height in pixels>_`. Each of these sizes must be contained in the resource.\n\n**Note:** Most icon formats are only able to store one single icon; therefore most of the time the [`sizes`](https://developer.mozilla.org/en-US/docs/Web/HTML/Global_attributes#attr-sizes) contains only one entry. MS's ICO format does, as well as Apple's ICNS. ICO is more ubiquitous; you should definitely use it."}},{name:"as",description:'This attribute is only used when `rel="preload"` or `rel="prefetch"` has been set on the `<link>` element. It specifies the type of content being loaded by the `<link>`, which is necessary for content prioritization, request matching, application of correct [content security policy](https://developer.mozilla.org/en-US/docs/Web/HTTP/CSP), and setting of correct [`Accept`](https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Accept "The Accept request HTTP header advertises which content types, expressed as MIME types, the client is able to understand. Using content negotiation, the server then selects one of the proposals, uses it and informs the client of its choice with the Content-Type response header. Browsers set adequate values for this header depending on the context where the request is done: when fetching a CSS stylesheet a different value is set for the request than when fetching an image, video or a script.") request header.'},{name:"importance",description:"Indicates the relative importance of the resource. Priority hints are delegated using the values:"},{name:"importance",description:'**`auto`**: Indicates **no preference**. The browser may use its own heuristics to decide the priority of the resource.\n\n**`high`**: Indicates to the browser that the resource is of **high** priority.\n\n**`low`**: Indicates to the browser that the resource is of **low** priority.\n\n**Note:** The `importance` attribute may only be used for the `<link>` element if `rel="preload"` or `rel="prefetch"` is present.'},{name:"integrity",description:"Contains inline metadata — a base64-encoded cryptographic hash of the resource (file) you’re telling the browser to fetch. The browser can use this to verify that the fetched resource has been delivered free of unexpected manipulation. See [Subresource Integrity](https://developer.mozilla.org/en-US/docs/Web/Security/Subresource_Integrity)."},{name:"referrerpolicy",description:'A string indicating which referrer to use when fetching the resource:\n\n*   `no-referrer` means that the [`Referer`](https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Referer "The Referer request header contains the address of the previous web page from which a link to the currently requested page was followed. The Referer header allows servers to identify where people are visiting them from and may use that data for analytics, logging, or optimized caching, for example.") header will not be sent.\n*   `no-referrer-when-downgrade` means that no [`Referer`](https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Referer "The Referer request header contains the address of the previous web page from which a link to the currently requested page was followed. The Referer header allows servers to identify where people are visiting them from and may use that data for analytics, logging, or optimized caching, for example.") header will be sent when navigating to an origin without TLS (HTTPS). This is a user agent’s default behavior, if no policy is otherwise specified.\n*   `origin` means that the referrer will be the origin of the page, which is roughly the scheme, the host, and the port.\n*   `origin-when-cross-origin` means that navigating to other origins will be limited to the scheme, the host, and the port, while navigating on the same origin will include the referrer\'s path.\n*   `unsafe-url` means that the referrer will include the origin and the path (but not the fragment, password, or username). This case is unsafe because it can leak origins and paths from TLS-protected resources to insecure origins.'},{name:"title",description:'The `title` attribute has special semantics on the `<link>` element. When used on a `<link rel="stylesheet">` it defines a [preferred or an alternate stylesheet](https://developer.mozilla.org/en-US/docs/Web/CSS/Alternative_style_sheets). Incorrectly using it may [cause the stylesheet to be ignored](https://developer.mozilla.org/en-US/docs/Correctly_Using_Titles_With_External_Stylesheets).'}],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/HTML/Element/link"}]},{name:"meta",description:{kind:"markdown",value:"The meta element represents various kinds of metadata that cannot be expressed using the title, base, link, style, and script elements."},attributes:[{name:"name",description:{kind:"markdown",value:'This attribute defines the name of a piece of document-level metadata. It should not be set if one of the attributes [`itemprop`](https://developer.mozilla.org/en-US/docs/Web/HTML/Global_attributes#attr-itemprop), [`http-equiv`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/meta#attr-http-equiv) or [`charset`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/meta#attr-charset) is also set.\n\nThis metadata name is associated with the value contained by the [`content`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/meta#attr-content) attribute. The possible values for the name attribute are:\n\n*   `application-name` which defines the name of the application running in the web page.\n    \n    **Note:**\n    \n    *   Browsers may use this to identify the application. It is different from the [`<title>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/title "The HTML Title element (<title>) defines the document\'s title that is shown in a browser\'s title bar or a page\'s tab.") element, which usually contain the application name, but may also contain information like the document name or a status.\n    *   Simple web pages shouldn\'t define an application-name.\n    \n*   `author` which defines the name of the document\'s author.\n*   `description` which contains a short and accurate summary of the content of the page. Several browsers, like Firefox and Opera, use this as the default description of bookmarked pages.\n*   `generator` which contains the identifier of the software that generated the page.\n*   `keywords` which contains words relevant to the page\'s content separated by commas.\n*   `referrer` which controls the [`Referer` HTTP header](https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Referer) attached to requests sent from the document:\n    \n    Values for the `content` attribute of `<meta name="referrer">`\n    \n    `no-referrer`\n    \n    Do not send a HTTP `Referrer` header.\n    \n    `origin`\n    \n    Send the [origin](https://developer.mozilla.org/en-US/docs/Glossary/Origin) of the document.\n    \n    `no-referrer-when-downgrade`\n    \n    Send the [origin](https://developer.mozilla.org/en-US/docs/Glossary/Origin) as a referrer to URLs as secure as the current page, (https→https), but does not send a referrer to less secure URLs (https→http). This is the default behaviour.\n    \n    `origin-when-cross-origin`\n    \n    Send the full URL (stripped of parameters) for same-origin requests, but only send the [origin](https://developer.mozilla.org/en-US/docs/Glossary/Origin) for other cases.\n    \n    `same-origin`\n    \n    A referrer will be sent for [same-site origins](https://developer.mozilla.org/en-US/docs/Web/Security/Same-origin_policy), but cross-origin requests will contain no referrer information.\n    \n    `strict-origin`\n    \n    Only send the origin of the document as the referrer to a-priori as-much-secure destination (HTTPS->HTTPS), but don\'t send it to a less secure destination (HTTPS->HTTP).\n    \n    `strict-origin-when-cross-origin`\n    \n    Send a full URL when performing a same-origin request, only send the origin of the document to a-priori as-much-secure destination (HTTPS->HTTPS), and send no header to a less secure destination (HTTPS->HTTP).\n    \n    `unsafe-URL`\n    \n    Send the full URL (stripped of parameters) for same-origin or cross-origin requests.\n    \n    **Notes:**\n    \n    *   Some browsers support the deprecated values of `always`, `default`, and `never` for referrer.\n    *   Dynamically inserting `<meta name="referrer">` (with [`document.write`](https://developer.mozilla.org/en-US/docs/Web/API/Document/write) or [`appendChild`](https://developer.mozilla.org/en-US/docs/Web/API/Node/appendChild)) makes the referrer behaviour unpredictable.\n    *   When several conflicting policies are defined, the no-referrer policy is applied.\n    \n\nThis attribute may also have a value taken from the extended list defined on [WHATWG Wiki MetaExtensions page](https://wiki.whatwg.org/wiki/MetaExtensions). Although none have been formally accepted yet, a few commonly used names are:\n\n*   `creator` which defines the name of the creator of the document, such as an organization or institution. If there are more than one, several [`<meta>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/meta "The HTML <meta> element represents metadata that cannot be represented by other HTML meta-related elements, like <base>, <link>, <script>, <style> or <title>.") elements should be used.\n*   `googlebot`, a synonym of `robots`, is only followed by Googlebot (the indexing crawler for Google).\n*   `publisher` which defines the name of the document\'s publisher.\n*   `robots` which defines the behaviour that cooperative crawlers, or "robots", should use with the page. It is a comma-separated list of the values below:\n    \n    Values for the content of `<meta name="robots">`\n    \n    Value\n    \n    Description\n    \n    Used by\n    \n    `index`\n    \n    Allows the robot to index the page (default).\n    \n    All\n    \n    `noindex`\n    \n    Requests the robot to not index the page.\n    \n    All\n    \n    `follow`\n    \n    Allows the robot to follow the links on the page (default).\n    \n    All\n    \n    `nofollow`\n    \n    Requests the robot to not follow the links on the page.\n    \n    All\n    \n    `none`\n    \n    Equivalent to `noindex, nofollow`\n    \n    [Google](https://support.google.com/webmasters/answer/79812)\n    \n    `noodp`\n    \n    Prevents using the [Open Directory Project](https://www.dmoz.org/) description, if any, as the page description in search engine results.\n    \n    [Google](https://support.google.com/webmasters/answer/35624#nodmoz), [Yahoo](https://help.yahoo.com/kb/search-for-desktop/meta-tags-robotstxt-yahoo-search-sln2213.html#cont5), [Bing](https://www.bing.com/webmaster/help/which-robots-metatags-does-bing-support-5198d240)\n    \n    `noarchive`\n    \n    Requests the search engine not to cache the page content.\n    \n    [Google](https://developers.google.com/webmasters/control-crawl-index/docs/robots_meta_tag#valid-indexing--serving-directives), [Yahoo](https://help.yahoo.com/kb/search-for-desktop/SLN2213.html), [Bing](https://www.bing.com/webmaster/help/which-robots-metatags-does-bing-support-5198d240)\n    \n    `nosnippet`\n    \n    Prevents displaying any description of the page in search engine results.\n    \n    [Google](https://developers.google.com/webmasters/control-crawl-index/docs/robots_meta_tag#valid-indexing--serving-directives), [Bing](https://www.bing.com/webmaster/help/which-robots-metatags-does-bing-support-5198d240)\n    \n    `noimageindex`\n    \n    Requests this page not to appear as the referring page of an indexed image.\n    \n    [Google](https://developers.google.com/webmasters/control-crawl-index/docs/robots_meta_tag#valid-indexing--serving-directives)\n    \n    `nocache`\n    \n    Synonym of `noarchive`.\n    \n    [Bing](https://www.bing.com/webmaster/help/which-robots-metatags-does-bing-support-5198d240)\n    \n    **Notes:**\n    \n    *   Only cooperative robots follow these rules. Do not expect to prevent e-mail harvesters with them.\n    *   The robot still needs to access the page in order to read these rules. To prevent bandwidth consumption, use a _[robots.txt](https://developer.mozilla.org/en-US/docs/Glossary/robots.txt "robots.txt: Robots.txt is a file which is usually placed in the root of any website. It decides whether crawlers are permitted or forbidden access to the web site.")_ file.\n    *   If you want to remove a page, `noindex` will work, but only after the robot visits the page again. Ensure that the `robots.txt` file is not preventing revisits.\n    *   Some values are mutually exclusive, like `index` and `noindex`, or `follow` and `nofollow`. In these cases the robot\'s behaviour is undefined and may vary between them.\n    *   Some crawler robots, like Google, Yahoo and Bing, support the same values for the HTTP header `X-Robots-Tag`; this allows non-HTML documents like images to use these rules.\n    \n*   `slurp`, is a synonym of `robots`, but only for Slurp - the crawler for Yahoo Search.\n*   `viewport`, which gives hints about the size of the initial size of the [viewport](https://developer.mozilla.org/en-US/docs/Glossary/viewport "viewport: A viewport represents a polygonal (normally rectangular) area in computer graphics that is currently being viewed. In web browser terms, it refers to the part of the document you\'re viewing which is currently visible in its window (or the screen, if the document is being viewed in full screen mode). Content outside the viewport is not visible onscreen until scrolled into view."). Used by mobile devices only.\n    \n    Values for the content of `<meta name="viewport">`\n    \n    Value\n    \n    Possible subvalues\n    \n    Description\n    \n    `width`\n    \n    A positive integer number, or the text `device-width`\n    \n    Defines the pixel width of the viewport that you want the web site to be rendered at.\n    \n    `height`\n    \n    A positive integer, or the text `device-height`\n    \n    Defines the height of the viewport. Not used by any browser.\n    \n    `initial-scale`\n    \n    A positive number between `0.0` and `10.0`\n    \n    Defines the ratio between the device width (`device-width` in portrait mode or `device-height` in landscape mode) and the viewport size.\n    \n    `maximum-scale`\n    \n    A positive number between `0.0` and `10.0`\n    \n    Defines the maximum amount to zoom in. It must be greater or equal to the `minimum-scale` or the behaviour is undefined. Browser settings can ignore this rule and iOS10+ ignores it by default.\n    \n    `minimum-scale`\n    \n    A positive number between `0.0` and `10.0`\n    \n    Defines the minimum zoom level. It must be smaller or equal to the `maximum-scale` or the behaviour is undefined. Browser settings can ignore this rule and iOS10+ ignores it by default.\n    \n    `user-scalable`\n    \n    `yes` or `no`\n    \n    If set to `no`, the user is not able to zoom in the webpage. The default is `yes`. Browser settings can ignore this rule, and iOS10+ ignores it by default.\n    \n    Specification\n    \n    Status\n    \n    Comment\n    \n    [CSS Device Adaptation  \n    The definition of \'<meta name="viewport">\' in that specification.](https://drafts.csswg.org/css-device-adapt/#viewport-meta)\n    \n    Working Draft\n    \n    Non-normatively describes the Viewport META element\n    \n    See also: [`@viewport`](https://developer.mozilla.org/en-US/docs/Web/CSS/@viewport "The @viewport CSS at-rule lets you configure the viewport through which the document is viewed. It\'s primarily used for mobile devices, but is also used by desktop browsers that support features like "snap to edge" (such as Microsoft Edge).")\n    \n    **Notes:**\n    \n    *   Though unstandardized, this declaration is respected by most mobile browsers due to de-facto dominance.\n    *   The default values may vary between devices and browsers.\n    *   To learn about this declaration in Firefox for Mobile, see [this article](https://developer.mozilla.org/en-US/docs/Mobile/Viewport_meta_tag "Mobile/Viewport meta tag").'}},{name:"http-equiv",description:{kind:"markdown",value:'Defines a pragma directive. The attribute is named `**http-equiv**(alent)` because all the allowed values are names of particular HTTP headers:\n\n*   `"content-language"`  \n    Defines the default language of the page. It can be overridden by the [lang](https://developer.mozilla.org/en-US/docs/Web/HTML/Global_attributes/lang) attribute on any element.\n    \n    **Warning:** Do not use this value, as it is obsolete. Prefer the `lang` attribute on the [`<html>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/html "The HTML <html> element represents the root (top-level element) of an HTML document, so it is also referred to as the root element. All other elements must be descendants of this element.") element.\n    \n*   `"content-security-policy"`  \n    Allows page authors to define a [content policy](https://developer.mozilla.org/en-US/docs/Web/Security/CSP/CSP_policy_directives) for the current page. Content policies mostly specify allowed server origins and script endpoints which help guard against cross-site scripting attacks.\n*   `"content-type"`  \n    Defines the [MIME type](https://developer.mozilla.org/en-US/docs/Glossary/MIME_type) of the document, followed by its character encoding. It follows the same syntax as the HTTP `content-type` entity-header field, but as it is inside a HTML page, most values other than `text/html` are impossible. Therefore the valid syntax for its `content` is the string \'`text/html`\' followed by a character set with the following syntax: \'`; charset=_IANAcharset_`\', where `IANAcharset` is the _preferred MIME name_ for a character set as [defined by the IANA.](https://www.iana.org/assignments/character-sets)\n    \n    **Warning:** Do not use this value, as it is obsolete. Use the [`charset`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/meta#attr-charset) attribute on the [`<meta>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/meta "The HTML <meta> element represents metadata that cannot be represented by other HTML meta-related elements, like <base>, <link>, <script>, <style> or <title>.") element.\n    \n    **Note:** As [`<meta>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/meta "The HTML <meta> element represents metadata that cannot be represented by other HTML meta-related elements, like <base>, <link>, <script>, <style> or <title>.") can\'t change documents\' types in XHTML or HTML5\'s XHTML serialization, never set the MIME type to an XHTML MIME type with `<meta>`.\n    \n*   `"refresh"`  \n    This instruction specifies:\n    *   The number of seconds until the page should be reloaded - only if the [`content`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/meta#attr-content) attribute contains a positive integer.\n    *   The number of seconds until the page should redirect to another - only if the [`content`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/meta#attr-content) attribute contains a positive integer followed by the string \'`;url=`\', and a valid URL.\n*   `"set-cookie"`  \n    Defines a [cookie](https://developer.mozilla.org/en-US/docs/cookie) for the page. Its content must follow the syntax defined in the [IETF HTTP Cookie Specification](https://tools.ietf.org/html/draft-ietf-httpstate-cookie-14).\n    \n    **Warning:** Do not use this instruction, as it is obsolete. Use the HTTP header [`Set-Cookie`](https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Set-Cookie) instead.'}},{name:"content",description:{kind:"markdown",value:"This attribute contains the value for the [`http-equiv`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/meta#attr-http-equiv) or [`name`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/meta#attr-name) attribute, depending on which is used."}},{name:"charset",description:{kind:"markdown",value:'This attribute declares the page\'s character encoding. It must contain a [standard IANA MIME name for character encodings](https://www.iana.org/assignments/character-sets). Although the standard doesn\'t request a specific encoding, it suggests:\n\n*   Authors are encouraged to use [`UTF-8`](https://developer.mozilla.org/en-US/docs/Glossary/UTF-8).\n*   Authors should not use ASCII-incompatible encodings to avoid security risk: browsers not supporting them may interpret harmful content as HTML. This happens with the `JIS_C6226-1983`, `JIS_X0212-1990`, `HZ-GB-2312`, `JOHAB`, the ISO-2022 family and the EBCDIC family.\n\n**Note:** ASCII-incompatible encodings are those that don\'t map the 8-bit code points `0x20` to `0x7E` to the `0x0020` to `0x007E` Unicode code points)\n\n*   Authors **must not** use `CESU-8`, `UTF-7`, `BOCU-1` and/or `SCSU` as [cross-site scripting](https://developer.mozilla.org/en-US/docs/Glossary/Cross-site_scripting) attacks with these encodings have been demonstrated.\n*   Authors should not use `UTF-32` because not all HTML5 encoding algorithms can distinguish it from `UTF-16`.\n\n**Notes:**\n\n*   The declared character encoding must match the one the page was saved with to avoid garbled characters and security holes.\n*   The [`<meta>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/meta "The HTML <meta> element represents metadata that cannot be represented by other HTML meta-related elements, like <base>, <link>, <script>, <style> or <title>.") element declaring the encoding must be inside the [`<head>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/head "The HTML <head> element provides general information (metadata) about the document, including its title and links to its scripts and style sheets.") element and **within the first 1024 bytes** of the HTML as some browsers only look at those bytes before choosing an encoding.\n*   This [`<meta>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/meta "The HTML <meta> element represents metadata that cannot be represented by other HTML meta-related elements, like <base>, <link>, <script>, <style> or <title>.") element is only one part of the [algorithm to determine a page\'s character set](https://www.whatwg.org/specs/web-apps/current-work/multipage/parsing.html#encoding-sniffing-algorithm "Algorithm charset page"). The [`Content-Type` header](https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Content-Type) and any [Byte-Order Marks](https://developer.mozilla.org/en-US/docs/Glossary/Byte-Order_Mark "The definition of that term (Byte-Order Marks) has not been written yet; please consider contributing it!") override this element.\n*   It is strongly recommended to define the character encoding. If a page\'s encoding is undefined, cross-scripting techniques are possible, such as the [`UTF-7` fallback cross-scripting technique](https://code.google.com/p/doctype-mirror/wiki/ArticleUtf7).\n*   The [`<meta>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/meta "The HTML <meta> element represents metadata that cannot be represented by other HTML meta-related elements, like <base>, <link>, <script>, <style> or <title>.") element with a `charset` attribute is a synonym for the pre-HTML5 `<meta http-equiv="Content-Type" content="text/html; charset=_IANAcharset_">`, where _`IANAcharset`_ contains the value of the equivalent [`charset`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/meta#attr-charset) attribute. This syntax is still allowed, although no longer recommended.'}},{name:"scheme",description:"This attribute defines the scheme in which metadata is described. A scheme is a context leading to the correct interpretations of the [`content`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/meta#attr-content) value, like a format.\n\n**Warning:** Do not use this value, as it is obsolete. There is no replacement as there was no real usage for it."}],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/HTML/Element/meta"}]},{name:"style",description:{kind:"markdown",value:"The style element allows authors to embed style information in their documents. The style element is one of several inputs to the styling processing model. The element does not represent content for the user."},attributes:[{name:"media",description:{kind:"markdown",value:"This attribute defines which media the style should be applied to. Its value is a [media query](https://developer.mozilla.org/en-US/docs/Web/Guide/CSS/Media_queries), which defaults to `all` if the attribute is missing."}},{name:"nonce",description:{kind:"markdown",value:"A cryptographic nonce (number used once) used to whitelist inline styles in a [style-src Content-Security-Policy](https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Content-Security-Policy/style-src). The server must generate a unique nonce value each time it transmits a policy. It is critical to provide a nonce that cannot be guessed as bypassing a resource’s policy is otherwise trivial."}},{name:"type",description:{kind:"markdown",value:"This attribute defines the styling language as a MIME type (charset should not be specified). This attribute is optional and defaults to `text/css` if it is not specified — there is very little reason to include this in modern web documents."}},{name:"scoped",valueSet:"v"},{name:"title",description:"This attribute specifies [alternative style sheet](https://developer.mozilla.org/en-US/docs/Web/CSS/Alternative_style_sheets) sets."}],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/HTML/Element/style"}]},{name:"body",description:{kind:"markdown",value:"The body element represents the content of the document."},attributes:[{name:"onafterprint",description:{kind:"markdown",value:"Function to call after the user has printed the document."}},{name:"onbeforeprint",description:{kind:"markdown",value:"Function to call when the user requests printing of the document."}},{name:"onbeforeunload",description:{kind:"markdown",value:"Function to call when the document is about to be unloaded."}},{name:"onhashchange",description:{kind:"markdown",value:"Function to call when the fragment identifier part (starting with the hash (`'#'`) character) of the document's current address has changed."}},{name:"onlanguagechange",description:{kind:"markdown",value:"Function to call when the preferred languages changed."}},{name:"onmessage",description:{kind:"markdown",value:"Function to call when the document has received a message."}},{name:"onoffline",description:{kind:"markdown",value:"Function to call when network communication has failed."}},{name:"ononline",description:{kind:"markdown",value:"Function to call when network communication has been restored."}},{name:"onpagehide"},{name:"onpageshow"},{name:"onpopstate",description:{kind:"markdown",value:"Function to call when the user has navigated session history."}},{name:"onstorage",description:{kind:"markdown",value:"Function to call when the storage area has changed."}},{name:"onunload",description:{kind:"markdown",value:"Function to call when the document is going away."}},{name:"alink",description:'Color of text for hyperlinks when selected. _This method is non-conforming, use CSS [`color`](https://developer.mozilla.org/en-US/docs/Web/CSS/color "The color CSS property sets the foreground color value of an element\'s text and text decorations, and sets the currentcolor value.") property in conjunction with the [`:active`](https://developer.mozilla.org/en-US/docs/Web/CSS/:active "The :active CSS pseudo-class represents an element (such as a button) that is being activated by the user.") pseudo-class instead._'},{name:"background",description:'URI of a image to use as a background. _This method is non-conforming, use CSS [`background`](https://developer.mozilla.org/en-US/docs/Web/CSS/background "The background shorthand CSS property sets all background style properties at once, such as color, image, origin and size, or repeat method.") property on the element instead._'},{name:"bgcolor",description:'Background color for the document. _This method is non-conforming, use CSS [`background-color`](https://developer.mozilla.org/en-US/docs/Web/CSS/background-color "The background-color CSS property sets the background color of an element.") property on the element instead._'},{name:"bottommargin",description:'The margin of the bottom of the body. _This method is non-conforming, use CSS [`margin-bottom`](https://developer.mozilla.org/en-US/docs/Web/CSS/margin-bottom "The margin-bottom CSS property sets the margin area on the bottom of an element. A positive value places it farther from its neighbors, while a negative value places it closer.") property on the element instead._'},{name:"leftmargin",description:'The margin of the left of the body. _This method is non-conforming, use CSS [`margin-left`](https://developer.mozilla.org/en-US/docs/Web/CSS/margin-left "The margin-left CSS property sets the margin area on the left side of an element. A positive value places it farther from its neighbors, while a negative value places it closer.") property on the element instead._'},{name:"link",description:'Color of text for unvisited hypertext links. _This method is non-conforming, use CSS [`color`](https://developer.mozilla.org/en-US/docs/Web/CSS/color "The color CSS property sets the foreground color value of an element\'s text and text decorations, and sets the currentcolor value.") property in conjunction with the [`:link`](https://developer.mozilla.org/en-US/docs/Web/CSS/:link "The :link CSS pseudo-class represents an element that has not yet been visited. It matches every unvisited <a>, <area>, or <link> element that has an href attribute.") pseudo-class instead._'},{name:"onblur",description:"Function to call when the document loses focus."},{name:"onerror",description:"Function to call when the document fails to load properly."},{name:"onfocus",description:"Function to call when the document receives focus."},{name:"onload",description:"Function to call when the document has finished loading."},{name:"onredo",description:"Function to call when the user has moved forward in undo transaction history."},{name:"onresize",description:"Function to call when the document has been resized."},{name:"onundo",description:"Function to call when the user has moved backward in undo transaction history."},{name:"rightmargin",description:'The margin of the right of the body. _This method is non-conforming, use CSS [`margin-right`](https://developer.mozilla.org/en-US/docs/Web/CSS/margin-right "The margin-right CSS property sets the margin area on the right side of an element. A positive value places it farther from its neighbors, while a negative value places it closer.") property on the element instead._'},{name:"text",description:'Foreground color of text. _This method is non-conforming, use CSS [`color`](https://developer.mozilla.org/en-US/docs/Web/CSS/color "The color CSS property sets the foreground color value of an element\'s text and text decorations, and sets the currentcolor value.") property on the element instead._'},{name:"topmargin",description:'The margin of the top of the body. _This method is non-conforming, use CSS [`margin-top`](https://developer.mozilla.org/en-US/docs/Web/CSS/margin-top "The margin-top CSS property sets the margin area on the top of an element. A positive value places it farther from its neighbors, while a negative value places it closer.") property on the element instead._'},{name:"vlink",description:'Color of text for visited hypertext links. _This method is non-conforming, use CSS [`color`](https://developer.mozilla.org/en-US/docs/Web/CSS/color "The color CSS property sets the foreground color value of an element\'s text and text decorations, and sets the currentcolor value.") property in conjunction with the [`:visited`](https://developer.mozilla.org/en-US/docs/Web/CSS/:visited "The :visited CSS pseudo-class represents links that the user has already visited. For privacy reasons, the styles that can be modified using this selector are very limited.") pseudo-class instead._'}],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/HTML/Element/body"}]},{name:"article",description:{kind:"markdown",value:"The article element represents a complete, or self-contained, composition in a document, page, application, or site and that is, in principle, independently distributable or reusable, e.g. in syndication. This could be a forum post, a magazine or newspaper article, a blog entry, a user-submitted comment, an interactive widget or gadget, or any other independent item of content. Each article should be identified, typically by including a heading (h1–h6 element) as a child of the article element."},attributes:[],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/HTML/Element/article"}]},{name:"section",description:{kind:"markdown",value:"The section element represents a generic section of a document or application. A section, in this context, is a thematic grouping of content. Each section should be identified, typically by including a heading ( h1- h6 element) as a child of the section element."},attributes:[],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/HTML/Element/section"}]},{name:"nav",description:{kind:"markdown",value:"The nav element represents a section of a page that links to other pages or to parts within the page: a section with navigation links."},attributes:[],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/HTML/Element/nav"}]},{name:"aside",description:{kind:"markdown",value:"The aside element represents a section of a page that consists of content that is tangentially related to the content around the aside element, and which could be considered separate from that content. Such sections are often represented as sidebars in printed typography."},attributes:[],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/HTML/Element/aside"}]},{name:"h1",description:{kind:"markdown",value:"The h1 element represents a section heading."},attributes:[],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/HTML/Element/Heading_Elements"}]},{name:"h2",description:{kind:"markdown",value:"The h2 element represents a section heading."},attributes:[],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/HTML/Element/Heading_Elements"}]},{name:"h3",description:{kind:"markdown",value:"The h3 element represents a section heading."},attributes:[],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/HTML/Element/Heading_Elements"}]},{name:"h4",description:{kind:"markdown",value:"The h4 element represents a section heading."},attributes:[],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/HTML/Element/Heading_Elements"}]},{name:"h5",description:{kind:"markdown",value:"The h5 element represents a section heading."},attributes:[],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/HTML/Element/Heading_Elements"}]},{name:"h6",description:{kind:"markdown",value:"The h6 element represents a section heading."},attributes:[],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/HTML/Element/Heading_Elements"}]},{name:"header",description:{kind:"markdown",value:"The header element represents introductory content for its nearest ancestor sectioning content or sectioning root element. A header typically contains a group of introductory or navigational aids. When the nearest ancestor sectioning content or sectioning root element is the body element, then it applies to the whole page."},attributes:[],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/HTML/Element/header"}]},{name:"footer",description:{kind:"markdown",value:"The footer element represents a footer for its nearest ancestor sectioning content or sectioning root element. A footer typically contains information about its section such as who wrote it, links to related documents, copyright data, and the like."},attributes:[],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/HTML/Element/footer"}]},{name:"address",description:{kind:"markdown",value:"The address element represents the contact information for its nearest article or body element ancestor. If that is the body element, then the contact information applies to the document as a whole."},attributes:[],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/HTML/Element/address"}]},{name:"p",description:{kind:"markdown",value:"The p element represents a paragraph."},attributes:[],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/HTML/Element/p"}]},{name:"hr",description:{kind:"markdown",value:"The hr element represents a paragraph-level thematic break, e.g. a scene change in a story, or a transition to another topic within a section of a reference book."},attributes:[{name:"align",description:"Sets the alignment of the rule on the page. If no value is specified, the default value is `left`."},{name:"color",description:"Sets the color of the rule through color name or hexadecimal value."},{name:"noshade",description:"Sets the rule to have no shading."},{name:"size",description:"Sets the height, in pixels, of the rule."},{name:"width",description:"Sets the length of the rule on the page through a pixel or percentage value."}],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/HTML/Element/hr"}]},{name:"pre",description:{kind:"markdown",value:"The pre element represents a block of preformatted text, in which structure is represented by typographic conventions rather than by elements."},attributes:[{name:"cols",description:'Contains the _preferred_ count of characters that a line should have. It was a non-standard synonym of [`width`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/pre#attr-width). To achieve such an effect, use CSS [`width`](https://developer.mozilla.org/en-US/docs/Web/CSS/width "The width CSS property sets an element\'s width. By default it sets the width of the content area, but if box-sizing is set to border-box, it sets the width of the border area.") instead.'},{name:"width",description:'Contains the _preferred_ count of characters that a line should have. Though technically still implemented, this attribute has no visual effect; to achieve such an effect, use CSS [`width`](https://developer.mozilla.org/en-US/docs/Web/CSS/width "The width CSS property sets an element\'s width. By default it sets the width of the content area, but if box-sizing is set to border-box, it sets the width of the border area.") instead.'},{name:"wrap",description:'Is a _hint_ indicating how the overflow must happen. In modern browser this hint is ignored and no visual effect results in its present; to achieve such an effect, use CSS [`white-space`](https://developer.mozilla.org/en-US/docs/Web/CSS/white-space "The white-space CSS property sets how white space inside an element is handled.") instead.'}],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/HTML/Element/pre"}]},{name:"blockquote",description:{kind:"markdown",value:"The blockquote element represents content that is quoted from another source, optionally with a citation which must be within a footer or cite element, and optionally with in-line changes such as annotations and abbreviations."},attributes:[{name:"cite",description:{kind:"markdown",value:"A URL that designates a source document or message for the information quoted. This attribute is intended to point to information explaining the context or the reference for the quote."}}],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/HTML/Element/blockquote"}]},{name:"ol",description:{kind:"markdown",value:"The ol element represents a list of items, where the items have been intentionally ordered, such that changing the order would change the meaning of the document."},attributes:[{name:"reversed",valueSet:"v",description:{kind:"markdown",value:"This Boolean attribute specifies that the items of the list are specified in reversed order."}},{name:"start",description:{kind:"markdown",value:'This integer attribute specifies the start value for numbering the individual list items. Although the ordering type of list elements might be Roman numerals, such as XXXI, or letters, the value of start is always represented as a number. To start numbering elements from the letter "C", use `<ol start="3">`.\n\n**Note**: This attribute was deprecated in HTML4, but reintroduced in HTML5.'}},{name:"type",valueSet:"lt",description:{kind:"markdown",value:"Indicates the numbering type:\n\n*   `'a'` indicates lowercase letters,\n*   `'A'` indicates uppercase letters,\n*   `'i'` indicates lowercase Roman numerals,\n*   `'I'` indicates uppercase Roman numerals,\n*   and `'1'` indicates numbers (default).\n\nThe type set is used for the entire list unless a different [`type`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/li#attr-type) attribute is used within an enclosed [`<li>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/li \"The HTML <li> element is used to represent an item in a list. It must be contained in a parent element: an ordered list (<ol>), an unordered list (<ul>), or a menu (<menu>). In menus and unordered lists, list items are usually displayed using bullet points. In ordered lists, they are usually displayed with an ascending counter on the left, such as a number or letter.\") element.\n\n**Note:** This attribute was deprecated in HTML4, but reintroduced in HTML5.\n\nUnless the value of the list number matters (e.g. in legal or technical documents where items are to be referenced by their number/letter), the CSS [`list-style-type`](https://developer.mozilla.org/en-US/docs/Web/CSS/list-style-type \"The list-style-type CSS property sets the marker (such as a disc, character, or custom counter style) of a list item element.\") property should be used instead."}},{name:"compact",description:'This Boolean attribute hints that the list should be rendered in a compact style. The interpretation of this attribute depends on the user agent and it doesn\'t work in all browsers.\n\n**Warning:** Do not use this attribute, as it has been deprecated: the [`<ol>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/ol "The HTML <ol> element represents an ordered list of items, typically rendered as a numbered list.") element should be styled using [CSS](https://developer.mozilla.org/en-US/docs/CSS). To give an effect similar to the `compact` attribute, the [CSS](https://developer.mozilla.org/en-US/docs/CSS) property [`line-height`](https://developer.mozilla.org/en-US/docs/Web/CSS/line-height "The line-height CSS property sets the amount of space used for lines, such as in text. On block-level elements, it specifies the minimum height of line boxes within the element. On non-replaced inline elements, it specifies the height that is used to calculate line box height.") can be used with a value of `80%`.'}],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/HTML/Element/ol"}]},{name:"ul",description:{kind:"markdown",value:"The ul element represents a list of items, where the order of the items is not important — that is, where changing the order would not materially change the meaning of the document."},attributes:[{name:"compact",description:'This Boolean attribute hints that the list should be rendered in a compact style. The interpretation of this attribute depends on the user agent and it doesn\'t work in all browsers.\n\n**Usage note: **Do not use this attribute, as it has been deprecated: the [`<ul>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/ul "The HTML <ul> element represents an unordered list of items, typically rendered as a bulleted list.") element should be styled using [CSS](https://developer.mozilla.org/en-US/docs/CSS). To give a similar effect as the `compact` attribute, the [CSS](https://developer.mozilla.org/en-US/docs/CSS) property [line-height](https://developer.mozilla.org/en-US/docs/CSS/line-height) can be used with a value of `80%`.'}],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/HTML/Element/ul"}]},{name:"li",description:{kind:"markdown",value:"The li element represents a list item. If its parent element is an ol, ul, or menu element, then the element is an item of the parent element's list, as defined for those elements. Otherwise, the list item has no defined list-related relationship to any other li element."},attributes:[{name:"value",description:{kind:"markdown",value:'This integer attribute indicates the current ordinal value of the list item as defined by the [`<ol>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/ol "The HTML <ol> element represents an ordered list of items, typically rendered as a numbered list.") element. The only allowed value for this attribute is a number, even if the list is displayed with Roman numerals or letters. List items that follow this one continue numbering from the value set. The **value** attribute has no meaning for unordered lists ([`<ul>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/ul "The HTML <ul> element represents an unordered list of items, typically rendered as a bulleted list.")) or for menus ([`<menu>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/menu "The HTML <menu> element represents a group of commands that a user can perform or activate. This includes both list menus, which might appear across the top of a screen, as well as context menus, such as those that might appear underneath a button after it has been clicked.")).\n\n**Note**: This attribute was deprecated in HTML4, but reintroduced in HTML5.\n\n**Note:** Prior to Gecko 9.0, negative values were incorrectly converted to 0. Starting in Gecko 9.0 all integer values are correctly parsed.'}},{name:"type",description:'This character attribute indicates the numbering type:\n\n*   `a`: lowercase letters\n*   `A`: uppercase letters\n*   `i`: lowercase Roman numerals\n*   `I`: uppercase Roman numerals\n*   `1`: numbers\n\nThis type overrides the one used by its parent [`<ol>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/ol "The HTML <ol> element represents an ordered list of items, typically rendered as a numbered list.") element, if any.\n\n**Usage note:** This attribute has been deprecated: use the CSS [`list-style-type`](https://developer.mozilla.org/en-US/docs/Web/CSS/list-style-type "The list-style-type CSS property sets the marker (such as a disc, character, or custom counter style) of a list item element.") property instead.'}],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/HTML/Element/li"}]},{name:"dl",description:{kind:"markdown",value:"The dl element represents an association list consisting of zero or more name-value groups (a description list). A name-value group consists of one or more names (dt elements) followed by one or more values (dd elements), ignoring any nodes other than dt and dd elements. Within a single dl element, there should not be more than one dt element for each name."},attributes:[],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/HTML/Element/dl"}]},{name:"dt",description:{kind:"markdown",value:"The dt element represents the term, or name, part of a term-description group in a description list (dl element)."},attributes:[],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/HTML/Element/dt"}]},{name:"dd",description:{kind:"markdown",value:"The dd element represents the description, definition, or value, part of a term-description group in a description list (dl element)."},attributes:[{name:"nowrap",description:"If the value of this attribute is set to `yes`, the definition text will not wrap. The default value is `no`."}],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/HTML/Element/dd"}]},{name:"figure",description:{kind:"markdown",value:"The figure element represents some flow content, optionally with a caption, that is self-contained (like a complete sentence) and is typically referenced as a single unit from the main flow of the document."},attributes:[],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/HTML/Element/figure"}]},{name:"figcaption",description:{kind:"markdown",value:"The figcaption element represents a caption or legend for the rest of the contents of the figcaption element's parent figure element, if any."},attributes:[],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/HTML/Element/figcaption"}]},{name:"main",description:{kind:"markdown",value:"The main element represents the main content of the body of a document or application. The main content area consists of content that is directly related to or expands upon the central topic of a document or central functionality of an application."},attributes:[],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/HTML/Element/main"}]},{name:"div",description:{kind:"markdown",value:"The div element has no special meaning at all. It represents its children. It can be used with the class, lang, and title attributes to mark up semantics common to a group of consecutive elements."},attributes:[],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/HTML/Element/div"}]},{name:"a",description:{kind:"markdown",value:"If the a element has an href attribute, then it represents a hyperlink (a hypertext anchor) labeled by its contents."},attributes:[{name:"href",description:{kind:"markdown",value:"Contains a URL or a URL fragment that the hyperlink points to."}},{name:"target",description:{kind:"markdown",value:'Specifies where to display the linked URL. It is a name of, or keyword for, a _browsing context_: a tab, window, or `<iframe>`. The following keywords have special meanings:\n\n*   `_self`: Load the URL into the same browsing context as the current one. This is the default behavior.\n*   `_blank`: Load the URL into a new browsing context. This is usually a tab, but users can configure browsers to use new windows instead.\n*   `_parent`: Load the URL into the parent browsing context of the current one. If there is no parent, this behaves the same way as `_self`.\n*   `_top`: Load the URL into the top-level browsing context (that is, the "highest" browsing context that is an ancestor of the current one, and has no parent). If there is no parent, this behaves the same way as `_self`.\n\n**Note:** When using `target`, consider adding `rel="noreferrer"` to avoid exploitation of the `window.opener` API.\n\n**Note:** Linking to another page using `target="_blank"` will run the new page on the same process as your page. If the new page is executing expensive JS, your page\'s performance may suffer. To avoid this use `rel="noopener"`.'}},{name:"download",description:{kind:"markdown",value:"This attribute instructs browsers to download a URL instead of navigating to it, so the user will be prompted to save it as a local file. If the attribute has a value, it is used as the pre-filled file name in the Save prompt (the user can still change the file name if they want). There are no restrictions on allowed values, though `/` and `\\` are converted to underscores. Most file systems limit some punctuation in file names, and browsers will adjust the suggested name accordingly.\n\n**Notes:**\n\n*   This attribute only works for [same-origin URLs](https://developer.mozilla.org/en-US/docs/Web/Security/Same-origin_policy).\n*   Although HTTP(s) URLs need to be in the same-origin, [`blob:` URLs](https://developer.mozilla.org/en-US/docs/Web/API/URL.createObjectURL) and [`data:` URLs](https://developer.mozilla.org/en-US/docs/Web/HTTP/Basics_of_HTTP/Data_URIs) are allowed so that content generated by JavaScript, such as pictures created in an image-editor Web app, can be downloaded.\n*   If the HTTP header [`Content-Disposition:`](https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Content-Disposition) gives a different filename than this attribute, the HTTP header takes priority over this attribute.\n*   If `Content-Disposition:` is set to `inline`, Firefox prioritizes `Content-Disposition`, like the filename case, while Chrome prioritizes the `download` attribute."}},{name:"ping",description:{kind:"markdown",value:'Contains a space-separated list of URLs to which, when the hyperlink is followed, [`POST`](https://developer.mozilla.org/en-US/docs/Web/HTTP/Methods/POST "The HTTP POST method sends data to the server. The type of the body of the request is indicated by the Content-Type header.") requests with the body `PING` will be sent by the browser (in the background). Typically used for tracking.'}},{name:"rel",description:{kind:"markdown",value:"Specifies the relationship of the target object to the link object. The value is a space-separated list of [link types](https://developer.mozilla.org/en-US/docs/Web/HTML/Link_types)."}},{name:"hreflang",description:{kind:"markdown",value:'This attribute indicates the human language of the linked resource. It is purely advisory, with no built-in functionality. Allowed values are determined by [BCP47](https://www.ietf.org/rfc/bcp/bcp47.txt "Tags for Identifying Languages").'}},{name:"type",description:{kind:"markdown",value:'Specifies the media type in the form of a [MIME type](https://developer.mozilla.org/en-US/docs/Glossary/MIME_type "MIME type: A MIME type (now properly called "media type", but also sometimes "content type") is a string sent along with a file indicating the type of the file (describing the content format, for example, a sound file might be labeled audio/ogg, or an image file image/png).") for the linked URL. It is purely advisory, with no built-in functionality.'}},{name:"referrerpolicy",description:"Indicates which [referrer](https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Referer) to send when fetching the URL:\n\n*   `'no-referrer'` means the `Referer:` header will not be sent.\n*   `'no-referrer-when-downgrade'` means no `Referer:` header will be sent when navigating to an origin without HTTPS. This is the default behavior.\n*   `'origin'` means the referrer will be the [origin](https://developer.mozilla.org/en-US/docs/Glossary/Origin) of the page, not including information after the domain.\n*   `'origin-when-cross-origin'` meaning that navigations to other origins will be limited to the scheme, the host and the port, while navigations on the same origin will include the referrer's path.\n*   `'strict-origin-when-cross-origin'`\n*   `'unsafe-url'` means the referrer will include the origin and path, but not the fragment, password, or username. This is unsafe because it can leak data from secure URLs to insecure ones."}],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/HTML/Element/a"}]},{name:"em",description:{kind:"markdown",value:"The em element represents stress emphasis of its contents."},attributes:[],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/HTML/Element/em"}]},{name:"strong",description:{kind:"markdown",value:"The strong element represents strong importance, seriousness, or urgency for its contents."},attributes:[],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/HTML/Element/strong"}]},{name:"small",description:{kind:"markdown",value:"The small element represents side comments such as small print."},attributes:[],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/HTML/Element/small"}]},{name:"s",description:{kind:"markdown",value:"The s element represents contents that are no longer accurate or no longer relevant."},attributes:[],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/HTML/Element/s"}]},{name:"cite",description:{kind:"markdown",value:"The cite element represents a reference to a creative work. It must include the title of the work or the name of the author(person, people or organization) or an URL reference, or a reference in abbreviated form as per the conventions used for the addition of citation metadata."},attributes:[],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/HTML/Element/cite"}]},{name:"q",description:{kind:"markdown",value:"The q element represents some phrasing content quoted from another source."},attributes:[{name:"cite",description:{kind:"markdown",value:"The value of this attribute is a URL that designates a source document or message for the information quoted. This attribute is intended to point to information explaining the context or the reference for the quote."}}],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/HTML/Element/q"}]},{name:"dfn",description:{kind:"markdown",value:"The dfn element represents the defining instance of a term. The paragraph, description list group, or section that is the nearest ancestor of the dfn element must also contain the definition(s) for the term given by the dfn element."},attributes:[],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/HTML/Element/dfn"}]},{name:"abbr",description:{kind:"markdown",value:"The abbr element represents an abbreviation or acronym, optionally with its expansion. The title attribute may be used to provide an expansion of the abbreviation. The attribute, if specified, must contain an expansion of the abbreviation, and nothing else."},attributes:[],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/HTML/Element/abbr"}]},{name:"ruby",description:{kind:"markdown",value:"The ruby element allows one or more spans of phrasing content to be marked with ruby annotations. Ruby annotations are short runs of text presented alongside base text, primarily used in East Asian typography as a guide for pronunciation or to include other annotations. In Japanese, this form of typography is also known as furigana. Ruby text can appear on either side, and sometimes both sides, of the base text, and it is possible to control its position using CSS. A more complete introduction to ruby can be found in the Use Cases & Exploratory Approaches for Ruby Markup document as well as in CSS Ruby Module Level 1. [RUBY-UC] [CSSRUBY]"},attributes:[],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/HTML/Element/ruby"}]},{name:"rb",description:{kind:"markdown",value:"The rb element marks the base text component of a ruby annotation. When it is the child of a ruby element, it doesn't represent anything itself, but its parent ruby element uses it as part of determining what it represents."},attributes:[],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/HTML/Element/rb"}]},{name:"rt",description:{kind:"markdown",value:"The rt element marks the ruby text component of a ruby annotation. When it is the child of a ruby element or of an rtc element that is itself the child of a ruby element, it doesn't represent anything itself, but its ancestor ruby element uses it as part of determining what it represents."},attributes:[],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/HTML/Element/rt"}]},{name:"rp",description:{kind:"markdown",value:"The rp element is used to provide fallback text to be shown by user agents that don't support ruby annotations. One widespread convention is to provide parentheses around the ruby text component of a ruby annotation."},attributes:[],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/HTML/Element/rp"}]},{name:"time",description:{kind:"markdown",value:"The time element represents its contents, along with a machine-readable form of those contents in the datetime attribute. The kind of content is limited to various kinds of dates, times, time-zone offsets, and durations, as described below."},attributes:[{name:"datetime",description:{kind:"markdown",value:"This attribute indicates the time and/or date of the element and must be in one of the formats described below."}}],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/HTML/Element/time"}]},{name:"code",description:{kind:"markdown",value:"The code element represents a fragment of computer code. This could be an XML element name, a file name, a computer program, or any other string that a computer would recognize."},attributes:[],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/HTML/Element/code"}]},{name:"var",description:{kind:"markdown",value:"The var element represents a variable. This could be an actual variable in a mathematical expression or programming context, an identifier representing a constant, a symbol identifying a physical quantity, a function parameter, or just be a term used as a placeholder in prose."},attributes:[],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/HTML/Element/var"}]},{name:"samp",description:{kind:"markdown",value:"The samp element represents sample or quoted output from another program or computing system."},attributes:[],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/HTML/Element/samp"}]},{name:"kbd",description:{kind:"markdown",value:"The kbd element represents user input (typically keyboard input, although it may also be used to represent other input, such as voice commands)."},attributes:[],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/HTML/Element/kbd"}]},{name:"sub",description:{kind:"markdown",value:"The sub element represents a subscript."},attributes:[],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/HTML/Element/sub"}]},{name:"sup",description:{kind:"markdown",value:"The sup element represents a superscript."},attributes:[],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/HTML/Element/sup"}]},{name:"i",description:{kind:"markdown",value:"The i element represents a span of text in an alternate voice or mood, or otherwise offset from the normal prose in a manner indicating a different quality of text, such as a taxonomic designation, a technical term, an idiomatic phrase from another language, transliteration, a thought, or a ship name in Western texts."},attributes:[],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/HTML/Element/i"}]},{name:"b",description:{kind:"markdown",value:"The b element represents a span of text to which attention is being drawn for utilitarian purposes without conveying any extra importance and with no implication of an alternate voice or mood, such as key words in a document abstract, product names in a review, actionable words in interactive text-driven software, or an article lede."},attributes:[],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/HTML/Element/b"}]},{name:"u",description:{kind:"markdown",value:"The u element represents a span of text with an unarticulated, though explicitly rendered, non-textual annotation, such as labeling the text as being a proper name in Chinese text (a Chinese proper name mark), or labeling the text as being misspelt."},attributes:[],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/HTML/Element/u"}]},{name:"mark",description:{kind:"markdown",value:"The mark element represents a run of text in one document marked or highlighted for reference purposes, due to its relevance in another context. When used in a quotation or other block of text referred to from the prose, it indicates a highlight that was not originally present but which has been added to bring the reader's attention to a part of the text that might not have been considered important by the original author when the block was originally written, but which is now under previously unexpected scrutiny. When used in the main prose of a document, it indicates a part of the document that has been highlighted due to its likely relevance to the user's current activity."},attributes:[],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/HTML/Element/mark"}]},{name:"bdi",description:{kind:"markdown",value:"The bdi element represents a span of text that is to be isolated from its surroundings for the purposes of bidirectional text formatting. [BIDI]"},attributes:[],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/HTML/Element/bdi"}]},{name:"bdo",description:{kind:"markdown",value:"The bdo element represents explicit text directionality formatting control for its children. It allows authors to override the Unicode bidirectional algorithm by explicitly specifying a direction override. [BIDI]"},attributes:[{name:"dir",description:"The direction in which text should be rendered in this element's contents. Possible values are:\n\n*   `ltr`: Indicates that the text should go in a left-to-right direction.\n*   `rtl`: Indicates that the text should go in a right-to-left direction."}],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/HTML/Element/bdo"}]},{name:"span",description:{kind:"markdown",value:"The span element doesn't mean anything on its own, but can be useful when used together with the global attributes, e.g. class, lang, or dir. It represents its children."},attributes:[],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/HTML/Element/span"}]},{name:"br",description:{kind:"markdown",value:"The br element represents a line break."},attributes:[{name:"clear",description:"Indicates where to begin the next line after the break."}],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/HTML/Element/br"}]},{name:"wbr",description:{kind:"markdown",value:"The wbr element represents a line break opportunity."},attributes:[],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/HTML/Element/wbr"}]},{name:"ins",description:{kind:"markdown",value:"The ins element represents an addition to the document."},attributes:[{name:"cite",description:"This attribute defines the URI of a resource that explains the change, such as a link to meeting minutes or a ticket in a troubleshooting system."},{name:"datetime",description:'This attribute indicates the time and date of the change and must be a valid date with an optional time string. If the value cannot be parsed as a date with an optional time string, the element does not have an associated time stamp. For the format of the string without a time, see [Format of a valid date string](https://developer.mozilla.org/en-US/docs/Web/HTML/Date_and_time_formats#Format_of_a_valid_date_string "Certain HTML elements use date and/or time values. The formats of the strings that specify these are described in this article.") in [Date and time formats used in HTML](https://developer.mozilla.org/en-US/docs/Web/HTML/Date_and_time_formats "Certain HTML elements use date and/or time values. The formats of the strings that specify these are described in this article."). The format of the string if it includes both date and time is covered in [Format of a valid local date and time string](https://developer.mozilla.org/en-US/docs/Web/HTML/Date_and_time_formats#Format_of_a_valid_local_date_and_time_string "Certain HTML elements use date and/or time values. The formats of the strings that specify these are described in this article.") in [Date and time formats used in HTML](https://developer.mozilla.org/en-US/docs/Web/HTML/Date_and_time_formats "Certain HTML elements use date and/or time values. The formats of the strings that specify these are described in this article.").'}],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/HTML/Element/ins"}]},{name:"del",description:{kind:"markdown",value:"The del element represents a removal from the document."},attributes:[{name:"cite",description:{kind:"markdown",value:"A URI for a resource that explains the change (for example, meeting minutes)."}},{name:"datetime",description:{kind:"markdown",value:'This attribute indicates the time and date of the change and must be a valid date string with an optional time. If the value cannot be parsed as a date with an optional time string, the element does not have an associated time stamp. For the format of the string without a time, see [Format of a valid date string](https://developer.mozilla.org/en-US/docs/Web/HTML/Date_and_time_formats#Format_of_a_valid_date_string "Certain HTML elements use date and/or time values. The formats of the strings that specify these are described in this article.") in [Date and time formats used in HTML](https://developer.mozilla.org/en-US/docs/Web/HTML/Date_and_time_formats "Certain HTML elements use date and/or time values. The formats of the strings that specify these are described in this article."). The format of the string if it includes both date and time is covered in [Format of a valid local date and time string](https://developer.mozilla.org/en-US/docs/Web/HTML/Date_and_time_formats#Format_of_a_valid_local_date_and_time_string "Certain HTML elements use date and/or time values. The formats of the strings that specify these are described in this article.") in [Date and time formats used in HTML](https://developer.mozilla.org/en-US/docs/Web/HTML/Date_and_time_formats "Certain HTML elements use date and/or time values. The formats of the strings that specify these are described in this article.").'}}],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/HTML/Element/del"}]},{name:"picture",description:{kind:"markdown",value:"The picture element is a container which provides multiple sources to its contained img element to allow authors to declaratively control or give hints to the user agent about which image resource to use, based on the screen pixel density, viewport size, image format, and other factors. It represents its children."},attributes:[],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/HTML/Element/picture"}]},{name:"img",description:{kind:"markdown",value:"An img element represents an image."},attributes:[{name:"alt",description:{kind:"markdown",value:'This attribute defines an alternative text description of the image.\n\n**Note:** Browsers do not always display the image referenced by the element. This is the case for non-graphical browsers (including those used by people with visual impairments), if the user chooses not to display images, or if the browser cannot display the image because it is invalid or an [unsupported type](#Supported_image_formats). In these cases, the browser may replace the image with the text defined in this element\'s `alt` attribute. You should, for these reasons and others, provide a useful value for `alt` whenever possible.\n\n**Note:** Omitting this attribute altogether indicates that the image is a key part of the content, and no textual equivalent is available. Setting this attribute to an empty string (`alt=""`) indicates that this image is _not_ a key part of the content (decorative), and that non-visual browsers may omit it from rendering.'}},{name:"src",description:{kind:"markdown",value:"The image URL. This attribute is mandatory for the `<img>` element. On browsers supporting `srcset`, `src` is treated like a candidate image with a pixel density descriptor `1x` unless an image with this pixel density descriptor is already defined in `srcset,` or unless `srcset` contains '`w`' descriptors."}},{name:"srcset",description:{kind:"markdown",value:"A list of one or more strings separated by commas indicating a set of possible image sources for the user agent to use. Each string is composed of:\n\n1.  a URL to an image,\n2.  optionally, whitespace followed by one of:\n    *   A width descriptor, or a positive integer directly followed by '`w`'. The width descriptor is divided by the source size given in the `sizes` attribute to calculate the effective pixel density.\n    *   A pixel density descriptor, which is a positive floating point number directly followed by '`x`'.\n\nIf no descriptor is specified, the source is assigned the default descriptor: `1x`.\n\nIt is incorrect to mix width descriptors and pixel density descriptors in the same `srcset` attribute. Duplicate descriptors (for instance, two sources in the same `srcset` which are both described with '`2x`') are also invalid.\n\nThe user agent selects any one of the available sources at its discretion. This provides them with significant leeway to tailor their selection based on things like user preferences or bandwidth conditions. See our [Responsive images](https://developer.mozilla.org/en-US/docs/Learn/HTML/Multimedia_and_embedding/Responsive_images) tutorial for an example."}},{name:"crossorigin",valueSet:"xo",description:{kind:"markdown",value:'This enumerated attribute indicates if the fetching of the related image must be done using CORS or not. [CORS-enabled images](https://developer.mozilla.org/en-US/docs/CORS_Enabled_Image) can be reused in the [`<canvas>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/canvas "Use the HTML <canvas> element with either the canvas scripting API or the WebGL API to draw graphics and animations.") element without being "[tainted](https://developer.mozilla.org/en-US/docs/Web/HTML/CORS_enabled_image#What_is_a_tainted_canvas)." The allowed values are:'}},{name:"usemap",description:{kind:"markdown",value:'The partial URL (starting with \'#\') of an [image map](https://developer.mozilla.org/en-US/docs/HTML/Element/map) associated with the element.\n\n**Note:** You cannot use this attribute if the `<img>` element is a descendant of an [`<a>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/a "The HTML <a> element (or anchor element) creates a hyperlink to other web pages, files, locations within the same page, email addresses, or any other URL.") or [`<button>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/button "The HTML <button> element represents a clickable button, which can be used in forms or anywhere in a document that needs simple, standard button functionality.") element.'}},{name:"ismap",valueSet:"v",description:{kind:"markdown",value:'This Boolean attribute indicates that the image is part of a server-side map. If so, the precise coordinates of a click are sent to the server.\n\n**Note:** This attribute is allowed only if the `<img>` element is a descendant of an [`<a>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/a "The HTML <a> element (or anchor element) creates a hyperlink to other web pages, files, locations within the same page, email addresses, or any other URL.") element with a valid [`href`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/a#attr-href) attribute.'}},{name:"width",description:{kind:"markdown",value:"The intrinsic width of the image in pixels."}},{name:"height",description:{kind:"markdown",value:"The intrinsic height of the image in pixels."}},{name:"decoding",description:"Provides an image decoding hint to the browser. The allowed values are:"},{name:"decoding",description:"`sync`\n\nDecode the image synchronously for atomic presentation with other content.\n\n`async`\n\nDecode the image asynchronously to reduce delay in presenting other content.\n\n`auto`\n\nDefault mode, which indicates no preference for the decoding mode. The browser decides what is best for the user."},{name:"importance",description:"Indicates the relative importance of the resource. Priority hints are delegated using the values:"},{name:"importance",description:"`auto`: Indicates **no preference**. The browser may use its own heuristics to decide the priority of the image.\n\n`high`: Indicates to the browser that the image is of **high** priority.\n\n`low`: Indicates to the browser that the image is of **low** priority."},{name:"intrinsicsize",description:"This attribute tells the browser to ignore the actual intrinsic size of the image and pretend it’s the size specified in the attribute. Specifically, the image would raster at these dimensions and `naturalWidth`/`naturalHeight` on images would return the values specified in this attribute. [Explainer](https://github.com/ojanvafai/intrinsicsize-attribute), [examples](https://googlechrome.github.io/samples/intrinsic-size/index.html)"},{name:"referrerpolicy",description:"A string indicating which referrer to use when fetching the resource:\n\n*   `no-referrer:` The [`Referer`](https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Referer \"The Referer request header contains the address of the previous web page from which a link to the currently requested page was followed. The Referer header allows servers to identify where people are visiting them from and may use that data for analytics, logging, or optimized caching, for example.\") header will not be sent.\n*   `no-referrer-when-downgrade:` No `Referer` header will be sent when navigating to an origin without TLS (HTTPS). This is a user agent’s default behavior if no policy is otherwise specified.\n*   `origin:` The `Referer` header will include the page of origin's scheme, the host, and the port.\n*   `origin-when-cross-origin:` Navigating to other origins will limit the included referral data to the scheme, the host and the port, while navigating from the same origin will include the referrer's full path.\n*   `unsafe-url:` The `Referer` header will include the origin and the path, but not the fragment, password, or username. This case is unsafe because it can leak origins and paths from TLS-protected resources to insecure origins."},{name:"sizes",description:"A list of one or more strings separated by commas indicating a set of source sizes. Each source size consists of:\n\n1.  a media condition. This must be omitted for the last item.\n2.  a source size value.\n\nSource size values specify the intended display size of the image. User agents use the current source size to select one of the sources supplied by the `srcset` attribute, when those sources are described using width ('`w`') descriptors. The selected source size affects the intrinsic size of the image (the image’s display size if no CSS styling is applied). If the `srcset` attribute is absent, or contains no values with a width (`w`) descriptor, then the `sizes` attribute has no effect."}],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/HTML/Element/img"}]},{name:"iframe",description:{kind:"markdown",value:"The iframe element represents a nested browsing context."},attributes:[{name:"src",description:{kind:"markdown",value:'The URL of the page to embed. Use a value of `about:blank` to embed an empty page that conforms to the [same-origin policy](https://developer.mozilla.org/en-US/docs/Web/Security/Same-origin_policy#Inherited_origins). Also note that programatically removing an `<iframe>`\'s src attribute (e.g. via [`Element.removeAttribute()`](https://developer.mozilla.org/en-US/docs/Web/API/Element/removeAttribute "The Element method removeAttribute() removes the attribute with the specified name from the element.")) causes `about:blank` to be loaded in the frame in Firefox (from version 65), Chromium-based browsers, and Safari/iOS.'}},{name:"srcdoc",description:{kind:"markdown",value:"Inline HTML to embed, overriding the `src` attribute. If a browser does not support the `srcdoc` attribute, it will fall back to the URL in the `src` attribute."}},{name:"name",description:{kind:"markdown",value:'A targetable name for the embedded browsing context. This can be used in the `target` attribute of the [`<a>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/a "The HTML <a> element (or anchor element) creates a hyperlink to other web pages, files, locations within the same page, email addresses, or any other URL."), [`<form>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/form "The HTML <form> element represents a document section that contains interactive controls for submitting information to a web server."), or [`<base>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/base "The HTML <base> element specifies the base URL to use for all relative URLs contained within a document. There can be only one <base> element in a document.") elements; the `formtarget` attribute of the [`<input>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/input "The HTML <input> element is used to create interactive controls for web-based forms in order to accept data from the user; a wide variety of types of input data and control widgets are available, depending on the device and user agent.") or [`<button>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/button "The HTML <button> element represents a clickable button, which can be used in forms or anywhere in a document that needs simple, standard button functionality.") elements; or the `windowName` parameter in the [`window.open()`](https://developer.mozilla.org/en-US/docs/Web/API/Window/open "The Window interface\'s open() method loads the specified resource into the browsing context (window, <iframe> or tab) with the specified name. If the name doesn\'t exist, then a new window is opened and the specified resource is loaded into its browsing context.") method.'}},{name:"sandbox",valueSet:"sb",description:{kind:"markdown",value:'Applies extra restrictions to the content in the frame. The value of the attribute can either be empty to apply all restrictions, or space-separated tokens to lift particular restrictions:\n\n*   `allow-forms`: Allows the resource to submit forms. If this keyword is not used, form submission is blocked.\n*   `allow-modals`: Lets the resource [open modal windows](https://html.spec.whatwg.org/multipage/origin.html#sandboxed-modals-flag).\n*   `allow-orientation-lock`: Lets the resource [lock the screen orientation](https://developer.mozilla.org/en-US/docs/Web/API/Screen/lockOrientation).\n*   `allow-pointer-lock`: Lets the resource use the [Pointer Lock API](https://developer.mozilla.org/en-US/docs/WebAPI/Pointer_Lock).\n*   `allow-popups`: Allows popups (such as `window.open()`, `target="_blank"`, or `showModalDialog()`). If this keyword is not used, the popup will silently fail to open.\n*   `allow-popups-to-escape-sandbox`: Lets the sandboxed document open new windows without those windows inheriting the sandboxing. For example, this can safely sandbox an advertisement without forcing the same restrictions upon the page the ad links to.\n*   `allow-presentation`: Lets the resource start a [presentation session](https://developer.mozilla.org/en-US/docs/Web/API/PresentationRequest).\n*   `allow-same-origin`: If this token is not used, the resource is treated as being from a special origin that always fails the [same-origin policy](https://developer.mozilla.org/en-US/docs/Glossary/same-origin_policy "same-origin policy: The same-origin policy is a critical security mechanism that restricts how a document or script loaded from one origin can interact with a resource from another origin.").\n*   `allow-scripts`: Lets the resource run scripts (but not create popup windows).\n*   `allow-storage-access-by-user-activation` : Lets the resource request access to the parent\'s storage capabilities with the [Storage Access API](https://developer.mozilla.org/en-US/docs/Web/API/Storage_Access_API).\n*   `allow-top-navigation`: Lets the resource navigate the top-level browsing context (the one named `_top`).\n*   `allow-top-navigation-by-user-activation`: Lets the resource navigate the top-level browsing context, but only if initiated by a user gesture.\n\n**Notes about sandboxing:**\n\n*   When the embedded document has the same origin as the embedding page, it is **strongly discouraged** to use both `allow-scripts` and `allow-same-origin`, as that lets the embedded document remove the `sandbox` attribute — making it no more secure than not using the `sandbox` attribute at all.\n*   Sandboxing is useless if the attacker can display content outside a sandboxed `iframe` — such as if the viewer opens the frame in a new tab. Such content should be also served from a _separate origin_ to limit potential damage.\n*   The `sandbox` attribute is unsupported in Internet Explorer 9 and earlier.'}},{name:"seamless",valueSet:"v"},{name:"allowfullscreen",valueSet:"v",description:{kind:"markdown",value:'Set to `true` if the `<iframe>` can activate fullscreen mode by calling the [`requestFullscreen()`](https://developer.mozilla.org/en-US/docs/Web/API/Element/requestFullscreen "The Element.requestFullscreen() method issues an asynchronous request to make the element be displayed in full-screen mode.") method.'}},{name:"width",description:{kind:"markdown",value:"The width of the frame in CSS pixels. Default is `300`."}},{name:"height",description:{kind:"markdown",value:"The height of the frame in CSS pixels. Default is `150`."}},{name:"allow",description:"Specifies a [feature policy](https://developer.mozilla.org/en-US/docs/Web/HTTP/Feature_Policy) for the `<iframe>`."},{name:"allowpaymentrequest",description:"Set to `true` if a cross-origin `<iframe>` should be allowed to invoke the [Payment Request API](https://developer.mozilla.org/en-US/docs/Web/API/Payment_Request_API)."},{name:"allowpaymentrequest",description:'This attribute is considered a legacy attribute and redefined as `allow="payment"`.'},{name:"csp",description:'A [Content Security Policy](https://developer.mozilla.org/en-US/docs/Web/HTTP/CSP) enforced for the embedded resource. See [`HTMLIFrameElement.csp`](https://developer.mozilla.org/en-US/docs/Web/API/HTMLIFrameElement/csp "The csp property of the HTMLIFrameElement interface specifies the Content Security Policy that an embedded document must agree to enforce upon itself.") for details.'},{name:"importance",description:"The download priority of the resource in the `<iframe>`'s `src` attribute. Allowed values:\n\n`auto` (default)\n\nNo preference. The browser uses its own heuristics to decide the priority of the resource.\n\n`high`\n\nThe resource should be downloaded before other lower-priority page resources.\n\n`low`\n\nThe resource should be downloaded after other higher-priority page resources."},{name:"referrerpolicy",description:'Indicates which [referrer](https://developer.mozilla.org/en-US/docs/Web/API/Document/referrer) to send when fetching the frame\'s resource:\n\n*   `no-referrer`: The [`Referer`](https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Referer "The Referer request header contains the address of the previous web page from which a link to the currently requested page was followed. The Referer header allows servers to identify where people are visiting them from and may use that data for analytics, logging, or optimized caching, for example.") header will not be sent.\n*   `no-referrer-when-downgrade` (default): The [`Referer`](https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Referer "The Referer request header contains the address of the previous web page from which a link to the currently requested page was followed. The Referer header allows servers to identify where people are visiting them from and may use that data for analytics, logging, or optimized caching, for example.") header will not be sent to [origin](https://developer.mozilla.org/en-US/docs/Glossary/origin "origin: Web content\'s origin is defined by the scheme (protocol), host (domain), and port of the URL used to access it. Two objects have the same origin only when the scheme, host, and port all match.")s without [TLS](https://developer.mozilla.org/en-US/docs/Glossary/TLS "TLS: Transport Layer Security (TLS), previously known as Secure Sockets Layer (SSL), is a protocol used by applications to communicate securely across a network, preventing tampering with and eavesdropping on email, web browsing, messaging, and other protocols.") ([HTTPS](https://developer.mozilla.org/en-US/docs/Glossary/HTTPS "HTTPS: HTTPS (HTTP Secure) is an encrypted version of the HTTP protocol. It usually uses SSL or TLS to encrypt all communication between a client and a server. This secure connection allows clients to safely exchange sensitive data with a server, for example for banking activities or online shopping.")).\n*   `origin`: The sent referrer will be limited to the origin of the referring page: its [scheme](https://developer.mozilla.org/en-US/docs/Archive/Mozilla/URIScheme), [host](https://developer.mozilla.org/en-US/docs/Glossary/host "host: A host is a device connected to the Internet (or a local network). Some hosts called servers offer additional services like serving webpages or storing files and emails."), and [port](https://developer.mozilla.org/en-US/docs/Glossary/port "port: For a computer connected to a network with an IP address, a port is a communication endpoint. Ports are designated by numbers, and below 1024 each port is associated by default with a specific protocol.").\n*   `origin-when-cross-origin`: The referrer sent to other origins will be limited to the scheme, the host, and the port. Navigations on the same origin will still include the path.\n*   `same-origin`: A referrer will be sent for [same origin](https://developer.mozilla.org/en-US/docs/Glossary/Same-origin_policy "same origin: The same-origin policy is a critical security mechanism that restricts how a document or script loaded from one origin can interact with a resource from another origin."), but cross-origin requests will contain no referrer information.\n*   `strict-origin`: Only send the origin of the document as the referrer when the protocol security level stays the same (HTTPS→HTTPS), but don\'t send it to a less secure destination (HTTPS→HTTP).\n*   `strict-origin-when-cross-origin`: Send a full URL when performing a same-origin request, only send the origin when the protocol security level stays the same (HTTPS→HTTPS), and send no header to a less secure destination (HTTPS→HTTP).\n*   `unsafe-url`: The referrer will include the origin _and_ the path (but not the [fragment](https://developer.mozilla.org/en-US/docs/Web/API/HTMLHyperlinkElementUtils/hash), [password](https://developer.mozilla.org/en-US/docs/Web/API/HTMLHyperlinkElementUtils/password), or [username](https://developer.mozilla.org/en-US/docs/Web/API/HTMLHyperlinkElementUtils/username)). **This value is unsafe**, because it leaks origins and paths from TLS-protected resources to insecure origins.'}],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/HTML/Element/iframe"}]},{name:"embed",description:{kind:"markdown",value:"The embed element provides an integration point for an external (typically non-HTML) application or interactive content."},attributes:[{name:"src",description:{kind:"markdown",value:"The URL of the resource being embedded."}},{name:"type",description:{kind:"markdown",value:"The MIME type to use to select the plug-in to instantiate."}},{name:"width",description:{kind:"markdown",value:"The displayed width of the resource, in [CSS pixels](https://drafts.csswg.org/css-values/#px). This must be an absolute value; percentages are _not_ allowed."}},{name:"height",description:{kind:"markdown",value:"The displayed height of the resource, in [CSS pixels](https://drafts.csswg.org/css-values/#px). This must be an absolute value; percentages are _not_ allowed."}}],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/HTML/Element/embed"}]},{name:"object",description:{kind:"markdown",value:"The object element can represent an external resource, which, depending on the type of the resource, will either be treated as an image, as a nested browsing context, or as an external resource to be processed by a plugin."},attributes:[{name:"data",description:{kind:"markdown",value:"The address of the resource as a valid URL. At least one of **data** and **type** must be defined."}},{name:"type",description:{kind:"markdown",value:"The [content type](https://developer.mozilla.org/en-US/docs/Glossary/Content_type) of the resource specified by **data**. At least one of **data** and **type** must be defined."}},{name:"typemustmatch",valueSet:"v",description:{kind:"markdown",value:"This Boolean attribute indicates if the **type** attribute and the actual [content type](https://developer.mozilla.org/en-US/docs/Glossary/Content_type) of the resource must match to be used."}},{name:"name",description:{kind:"markdown",value:"The name of valid browsing context (HTML5), or the name of the control (HTML 4)."}},{name:"usemap",description:{kind:"markdown",value:"A hash-name reference to a [`<map>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/map \"The HTML <map> element is used with <area> elements to define an image map (a clickable link area).\") element; that is a '#' followed by the value of a [`name`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/map#attr-name) of a map element."}},{name:"form",description:{kind:"markdown",value:'The form element, if any, that the object element is associated with (its _form owner_). The value of the attribute must be an ID of a [`<form>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/form "The HTML <form> element represents a document section that contains interactive controls for submitting information to a web server.") element in the same document.'}},{name:"width",description:{kind:"markdown",value:"The width of the display resource, in [CSS pixels](https://drafts.csswg.org/css-values/#px). -- (Absolute values only. [NO percentages](https://html.spec.whatwg.org/multipage/embedded-content.html#dimension-attributes))"}},{name:"height",description:{kind:"markdown",value:"The height of the displayed resource, in [CSS pixels](https://drafts.csswg.org/css-values/#px). -- (Absolute values only. [NO percentages](https://html.spec.whatwg.org/multipage/embedded-content.html#dimension-attributes))"}},{name:"archive",description:"A space-separated list of URIs for archives of resources for the object."},{name:"border",description:"The width of a border around the control, in pixels."},{name:"classid",description:"The URI of the object's implementation. It can be used together with, or in place of, the **data** attribute."},{name:"codebase",description:"The base path used to resolve relative URIs specified by **classid**, **data**, or **archive**. If not specified, the default is the base URI of the current document."},{name:"codetype",description:"The content type of the data specified by **classid**."},{name:"declare",description:"The presence of this Boolean attribute makes this element a declaration only. The object must be instantiated by a subsequent `<object>` element. In HTML5, repeat the <object> element completely each that that the resource is reused."},{name:"standby",description:"A message that the browser can show while loading the object's implementation and data."},{name:"tabindex",description:"The position of the element in the tabbing navigation order for the current document."}],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/HTML/Element/object"}]},{name:"param",description:{kind:"markdown",value:"The param element defines parameters for plugins invoked by object elements. It does not represent anything on its own."},attributes:[{name:"name",description:{kind:"markdown",value:"Name of the parameter."}},{name:"value",description:{kind:"markdown",value:"Specifies the value of the parameter."}},{name:"type",description:'Only used if the `valuetype` is set to "ref". Specifies the MIME type of values found at the URI specified by value.'},{name:"valuetype",description:'Specifies the type of the `value` attribute. Possible values are:\n\n*   data: Default value. The value is passed to the object\'s implementation as a string.\n*   ref: The value is a URI to a resource where run-time values are stored.\n*   object: An ID of another [`<object>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/object "The HTML <object> element represents an external resource, which can be treated as an image, a nested browsing context, or a resource to be handled by a plugin.") in the same document.'}],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/HTML/Element/param"}]},{name:"video",description:{kind:"markdown",value:"A video element is used for playing videos or movies, and audio files with captions."},attributes:[{name:"src"},{name:"crossorigin",valueSet:"xo"},{name:"poster"},{name:"preload",valueSet:"pl"},{name:"autoplay",valueSet:"v",description:{kind:"markdown",value:"A Boolean attribute; if specified, the video automatically begins to play back as soon as it can do so without stopping to finish loading the data."}},{name:"mediagroup"},{name:"loop",valueSet:"v"},{name:"muted",valueSet:"v"},{name:"controls",valueSet:"v"},{name:"width"},{name:"height"}],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/HTML/Element/video"}]},{name:"audio",description:{kind:"markdown",value:"An audio element represents a sound or audio stream."},attributes:[{name:"src",description:{kind:"markdown",value:'The URL of the audio to embed. This is subject to [HTTP access controls](https://developer.mozilla.org/en-US/docs/HTTP_access_control). This is optional; you may instead use the [`<source>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/source "The HTML <source> element specifies multiple media resources for the <picture>, the <audio> element, or the <video> element.") element within the audio block to specify the audio to embed.'}},{name:"crossorigin",valueSet:"xo",description:{kind:"markdown",value:'This enumerated attribute indicates whether to use CORS to fetch the related image. [CORS-enabled resources](https://developer.mozilla.org/en-US/docs/CORS_Enabled_Image) can be reused in the [`<canvas>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/canvas "Use the HTML <canvas> element with either the canvas scripting API or the WebGL API to draw graphics and animations.") element without being _tainted_. The allowed values are:\n\nanonymous\n\nSends a cross-origin request without a credential. In other words, it sends the `Origin:` HTTP header without a cookie, X.509 certificate, or performing HTTP Basic authentication. If the server does not give credentials to the origin site (by not setting the `Access-Control-Allow-Origin:` HTTP header), the image will be _tainted_, and its usage restricted.\n\nuse-credentials\n\nSends a cross-origin request with a credential. In other words, it sends the `Origin:` HTTP header with a cookie, a certificate, or performing HTTP Basic authentication. If the server does not give credentials to the origin site (through `Access-Control-Allow-Credentials:` HTTP header), the image will be _tainted_ and its usage restricted.\n\nWhen not present, the resource is fetched without a CORS request (i.e. without sending the `Origin:` HTTP header), preventing its non-tainted used in [`<canvas>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/canvas "Use the HTML <canvas> element with either the canvas scripting API or the WebGL API to draw graphics and animations.") elements. If invalid, it is handled as if the enumerated keyword **anonymous** was used. See [CORS settings attributes](https://developer.mozilla.org/en-US/docs/HTML/CORS_settings_attributes) for additional information.'}},{name:"preload",valueSet:"pl",description:{kind:"markdown",value:"This enumerated attribute is intended to provide a hint to the browser about what the author thinks will lead to the best user experience. It may have one of the following values:\n\n*   `none`: Indicates that the audio should not be preloaded.\n*   `metadata`: Indicates that only audio metadata (e.g. length) is fetched.\n*   `auto`: Indicates that the whole audio file can be downloaded, even if the user is not expected to use it.\n*   _empty string_: A synonym of the `auto` value.\n\nIf not set, `preload`'s default value is browser-defined (i.e. each browser may have its own default value). The spec advises it to be set to `metadata`.\n\n**Usage notes:**\n\n*   The `autoplay` attribute has precedence over `preload`. If `autoplay` is specified, the browser would obviously need to start downloading the audio for playback.\n*   The browser is not forced by the specification to follow the value of this attribute; it is a mere hint."}},{name:"autoplay",valueSet:"v",description:{kind:"markdown",value:"A Boolean attribute: if specified, the audio will automatically begin playback as soon as it can do so, without waiting for the entire audio file to finish downloading.\n\n**Note**: Sites that automatically play audio (or videos with an audio track) can be an unpleasant experience for users, so should be avoided when possible. If you must offer autoplay functionality, you should make it opt-in (requiring a user to specifically enable it). However, this can be useful when creating media elements whose source will be set at a later time, under user control."}},{name:"mediagroup"},{name:"loop",valueSet:"v",description:{kind:"markdown",value:"A Boolean attribute: if specified, the audio player will automatically seek back to the start upon reaching the end of the audio."}},{name:"muted",valueSet:"v",description:{kind:"markdown",value:"A Boolean attribute that indicates whether the audio will be initially silenced. Its default value is `false`."}},{name:"controls",valueSet:"v",description:{kind:"markdown",value:"If this attribute is present, the browser will offer controls to allow the user to control audio playback, including volume, seeking, and pause/resume playback."}}],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/HTML/Element/audio"}]},{name:"source",description:{kind:"markdown",value:"The source element allows authors to specify multiple alternative media resources for media elements. It does not represent anything on its own."},attributes:[{name:"src",description:{kind:"markdown",value:'Required for [`<audio>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/audio "The HTML <audio> element is used to embed sound content in documents. It may contain one or more audio sources, represented using the src attribute or the <source> element: the browser will choose the most suitable one. It can also be the destination for streamed media, using a MediaStream.") and [`<video>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/video "The HTML Video element (<video>) embeds a media player which supports video playback into the document."), address of the media resource. The value of this attribute is ignored when the `<source>` element is placed inside a [`<picture>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/picture "The HTML <picture> element contains zero or more <source> elements and one <img> element to provide versions of an image for different display/device scenarios.") element.'}},{name:"type",description:{kind:"markdown",value:"The MIME-type of the resource, optionally with a `codecs` parameter. See [RFC 4281](https://tools.ietf.org/html/rfc4281) for information about how to specify codecs."}},{name:"sizes",description:'Is a list of source sizes that describes the final rendered width of the image represented by the source. Each source size consists of a comma-separated list of media condition-length pairs. This information is used by the browser to determine, before laying the page out, which image defined in [`srcset`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/source#attr-srcset) to use.  \nThe `sizes` attribute has an effect only when the [`<source>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/source "The HTML <source> element specifies multiple media resources for the <picture>, the <audio> element, or the <video> element.") element is the direct child of a [`<picture>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/picture "The HTML <picture> element contains zero or more <source> elements and one <img> element to provide versions of an image for different display/device scenarios.") element.'},{name:"srcset",description:"A list of one or more strings separated by commas indicating a set of possible images represented by the source for the browser to use. Each string is composed of:\n\n1.  one URL to an image,\n2.  a width descriptor, that is a positive integer directly followed by `'w'`. The default value, if missing, is the infinity.\n3.  a pixel density descriptor, that is a positive floating number directly followed by `'x'`. The default value, if missing, is `1x`.\n\nEach string in the list must have at least a width descriptor or a pixel density descriptor to be valid. Among the list, there must be only one string containing the same tuple of width descriptor and pixel density descriptor.  \nThe browser chooses the most adequate image to display at a given point of time.  \nThe `srcset` attribute has an effect only when the [`<source>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/source \"The HTML <source> element specifies multiple media resources for the <picture>, the <audio> element, or the <video> element.\") element is the direct child of a [`<picture>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/picture \"The HTML <picture> element contains zero or more <source> elements and one <img> element to provide versions of an image for different display/device scenarios.\") element."},{name:"media",description:'[Media query](https://developer.mozilla.org/en-US/docs/CSS/Media_queries) of the resource\'s intended media; this should be used only in a [`<picture>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/picture "The HTML <picture> element contains zero or more <source> elements and one <img> element to provide versions of an image for different display/device scenarios.") element.'}],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/HTML/Element/source"}]},{name:"track",description:{kind:"markdown",value:"The track element allows authors to specify explicit external timed text tracks for media elements. It does not represent anything on its own."},attributes:[{name:"default",valueSet:"v",description:{kind:"markdown",value:"This attribute indicates that the track should be enabled unless the user's preferences indicate that another track is more appropriate. This may only be used on one `track` element per media element."}},{name:"kind",valueSet:"tk",description:{kind:"markdown",value:"How the text track is meant to be used. If omitted the default kind is `subtitles`. If the attribute is not present, it will use the `subtitles`. If the attribute contains an invalid value, it will use `metadata`. (Versions of Chrome earlier than 52 treated an invalid value as `subtitles`.) The following keywords are allowed:\n\n*   `subtitles`\n    *   Subtitles provide translation of content that cannot be understood by the viewer. For example dialogue or text that is not English in an English language film.\n    *   Subtitles may contain additional content, usually extra background information. For example the text at the beginning of the Star Wars films, or the date, time, and location of a scene.\n*   `captions`\n    *   Closed captions provide a transcription and possibly a translation of audio.\n    *   It may include important non-verbal information such as music cues or sound effects. It may indicate the cue's source (e.g. music, text, character).\n    *   Suitable for users who are deaf or when the sound is muted.\n*   `descriptions`\n    *   Textual description of the video content.\n    *   Suitable for users who are blind or where the video cannot be seen.\n*   `chapters`\n    *   Chapter titles are intended to be used when the user is navigating the media resource.\n*   `metadata`\n    *   Tracks used by scripts. Not visible to the user."}},{name:"label",description:{kind:"markdown",value:"A user-readable title of the text track which is used by the browser when listing available text tracks."}},{name:"src",description:{kind:"markdown",value:'Address of the track (`.vtt` file). Must be a valid URL. This attribute must be specified and its URL value must have the same origin as the document — unless the [`<audio>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/audio "The HTML <audio> element is used to embed sound content in documents. It may contain one or more audio sources, represented using the src attribute or the <source> element: the browser will choose the most suitable one. It can also be the destination for streamed media, using a MediaStream.") or [`<video>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/video "The HTML Video element (<video>) embeds a media player which supports video playback into the document.") parent element of the `track` element has a [`crossorigin`](https://developer.mozilla.org/en-US/docs/Web/HTML/CORS_settings_attributes) attribute.'}},{name:"srclang",description:{kind:"markdown",value:"Language of the track text data. It must be a valid [BCP 47](https://r12a.github.io/app-subtags/) language tag. If the `kind` attribute is set to `subtitles,` then `srclang` must be defined."}}],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/HTML/Element/track"}]},{name:"map",description:{kind:"markdown",value:"The map element, in conjunction with an img element and any area element descendants, defines an image map. The element represents its children."},attributes:[{name:"name",description:{kind:"markdown",value:"The name attribute gives the map a name so that it can be referenced. The attribute must be present and must have a non-empty value with no space characters. The value of the name attribute must not be a compatibility-caseless match for the value of the name attribute of another map element in the same document. If the id attribute is also specified, both attributes must have the same value."}}],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/HTML/Element/map"}]},{name:"area",description:{kind:"markdown",value:"The area element represents either a hyperlink with some text and a corresponding area on an image map, or a dead area on an image map."},attributes:[{name:"alt"},{name:"coords"},{name:"shape",valueSet:"sh"},{name:"href"},{name:"target"},{name:"download"},{name:"ping"},{name:"rel"},{name:"hreflang"},{name:"type"},{name:"accesskey",description:"Specifies a keyboard navigation accelerator for the element. Pressing ALT or a similar key in association with the specified character selects the form control correlated with that key sequence. Page designers are forewarned to avoid key sequences already bound to browsers. This attribute is global since HTML5."}],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/HTML/Element/area"}]},{name:"table",description:{kind:"markdown",value:"The table element represents data with more than one dimension, in the form of a table."},attributes:[{name:"border"},{name:"align",description:'This enumerated attribute indicates how the table must be aligned inside the containing document. It may have the following values:\n\n*   left: the table is displayed on the left side of the document;\n*   center: the table is displayed in the center of the document;\n*   right: the table is displayed on the right side of the document.\n\n**Usage Note**\n\n*   **Do not use this attribute**, as it has been deprecated. The [`<table>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/table "The HTML <table> element represents tabular data — that is, information presented in a two-dimensional table comprised of rows and columns of cells containing data.") element should be styled using [CSS](https://developer.mozilla.org/en-US/docs/CSS). Set [`margin-left`](https://developer.mozilla.org/en-US/docs/Web/CSS/margin-left "The margin-left CSS property sets the margin area on the left side of an element. A positive value places it farther from its neighbors, while a negative value places it closer.") and [`margin-right`](https://developer.mozilla.org/en-US/docs/Web/CSS/margin-right "The margin-right CSS property sets the margin area on the right side of an element. A positive value places it farther from its neighbors, while a negative value places it closer.") to `auto` or [`margin`](https://developer.mozilla.org/en-US/docs/Web/CSS/margin "The margin CSS property sets the margin area on all four sides of an element. It is a shorthand for margin-top, margin-right, margin-bottom, and margin-left.") to `0 auto` to achieve an effect that is similar to the align attribute.\n*   Prior to Firefox 4, Firefox also supported the `middle`, `absmiddle`, and `abscenter` values as synonyms of `center`, in quirks mode only.'}],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/HTML/Element/table"}]},{name:"caption",description:{kind:"markdown",value:"The caption element represents the title of the table that is its parent, if it has a parent and that is a table element."},attributes:[{name:"align",description:'This enumerated attribute indicates how the caption must be aligned with respect to the table. It may have one of the following values:\n\n`left`\n\nThe caption is displayed to the left of the table.\n\n`top`\n\nThe caption is displayed above the table.\n\n`right`\n\nThe caption is displayed to the right of the table.\n\n`bottom`\n\nThe caption is displayed below the table.\n\n**Usage note:** Do not use this attribute, as it has been deprecated. The [`<caption>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/caption "The HTML Table Caption element (<caption>) specifies the caption (or title) of a table, and if used is always the first child of a <table>.") element should be styled using the [CSS](https://developer.mozilla.org/en-US/docs/CSS) properties [`caption-side`](https://developer.mozilla.org/en-US/docs/Web/CSS/caption-side "The caption-side CSS property puts the content of a table\'s <caption> on the specified side. The values are relative to the writing-mode of the table.") and [`text-align`](https://developer.mozilla.org/en-US/docs/Web/CSS/text-align "The text-align CSS property sets the horizontal alignment of an inline or table-cell box. This means it works like vertical-align but in the horizontal direction.").'}],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/HTML/Element/caption"}]},{name:"colgroup",description:{kind:"markdown",value:"The colgroup element represents a group of one or more columns in the table that is its parent, if it has a parent and that is a table element."},attributes:[{name:"span"},{name:"align",description:'This enumerated attribute specifies how horizontal alignment of each column cell content will be handled. Possible values are:\n\n*   `left`, aligning the content to the left of the cell\n*   `center`, centering the content in the cell\n*   `right`, aligning the content to the right of the cell\n*   `justify`, inserting spaces into the textual content so that the content is justified in the cell\n*   `char`, aligning the textual content on a special character with a minimal offset, defined by the [`char`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/col#attr-char) and [`charoff`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/col#attr-charoff) attributes Unimplemented (see [bug 2212](https://bugzilla.mozilla.org/show_bug.cgi?id=2212 "character alignment not implemented (align=char, charoff=, text-align:<string>)")).\n\nIf this attribute is not set, the `left` value is assumed. The descendant [`<col>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/col "The HTML <col> element defines a column within a table and is used for defining common semantics on all common cells. It is generally found within a <colgroup> element.") elements may override this value using their own [`align`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/col#attr-align) attribute.\n\n**Note:** Do not use this attribute as it is obsolete (not supported) in the latest standard.\n\n*   To achieve the same effect as the `left`, `center`, `right` or `justify` values:\n    *   Do not try to set the [`text-align`](https://developer.mozilla.org/en-US/docs/Web/CSS/text-align "The text-align CSS property sets the horizontal alignment of an inline or table-cell box. This means it works like vertical-align but in the horizontal direction.") property on a selector giving a [`<colgroup>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/colgroup "The HTML <colgroup> element defines a group of columns within a table.") element. Because [`<td>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/td "The HTML <td> element defines a cell of a table that contains data. It participates in the table model.") elements are not descendant of the [`<colgroup>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/colgroup "The HTML <colgroup> element defines a group of columns within a table.") element, they won\'t inherit it.\n    *   If the table doesn\'t use a [`colspan`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/td#attr-colspan) attribute, use one `td:nth-child(an+b)` CSS selector per column, where a is the total number of the columns in the table and b is the ordinal position of this column in the table. Only after this selector the [`text-align`](https://developer.mozilla.org/en-US/docs/Web/CSS/text-align "The text-align CSS property sets the horizontal alignment of an inline or table-cell box. This means it works like vertical-align but in the horizontal direction.") property can be used.\n    *   If the table does use a [`colspan`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/td#attr-colspan) attribute, the effect can be achieved by combining adequate CSS attribute selectors like `[colspan=n]`, though this is not trivial.\n*   To achieve the same effect as the `char` value, in CSS3, you can use the value of the [`char`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/colgroup#attr-char) as the value of the [`text-align`](https://developer.mozilla.org/en-US/docs/Web/CSS/text-align "The text-align CSS property sets the horizontal alignment of an inline or table-cell box. This means it works like vertical-align but in the horizontal direction.") property Unimplemented.'}],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/HTML/Element/colgroup"}]},{name:"col",description:{kind:"markdown",value:"If a col element has a parent and that is a colgroup element that itself has a parent that is a table element, then the col element represents one or more columns in the column group represented by that colgroup."},attributes:[{name:"span"},{name:"align",description:'This enumerated attribute specifies how horizontal alignment of each column cell content will be handled. Possible values are:\n\n*   `left`, aligning the content to the left of the cell\n*   `center`, centering the content in the cell\n*   `right`, aligning the content to the right of the cell\n*   `justify`, inserting spaces into the textual content so that the content is justified in the cell\n*   `char`, aligning the textual content on a special character with a minimal offset, defined by the [`char`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/col#attr-char) and [`charoff`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/col#attr-charoff) attributes Unimplemented (see [bug 2212](https://bugzilla.mozilla.org/show_bug.cgi?id=2212 "character alignment not implemented (align=char, charoff=, text-align:<string>)")).\n\nIf this attribute is not set, its value is inherited from the [`align`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/colgroup#attr-align) of the [`<colgroup>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/colgroup "The HTML <colgroup> element defines a group of columns within a table.") element this `<col>` element belongs too. If there are none, the `left` value is assumed.\n\n**Note:** Do not use this attribute as it is obsolete (not supported) in the latest standard.\n\n*   To achieve the same effect as the `left`, `center`, `right` or `justify` values:\n    *   Do not try to set the [`text-align`](https://developer.mozilla.org/en-US/docs/Web/CSS/text-align "The text-align CSS property sets the horizontal alignment of an inline or table-cell box. This means it works like vertical-align but in the horizontal direction.") property on a selector giving a [`<col>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/col "The HTML <col> element defines a column within a table and is used for defining common semantics on all common cells. It is generally found within a <colgroup> element.") element. Because [`<td>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/td "The HTML <td> element defines a cell of a table that contains data. It participates in the table model.") elements are not descendant of the [`<col>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/col "The HTML <col> element defines a column within a table and is used for defining common semantics on all common cells. It is generally found within a <colgroup> element.") element, they won\'t inherit it.\n    *   If the table doesn\'t use a [`colspan`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/td#attr-colspan) attribute, use the `td:nth-child(an+b)` CSS selector. Set `a` to zero and `b` to the position of the column in the table, e.g. `td:nth-child(2) { text-align: right; }` to right-align the second column.\n    *   If the table does use a [`colspan`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/td#attr-colspan) attribute, the effect can be achieved by combining adequate CSS attribute selectors like `[colspan=n]`, though this is not trivial.\n*   To achieve the same effect as the `char` value, in CSS3, you can use the value of the [`char`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/col#attr-char) as the value of the [`text-align`](https://developer.mozilla.org/en-US/docs/Web/CSS/text-align "The text-align CSS property sets the horizontal alignment of an inline or table-cell box. This means it works like vertical-align but in the horizontal direction.") property Unimplemented.'}],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/HTML/Element/col"}]},{name:"tbody",description:{kind:"markdown",value:"The tbody element represents a block of rows that consist of a body of data for the parent table element, if the tbody element has a parent and it is a table."},attributes:[{name:"align",description:'This enumerated attribute specifies how horizontal alignment of each cell content will be handled. Possible values are:\n\n*   `left`, aligning the content to the left of the cell\n*   `center`, centering the content in the cell\n*   `right`, aligning the content to the right of the cell\n*   `justify`, inserting spaces into the textual content so that the content is justified in the cell\n*   `char`, aligning the textual content on a special character with a minimal offset, defined by the [`char`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/tbody#attr-char) and [`charoff`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/tbody#attr-charoff) attributes.\n\nIf this attribute is not set, the `left` value is assumed.\n\n**Note:** Do not use this attribute as it is obsolete (not supported) in the latest standard.\n\n*   To achieve the same effect as the `left`, `center`, `right` or `justify` values, use the CSS [`text-align`](https://developer.mozilla.org/en-US/docs/Web/CSS/text-align "The text-align CSS property sets the horizontal alignment of an inline or table-cell box. This means it works like vertical-align but in the horizontal direction.") property on it.\n*   To achieve the same effect as the `char` value, in CSS3, you can use the value of the [`char`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/tbody#attr-char) as the value of the [`text-align`](https://developer.mozilla.org/en-US/docs/Web/CSS/text-align "The text-align CSS property sets the horizontal alignment of an inline or table-cell box. This means it works like vertical-align but in the horizontal direction.") property Unimplemented.'}],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/HTML/Element/tbody"}]},{name:"thead",description:{kind:"markdown",value:"The thead element represents the block of rows that consist of the column labels (headers) for the parent table element, if the thead element has a parent and it is a table."},attributes:[{name:"align",description:'This enumerated attribute specifies how horizontal alignment of each cell content will be handled. Possible values are:\n\n*   `left`, aligning the content to the left of the cell\n*   `center`, centering the content in the cell\n*   `right`, aligning the content to the right of the cell\n*   `justify`, inserting spaces into the textual content so that the content is justified in the cell\n*   `char`, aligning the textual content on a special character with a minimal offset, defined by the [`char`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/thead#attr-char) and [`charoff`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/thead#attr-charoff) attributes Unimplemented (see [bug 2212](https://bugzilla.mozilla.org/show_bug.cgi?id=2212 "character alignment not implemented (align=char, charoff=, text-align:<string>)")).\n\nIf this attribute is not set, the `left` value is assumed.\n\n**Note:** Do not use this attribute as it is obsolete (not supported) in the latest standard.\n\n*   To achieve the same effect as the `left`, `center`, `right` or `justify` values, use the CSS [`text-align`](https://developer.mozilla.org/en-US/docs/Web/CSS/text-align "The text-align CSS property sets the horizontal alignment of an inline or table-cell box. This means it works like vertical-align but in the horizontal direction.") property on it.\n*   To achieve the same effect as the `char` value, in CSS3, you can use the value of the [`char`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/thead#attr-char) as the value of the [`text-align`](https://developer.mozilla.org/en-US/docs/Web/CSS/text-align "The text-align CSS property sets the horizontal alignment of an inline or table-cell box. This means it works like vertical-align but in the horizontal direction.") property Unimplemented.'}],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/HTML/Element/thead"}]},{name:"tfoot",description:{kind:"markdown",value:"The tfoot element represents the block of rows that consist of the column summaries (footers) for the parent table element, if the tfoot element has a parent and it is a table."},attributes:[{name:"align",description:'This enumerated attribute specifies how horizontal alignment of each cell content will be handled. Possible values are:\n\n*   `left`, aligning the content to the left of the cell\n*   `center`, centering the content in the cell\n*   `right`, aligning the content to the right of the cell\n*   `justify`, inserting spaces into the textual content so that the content is justified in the cell\n*   `char`, aligning the textual content on a special character with a minimal offset, defined by the [`char`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/tbody#attr-char) and [`charoff`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/tbody#attr-charoff) attributes Unimplemented (see [bug 2212](https://bugzilla.mozilla.org/show_bug.cgi?id=2212 "character alignment not implemented (align=char, charoff=, text-align:<string>)")).\n\nIf this attribute is not set, the `left` value is assumed.\n\n**Note:** Do not use this attribute as it is obsolete (not supported) in the latest standard.\n\n*   To achieve the same effect as the `left`, `center`, `right` or `justify` values, use the CSS [`text-align`](https://developer.mozilla.org/en-US/docs/Web/CSS/text-align "The text-align CSS property sets the horizontal alignment of an inline or table-cell box. This means it works like vertical-align but in the horizontal direction.") property on it.\n*   To achieve the same effect as the `char` value, in CSS3, you can use the value of the [`char`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/tfoot#attr-char) as the value of the [`text-align`](https://developer.mozilla.org/en-US/docs/Web/CSS/text-align "The text-align CSS property sets the horizontal alignment of an inline or table-cell box. This means it works like vertical-align but in the horizontal direction.") property Unimplemented.'}],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/HTML/Element/tfoot"}]},{name:"tr",description:{kind:"markdown",value:"The tr element represents a row of cells in a table."},attributes:[{name:"align",description:'A [`DOMString`](https://developer.mozilla.org/en-US/docs/Web/API/DOMString "DOMString is a UTF-16 String. As JavaScript already uses such strings, DOMString is mapped directly to a String.") which specifies how the cell\'s context should be aligned horizontally within the cells in the row; this is shorthand for using `align` on every cell in the row individually. Possible values are:\n\n`left`\n\nAlign the content of each cell at its left edge.\n\n`center`\n\nCenter the contents of each cell between their left and right edges.\n\n`right`\n\nAlign the content of each cell at its right edge.\n\n`justify`\n\nWiden whitespaces within the text of each cell so that the text fills the full width of each cell (full justification).\n\n`char`\n\nAlign each cell in the row on a specific character (such that each row in the column that is configured this way will horizontally align its cells on that character). This uses the [`char`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/tr#attr-char) and [`charoff`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/tr#attr-charoff) to establish the alignment character (typically "." or "," when aligning numerical data) and the number of characters that should follow the alignment character. This alignment type was never widely supported.\n\nIf no value is expressly set for `align`, the parent node\'s value is inherited.\n\nInstead of using the obsolete `align` attribute, you should instead use the CSS [`text-align`](https://developer.mozilla.org/en-US/docs/Web/CSS/text-align "The text-align CSS property sets the horizontal alignment of an inline or table-cell box. This means it works like vertical-align but in the horizontal direction.") property to establish `left`, `center`, `right`, or `justify` alignment for the row\'s cells. To apply character-based alignment, set the CSS [`text-align`](https://developer.mozilla.org/en-US/docs/Web/CSS/text-align "The text-align CSS property sets the horizontal alignment of an inline or table-cell box. This means it works like vertical-align but in the horizontal direction.") property to the alignment character (such as `"."` or `","`).'}],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/HTML/Element/tr"}]},{name:"td",description:{kind:"markdown",value:"The td element represents a data cell in a table."},attributes:[{name:"colspan"},{name:"rowspan"},{name:"headers"},{name:"abbr",description:"This attribute contains a short abbreviated description of the cell's content. Some user-agents, such as speech readers, may present this description before the content itself.\n\n**Note:** Do not use this attribute as it is obsolete in the latest standard. Alternatively, you can put the abbreviated description inside the cell and place the long content in the **title** attribute."},{name:"align",description:'This enumerated attribute specifies how the cell content\'s horizontal alignment will be handled. Possible values are:\n\n*   `left`: The content is aligned to the left of the cell.\n*   `center`: The content is centered in the cell.\n*   `right`: The content is aligned to the right of the cell.\n*   `justify` (with text only): The content is stretched out inside the cell so that it covers its entire width.\n*   `char` (with text only): The content is aligned to a character inside the `<th>` element with minimal offset. This character is defined by the [`char`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/td#attr-char) and [`charoff`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/td#attr-charoff) attributes Unimplemented (see [bug 2212](https://bugzilla.mozilla.org/show_bug.cgi?id=2212 "character alignment not implemented (align=char, charoff=, text-align:<string>)")).\n\nThe default value when this attribute is not specified is `left`.\n\n**Note:** Do not use this attribute as it is obsolete in the latest standard.\n\n*   To achieve the same effect as the `left`, `center`, `right` or `justify` values, apply the CSS [`text-align`](https://developer.mozilla.org/en-US/docs/Web/CSS/text-align "The text-align CSS property sets the horizontal alignment of an inline or table-cell box. This means it works like vertical-align but in the horizontal direction.") property to the element.\n*   To achieve the same effect as the `char` value, give the [`text-align`](https://developer.mozilla.org/en-US/docs/Web/CSS/text-align "The text-align CSS property sets the horizontal alignment of an inline or table-cell box. This means it works like vertical-align but in the horizontal direction.") property the same value you would use for the [`char`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/td#attr-char). Unimplemented in CSS3.'},{name:"axis",description:"This attribute contains a list of space-separated strings. Each string is the `id` of a group of cells that this header applies to.\n\n**Note:** Do not use this attribute as it is obsolete in the latest standard."},{name:"bgcolor",description:'This attribute defines the background color of each cell in a column. It consists of a 6-digit hexadecimal code as defined in [sRGB](https://www.w3.org/Graphics/Color/sRGB) and is prefixed by \'#\'. This attribute may be used with one of sixteen predefined color strings:\n\n \n\n`black` = "#000000"\n\n \n\n`green` = "#008000"\n\n \n\n`silver` = "#C0C0C0"\n\n \n\n`lime` = "#00FF00"\n\n \n\n`gray` = "#808080"\n\n \n\n`olive` = "#808000"\n\n \n\n`white` = "#FFFFFF"\n\n \n\n`yellow` = "#FFFF00"\n\n \n\n`maroon` = "#800000"\n\n \n\n`navy` = "#000080"\n\n \n\n`red` = "#FF0000"\n\n \n\n`blue` = "#0000FF"\n\n \n\n`purple` = "#800080"\n\n \n\n`teal` = "#008080"\n\n \n\n`fuchsia` = "#FF00FF"\n\n \n\n`aqua` = "#00FFFF"\n\n**Note:** Do not use this attribute, as it is non-standard and only implemented in some versions of Microsoft Internet Explorer: The [`<td>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/td "The HTML <td> element defines a cell of a table that contains data. It participates in the table model.") element should be styled using [CSS](https://developer.mozilla.org/en-US/docs/CSS). To create a similar effect use the [`background-color`](https://developer.mozilla.org/en-US/docs/Web/CSS/background-color "The background-color CSS property sets the background color of an element.") property in [CSS](https://developer.mozilla.org/en-US/docs/CSS) instead.'}],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/HTML/Element/td"}]},{name:"th",description:{kind:"markdown",value:"The th element represents a header cell in a table."},attributes:[{name:"colspan"},{name:"rowspan"},{name:"headers"},{name:"scope",valueSet:"s"},{name:"sorted"},{name:"abbr",description:{kind:"markdown",value:"This attribute contains a short abbreviated description of the cell's content. Some user-agents, such as speech readers, may present this description before the content itself."}},{name:"align",description:'This enumerated attribute specifies how the cell content\'s horizontal alignment will be handled. Possible values are:\n\n*   `left`: The content is aligned to the left of the cell.\n*   `center`: The content is centered in the cell.\n*   `right`: The content is aligned to the right of the cell.\n*   `justify` (with text only): The content is stretched out inside the cell so that it covers its entire width.\n*   `char` (with text only): The content is aligned to a character inside the `<th>` element with minimal offset. This character is defined by the [`char`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/th#attr-char) and [`charoff`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/th#attr-charoff) attributes.\n\nThe default value when this attribute is not specified is `left`.\n\n**Note:** Do not use this attribute as it is obsolete in the latest standard.\n\n*   To achieve the same effect as the `left`, `center`, `right` or `justify` values, apply the CSS [`text-align`](https://developer.mozilla.org/en-US/docs/Web/CSS/text-align "The text-align CSS property sets the horizontal alignment of an inline or table-cell box. This means it works like vertical-align but in the horizontal direction.") property to the element.\n*   To achieve the same effect as the `char` value, give the [`text-align`](https://developer.mozilla.org/en-US/docs/Web/CSS/text-align "The text-align CSS property sets the horizontal alignment of an inline or table-cell box. This means it works like vertical-align but in the horizontal direction.") property the same value you would use for the [`char`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/th#attr-char). Unimplemented in CSS3.'},{name:"axis",description:"This attribute contains a list of space-separated strings. Each string is the `id` of a group of cells that this header applies to.\n\n**Note:** Do not use this attribute as it is obsolete in the latest standard: use the [`scope`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/th#attr-scope) attribute instead."},{name:"bgcolor",description:'This attribute defines the background color of each cell in a column. It consists of a 6-digit hexadecimal code as defined in [sRGB](https://www.w3.org/Graphics/Color/sRGB) and is prefixed by \'#\'. This attribute may be used with one of sixteen predefined color strings:\n\n \n\n`black` = "#000000"\n\n \n\n`green` = "#008000"\n\n \n\n`silver` = "#C0C0C0"\n\n \n\n`lime` = "#00FF00"\n\n \n\n`gray` = "#808080"\n\n \n\n`olive` = "#808000"\n\n \n\n`white` = "#FFFFFF"\n\n \n\n`yellow` = "#FFFF00"\n\n \n\n`maroon` = "#800000"\n\n \n\n`navy` = "#000080"\n\n \n\n`red` = "#FF0000"\n\n \n\n`blue` = "#0000FF"\n\n \n\n`purple` = "#800080"\n\n \n\n`teal` = "#008080"\n\n \n\n`fuchsia` = "#FF00FF"\n\n \n\n`aqua` = "#00FFFF"\n\n**Note:** Do not use this attribute, as it is non-standard and only implemented in some versions of Microsoft Internet Explorer: The [`<th>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/th "The HTML <th> element defines a cell as header of a group of table cells. The exact nature of this group is defined by the scope and headers attributes.") element should be styled using [CSS](https://developer.mozilla.org/en-US/docs/Web/CSS). To create a similar effect use the [`background-color`](https://developer.mozilla.org/en-US/docs/Web/CSS/background-color "The background-color CSS property sets the background color of an element.") property in [CSS](https://developer.mozilla.org/en-US/docs/Web/CSS) instead.'}],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/HTML/Element/th"}]},{name:"form",description:{kind:"markdown",value:"The form element represents a collection of form-associated elements, some of which can represent editable values that can be submitted to a server for processing."},attributes:[{name:"accept-charset",description:{kind:"markdown",value:'A space- or comma-delimited list of character encodings that the server accepts. The browser uses them in the order in which they are listed. The default value, the reserved string `"UNKNOWN"`, indicates the same encoding as that of the document containing the form element.  \nIn previous versions of HTML, the different character encodings could be delimited by spaces or commas. In HTML5, only spaces are allowed as delimiters.'}},{name:"action",description:{kind:"markdown",value:'The URI of a program that processes the form information. This value can be overridden by a [`formaction`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/button#attr-formaction) attribute on a [`<button>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/button "The HTML <button> element represents a clickable button, which can be used in forms or anywhere in a document that needs simple, standard button functionality.") or [`<input>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/input "The HTML <input> element is used to create interactive controls for web-based forms in order to accept data from the user; a wide variety of types of input data and control widgets are available, depending on the device and user agent.") element.'}},{name:"autocomplete",valueSet:"o",description:{kind:"markdown",value:"Indicates whether input elements can by default have their values automatically completed by the browser. This setting can be overridden by an `autocomplete` attribute on an element belonging to the form. Possible values are:\n\n*   `off`: The user must explicitly enter a value into each field for every use, or the document provides its own auto-completion method; the browser does not automatically complete entries.\n*   `on`: The browser can automatically complete values based on values that the user has previously entered in the form.\n\nFor most modern browsers (including Firefox 38+, Google Chrome 34+, IE 11+) setting the autocomplete attribute will not prevent a browser's password manager from asking the user if they want to store login fields (username and password), if the user permits the storage the browser will autofill the login the next time the user visits the page. See [The autocomplete attribute and login fields](https://developer.mozilla.org/en-US/docs/Web/Security/Securing_your_site/Turning_off_form_autocompletion#The_autocomplete_attribute_and_login_fields)."}},{name:"enctype",valueSet:"et",description:{kind:"markdown",value:'When the value of the `method` attribute is `post`, enctype is the [MIME type](https://en.wikipedia.org/wiki/Mime_type) of content that is used to submit the form to the server. Possible values are:\n\n*   `application/x-www-form-urlencoded`: The default value if the attribute is not specified.\n*   `multipart/form-data`: The value used for an [`<input>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/input "The HTML <input> element is used to create interactive controls for web-based forms in order to accept data from the user; a wide variety of types of input data and control widgets are available, depending on the device and user agent.") element with the `type` attribute set to "file".\n*   `text/plain`: (HTML5)\n\nThis value can be overridden by a [`formenctype`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/button#attr-formenctype) attribute on a [`<button>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/button "The HTML <button> element represents a clickable button, which can be used in forms or anywhere in a document that needs simple, standard button functionality.") or [`<input>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/input "The HTML <input> element is used to create interactive controls for web-based forms in order to accept data from the user; a wide variety of types of input data and control widgets are available, depending on the device and user agent.") element.'}},{name:"method",valueSet:"m",description:{kind:"markdown",value:'The [HTTP](https://developer.mozilla.org/en-US/docs/Web/HTTP) method that the browser uses to submit the form. Possible values are:\n\n*   `post`: Corresponds to the HTTP [POST method](https://www.w3.org/Protocols/rfc2616/rfc2616-sec9.html#sec9.5) ; form data are included in the body of the form and sent to the server.\n*   `get`: Corresponds to the HTTP [GET method](https://www.w3.org/Protocols/rfc2616/rfc2616-sec9.html#sec9.3); form data are appended to the `action` attribute URI with a \'?\' as separator, and the resulting URI is sent to the server. Use this method when the form has no side-effects and contains only ASCII characters.\n*   `dialog`: Use when the form is inside a [`<dialog>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/dialog "The HTML <dialog> element represents a dialog box or other interactive component, such as an inspector or window.") element to close the dialog when submitted.\n\nThis value can be overridden by a [`formmethod`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/button#attr-formmethod) attribute on a [`<button>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/button "The HTML <button> element represents a clickable button, which can be used in forms or anywhere in a document that needs simple, standard button functionality.") or [`<input>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/input "The HTML <input> element is used to create interactive controls for web-based forms in order to accept data from the user; a wide variety of types of input data and control widgets are available, depending on the device and user agent.") element.'}},{name:"name",description:{kind:"markdown",value:"The name of the form. In HTML 4, its use is deprecated (`id` should be used instead). It must be unique among the forms in a document and not just an empty string in HTML 5."}},{name:"novalidate",valueSet:"v",description:{kind:"markdown",value:'This Boolean attribute indicates that the form is not to be validated when submitted. If this attribute is not specified (and therefore the form is validated), this default setting can be overridden by a [`formnovalidate`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/button#attr-formnovalidate) attribute on a [`<button>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/button "The HTML <button> element represents a clickable button, which can be used in forms or anywhere in a document that needs simple, standard button functionality.") or [`<input>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/input "The HTML <input> element is used to create interactive controls for web-based forms in order to accept data from the user; a wide variety of types of input data and control widgets are available, depending on the device and user agent.") element belonging to the form.'}},{name:"target",description:{kind:"markdown",value:'A name or keyword indicating where to display the response that is received after submitting the form. In HTML 4, this is the name/keyword for a frame. In HTML5, it is a name/keyword for a _browsing context_ (for example, tab, window, or inline frame). The following keywords have special meanings:\n\n*   `_self`: Load the response into the same HTML 4 frame (or HTML5 browsing context) as the current one. This value is the default if the attribute is not specified.\n*   `_blank`: Load the response into a new unnamed HTML 4 window or HTML5 browsing context.\n*   `_parent`: Load the response into the HTML 4 frameset parent of the current frame, or HTML5 parent browsing context of the current one. If there is no parent, this option behaves the same way as `_self`.\n*   `_top`: HTML 4: Load the response into the full original window, and cancel all other frames. HTML5: Load the response into the top-level browsing context (i.e., the browsing context that is an ancestor of the current one, and has no parent). If there is no parent, this option behaves the same way as `_self`.\n*   _iframename_: The response is displayed in a named [`<iframe>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/iframe "The HTML Inline Frame element (<iframe>) represents a nested browsing context, embedding another HTML page into the current one.").\n\nHTML5: This value can be overridden by a [`formtarget`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/button#attr-formtarget) attribute on a [`<button>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/button "The HTML <button> element represents a clickable button, which can be used in forms or anywhere in a document that needs simple, standard button functionality.") or [`<input>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/input "The HTML <input> element is used to create interactive controls for web-based forms in order to accept data from the user; a wide variety of types of input data and control widgets are available, depending on the device and user agent.") element.'}},{name:"accept",description:'A comma-separated list of content types that the server accepts.\n\n**Usage note:** This attribute has been removed in HTML5 and should no longer be used. Instead, use the [`accept`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/input#attr-accept) attribute of the specific [`<input>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/input "The HTML <input> element is used to create interactive controls for web-based forms in order to accept data from the user; a wide variety of types of input data and control widgets are available, depending on the device and user agent.") element.'},{name:"autocapitalize",description:"This is a nonstandard attribute used by iOS Safari Mobile which controls whether and how the text value for textual form control descendants should be automatically capitalized as it is entered/edited by the user. If the `autocapitalize` attribute is specified on an individual form control descendant, it trumps the form-wide `autocapitalize` setting. The non-deprecated values are available in iOS 5 and later. The default value is `sentences`. Possible values are:\n\n*   `none`: Completely disables automatic capitalization\n*   `sentences`: Automatically capitalize the first letter of sentences.\n*   `words`: Automatically capitalize the first letter of words.\n*   `characters`: Automatically capitalize all characters.\n*   `on`: Deprecated since iOS 5.\n*   `off`: Deprecated since iOS 5."}],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/HTML/Element/form"}]},{name:"label",description:{kind:"markdown",value:"The label element represents a caption in a user interface. The caption can be associated with a specific form control, known as the label element's labeled control, either using the for attribute, or by putting the form control inside the label element itself."},attributes:[{name:"form",description:{kind:"markdown",value:'The [`<form>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/form "The HTML <form> element represents a document section that contains interactive controls for submitting information to a web server.") element with which the label is associated (its _form owner_). If specified, the value of the attribute is the `id` of a [`<form>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/form "The HTML <form> element represents a document section that contains interactive controls for submitting information to a web server.") element in the same document. This lets you place label elements anywhere within a document, not just as descendants of their form elements.'}},{name:"for",description:{kind:"markdown",value:"The [`id`](https://developer.mozilla.org/en-US/docs/Web/HTML/Global_attributes#attr-id) of a [labelable](https://developer.mozilla.org/en-US/docs/Web/Guide/HTML/Content_categories#Form_labelable) form-related element in the same document as the `<label>` element. The first element in the document with an `id` matching the value of the `for` attribute is the _labeled control_ for this label element, if it is a labelable element. If it is not labelable then the `for` attribute has no effect. If there are other elements which also match the `id` value, later in the document, they are not considered.\n\n**Note**: A `<label>` element can have both a `for` attribute and a contained control element, as long as the `for` attribute points to the contained control element."}}],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/HTML/Element/label"}]},{name:"input",description:{kind:"markdown",value:"The input element represents a typed data field, usually with a form control to allow the user to edit the data."},attributes:[{name:"accept"},{name:"alt"},{name:"autocomplete",valueSet:"inputautocomplete"},{name:"autofocus",valueSet:"v"},{name:"checked",valueSet:"v"},{name:"dirname"},{name:"disabled",valueSet:"v"},{name:"form"},{name:"formaction"},{name:"formenctype",valueSet:"et"},{name:"formmethod",valueSet:"fm"},{name:"formnovalidate",valueSet:"v"},{name:"formtarget"},{name:"height"},{name:"inputmode",valueSet:"im"},{name:"list"},{name:"max"},{name:"maxlength"},{name:"min"},{name:"minlength"},{name:"multiple",valueSet:"v"},{name:"name"},{name:"pattern"},{name:"placeholder"},{name:"readonly",valueSet:"v"},{name:"required",valueSet:"v"},{name:"size"},{name:"src"},{name:"step"},{name:"type",valueSet:"t"},{name:"value"},{name:"width"}],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/HTML/Element/input"}]},{name:"button",description:{kind:"markdown",value:"The button element represents a button labeled by its contents."},attributes:[{name:"autofocus",valueSet:"v",description:{kind:"markdown",value:"This Boolean attribute lets you specify that the button should have input focus when the page loads, unless the user overrides it, for example by typing in a different control. Only one form-associated element in a document can have this attribute specified."}},{name:"disabled",valueSet:"v",description:{kind:"markdown",value:'This Boolean attribute indicates that the user cannot interact with the button. If this attribute is not specified, the button inherits its setting from the containing element, for example [`<fieldset>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/fieldset "The HTML <fieldset> element is used to group several controls as well as labels (<label>) within a web form."); if there is no containing element with the **disabled** attribute set, then the button is enabled.\n\nFirefox will, unlike other browsers, by default, [persist the dynamic disabled state](https://stackoverflow.com/questions/5985839/bug-with-firefox-disabled-attribute-of-input-not-resetting-when-refreshing) of a [`<button>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/button "The HTML <button> element represents a clickable button, which can be used in forms or anywhere in a document that needs simple, standard button functionality.") across page loads. Use the [`autocomplete`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/button#attr-autocomplete) attribute to control this feature.'}},{name:"form",description:{kind:"markdown",value:'The form element that the button is associated with (its _form owner_). The value of the attribute must be the **id** attribute of a [`<form>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/form "The HTML <form> element represents a document section that contains interactive controls for submitting information to a web server.") element in the same document. If this attribute is not specified, the `<button>` element will be associated to an ancestor [`<form>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/form "The HTML <form> element represents a document section that contains interactive controls for submitting information to a web server.") element, if one exists. This attribute enables you to associate `<button>` elements to [`<form>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/form "The HTML <form> element represents a document section that contains interactive controls for submitting information to a web server.") elements anywhere within a document, not just as descendants of [`<form>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/form "The HTML <form> element represents a document section that contains interactive controls for submitting information to a web server.") elements.'}},{name:"formaction",description:{kind:"markdown",value:"The URI of a program that processes the information submitted by the button. If specified, it overrides the [`action`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/form#attr-action) attribute of the button's form owner."}},{name:"formenctype",valueSet:"et",description:{kind:"markdown",value:'If the button is a submit button, this attribute specifies the type of content that is used to submit the form to the server. Possible values are:\n\n*   `application/x-www-form-urlencoded`: The default value if the attribute is not specified.\n*   `multipart/form-data`: Use this value if you are using an [`<input>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/input "The HTML <input> element is used to create interactive controls for web-based forms in order to accept data from the user; a wide variety of types of input data and control widgets are available, depending on the device and user agent.") element with the [`type`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/input#attr-type) attribute set to `file`.\n*   `text/plain`\n\nIf this attribute is specified, it overrides the [`enctype`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/form#attr-enctype) attribute of the button\'s form owner.'}},{name:"formmethod",valueSet:"fm",description:{kind:"markdown",value:"If the button is a submit button, this attribute specifies the HTTP method that the browser uses to submit the form. Possible values are:\n\n*   `post`: The data from the form are included in the body of the form and sent to the server.\n*   `get`: The data from the form are appended to the **form** attribute URI, with a '?' as a separator, and the resulting URI is sent to the server. Use this method when the form has no side-effects and contains only ASCII characters.\n\nIf specified, this attribute overrides the [`method`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/form#attr-method) attribute of the button's form owner."}},{name:"formnovalidate",valueSet:"v",description:{kind:"markdown",value:"If the button is a submit button, this Boolean attribute specifies that the form is not to be validated when it is submitted. If this attribute is specified, it overrides the [`novalidate`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/form#attr-novalidate) attribute of the button's form owner."}},{name:"formtarget",description:{kind:"markdown",value:"If the button is a submit button, this attribute is a name or keyword indicating where to display the response that is received after submitting the form. This is a name of, or keyword for, a _browsing context_ (for example, tab, window, or inline frame). If this attribute is specified, it overrides the [`target`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/form#attr-target) attribute of the button's form owner. The following keywords have special meanings:\n\n*   `_self`: Load the response into the same browsing context as the current one. This value is the default if the attribute is not specified.\n*   `_blank`: Load the response into a new unnamed browsing context.\n*   `_parent`: Load the response into the parent browsing context of the current one. If there is no parent, this option behaves the same way as `_self`.\n*   `_top`: Load the response into the top-level browsing context (that is, the browsing context that is an ancestor of the current one, and has no parent). If there is no parent, this option behaves the same way as `_self`."}},{name:"name",description:{kind:"markdown",value:"The name of the button, which is submitted with the form data."}},{name:"type",valueSet:"bt",description:{kind:"markdown",value:"The type of the button. Possible values are:\n\n*   `submit`: The button submits the form data to the server. This is the default if the attribute is not specified, or if the attribute is dynamically changed to an empty or invalid value.\n*   `reset`: The button resets all the controls to their initial values.\n*   `button`: The button has no default behavior. It can have client-side scripts associated with the element's events, which are triggered when the events occur."}},{name:"value",description:{kind:"markdown",value:"The initial value of the button. It defines the value associated with the button which is submitted with the form data. This value is passed to the server in params when the form is submitted."}},{name:"autocomplete",description:'The use of this attribute on a [`<button>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/button "The HTML <button> element represents a clickable button, which can be used in forms or anywhere in a document that needs simple, standard button functionality.") is nonstandard and Firefox-specific. By default, unlike other browsers, [Firefox persists the dynamic disabled state](https://stackoverflow.com/questions/5985839/bug-with-firefox-disabled-attribute-of-input-not-resetting-when-refreshing) of a [`<button>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/button "The HTML <button> element represents a clickable button, which can be used in forms or anywhere in a document that needs simple, standard button functionality.") across page loads. Setting the value of this attribute to `off` (i.e. `autocomplete="off"`) disables this feature. See [bug 654072](https://bugzilla.mozilla.org/show_bug.cgi?id=654072 "if disabled state is changed with javascript, the normal state doesn\'t return after refreshing the page").'}],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/HTML/Element/button"}]},{name:"select",description:{kind:"markdown",value:"The select element represents a control for selecting amongst a set of options."},attributes:[{name:"autocomplete",valueSet:"inputautocomplete",description:{kind:"markdown",value:'A [`DOMString`](https://developer.mozilla.org/en-US/docs/Web/API/DOMString "DOMString is a UTF-16 String. As JavaScript already uses such strings, DOMString is mapped directly to a String.") providing a hint for a [user agent\'s](https://developer.mozilla.org/en-US/docs/Glossary/user_agent "user agent\'s: A user agent is a computer program representing a person, for example, a browser in a Web context.") autocomplete feature. See [The HTML autocomplete attribute](https://developer.mozilla.org/en-US/docs/Web/HTML/Attributes/autocomplete) for a complete list of values and details on how to use autocomplete.'}},{name:"autofocus",valueSet:"v",description:{kind:"markdown",value:"This Boolean attribute lets you specify that a form control should have input focus when the page loads. Only one form element in a document can have the `autofocus` attribute."}},{name:"disabled",valueSet:"v",description:{kind:"markdown",value:"This Boolean attribute indicates that the user cannot interact with the control. If this attribute is not specified, the control inherits its setting from the containing element, for example `fieldset`; if there is no containing element with the `disabled` attribute set, then the control is enabled."}},{name:"form",description:{kind:"markdown",value:'This attribute lets you specify the form element to which the select element is associated (that is, its "form owner"). If this attribute is specified, its value must be the same as the `id` of a form element in the same document. This enables you to place select elements anywhere within a document, not just as descendants of their form elements.'}},{name:"multiple",valueSet:"v",description:{kind:"markdown",value:"This Boolean attribute indicates that multiple options can be selected in the list. If it is not specified, then only one option can be selected at a time. When `multiple` is specified, most browsers will show a scrolling list box instead of a single line dropdown."}},{name:"name",description:{kind:"markdown",value:"This attribute is used to specify the name of the control."}},{name:"required",valueSet:"v",description:{kind:"markdown",value:"A Boolean attribute indicating that an option with a non-empty string value must be selected."}},{name:"size",description:{kind:"markdown",value:"If the control is presented as a scrolling list box (e.g. when `multiple` is specified), this attribute represents the number of rows in the list that should be visible at one time. Browsers are not required to present a select element as a scrolled list box. The default value is 0.\n\n**Note:** According to the HTML5 specification, the default value for size should be 1; however, in practice, this has been found to break some web sites, and no other browser currently does that, so Mozilla has opted to continue to return 0 for the time being with Firefox."}}],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/HTML/Element/select"}]},{name:"datalist",description:{kind:"markdown",value:"The datalist element represents a set of option elements that represent predefined options for other controls. In the rendering, the datalist element represents nothing and it, along with its children, should be hidden."},attributes:[],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/HTML/Element/datalist"}]},{name:"optgroup",description:{kind:"markdown",value:"The optgroup element represents a group of option elements with a common label."},attributes:[{name:"disabled",valueSet:"v",description:{kind:"markdown",value:"If this Boolean attribute is set, none of the items in this option group is selectable. Often browsers grey out such control and it won't receive any browsing events, like mouse clicks or focus-related ones."}},{name:"label",description:{kind:"markdown",value:"The name of the group of options, which the browser can use when labeling the options in the user interface. This attribute is mandatory if this element is used."}}],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/HTML/Element/optgroup"}]},{name:"option",description:{kind:"markdown",value:"The option element represents an option in a select element or as part of a list of suggestions in a datalist element."},attributes:[{name:"disabled",valueSet:"v",description:{kind:"markdown",value:'If this Boolean attribute is set, this option is not checkable. Often browsers grey out such control and it won\'t receive any browsing event, like mouse clicks or focus-related ones. If this attribute is not set, the element can still be disabled if one of its ancestors is a disabled [`<optgroup>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/optgroup "The HTML <optgroup> element creates a grouping of options within a <select> element.") element.'}},{name:"label",description:{kind:"markdown",value:"This attribute is text for the label indicating the meaning of the option. If the `label` attribute isn't defined, its value is that of the element text content."}},{name:"selected",valueSet:"v",description:{kind:"markdown",value:'If present, this Boolean attribute indicates that the option is initially selected. If the `<option>` element is the descendant of a [`<select>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/select "The HTML <select> element represents a control that provides a menu of options") element whose [`multiple`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/select#attr-multiple) attribute is not set, only one single `<option>` of this [`<select>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/select "The HTML <select> element represents a control that provides a menu of options") element may have the `selected` attribute.'}},{name:"value",description:{kind:"markdown",value:"The content of this attribute represents the value to be submitted with the form, should this option be selected. If this attribute is omitted, the value is taken from the text content of the option element."}}],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/HTML/Element/option"}]},{name:"textarea",description:{kind:"markdown",value:"The textarea element represents a multiline plain text edit control for the element's raw value. The contents of the control represent the control's default value."},attributes:[{name:"autocomplete",valueSet:"inputautocomplete",description:{kind:"markdown",value:'This attribute indicates whether the value of the control can be automatically completed by the browser. Possible values are:\n\n*   `off`: The user must explicitly enter a value into this field for every use, or the document provides its own auto-completion method; the browser does not automatically complete the entry.\n*   `on`: The browser can automatically complete the value based on values that the user has entered during previous uses.\n\nIf the `autocomplete` attribute is not specified on a `<textarea>` element, then the browser uses the `autocomplete` attribute value of the `<textarea>` element\'s form owner. The form owner is either the [`<form>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/form "The HTML <form> element represents a document section that contains interactive controls for submitting information to a web server.") element that this `<textarea>` element is a descendant of or the form element whose `id` is specified by the `form` attribute of the input element. For more information, see the [`autocomplete`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/form#attr-autocomplete) attribute in [`<form>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/form "The HTML <form> element represents a document section that contains interactive controls for submitting information to a web server.").'}},{name:"autofocus",valueSet:"v",description:{kind:"markdown",value:"This Boolean attribute lets you specify that a form control should have input focus when the page loads. Only one form-associated element in a document can have this attribute specified."}},{name:"cols",description:{kind:"markdown",value:"The visible width of the text control, in average character widths. If it is specified, it must be a positive integer. If it is not specified, the default value is `20`."}},{name:"dirname"},{name:"disabled",valueSet:"v",description:{kind:"markdown",value:'This Boolean attribute indicates that the user cannot interact with the control. If this attribute is not specified, the control inherits its setting from the containing element, for example [`<fieldset>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/fieldset "The HTML <fieldset> element is used to group several controls as well as labels (<label>) within a web form."); if there is no containing element when the `disabled` attribute is set, the control is enabled.'}},{name:"form",description:{kind:"markdown",value:'The form element that the `<textarea>` element is associated with (its "form owner"). The value of the attribute must be the `id` of a form element in the same document. If this attribute is not specified, the `<textarea>` element must be a descendant of a form element. This attribute enables you to place `<textarea>` elements anywhere within a document, not just as descendants of form elements.'}},{name:"inputmode",valueSet:"im"},{name:"maxlength",description:{kind:"markdown",value:"The maximum number of characters (unicode code points) that the user can enter. If this value isn't specified, the user can enter an unlimited number of characters."}},{name:"minlength",description:{kind:"markdown",value:"The minimum number of characters (unicode code points) required that the user should enter."}},{name:"name",description:{kind:"markdown",value:"The name of the control."}},{name:"placeholder",description:{kind:"markdown",value:'A hint to the user of what can be entered in the control. Carriage returns or line-feeds within the placeholder text must be treated as line breaks when rendering the hint.\n\n**Note:** Placeholders should only be used to show an example of the type of data that should be entered into a form; they are _not_ a substitute for a proper [`<label>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/label "The HTML <label> element represents a caption for an item in a user interface.") element tied to the input. See [Labels and placeholders](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/input#Labels_and_placeholders "The HTML <input> element is used to create interactive controls for web-based forms in order to accept data from the user; a wide variety of types of input data and control widgets are available, depending on the device and user agent.") in [<input>: The Input (Form Input) element](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/input "The HTML <input> element is used to create interactive controls for web-based forms in order to accept data from the user; a wide variety of types of input data and control widgets are available, depending on the device and user agent.") for a full explanation.'}},{name:"readonly",valueSet:"v",description:{kind:"markdown",value:"This Boolean attribute indicates that the user cannot modify the value of the control. Unlike the `disabled` attribute, the `readonly` attribute does not prevent the user from clicking or selecting in the control. The value of a read-only control is still submitted with the form."}},{name:"required",valueSet:"v",description:{kind:"markdown",value:"This attribute specifies that the user must fill in a value before submitting a form."}},{name:"rows",description:{kind:"markdown",value:"The number of visible text lines for the control."}},{name:"wrap",valueSet:"w",description:{kind:"markdown",value:"Indicates how the control wraps text. Possible values are:\n\n*   `hard`: The browser automatically inserts line breaks (CR+LF) so that each line has no more than the width of the control; the `cols` attribute must also be specified for this to take effect.\n*   `soft`: The browser ensures that all line breaks in the value consist of a CR+LF pair, but does not insert any additional line breaks.\n*   `off` : Like `soft` but changes appearance to `white-space: pre` so line segments exceeding `cols` are not wrapped and the `<textarea>` becomes horizontally scrollable.\n\nIf this attribute is not specified, `soft` is its default value."}},{name:"autocapitalize",description:"This is a non-standard attribute supported by WebKit on iOS (therefore nearly all browsers running on iOS, including Safari, Firefox, and Chrome), which controls whether and how the text value should be automatically capitalized as it is entered/edited by the user. The non-deprecated values are available in iOS 5 and later. Possible values are:\n\n*   `none`: Completely disables automatic capitalization.\n*   `sentences`: Automatically capitalize the first letter of sentences.\n*   `words`: Automatically capitalize the first letter of words.\n*   `characters`: Automatically capitalize all characters.\n*   `on`: Deprecated since iOS 5.\n*   `off`: Deprecated since iOS 5."},{name:"spellcheck",description:"Specifies whether the `<textarea>` is subject to spell checking by the underlying browser/OS. the value can be:\n\n*   `true`: Indicates that the element needs to have its spelling and grammar checked.\n*   `default` : Indicates that the element is to act according to a default behavior, possibly based on the parent element's own `spellcheck` value.\n*   `false` : Indicates that the element should not be spell checked."}],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/HTML/Element/textarea"}]},{name:"output",description:{kind:"markdown",value:"The output element represents the result of a calculation performed by the application, or the result of a user action."},attributes:[{name:"for",description:{kind:"markdown",value:"A space-separated list of other elements’ [`id`](https://developer.mozilla.org/en-US/docs/Web/HTML/Global_attributes/id)s, indicating that those elements contributed input values to (or otherwise affected) the calculation."}},{name:"form",description:{kind:"markdown",value:'The [form element](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/form) that this element is associated with (its "form owner"). The value of the attribute must be an `id` of a form element in the same document. If this attribute is not specified, the output element must be a descendant of a form element. This attribute enables you to place output elements anywhere within a document, not just as descendants of their form elements.'}},{name:"name",description:{kind:"markdown",value:'The name of the element, exposed in the [`HTMLFormElement`](https://developer.mozilla.org/en-US/docs/Web/API/HTMLFormElement "The HTMLFormElement interface represents a <form> element in the DOM; it allows access to and in some cases modification of aspects of the form, as well as access to its component elements.") API.'}}],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/HTML/Element/output"}]},{name:"progress",description:{kind:"markdown",value:"The progress element represents the completion progress of a task. The progress is either indeterminate, indicating that progress is being made but that it is not clear how much more work remains to be done before the task is complete (e.g. because the task is waiting for a remote host to respond), or the progress is a number in the range zero to a maximum, giving the fraction of work that has so far been completed."},attributes:[{name:"value",description:{kind:"markdown",value:"This attribute specifies how much of the task that has been completed. It must be a valid floating point number between 0 and `max`, or between 0 and 1 if `max` is omitted. If there is no `value` attribute, the progress bar is indeterminate; this indicates that an activity is ongoing with no indication of how long it is expected to take."}},{name:"max",description:{kind:"markdown",value:"This attribute describes how much work the task indicated by the `progress` element requires. The `max` attribute, if present, must have a value greater than zero and be a valid floating point number. The default value is 1."}}],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/HTML/Element/progress"}]},{name:"meter",description:{kind:"markdown",value:"The meter element represents a scalar measurement within a known range, or a fractional value; for example disk usage, the relevance of a query result, or the fraction of a voting population to have selected a particular candidate."},attributes:[{name:"value",description:{kind:"markdown",value:"The current numeric value. This must be between the minimum and maximum values (`min` attribute and `max` attribute) if they are specified. If unspecified or malformed, the value is 0. If specified, but not within the range given by the `min` attribute and `max` attribute, the value is equal to the nearest end of the range.\n\n**Usage note:** Unless the `value` attribute is between `0` and `1` (inclusive), the `min` and `max` attributes should define the range so that the `value` attribute's value is within it."}},{name:"min",description:{kind:"markdown",value:"The lower numeric bound of the measured range. This must be less than the maximum value (`max` attribute), if specified. If unspecified, the minimum value is 0."}},{name:"max",description:{kind:"markdown",value:"The upper numeric bound of the measured range. This must be greater than the minimum value (`min` attribute), if specified. If unspecified, the maximum value is 1."}},{name:"low",description:{kind:"markdown",value:"The upper numeric bound of the low end of the measured range. This must be greater than the minimum value (`min` attribute), and it also must be less than the high value and maximum value (`high` attribute and `max` attribute, respectively), if any are specified. If unspecified, or if less than the minimum value, the `low` value is equal to the minimum value."}},{name:"high",description:{kind:"markdown",value:"The lower numeric bound of the high end of the measured range. This must be less than the maximum value (`max` attribute), and it also must be greater than the low value and minimum value (`low` attribute and **min** attribute, respectively), if any are specified. If unspecified, or if greater than the maximum value, the `high` value is equal to the maximum value."}},{name:"optimum",description:{kind:"markdown",value:"This attribute indicates the optimal numeric value. It must be within the range (as defined by the `min` attribute and `max` attribute). When used with the `low` attribute and `high` attribute, it gives an indication where along the range is considered preferable. For example, if it is between the `min` attribute and the `low` attribute, then the lower range is considered preferred."}},{name:"form",description:"This attribute associates the element with a `form` element that has ownership of the `meter` element. For example, a `meter` might be displaying a range corresponding to an `input` element of `type` _number_. This attribute is only used if the `meter` element is being used as a form-associated element; even then, it may be omitted if the element appears as a descendant of a `form` element."}],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/HTML/Element/meter"}]},{name:"fieldset",description:{kind:"markdown",value:"The fieldset element represents a set of form controls optionally grouped under a common name."},attributes:[{name:"disabled",valueSet:"v",description:{kind:"markdown",value:"If this Boolean attribute is set, all form controls that are descendants of the `<fieldset>`, are disabled, meaning they are not editable and won't be submitted along with the `<form>`. They won't receive any browsing events, like mouse clicks or focus-related events. By default browsers display such controls grayed out. Note that form elements inside the [`<legend>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/legend \"The HTML <legend> element represents a caption for the content of its parent <fieldset>.\") element won't be disabled."}},{name:"form",description:{kind:"markdown",value:'This attribute takes the value of the `id` attribute of a [`<form>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/form "The HTML <form> element represents a document section that contains interactive controls for submitting information to a web server.") element you want the `<fieldset>` to be part of, even if it is not inside the form.'}},{name:"name",description:{kind:"markdown",value:'The name associated with the group.\n\n**Note**: The caption for the fieldset is given by the first [`<legend>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/legend "The HTML <legend> element represents a caption for the content of its parent <fieldset>.") element nested inside it.'}}],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/HTML/Element/fieldset"}]},{name:"legend",description:{kind:"markdown",value:"The legend element represents a caption for the rest of the contents of the legend element's parent fieldset element, if any."},attributes:[],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/HTML/Element/legend"}]},{name:"details",description:{kind:"markdown",value:"The details element represents a disclosure widget from which the user can obtain additional information or controls."},attributes:[{name:"open",valueSet:"v",description:{kind:"markdown",value:"This Boolean attribute indicates whether or not the details — that is, the contents of the `<details>` element — are currently visible. The default, `false`, means the details are not visible."}}],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/HTML/Element/details"}]},{name:"summary",description:{kind:"markdown",value:"The summary element represents a summary, caption, or legend for the rest of the contents of the summary element's parent details element, if any."},attributes:[],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/HTML/Element/summary"}]},{name:"dialog",description:{kind:"markdown",value:"The dialog element represents a part of an application that a user interacts with to perform a task, for example a dialog box, inspector, or window."},attributes:[{name:"open",description:"Indicates that the dialog is active and available for interaction. When the `open` attribute is not set, the dialog shouldn't be shown to the user."}],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/HTML/Element/dialog"}]},{name:"script",description:{kind:"markdown",value:"The script element allows authors to include dynamic script and data blocks in their documents. The element does not represent content for the user."},attributes:[{name:"src",description:{kind:"markdown",value:"This attribute specifies the URI of an external script; this can be used as an alternative to embedding a script directly within a document.\n\nIf a `script` element has a `src` attribute specified, it should not have a script embedded inside its tags."}},{name:"type",description:{kind:"markdown",value:'This attribute indicates the type of script represented. The value of this attribute will be in one of the following categories:\n\n*   **Omitted or a JavaScript MIME type:** For HTML5-compliant browsers this indicates the script is JavaScript. HTML5 specification urges authors to omit the attribute rather than provide a redundant MIME type. In earlier browsers, this identified the scripting language of the embedded or imported (via the `src` attribute) code. JavaScript MIME types are [listed in the specification](https://developer.mozilla.org/en-US/docs/Web/HTTP/Basics_of_HTTP/MIME_types#JavaScript_types).\n*   **`module`:** For HTML5-compliant browsers the code is treated as a JavaScript module. The processing of the script contents is not affected by the `charset` and `defer` attributes. For information on using `module`, see [ES6 in Depth: Modules](https://hacks.mozilla.org/2015/08/es6-in-depth-modules/). Code may behave differently when the `module` keyword is used.\n*   **Any other value:** The embedded content is treated as a data block which won\'t be processed by the browser. Developers must use a valid MIME type that is not a JavaScript MIME type to denote data blocks. The `src` attribute will be ignored.\n\n**Note:** in Firefox you could specify the version of JavaScript contained in a `<script>` element by including a non-standard `version` parameter inside the `type` attribute — for example `type="text/javascript;version=1.8"`. This has been removed in Firefox 59 (see [bug 1428745](https://bugzilla.mozilla.org/show_bug.cgi?id=1428745 "FIXED: Remove support for version parameter from script loader")).'}},{name:"charset"},{name:"async",valueSet:"v",description:{kind:"markdown",value:'This is a Boolean attribute indicating that the browser should, if possible, load the script asynchronously.\n\nThis attribute must not be used if the `src` attribute is absent (i.e. for inline scripts). If it is included in this case it will have no effect.\n\nBrowsers usually assume the worst case scenario and load scripts synchronously, (i.e. `async="false"`) during HTML parsing.\n\nDynamically inserted scripts (using [`document.createElement()`](https://developer.mozilla.org/en-US/docs/Web/API/Document/createElement "In an HTML document, the document.createElement() method creates the HTML element specified by tagName, or an HTMLUnknownElement if tagName isn\'t recognized.")) load asynchronously by default, so to turn on synchronous loading (i.e. scripts load in the order they were inserted) set `async="false"`.\n\nSee [Browser compatibility](#Browser_compatibility) for notes on browser support. See also [Async scripts for asm.js](https://developer.mozilla.org/en-US/docs/Games/Techniques/Async_scripts).'}},{name:"defer",valueSet:"v",description:{kind:"markdown",value:'This Boolean attribute is set to indicate to a browser that the script is meant to be executed after the document has been parsed, but before firing [`DOMContentLoaded`](https://developer.mozilla.org/en-US/docs/Web/Events/DOMContentLoaded "/en-US/docs/Web/Events/DOMContentLoaded").\n\nScripts with the `defer` attribute will prevent the `DOMContentLoaded` event from firing until the script has loaded and finished evaluating.\n\nThis attribute must not be used if the `src` attribute is absent (i.e. for inline scripts), in this case it would have no effect.\n\nTo achieve a similar effect for dynamically inserted scripts use `async="false"` instead. Scripts with the `defer` attribute will execute in the order in which they appear in the document.'}},{name:"crossorigin",valueSet:"xo",description:{kind:"markdown",value:'Normal `script` elements pass minimal information to the [`window.onerror`](https://developer.mozilla.org/en-US/docs/Web/API/GlobalEventHandlers/onerror "The onerror property of the GlobalEventHandlers mixin is an EventHandler that processes error events.") for scripts which do not pass the standard [CORS](https://developer.mozilla.org/en-US/docs/Glossary/CORS "CORS: CORS (Cross-Origin Resource Sharing) is a system, consisting of transmitting HTTP headers, that determines whether browsers block frontend JavaScript code from accessing responses for cross-origin requests.") checks. To allow error logging for sites which use a separate domain for static media, use this attribute. See [CORS settings attributes](https://developer.mozilla.org/en-US/docs/Web/HTML/CORS_settings_attributes) for a more descriptive explanation of its valid arguments.'}},{name:"nonce",description:{kind:"markdown",value:"A cryptographic nonce (number used once) to whitelist inline scripts in a [script-src Content-Security-Policy](https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Content-Security-Policy/script-src). The server must generate a unique nonce value each time it transmits a policy. It is critical to provide a nonce that cannot be guessed as bypassing a resource's policy is otherwise trivial."}},{name:"integrity",description:"This attribute contains inline metadata that a user agent can use to verify that a fetched resource has been delivered free of unexpected manipulation. See [Subresource Integrity](https://developer.mozilla.org/en-US/docs/Web/Security/Subresource_Integrity)."},{name:"nomodule",description:"This Boolean attribute is set to indicate that the script should not be executed in browsers that support [ES2015 modules](https://hacks.mozilla.org/2015/08/es6-in-depth-modules/) — in effect, this can be used to serve fallback scripts to older browsers that do not support modular JavaScript code."},{name:"referrerpolicy",description:'Indicates which [referrer](https://developer.mozilla.org/en-US/docs/Web/API/Document/referrer) to send when fetching the script, or resources fetched by the script:\n\n*   `no-referrer`: The [`Referer`](https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Referer "The Referer request header contains the address of the previous web page from which a link to the currently requested page was followed. The Referer header allows servers to identify where people are visiting them from and may use that data for analytics, logging, or optimized caching, for example.") header will not be sent.\n*   `no-referrer-when-downgrade` (default): The [`Referer`](https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Referer "The Referer request header contains the address of the previous web page from which a link to the currently requested page was followed. The Referer header allows servers to identify where people are visiting them from and may use that data for analytics, logging, or optimized caching, for example.") header will not be sent to [origin](https://developer.mozilla.org/en-US/docs/Glossary/origin "origin: Web content\'s origin is defined by the scheme (protocol), host (domain), and port of the URL used to access it. Two objects have the same origin only when the scheme, host, and port all match.")s without [TLS](https://developer.mozilla.org/en-US/docs/Glossary/TLS "TLS: Transport Layer Security (TLS), previously known as Secure Sockets Layer (SSL), is a protocol used by applications to communicate securely across a network, preventing tampering with and eavesdropping on email, web browsing, messaging, and other protocols.") ([HTTPS](https://developer.mozilla.org/en-US/docs/Glossary/HTTPS "HTTPS: HTTPS (HTTP Secure) is an encrypted version of the HTTP protocol. It usually uses SSL or TLS to encrypt all communication between a client and a server. This secure connection allows clients to safely exchange sensitive data with a server, for example for banking activities or online shopping.")).\n*   `origin`: The sent referrer will be limited to the origin of the referring page: its [scheme](https://developer.mozilla.org/en-US/docs/Archive/Mozilla/URIScheme), [host](https://developer.mozilla.org/en-US/docs/Glossary/host "host: A host is a device connected to the Internet (or a local network). Some hosts called servers offer additional services like serving webpages or storing files and emails."), and [port](https://developer.mozilla.org/en-US/docs/Glossary/port "port: For a computer connected to a network with an IP address, a port is a communication endpoint. Ports are designated by numbers, and below 1024 each port is associated by default with a specific protocol.").\n*   `origin-when-cross-origin`: The referrer sent to other origins will be limited to the scheme, the host, and the port. Navigations on the same origin will still include the path.\n*   `same-origin`: A referrer will be sent for [same origin](https://developer.mozilla.org/en-US/docs/Glossary/Same-origin_policy "same origin: The same-origin policy is a critical security mechanism that restricts how a document or script loaded from one origin can interact with a resource from another origin."), but cross-origin requests will contain no referrer information.\n*   `strict-origin`: Only send the origin of the document as the referrer when the protocol security level stays the same (e.g. HTTPS→HTTPS), but don\'t send it to a less secure destination (e.g. HTTPS→HTTP).\n*   `strict-origin-when-cross-origin`: Send a full URL when performing a same-origin request, but only send the origin when the protocol security level stays the same (e.g.HTTPS→HTTPS), and send no header to a less secure destination (e.g. HTTPS→HTTP).\n*   `unsafe-url`: The referrer will include the origin _and_ the path (but not the [fragment](https://developer.mozilla.org/en-US/docs/Web/API/HTMLHyperlinkElementUtils/hash), [password](https://developer.mozilla.org/en-US/docs/Web/API/HTMLHyperlinkElementUtils/password), or [username](https://developer.mozilla.org/en-US/docs/Web/API/HTMLHyperlinkElementUtils/username)). **This value is unsafe**, because it leaks origins and paths from TLS-protected resources to insecure origins.\n\n**Note**: An empty string value (`""`) is both the default value, and a fallback value if `referrerpolicy` is not supported. If `referrerpolicy` is not explicitly specified on the `<script>` element, it will adopt a higher-level referrer policy, i.e. one set on the whole document or domain. If a higher-level policy is not available, the empty string is treated as being equivalent to `no-referrer-when-downgrade`.'},{name:"text",description:"Like the `textContent` attribute, this attribute sets the text content of the element. Unlike the `textContent` attribute, however, this attribute is evaluated as executable code after the node is inserted into the DOM."}],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/HTML/Element/script"}]},{name:"noscript",description:{kind:"markdown",value:"The noscript element represents nothing if scripting is enabled, and represents its children if scripting is disabled. It is used to present different markup to user agents that support scripting and those that don't support scripting, by affecting how the document is parsed."},attributes:[],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/HTML/Element/noscript"}]},{name:"template",description:{kind:"markdown",value:"The template element is used to declare fragments of HTML that can be cloned and inserted in the document by script."},attributes:[],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/HTML/Element/template"}]},{name:"canvas",description:{kind:"markdown",value:"The canvas element provides scripts with a resolution-dependent bitmap canvas, which can be used for rendering graphs, game graphics, art, or other visual images on the fly."},attributes:[{name:"width",description:{kind:"markdown",value:"The width of the coordinate space in CSS pixels. Defaults to 300."}},{name:"height",description:{kind:"markdown",value:"The height of the coordinate space in CSS pixels. Defaults to 150."}},{name:"moz-opaque",description:"Lets the canvas know whether or not translucency will be a factor. If the canvas knows there's no translucency, painting performance can be optimized. This is only supported by Mozilla-based browsers; use the standardized [`canvas.getContext('2d', { alpha: false })`](https://developer.mozilla.org/en-US/docs/Web/API/HTMLCanvasElement/getContext \"The HTMLCanvasElement.getContext() method returns a drawing context on the canvas, or null if the context identifier is not supported.\") instead."}],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/HTML/Element/canvas"}]}],globalAttributes:[{name:"accesskey",description:{kind:"markdown",value:"Provides a hint for generating a keyboard shortcut for the current element. This attribute consists of a space-separated list of characters. The browser should use the first one that exists on the computer keyboard layout."},references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/HTML/Global_attributes/accesskey"}]},{name:"autocapitalize",description:{kind:"markdown",value:"Controls whether and how text input is automatically capitalized as it is entered/edited by the user. It can have the following values:\n\n*   `off` or `none`, no autocapitalization is applied (all letters default to lowercase)\n*   `on` or `sentences`, the first letter of each sentence defaults to a capital letter; all other letters default to lowercase\n*   `words`, the first letter of each word defaults to a capital letter; all other letters default to lowercase\n*   `characters`, all letters should default to uppercase"},references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/HTML/Global_attributes/autocapitalize"}]},{name:"class",description:{kind:"markdown",value:'A space-separated list of the classes of the element. Classes allows CSS and JavaScript to select and access specific elements via the [class selectors](/en-US/docs/Web/CSS/Class_selectors) or functions like the method [`Document.getElementsByClassName()`](/en-US/docs/Web/API/Document/getElementsByClassName "returns an array-like object of all child elements which have all of the given class names.").'},references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/HTML/Global_attributes/class"}]},{name:"contenteditable",description:{kind:"markdown",value:"An enumerated attribute indicating if the element should be editable by the user. If so, the browser modifies its widget to allow editing. The attribute must take one of the following values:\n\n*   `true` or the _empty string_, which indicates that the element must be editable;\n*   `false`, which indicates that the element must not be editable."},references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/HTML/Global_attributes/contenteditable"}]},{name:"contextmenu",description:{kind:"markdown",value:'The `[**id**](#attr-id)` of a [`<menu>`](/en-US/docs/Web/HTML/Element/menu "The HTML <menu> element represents a group of commands that a user can perform or activate. This includes both list menus, which might appear across the top of a screen, as well as context menus, such as those that might appear underneath a button after it has been clicked.") to use as the contextual menu for this element.'},references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/HTML/Global_attributes/contextmenu"}]},{name:"dir",description:{kind:"markdown",value:"An enumerated attribute indicating the directionality of the element's text. It can have the following values:\n\n*   `ltr`, which means _left to right_ and is to be used for languages that are written from the left to the right (like English);\n*   `rtl`, which means _right to left_ and is to be used for languages that are written from the right to the left (like Arabic);\n*   `auto`, which lets the user agent decide. It uses a basic algorithm as it parses the characters inside the element until it finds a character with a strong directionality, then it applies that directionality to the whole element."},valueSet:"d",references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/HTML/Global_attributes/dir"}]},{name:"draggable",description:{kind:"markdown",value:"An enumerated attribute indicating whether the element can be dragged, using the [Drag and Drop API](/en-us/docs/DragDrop/Drag_and_Drop). It can have the following values:\n\n*   `true`, which indicates that the element may be dragged\n*   `false`, which indicates that the element may not be dragged."},valueSet:"b",references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/HTML/Global_attributes/draggable"}]},{name:"dropzone",description:{kind:"markdown",value:"An enumerated attribute indicating what types of content can be dropped on an element, using the [Drag and Drop API](/en-US/docs/DragDrop/Drag_and_Drop). It can have the following values:\n\n*   `copy`, which indicates that dropping will create a copy of the element that was dragged\n*   `move`, which indicates that the element that was dragged will be moved to this new location.\n*   `link`, will create a link to the dragged data."}},{name:"exportparts",description:{kind:"markdown",value:"Used to transitively export shadow parts from a nested shadow tree into a containing light tree."},references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/HTML/Global_attributes/exportparts"}]},{name:"hidden",description:{kind:"markdown",value:"A Boolean attribute indicates that the element is not yet, or is no longer, _relevant_. For example, it can be used to hide elements of the page that can't be used until the login process has been completed. The browser won't render such elements. This attribute must not be used to hide content that could legitimately be shown."},valueSet:"v",references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/HTML/Global_attributes/hidden"}]},{name:"id",description:{kind:"markdown",value:"Defines a unique identifier (ID) which must be unique in the whole document. Its purpose is to identify the element when linking (using a fragment identifier), scripting, or styling (with CSS)."},references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/HTML/Global_attributes/id"}]},{name:"inputmode",description:{kind:"markdown",value:'Provides a hint to browsers as to the type of virtual keyboard configuration to use when editing this element or its contents. Used primarily on [`<input>`](/en-US/docs/Web/HTML/Element/input "The HTML <input> element is used to create interactive controls for web-based forms in order to accept data from the user; a wide variety of types of input data and control widgets are available, depending on the device and user agent.") elements, but is usable on any element while in `[contenteditable](/en-US/docs/Web/HTML/Global_attributes#attr-contenteditable)` mode.'},references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/HTML/Global_attributes/inputmode"}]},{name:"is",description:{kind:"markdown",value:"Allows you to specify that a standard HTML element should behave like a registered custom built-in element (see [Using custom elements](/en-US/docs/Web/Web_Components/Using_custom_elements) for more details)."},references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/HTML/Global_attributes/is"}]},{name:"itemid",description:{kind:"markdown",value:"The unique, global identifier of an item."},references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/HTML/Global_attributes/itemid"}]},{name:"itemprop",description:{kind:"markdown",value:"Used to add properties to an item. Every HTML element may have an `itemprop` attribute specified, where an `itemprop` consists of a name and value pair."},references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/HTML/Global_attributes/itemprop"}]},{name:"itemref",description:{kind:"markdown",value:"Properties that are not descendants of an element with the `itemscope` attribute can be associated with the item using an `itemref`. It provides a list of element ids (not `itemid`s) with additional properties elsewhere in the document."},references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/HTML/Global_attributes/itemref"}]},{name:"itemscope",description:{kind:"markdown",value:"`itemscope` (usually) works along with `[itemtype](/en-US/docs/Web/HTML/Global_attributes#attr-itemtype)` to specify that the HTML contained in a block is about a particular item. `itemscope` creates the Item and defines the scope of the `itemtype` associated with it. `itemtype` is a valid URL of a vocabulary (such as [schema.org](https://schema.org/)) that describes the item and its properties context."},valueSet:"v",references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/HTML/Global_attributes/itemscope"}]},{name:"itemtype",description:{kind:"markdown",value:"Specifies the URL of the vocabulary that will be used to define `itemprop`s (item properties) in the data structure. `[itemscope](/en-US/docs/Web/HTML/Global_attributes#attr-itemscope)` is used to set the scope of where in the data structure the vocabulary set by `itemtype` will be active."},references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/HTML/Global_attributes/itemtype"}]},{name:"lang",description:{kind:"markdown",value:"Helps define the language of an element: the language that non-editable elements are in, or the language that editable elements should be written in by the user. The attribute contains one “language tag” (made of hyphen-separated “language subtags”) in the format defined in [_Tags for Identifying Languages (BCP47)_](https://www.ietf.org/rfc/bcp/bcp47.txt). [**xml:lang**](#attr-xml:lang) has priority over it."},references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/HTML/Global_attributes/lang"}]},{name:"part",description:{kind:"markdown",value:'A space-separated list of the part names of the element. Part names allows CSS to select and style specific elements in a shadow tree via the [`::part`](/en-US/docs/Web/CSS/::part "The ::part CSS pseudo-element represents any element within a shadow tree that has a matching part attribute.") pseudo-element.'},references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/HTML/Global_attributes/part"}]},{name:"role",valueSet:"roles"},{name:"slot",description:{kind:"markdown",value:"Assigns a slot in a [shadow DOM](/en-US/docs/Web/Web_Components/Shadow_DOM) shadow tree to an element: An element with a `slot` attribute is assigned to the slot created by the [`<slot>`](/en-US/docs/Web/HTML/Element/slot \"The HTML <slot> element—part of the Web Components technology suite—is a placeholder inside a web component that you can fill with your own markup, which lets you create separate DOM trees and present them together.\") element whose `[name](/en-US/docs/Web/HTML/Element/slot#attr-name)` attribute's value matches that `slot` attribute's value."},references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/HTML/Global_attributes/slot"}]},{name:"spellcheck",description:{kind:"markdown",value:"An enumerated attribute defines whether the element may be checked for spelling errors. It may have the following values:\n\n*   `true`, which indicates that the element should be, if possible, checked for spelling errors;\n*   `false`, which indicates that the element should not be checked for spelling errors."},valueSet:"b",references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/HTML/Global_attributes/spellcheck"}]},{name:"style",description:{kind:"markdown",value:'Contains [CSS](/en-US/docs/Web/CSS) styling declarations to be applied to the element. Note that it is recommended for styles to be defined in a separate file or files. This attribute and the [`<style>`](/en-US/docs/Web/HTML/Element/style "The HTML <style> element contains style information for a document, or part of a document.") element have mainly the purpose of allowing for quick styling, for example for testing purposes.'},references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/HTML/Global_attributes/style"}]},{name:"tabindex",description:{kind:"markdown",value:"An integer attribute indicating if the element can take input focus (is _focusable_), if it should participate to sequential keyboard navigation, and if so, at what position. It can take several values:\n\n*   a _negative value_ means that the element should be focusable, but should not be reachable via sequential keyboard navigation;\n*   `0` means that the element should be focusable and reachable via sequential keyboard navigation, but its relative order is defined by the platform convention;\n*   a _positive value_ means that the element should be focusable and reachable via sequential keyboard navigation; the order in which the elements are focused is the increasing value of the [**tabindex**](#attr-tabindex). If several elements share the same tabindex, their relative order follows their relative positions in the document."},references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/HTML/Global_attributes/tabindex"}]},{name:"title",description:{kind:"markdown",value:"Contains a text representing advisory information related to the element it belongs to. Such information can typically, but not necessarily, be presented to the user as a tooltip."},references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/HTML/Global_attributes/title"}]},{name:"translate",description:{kind:"markdown",value:"An enumerated attribute that is used to specify whether an element's attribute values and the values of its [`Text`](/en-US/docs/Web/API/Text \"The Text interface represents the textual content of Element or Attr. If an element has no markup within its content, it has a single child implementing Text that contains the element's text. However, if the element contains markup, it is parsed into information items and Text nodes that form its children.\") node children are to be translated when the page is localized, or whether to leave them unchanged. It can have the following values:\n\n*   empty string and `yes`, which indicates that the element will be translated.\n*   `no`, which indicates that the element will not be translated."},valueSet:"y",references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/HTML/Global_attributes/translate"}]},{name:"onabort",description:{kind:"markdown",value:"The loading of a resource has been aborted."}},{name:"onblur",description:{kind:"markdown",value:"An element has lost focus (does not bubble)."}},{name:"oncanplay",description:{kind:"markdown",value:"The user agent can play the media, but estimates that not enough data has been loaded to play the media up to its end without having to stop for further buffering of content."}},{name:"oncanplaythrough",description:{kind:"markdown",value:"The user agent can play the media up to its end without having to stop for further buffering of content."}},{name:"onchange",description:{kind:"markdown",value:"The change event is fired for <input>, <select>, and <textarea> elements when a change to the element's value is committed by the user."}},{name:"onclick",description:{kind:"markdown",value:"A pointing device button has been pressed and released on an element."}},{name:"oncontextmenu",description:{kind:"markdown",value:"The right button of the mouse is clicked (before the context menu is displayed)."}},{name:"ondblclick",description:{kind:"markdown",value:"A pointing device button is clicked twice on an element."}},{name:"ondrag",description:{kind:"markdown",value:"An element or text selection is being dragged (every 350ms)."}},{name:"ondragend",description:{kind:"markdown",value:"A drag operation is being ended (by releasing a mouse button or hitting the escape key)."}},{name:"ondragenter",description:{kind:"markdown",value:"A dragged element or text selection enters a valid drop target."}},{name:"ondragleave",description:{kind:"markdown",value:"A dragged element or text selection leaves a valid drop target."}},{name:"ondragover",description:{kind:"markdown",value:"An element or text selection is being dragged over a valid drop target (every 350ms)."}},{name:"ondragstart",description:{kind:"markdown",value:"The user starts dragging an element or text selection."}},{name:"ondrop",description:{kind:"markdown",value:"An element is dropped on a valid drop target."}},{name:"ondurationchange",description:{kind:"markdown",value:"The duration attribute has been updated."}},{name:"onemptied",description:{kind:"markdown",value:"The media has become empty; for example, this event is sent if the media has already been loaded (or partially loaded), and the load() method is called to reload it."}},{name:"onended",description:{kind:"markdown",value:"Playback has stopped because the end of the media was reached."}},{name:"onerror",description:{kind:"markdown",value:"A resource failed to load."}},{name:"onfocus",description:{kind:"markdown",value:"An element has received focus (does not bubble)."}},{name:"onformchange"},{name:"onforminput"},{name:"oninput",description:{kind:"markdown",value:"The value of an element changes or the content of an element with the attribute contenteditable is modified."}},{name:"oninvalid",description:{kind:"markdown",value:"A submittable element has been checked and doesn't satisfy its constraints."}},{name:"onkeydown",description:{kind:"markdown",value:"A key is pressed down."}},{name:"onkeypress",description:{kind:"markdown",value:"A key is pressed down and that key normally produces a character value (use input instead)."}},{name:"onkeyup",description:{kind:"markdown",value:"A key is released."}},{name:"onload",description:{kind:"markdown",value:"A resource and its dependent resources have finished loading."}},{name:"onloadeddata",description:{kind:"markdown",value:"The first frame of the media has finished loading."}},{name:"onloadedmetadata",description:{kind:"markdown",value:"The metadata has been loaded."}},{name:"onloadstart",description:{kind:"markdown",value:"Progress has begun."}},{name:"onmousedown",description:{kind:"markdown",value:"A pointing device button (usually a mouse) is pressed on an element."}},{name:"onmousemove",description:{kind:"markdown",value:"A pointing device is moved over an element."}},{name:"onmouseout",description:{kind:"markdown",value:"A pointing device is moved off the element that has the listener attached or off one of its children."}},{name:"onmouseover",description:{kind:"markdown",value:"A pointing device is moved onto the element that has the listener attached or onto one of its children."}},{name:"onmouseup",description:{kind:"markdown",value:"A pointing device button is released over an element."}},{name:"onmousewheel"},{name:"onmouseenter",description:{kind:"markdown",value:"A pointing device is moved onto the element that has the listener attached."}},{name:"onmouseleave",description:{kind:"markdown",value:"A pointing device is moved off the element that has the listener attached."}},{name:"onpause",description:{kind:"markdown",value:"Playback has been paused."}},{name:"onplay",description:{kind:"markdown",value:"Playback has begun."}},{name:"onplaying",description:{kind:"markdown",value:"Playback is ready to start after having been paused or delayed due to lack of data."}},{name:"onprogress",description:{kind:"markdown",value:"In progress."}},{name:"onratechange",description:{kind:"markdown",value:"The playback rate has changed."}},{name:"onreset",description:{kind:"markdown",value:"A form is reset."}},{name:"onresize",description:{kind:"markdown",value:"The document view has been resized."}},{name:"onreadystatechange",description:{kind:"markdown",value:"The readyState attribute of a document has changed."}},{name:"onscroll",description:{kind:"markdown",value:"The document view or an element has been scrolled."}},{name:"onseeked",description:{kind:"markdown",value:"A seek operation completed."}},{name:"onseeking",description:{kind:"markdown",value:"A seek operation began."}},{name:"onselect",description:{kind:"markdown",value:"Some text is being selected."}},{name:"onshow",description:{kind:"markdown",value:"A contextmenu event was fired on/bubbled to an element that has a contextmenu attribute"}},{name:"onstalled",description:{kind:"markdown",value:"The user agent is trying to fetch media data, but data is unexpectedly not forthcoming."}},{name:"onsubmit",description:{kind:"markdown",value:"A form is submitted."}},{name:"onsuspend",description:{kind:"markdown",value:"Media data loading has been suspended."}},{name:"ontimeupdate",description:{kind:"markdown",value:"The time indicated by the currentTime attribute has been updated."}},{name:"onvolumechange",description:{kind:"markdown",value:"The volume has changed."}},{name:"onwaiting",description:{kind:"markdown",value:"Playback has stopped because of a temporary lack of data."}},{name:"onpointercancel",description:{kind:"markdown",value:"The pointer is unlikely to produce any more events."}},{name:"onpointerdown",description:{kind:"markdown",value:"The pointer enters the active buttons state."}},{name:"onpointerenter",description:{kind:"markdown",value:"Pointing device is moved inside the hit-testing boundary."}},{name:"onpointerleave",description:{kind:"markdown",value:"Pointing device is moved out of the hit-testing boundary."}},{name:"onpointerlockchange",description:{kind:"markdown",value:"The pointer was locked or released."}},{name:"onpointerlockerror",description:{kind:"markdown",value:"It was impossible to lock the pointer for technical reasons or because the permission was denied."}},{name:"onpointermove",description:{kind:"markdown",value:"The pointer changed coordinates."}},{name:"onpointerout",description:{kind:"markdown",value:"The pointing device moved out of hit-testing boundary or leaves detectable hover range."}},{name:"onpointerover",description:{kind:"markdown",value:"The pointing device is moved into the hit-testing boundary."}},{name:"onpointerup",description:{kind:"markdown",value:"The pointer leaves the active buttons state."}},{name:"aria-activedescendant",references:[{name:"WAI-ARIA Reference",url:"https://www.w3.org/TR/wai-aria-1.1/#aria-activedescendant"}],description:{kind:"markdown",value:"Identifies the currently active element when DOM focus is on a [`composite`](https://www.w3.org/TR/wai-aria-1.1/#composite) widget, [`textbox`](https://www.w3.org/TR/wai-aria-1.1/#textbox), [`group`](https://www.w3.org/TR/wai-aria-1.1/#group), or [`application`](https://www.w3.org/TR/wai-aria-1.1/#application)."}},{name:"aria-atomic",valueSet:"b",references:[{name:"WAI-ARIA Reference",url:"https://www.w3.org/TR/wai-aria-1.1/#aria-atomic"}],description:{kind:"markdown",value:"Indicates whether [assistive technologies](https://www.w3.org/TR/wai-aria-1.1/#dfn-assistive-technology) will present all, or only parts of, the changed region based on the change notifications defined by the [`aria-relevant`](https://www.w3.org/TR/wai-aria-1.1/#aria-relevant) attribute."}},{name:"aria-autocomplete",valueSet:"autocomplete",references:[{name:"WAI-ARIA Reference",url:"https://www.w3.org/TR/wai-aria-1.1/#aria-autocomplete"}],description:{kind:"markdown",value:"Indicates whether inputting text could trigger display of one or more predictions of the user's intended value for an input and specifies how predictions would be presented if they are made."}},{name:"aria-busy",valueSet:"b",references:[{name:"WAI-ARIA Reference",url:"https://www.w3.org/TR/wai-aria-1.1/#aria-busy"}],description:{kind:"markdown",value:"Indicates an element is being modified and that assistive technologies _MAY_ want to wait until the modifications are complete before exposing them to the user."}},{name:"aria-checked",valueSet:"tristate",references:[{name:"WAI-ARIA Reference",url:"https://www.w3.org/TR/wai-aria-1.1/#aria-checked"}],description:{kind:"markdown",value:'Indicates the current "checked" [state](https://www.w3.org/TR/wai-aria-1.1/#dfn-state) of checkboxes, radio buttons, and other [widgets](https://www.w3.org/TR/wai-aria-1.1/#dfn-widget). See related [`aria-pressed`](https://www.w3.org/TR/wai-aria-1.1/#aria-pressed) and [`aria-selected`](https://www.w3.org/TR/wai-aria-1.1/#aria-selected).'}},{name:"aria-colcount",references:[{name:"WAI-ARIA Reference",url:"https://www.w3.org/TR/wai-aria-1.1/#aria-colcount"}],description:{kind:"markdown",value:"Defines the total number of columns in a [`table`](https://www.w3.org/TR/wai-aria-1.1/#table), [`grid`](https://www.w3.org/TR/wai-aria-1.1/#grid), or [`treegrid`](https://www.w3.org/TR/wai-aria-1.1/#treegrid). See related [`aria-colindex`](https://www.w3.org/TR/wai-aria-1.1/#aria-colindex)."}},{name:"aria-colindex",references:[{name:"WAI-ARIA Reference",url:"https://www.w3.org/TR/wai-aria-1.1/#aria-colindex"}],description:{kind:"markdown",value:"Defines an [element's](https://www.w3.org/TR/wai-aria-1.1/#dfn-element) column index or position with respect to the total number of columns within a [`table`](https://www.w3.org/TR/wai-aria-1.1/#table), [`grid`](https://www.w3.org/TR/wai-aria-1.1/#grid), or [`treegrid`](https://www.w3.org/TR/wai-aria-1.1/#treegrid). See related [`aria-colcount`](https://www.w3.org/TR/wai-aria-1.1/#aria-colcount) and [`aria-colspan`](https://www.w3.org/TR/wai-aria-1.1/#aria-colspan)."}},{name:"aria-colspan",references:[{name:"WAI-ARIA Reference",url:"https://www.w3.org/TR/wai-aria-1.1/#aria-colspan"}],description:{kind:"markdown",value:"Defines the number of columns spanned by a cell or gridcell within a [`table`](https://www.w3.org/TR/wai-aria-1.1/#table), [`grid`](https://www.w3.org/TR/wai-aria-1.1/#grid), or [`treegrid`](https://www.w3.org/TR/wai-aria-1.1/#treegrid). See related [`aria-colindex`](https://www.w3.org/TR/wai-aria-1.1/#aria-colindex) and [`aria-rowspan`](https://www.w3.org/TR/wai-aria-1.1/#aria-rowspan)."}},{name:"aria-controls",references:[{name:"WAI-ARIA Reference",url:"https://www.w3.org/TR/wai-aria-1.1/#aria-controls"}],description:{kind:"markdown",value:"Identifies the [element](https://www.w3.org/TR/wai-aria-1.1/#dfn-element) (or elements) whose contents or presence are controlled by the current element. See related [`aria-owns`](https://www.w3.org/TR/wai-aria-1.1/#aria-owns)."}},{name:"aria-current",valueSet:"current",references:[{name:"WAI-ARIA Reference",url:"https://www.w3.org/TR/wai-aria-1.1/#aria-current"}],description:{kind:"markdown",value:"Indicates the [element](https://www.w3.org/TR/wai-aria-1.1/#dfn-element) that represents the current item within a container or set of related elements."}},{name:"aria-describedat",references:[{name:"WAI-ARIA Reference",url:"https://www.w3.org/TR/wai-aria-1.1/#aria-describedat"}]},{name:"aria-describedby",references:[{name:"WAI-ARIA Reference",url:"https://www.w3.org/TR/wai-aria-1.1/#aria-describedby"}],description:{kind:"markdown",value:"Identifies the [element](https://www.w3.org/TR/wai-aria-1.1/#dfn-element) (or elements) that describes the [object](https://www.w3.org/TR/wai-aria-1.1/#dfn-object). See related [`aria-labelledby`](https://www.w3.org/TR/wai-aria-1.1/#aria-labelledby)."}},{name:"aria-disabled",valueSet:"b",references:[{name:"WAI-ARIA Reference",url:"https://www.w3.org/TR/wai-aria-1.1/#aria-disabled"}],description:{kind:"markdown",value:"Indicates that the [element](https://www.w3.org/TR/wai-aria-1.1/#dfn-element) is [perceivable](https://www.w3.org/TR/wai-aria-1.1/#dfn-perceivable) but disabled, so it is not editable or otherwise [operable](https://www.w3.org/TR/wai-aria-1.1/#dfn-operable). See related [`aria-hidden`](https://www.w3.org/TR/wai-aria-1.1/#aria-hidden) and [`aria-readonly`](https://www.w3.org/TR/wai-aria-1.1/#aria-readonly)."}},{name:"aria-dropeffect",valueSet:"dropeffect",references:[{name:"WAI-ARIA Reference",url:"https://www.w3.org/TR/wai-aria-1.1/#aria-dropeffect"}],description:{kind:"markdown",value:"\\[Deprecated in ARIA 1.1\\] Indicates what functions can be performed when a dragged object is released on the drop target."}},{name:"aria-errormessage",references:[{name:"WAI-ARIA Reference",url:"https://www.w3.org/TR/wai-aria-1.1/#aria-errormessage"}],description:{kind:"markdown",value:"Identifies the [element](https://www.w3.org/TR/wai-aria-1.1/#dfn-element) that provides an error message for the [object](https://www.w3.org/TR/wai-aria-1.1/#dfn-object). See related [`aria-invalid`](https://www.w3.org/TR/wai-aria-1.1/#aria-invalid) and [`aria-describedby`](https://www.w3.org/TR/wai-aria-1.1/#aria-describedby)."}},{name:"aria-expanded",valueSet:"u",references:[{name:"WAI-ARIA Reference",url:"https://www.w3.org/TR/wai-aria-1.1/#aria-expanded"}],description:{kind:"markdown",value:"Indicates whether the element, or another grouping element it controls, is currently expanded or collapsed."}},{name:"aria-flowto",references:[{name:"WAI-ARIA Reference",url:"https://www.w3.org/TR/wai-aria-1.1/#aria-flowto"}],description:{kind:"markdown",value:"Identifies the next [element](https://www.w3.org/TR/wai-aria-1.1/#dfn-element) (or elements) in an alternate reading order of content which, at the user's discretion, allows assistive technology to override the general default of reading in document source order."}},{name:"aria-grabbed",valueSet:"u",references:[{name:"WAI-ARIA Reference",url:"https://www.w3.org/TR/wai-aria-1.1/#aria-grabbed"}],description:{kind:"markdown",value:'\\[Deprecated in ARIA 1.1\\] Indicates an element\'s "grabbed" [state](https://www.w3.org/TR/wai-aria-1.1/#dfn-state) in a drag-and-drop operation.'}},{name:"aria-haspopup",valueSet:"haspopup",references:[{name:"WAI-ARIA Reference",url:"https://www.w3.org/TR/wai-aria-1.1/#aria-haspopup"}],description:{kind:"markdown",value:"Indicates the availability and type of interactive popup element, such as menu or dialog, that can be triggered by an [element](https://www.w3.org/TR/wai-aria-1.1/#dfn-element)."}},{name:"aria-hidden",valueSet:"b",references:[{name:"WAI-ARIA Reference",url:"https://www.w3.org/TR/wai-aria-1.1/#aria-hidden"}],description:{kind:"markdown",value:"Indicates whether the [element](https://www.w3.org/TR/wai-aria-1.1/#dfn-element) is exposed to an accessibility API. See related [`aria-disabled`](https://www.w3.org/TR/wai-aria-1.1/#aria-disabled)."}},{name:"aria-invalid",valueSet:"invalid",references:[{name:"WAI-ARIA Reference",url:"https://www.w3.org/TR/wai-aria-1.1/#aria-invalid"}],description:{kind:"markdown",value:"Indicates the entered value does not conform to the format expected by the application. See related [`aria-errormessage`](https://www.w3.org/TR/wai-aria-1.1/#aria-errormessage)."}},{name:"aria-kbdshortcuts",references:[{name:"WAI-ARIA Reference",url:"https://www.w3.org/TR/wai-aria-1.1/#aria-kbdshortcuts"}]},{name:"aria-label",references:[{name:"WAI-ARIA Reference",url:"https://www.w3.org/TR/wai-aria-1.1/#aria-label"}],description:{kind:"markdown",value:"Defines a string value that labels the current element. See related [`aria-labelledby`](https://www.w3.org/TR/wai-aria-1.1/#aria-labelledby)."}},{name:"aria-labelledby",references:[{name:"WAI-ARIA Reference",url:"https://www.w3.org/TR/wai-aria-1.1/#aria-labelledby"}],description:{kind:"markdown",value:"Identifies the [element](https://www.w3.org/TR/wai-aria-1.1/#dfn-element) (or elements) that labels the current element. See related [`aria-describedby`](https://www.w3.org/TR/wai-aria-1.1/#aria-describedby)."}},{name:"aria-level",references:[{name:"WAI-ARIA Reference",url:"https://www.w3.org/TR/wai-aria-1.1/#aria-level"}],description:{kind:"markdown",value:"Defines the hierarchical level of an [element](https://www.w3.org/TR/wai-aria-1.1/#dfn-element) within a structure."}},{name:"aria-live",valueSet:"live",references:[{name:"WAI-ARIA Reference",url:"https://www.w3.org/TR/wai-aria-1.1/#aria-live"}],description:{kind:"markdown",value:"Indicates that an [element](https://www.w3.org/TR/wai-aria-1.1/#dfn-element) will be updated, and describes the types of updates the [user agents](https://www.w3.org/TR/wai-aria-1.1/#dfn-user-agent), [assistive technologies](https://www.w3.org/TR/wai-aria-1.1/#dfn-assistive-technology), and user can expect from the [live region](https://www.w3.org/TR/wai-aria-1.1/#dfn-live-region)."}},{name:"aria-modal",valueSet:"b",references:[{name:"WAI-ARIA Reference",url:"https://www.w3.org/TR/wai-aria-1.1/#aria-modal"}],description:{kind:"markdown",value:"Indicates whether an [element](https://www.w3.org/TR/wai-aria-1.1/#dfn-element) is modal when displayed."}},{name:"aria-multiline",valueSet:"b",references:[{name:"WAI-ARIA Reference",url:"https://www.w3.org/TR/wai-aria-1.1/#aria-multiline"}],description:{kind:"markdown",value:"Indicates whether a text box accepts multiple lines of input or only a single line."}},{name:"aria-multiselectable",valueSet:"b",references:[{name:"WAI-ARIA Reference",url:"https://www.w3.org/TR/wai-aria-1.1/#aria-multiselectable"}],description:{kind:"markdown",value:"Indicates that the user may select more than one item from the current selectable descendants."}},{name:"aria-orientation",valueSet:"orientation",references:[{name:"WAI-ARIA Reference",url:"https://www.w3.org/TR/wai-aria-1.1/#aria-orientation"}],description:{kind:"markdown",value:"Indicates whether the element's orientation is horizontal, vertical, or unknown/ambiguous."}},{name:"aria-owns",references:[{name:"WAI-ARIA Reference",url:"https://www.w3.org/TR/wai-aria-1.1/#aria-owns"}],description:{kind:"markdown",value:"Identifies an [element](https://www.w3.org/TR/wai-aria-1.1/#dfn-element) (or elements) in order to define a visual, functional, or contextual parent/child [relationship](https://www.w3.org/TR/wai-aria-1.1/#dfn-relationship) between DOM elements where the DOM hierarchy cannot be used to represent the relationship. See related [`aria-controls`](https://www.w3.org/TR/wai-aria-1.1/#aria-controls)."}},{name:"aria-placeholder",references:[{name:"WAI-ARIA Reference",url:"https://www.w3.org/TR/wai-aria-1.1/#aria-placeholder"}],description:{kind:"markdown",value:"Defines a short hint (a word or short phrase) intended to aid the user with data entry when the control has no value. A hint could be a sample value or a brief description of the expected format."}},{name:"aria-posinset",references:[{name:"WAI-ARIA Reference",url:"https://www.w3.org/TR/wai-aria-1.1/#aria-posinset"}],description:{kind:"markdown",value:"Defines an [element](https://www.w3.org/TR/wai-aria-1.1/#dfn-element)'s number or position in the current set of listitems or treeitems. Not required if all elements in the set are present in the DOM. See related [`aria-setsize`](https://www.w3.org/TR/wai-aria-1.1/#aria-setsize)."}},{name:"aria-pressed",valueSet:"tristate",references:[{name:"WAI-ARIA Reference",url:"https://www.w3.org/TR/wai-aria-1.1/#aria-pressed"}],description:{kind:"markdown",value:'Indicates the current "pressed" [state](https://www.w3.org/TR/wai-aria-1.1/#dfn-state) of toggle buttons. See related [`aria-checked`](https://www.w3.org/TR/wai-aria-1.1/#aria-checked) and [`aria-selected`](https://www.w3.org/TR/wai-aria-1.1/#aria-selected).'}},{name:"aria-readonly",valueSet:"b",references:[{name:"WAI-ARIA Reference",url:"https://www.w3.org/TR/wai-aria-1.1/#aria-readonly"}],description:{kind:"markdown",value:"Indicates that the [element](https://www.w3.org/TR/wai-aria-1.1/#dfn-element) is not editable, but is otherwise [operable](https://www.w3.org/TR/wai-aria-1.1/#dfn-operable). See related [`aria-disabled`](https://www.w3.org/TR/wai-aria-1.1/#aria-disabled)."}},{name:"aria-relevant",valueSet:"relevant",references:[{name:"WAI-ARIA Reference",url:"https://www.w3.org/TR/wai-aria-1.1/#aria-relevant"}],description:{kind:"markdown",value:"Indicates what notifications the user agent will trigger when the accessibility tree within a live region is modified. See related [`aria-atomic`](https://www.w3.org/TR/wai-aria-1.1/#aria-atomic)."}},{name:"aria-required",valueSet:"b",references:[{name:"WAI-ARIA Reference",url:"https://www.w3.org/TR/wai-aria-1.1/#aria-required"}],description:{kind:"markdown",value:"Indicates that user input is required on the [element](https://www.w3.org/TR/wai-aria-1.1/#dfn-element) before a form may be submitted."}},{name:"aria-roledescription",references:[{name:"WAI-ARIA Reference",url:"https://www.w3.org/TR/wai-aria-1.1/#aria-roledescription"}],description:{kind:"markdown",value:"Defines a human-readable, author-localized description for the [role](https://www.w3.org/TR/wai-aria-1.1/#dfn-role) of an [element](https://www.w3.org/TR/wai-aria-1.1/#dfn-element)."}},{name:"aria-rowcount",references:[{name:"WAI-ARIA Reference",url:"https://www.w3.org/TR/wai-aria-1.1/#aria-rowcount"}],description:{kind:"markdown",value:"Defines the total number of rows in a [`table`](https://www.w3.org/TR/wai-aria-1.1/#table), [`grid`](https://www.w3.org/TR/wai-aria-1.1/#grid), or [`treegrid`](https://www.w3.org/TR/wai-aria-1.1/#treegrid). See related [`aria-rowindex`](https://www.w3.org/TR/wai-aria-1.1/#aria-rowindex)."}},{name:"aria-rowindex",references:[{name:"WAI-ARIA Reference",url:"https://www.w3.org/TR/wai-aria-1.1/#aria-rowindex"}],description:{kind:"markdown",value:"Defines an [element's](https://www.w3.org/TR/wai-aria-1.1/#dfn-element) row index or position with respect to the total number of rows within a [`table`](https://www.w3.org/TR/wai-aria-1.1/#table), [`grid`](https://www.w3.org/TR/wai-aria-1.1/#grid), or [`treegrid`](https://www.w3.org/TR/wai-aria-1.1/#treegrid). See related [`aria-rowcount`](https://www.w3.org/TR/wai-aria-1.1/#aria-rowcount) and [`aria-rowspan`](https://www.w3.org/TR/wai-aria-1.1/#aria-rowspan)."}},{name:"aria-rowspan",references:[{name:"WAI-ARIA Reference",url:"https://www.w3.org/TR/wai-aria-1.1/#aria-rowspan"}],description:{kind:"markdown",value:"Defines the number of rows spanned by a cell or gridcell within a [`table`](https://www.w3.org/TR/wai-aria-1.1/#table), [`grid`](https://www.w3.org/TR/wai-aria-1.1/#grid), or [`treegrid`](https://www.w3.org/TR/wai-aria-1.1/#treegrid). See related [`aria-rowindex`](https://www.w3.org/TR/wai-aria-1.1/#aria-rowindex) and [`aria-colspan`](https://www.w3.org/TR/wai-aria-1.1/#aria-colspan)."}},{name:"aria-selected",valueSet:"u",references:[{name:"WAI-ARIA Reference",url:"https://www.w3.org/TR/wai-aria-1.1/#aria-selected"}],description:{kind:"markdown",value:'Indicates the current "selected" [state](https://www.w3.org/TR/wai-aria-1.1/#dfn-state) of various [widgets](https://www.w3.org/TR/wai-aria-1.1/#dfn-widget). See related [`aria-checked`](https://www.w3.org/TR/wai-aria-1.1/#aria-checked) and [`aria-pressed`](https://www.w3.org/TR/wai-aria-1.1/#aria-pressed).'}},{name:"aria-setsize",references:[{name:"WAI-ARIA Reference",url:"https://www.w3.org/TR/wai-aria-1.1/#aria-setsize"}],description:{kind:"markdown",value:"Defines the number of items in the current set of listitems or treeitems. Not required if all elements in the set are present in the DOM. See related [`aria-posinset`](https://www.w3.org/TR/wai-aria-1.1/#aria-posinset)."}},{name:"aria-sort",valueSet:"sort",references:[{name:"WAI-ARIA Reference",url:"https://www.w3.org/TR/wai-aria-1.1/#aria-sort"}],description:{kind:"markdown",value:"Indicates if items in a table or grid are sorted in ascending or descending order."}},{name:"aria-valuemax",references:[{name:"WAI-ARIA Reference",url:"https://www.w3.org/TR/wai-aria-1.1/#aria-valuemax"}],description:{kind:"markdown",value:"Defines the maximum allowed value for a range [widget](https://www.w3.org/TR/wai-aria-1.1/#dfn-widget)."}},{name:"aria-valuemin",references:[{name:"WAI-ARIA Reference",url:"https://www.w3.org/TR/wai-aria-1.1/#aria-valuemin"}],description:{kind:"markdown",value:"Defines the minimum allowed value for a range [widget](https://www.w3.org/TR/wai-aria-1.1/#dfn-widget)."}},{name:"aria-valuenow",references:[{name:"WAI-ARIA Reference",url:"https://www.w3.org/TR/wai-aria-1.1/#aria-valuenow"}],description:{kind:"markdown",value:"Defines the current value for a range [widget](https://www.w3.org/TR/wai-aria-1.1/#dfn-widget). See related [`aria-valuetext`](https://www.w3.org/TR/wai-aria-1.1/#aria-valuetext)."}},{name:"aria-valuetext",references:[{name:"WAI-ARIA Reference",url:"https://www.w3.org/TR/wai-aria-1.1/#aria-valuetext"}],description:{kind:"markdown",value:"Defines the human readable text alternative of [`aria-valuenow`](https://www.w3.org/TR/wai-aria-1.1/#aria-valuenow) for a range [widget](https://www.w3.org/TR/wai-aria-1.1/#dfn-widget)."}},{name:"aria-details",description:{kind:"markdown",value:"Identifies the [element](https://www.w3.org/TR/wai-aria-1.1/#dfn-element) that provides a detailed, extended description for the [object](https://www.w3.org/TR/wai-aria-1.1/#dfn-object). See related [`aria-describedby`](https://www.w3.org/TR/wai-aria-1.1/#aria-describedby)."}},{name:"aria-keyshortcuts",description:{kind:"markdown",value:"Indicates keyboard shortcuts that an author has implemented to activate or give focus to an element."}}],valueSets:[{name:"b",values:[{name:"true"},{name:"false"}]},{name:"u",values:[{name:"true"},{name:"false"},{name:"undefined"}]},{name:"o",values:[{name:"on"},{name:"off"}]},{name:"y",values:[{name:"yes"},{name:"no"}]},{name:"w",values:[{name:"soft"},{name:"hard"}]},{name:"d",values:[{name:"ltr"},{name:"rtl"},{name:"auto"}]},{name:"m",values:[{name:"get",description:{kind:"markdown",value:"Corresponds to the HTTP [GET method](https://www.w3.org/Protocols/rfc2616/rfc2616-sec9.html#sec9.3); form data are appended to the `action` attribute URI with a '?' as separator, and the resulting URI is sent to the server. Use this method when the form has no side-effects and contains only ASCII characters."}},{name:"post",description:{kind:"markdown",value:"Corresponds to the HTTP [POST method](https://www.w3.org/Protocols/rfc2616/rfc2616-sec9.html#sec9.5); form data are included in the body of the form and sent to the server."}},{name:"dialog",description:{kind:"markdown",value:"Use when the form is inside a [`<dialog>`](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/dialog) element to close the dialog when submitted."}}]},{name:"fm",values:[{name:"get"},{name:"post"}]},{name:"s",values:[{name:"row"},{name:"col"},{name:"rowgroup"},{name:"colgroup"}]},{name:"t",values:[{name:"hidden"},{name:"text"},{name:"search"},{name:"tel"},{name:"url"},{name:"email"},{name:"password"},{name:"datetime"},{name:"date"},{name:"month"},{name:"week"},{name:"time"},{name:"datetime-local"},{name:"number"},{name:"range"},{name:"color"},{name:"checkbox"},{name:"radio"},{name:"file"},{name:"submit"},{name:"image"},{name:"reset"},{name:"button"}]},{name:"im",values:[{name:"verbatim"},{name:"latin"},{name:"latin-name"},{name:"latin-prose"},{name:"full-width-latin"},{name:"kana"},{name:"kana-name"},{name:"katakana"},{name:"numeric"},{name:"tel"},{name:"email"},{name:"url"}]},{name:"bt",values:[{name:"button"},{name:"submit"},{name:"reset"},{name:"menu"}]},{name:"lt",values:[{name:"1"},{name:"a"},{name:"A"},{name:"i"},{name:"I"}]},{name:"mt",values:[{name:"context"},{name:"toolbar"}]},{name:"mit",values:[{name:"command"},{name:"checkbox"},{name:"radio"}]},{name:"et",values:[{name:"application/x-www-form-urlencoded"},{name:"multipart/form-data"},{name:"text/plain"}]},{name:"tk",values:[{name:"subtitles"},{name:"captions"},{name:"descriptions"},{name:"chapters"},{name:"metadata"}]},{name:"pl",values:[{name:"none"},{name:"metadata"},{name:"auto"}]},{name:"sh",values:[{name:"circle"},{name:"default"},{name:"poly"},{name:"rect"}]},{name:"xo",values:[{name:"anonymous"},{name:"use-credentials"}]},{name:"sb",values:[{name:"allow-forms"},{name:"allow-modals"},{name:"allow-pointer-lock"},{name:"allow-popups"},{name:"allow-popups-to-escape-sandbox"},{name:"allow-same-origin"},{name:"allow-scripts"},{name:"allow-top-navigation"}]},{name:"tristate",values:[{name:"true"},{name:"false"},{name:"mixed"},{name:"undefined"}]},{name:"inputautocomplete",values:[{name:"additional-name"},{name:"address-level1"},{name:"address-level2"},{name:"address-level3"},{name:"address-level4"},{name:"address-line1"},{name:"address-line2"},{name:"address-line3"},{name:"bday"},{name:"bday-year"},{name:"bday-day"},{name:"bday-month"},{name:"billing"},{name:"cc-additional-name"},{name:"cc-csc"},{name:"cc-exp"},{name:"cc-exp-month"},{name:"cc-exp-year"},{name:"cc-family-name"},{name:"cc-given-name"},{name:"cc-name"},{name:"cc-number"},{name:"cc-type"},{name:"country"},{name:"country-name"},{name:"current-password"},{name:"email"},{name:"family-name"},{name:"fax"},{name:"given-name"},{name:"home"},{name:"honorific-prefix"},{name:"honorific-suffix"},{name:"impp"},{name:"language"},{name:"mobile"},{name:"name"},{name:"new-password"},{name:"nickname"},{name:"organization"},{name:"organization-title"},{name:"pager"},{name:"photo"},{name:"postal-code"},{name:"sex"},{name:"shipping"},{name:"street-address"},{name:"tel-area-code"},{name:"tel"},{name:"tel-country-code"},{name:"tel-extension"},{name:"tel-local"},{name:"tel-local-prefix"},{name:"tel-local-suffix"},{name:"tel-national"},{name:"transaction-amount"},{name:"transaction-currency"},{name:"url"},{name:"username"},{name:"work"}]},{name:"autocomplete",values:[{name:"inline"},{name:"list"},{name:"both"},{name:"none"}]},{name:"current",values:[{name:"page"},{name:"step"},{name:"location"},{name:"date"},{name:"time"},{name:"true"},{name:"false"}]},{name:"dropeffect",values:[{name:"copy"},{name:"move"},{name:"link"},{name:"execute"},{name:"popup"},{name:"none"}]},{name:"invalid",values:[{name:"grammar"},{name:"false"},{name:"spelling"},{name:"true"}]},{name:"live",values:[{name:"off"},{name:"polite"},{name:"assertive"}]},{name:"orientation",values:[{name:"vertical"},{name:"horizontal"},{name:"undefined"}]},{name:"relevant",values:[{name:"additions"},{name:"removals"},{name:"text"},{name:"all"},{name:"additions text"}]},{name:"sort",values:[{name:"ascending"},{name:"descending"},{name:"none"},{name:"other"}]},{name:"roles",values:[{name:"alert"},{name:"alertdialog"},{name:"button"},{name:"checkbox"},{name:"dialog"},{name:"gridcell"},{name:"link"},{name:"log"},{name:"marquee"},{name:"menuitem"},{name:"menuitemcheckbox"},{name:"menuitemradio"},{name:"option"},{name:"progressbar"},{name:"radio"},{name:"scrollbar"},{name:"searchbox"},{name:"slider"},{name:"spinbutton"},{name:"status"},{name:"switch"},{name:"tab"},{name:"tabpanel"},{name:"textbox"},{name:"timer"},{name:"tooltip"},{name:"treeitem"},{name:"combobox"},{name:"grid"},{name:"listbox"},{name:"menu"},{name:"menubar"},{name:"radiogroup"},{name:"tablist"},{name:"tree"},{name:"treegrid"},{name:"application"},{name:"article"},{name:"cell"},{name:"columnheader"},{name:"definition"},{name:"directory"},{name:"document"},{name:"feed"},{name:"figure"},{name:"group"},{name:"heading"},{name:"img"},{name:"list"},{name:"listitem"},{name:"math"},{name:"none"},{name:"note"},{name:"presentation"},{name:"region"},{name:"row"},{name:"rowgroup"},{name:"rowheader"},{name:"separator"},{name:"table"},{name:"term"},{name:"text"},{name:"toolbar"},{name:"banner"},{name:"complementary"},{name:"contentinfo"},{name:"form"},{name:"main"},{name:"navigation"},{name:"region"},{name:"search"},{name:"doc-abstract"},{name:"doc-acknowledgments"},{name:"doc-afterword"},{name:"doc-appendix"},{name:"doc-backlink"},{name:"doc-biblioentry"},{name:"doc-bibliography"},{name:"doc-biblioref"},{name:"doc-chapter"},{name:"doc-colophon"},{name:"doc-conclusion"},{name:"doc-cover"},{name:"doc-credit"},{name:"doc-credits"},{name:"doc-dedication"},{name:"doc-endnote"},{name:"doc-endnotes"},{name:"doc-epigraph"},{name:"doc-epilogue"},{name:"doc-errata"},{name:"doc-example"},{name:"doc-footnote"},{name:"doc-foreword"},{name:"doc-glossary"},{name:"doc-glossref"},{name:"doc-index"},{name:"doc-introduction"},{name:"doc-noteref"},{name:"doc-notice"},{name:"doc-pagebreak"},{name:"doc-pagelist"},{name:"doc-part"},{name:"doc-preface"},{name:"doc-prologue"},{name:"doc-pullquote"},{name:"doc-qna"},{name:"doc-subtitle"},{name:"doc-tip"},{name:"doc-toc"}]},{name:"metanames",values:[{name:"application-name"},{name:"author"},{name:"description"},{name:"format-detection"},{name:"generator"},{name:"keywords"},{name:"publisher"},{name:"referrer"},{name:"robots"},{name:"theme-color"},{name:"viewport"}]},{name:"haspopup",values:[{name:"false",description:{kind:"markdown",value:"(default) Indicates the element does not have a popup."}},{name:"true",description:{kind:"markdown",value:"Indicates the popup is a menu."}},{name:"menu",description:{kind:"markdown",value:"Indicates the popup is a menu."}},{name:"listbox",description:{kind:"markdown",value:"Indicates the popup is a listbox."}},{name:"tree",description:{kind:"markdown",value:"Indicates the popup is a tree."}},{name:"grid",description:{kind:"markdown",value:"Indicates the popup is a grid."}},{name:"dialog",description:{kind:"markdown",value:"Indicates the popup is a dialog."}}]}]},In=function(){function t(_){this.dataProviders=[],this.setDataProviders(!1!==_.useDefaultDataProvider,_.customDataProviders||[])}return t.prototype.setDataProviders=function(_,S){var x;this.dataProviders=[],_&&this.dataProviders.push(new Qt("html5",Cn)),(x=this.dataProviders).push.apply(x,S)},t.prototype.getDataProviders=function(){return this.dataProviders},t}(),Wn={};function Sn(_,S){return new Qt(_,S)}var Dn=class{_ctx;_languageService;_languageSettings;_languageId;constructor(_,S){this._ctx=_,this._languageSettings=S.languageSettings,this._languageId=S.languageId;let x=this._languageSettings.data,L=x?.useDefaultDataProvider,z=[];if(x?.dataProviders)for(let _ in x.dataProviders)z.push(Sn(_,x.dataProviders[_]));this._languageService=function kn(_){void 0===_&&(_=Wn);var S=new In(_),x=new xn(_,S),L=new ln(_,S);return{setDataProviders:S.setDataProviders.bind(S),createScanner:$,parseHTMLDocument:function(_){return je(_.getText())},doComplete:L.doComplete.bind(L),doComplete2:L.doComplete2.bind(L),setCompletionParticipants:L.setCompletionParticipants.bind(L),doHover:x.doHover.bind(x),format:sn,findDocumentHighlights:mn,findDocumentLinks:cn,findDocumentSymbols:fn,getFoldingRanges:wn,getSelectionRanges:yn,doQuoteComplete:L.doQuoteComplete.bind(L),doTagComplete:L.doTagComplete.bind(L),doRename:bn,findMatchingTagPosition:vn,findOnTypeRenameRanges:ft,findLinkedEditingRanges:ft}}({useDefaultDataProvider:L,customDataProviders:z})}async doComplete(_,S){let x=this._getTextDocument(_);if(!x)return null;let L=this._languageService.parseHTMLDocument(x);return Promise.resolve(this._languageService.doComplete(x,S,L,this._languageSettings&&this._languageSettings.suggest))}async format(_,S,x){let L=this._getTextDocument(_);if(!L)return[];let z={...this._languageSettings.format,...x},C=this._languageService.format(L,S,z);return Promise.resolve(C)}async doHover(_,S){let x=this._getTextDocument(_);if(!x)return null;let L=this._languageService.parseHTMLDocument(x),z=this._languageService.doHover(x,S,L);return Promise.resolve(z)}async findDocumentHighlights(_,S){let x=this._getTextDocument(_);if(!x)return[];let L=this._languageService.parseHTMLDocument(x),z=this._languageService.findDocumentHighlights(x,S,L);return Promise.resolve(z)}async findDocumentLinks(_){let S=this._getTextDocument(_);if(!S)return[];let x=this._languageService.findDocumentLinks(S,null);return Promise.resolve(x)}async findDocumentSymbols(_){let S=this._getTextDocument(_);if(!S)return[];let x=this._languageService.parseHTMLDocument(S),L=this._languageService.findDocumentSymbols(S,x);return Promise.resolve(L)}async getFoldingRanges(_,S){let x=this._getTextDocument(_);if(!x)return[];let L=this._languageService.getFoldingRanges(x,S);return Promise.resolve(L)}async getSelectionRanges(_,S){let x=this._getTextDocument(_);if(!x)return[];let L=this._languageService.getSelectionRanges(x,S);return Promise.resolve(L)}async doRename(_,S,x){let L=this._getTextDocument(_);if(!L)return null;let z=this._languageService.parseHTMLDocument(L),C=this._languageService.doRename(L,S,x,z);return Promise.resolve(C)}_getTextDocument(_){let S=this._ctx.getMirrorModels();for(let x of S)if(x.uri.toString()===_)return ot.create(_,this._languageId,x.version,x.getValue());return null}};function Ri(_,S){return new Dn(_,S)}return we(ve)})()));