/*!-----------------------------------------------------------------------------
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Version: 0.32.1(29a273516805a852aa8edc5e05059f119b13eff0)
 * Released under the MIT license
 * https://github.com/microsoft/monaco-editor/blob/main/LICENSE.txt
 *-----------------------------------------------------------------------------*/
define("vs/language/html/htmlMode",["require","require"],(s=>(()=>{var c,d=Object.create,p=Object.defineProperty,m=Object.getOwnPropertyDescriptor,v=Object.getOwnPropertyNames,_=Object.getPrototypeOf,w=Object.prototype.hasOwnProperty,le=s=>p(s,"__esModule",{value:!0}),b=(c=function(c){if(void 0!==s)return s.apply(this,arguments);throw new Error('Dynamic require of "'+c+'" is not supported')},void 0!==s?s:"undefined"!=typeof Proxy?new Proxy(c,{get:(c,d)=>(void 0!==s?s:c)[d]}):c),q=(s,c,d,_)=>{if(c&&"object"==typeof c||"function"==typeof c)for(let b of v(c))!w.call(s,b)&&(d||"default"!==b)&&p(s,b,{get:()=>c[b],enumerable:!(_=m(c,b))||_.enumerable});return s},ge=(s,c)=>q(le(p(null!=s?d(_(s)):{},"default",!c&&s&&s.__esModule?{get:()=>s.default,enumerable:!0}:{value:s,enumerable:!0})),s),E=(s=>(c,d)=>s&&s.get(c)||(d=q(le({}),c,1),s&&s.set(c,d),d))("undefined"!=typeof WeakMap?new WeakMap:0),x=((s,c)=>()=>(c||s((c={exports:{}}).exports,c),c.exports))(((s,c)=>{var d=ge(b("vs/editor/editor.api"));c.exports=d})),I={};((s,c)=>{for(var d in c)p(s,d,{get:c[d],enumerable:!0})})(I,{CompletionAdapter:()=>He,DefinitionAdapter:()=>Xe,DiagnosticsAdapter:()=>Ve,DocumentColorAdapter:()=>nt,DocumentFormattingEditProvider:()=>et,DocumentHighlightAdapter:()=>ze,DocumentLinkAdapter:()=>Ye,DocumentRangeFormattingEditProvider:()=>tt,DocumentSymbolAdapter:()=>Ge,FoldingRangeAdapter:()=>rt,HoverAdapter:()=>Ke,ReferenceAdapter:()=>qe,RenameAdapter:()=>$e,SelectionRangeAdapter:()=>it,WorkerManager:()=>ne,fromPosition:()=>C,fromRange:()=>ue,setupMode:()=>Rn,setupMode1:()=>En,toRange:()=>y,toTextEdit:()=>D});var A={};q(A,ge(x()));var S,R,T,P,M,L,F,j,O,N,W,U,V,H,K,z,B,X,Q,J,Z,$,G,Y,ee,te,ne=class{_defaults;_idleCheckInterval;_lastUsedTime;_configChangeListener;_worker;_client;constructor(s){this._defaults=s,this._worker=null,this._client=null,this._idleCheckInterval=window.setInterval((()=>this._checkIfIdle()),3e4),this._lastUsedTime=0,this._configChangeListener=this._defaults.onDidChange((()=>this._stopWorker()))}_stopWorker(){this._worker&&(this._worker.dispose(),this._worker=null),this._client=null}dispose(){clearInterval(this._idleCheckInterval),this._configChangeListener.dispose(),this._stopWorker()}_checkIfIdle(){this._worker&&Date.now()-this._lastUsedTime>12e4&&this._stopWorker()}_getClient(){return this._lastUsedTime=Date.now(),this._client||(this._worker=A.editor.createWebWorker({moduleId:"vs/language/html/htmlWorker",createData:{languageSettings:this._defaults.options,languageId:this._defaults.languageId},label:this._defaults.languageId}),this._client=this._worker.getProxy()),this._client}getLanguageServiceWorker(...s){let c;return this._getClient().then((s=>{c=s})).then((c=>{if(this._worker)return this._worker.withSyncedResources(s)})).then((s=>c))}};!function(s){s.MIN_VALUE=-2147483648,s.MAX_VALUE=2147483647}(S||(S={})),function(s){s.MIN_VALUE=0,s.MAX_VALUE=2147483647}(R||(R={})),function(s){s.create=function t(s,c){return s===Number.MAX_VALUE&&(s=R.MAX_VALUE),c===Number.MAX_VALUE&&(c=R.MAX_VALUE),{line:s,character:c}},s.is=function i(s){var c=s;return We.objectLiteral(c)&&We.uinteger(c.line)&&We.uinteger(c.character)}}(T||(T={})),function(s){s.create=function t(s,c,d,p){if(We.uinteger(s)&&We.uinteger(c)&&We.uinteger(d)&&We.uinteger(p))return{start:T.create(s,c),end:T.create(d,p)};if(T.is(s)&&T.is(c))return{start:s,end:c};throw new Error("Range#create called with invalid arguments["+s+", "+c+", "+d+", "+p+"]")},s.is=function i(s){var c=s;return We.objectLiteral(c)&&T.is(c.start)&&T.is(c.end)}}(P||(P={})),function(s){s.create=function t(s,c){return{uri:s,range:c}},s.is=function i(s){var c=s;return We.defined(c)&&P.is(c.range)&&(We.string(c.uri)||We.undefined(c.uri))}}(M||(M={})),function(s){s.create=function t(s,c,d,p){return{targetUri:s,targetRange:c,targetSelectionRange:d,originSelectionRange:p}},s.is=function i(s){var c=s;return We.defined(c)&&P.is(c.targetRange)&&We.string(c.targetUri)&&(P.is(c.targetSelectionRange)||We.undefined(c.targetSelectionRange))&&(P.is(c.originSelectionRange)||We.undefined(c.originSelectionRange))}}(L||(L={})),function(s){s.create=function t(s,c,d,p){return{red:s,green:c,blue:d,alpha:p}},s.is=function i(s){var c=s;return We.numberRange(c.red,0,1)&&We.numberRange(c.green,0,1)&&We.numberRange(c.blue,0,1)&&We.numberRange(c.alpha,0,1)}}(F||(F={})),function(s){s.create=function t(s,c){return{range:s,color:c}},s.is=function i(s){var c=s;return P.is(c.range)&&F.is(c.color)}}(j||(j={})),function(s){s.create=function t(s,c,d){return{label:s,textEdit:c,additionalTextEdits:d}},s.is=function i(s){var c=s;return We.string(c.label)&&(We.undefined(c.textEdit)||X.is(c))&&(We.undefined(c.additionalTextEdits)||We.typedArray(c.additionalTextEdits,X.is))}}(O||(O={})),function(s){s.Comment="comment",s.Imports="imports",s.Region="region"}(N||(N={})),function(s){s.create=function t(s,c,d,p,m){var v={startLine:s,endLine:c};return We.defined(d)&&(v.startCharacter=d),We.defined(p)&&(v.endCharacter=p),We.defined(m)&&(v.kind=m),v},s.is=function i(s){var c=s;return We.uinteger(c.startLine)&&We.uinteger(c.startLine)&&(We.undefined(c.startCharacter)||We.uinteger(c.startCharacter))&&(We.undefined(c.endCharacter)||We.uinteger(c.endCharacter))&&(We.undefined(c.kind)||We.string(c.kind))}}(W||(W={})),function(s){s.create=function t(s,c){return{location:s,message:c}},s.is=function i(s){var c=s;return We.defined(c)&&M.is(c.location)&&We.string(c.message)}}(U||(U={})),function(s){s.Error=1,s.Warning=2,s.Information=3,s.Hint=4}(V||(V={})),function(s){s.Unnecessary=1,s.Deprecated=2}(H||(H={})),function(s){s.is=function t(s){var c=s;return null!=c&&We.string(c.href)}}(K||(K={})),function(s){s.create=function t(s,c,d,p,m,v){var _={range:s,message:c};return We.defined(d)&&(_.severity=d),We.defined(p)&&(_.code=p),We.defined(m)&&(_.source=m),We.defined(v)&&(_.relatedInformation=v),_},s.is=function i(s){var c,d=s;return We.defined(d)&&P.is(d.range)&&We.string(d.message)&&(We.number(d.severity)||We.undefined(d.severity))&&(We.integer(d.code)||We.string(d.code)||We.undefined(d.code))&&(We.undefined(d.codeDescription)||We.string(null===(c=d.codeDescription)||void 0===c?void 0:c.href))&&(We.string(d.source)||We.undefined(d.source))&&(We.undefined(d.relatedInformation)||We.typedArray(d.relatedInformation,U.is))}}(z||(z={})),function(s){s.create=function t(s,c){for(var d=[],p=2;p<arguments.length;p++)d[p-2]=arguments[p];var m={title:s,command:c};return We.defined(d)&&d.length>0&&(m.arguments=d),m},s.is=function i(s){var c=s;return We.defined(c)&&We.string(c.title)&&We.string(c.command)}}(B||(B={})),function(s){s.replace=function t(s,c){return{range:s,newText:c}},s.insert=function i(s,c){return{range:{start:s,end:s},newText:c}},s.del=function r(s){return{range:s,newText:""}},s.is=function e(s){var c=s;return We.objectLiteral(c)&&We.string(c.newText)&&P.is(c.range)}}(X||(X={})),function(s){s.create=function t(s,c,d){var p={label:s};return void 0!==c&&(p.needsConfirmation=c),void 0!==d&&(p.description=d),p},s.is=function i(s){var c=s;return void 0!==c&&We.objectLiteral(c)&&We.string(c.label)&&(We.boolean(c.needsConfirmation)||void 0===c.needsConfirmation)&&(We.string(c.description)||void 0===c.description)}}(Q||(Q={})),function(s){s.is=function t(s){return"string"==typeof s}}(J||(J={})),function(s){s.replace=function t(s,c,d){return{range:s,newText:c,annotationId:d}},s.insert=function i(s,c,d){return{range:{start:s,end:s},newText:c,annotationId:d}},s.del=function r(s,c){return{range:s,newText:"",annotationId:c}},s.is=function e(s){var c=s;return X.is(c)&&(Q.is(c.annotationId)||J.is(c.annotationId))}}(Z||(Z={})),function(s){s.create=function t(s,c){return{textDocument:s,edits:c}},s.is=function i(s){var c=s;return We.defined(c)&&oe.is(c.textDocument)&&Array.isArray(c.edits)}}($||($={})),function(s){s.create=function t(s,c,d){var p={kind:"create",uri:s};return void 0!==c&&(void 0!==c.overwrite||void 0!==c.ignoreIfExists)&&(p.options=c),void 0!==d&&(p.annotationId=d),p},s.is=function i(s){var c=s;return c&&"create"===c.kind&&We.string(c.uri)&&(void 0===c.options||(void 0===c.options.overwrite||We.boolean(c.options.overwrite))&&(void 0===c.options.ignoreIfExists||We.boolean(c.options.ignoreIfExists)))&&(void 0===c.annotationId||J.is(c.annotationId))}}(G||(G={})),function(s){s.create=function t(s,c,d,p){var m={kind:"rename",oldUri:s,newUri:c};return void 0!==d&&(void 0!==d.overwrite||void 0!==d.ignoreIfExists)&&(m.options=d),void 0!==p&&(m.annotationId=p),m},s.is=function i(s){var c=s;return c&&"rename"===c.kind&&We.string(c.oldUri)&&We.string(c.newUri)&&(void 0===c.options||(void 0===c.options.overwrite||We.boolean(c.options.overwrite))&&(void 0===c.options.ignoreIfExists||We.boolean(c.options.ignoreIfExists)))&&(void 0===c.annotationId||J.is(c.annotationId))}}(Y||(Y={})),function(s){s.create=function t(s,c,d){var p={kind:"delete",uri:s};return void 0!==c&&(void 0!==c.recursive||void 0!==c.ignoreIfNotExists)&&(p.options=c),void 0!==d&&(p.annotationId=d),p},s.is=function i(s){var c=s;return c&&"delete"===c.kind&&We.string(c.uri)&&(void 0===c.options||(void 0===c.options.recursive||We.boolean(c.options.recursive))&&(void 0===c.options.ignoreIfNotExists||We.boolean(c.options.ignoreIfNotExists)))&&(void 0===c.annotationId||J.is(c.annotationId))}}(ee||(ee={})),function(s){s.is=function t(s){var c=s;return c&&(void 0!==c.changes||void 0!==c.documentChanges)&&(void 0===c.documentChanges||c.documentChanges.every((function(s){return We.string(s.kind)?G.is(s)||Y.is(s)||ee.is(s):$.is(s)})))}}(te||(te={}));var re,ie,oe,ae,se,ce,de,fe,he,pe,me,ve,_e,we,ye,ke,be,Ce,Ee,xe,Ie,Ae,Se,Re,De,Te,Pe,Me,Le,Fe,je,Oe=function(){function n(s,c){this.edits=s,this.changeAnnotations=c}return n.prototype.insert=function(s,c,d){var p,m;if(void 0===d?p=X.insert(s,c):J.is(d)?(m=d,p=Z.insert(s,c,d)):(this.assertChangeAnnotations(this.changeAnnotations),m=this.changeAnnotations.manage(d),p=Z.insert(s,c,m)),this.edits.push(p),void 0!==m)return m},n.prototype.replace=function(s,c,d){var p,m;if(void 0===d?p=X.replace(s,c):J.is(d)?(m=d,p=Z.replace(s,c,d)):(this.assertChangeAnnotations(this.changeAnnotations),m=this.changeAnnotations.manage(d),p=Z.replace(s,c,m)),this.edits.push(p),void 0!==m)return m},n.prototype.delete=function(s,c){var d,p;if(void 0===c?d=X.del(s):J.is(c)?(p=c,d=Z.del(s,c)):(this.assertChangeAnnotations(this.changeAnnotations),p=this.changeAnnotations.manage(c),d=Z.del(s,p)),this.edits.push(d),void 0!==p)return p},n.prototype.add=function(s){this.edits.push(s)},n.prototype.all=function(){return this.edits},n.prototype.clear=function(){this.edits.splice(0,this.edits.length)},n.prototype.assertChangeAnnotations=function(s){if(void 0===s)throw new Error("Text edit change is not configured to manage change annotations.")},n}(),Ne=function(){function n(s){this._annotations=void 0===s?Object.create(null):s,this._counter=0,this._size=0}return n.prototype.all=function(){return this._annotations},Object.defineProperty(n.prototype,"size",{get:function(){return this._size},enumerable:!1,configurable:!0}),n.prototype.manage=function(s,c){var d;if(J.is(s)?d=s:(d=this.nextId(),c=s),void 0!==this._annotations[d])throw new Error("Id "+d+" is already in use.");if(void 0===c)throw new Error("No annotation provided for id "+d);return this._annotations[d]=c,this._size++,d},n.prototype.nextId=function(){return this._counter++,this._counter.toString()},n}();!function(){function n(s){var c=this;this._textEditChanges=Object.create(null),void 0!==s?(this._workspaceEdit=s,s.documentChanges?(this._changeAnnotations=new Ne(s.changeAnnotations),s.changeAnnotations=this._changeAnnotations.all(),s.documentChanges.forEach((function(s){if($.is(s)){var d=new Oe(s.edits,c._changeAnnotations);c._textEditChanges[s.textDocument.uri]=d}}))):s.changes&&Object.keys(s.changes).forEach((function(d){var p=new Oe(s.changes[d]);c._textEditChanges[d]=p}))):this._workspaceEdit={}}Object.defineProperty(n.prototype,"edit",{get:function(){return this.initDocumentChanges(),void 0!==this._changeAnnotations&&(0===this._changeAnnotations.size?this._workspaceEdit.changeAnnotations=void 0:this._workspaceEdit.changeAnnotations=this._changeAnnotations.all()),this._workspaceEdit},enumerable:!1,configurable:!0}),n.prototype.getTextEditChange=function(s){if(oe.is(s)){if(this.initDocumentChanges(),void 0===this._workspaceEdit.documentChanges)throw new Error("Workspace edit is not configured for document changes.");var c={uri:s.uri,version:s.version};if(!(p=this._textEditChanges[c.uri])){var d={textDocument:c,edits:m=[]};this._workspaceEdit.documentChanges.push(d),p=new Oe(m,this._changeAnnotations),this._textEditChanges[c.uri]=p}return p}if(this.initChanges(),void 0===this._workspaceEdit.changes)throw new Error("Workspace edit is not configured for normal text edit changes.");var p;if(!(p=this._textEditChanges[s])){var m=[];this._workspaceEdit.changes[s]=m,p=new Oe(m),this._textEditChanges[s]=p}return p},n.prototype.initDocumentChanges=function(){void 0===this._workspaceEdit.documentChanges&&void 0===this._workspaceEdit.changes&&(this._changeAnnotations=new Ne,this._workspaceEdit.documentChanges=[],this._workspaceEdit.changeAnnotations=this._changeAnnotations.all())},n.prototype.initChanges=function(){void 0===this._workspaceEdit.documentChanges&&void 0===this._workspaceEdit.changes&&(this._workspaceEdit.changes=Object.create(null))},n.prototype.createFile=function(s,c,d){if(this.initDocumentChanges(),void 0===this._workspaceEdit.documentChanges)throw new Error("Workspace edit is not configured for document changes.");var p,m,v;if(Q.is(c)||J.is(c)?p=c:d=c,void 0===p?m=G.create(s,d):(v=J.is(p)?p:this._changeAnnotations.manage(p),m=G.create(s,d,v)),this._workspaceEdit.documentChanges.push(m),void 0!==v)return v},n.prototype.renameFile=function(s,c,d,p){if(this.initDocumentChanges(),void 0===this._workspaceEdit.documentChanges)throw new Error("Workspace edit is not configured for document changes.");var m,v,_;if(Q.is(d)||J.is(d)?m=d:p=d,void 0===m?v=Y.create(s,c,p):(_=J.is(m)?m:this._changeAnnotations.manage(m),v=Y.create(s,c,p,_)),this._workspaceEdit.documentChanges.push(v),void 0!==_)return _},n.prototype.deleteFile=function(s,c,d){if(this.initDocumentChanges(),void 0===this._workspaceEdit.documentChanges)throw new Error("Workspace edit is not configured for document changes.");var p,m,v;if(Q.is(c)||J.is(c)?p=c:d=c,void 0===p?m=ee.create(s,d):(v=J.is(p)?p:this._changeAnnotations.manage(p),m=ee.create(s,d,v)),this._workspaceEdit.documentChanges.push(m),void 0!==v)return v}}();!function(s){s.create=function t(s){return{uri:s}},s.is=function i(s){var c=s;return We.defined(c)&&We.string(c.uri)}}(re||(re={})),function(s){s.create=function t(s,c){return{uri:s,version:c}},s.is=function i(s){var c=s;return We.defined(c)&&We.string(c.uri)&&We.integer(c.version)}}(ie||(ie={})),function(s){s.create=function t(s,c){return{uri:s,version:c}},s.is=function i(s){var c=s;return We.defined(c)&&We.string(c.uri)&&(null===c.version||We.integer(c.version))}}(oe||(oe={})),function(s){s.create=function t(s,c,d,p){return{uri:s,languageId:c,version:d,text:p}},s.is=function i(s){var c=s;return We.defined(c)&&We.string(c.uri)&&We.string(c.languageId)&&We.integer(c.version)&&We.string(c.text)}}(ae||(ae={})),function(s){s.PlainText="plaintext",s.Markdown="markdown"}(se||(se={})),function(s){s.is=function t(c){var d=c;return d===s.PlainText||d===s.Markdown}}(se||(se={})),function(s){s.is=function t(s){var c=s;return We.objectLiteral(s)&&se.is(c.kind)&&We.string(c.value)}}(ce||(ce={})),function(s){s.Text=1,s.Method=2,s.Function=3,s.Constructor=4,s.Field=5,s.Variable=6,s.Class=7,s.Interface=8,s.Module=9,s.Property=10,s.Unit=11,s.Value=12,s.Enum=13,s.Keyword=14,s.Snippet=15,s.Color=16,s.File=17,s.Reference=18,s.Folder=19,s.EnumMember=20,s.Constant=21,s.Struct=22,s.Event=23,s.Operator=24,s.TypeParameter=25}(de||(de={})),function(s){s.PlainText=1,s.Snippet=2}(fe||(fe={})),function(s){s.Deprecated=1}(he||(he={})),function(s){s.create=function t(s,c,d){return{newText:s,insert:c,replace:d}},s.is=function i(s){var c=s;return c&&We.string(c.newText)&&P.is(c.insert)&&P.is(c.replace)}}(pe||(pe={})),function(s){s.asIs=1,s.adjustIndentation=2}(me||(me={})),function(s){s.create=function t(s){return{label:s}}}(ve||(ve={})),function(s){s.create=function t(s,c){return{items:s||[],isIncomplete:!!c}}}(_e||(_e={})),function(s){s.fromPlainText=function t(s){return s.replace(/[\\`*_{}[\]()#+\-.!]/g,"\\$&")},s.is=function i(s){var c=s;return We.string(c)||We.objectLiteral(c)&&We.string(c.language)&&We.string(c.value)}}(we||(we={})),function(s){s.is=function t(s){var c=s;return!!c&&We.objectLiteral(c)&&(ce.is(c.contents)||we.is(c.contents)||We.typedArray(c.contents,we.is))&&(void 0===s.range||P.is(s.range))}}(ye||(ye={})),function(s){s.create=function t(s,c){return c?{label:s,documentation:c}:{label:s}}}(ke||(ke={})),function(s){s.create=function t(s,c){for(var d=[],p=2;p<arguments.length;p++)d[p-2]=arguments[p];var m={label:s};return We.defined(c)&&(m.documentation=c),We.defined(d)?m.parameters=d:m.parameters=[],m}}(be||(be={})),function(s){s.Text=1,s.Read=2,s.Write=3}(Ce||(Ce={})),function(s){s.create=function t(s,c){var d={range:s};return We.number(c)&&(d.kind=c),d}}(Ee||(Ee={})),function(s){s.File=1,s.Module=2,s.Namespace=3,s.Package=4,s.Class=5,s.Method=6,s.Property=7,s.Field=8,s.Constructor=9,s.Enum=10,s.Interface=11,s.Function=12,s.Variable=13,s.Constant=14,s.String=15,s.Number=16,s.Boolean=17,s.Array=18,s.Object=19,s.Key=20,s.Null=21,s.EnumMember=22,s.Struct=23,s.Event=24,s.Operator=25,s.TypeParameter=26}(xe||(xe={})),function(s){s.Deprecated=1}(Ie||(Ie={})),function(s){s.create=function t(s,c,d,p,m){var v={name:s,kind:c,location:{uri:p,range:d}};return m&&(v.containerName=m),v}}(Ae||(Ae={})),function(s){s.create=function t(s,c,d,p,m,v){var _={name:s,detail:c,kind:d,range:p,selectionRange:m};return void 0!==v&&(_.children=v),_},s.is=function i(s){var c=s;return c&&We.string(c.name)&&We.number(c.kind)&&P.is(c.range)&&P.is(c.selectionRange)&&(void 0===c.detail||We.string(c.detail))&&(void 0===c.deprecated||We.boolean(c.deprecated))&&(void 0===c.children||Array.isArray(c.children))&&(void 0===c.tags||Array.isArray(c.tags))}}(Se||(Se={})),function(s){s.Empty="",s.QuickFix="quickfix",s.Refactor="refactor",s.RefactorExtract="refactor.extract",s.RefactorInline="refactor.inline",s.RefactorRewrite="refactor.rewrite",s.Source="source",s.SourceOrganizeImports="source.organizeImports",s.SourceFixAll="source.fixAll"}(Re||(Re={})),function(s){s.create=function t(s,c){var d={diagnostics:s};return null!=c&&(d.only=c),d},s.is=function i(s){var c=s;return We.defined(c)&&We.typedArray(c.diagnostics,z.is)&&(void 0===c.only||We.typedArray(c.only,We.string))}}(De||(De={})),function(s){s.create=function t(s,c,d){var p={title:s},m=!0;return"string"==typeof c?(m=!1,p.kind=c):B.is(c)?p.command=c:p.edit=c,m&&void 0!==d&&(p.kind=d),p},s.is=function i(s){var c=s;return c&&We.string(c.title)&&(void 0===c.diagnostics||We.typedArray(c.diagnostics,z.is))&&(void 0===c.kind||We.string(c.kind))&&(void 0!==c.edit||void 0!==c.command)&&(void 0===c.command||B.is(c.command))&&(void 0===c.isPreferred||We.boolean(c.isPreferred))&&(void 0===c.edit||te.is(c.edit))}}(Te||(Te={})),function(s){s.create=function t(s,c){var d={range:s};return We.defined(c)&&(d.data=c),d},s.is=function i(s){var c=s;return We.defined(c)&&P.is(c.range)&&(We.undefined(c.command)||B.is(c.command))}}(Pe||(Pe={})),function(s){s.create=function t(s,c){return{tabSize:s,insertSpaces:c}},s.is=function i(s){var c=s;return We.defined(c)&&We.uinteger(c.tabSize)&&We.boolean(c.insertSpaces)}}(Me||(Me={})),function(s){s.create=function t(s,c,d){return{range:s,target:c,data:d}},s.is=function i(s){var c=s;return We.defined(c)&&P.is(c.range)&&(We.undefined(c.target)||We.string(c.target))}}(Le||(Le={})),function(s){s.create=function t(s,c){return{range:s,parent:c}},s.is=function i(c){var d=c;return void 0!==d&&P.is(d.range)&&(void 0===d.parent||s.is(d.parent))}}(Fe||(Fe={})),function(s){function e(s,c){if(s.length<=1)return s;var d=s.length/2|0,p=s.slice(0,d),m=s.slice(d);e(p,c),e(m,c);for(var v=0,_=0,w=0;v<p.length&&_<m.length;){var b=c(p[v],m[_]);s[w++]=b<=0?p[v++]:m[_++]}for(;v<p.length;)s[w++]=p[v++];for(;_<m.length;)s[w++]=m[_++];return s}s.create=function t(s,c,d,p){return new Ue(s,c,d,p)},s.is=function i(s){var c=s;return!!(We.defined(c)&&We.string(c.uri)&&(We.undefined(c.languageId)||We.string(c.languageId))&&We.uinteger(c.lineCount)&&We.func(c.getText)&&We.func(c.positionAt)&&We.func(c.offsetAt))},s.applyEdits=function r(s,c){for(var d=s.getText(),p=e(c,(function(s,c){var d=s.range.start.line-c.range.start.line;return 0===d?s.range.start.character-c.range.start.character:d})),m=d.length,v=p.length-1;v>=0;v--){var _=p[v],w=s.offsetAt(_.range.start),b=s.offsetAt(_.range.end);if(!(b<=m))throw new Error("Overlapping edit");d=d.substring(0,w)+_.newText+d.substring(b,d.length),m=w}return d}}(je||(je={}));var We,Ue=function(){function n(s,c,d,p){this._uri=s,this._languageId=c,this._version=d,this._content=p,this._lineOffsets=void 0}return Object.defineProperty(n.prototype,"uri",{get:function(){return this._uri},enumerable:!1,configurable:!0}),Object.defineProperty(n.prototype,"languageId",{get:function(){return this._languageId},enumerable:!1,configurable:!0}),Object.defineProperty(n.prototype,"version",{get:function(){return this._version},enumerable:!1,configurable:!0}),n.prototype.getText=function(s){if(s){var c=this.offsetAt(s.start),d=this.offsetAt(s.end);return this._content.substring(c,d)}return this._content},n.prototype.update=function(s,c){this._content=s.text,this._version=c,this._lineOffsets=void 0},n.prototype.getLineOffsets=function(){if(void 0===this._lineOffsets){for(var s=[],c=this._content,d=!0,p=0;p<c.length;p++){d&&(s.push(p),d=!1);var m=c.charAt(p);d="\r"===m||"\n"===m,"\r"===m&&p+1<c.length&&"\n"===c.charAt(p+1)&&p++}d&&c.length>0&&s.push(c.length),this._lineOffsets=s}return this._lineOffsets},n.prototype.positionAt=function(s){s=Math.max(Math.min(s,this._content.length),0);var c=this.getLineOffsets(),d=0,p=c.length;if(0===p)return T.create(0,s);for(;d<p;){var m=Math.floor((d+p)/2);c[m]>s?p=m:d=m+1}var v=d-1;return T.create(v,s-c[v])},n.prototype.offsetAt=function(s){var c=this.getLineOffsets();if(s.line>=c.length)return this._content.length;if(s.line<0)return 0;var d=c[s.line],p=s.line+1<c.length?c[s.line+1]:this._content.length;return Math.max(Math.min(d+s.character,p),d)},Object.defineProperty(n.prototype,"lineCount",{get:function(){return this.getLineOffsets().length},enumerable:!1,configurable:!0}),n}();!function(s){var c=Object.prototype.toString;s.defined=function i(s){return typeof s<"u"},s.undefined=function r(s){return typeof s>"u"},s.boolean=function e(s){return!0===s||!1===s},s.string=function o(s){return"[object String]"===c.call(s)},s.number=function a(s){return"[object Number]"===c.call(s)},s.numberRange=function u(s,d,p){return"[object Number]"===c.call(s)&&d<=s&&s<=p},s.integer=function l(s){return"[object Number]"===c.call(s)&&-2147483648<=s&&s<=2147483647},s.uinteger=function f(s){return"[object Number]"===c.call(s)&&0<=s&&s<=2147483647},s.func=function g(s){return"[object Function]"===c.call(s)},s.objectLiteral=function h(s){return null!==s&&"object"==typeof s},s.typedArray=function k(s,c){return Array.isArray(s)&&s.every(c)}}(We||(We={}));var Ve=class{constructor(s,c,d){this._languageId=s,this._worker=c;let e=s=>{let c,d=s.getLanguageId();d===this._languageId&&(this._listener[s.uri.toString()]=s.onDidChangeContent((()=>{window.clearTimeout(c),c=window.setTimeout((()=>this._doValidate(s.uri,d)),500)})),this._doValidate(s.uri,d))},o=s=>{A.editor.setModelMarkers(s,this._languageId,[]);let c=s.uri.toString(),d=this._listener[c];d&&(d.dispose(),delete this._listener[c])};this._disposables.push(A.editor.onDidCreateModel(e)),this._disposables.push(A.editor.onWillDisposeModel(o)),this._disposables.push(A.editor.onDidChangeModelLanguage((s=>{o(s.model),e(s.model)}))),this._disposables.push(d((s=>{A.editor.getModels().forEach((s=>{s.getLanguageId()===this._languageId&&(o(s),e(s))}))}))),this._disposables.push({dispose:()=>{A.editor.getModels().forEach(o);for(let s in this._listener)this._listener[s].dispose()}}),A.editor.getModels().forEach(e)}_disposables=[];_listener=Object.create(null);dispose(){this._disposables.forEach((s=>s&&s.dispose())),this._disposables.length=0}_doValidate(s,c){this._worker(s).then((c=>c.doValidation(s.toString()))).then((d=>{let p=d.map((s=>function hn(s,c){let d="number"==typeof c.code?String(c.code):c.code;return{severity:mn(c.severity),startLineNumber:c.range.start.line+1,startColumn:c.range.start.character+1,endLineNumber:c.range.end.line+1,endColumn:c.range.end.character+1,message:c.message,code:d,source:c.source}}(0,s))),m=A.editor.getModel(s);m&&m.getLanguageId()===c&&A.editor.setModelMarkers(m,c,p)})).then(void 0,(s=>{console.error(s)}))}};function mn(s){switch(s){case V.Error:return A.MarkerSeverity.Error;case V.Warning:return A.MarkerSeverity.Warning;case V.Information:return A.MarkerSeverity.Info;case V.Hint:return A.MarkerSeverity.Hint;default:return A.MarkerSeverity.Info}}var He=class{constructor(s,c){this._worker=s,this._triggerCharacters=c}get triggerCharacters(){return this._triggerCharacters}provideCompletionItems(s,c,d,p){let m=s.uri;return this._worker(m).then((s=>s.doComplete(m.toString(),C(c)))).then((d=>{if(!d)return;let p=s.getWordUntilPosition(c),m=new A.Range(c.lineNumber,p.startColumn,c.lineNumber,p.endColumn),v=d.items.map((s=>{let c={label:s.label,insertText:s.insertText||s.label,sortText:s.sortText,filterText:s.filterText,documentation:s.documentation,detail:s.detail,command:yn(s.command),range:m,kind:Tn(s.kind)};return s.textEdit&&(function vn(s){return typeof s.insert<"u"&&typeof s.replace<"u"}(s.textEdit)?c.range={insert:y(s.textEdit.insert),replace:y(s.textEdit.replace)}:c.range=y(s.textEdit.range),c.insertText=s.textEdit.newText),s.additionalTextEdits&&(c.additionalTextEdits=s.additionalTextEdits.map(D)),s.insertTextFormat===fe.Snippet&&(c.insertTextRules=A.languages.CompletionItemInsertTextRule.InsertAsSnippet),c}));return{isIncomplete:d.isIncomplete,suggestions:v}}))}};function C(s){if(s)return{character:s.column-1,line:s.lineNumber-1}}function ue(s){if(s)return{start:{line:s.startLineNumber-1,character:s.startColumn-1},end:{line:s.endLineNumber-1,character:s.endColumn-1}}}function y(s){if(s)return new A.Range(s.start.line+1,s.start.character+1,s.end.line+1,s.end.character+1)}function Tn(s){let c=A.languages.CompletionItemKind;switch(s){case de.Text:return c.Text;case de.Method:return c.Method;case de.Function:return c.Function;case de.Constructor:return c.Constructor;case de.Field:return c.Field;case de.Variable:return c.Variable;case de.Class:return c.Class;case de.Interface:return c.Interface;case de.Module:return c.Module;case de.Property:return c.Property;case de.Unit:return c.Unit;case de.Value:return c.Value;case de.Enum:return c.Enum;case de.Keyword:return c.Keyword;case de.Snippet:return c.Snippet;case de.Color:return c.Color;case de.File:return c.File;case de.Reference:return c.Reference}return c.Property}function D(s){if(s)return{range:y(s.range),text:s.newText}}function yn(s){return s&&"editor.action.triggerSuggest"===s.command?{id:s.command,title:s.title,arguments:s.arguments}:void 0}var Ke=class{constructor(s){this._worker=s}provideHover(s,c,d){let p=s.uri;return this._worker(p).then((s=>s.doHover(p.toString(),C(c)))).then((s=>{if(s)return{range:y(s.range),contents:kn(s.contents)}}))}};function Be(s){return"string"==typeof s?{value:s}:function xn(s){return s&&"object"==typeof s&&"string"==typeof s.kind}(s)?"plaintext"===s.kind?{value:s.value.replace(/[\\`*_{}[\]()#+\-.!]/g,"\\$&")}:{value:s.value}:{value:"```"+s.language+"\n"+s.value+"\n```\n"}}function kn(s){if(s)return Array.isArray(s)?s.map(Be):[Be(s)]}var ze=class{constructor(s){this._worker=s}provideDocumentHighlights(s,c,d){let p=s.uri;return this._worker(p).then((s=>s.findDocumentHighlights(p.toString(),C(c)))).then((s=>{if(s)return s.map((s=>({range:y(s.range),kind:In(s.kind)})))}))}};function In(s){switch(s){case Ce.Read:return A.languages.DocumentHighlightKind.Read;case Ce.Write:return A.languages.DocumentHighlightKind.Write;case Ce.Text:return A.languages.DocumentHighlightKind.Text}return A.languages.DocumentHighlightKind.Text}var Xe=class{constructor(s){this._worker=s}provideDefinition(s,c,d){let p=s.uri;return this._worker(p).then((s=>s.findDefinition(p.toString(),C(c)))).then((s=>{if(s)return[Qe(s)]}))}};function Qe(s){return{uri:A.Uri.parse(s.uri),range:y(s.range)}}var qe=class{constructor(s){this._worker=s}provideReferences(s,c,d,p){let m=s.uri;return this._worker(m).then((s=>s.findReferences(m.toString(),C(c)))).then((s=>{if(s)return s.map(Qe)}))}},$e=class{constructor(s){this._worker=s}provideRenameEdits(s,c,d,p){let m=s.uri;return this._worker(m).then((s=>s.doRename(m.toString(),C(c),d))).then((s=>function _n(s){if(!s||!s.changes)return;let c=[];for(let d in s.changes){let p=A.Uri.parse(d);for(let m of s.changes[d])c.push({resource:p,edit:{range:y(m.range),text:m.newText}})}return{edits:c}}(s)))}};var Ge=class{constructor(s){this._worker=s}provideDocumentSymbols(s,c){let d=s.uri;return this._worker(d).then((s=>s.findDocumentSymbols(d.toString()))).then((s=>{if(s)return s.map((s=>({name:s.name,detail:"",containerName:s.containerName,kind:Cn(s.kind),range:y(s.location.range),selectionRange:y(s.location.range),tags:[]})))}))}};function Cn(s){let c=A.languages.SymbolKind;switch(s){case xe.File:return c.Array;case xe.Module:return c.Module;case xe.Namespace:return c.Namespace;case xe.Package:return c.Package;case xe.Class:return c.Class;case xe.Method:return c.Method;case xe.Property:return c.Property;case xe.Field:return c.Field;case xe.Constructor:return c.Constructor;case xe.Enum:return c.Enum;case xe.Interface:return c.Interface;case xe.Function:return c.Function;case xe.Variable:return c.Variable;case xe.Constant:return c.Constant;case xe.String:return c.String;case xe.Number:return c.Number;case xe.Boolean:return c.Boolean;case xe.Array:return c.Array}return c.Function}var Ye=class{constructor(s){this._worker=s}provideLinks(s,c){let d=s.uri;return this._worker(d).then((s=>s.findDocumentLinks(d.toString()))).then((s=>{if(s)return{links:s.map((s=>({range:y(s.range),url:s.target})))}}))}},et=class{constructor(s){this._worker=s}provideDocumentFormattingEdits(s,c,d){let p=s.uri;return this._worker(p).then((s=>s.format(p.toString(),null,Je(c)).then((s=>{if(s&&0!==s.length)return s.map(D)}))))}},tt=class{constructor(s){this._worker=s}provideDocumentRangeFormattingEdits(s,c,d,p){let m=s.uri;return this._worker(m).then((s=>s.format(m.toString(),ue(c),Je(d)).then((s=>{if(s&&0!==s.length)return s.map(D)}))))}};function Je(s){return{tabSize:s.tabSize,insertSpaces:s.insertSpaces}}var nt=class{constructor(s){this._worker=s}provideDocumentColors(s,c){let d=s.uri;return this._worker(d).then((s=>s.findDocumentColors(d.toString()))).then((s=>{if(s)return s.map((s=>({color:s.color,range:y(s.range)})))}))}provideColorPresentations(s,c,d){let p=s.uri;return this._worker(p).then((s=>s.getColorPresentations(p.toString(),c.color,ue(c.range)))).then((s=>{if(s)return s.map((s=>{let c={label:s.label};return s.textEdit&&(c.textEdit=D(s.textEdit)),s.additionalTextEdits&&(c.additionalTextEdits=s.additionalTextEdits.map(D)),c}))}))}},rt=class{constructor(s){this._worker=s}provideFoldingRanges(s,c,d){let p=s.uri;return this._worker(p).then((s=>s.getFoldingRanges(p.toString(),c))).then((s=>{if(s)return s.map((s=>{let c={start:s.startLine+1,end:s.endLine+1};return typeof s.kind<"u"&&(c.kind=function bn(s){switch(s){case N.Comment:return A.languages.FoldingRangeKind.Comment;case N.Imports:return A.languages.FoldingRangeKind.Imports;case N.Region:return A.languages.FoldingRangeKind.Region}}(s.kind)),c}))}))}};var it=class{constructor(s){this._worker=s}provideSelectionRanges(s,c,d){let p=s.uri;return this._worker(p).then((s=>s.getSelectionRanges(p.toString(),c.map(C)))).then((s=>{if(s)return s.map((s=>{let c=[];for(;s;)c.push({range:y(s.range)}),s=s.parent;return c}))}))}},ot=class extends He{constructor(s){super(s,[".",":","<",'"',"=","/"])}};function En(s){let c=new ne(s),i=(...s)=>c.getLanguageServiceWorker(...s),d=s.languageId;A.languages.registerCompletionItemProvider(d,new ot(i)),A.languages.registerHoverProvider(d,new Ke(i)),A.languages.registerDocumentHighlightProvider(d,new ze(i)),A.languages.registerLinkProvider(d,new Ye(i)),A.languages.registerFoldingRangeProvider(d,new rt(i)),A.languages.registerDocumentSymbolProvider(d,new Ge(i)),A.languages.registerSelectionRangeProvider(d,new it(i)),A.languages.registerRenameProvider(d,new $e(i)),"html"===d&&(A.languages.registerDocumentFormattingEditProvider(d,new et(i)),A.languages.registerDocumentRangeFormattingEditProvider(d,new tt(i)))}function Rn(s){let c=[],d=[],p=new ne(s);c.push(p);let e=(...s)=>p.getLanguageServiceWorker(...s);return function o(){let{languageId:c,modeConfiguration:p}=s;en(d),p.completionItems&&d.push(A.languages.registerCompletionItemProvider(c,new ot(e))),p.hovers&&d.push(A.languages.registerHoverProvider(c,new Ke(e))),p.documentHighlights&&d.push(A.languages.registerDocumentHighlightProvider(c,new ze(e))),p.links&&d.push(A.languages.registerLinkProvider(c,new Ye(e))),p.documentSymbols&&d.push(A.languages.registerDocumentSymbolProvider(c,new Ge(e))),p.rename&&d.push(A.languages.registerRenameProvider(c,new $e(e))),p.foldingRanges&&d.push(A.languages.registerFoldingRangeProvider(c,new rt(e))),p.selectionRanges&&d.push(A.languages.registerSelectionRangeProvider(c,new it(e))),p.documentFormattingEdits&&d.push(A.languages.registerDocumentFormattingEditProvider(c,new et(e))),p.documentRangeFormattingEdits&&d.push(A.languages.registerDocumentRangeFormattingEditProvider(c,new tt(e)))}(),c.push(Ze(d)),Ze(c)}function Ze(s){return{dispose:()=>en(s)}}function en(s){for(;s.length;)s.pop().dispose()}return E(I)})()));