/*!-----------------------------------------------------------------------------
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Version: 0.32.1(29a273516805a852aa8edc5e05059f119b13eff0)
 * Released under the MIT license
 * https://github.com/microsoft/monaco-editor/blob/main/LICENSE.txt
 *-----------------------------------------------------------------------------*/
define("vs/language/css/cssWorker",["require","require"],(l=>(()=>{var l,h,m=Object.defineProperty,b=Object.getOwnPropertyDescriptor,y=Object.getOwnPropertyNames,w=Object.prototype.hasOwnProperty,x=(l="undefined"!=typeof WeakMap?new WeakMap:0,(h,x)=>l&&l.get(h)||(x=((l,h,x,F)=>{if(h&&"object"==typeof h||"function"==typeof h)for(let E of y(h))!w.call(l,E)&&(x||"default"!==E)&&m(l,E,{get:()=>h[E],enumerable:!(F=b(h,E))||F.enumerable});return l})((l=>m(l,"__esModule",{value:!0}))({}),h,1),l&&l.set(h,x),x)),F={};((l,h)=>{for(var b in h)m(l,b,{get:h[b],enumerable:!0})})(F,{CSSWorker:()=>qs,create:()=>Bs}),function(l){l[l.Ident=0]="Ident",l[l.AtKeyword=1]="AtKeyword",l[l.String=2]="String",l[l.BadString=3]="BadString",l[l.UnquotedString=4]="UnquotedString",l[l.Hash=5]="Hash",l[l.Num=6]="Num",l[l.Percentage=7]="Percentage",l[l.Dimension=8]="Dimension",l[l.UnicodeRange=9]="UnicodeRange",l[l.CDO=10]="CDO",l[l.CDC=11]="CDC",l[l.Colon=12]="Colon",l[l.SemiColon=13]="SemiColon",l[l.CurlyL=14]="CurlyL",l[l.CurlyR=15]="CurlyR",l[l.ParenthesisL=16]="ParenthesisL",l[l.ParenthesisR=17]="ParenthesisR",l[l.BracketL=18]="BracketL",l[l.BracketR=19]="BracketR",l[l.Whitespace=20]="Whitespace",l[l.Includes=21]="Includes",l[l.Dashmatch=22]="Dashmatch",l[l.SubstringOperator=23]="SubstringOperator",l[l.PrefixOperator=24]="PrefixOperator",l[l.SuffixOperator=25]="SuffixOperator",l[l.Delim=26]="Delim",l[l.EMS=27]="EMS",l[l.EXS=28]="EXS",l[l.Length=29]="Length",l[l.Angle=30]="Angle",l[l.Time=31]="Time",l[l.Freq=32]="Freq",l[l.Exclamation=33]="Exclamation",l[l.Resolution=34]="Resolution",l[l.Comma=35]="Comma",l[l.Charset=36]="Charset",l[l.EscapedJavaScript=37]="EscapedJavaScript",l[l.BadEscapedJavaScript=38]="BadEscapedJavaScript",l[l.Comment=39]="Comment",l[l.SingleLineComment=40]="SingleLineComment",l[l.EOF=41]="EOF",l[l.CustomToken=42]="CustomToken"}(h||(h={}));var E=function(){function n(l){this.source=l,this.len=l.length,this.position=0}return n.prototype.substring=function(l,h){return void 0===h&&(h=this.position),this.source.substring(l,h)},n.prototype.eos=function(){return this.len<=this.position},n.prototype.pos=function(){return this.position},n.prototype.goBackTo=function(l){this.position=l},n.prototype.goBack=function(l){this.position-=l},n.prototype.advance=function(l){this.position+=l},n.prototype.nextChar=function(){return this.source.charCodeAt(this.position++)||0},n.prototype.peekChar=function(l){return void 0===l&&(l=0),this.source.charCodeAt(this.position+l)||0},n.prototype.lookbackChar=function(l){return void 0===l&&(l=0),this.source.charCodeAt(this.position-l)||0},n.prototype.advanceIfChar=function(l){return l===this.source.charCodeAt(this.position)&&(this.position++,!0)},n.prototype.advanceIfChars=function(l){if(this.position+l.length>this.source.length)return!1;for(var h=0;h<l.length;h++)if(this.source.charCodeAt(this.position+h)!==l[h])return!1;return this.advance(h),!0},n.prototype.advanceWhileChar=function(l){for(var h=this.position;this.position<this.len&&l(this.source.charCodeAt(this.position));)this.position++;return this.position-h},n}(),z="a".charCodeAt(0),D="f".charCodeAt(0),R="z".charCodeAt(0),T="A".charCodeAt(0),M="F".charCodeAt(0),P="Z".charCodeAt(0),_="0".charCodeAt(0),N="9".charCodeAt(0),A="~".charCodeAt(0),O="^".charCodeAt(0),W="=".charCodeAt(0),L="|".charCodeAt(0),U="-".charCodeAt(0),j="_".charCodeAt(0),B="%".charCodeAt(0),q="*".charCodeAt(0),G="(".charCodeAt(0),H=")".charCodeAt(0),J="<".charCodeAt(0),X=">".charCodeAt(0),Y="@".charCodeAt(0),Z="#".charCodeAt(0),Q="$".charCodeAt(0),ee="\\".charCodeAt(0),ne="/".charCodeAt(0),re="\n".charCodeAt(0),ie="\r".charCodeAt(0),oe="\f".charCodeAt(0),ae='"'.charCodeAt(0),le="'".charCodeAt(0),ce=" ".charCodeAt(0),pe="\t".charCodeAt(0),me=";".charCodeAt(0),ue=":".charCodeAt(0),fe="{".charCodeAt(0),ge="}".charCodeAt(0),be="[".charCodeAt(0),ve="]".charCodeAt(0),ye=",".charCodeAt(0),we=".".charCodeAt(0),xe="!".charCodeAt(0),ke={};ke[me]=h.SemiColon,ke[ue]=h.Colon,ke[fe]=h.CurlyL,ke[ge]=h.CurlyR,ke[ve]=h.BracketR,ke[be]=h.BracketL,ke[G]=h.ParenthesisL,ke[H]=h.ParenthesisR,ke[ye]=h.Comma;var Ce={};Ce.em=h.EMS,Ce.ex=h.EXS,Ce.px=h.Length,Ce.cm=h.Length,Ce.mm=h.Length,Ce.in=h.Length,Ce.pt=h.Length,Ce.pc=h.Length,Ce.deg=h.Angle,Ce.rad=h.Angle,Ce.grad=h.Angle,Ce.ms=h.Time,Ce.s=h.Time,Ce.hz=h.Freq,Ce.khz=h.Freq,Ce["%"]=h.Percentage,Ce.fr=h.Percentage,Ce.dpi=h.Resolution,Ce.dpcm=h.Resolution;var Fe=function(){function n(){this.stream=new E(""),this.ignoreComment=!0,this.ignoreWhitespace=!0,this.inURL=!1}return n.prototype.setSource=function(l){this.stream=new E(l)},n.prototype.finishToken=function(l,h,m){return{offset:l,len:this.stream.pos()-l,type:h,text:m||this.stream.substring(l)}},n.prototype.substring=function(l,h){return this.stream.substring(l,l+h)},n.prototype.pos=function(){return this.stream.pos()},n.prototype.goBackTo=function(l){this.stream.goBackTo(l)},n.prototype.scanUnquotedString=function(){var l=this.stream.pos(),m=[];return this._unquotedString(m)?this.finishToken(l,h.UnquotedString,m.join("")):null},n.prototype.scan=function(){var l=this.trivia();if(null!==l)return l;var m=this.stream.pos();return this.stream.eos()?this.finishToken(m,h.EOF):this.scanNext(m)},n.prototype.scanNext=function(l){if(this.stream.advanceIfChars([J,xe,U,U]))return this.finishToken(l,h.CDO);if(this.stream.advanceIfChars([U,U,X]))return this.finishToken(l,h.CDC);var m=[];if(this.ident(m))return this.finishToken(l,h.Ident,m.join(""));if(this.stream.advanceIfChar(Y)){if(m=["@"],this._name(m)){var b=m.join("");return"@charset"===b?this.finishToken(l,h.Charset,b):this.finishToken(l,h.AtKeyword,b)}return this.finishToken(l,h.Delim)}if(this.stream.advanceIfChar(Z))return m=["#"],this._name(m)?this.finishToken(l,h.Hash,m.join("")):this.finishToken(l,h.Delim);if(this.stream.advanceIfChar(xe))return this.finishToken(l,h.Exclamation);if(this._number()){var y=this.stream.pos();if(m=[this.stream.substring(l,y)],this.stream.advanceIfChar(B))return this.finishToken(l,h.Percentage);if(this.ident(m)){var w=this.stream.substring(y).toLowerCase(),x=Ce[w];return typeof x<"u"?this.finishToken(l,x,m.join("")):this.finishToken(l,h.Dimension,m.join(""))}return this.finishToken(l,h.Num)}m=[];var F=this._string(m);return null!==F?this.finishToken(l,F,m.join("")):typeof(F=ke[this.stream.peekChar()])<"u"?(this.stream.advance(1),this.finishToken(l,F)):this.stream.peekChar(0)===A&&this.stream.peekChar(1)===W?(this.stream.advance(2),this.finishToken(l,h.Includes)):this.stream.peekChar(0)===L&&this.stream.peekChar(1)===W?(this.stream.advance(2),this.finishToken(l,h.Dashmatch)):this.stream.peekChar(0)===q&&this.stream.peekChar(1)===W?(this.stream.advance(2),this.finishToken(l,h.SubstringOperator)):this.stream.peekChar(0)===O&&this.stream.peekChar(1)===W?(this.stream.advance(2),this.finishToken(l,h.PrefixOperator)):this.stream.peekChar(0)===Q&&this.stream.peekChar(1)===W?(this.stream.advance(2),this.finishToken(l,h.SuffixOperator)):(this.stream.nextChar(),this.finishToken(l,h.Delim))},n.prototype.trivia=function(){for(;;){var l=this.stream.pos();if(this._whitespace()){if(!this.ignoreWhitespace)return this.finishToken(l,h.Whitespace)}else{if(!this.comment())return null;if(!this.ignoreComment)return this.finishToken(l,h.Comment)}}},n.prototype.comment=function(){if(this.stream.advanceIfChars([ne,q])){var l=!1,h=!1;return this.stream.advanceWhileChar((function(m){return h&&m===ne?(l=!0,!1):(h=m===q,!0)})),l&&this.stream.advance(1),!0}return!1},n.prototype._number=function(){var l,h=0;return this.stream.peekChar()===we&&(h=1),(l=this.stream.peekChar(h))>=_&&l<=N&&(this.stream.advance(h+1),this.stream.advanceWhileChar((function(l){return l>=_&&l<=N||0===h&&l===we})),!0)},n.prototype._newline=function(l){var h=this.stream.peekChar();switch(h){case ie:case oe:case re:return this.stream.advance(1),l.push(String.fromCharCode(h)),h===ie&&this.stream.advanceIfChar(re)&&l.push("\n"),!0}return!1},n.prototype._escape=function(l,h){var m=this.stream.peekChar();if(m===ee){this.stream.advance(1),m=this.stream.peekChar();for(var b=0;b<6&&(m>=_&&m<=N||m>=z&&m<=D||m>=T&&m<=M);)this.stream.advance(1),m=this.stream.peekChar(),b++;if(b>0){try{var y=parseInt(this.stream.substring(this.stream.pos()-b),16);y&&l.push(String.fromCharCode(y))}catch{}return m===ce||m===pe?this.stream.advance(1):this._newline([]),!0}if(m!==ie&&m!==oe&&m!==re)return this.stream.advance(1),l.push(String.fromCharCode(m)),!0;if(h)return this._newline(l)}return!1},n.prototype._stringChar=function(l,h){var m=this.stream.peekChar();return 0!==m&&m!==l&&m!==ee&&m!==ie&&m!==oe&&m!==re&&(this.stream.advance(1),h.push(String.fromCharCode(m)),!0)},n.prototype._string=function(l){if(this.stream.peekChar()===le||this.stream.peekChar()===ae){var m=this.stream.nextChar();for(l.push(String.fromCharCode(m));this._stringChar(m,l)||this._escape(l,!0););return this.stream.peekChar()===m?(this.stream.nextChar(),l.push(String.fromCharCode(m)),h.String):h.BadString}return null},n.prototype._unquotedChar=function(l){var h=this.stream.peekChar();return 0!==h&&h!==ee&&h!==le&&h!==ae&&h!==G&&h!==H&&h!==ce&&h!==pe&&h!==re&&h!==oe&&h!==ie&&(this.stream.advance(1),l.push(String.fromCharCode(h)),!0)},n.prototype._unquotedString=function(l){for(var h=!1;this._unquotedChar(l)||this._escape(l);)h=!0;return h},n.prototype._whitespace=function(){return this.stream.advanceWhileChar((function(l){return l===ce||l===pe||l===re||l===oe||l===ie}))>0},n.prototype._name=function(l){for(var h=!1;this._identChar(l)||this._escape(l);)h=!0;return h},n.prototype.ident=function(l){var h=this.stream.pos();if(this._minus(l)){if(this._minus(l)||this._identFirstChar(l)||this._escape(l)){for(;this._identChar(l)||this._escape(l););return!0}}else if(this._identFirstChar(l)||this._escape(l)){for(;this._identChar(l)||this._escape(l););return!0}return this.stream.goBackTo(h),!1},n.prototype._identFirstChar=function(l){var h=this.stream.peekChar();return(h===j||h>=z&&h<=R||h>=T&&h<=P||h>=128&&h<=65535)&&(this.stream.advance(1),l.push(String.fromCharCode(h)),!0)},n.prototype._minus=function(l){var h=this.stream.peekChar();return h===U&&(this.stream.advance(1),l.push(String.fromCharCode(h)),!0)},n.prototype._identChar=function(l){var h=this.stream.peekChar();return(h===j||h===U||h>=z&&h<=R||h>=T&&h<=P||h>=_&&h<=N||h>=128&&h<=65535)&&(this.stream.advance(1),l.push(String.fromCharCode(h)),!0)},n}();function V(l,h){if(l.length<h.length)return!1;for(var m=0;m<h.length;m++)if(l[m]!==h[m])return!1;return!0}function en(l,h){var m=l.length-h.length;return m>0?l.lastIndexOf(h)===m:0===m&&l===h}function Gn(l,h){return void 0===h&&(h=!0),l?l.length<140?l:l.slice(0,140)+(h?"…":""):""}var Ee,ze,De=function(){var n=function(l,h){return(n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(l,h){l.__proto__=h}||function(l,h){for(var m in h)Object.prototype.hasOwnProperty.call(h,m)&&(l[m]=h[m])})(l,h)};return function(l,h){if("function"!=typeof h&&null!==h)throw new TypeError("Class extends value "+String(h)+" is not a constructor or null");function r(){this.constructor=l}n(l,h),l.prototype=null===h?Object.create(h):(r.prototype=h.prototype,new r)}}();function tn(l,h){var m=null;return!l||h<l.offset||h>l.end?null:(l.accept((function(l){return-1===l.offset&&-1===l.length||l.offset<=h&&l.end>=h&&(m?l.length<=m.length&&(m=l):m=l,!0)})),m)}function it(l,h){for(var m=tn(l,h),b=[];m;)b.unshift(m),m=m.parent;return b}!function(l){l[l.Undefined=0]="Undefined",l[l.Identifier=1]="Identifier",l[l.Stylesheet=2]="Stylesheet",l[l.Ruleset=3]="Ruleset",l[l.Selector=4]="Selector",l[l.SimpleSelector=5]="SimpleSelector",l[l.SelectorInterpolation=6]="SelectorInterpolation",l[l.SelectorCombinator=7]="SelectorCombinator",l[l.SelectorCombinatorParent=8]="SelectorCombinatorParent",l[l.SelectorCombinatorSibling=9]="SelectorCombinatorSibling",l[l.SelectorCombinatorAllSiblings=10]="SelectorCombinatorAllSiblings",l[l.SelectorCombinatorShadowPiercingDescendant=11]="SelectorCombinatorShadowPiercingDescendant",l[l.Page=12]="Page",l[l.PageBoxMarginBox=13]="PageBoxMarginBox",l[l.ClassSelector=14]="ClassSelector",l[l.IdentifierSelector=15]="IdentifierSelector",l[l.ElementNameSelector=16]="ElementNameSelector",l[l.PseudoSelector=17]="PseudoSelector",l[l.AttributeSelector=18]="AttributeSelector",l[l.Declaration=19]="Declaration",l[l.Declarations=20]="Declarations",l[l.Property=21]="Property",l[l.Expression=22]="Expression",l[l.BinaryExpression=23]="BinaryExpression",l[l.Term=24]="Term",l[l.Operator=25]="Operator",l[l.Value=26]="Value",l[l.StringLiteral=27]="StringLiteral",l[l.URILiteral=28]="URILiteral",l[l.EscapedValue=29]="EscapedValue",l[l.Function=30]="Function",l[l.NumericValue=31]="NumericValue",l[l.HexColorValue=32]="HexColorValue",l[l.RatioValue=33]="RatioValue",l[l.MixinDeclaration=34]="MixinDeclaration",l[l.MixinReference=35]="MixinReference",l[l.VariableName=36]="VariableName",l[l.VariableDeclaration=37]="VariableDeclaration",l[l.Prio=38]="Prio",l[l.Interpolation=39]="Interpolation",l[l.NestedProperties=40]="NestedProperties",l[l.ExtendsReference=41]="ExtendsReference",l[l.SelectorPlaceholder=42]="SelectorPlaceholder",l[l.Debug=43]="Debug",l[l.If=44]="If",l[l.Else=45]="Else",l[l.For=46]="For",l[l.Each=47]="Each",l[l.While=48]="While",l[l.MixinContentReference=49]="MixinContentReference",l[l.MixinContentDeclaration=50]="MixinContentDeclaration",l[l.Media=51]="Media",l[l.Keyframe=52]="Keyframe",l[l.FontFace=53]="FontFace",l[l.Import=54]="Import",l[l.Namespace=55]="Namespace",l[l.Invocation=56]="Invocation",l[l.FunctionDeclaration=57]="FunctionDeclaration",l[l.ReturnStatement=58]="ReturnStatement",l[l.MediaQuery=59]="MediaQuery",l[l.MediaCondition=60]="MediaCondition",l[l.MediaFeature=61]="MediaFeature",l[l.FunctionParameter=62]="FunctionParameter",l[l.FunctionArgument=63]="FunctionArgument",l[l.KeyframeSelector=64]="KeyframeSelector",l[l.ViewPort=65]="ViewPort",l[l.Document=66]="Document",l[l.AtApplyRule=67]="AtApplyRule",l[l.CustomPropertyDeclaration=68]="CustomPropertyDeclaration",l[l.CustomPropertySet=69]="CustomPropertySet",l[l.ListEntry=70]="ListEntry",l[l.Supports=71]="Supports",l[l.SupportsCondition=72]="SupportsCondition",l[l.NamespacePrefix=73]="NamespacePrefix",l[l.GridLine=74]="GridLine",l[l.Plugin=75]="Plugin",l[l.UnknownAtRule=76]="UnknownAtRule",l[l.Use=77]="Use",l[l.ModuleConfiguration=78]="ModuleConfiguration",l[l.Forward=79]="Forward",l[l.ForwardVisibility=80]="ForwardVisibility",l[l.Module=81]="Module"}(Ee||(Ee={})),function(l){l[l.Mixin=0]="Mixin",l[l.Rule=1]="Rule",l[l.Variable=2]="Variable",l[l.Function=3]="Function",l[l.Keyframe=4]="Keyframe",l[l.Unknown=5]="Unknown",l[l.Module=6]="Module",l[l.Forward=7]="Forward",l[l.ForwardVisibility=8]="ForwardVisibility"}(ze||(ze={}));var Re,Te=function(){function n(l,h,m){void 0===l&&(l=-1),void 0===h&&(h=-1),this.parent=null,this.offset=l,this.length=h,m&&(this.nodeType=m)}return Object.defineProperty(n.prototype,"end",{get:function(){return this.offset+this.length},enumerable:!1,configurable:!0}),Object.defineProperty(n.prototype,"type",{get:function(){return this.nodeType||Ee.Undefined},set:function(l){this.nodeType=l},enumerable:!1,configurable:!0}),n.prototype.getTextProvider=function(){for(var l=this;l&&!l.textProvider;)l=l.parent;return l?l.textProvider:function(){return"unknown"}},n.prototype.getText=function(){return this.getTextProvider()(this.offset,this.length)},n.prototype.matches=function(l){return this.length===l.length&&this.getTextProvider()(this.offset,this.length)===l},n.prototype.startsWith=function(l){return this.length>=l.length&&this.getTextProvider()(this.offset,l.length)===l},n.prototype.endsWith=function(l){return this.length>=l.length&&this.getTextProvider()(this.end-l.length,l.length)===l},n.prototype.accept=function(l){if(l(this)&&this.children)for(var h=0,m=this.children;h<m.length;h++){m[h].accept(l)}},n.prototype.acceptVisitor=function(l){this.accept(l.visitNode.bind(l))},n.prototype.adoptChild=function(l,h){if(void 0===h&&(h=-1),l.parent&&l.parent.children){var m=l.parent.children.indexOf(l);m>=0&&l.parent.children.splice(m,1)}l.parent=this;var b=this.children;return b||(b=this.children=[]),-1!==h?b.splice(h,0,l):b.push(l),l},n.prototype.attachTo=function(l,h){return void 0===h&&(h=-1),l&&l.adoptChild(this,h),this},n.prototype.collectIssues=function(l){this.issues&&l.push.apply(l,this.issues)},n.prototype.addIssue=function(l){this.issues||(this.issues=[]),this.issues.push(l)},n.prototype.hasIssue=function(l){return Array.isArray(this.issues)&&this.issues.some((function(h){return h.getRule()===l}))},n.prototype.isErroneous=function(l){return void 0===l&&(l=!1),!!(this.issues&&this.issues.length>0)||l&&Array.isArray(this.children)&&this.children.some((function(l){return l.isErroneous(!0)}))},n.prototype.setNode=function(l,h,m){return void 0===m&&(m=-1),!!h&&(h.attachTo(this,m),this[l]=h,!0)},n.prototype.addChild=function(l){return!!l&&(this.children||(this.children=[]),l.attachTo(this),this.updateOffsetAndLength(l),!0)},n.prototype.updateOffsetAndLength=function(l){(l.offset<this.offset||-1===this.offset)&&(this.offset=l.offset);var h=l.end;(h>this.end||-1===this.length)&&(this.length=h-this.offset)},n.prototype.hasChildren=function(){return!!this.children&&this.children.length>0},n.prototype.getChildren=function(){return this.children?this.children.slice(0):[]},n.prototype.getChild=function(l){return this.children&&l<this.children.length?this.children[l]:null},n.prototype.addChildren=function(l){for(var h=0,m=l;h<m.length;h++){var b=m[h];this.addChild(b)}},n.prototype.findFirstChildBeforeOffset=function(l){if(this.children)for(var h=null,m=this.children.length-1;m>=0;m--)if((h=this.children[m]).offset<=l)return h;return null},n.prototype.findChildAtOffset=function(l,h){var m=this.findFirstChildBeforeOffset(l);return m&&m.end>=l?h&&m.findChildAtOffset(l,!0)||m:null},n.prototype.encloses=function(l){return this.offset<=l.offset&&this.offset+this.length>=l.offset+l.length},n.prototype.getParent=function(){for(var l=this.parent;l instanceof Ie;)l=l.parent;return l},n.prototype.findParent=function(l){for(var h=this;h&&h.type!==l;)h=h.parent;return h},n.prototype.findAParent=function(){for(var l=[],h=0;h<arguments.length;h++)l[h]=arguments[h];for(var m=this;m&&!l.some((function(l){return m.type===l}));)m=m.parent;return m},n.prototype.setData=function(l,h){this.options||(this.options={}),this.options[l]=h},n.prototype.getData=function(l){return this.options&&this.options.hasOwnProperty(l)?this.options[l]:null},n}(),Ie=function(l){function e(h,m){void 0===m&&(m=-1);var b=l.call(this,-1,-1)||this;return b.attachTo(h,m),b.offset=-1,b.length=-1,b}return De(e,l),e}(Te),Me=function(l){function e(h,m){var b=l.call(this,h,m)||this;return b.isCustomProperty=!1,b}return De(e,l),Object.defineProperty(e.prototype,"type",{get:function(){return Ee.Identifier},enumerable:!1,configurable:!0}),e.prototype.containsInterpolation=function(){return this.hasChildren()},e}(Te),Pe=function(l){function e(h,m){return l.call(this,h,m)||this}return De(e,l),Object.defineProperty(e.prototype,"type",{get:function(){return Ee.Stylesheet},enumerable:!1,configurable:!0}),e}(Te),_e=function(l){function e(h,m){return l.call(this,h,m)||this}return De(e,l),Object.defineProperty(e.prototype,"type",{get:function(){return Ee.Declarations},enumerable:!1,configurable:!0}),e}(Te),Ae=function(l){function e(h,m){return l.call(this,h,m)||this}return De(e,l),e.prototype.getDeclarations=function(){return this.declarations},e.prototype.setDeclarations=function(l){return this.setNode("declarations",l)},e}(Te),Oe=function(l){function e(h,m){return l.call(this,h,m)||this}return De(e,l),Object.defineProperty(e.prototype,"type",{get:function(){return Ee.Ruleset},enumerable:!1,configurable:!0}),e.prototype.getSelectors=function(){return this.selectors||(this.selectors=new Ie(this)),this.selectors},e.prototype.isNested=function(){return!!this.parent&&null!==this.parent.findParent(Ee.Declarations)},e}(Ae),We=function(l){function e(h,m){return l.call(this,h,m)||this}return De(e,l),Object.defineProperty(e.prototype,"type",{get:function(){return Ee.Selector},enumerable:!1,configurable:!0}),e}(Te),Le=function(l){function e(h,m){return l.call(this,h,m)||this}return De(e,l),Object.defineProperty(e.prototype,"type",{get:function(){return Ee.SimpleSelector},enumerable:!1,configurable:!0}),e}(Te),Ue=(function(l){function e(h,m){return l.call(this,h,m)||this}De(e,l),Object.defineProperty(e.prototype,"type",{get:function(){return Ee.AtApplyRule},enumerable:!1,configurable:!0}),e.prototype.setIdentifier=function(l){return this.setNode("identifier",l,0)},e.prototype.getIdentifier=function(){return this.identifier},e.prototype.getName=function(){return this.identifier?this.identifier.getText():""}}(Te),function(l){function e(h,m){return l.call(this,h,m)||this}return De(e,l),e}(Te)),je=function(l){function e(h,m){return l.call(this,h,m)||this}return De(e,l),Object.defineProperty(e.prototype,"type",{get:function(){return Ee.CustomPropertySet},enumerable:!1,configurable:!0}),e}(Ae),Be=function(l){function e(h,m){var b=l.call(this,h,m)||this;return b.property=null,b}return De(e,l),Object.defineProperty(e.prototype,"type",{get:function(){return Ee.Declaration},enumerable:!1,configurable:!0}),e.prototype.setProperty=function(l){return this.setNode("property",l)},e.prototype.getProperty=function(){return this.property},e.prototype.getFullPropertyName=function(){var l=this.property?this.property.getName():"unknown";if(this.parent instanceof _e&&this.parent.getParent()instanceof ct){var h=this.parent.getParent().getParent();if(h instanceof e)return h.getFullPropertyName()+l}return l},e.prototype.getNonPrefixedPropertyName=function(){var l=this.getFullPropertyName();if(l&&"-"===l.charAt(0)){var h=l.indexOf("-",1);if(-1!==h)return l.substring(h+1)}return l},e.prototype.setValue=function(l){return this.setNode("value",l)},e.prototype.getValue=function(){return this.value},e.prototype.setNestedProperties=function(l){return this.setNode("nestedProperties",l)},e.prototype.getNestedProperties=function(){return this.nestedProperties},e}(Ue),$e=function(l){function e(h,m){return l.call(this,h,m)||this}return De(e,l),Object.defineProperty(e.prototype,"type",{get:function(){return Ee.CustomPropertyDeclaration},enumerable:!1,configurable:!0}),e.prototype.setPropertySet=function(l){return this.setNode("propertySet",l)},e.prototype.getPropertySet=function(){return this.propertySet},e}(Be),Ke=function(l){function e(h,m){return l.call(this,h,m)||this}return De(e,l),Object.defineProperty(e.prototype,"type",{get:function(){return Ee.Property},enumerable:!1,configurable:!0}),e.prototype.setIdentifier=function(l){return this.setNode("identifier",l)},e.prototype.getIdentifier=function(){return this.identifier},e.prototype.getName=function(){return function ti(l,h){var m=h.exec(l);return m&&m[0].length?l.substr(0,l.length-m[0].length):l}(this.getText(),/[_\+]+$/)},e.prototype.isCustomProperty=function(){return!!this.identifier&&this.identifier.isCustomProperty},e}(Te),qe=function(l){function e(h,m){return l.call(this,h,m)||this}return De(e,l),Object.defineProperty(e.prototype,"type",{get:function(){return Ee.Invocation},enumerable:!1,configurable:!0}),e.prototype.getArguments=function(){return this.arguments||(this.arguments=new Ie(this)),this.arguments},e}(Te),Ge=function(l){function e(h,m){return l.call(this,h,m)||this}return De(e,l),Object.defineProperty(e.prototype,"type",{get:function(){return Ee.Function},enumerable:!1,configurable:!0}),e.prototype.setIdentifier=function(l){return this.setNode("identifier",l,0)},e.prototype.getIdentifier=function(){return this.identifier},e.prototype.getName=function(){return this.identifier?this.identifier.getText():""},e}(qe),He=function(l){function e(h,m){return l.call(this,h,m)||this}return De(e,l),Object.defineProperty(e.prototype,"type",{get:function(){return Ee.FunctionParameter},enumerable:!1,configurable:!0}),e.prototype.setIdentifier=function(l){return this.setNode("identifier",l,0)},e.prototype.getIdentifier=function(){return this.identifier},e.prototype.getName=function(){return this.identifier?this.identifier.getText():""},e.prototype.setDefaultValue=function(l){return this.setNode("defaultValue",l,0)},e.prototype.getDefaultValue=function(){return this.defaultValue},e}(Te),Je=function(l){function e(h,m){return l.call(this,h,m)||this}return De(e,l),Object.defineProperty(e.prototype,"type",{get:function(){return Ee.FunctionArgument},enumerable:!1,configurable:!0}),e.prototype.setIdentifier=function(l){return this.setNode("identifier",l,0)},e.prototype.getIdentifier=function(){return this.identifier},e.prototype.getName=function(){return this.identifier?this.identifier.getText():""},e.prototype.setValue=function(l){return this.setNode("value",l,0)},e.prototype.getValue=function(){return this.value},e}(Te),Ze=function(l){function e(h,m){return l.call(this,h,m)||this}return De(e,l),Object.defineProperty(e.prototype,"type",{get:function(){return Ee.If},enumerable:!1,configurable:!0}),e.prototype.setExpression=function(l){return this.setNode("expression",l,0)},e.prototype.setElseClause=function(l){return this.setNode("elseClause",l)},e}(Ae),tt=function(l){function e(h,m){return l.call(this,h,m)||this}return De(e,l),Object.defineProperty(e.prototype,"type",{get:function(){return Ee.For},enumerable:!1,configurable:!0}),e.prototype.setVariable=function(l){return this.setNode("variable",l,0)},e}(Ae),nt=function(l){function e(h,m){return l.call(this,h,m)||this}return De(e,l),Object.defineProperty(e.prototype,"type",{get:function(){return Ee.Each},enumerable:!1,configurable:!0}),e.prototype.getVariables=function(){return this.variables||(this.variables=new Ie(this)),this.variables},e}(Ae),rt=function(l){function e(h,m){return l.call(this,h,m)||this}return De(e,l),Object.defineProperty(e.prototype,"type",{get:function(){return Ee.While},enumerable:!1,configurable:!0}),e}(Ae),ot=function(l){function e(h,m){return l.call(this,h,m)||this}return De(e,l),Object.defineProperty(e.prototype,"type",{get:function(){return Ee.Else},enumerable:!1,configurable:!0}),e}(Ae),st=function(l){function e(h,m){return l.call(this,h,m)||this}return De(e,l),Object.defineProperty(e.prototype,"type",{get:function(){return Ee.FunctionDeclaration},enumerable:!1,configurable:!0}),e.prototype.setIdentifier=function(l){return this.setNode("identifier",l,0)},e.prototype.getIdentifier=function(){return this.identifier},e.prototype.getName=function(){return this.identifier?this.identifier.getText():""},e.prototype.getParameters=function(){return this.parameters||(this.parameters=new Ie(this)),this.parameters},e}(Ae),at=function(l){function e(h,m){return l.call(this,h,m)||this}return De(e,l),Object.defineProperty(e.prototype,"type",{get:function(){return Ee.ViewPort},enumerable:!1,configurable:!0}),e}(Ae),lt=function(l){function e(h,m){return l.call(this,h,m)||this}return De(e,l),Object.defineProperty(e.prototype,"type",{get:function(){return Ee.FontFace},enumerable:!1,configurable:!0}),e}(Ae),ct=function(l){function e(h,m){return l.call(this,h,m)||this}return De(e,l),Object.defineProperty(e.prototype,"type",{get:function(){return Ee.NestedProperties},enumerable:!1,configurable:!0}),e}(Ae),dt=function(l){function e(h,m){return l.call(this,h,m)||this}return De(e,l),Object.defineProperty(e.prototype,"type",{get:function(){return Ee.Keyframe},enumerable:!1,configurable:!0}),e.prototype.setKeyword=function(l){return this.setNode("keyword",l,0)},e.prototype.getKeyword=function(){return this.keyword},e.prototype.setIdentifier=function(l){return this.setNode("identifier",l,0)},e.prototype.getIdentifier=function(){return this.identifier},e.prototype.getName=function(){return this.identifier?this.identifier.getText():""},e}(Ae),pt=function(l){function e(h,m){return l.call(this,h,m)||this}return De(e,l),Object.defineProperty(e.prototype,"type",{get:function(){return Ee.KeyframeSelector},enumerable:!1,configurable:!0}),e}(Ae),ht=function(l){function e(h,m){return l.call(this,h,m)||this}return De(e,l),Object.defineProperty(e.prototype,"type",{get:function(){return Ee.Import},enumerable:!1,configurable:!0}),e.prototype.setMedialist=function(l){return!!l&&(l.attachTo(this),!0)},e}(Te),mt=function(l){function e(){return null!==l&&l.apply(this,arguments)||this}return De(e,l),Object.defineProperty(e.prototype,"type",{get:function(){return Ee.Use},enumerable:!1,configurable:!0}),e.prototype.getParameters=function(){return this.parameters||(this.parameters=new Ie(this)),this.parameters},e.prototype.setIdentifier=function(l){return this.setNode("identifier",l,0)},e.prototype.getIdentifier=function(){return this.identifier},e}(Te),gt=function(l){function e(){return null!==l&&l.apply(this,arguments)||this}return De(e,l),Object.defineProperty(e.prototype,"type",{get:function(){return Ee.ModuleConfiguration},enumerable:!1,configurable:!0}),e.prototype.setIdentifier=function(l){return this.setNode("identifier",l,0)},e.prototype.getIdentifier=function(){return this.identifier},e.prototype.getName=function(){return this.identifier?this.identifier.getText():""},e.prototype.setValue=function(l){return this.setNode("value",l,0)},e.prototype.getValue=function(){return this.value},e}(Te),bt=function(l){function e(){return null!==l&&l.apply(this,arguments)||this}return De(e,l),Object.defineProperty(e.prototype,"type",{get:function(){return Ee.Forward},enumerable:!1,configurable:!0}),e.prototype.setIdentifier=function(l){return this.setNode("identifier",l,0)},e.prototype.getIdentifier=function(){return this.identifier},e.prototype.getMembers=function(){return this.members||(this.members=new Ie(this)),this.members},e.prototype.getParameters=function(){return this.parameters||(this.parameters=new Ie(this)),this.parameters},e}(Te),vt=function(l){function e(){return null!==l&&l.apply(this,arguments)||this}return De(e,l),Object.defineProperty(e.prototype,"type",{get:function(){return Ee.ForwardVisibility},enumerable:!1,configurable:!0}),e.prototype.setIdentifier=function(l){return this.setNode("identifier",l,0)},e.prototype.getIdentifier=function(){return this.identifier},e}(Te),yt=function(l){function e(h,m){return l.call(this,h,m)||this}return De(e,l),Object.defineProperty(e.prototype,"type",{get:function(){return Ee.Namespace},enumerable:!1,configurable:!0}),e}(Te),xt=function(l){function e(h,m){return l.call(this,h,m)||this}return De(e,l),Object.defineProperty(e.prototype,"type",{get:function(){return Ee.Media},enumerable:!1,configurable:!0}),e}(Ae),St=function(l){function e(h,m){return l.call(this,h,m)||this}return De(e,l),Object.defineProperty(e.prototype,"type",{get:function(){return Ee.Supports},enumerable:!1,configurable:!0}),e}(Ae),kt=function(l){function e(h,m){return l.call(this,h,m)||this}return De(e,l),Object.defineProperty(e.prototype,"type",{get:function(){return Ee.Document},enumerable:!1,configurable:!0}),e}(Ae),Ct=function(l){function e(h,m){return l.call(this,h,m)||this}return De(e,l),e.prototype.getMediums=function(){return this.mediums||(this.mediums=new Ie(this)),this.mediums},e}(Te),Ft=function(l){function e(h,m){return l.call(this,h,m)||this}return De(e,l),Object.defineProperty(e.prototype,"type",{get:function(){return Ee.MediaQuery},enumerable:!1,configurable:!0}),e}(Te),Et=function(l){function e(h,m){return l.call(this,h,m)||this}return De(e,l),Object.defineProperty(e.prototype,"type",{get:function(){return Ee.MediaCondition},enumerable:!1,configurable:!0}),e}(Te),zt=function(l){function e(h,m){return l.call(this,h,m)||this}return De(e,l),Object.defineProperty(e.prototype,"type",{get:function(){return Ee.MediaFeature},enumerable:!1,configurable:!0}),e}(Te),Dt=function(l){function e(h,m){return l.call(this,h,m)||this}return De(e,l),Object.defineProperty(e.prototype,"type",{get:function(){return Ee.SupportsCondition},enumerable:!1,configurable:!0}),e}(Te),Rt=function(l){function e(h,m){return l.call(this,h,m)||this}return De(e,l),Object.defineProperty(e.prototype,"type",{get:function(){return Ee.Page},enumerable:!1,configurable:!0}),e}(Ae),Tt=function(l){function e(h,m){return l.call(this,h,m)||this}return De(e,l),Object.defineProperty(e.prototype,"type",{get:function(){return Ee.PageBoxMarginBox},enumerable:!1,configurable:!0}),e}(Ae),It=function(l){function e(h,m){return l.call(this,h,m)||this}return De(e,l),Object.defineProperty(e.prototype,"type",{get:function(){return Ee.Expression},enumerable:!1,configurable:!0}),e}(Te),Mt=function(l){function e(h,m){return l.call(this,h,m)||this}return De(e,l),Object.defineProperty(e.prototype,"type",{get:function(){return Ee.BinaryExpression},enumerable:!1,configurable:!0}),e.prototype.setLeft=function(l){return this.setNode("left",l)},e.prototype.getLeft=function(){return this.left},e.prototype.setRight=function(l){return this.setNode("right",l)},e.prototype.getRight=function(){return this.right},e.prototype.setOperator=function(l){return this.setNode("operator",l)},e.prototype.getOperator=function(){return this.operator},e}(Te),Pt=function(l){function e(h,m){return l.call(this,h,m)||this}return De(e,l),Object.defineProperty(e.prototype,"type",{get:function(){return Ee.Term},enumerable:!1,configurable:!0}),e.prototype.setOperator=function(l){return this.setNode("operator",l)},e.prototype.getOperator=function(){return this.operator},e.prototype.setExpression=function(l){return this.setNode("expression",l)},e.prototype.getExpression=function(){return this.expression},e}(Te),_t=function(l){function e(h,m){return l.call(this,h,m)||this}return De(e,l),Object.defineProperty(e.prototype,"type",{get:function(){return Ee.AttributeSelector},enumerable:!1,configurable:!0}),e.prototype.setNamespacePrefix=function(l){return this.setNode("namespacePrefix",l)},e.prototype.getNamespacePrefix=function(){return this.namespacePrefix},e.prototype.setIdentifier=function(l){return this.setNode("identifier",l)},e.prototype.getIdentifier=function(){return this.identifier},e.prototype.setOperator=function(l){return this.setNode("operator",l)},e.prototype.getOperator=function(){return this.operator},e.prototype.setValue=function(l){return this.setNode("value",l)},e.prototype.getValue=function(){return this.value},e}(Te),Nt=(function(l){function e(h,m){return l.call(this,h,m)||this}De(e,l),Object.defineProperty(e.prototype,"type",{get:function(){return Ee.Operator},enumerable:!1,configurable:!0})}(Te),function(l){function e(h,m){return l.call(this,h,m)||this}return De(e,l),Object.defineProperty(e.prototype,"type",{get:function(){return Ee.HexColorValue},enumerable:!1,configurable:!0}),e}(Te)),At=function(l){function e(h,m){return l.call(this,h,m)||this}return De(e,l),Object.defineProperty(e.prototype,"type",{get:function(){return Ee.RatioValue},enumerable:!1,configurable:!0}),e}(Te),Ot=".".charCodeAt(0),Ut="0".charCodeAt(0),jt="9".charCodeAt(0),Kt=function(l){function e(h,m){return l.call(this,h,m)||this}return De(e,l),Object.defineProperty(e.prototype,"type",{get:function(){return Ee.NumericValue},enumerable:!1,configurable:!0}),e.prototype.getValue=function(){for(var l,h=this.getText(),m=0,b=0,y=h.length;b<y&&(l=h.charCodeAt(b),Ut<=l&&l<=jt||l===Ot);b++)m+=1;return{value:h.substring(0,m),unit:m<h.length?h.substring(m):void 0}},e}(Te),Jt=function(l){function e(h,m){var b=l.call(this,h,m)||this;return b.variable=null,b.value=null,b.needsSemicolon=!0,b}return De(e,l),Object.defineProperty(e.prototype,"type",{get:function(){return Ee.VariableDeclaration},enumerable:!1,configurable:!0}),e.prototype.setVariable=function(l){return!!l&&(l.attachTo(this),this.variable=l,!0)},e.prototype.getVariable=function(){return this.variable},e.prototype.getName=function(){return this.variable?this.variable.getName():""},e.prototype.setValue=function(l){return!!l&&(l.attachTo(this),this.value=l,!0)},e.prototype.getValue=function(){return this.value},e}(Ue),Xt=function(l){function e(h,m){return l.call(this,h,m)||this}return De(e,l),Object.defineProperty(e.prototype,"type",{get:function(){return Ee.Interpolation},enumerable:!1,configurable:!0}),e}(Te),Zt=function(l){function e(h,m){return l.call(this,h,m)||this}return De(e,l),Object.defineProperty(e.prototype,"type",{get:function(){return Ee.VariableName},enumerable:!1,configurable:!0}),e.prototype.getName=function(){return this.getText()},e}(Te),Qt=function(l){function e(h,m){return l.call(this,h,m)||this}return De(e,l),Object.defineProperty(e.prototype,"type",{get:function(){return Ee.ExtendsReference},enumerable:!1,configurable:!0}),e.prototype.getSelectors=function(){return this.selectors||(this.selectors=new Ie(this)),this.selectors},e}(Te),nn=function(l){function e(h,m){return l.call(this,h,m)||this}return De(e,l),Object.defineProperty(e.prototype,"type",{get:function(){return Ee.MixinContentReference},enumerable:!1,configurable:!0}),e.prototype.getArguments=function(){return this.arguments||(this.arguments=new Ie(this)),this.arguments},e}(Te),rn=function(l){function e(h,m){return l.call(this,h,m)||this}return De(e,l),Object.defineProperty(e.prototype,"type",{get:function(){return Ee.MixinContentReference},enumerable:!1,configurable:!0}),e.prototype.getParameters=function(){return this.parameters||(this.parameters=new Ie(this)),this.parameters},e}(Ae),on=function(l){function e(h,m){return l.call(this,h,m)||this}return De(e,l),Object.defineProperty(e.prototype,"type",{get:function(){return Ee.MixinReference},enumerable:!1,configurable:!0}),e.prototype.getNamespaces=function(){return this.namespaces||(this.namespaces=new Ie(this)),this.namespaces},e.prototype.setIdentifier=function(l){return this.setNode("identifier",l,0)},e.prototype.getIdentifier=function(){return this.identifier},e.prototype.getName=function(){return this.identifier?this.identifier.getText():""},e.prototype.getArguments=function(){return this.arguments||(this.arguments=new Ie(this)),this.arguments},e.prototype.setContent=function(l){return this.setNode("content",l)},e.prototype.getContent=function(){return this.content},e}(Te),sn=function(l){function e(h,m){return l.call(this,h,m)||this}return De(e,l),Object.defineProperty(e.prototype,"type",{get:function(){return Ee.MixinDeclaration},enumerable:!1,configurable:!0}),e.prototype.setIdentifier=function(l){return this.setNode("identifier",l,0)},e.prototype.getIdentifier=function(){return this.identifier},e.prototype.getName=function(){return this.identifier?this.identifier.getText():""},e.prototype.getParameters=function(){return this.parameters||(this.parameters=new Ie(this)),this.parameters},e.prototype.setGuard=function(l){return l&&(l.attachTo(this),this.guard=l),!1},e}(Ae),an=function(l){function e(h,m){return l.call(this,h,m)||this}return De(e,l),Object.defineProperty(e.prototype,"type",{get:function(){return Ee.UnknownAtRule},enumerable:!1,configurable:!0}),e.prototype.setAtRuleName=function(l){this.atRuleName=l},e.prototype.getAtRuleName=function(){return this.atRuleName},e}(Ae),ln=function(l){function e(){return null!==l&&l.apply(this,arguments)||this}return De(e,l),Object.defineProperty(e.prototype,"type",{get:function(){return Ee.ListEntry},enumerable:!1,configurable:!0}),e.prototype.setKey=function(l){return this.setNode("key",l,0)},e.prototype.setValue=function(l){return this.setNode("value",l,1)},e}(Te),cn=function(l){function e(){return null!==l&&l.apply(this,arguments)||this}return De(e,l),e.prototype.getConditions=function(){return this.conditions||(this.conditions=new Ie(this)),this.conditions},e}(Te),dn=function(l){function e(){return null!==l&&l.apply(this,arguments)||this}return De(e,l),e.prototype.setVariable=function(l){return this.setNode("variable",l)},e}(Te),pn=function(l){function e(){return null!==l&&l.apply(this,arguments)||this}return De(e,l),Object.defineProperty(e.prototype,"type",{get:function(){return Ee.Module},enumerable:!1,configurable:!0}),e.prototype.setIdentifier=function(l){return this.setNode("identifier",l,0)},e.prototype.getIdentifier=function(){return this.identifier},e}(Te);!function(l){l[l.Ignore=1]="Ignore",l[l.Warning=2]="Warning",l[l.Error=4]="Error"}(Re||(Re={}));var hn=function(){function n(l,h,m,b,y,w){void 0===y&&(y=l.offset),void 0===w&&(w=l.length),this.node=l,this.rule=h,this.level=m,this.message=b||h.message,this.offset=y,this.length=w}return n.prototype.getRule=function(){return this.rule},n.prototype.getLevel=function(){return this.level},n.prototype.getOffset=function(){return this.offset},n.prototype.getLength=function(){return this.length},n.prototype.getNode=function(){return this.node},n.prototype.getMessage=function(){return this.message},n}(),mn=function(){function n(){this.entries=[]}return n.entries=function(l){var h=new n;return l.acceptVisitor(h),h.entries},n.prototype.visitNode=function(l){return l.isErroneous()&&l.collectIssues(this.entries),!0},n}();function Da(l,h,...m){return function Ea(l,h){let m;return m=0===h.length?l:l.replace(/\{(\d+)\}/g,((l,m)=>{let b=m[0];return typeof h[b]<"u"?h[b]:l})),m}(h,m)}function $(l){return Da}var un,fn,gn,bn,yn,wn,xn,Sn,kn,Cn,zn,Rn,Tn,Mn,Pn,_n,Nn,An,On,Wn,Ln,Un,jn,Vn,Bn,$n,Kn=$(),qn=function l(h,m){this.id=h,this.message=m},Hn={NumberExpected:new qn("css-numberexpected",Kn("expected.number","number expected")),ConditionExpected:new qn("css-conditionexpected",Kn("expected.condt","condition expected")),RuleOrSelectorExpected:new qn("css-ruleorselectorexpected",Kn("expected.ruleorselector","at-rule or selector expected")),DotExpected:new qn("css-dotexpected",Kn("expected.dot","dot expected")),ColonExpected:new qn("css-colonexpected",Kn("expected.colon","colon expected")),SemiColonExpected:new qn("css-semicolonexpected",Kn("expected.semicolon","semi-colon expected")),TermExpected:new qn("css-termexpected",Kn("expected.term","term expected")),ExpressionExpected:new qn("css-expressionexpected",Kn("expected.expression","expression expected")),OperatorExpected:new qn("css-operatorexpected",Kn("expected.operator","operator expected")),IdentifierExpected:new qn("css-identifierexpected",Kn("expected.ident","identifier expected")),PercentageExpected:new qn("css-percentageexpected",Kn("expected.percentage","percentage expected")),URIOrStringExpected:new qn("css-uriorstringexpected",Kn("expected.uriorstring","uri or string expected")),URIExpected:new qn("css-uriexpected",Kn("expected.uri","URI expected")),VariableNameExpected:new qn("css-varnameexpected",Kn("expected.varname","variable name expected")),VariableValueExpected:new qn("css-varvalueexpected",Kn("expected.varvalue","variable value expected")),PropertyValueExpected:new qn("css-propertyvalueexpected",Kn("expected.propvalue","property value expected")),LeftCurlyExpected:new qn("css-lcurlyexpected",Kn("expected.lcurly","{ expected")),RightCurlyExpected:new qn("css-rcurlyexpected",Kn("expected.rcurly","} expected")),LeftSquareBracketExpected:new qn("css-rbracketexpected",Kn("expected.lsquare","[ expected")),RightSquareBracketExpected:new qn("css-lbracketexpected",Kn("expected.rsquare","] expected")),LeftParenthesisExpected:new qn("css-lparentexpected",Kn("expected.lparen","( expected")),RightParenthesisExpected:new qn("css-rparentexpected",Kn("expected.rparent",") expected")),CommaExpected:new qn("css-commaexpected",Kn("expected.comma","comma expected")),PageDirectiveOrDeclarationExpected:new qn("css-pagedirordeclexpected",Kn("expected.pagedirordecl","page directive or declaraton expected")),UnknownAtRule:new qn("css-unknownatrule",Kn("unknown.atrule","at-rule unknown")),UnknownKeyword:new qn("css-unknownkeyword",Kn("unknown.keyword","unknown keyword")),SelectorExpected:new qn("css-selectorexpected",Kn("expected.selector","selector expected")),StringLiteralExpected:new qn("css-stringliteralexpected",Kn("expected.stringliteral","string literal expected")),WhitespaceExpected:new qn("css-whitespaceexpected",Kn("expected.whitespace","whitespace expected")),MediaQueryExpected:new qn("css-mediaqueryexpected",Kn("expected.mediaquery","media query expected")),IdentifierOrWildcardExpected:new qn("css-idorwildcardexpected",Kn("expected.idorwildcard","identifier or wildcard expected")),WildcardExpected:new qn("css-wildcardexpected",Kn("expected.wildcard","wildcard expected")),IdentifierOrVariableExpected:new qn("css-idorvarexpected",Kn("expected.idorvar","identifier or variable expected"))};!function(l){l.MIN_VALUE=-2147483648,l.MAX_VALUE=2147483647}(un||(un={})),function(l){l.MIN_VALUE=0,l.MAX_VALUE=2147483647}(fn||(fn={})),function(l){l.create=function e(l,h){return l===Number.MAX_VALUE&&(l=fn.MAX_VALUE),h===Number.MAX_VALUE&&(h=fn.MAX_VALUE),{line:l,character:h}},l.is=function t(l){var h=l;return _r.objectLiteral(h)&&_r.uinteger(h.line)&&_r.uinteger(h.character)}}(gn||(gn={})),function(l){l.create=function e(l,h,m,b){if(_r.uinteger(l)&&_r.uinteger(h)&&_r.uinteger(m)&&_r.uinteger(b))return{start:gn.create(l,h),end:gn.create(m,b)};if(gn.is(l)&&gn.is(h))return{start:l,end:h};throw new Error("Range#create called with invalid arguments["+l+", "+h+", "+m+", "+b+"]")},l.is=function t(l){var h=l;return _r.objectLiteral(h)&&gn.is(h.start)&&gn.is(h.end)}}(bn||(bn={})),function(l){l.create=function e(l,h){return{uri:l,range:h}},l.is=function t(l){var h=l;return _r.defined(h)&&bn.is(h.range)&&(_r.string(h.uri)||_r.undefined(h.uri))}}(yn||(yn={})),function(l){l.create=function e(l,h,m,b){return{targetUri:l,targetRange:h,targetSelectionRange:m,originSelectionRange:b}},l.is=function t(l){var h=l;return _r.defined(h)&&bn.is(h.targetRange)&&_r.string(h.targetUri)&&(bn.is(h.targetSelectionRange)||_r.undefined(h.targetSelectionRange))&&(bn.is(h.originSelectionRange)||_r.undefined(h.originSelectionRange))}}(wn||(wn={})),function(l){l.create=function e(l,h,m,b){return{red:l,green:h,blue:m,alpha:b}},l.is=function t(l){var h=l;return _r.numberRange(h.red,0,1)&&_r.numberRange(h.green,0,1)&&_r.numberRange(h.blue,0,1)&&_r.numberRange(h.alpha,0,1)}}(xn||(xn={})),function(l){l.create=function e(l,h){return{range:l,color:h}},l.is=function t(l){var h=l;return bn.is(h.range)&&xn.is(h.color)}}(Sn||(Sn={})),function(l){l.create=function e(l,h,m){return{label:l,textEdit:h,additionalTextEdits:m}},l.is=function t(l){var h=l;return _r.string(h.label)&&(_r.undefined(h.textEdit)||An.is(h))&&(_r.undefined(h.additionalTextEdits)||_r.typedArray(h.additionalTextEdits,An.is))}}(kn||(kn={})),function(l){l.Comment="comment",l.Imports="imports",l.Region="region"}(Cn||(Cn={})),function(l){l.create=function e(l,h,m,b,y){var w={startLine:l,endLine:h};return _r.defined(m)&&(w.startCharacter=m),_r.defined(b)&&(w.endCharacter=b),_r.defined(y)&&(w.kind=y),w},l.is=function t(l){var h=l;return _r.uinteger(h.startLine)&&_r.uinteger(h.startLine)&&(_r.undefined(h.startCharacter)||_r.uinteger(h.startCharacter))&&(_r.undefined(h.endCharacter)||_r.uinteger(h.endCharacter))&&(_r.undefined(h.kind)||_r.string(h.kind))}}(zn||(zn={})),function(l){l.create=function e(l,h){return{location:l,message:h}},l.is=function t(l){var h=l;return _r.defined(h)&&yn.is(h.location)&&_r.string(h.message)}}(Rn||(Rn={})),function(l){l.Error=1,l.Warning=2,l.Information=3,l.Hint=4}(Tn||(Tn={})),function(l){l.Unnecessary=1,l.Deprecated=2}(Mn||(Mn={})),function(l){l.is=function e(l){var h=l;return null!=h&&_r.string(h.href)}}(Pn||(Pn={})),function(l){l.create=function e(l,h,m,b,y,w){var x={range:l,message:h};return _r.defined(m)&&(x.severity=m),_r.defined(b)&&(x.code=b),_r.defined(y)&&(x.source=y),_r.defined(w)&&(x.relatedInformation=w),x},l.is=function t(l){var h,m=l;return _r.defined(m)&&bn.is(m.range)&&_r.string(m.message)&&(_r.number(m.severity)||_r.undefined(m.severity))&&(_r.integer(m.code)||_r.string(m.code)||_r.undefined(m.code))&&(_r.undefined(m.codeDescription)||_r.string(null===(h=m.codeDescription)||void 0===h?void 0:h.href))&&(_r.string(m.source)||_r.undefined(m.source))&&(_r.undefined(m.relatedInformation)||_r.typedArray(m.relatedInformation,Rn.is))}}(_n||(_n={})),function(l){l.create=function e(l,h){for(var m=[],b=2;b<arguments.length;b++)m[b-2]=arguments[b];var y={title:l,command:h};return _r.defined(m)&&m.length>0&&(y.arguments=m),y},l.is=function t(l){var h=l;return _r.defined(h)&&_r.string(h.title)&&_r.string(h.command)}}(Nn||(Nn={})),function(l){l.replace=function e(l,h){return{range:l,newText:h}},l.insert=function t(l,h){return{range:{start:l,end:l},newText:h}},l.del=function r(l){return{range:l,newText:""}},l.is=function i(l){var h=l;return _r.objectLiteral(h)&&_r.string(h.newText)&&bn.is(h.range)}}(An||(An={})),function(l){l.create=function e(l,h,m){var b={label:l};return void 0!==h&&(b.needsConfirmation=h),void 0!==m&&(b.description=m),b},l.is=function t(l){var h=l;return void 0!==h&&_r.objectLiteral(h)&&_r.string(h.label)&&(_r.boolean(h.needsConfirmation)||void 0===h.needsConfirmation)&&(_r.string(h.description)||void 0===h.description)}}(On||(On={})),function(l){l.is=function e(l){return"string"==typeof l}}(Wn||(Wn={})),function(l){l.replace=function e(l,h,m){return{range:l,newText:h,annotationId:m}},l.insert=function t(l,h,m){return{range:{start:l,end:l},newText:h,annotationId:m}},l.del=function r(l,h){return{range:l,newText:"",annotationId:h}},l.is=function i(l){var h=l;return An.is(h)&&(On.is(h.annotationId)||Wn.is(h.annotationId))}}(Ln||(Ln={})),function(l){l.create=function e(l,h){return{textDocument:l,edits:h}},l.is=function t(l){var h=l;return _r.defined(h)&&Yn.is(h.textDocument)&&Array.isArray(h.edits)}}(Un||(Un={})),function(l){l.create=function e(l,h,m){var b={kind:"create",uri:l};return void 0!==h&&(void 0!==h.overwrite||void 0!==h.ignoreIfExists)&&(b.options=h),void 0!==m&&(b.annotationId=m),b},l.is=function t(l){var h=l;return h&&"create"===h.kind&&_r.string(h.uri)&&(void 0===h.options||(void 0===h.options.overwrite||_r.boolean(h.options.overwrite))&&(void 0===h.options.ignoreIfExists||_r.boolean(h.options.ignoreIfExists)))&&(void 0===h.annotationId||Wn.is(h.annotationId))}}(jn||(jn={})),function(l){l.create=function e(l,h,m,b){var y={kind:"rename",oldUri:l,newUri:h};return void 0!==m&&(void 0!==m.overwrite||void 0!==m.ignoreIfExists)&&(y.options=m),void 0!==b&&(y.annotationId=b),y},l.is=function t(l){var h=l;return h&&"rename"===h.kind&&_r.string(h.oldUri)&&_r.string(h.newUri)&&(void 0===h.options||(void 0===h.options.overwrite||_r.boolean(h.options.overwrite))&&(void 0===h.options.ignoreIfExists||_r.boolean(h.options.ignoreIfExists)))&&(void 0===h.annotationId||Wn.is(h.annotationId))}}(Vn||(Vn={})),function(l){l.create=function e(l,h,m){var b={kind:"delete",uri:l};return void 0!==h&&(void 0!==h.recursive||void 0!==h.ignoreIfNotExists)&&(b.options=h),void 0!==m&&(b.annotationId=m),b},l.is=function t(l){var h=l;return h&&"delete"===h.kind&&_r.string(h.uri)&&(void 0===h.options||(void 0===h.options.recursive||_r.boolean(h.options.recursive))&&(void 0===h.options.ignoreIfNotExists||_r.boolean(h.options.ignoreIfNotExists)))&&(void 0===h.annotationId||Wn.is(h.annotationId))}}(Bn||(Bn={})),function(l){l.is=function e(l){var h=l;return h&&(void 0!==h.changes||void 0!==h.documentChanges)&&(void 0===h.documentChanges||h.documentChanges.every((function(l){return _r.string(l.kind)?jn.is(l)||Vn.is(l)||Bn.is(l):Un.is(l)})))}}($n||($n={}));var Jn,Xn,Yn,Zn,Qn,er,tr,nr,rr,ir,or,sr,ar,lr,cr,pr,hr,mr,ur,fr,gr,br,vr,yr,wr,xr,Cr,Fr,Er,Tr,Ir,Mr=function(){function n(l,h){this.edits=l,this.changeAnnotations=h}return n.prototype.insert=function(l,h,m){var b,y;if(void 0===m?b=An.insert(l,h):Wn.is(m)?(y=m,b=Ln.insert(l,h,m)):(this.assertChangeAnnotations(this.changeAnnotations),y=this.changeAnnotations.manage(m),b=Ln.insert(l,h,y)),this.edits.push(b),void 0!==y)return y},n.prototype.replace=function(l,h,m){var b,y;if(void 0===m?b=An.replace(l,h):Wn.is(m)?(y=m,b=Ln.replace(l,h,m)):(this.assertChangeAnnotations(this.changeAnnotations),y=this.changeAnnotations.manage(m),b=Ln.replace(l,h,y)),this.edits.push(b),void 0!==y)return y},n.prototype.delete=function(l,h){var m,b;if(void 0===h?m=An.del(l):Wn.is(h)?(b=h,m=Ln.del(l,h)):(this.assertChangeAnnotations(this.changeAnnotations),b=this.changeAnnotations.manage(h),m=Ln.del(l,b)),this.edits.push(m),void 0!==b)return b},n.prototype.add=function(l){this.edits.push(l)},n.prototype.all=function(){return this.edits},n.prototype.clear=function(){this.edits.splice(0,this.edits.length)},n.prototype.assertChangeAnnotations=function(l){if(void 0===l)throw new Error("Text edit change is not configured to manage change annotations.")},n}(),Pr=function(){function n(l){this._annotations=void 0===l?Object.create(null):l,this._counter=0,this._size=0}return n.prototype.all=function(){return this._annotations},Object.defineProperty(n.prototype,"size",{get:function(){return this._size},enumerable:!1,configurable:!0}),n.prototype.manage=function(l,h){var m;if(Wn.is(l)?m=l:(m=this.nextId(),h=l),void 0!==this._annotations[m])throw new Error("Id "+m+" is already in use.");if(void 0===h)throw new Error("No annotation provided for id "+m);return this._annotations[m]=h,this._size++,m},n.prototype.nextId=function(){return this._counter++,this._counter.toString()},n}();!function(){function n(l){var h=this;this._textEditChanges=Object.create(null),void 0!==l?(this._workspaceEdit=l,l.documentChanges?(this._changeAnnotations=new Pr(l.changeAnnotations),l.changeAnnotations=this._changeAnnotations.all(),l.documentChanges.forEach((function(l){if(Un.is(l)){var m=new Mr(l.edits,h._changeAnnotations);h._textEditChanges[l.textDocument.uri]=m}}))):l.changes&&Object.keys(l.changes).forEach((function(m){var b=new Mr(l.changes[m]);h._textEditChanges[m]=b}))):this._workspaceEdit={}}Object.defineProperty(n.prototype,"edit",{get:function(){return this.initDocumentChanges(),void 0!==this._changeAnnotations&&(0===this._changeAnnotations.size?this._workspaceEdit.changeAnnotations=void 0:this._workspaceEdit.changeAnnotations=this._changeAnnotations.all()),this._workspaceEdit},enumerable:!1,configurable:!0}),n.prototype.getTextEditChange=function(l){if(Yn.is(l)){if(this.initDocumentChanges(),void 0===this._workspaceEdit.documentChanges)throw new Error("Workspace edit is not configured for document changes.");var h={uri:l.uri,version:l.version};if(!(b=this._textEditChanges[h.uri])){var m={textDocument:h,edits:y=[]};this._workspaceEdit.documentChanges.push(m),b=new Mr(y,this._changeAnnotations),this._textEditChanges[h.uri]=b}return b}if(this.initChanges(),void 0===this._workspaceEdit.changes)throw new Error("Workspace edit is not configured for normal text edit changes.");var b;if(!(b=this._textEditChanges[l])){var y=[];this._workspaceEdit.changes[l]=y,b=new Mr(y),this._textEditChanges[l]=b}return b},n.prototype.initDocumentChanges=function(){void 0===this._workspaceEdit.documentChanges&&void 0===this._workspaceEdit.changes&&(this._changeAnnotations=new Pr,this._workspaceEdit.documentChanges=[],this._workspaceEdit.changeAnnotations=this._changeAnnotations.all())},n.prototype.initChanges=function(){void 0===this._workspaceEdit.documentChanges&&void 0===this._workspaceEdit.changes&&(this._workspaceEdit.changes=Object.create(null))},n.prototype.createFile=function(l,h,m){if(this.initDocumentChanges(),void 0===this._workspaceEdit.documentChanges)throw new Error("Workspace edit is not configured for document changes.");var b,y,w;if(On.is(h)||Wn.is(h)?b=h:m=h,void 0===b?y=jn.create(l,m):(w=Wn.is(b)?b:this._changeAnnotations.manage(b),y=jn.create(l,m,w)),this._workspaceEdit.documentChanges.push(y),void 0!==w)return w},n.prototype.renameFile=function(l,h,m,b){if(this.initDocumentChanges(),void 0===this._workspaceEdit.documentChanges)throw new Error("Workspace edit is not configured for document changes.");var y,w,x;if(On.is(m)||Wn.is(m)?y=m:b=m,void 0===y?w=Vn.create(l,h,b):(x=Wn.is(y)?y:this._changeAnnotations.manage(y),w=Vn.create(l,h,b,x)),this._workspaceEdit.documentChanges.push(w),void 0!==x)return x},n.prototype.deleteFile=function(l,h,m){if(this.initDocumentChanges(),void 0===this._workspaceEdit.documentChanges)throw new Error("Workspace edit is not configured for document changes.");var b,y,w;if(On.is(h)||Wn.is(h)?b=h:m=h,void 0===b?y=Bn.create(l,m):(w=Wn.is(b)?b:this._changeAnnotations.manage(b),y=Bn.create(l,m,w)),this._workspaceEdit.documentChanges.push(y),void 0!==w)return w}}();!function(l){l.create=function e(l){return{uri:l}},l.is=function t(l){var h=l;return _r.defined(h)&&_r.string(h.uri)}}(Jn||(Jn={})),function(l){l.create=function e(l,h){return{uri:l,version:h}},l.is=function t(l){var h=l;return _r.defined(h)&&_r.string(h.uri)&&_r.integer(h.version)}}(Xn||(Xn={})),function(l){l.create=function e(l,h){return{uri:l,version:h}},l.is=function t(l){var h=l;return _r.defined(h)&&_r.string(h.uri)&&(null===h.version||_r.integer(h.version))}}(Yn||(Yn={})),function(l){l.create=function e(l,h,m,b){return{uri:l,languageId:h,version:m,text:b}},l.is=function t(l){var h=l;return _r.defined(h)&&_r.string(h.uri)&&_r.string(h.languageId)&&_r.integer(h.version)&&_r.string(h.text)}}(Zn||(Zn={})),function(l){l.PlainText="plaintext",l.Markdown="markdown"}(Qn||(Qn={})),function(l){l.is=function e(h){var m=h;return m===l.PlainText||m===l.Markdown}}(Qn||(Qn={})),function(l){l.is=function e(l){var h=l;return _r.objectLiteral(l)&&Qn.is(h.kind)&&_r.string(h.value)}}(er||(er={})),function(l){l.Text=1,l.Method=2,l.Function=3,l.Constructor=4,l.Field=5,l.Variable=6,l.Class=7,l.Interface=8,l.Module=9,l.Property=10,l.Unit=11,l.Value=12,l.Enum=13,l.Keyword=14,l.Snippet=15,l.Color=16,l.File=17,l.Reference=18,l.Folder=19,l.EnumMember=20,l.Constant=21,l.Struct=22,l.Event=23,l.Operator=24,l.TypeParameter=25}(tr||(tr={})),function(l){l.PlainText=1,l.Snippet=2}(nr||(nr={})),function(l){l.Deprecated=1}(rr||(rr={})),function(l){l.create=function e(l,h,m){return{newText:l,insert:h,replace:m}},l.is=function t(l){var h=l;return h&&_r.string(h.newText)&&bn.is(h.insert)&&bn.is(h.replace)}}(ir||(ir={})),function(l){l.asIs=1,l.adjustIndentation=2}(or||(or={})),function(l){l.create=function e(l){return{label:l}}}(sr||(sr={})),function(l){l.create=function e(l,h){return{items:l||[],isIncomplete:!!h}}}(ar||(ar={})),function(l){l.fromPlainText=function e(l){return l.replace(/[\\`*_{}[\]()#+\-.!]/g,"\\$&")},l.is=function t(l){var h=l;return _r.string(h)||_r.objectLiteral(h)&&_r.string(h.language)&&_r.string(h.value)}}(lr||(lr={})),function(l){l.is=function e(l){var h=l;return!!h&&_r.objectLiteral(h)&&(er.is(h.contents)||lr.is(h.contents)||_r.typedArray(h.contents,lr.is))&&(void 0===l.range||bn.is(l.range))}}(cr||(cr={})),function(l){l.create=function e(l,h){return h?{label:l,documentation:h}:{label:l}}}(pr||(pr={})),function(l){l.create=function e(l,h){for(var m=[],b=2;b<arguments.length;b++)m[b-2]=arguments[b];var y={label:l};return _r.defined(h)&&(y.documentation=h),_r.defined(m)?y.parameters=m:y.parameters=[],y}}(hr||(hr={})),function(l){l.Text=1,l.Read=2,l.Write=3}(mr||(mr={})),function(l){l.create=function e(l,h){var m={range:l};return _r.number(h)&&(m.kind=h),m}}(ur||(ur={})),function(l){l.File=1,l.Module=2,l.Namespace=3,l.Package=4,l.Class=5,l.Method=6,l.Property=7,l.Field=8,l.Constructor=9,l.Enum=10,l.Interface=11,l.Function=12,l.Variable=13,l.Constant=14,l.String=15,l.Number=16,l.Boolean=17,l.Array=18,l.Object=19,l.Key=20,l.Null=21,l.EnumMember=22,l.Struct=23,l.Event=24,l.Operator=25,l.TypeParameter=26}(fr||(fr={})),function(l){l.Deprecated=1}(gr||(gr={})),function(l){l.create=function e(l,h,m,b,y){var w={name:l,kind:h,location:{uri:b,range:m}};return y&&(w.containerName=y),w}}(br||(br={})),function(l){l.create=function e(l,h,m,b,y,w){var x={name:l,detail:h,kind:m,range:b,selectionRange:y};return void 0!==w&&(x.children=w),x},l.is=function t(l){var h=l;return h&&_r.string(h.name)&&_r.number(h.kind)&&bn.is(h.range)&&bn.is(h.selectionRange)&&(void 0===h.detail||_r.string(h.detail))&&(void 0===h.deprecated||_r.boolean(h.deprecated))&&(void 0===h.children||Array.isArray(h.children))&&(void 0===h.tags||Array.isArray(h.tags))}}(vr||(vr={})),function(l){l.Empty="",l.QuickFix="quickfix",l.Refactor="refactor",l.RefactorExtract="refactor.extract",l.RefactorInline="refactor.inline",l.RefactorRewrite="refactor.rewrite",l.Source="source",l.SourceOrganizeImports="source.organizeImports",l.SourceFixAll="source.fixAll"}(yr||(yr={})),function(l){l.create=function e(l,h){var m={diagnostics:l};return null!=h&&(m.only=h),m},l.is=function t(l){var h=l;return _r.defined(h)&&_r.typedArray(h.diagnostics,_n.is)&&(void 0===h.only||_r.typedArray(h.only,_r.string))}}(wr||(wr={})),function(l){l.create=function e(l,h,m){var b={title:l},y=!0;return"string"==typeof h?(y=!1,b.kind=h):Nn.is(h)?b.command=h:b.edit=h,y&&void 0!==m&&(b.kind=m),b},l.is=function t(l){var h=l;return h&&_r.string(h.title)&&(void 0===h.diagnostics||_r.typedArray(h.diagnostics,_n.is))&&(void 0===h.kind||_r.string(h.kind))&&(void 0!==h.edit||void 0!==h.command)&&(void 0===h.command||Nn.is(h.command))&&(void 0===h.isPreferred||_r.boolean(h.isPreferred))&&(void 0===h.edit||$n.is(h.edit))}}(xr||(xr={})),function(l){l.create=function e(l,h){var m={range:l};return _r.defined(h)&&(m.data=h),m},l.is=function t(l){var h=l;return _r.defined(h)&&bn.is(h.range)&&(_r.undefined(h.command)||Nn.is(h.command))}}(Cr||(Cr={})),function(l){l.create=function e(l,h){return{tabSize:l,insertSpaces:h}},l.is=function t(l){var h=l;return _r.defined(h)&&_r.uinteger(h.tabSize)&&_r.boolean(h.insertSpaces)}}(Fr||(Fr={})),function(l){l.create=function e(l,h,m){return{range:l,target:h,data:m}},l.is=function t(l){var h=l;return _r.defined(h)&&bn.is(h.range)&&(_r.undefined(h.target)||_r.string(h.target))}}(Er||(Er={})),function(l){l.create=function e(l,h){return{range:l,parent:h}},l.is=function t(h){var m=h;return void 0!==m&&bn.is(m.range)&&(void 0===m.parent||l.is(m.parent))}}(Tr||(Tr={})),function(l){function i(l,h){if(l.length<=1)return l;var m=l.length/2|0,b=l.slice(0,m),y=l.slice(m);i(b,h),i(y,h);for(var w=0,x=0,F=0;w<b.length&&x<y.length;){var E=h(b[w],y[x]);l[F++]=E<=0?b[w++]:y[x++]}for(;w<b.length;)l[F++]=b[w++];for(;x<y.length;)l[F++]=y[x++];return l}l.create=function e(l,h,m,b){return new Nr(l,h,m,b)},l.is=function t(l){var h=l;return!!(_r.defined(h)&&_r.string(h.uri)&&(_r.undefined(h.languageId)||_r.string(h.languageId))&&_r.uinteger(h.lineCount)&&_r.func(h.getText)&&_r.func(h.positionAt)&&_r.func(h.offsetAt))},l.applyEdits=function r(l,h){for(var m=l.getText(),b=i(h,(function(l,h){var m=l.range.start.line-h.range.start.line;return 0===m?l.range.start.character-h.range.start.character:m})),y=m.length,w=b.length-1;w>=0;w--){var x=b[w],F=l.offsetAt(x.range.start),E=l.offsetAt(x.range.end);if(!(E<=y))throw new Error("Overlapping edit");m=m.substring(0,F)+x.newText+m.substring(E,m.length),y=F}return m}}(Ir||(Ir={}));var _r,Nr=function(){function n(l,h,m,b){this._uri=l,this._languageId=h,this._version=m,this._content=b,this._lineOffsets=void 0}return Object.defineProperty(n.prototype,"uri",{get:function(){return this._uri},enumerable:!1,configurable:!0}),Object.defineProperty(n.prototype,"languageId",{get:function(){return this._languageId},enumerable:!1,configurable:!0}),Object.defineProperty(n.prototype,"version",{get:function(){return this._version},enumerable:!1,configurable:!0}),n.prototype.getText=function(l){if(l){var h=this.offsetAt(l.start),m=this.offsetAt(l.end);return this._content.substring(h,m)}return this._content},n.prototype.update=function(l,h){this._content=l.text,this._version=h,this._lineOffsets=void 0},n.prototype.getLineOffsets=function(){if(void 0===this._lineOffsets){for(var l=[],h=this._content,m=!0,b=0;b<h.length;b++){m&&(l.push(b),m=!1);var y=h.charAt(b);m="\r"===y||"\n"===y,"\r"===y&&b+1<h.length&&"\n"===h.charAt(b+1)&&b++}m&&h.length>0&&l.push(h.length),this._lineOffsets=l}return this._lineOffsets},n.prototype.positionAt=function(l){l=Math.max(Math.min(l,this._content.length),0);var h=this.getLineOffsets(),m=0,b=h.length;if(0===b)return gn.create(0,l);for(;m<b;){var y=Math.floor((m+b)/2);h[y]>l?b=y:m=y+1}var w=m-1;return gn.create(w,l-h[w])},n.prototype.offsetAt=function(l){var h=this.getLineOffsets();if(l.line>=h.length)return this._content.length;if(l.line<0)return 0;var m=h[l.line],b=l.line+1<h.length?h[l.line+1]:this._content.length;return Math.max(Math.min(m+l.character,b),m)},Object.defineProperty(n.prototype,"lineCount",{get:function(){return this.getLineOffsets().length},enumerable:!1,configurable:!0}),n}();!function(l){var h=Object.prototype.toString;l.defined=function t(l){return typeof l<"u"},l.undefined=function r(l){return typeof l>"u"},l.boolean=function i(l){return!0===l||!1===l},l.string=function o(l){return"[object String]"===h.call(l)},l.number=function a(l){return"[object Number]"===h.call(l)},l.numberRange=function s(l,m,b){return"[object Number]"===h.call(l)&&m<=l&&l<=b},l.integer=function d(l){return"[object Number]"===h.call(l)&&-2147483648<=l&&l<=2147483647},l.uinteger=function c(l){return"[object Number]"===h.call(l)&&0<=l&&l<=2147483647},l.func=function p(l){return"[object Function]"===h.call(l)},l.objectLiteral=function u(l){return null!==l&&"object"==typeof l},l.typedArray=function f(l,h){return Array.isArray(l)&&l.every(h)}}(_r||(_r={}));var Ar,Or,Wr,Lr=class{constructor(l,h,m,b){this._uri=l,this._languageId=h,this._version=m,this._content=b,this._lineOffsets=void 0}get uri(){return this._uri}get languageId(){return this._languageId}get version(){return this._version}getText(l){if(l){let h=this.offsetAt(l.start),m=this.offsetAt(l.end);return this._content.substring(h,m)}return this._content}update(l,h){for(let h of l)if(Lr.isIncremental(h)){let l=Gi(h.range),m=this.offsetAt(l.start),b=this.offsetAt(l.end);this._content=this._content.substring(0,m)+h.text+this._content.substring(b,this._content.length);let y=Math.max(l.start.line,0),w=Math.max(l.end.line,0),x=this._lineOffsets,F=Ki(h.text,!1,m);if(w-y===F.length)for(let l=0,h=F.length;l<h;l++)x[l+y+1]=F[l];else F.length<1e4?x.splice(y+1,w-y,...F):this._lineOffsets=x=x.slice(0,y+1).concat(F,x.slice(w+1));let E=h.text.length-(b-m);if(0!==E)for(let l=y+1+F.length,h=x.length;l<h;l++)x[l]=x[l]+E}else{if(!Lr.isFull(h))throw new Error("Unknown change event received");this._content=h.text,this._lineOffsets=void 0}this._version=h}getLineOffsets(){return void 0===this._lineOffsets&&(this._lineOffsets=Ki(this._content,!0)),this._lineOffsets}positionAt(l){l=Math.max(Math.min(l,this._content.length),0);let h=this.getLineOffsets(),m=0,b=h.length;if(0===b)return{line:0,character:l};for(;m<b;){let y=Math.floor((m+b)/2);h[y]>l?b=y:m=y+1}let y=m-1;return{line:y,character:l-h[y]}}offsetAt(l){let h=this.getLineOffsets();if(l.line>=h.length)return this._content.length;if(l.line<0)return 0;let m=h[l.line],b=l.line+1<h.length?h[l.line+1]:this._content.length;return Math.max(Math.min(m+l.character,b),m)}get lineCount(){return this.getLineOffsets().length}static isIncremental(l){let h=l;return null!=h&&"string"==typeof h.text&&void 0!==h.range&&(void 0===h.rangeLength||"number"==typeof h.rangeLength)}static isFull(l){let h=l;return null!=h&&"string"==typeof h.text&&void 0===h.range&&void 0===h.rangeLength}};function dr(l,h){if(l.length<=1)return l;let m=l.length/2|0,b=l.slice(0,m),y=l.slice(m);dr(b,h),dr(y,h);let w=0,x=0,F=0;for(;w<b.length&&x<y.length;)h(b[w],y[x])<=0?l[F++]=b[w++]:l[F++]=y[x++];for(;w<b.length;)l[F++]=b[w++];for(;x<y.length;)l[F++]=y[x++];return l}function Ki(l,h,m=0){let b=h?[m]:[];for(let h=0;h<l.length;h++){let y=l.charCodeAt(h);(13===y||10===y)&&(13===y&&h+1<l.length&&10===l.charCodeAt(h+1)&&h++,b.push(m+h+1))}return b}function Gi(l){let h=l.start,m=l.end;return h.line>m.line||h.line===m.line&&h.character>m.character?{start:m,end:h}:l}function Ra(l){let h=Gi(l.range);return h!==l.range?{newText:l.newText,range:h}:l}!function(l){l.create=function e(l,h,m,b){return new Lr(l,h,m,b)},l.update=function t(l,h,m){if(l instanceof Lr)return l.update(h,m),l;throw new Error("TextDocument.update: document must be created by TextDocument.create")},l.applyEdits=function r(l,h){let m=l.getText(),b=dr(h.map(Ra),((l,h)=>{let m=l.range.start.line-h.range.start.line;return 0===m?l.range.start.character-h.range.start.character:m})),y=0,w=[];for(let h of b){let b=l.offsetAt(h.range.start);if(b<y)throw new Error("Overlapping edit");b>y&&w.push(m.substring(y,b)),h.newText.length&&w.push(h.newText),y=l.offsetAt(h.range.end)}return w.push(m.substr(y)),w.join("")}}(Ar||(Ar={})),function(l){l.LATEST={textDocument:{completion:{completionItem:{documentationFormat:[Qn.Markdown,Qn.PlainText]}},hover:{contentFormat:[Qn.Markdown,Qn.PlainText]}}}}(Or||(Or={})),function(l){l[l.Unknown=0]="Unknown",l[l.File=1]="File",l[l.Directory=2]="Directory",l[l.SymbolicLink=64]="SymbolicLink"}(Wr||(Wr={}));var jr={E:"Edge",FF:"Firefox",S:"Safari",C:"Chrome",IE:"IE",O:"Opera"};function Xi(l){switch(l){case"experimental":return"⚠️ Property is experimental. Be cautious when using it.️\n\n";case"nonstandard":return"🚨️ Property is nonstandard. Avoid using it.\n\n";case"obsolete":return"🚨️️️ Property is obsolete. Avoid using it.\n\n";default:return""}}function Se(l,h,m){var b;if(""!==(b=h?{kind:"markdown",value:Ma(l,m)}:{kind:"plaintext",value:Ia(l,m)}).value)return b}function vn(l){return(l=l.replace(/[\\`*_{}[\]()#+\-.!]/g,"\\$&")).replace(/</g,"&lt;").replace(/>/g,"&gt;")}function Ia(l,h){if(!l.description||""===l.description)return"";if("string"!=typeof l.description)return l.description.value;var m="";if(!1!==(null==h?void 0:h.documentation)){l.status&&(m+=Xi(l.status)),m+=l.description;var b=Yi(l.browsers);b&&(m+="\n("+b+")"),"syntax"in l&&(m+="\n\nSyntax: ".concat(l.syntax))}return l.references&&l.references.length>0&&!1!==(null==h?void 0:h.references)&&(m.length>0&&(m+="\n\n"),m+=l.references.map((function(l){return"".concat(l.name,": ").concat(l.url)})).join(" | ")),m}function Ma(l,h){if(!l.description||""===l.description)return"";var m="";if(!1!==(null==h?void 0:h.documentation)){l.status&&(m+=Xi(l.status)),"string"==typeof l.description?m+=vn(l.description):m+=l.description.kind===Qn.Markdown?l.description.value:vn(l.description.value);var b=Yi(l.browsers);b&&(m+="\n\n("+vn(b)+")"),"syntax"in l&&l.syntax&&(m+="\n\nSyntax: ".concat(vn(l.syntax)))}return l.references&&l.references.length>0&&!1!==(null==h?void 0:h.references)&&(m.length>0&&(m+="\n\n"),m+=l.references.map((function(l){return"[".concat(l.name,"](").concat(l.url,")")})).join(" | ")),m}function Yi(l){return void 0===l&&(l=[]),0===l.length?null:l.map((function(l){var h="",m=l.match(/([A-Z]+)(\d+)?/),b=m[1],y=m[2];return b in jr&&(h+=jr[b]),y&&(h+=" "+y),h})).join(", ")}var Vr=$(),Br=[{func:"rgb($red, $green, $blue)",desc:Vr("css.builtin.rgb","Creates a Color from red, green, and blue values.")},{func:"rgba($red, $green, $blue, $alpha)",desc:Vr("css.builtin.rgba","Creates a Color from red, green, blue, and alpha values.")},{func:"hsl($hue, $saturation, $lightness)",desc:Vr("css.builtin.hsl","Creates a Color from hue, saturation, and lightness values.")},{func:"hsla($hue, $saturation, $lightness, $alpha)",desc:Vr("css.builtin.hsla","Creates a Color from hue, saturation, lightness, and alpha values.")}],$r={aliceblue:"#f0f8ff",antiquewhite:"#faebd7",aqua:"#00ffff",aquamarine:"#7fffd4",azure:"#f0ffff",beige:"#f5f5dc",bisque:"#ffe4c4",black:"#000000",blanchedalmond:"#ffebcd",blue:"#0000ff",blueviolet:"#8a2be2",brown:"#a52a2a",burlywood:"#deb887",cadetblue:"#5f9ea0",chartreuse:"#7fff00",chocolate:"#d2691e",coral:"#ff7f50",cornflowerblue:"#6495ed",cornsilk:"#fff8dc",crimson:"#dc143c",cyan:"#00ffff",darkblue:"#00008b",darkcyan:"#008b8b",darkgoldenrod:"#b8860b",darkgray:"#a9a9a9",darkgrey:"#a9a9a9",darkgreen:"#006400",darkkhaki:"#bdb76b",darkmagenta:"#8b008b",darkolivegreen:"#556b2f",darkorange:"#ff8c00",darkorchid:"#9932cc",darkred:"#8b0000",darksalmon:"#e9967a",darkseagreen:"#8fbc8f",darkslateblue:"#483d8b",darkslategray:"#2f4f4f",darkslategrey:"#2f4f4f",darkturquoise:"#00ced1",darkviolet:"#9400d3",deeppink:"#ff1493",deepskyblue:"#00bfff",dimgray:"#696969",dimgrey:"#696969",dodgerblue:"#1e90ff",firebrick:"#b22222",floralwhite:"#fffaf0",forestgreen:"#228b22",fuchsia:"#ff00ff",gainsboro:"#dcdcdc",ghostwhite:"#f8f8ff",gold:"#ffd700",goldenrod:"#daa520",gray:"#808080",grey:"#808080",green:"#008000",greenyellow:"#adff2f",honeydew:"#f0fff0",hotpink:"#ff69b4",indianred:"#cd5c5c",indigo:"#4b0082",ivory:"#fffff0",khaki:"#f0e68c",lavender:"#e6e6fa",lavenderblush:"#fff0f5",lawngreen:"#7cfc00",lemonchiffon:"#fffacd",lightblue:"#add8e6",lightcoral:"#f08080",lightcyan:"#e0ffff",lightgoldenrodyellow:"#fafad2",lightgray:"#d3d3d3",lightgrey:"#d3d3d3",lightgreen:"#90ee90",lightpink:"#ffb6c1",lightsalmon:"#ffa07a",lightseagreen:"#20b2aa",lightskyblue:"#87cefa",lightslategray:"#778899",lightslategrey:"#778899",lightsteelblue:"#b0c4de",lightyellow:"#ffffe0",lime:"#00ff00",limegreen:"#32cd32",linen:"#faf0e6",magenta:"#ff00ff",maroon:"#800000",mediumaquamarine:"#66cdaa",mediumblue:"#0000cd",mediumorchid:"#ba55d3",mediumpurple:"#9370d8",mediumseagreen:"#3cb371",mediumslateblue:"#7b68ee",mediumspringgreen:"#00fa9a",mediumturquoise:"#48d1cc",mediumvioletred:"#c71585",midnightblue:"#191970",mintcream:"#f5fffa",mistyrose:"#ffe4e1",moccasin:"#ffe4b5",navajowhite:"#ffdead",navy:"#000080",oldlace:"#fdf5e6",olive:"#808000",olivedrab:"#6b8e23",orange:"#ffa500",orangered:"#ff4500",orchid:"#da70d6",palegoldenrod:"#eee8aa",palegreen:"#98fb98",paleturquoise:"#afeeee",palevioletred:"#d87093",papayawhip:"#ffefd5",peachpuff:"#ffdab9",peru:"#cd853f",pink:"#ffc0cb",plum:"#dda0dd",powderblue:"#b0e0e6",purple:"#800080",red:"#ff0000",rebeccapurple:"#663399",rosybrown:"#bc8f8f",royalblue:"#4169e1",saddlebrown:"#8b4513",salmon:"#fa8072",sandybrown:"#f4a460",seagreen:"#2e8b57",seashell:"#fff5ee",sienna:"#a0522d",silver:"#c0c0c0",skyblue:"#87ceeb",slateblue:"#6a5acd",slategray:"#708090",slategrey:"#708090",snow:"#fffafa",springgreen:"#00ff7f",steelblue:"#4682b4",tan:"#d2b48c",teal:"#008080",thistle:"#d8bfd8",tomato:"#ff6347",turquoise:"#40e0d0",violet:"#ee82ee",wheat:"#f5deb3",white:"#ffffff",whitesmoke:"#f5f5f5",yellow:"#ffff00",yellowgreen:"#9acd32"},Kr={currentColor:"The value of the 'color' property. The computed value of the 'currentColor' keyword is the computed value of the 'color' property. If the 'currentColor' keyword is set on the 'color' property itself, it is treated as 'color:inherit' at parse time.",transparent:"Fully transparent. This keyword can be considered a shorthand for rgba(0,0,0,0) which is its computed value."};function ut(l,h){var m=l.getText().match(/^([-+]?[0-9]*\.?[0-9]+)(%?)$/);if(m){m[2]&&(h=100);var b=parseFloat(m[1])/h;if(b>=0&&b<=1)return b}throw new Error}function K(l){return l<48?0:l<=57?l-48:(l<97&&(l+=32),l>=97&&l<=102?l-97+10:0)}function Zi(l){if("#"!==l[0])return null;switch(l.length){case 4:return{red:17*K(l.charCodeAt(1))/255,green:17*K(l.charCodeAt(2))/255,blue:17*K(l.charCodeAt(3))/255,alpha:1};case 5:return{red:17*K(l.charCodeAt(1))/255,green:17*K(l.charCodeAt(2))/255,blue:17*K(l.charCodeAt(3))/255,alpha:17*K(l.charCodeAt(4))/255};case 7:return{red:(16*K(l.charCodeAt(1))+K(l.charCodeAt(2)))/255,green:(16*K(l.charCodeAt(3))+K(l.charCodeAt(4)))/255,blue:(16*K(l.charCodeAt(5))+K(l.charCodeAt(6)))/255,alpha:1};case 9:return{red:(16*K(l.charCodeAt(1))+K(l.charCodeAt(2)))/255,green:(16*K(l.charCodeAt(3))+K(l.charCodeAt(4)))/255,blue:(16*K(l.charCodeAt(5))+K(l.charCodeAt(6)))/255,alpha:(16*K(l.charCodeAt(7))+K(l.charCodeAt(8)))/255}}return null}function ro(l){if(l.type===Ee.HexColorValue)return Zi(l.getText());if(l.type===Ee.Function){var h=l,m=h.getName(),b=h.getArguments().getChildren();if(1===b.length){var y=b[0].getChildren();if(1===y.length&&y[0].type===Ee.Expression&&3===(b=y[0].getChildren()).length){var w=b[2];if(w instanceof Mt){var x=w.getLeft(),F=w.getRight(),E=w.getOperator();x&&F&&E&&E.matches("/")&&(b=[b[0],b[1],x,F])}}}if(!m||b.length<3||b.length>4)return null;try{var z=4===b.length?ut(b[3],1):1;if("rgb"===m||"rgba"===m)return{red:ut(b[0],255),green:ut(b[1],255),blue:ut(b[2],255),alpha:z};if("hsl"===m||"hsla"===m){var D=function Ta(l){var h=l.getText(),m=h.match(/^([-+]?[0-9]*\.?[0-9]+)(deg|rad|grad|turn)?$/);if(m)switch(m[2]){case"deg":return parseFloat(h)%360;case"rad":return 180*parseFloat(h)/Math.PI%360;case"grad":return.9*parseFloat(h)%360;case"turn":return 360*parseFloat(h)%360;default:if(typeof m[2]>"u")return parseFloat(h)%360}throw new Error}(b[0]);return function _a(l,h,m,b){if(void 0===b&&(b=1),0===h)return{red:m,green:m,blue:m,alpha:b};var i=function(l,h,m){for(;m<0;)m+=6;for(;m>=6;)m-=6;return m<1?(h-l)*m+l:m<3?h:m<4?(h-l)*(4-m)+l:l},y=m<=.5?m*(h+1):m+h-m*h,w=2*m-y;return{red:i(w,y,2+(l/=60)),green:i(w,y,l),blue:i(w,y,l-2),alpha:b}}(D,ut(b[1],100),ut(b[2],100),z)}}catch{return null}}else if(l.type===Ee.Identifier){if(l.parent&&l.parent.type!==Ee.Term)return null;var R=l.parent;if(R&&R.parent&&R.parent.type===Ee.BinaryExpression){var T=R.parent;if(T.parent&&T.parent.type===Ee.ListEntry&&T.parent.key===T)return null}var M=l.getText().toLowerCase();if("none"===M)return null;var P=$r[M];if(P)return Zi(P)}return null}var qr={bottom:"Computes to ‘100%’ for the vertical position if one or two values are given, otherwise specifies the bottom edge as the origin for the next offset.",center:"Computes to ‘50%’ (‘left 50%’) for the horizontal position if the horizontal position is not otherwise specified, or ‘50%’ (‘top 50%’) for the vertical position if it is.",left:"Computes to ‘0%’ for the horizontal position if one or two values are given, otherwise specifies the left edge as the origin for the next offset.",right:"Computes to ‘100%’ for the horizontal position if one or two values are given, otherwise specifies the right edge as the origin for the next offset.",top:"Computes to ‘0%’ for the vertical position if one or two values are given, otherwise specifies the top edge as the origin for the next offset."},Gr={"no-repeat":"Placed once and not repeated in this direction.",repeat:"Repeated in this direction as often as needed to cover the background painting area.","repeat-x":"Computes to ‘repeat no-repeat’.","repeat-y":"Computes to ‘no-repeat repeat’.",round:"Repeated as often as will fit within the background positioning area. If it doesn’t fit a whole number of times, it is rescaled so that it does.",space:"Repeated as often as will fit within the background positioning area without being clipped and then the images are spaced out to fill the area."},Hr={dashed:"A series of square-ended dashes.",dotted:"A series of round dots.",double:"Two parallel solid lines with some space between them.",groove:"Looks as if it were carved in the canvas.",hidden:"Same as ‘none’, but has different behavior in the border conflict resolution rules for border-collapsed tables.",inset:"Looks as if the content on the inside of the border is sunken into the canvas.",none:"No border. Color and width are ignored.",outset:"Looks as if the content on the inside of the border is coming out of the canvas.",ridge:"Looks as if it were coming out of the canvas.",solid:"A single line segment."},Jr=["medium","thick","thin"],Xr={"border-box":"The background is painted within (clipped to) the border box.","content-box":"The background is painted within (clipped to) the content box.","padding-box":"The background is painted within (clipped to) the padding box."},Yr={"margin-box":"Uses the margin box as reference box.","fill-box":"Uses the object bounding box as reference box.","stroke-box":"Uses the stroke bounding box as reference box.","view-box":"Uses the nearest SVG viewport as reference box."},Zr={initial:"Represents the value specified as the property’s initial value.",inherit:"Represents the computed value of the property on the element’s parent.",unset:"Acts as either `inherit` or `initial`, depending on whether the property is inherited or not."},Qr={"var()":"Evaluates the value of a custom variable.","calc()":"Evaluates an mathematical expression. The following operators can be used: + - * /."},ri={"url()":"Reference an image file by URL","image()":"Provide image fallbacks and annotations.","-webkit-image-set()":"Provide multiple resolutions. Remember to use unprefixed image-set() in addition.","image-set()":"Provide multiple resolutions of an image and const the UA decide which is most appropriate in a given situation.","-moz-element()":"Use an element in the document as an image. Remember to use unprefixed element() in addition.","element()":"Use an element in the document as an image.","cross-fade()":"Indicates the two images to be combined and how far along in the transition the combination is.","-webkit-gradient()":"Deprecated. Use modern linear-gradient() or radial-gradient() instead.","-webkit-linear-gradient()":"Linear gradient. Remember to use unprefixed version in addition.","-moz-linear-gradient()":"Linear gradient. Remember to use unprefixed version in addition.","-o-linear-gradient()":"Linear gradient. Remember to use unprefixed version in addition.","linear-gradient()":"A linear gradient is created by specifying a straight gradient line, and then several colors placed along that line.","-webkit-repeating-linear-gradient()":"Repeating Linear gradient. Remember to use unprefixed version in addition.","-moz-repeating-linear-gradient()":"Repeating Linear gradient. Remember to use unprefixed version in addition.","-o-repeating-linear-gradient()":"Repeating Linear gradient. Remember to use unprefixed version in addition.","repeating-linear-gradient()":"Same as linear-gradient, except the color-stops are repeated infinitely in both directions, with their positions shifted by multiples of the difference between the last specified color-stop’s position and the first specified color-stop’s position.","-webkit-radial-gradient()":"Radial gradient. Remember to use unprefixed version in addition.","-moz-radial-gradient()":"Radial gradient. Remember to use unprefixed version in addition.","radial-gradient()":"Colors emerge from a single point and smoothly spread outward in a circular or elliptical shape.","-webkit-repeating-radial-gradient()":"Repeating radial gradient. Remember to use unprefixed version in addition.","-moz-repeating-radial-gradient()":"Repeating radial gradient. Remember to use unprefixed version in addition.","repeating-radial-gradient()":"Same as radial-gradient, except the color-stops are repeated infinitely in both directions, with their positions shifted by multiples of the difference between the last specified color-stop’s position and the first specified color-stop’s position."},ii={ease:"Equivalent to cubic-bezier(0.25, 0.1, 0.25, 1.0).","ease-in":"Equivalent to cubic-bezier(0.42, 0, 1.0, 1.0).","ease-in-out":"Equivalent to cubic-bezier(0.42, 0, 0.58, 1.0).","ease-out":"Equivalent to cubic-bezier(0, 0, 0.58, 1.0).",linear:"Equivalent to cubic-bezier(0.0, 0.0, 1.0, 1.0).","step-end":"Equivalent to steps(1, end).","step-start":"Equivalent to steps(1, start).","steps()":"The first parameter specifies the number of intervals in the function. The second parameter, which is optional, is either the value “start” or “end”.","cubic-bezier()":"Specifies a cubic-bezier curve. The four values specify points P1 and P2  of the curve as (x1, y1, x2, y2).","cubic-bezier(0.6, -0.28, 0.735, 0.045)":"Ease-in Back. Overshoots.","cubic-bezier(0.68, -0.55, 0.265, 1.55)":"Ease-in-out Back. Overshoots.","cubic-bezier(0.175, 0.885, 0.32, 1.275)":"Ease-out Back. Overshoots.","cubic-bezier(0.6, 0.04, 0.98, 0.335)":"Ease-in Circular. Based on half circle.","cubic-bezier(0.785, 0.135, 0.15, 0.86)":"Ease-in-out Circular. Based on half circle.","cubic-bezier(0.075, 0.82, 0.165, 1)":"Ease-out Circular. Based on half circle.","cubic-bezier(0.55, 0.055, 0.675, 0.19)":"Ease-in Cubic. Based on power of three.","cubic-bezier(0.645, 0.045, 0.355, 1)":"Ease-in-out Cubic. Based on power of three.","cubic-bezier(0.215, 0.610, 0.355, 1)":"Ease-out Cubic. Based on power of three.","cubic-bezier(0.95, 0.05, 0.795, 0.035)":"Ease-in Exponential. Based on two to the power ten.","cubic-bezier(1, 0, 0, 1)":"Ease-in-out Exponential. Based on two to the power ten.","cubic-bezier(0.19, 1, 0.22, 1)":"Ease-out Exponential. Based on two to the power ten.","cubic-bezier(0.47, 0, 0.745, 0.715)":"Ease-in Sine.","cubic-bezier(0.445, 0.05, 0.55, 0.95)":"Ease-in-out Sine.","cubic-bezier(0.39, 0.575, 0.565, 1)":"Ease-out Sine.","cubic-bezier(0.55, 0.085, 0.68, 0.53)":"Ease-in Quadratic. Based on power of two.","cubic-bezier(0.455, 0.03, 0.515, 0.955)":"Ease-in-out Quadratic. Based on power of two.","cubic-bezier(0.25, 0.46, 0.45, 0.94)":"Ease-out Quadratic. Based on power of two.","cubic-bezier(0.895, 0.03, 0.685, 0.22)":"Ease-in Quartic. Based on power of four.","cubic-bezier(0.77, 0, 0.175, 1)":"Ease-in-out Quartic. Based on power of four.","cubic-bezier(0.165, 0.84, 0.44, 1)":"Ease-out Quartic. Based on power of four.","cubic-bezier(0.755, 0.05, 0.855, 0.06)":"Ease-in Quintic. Based on power of five.","cubic-bezier(0.86, 0, 0.07, 1)":"Ease-in-out Quintic. Based on power of five.","cubic-bezier(0.23, 1, 0.320, 1)":"Ease-out Quintic. Based on power of five."},oi={"circle()":"Defines a circle.","ellipse()":"Defines an ellipse.","inset()":"Defines an inset rectangle.","polygon()":"Defines a polygon."},si={length:["em","rem","ex","px","cm","mm","in","pt","pc","ch","vw","vh","vmin","vmax"],angle:["deg","rad","grad","turn"],time:["ms","s"],frequency:["Hz","kHz"],resolution:["dpi","dpcm","dppx"],percentage:["%","fr"]},ai=["a","abbr","address","area","article","aside","audio","b","base","bdi","bdo","blockquote","body","br","button","canvas","caption","cite","code","col","colgroup","data","datalist","dd","del","details","dfn","dialog","div","dl","dt","em","embed","fieldset","figcaption","figure","footer","form","h1","h2","h3","h4","h5","h6","head","header","hgroup","hr","html","i","iframe","img","input","ins","kbd","keygen","label","legend","li","link","main","map","mark","menu","menuitem","meta","meter","nav","noscript","object","ol","optgroup","option","output","p","param","picture","pre","progress","q","rb","rp","rt","rtc","ruby","s","samp","script","section","select","small","source","span","strong","style","sub","summary","sup","table","tbody","td","template","textarea","tfoot","th","thead","time","title","tr","track","u","ul","const","video","wbr"],li=["circle","clipPath","cursor","defs","desc","ellipse","feBlend","feColorMatrix","feComponentTransfer","feComposite","feConvolveMatrix","feDiffuseLighting","feDisplacementMap","feDistantLight","feDropShadow","feFlood","feFuncA","feFuncB","feFuncG","feFuncR","feGaussianBlur","feImage","feMerge","feMergeNode","feMorphology","feOffset","fePointLight","feSpecularLighting","feSpotLight","feTile","feTurbulence","filter","foreignObject","g","hatch","hatchpath","image","line","linearGradient","marker","mask","mesh","meshpatch","meshrow","metadata","mpath","path","pattern","polygon","polyline","radialGradient","rect","set","solidcolor","stop","svg","switch","symbol","text","textPath","tspan","use","view"],ci=["@bottom-center","@bottom-left","@bottom-left-corner","@bottom-right","@bottom-right-corner","@left-bottom","@left-middle","@left-top","@right-bottom","@right-middle","@right-top","@top-center","@top-left","@top-left-corner","@top-right","@top-right-corner"];function Wt(l){return Object.keys(l).map((function(h){return l[h]}))}function de(l){return typeof l<"u"}var lo=function(l,h,m){if(m||2===arguments.length)for(var b,y=0,w=h.length;y<w;y++)(b||!(y in h))&&(b||(b=Array.prototype.slice.call(h,0,y)),b[y]=h[y]);return l.concat(b||Array.prototype.slice.call(h))},di=function(){function n(l){void 0===l&&(l=new Fe),this.keyframeRegex=/^@(\-(webkit|ms|moz|o)\-)?keyframes$/i,this.scanner=l,this.token={type:h.EOF,offset:-1,len:0,text:""},this.prevToken=void 0}return n.prototype.peekIdent=function(l){return h.Ident===this.token.type&&l.length===this.token.text.length&&l===this.token.text.toLowerCase()},n.prototype.peekKeyword=function(l){return h.AtKeyword===this.token.type&&l.length===this.token.text.length&&l===this.token.text.toLowerCase()},n.prototype.peekDelim=function(l){return h.Delim===this.token.type&&l===this.token.text},n.prototype.peek=function(l){return l===this.token.type},n.prototype.peekOne=function(){for(var l=[],h=0;h<arguments.length;h++)l[h]=arguments[h];return-1!==l.indexOf(this.token.type)},n.prototype.peekRegExp=function(l,h){return l===this.token.type&&h.test(this.token.text)},n.prototype.hasWhitespace=function(){return!!this.prevToken&&this.prevToken.offset+this.prevToken.len!==this.token.offset},n.prototype.consumeToken=function(){this.prevToken=this.token,this.token=this.scanner.scan()},n.prototype.mark=function(){return{prev:this.prevToken,curr:this.token,pos:this.scanner.pos()}},n.prototype.restoreAtMark=function(l){this.prevToken=l.prev,this.token=l.curr,this.scanner.goBackTo(l.pos)},n.prototype.try=function(l){var h=this.mark();return l()||(this.restoreAtMark(h),null)},n.prototype.acceptOneKeyword=function(l){if(h.AtKeyword===this.token.type)for(var m=0,b=l;m<b.length;m++){var y=b[m];if(y.length===this.token.text.length&&y===this.token.text.toLowerCase())return this.consumeToken(),!0}return!1},n.prototype.accept=function(l){return l===this.token.type&&(this.consumeToken(),!0)},n.prototype.acceptIdent=function(l){return!!this.peekIdent(l)&&(this.consumeToken(),!0)},n.prototype.acceptKeyword=function(l){return!!this.peekKeyword(l)&&(this.consumeToken(),!0)},n.prototype.acceptDelim=function(l){return!!this.peekDelim(l)&&(this.consumeToken(),!0)},n.prototype.acceptRegexp=function(l){return!!l.test(this.token.text)&&(this.consumeToken(),!0)},n.prototype._parseRegexp=function(l){var h=this.createNode(Ee.Identifier);do{}while(this.acceptRegexp(l));return this.finish(h)},n.prototype.acceptUnquotedString=function(){var l=this.scanner.pos();this.scanner.goBackTo(this.token.offset);var h=this.scanner.scanUnquotedString();return h?(this.token=h,this.consumeToken(),!0):(this.scanner.goBackTo(l),!1)},n.prototype.resync=function(l,m){for(;;){if(l&&-1!==l.indexOf(this.token.type))return this.consumeToken(),!0;if(m&&-1!==m.indexOf(this.token.type))return!0;if(this.token.type===h.EOF)return!1;this.token=this.scanner.scan()}},n.prototype.createNode=function(l){return new Te(this.token.offset,this.token.len,l)},n.prototype.create=function(l){return new l(this.token.offset,this.token.len)},n.prototype.finish=function(l,h,m,b){if(!(l instanceof Ie)&&(h&&this.markError(l,h,m,b),this.prevToken)){var y=this.prevToken.offset+this.prevToken.len;l.length=y>l.offset?y-l.offset:0}return l},n.prototype.markError=function(l,h,m,b){this.token!==this.lastErrorToken&&(l.addIssue(new hn(l,h,Re.Error,void 0,this.token.offset,this.token.len)),this.lastErrorToken=this.token),(m||b)&&this.resync(m,b)},n.prototype.parseStylesheet=function(l){var h=l.version,m=l.getText();return this.internalParse(m,this._parseStylesheet,(function(b,y){if(l.version!==h)throw new Error("Underlying model has changed, AST is no longer valid");return m.substr(b,y)}))},n.prototype.internalParse=function(l,h,m){this.scanner.setSource(l),this.token=this.scanner.scan();var b=h.bind(this)();return b&&(b.textProvider=m||function(h,m){return l.substr(h,m)}),b},n.prototype._parseStylesheet=function(){for(var l=this.create(Pe);l.addChild(this._parseStylesheetStart()););var m=!1;do{var b=!1;do{b=!1;var y=this._parseStylesheetStatement();for(y&&(l.addChild(y),b=!0,m=!1,!this.peek(h.EOF)&&this._needsSemicolonAfter(y)&&!this.accept(h.SemiColon)&&this.markError(l,Hn.SemiColonExpected));this.accept(h.SemiColon)||this.accept(h.CDO)||this.accept(h.CDC);)b=!0,m=!1}while(b);if(this.peek(h.EOF))break;m||(this.peek(h.AtKeyword)?this.markError(l,Hn.UnknownAtRule):this.markError(l,Hn.RuleOrSelectorExpected),m=!0),this.consumeToken()}while(!this.peek(h.EOF));return this.finish(l)},n.prototype._parseStylesheetStart=function(){return this._parseCharset()},n.prototype._parseStylesheetStatement=function(l){return void 0===l&&(l=!1),this.peek(h.AtKeyword)?this._parseStylesheetAtStatement(l):this._parseRuleset(l)},n.prototype._parseStylesheetAtStatement=function(l){return void 0===l&&(l=!1),this._parseImport()||this._parseMedia(l)||this._parsePage()||this._parseFontFace()||this._parseKeyframe()||this._parseSupports(l)||this._parseViewPort()||this._parseNamespace()||this._parseDocument()||this._parseUnknownAtRule()},n.prototype._tryParseRuleset=function(l){var m=this.mark();if(this._parseSelector(l)){for(;this.accept(h.Comma)&&this._parseSelector(l););if(this.accept(h.CurlyL))return this.restoreAtMark(m),this._parseRuleset(l)}return this.restoreAtMark(m),null},n.prototype._parseRuleset=function(l){void 0===l&&(l=!1);var m=this.create(Oe),b=m.getSelectors();if(!b.addChild(this._parseSelector(l)))return null;for(;this.accept(h.Comma);)if(!b.addChild(this._parseSelector(l)))return this.finish(m,Hn.SelectorExpected);return this._parseBody(m,this._parseRuleSetDeclaration.bind(this))},n.prototype._parseRuleSetDeclarationAtStatement=function(){return this._parseUnknownAtRule()},n.prototype._parseRuleSetDeclaration=function(){return this.peek(h.AtKeyword)?this._parseRuleSetDeclarationAtStatement():this._parseDeclaration()},n.prototype._needsSemicolonAfter=function(l){switch(l.type){case Ee.Keyframe:case Ee.ViewPort:case Ee.Media:case Ee.Ruleset:case Ee.Namespace:case Ee.If:case Ee.For:case Ee.Each:case Ee.While:case Ee.MixinDeclaration:case Ee.FunctionDeclaration:case Ee.MixinContentDeclaration:return!1;case Ee.ExtendsReference:case Ee.MixinContentReference:case Ee.ReturnStatement:case Ee.MediaQuery:case Ee.Debug:case Ee.Import:case Ee.AtApplyRule:case Ee.CustomPropertyDeclaration:return!0;case Ee.VariableDeclaration:return l.needsSemicolon;case Ee.MixinReference:return!l.getContent();case Ee.Declaration:return!l.getNestedProperties()}return!1},n.prototype._parseDeclarations=function(l){var m=this.create(_e);if(!this.accept(h.CurlyL))return null;for(var b=l();m.addChild(b)&&!this.peek(h.CurlyR);){if(this._needsSemicolonAfter(b)&&!this.accept(h.SemiColon))return this.finish(m,Hn.SemiColonExpected,[h.SemiColon,h.CurlyR]);for(b&&this.prevToken&&this.prevToken.type===h.SemiColon&&(b.semicolonPosition=this.prevToken.offset);this.accept(h.SemiColon););b=l()}return this.accept(h.CurlyR)?this.finish(m):this.finish(m,Hn.RightCurlyExpected,[h.CurlyR,h.SemiColon])},n.prototype._parseBody=function(l,m){return l.setDeclarations(this._parseDeclarations(m))?this.finish(l):this.finish(l,Hn.LeftCurlyExpected,[h.CurlyR,h.SemiColon])},n.prototype._parseSelector=function(l){var h=this.create(We),m=!1;for(l&&(m=h.addChild(this._parseCombinator()));h.addChild(this._parseSimpleSelector());)m=!0,h.addChild(this._parseCombinator());return m?this.finish(h):null},n.prototype._parseDeclaration=function(l){var m=this._tryParseCustomPropertyDeclaration(l);if(m)return m;var b=this.create(Be);return b.setProperty(this._parseProperty())?this.accept(h.Colon)?(this.prevToken&&(b.colonPosition=this.prevToken.offset),b.setValue(this._parseExpr())?(b.addChild(this._parsePrio()),this.peek(h.SemiColon)&&(b.semicolonPosition=this.token.offset),this.finish(b)):this.finish(b,Hn.PropertyValueExpected)):this.finish(b,Hn.ColonExpected,[h.Colon],l||[h.SemiColon]):null},n.prototype._tryParseCustomPropertyDeclaration=function(l){if(!this.peekRegExp(h.Ident,/^--/))return null;var m=this.create($e);if(!m.setProperty(this._parseProperty()))return null;if(!this.accept(h.Colon))return this.finish(m,Hn.ColonExpected,[h.Colon]);this.prevToken&&(m.colonPosition=this.prevToken.offset);var b=this.mark();if(this.peek(h.CurlyL)){var y=this.create(je),w=this._parseDeclarations(this._parseRuleSetDeclaration.bind(this));if(y.setDeclarations(w)&&!w.isErroneous(!0)&&(y.addChild(this._parsePrio()),this.peek(h.SemiColon)))return this.finish(y),m.setPropertySet(y),m.semicolonPosition=this.token.offset,this.finish(m);this.restoreAtMark(b)}var x=this._parseExpr();return x&&!x.isErroneous(!0)&&(this._parsePrio(),this.peekOne.apply(this,lo(lo([],l||[],!1),[h.SemiColon,h.EOF],!1)))?(m.setValue(x),this.peek(h.SemiColon)&&(m.semicolonPosition=this.token.offset),this.finish(m)):(this.restoreAtMark(b),m.addChild(this._parseCustomPropertyValue(l)),m.addChild(this._parsePrio()),de(m.colonPosition)&&this.token.offset===m.colonPosition+1?this.finish(m,Hn.PropertyValueExpected):this.finish(m))},n.prototype._parseCustomPropertyValue=function(l){var m=this;void 0===l&&(l=[h.CurlyR]);var b=this.create(Te),i=function(){return 0===y&&0===w&&0===x},o=function(){return-1!==l.indexOf(m.token.type)},y=0,w=0,x=0;e:for(;;){switch(this.token.type){case h.SemiColon:case h.Exclamation:if(i())break e;break;case h.CurlyL:y++;break;case h.CurlyR:if(--y<0){if(o()&&0===w&&0===x)break e;return this.finish(b,Hn.LeftCurlyExpected)}break;case h.ParenthesisL:w++;break;case h.ParenthesisR:if(--w<0){if(o()&&0===x&&0===y)break e;return this.finish(b,Hn.LeftParenthesisExpected)}break;case h.BracketL:x++;break;case h.BracketR:if(--x<0)return this.finish(b,Hn.LeftSquareBracketExpected);break;case h.BadString:break e;case h.EOF:var F=Hn.RightCurlyExpected;return x>0?F=Hn.RightSquareBracketExpected:w>0&&(F=Hn.RightParenthesisExpected),this.finish(b,F)}this.consumeToken()}return this.finish(b)},n.prototype._tryToParseDeclaration=function(l){var m=this.mark();return this._parseProperty()&&this.accept(h.Colon)?(this.restoreAtMark(m),this._parseDeclaration(l)):(this.restoreAtMark(m),null)},n.prototype._parseProperty=function(){var l=this.create(Ke),h=this.mark();return(this.acceptDelim("*")||this.acceptDelim("_"))&&this.hasWhitespace()?(this.restoreAtMark(h),null):l.setIdentifier(this._parsePropertyIdentifier())?this.finish(l):null},n.prototype._parsePropertyIdentifier=function(){return this._parseIdent()},n.prototype._parseCharset=function(){if(!this.peek(h.Charset))return null;var l=this.create(Te);return this.consumeToken(),this.accept(h.String)?this.accept(h.SemiColon)?this.finish(l):this.finish(l,Hn.SemiColonExpected):this.finish(l,Hn.IdentifierExpected)},n.prototype._parseImport=function(){if(!this.peekKeyword("@import"))return null;var l=this.create(ht);return this.consumeToken(),l.addChild(this._parseURILiteral())||l.addChild(this._parseStringLiteral())?(!this.peek(h.SemiColon)&&!this.peek(h.EOF)&&l.setMedialist(this._parseMediaQueryList()),this.finish(l)):this.finish(l,Hn.URIOrStringExpected)},n.prototype._parseNamespace=function(){if(!this.peekKeyword("@namespace"))return null;var l=this.create(yt);return this.consumeToken(),l.addChild(this._parseURILiteral())||(l.addChild(this._parseIdent()),l.addChild(this._parseURILiteral())||l.addChild(this._parseStringLiteral()))?this.accept(h.SemiColon)?this.finish(l):this.finish(l,Hn.SemiColonExpected):this.finish(l,Hn.URIExpected,[h.SemiColon])},n.prototype._parseFontFace=function(){if(!this.peekKeyword("@font-face"))return null;var l=this.create(lt);return this.consumeToken(),this._parseBody(l,this._parseRuleSetDeclaration.bind(this))},n.prototype._parseViewPort=function(){if(!this.peekKeyword("@-ms-viewport")&&!this.peekKeyword("@-o-viewport")&&!this.peekKeyword("@viewport"))return null;var l=this.create(at);return this.consumeToken(),this._parseBody(l,this._parseRuleSetDeclaration.bind(this))},n.prototype._parseKeyframe=function(){if(!this.peekRegExp(h.AtKeyword,this.keyframeRegex))return null;var l=this.create(dt),m=this.create(Te);return this.consumeToken(),l.setKeyword(this.finish(m)),m.matches("@-ms-keyframes")&&this.markError(m,Hn.UnknownKeyword),l.setIdentifier(this._parseKeyframeIdent())?this._parseBody(l,this._parseKeyframeSelector.bind(this)):this.finish(l,Hn.IdentifierExpected,[h.CurlyR])},n.prototype._parseKeyframeIdent=function(){return this._parseIdent([ze.Keyframe])},n.prototype._parseKeyframeSelector=function(){var l=this.create(pt);if(!l.addChild(this._parseIdent())&&!this.accept(h.Percentage))return null;for(;this.accept(h.Comma);)if(!l.addChild(this._parseIdent())&&!this.accept(h.Percentage))return this.finish(l,Hn.PercentageExpected);return this._parseBody(l,this._parseRuleSetDeclaration.bind(this))},n.prototype._tryParseKeyframeSelector=function(){var l=this.create(pt),m=this.mark();if(!l.addChild(this._parseIdent())&&!this.accept(h.Percentage))return null;for(;this.accept(h.Comma);)if(!l.addChild(this._parseIdent())&&!this.accept(h.Percentage))return this.restoreAtMark(m),null;return this.peek(h.CurlyL)?this._parseBody(l,this._parseRuleSetDeclaration.bind(this)):(this.restoreAtMark(m),null)},n.prototype._parseSupports=function(l){if(void 0===l&&(l=!1),!this.peekKeyword("@supports"))return null;var h=this.create(St);return this.consumeToken(),h.addChild(this._parseSupportsCondition()),this._parseBody(h,this._parseSupportsDeclaration.bind(this,l))},n.prototype._parseSupportsDeclaration=function(l){return void 0===l&&(l=!1),l?this._tryParseRuleset(!0)||this._tryToParseDeclaration()||this._parseStylesheetStatement(!0):this._parseStylesheetStatement(!1)},n.prototype._parseSupportsCondition=function(){var l=this.create(Dt);if(this.acceptIdent("not"))l.addChild(this._parseSupportsConditionInParens());else if(l.addChild(this._parseSupportsConditionInParens()),this.peekRegExp(h.Ident,/^(and|or)$/i))for(var m=this.token.text.toLowerCase();this.acceptIdent(m);)l.addChild(this._parseSupportsConditionInParens());return this.finish(l)},n.prototype._parseSupportsConditionInParens=function(){var l=this.create(Dt);if(this.accept(h.ParenthesisL))return this.prevToken&&(l.lParent=this.prevToken.offset),l.addChild(this._tryToParseDeclaration([h.ParenthesisR]))||this._parseSupportsCondition()?this.accept(h.ParenthesisR)?(this.prevToken&&(l.rParent=this.prevToken.offset),this.finish(l)):this.finish(l,Hn.RightParenthesisExpected,[h.ParenthesisR],[]):this.finish(l,Hn.ConditionExpected);if(this.peek(h.Ident)){var m=this.mark();if(this.consumeToken(),!this.hasWhitespace()&&this.accept(h.ParenthesisL)){for(var b=1;this.token.type!==h.EOF&&0!==b;)this.token.type===h.ParenthesisL?b++:this.token.type===h.ParenthesisR&&b--,this.consumeToken();return this.finish(l)}this.restoreAtMark(m)}return this.finish(l,Hn.LeftParenthesisExpected,[],[h.ParenthesisL])},n.prototype._parseMediaDeclaration=function(l){return void 0===l&&(l=!1),l?this._tryParseRuleset(!0)||this._tryToParseDeclaration()||this._parseStylesheetStatement(!0):this._parseStylesheetStatement(!1)},n.prototype._parseMedia=function(l){if(void 0===l&&(l=!1),!this.peekKeyword("@media"))return null;var h=this.create(xt);return this.consumeToken(),h.addChild(this._parseMediaQueryList())?this._parseBody(h,this._parseMediaDeclaration.bind(this,l)):this.finish(h,Hn.MediaQueryExpected)},n.prototype._parseMediaQueryList=function(){var l=this.create(Ct);if(!l.addChild(this._parseMediaQuery()))return this.finish(l,Hn.MediaQueryExpected);for(;this.accept(h.Comma);)if(!l.addChild(this._parseMediaQuery()))return this.finish(l,Hn.MediaQueryExpected);return this.finish(l)},n.prototype._parseMediaQuery=function(){var l=this.create(Ft),m=this.mark();if(this.acceptIdent("not"),this.peek(h.ParenthesisL))this.restoreAtMark(m),l.addChild(this._parseMediaCondition());else{if(this.acceptIdent("only"),!l.addChild(this._parseIdent()))return null;this.acceptIdent("and")&&l.addChild(this._parseMediaCondition())}return this.finish(l)},n.prototype._parseRatio=function(){var l=this.mark(),h=this.create(At);return this._parseNumeric()?this.acceptDelim("/")?this._parseNumeric()?this.finish(h):this.finish(h,Hn.NumberExpected):(this.restoreAtMark(l),null):null},n.prototype._parseMediaCondition=function(){var l=this.create(Et);this.acceptIdent("not");for(var m=!0;m;){if(!this.accept(h.ParenthesisL))return this.finish(l,Hn.LeftParenthesisExpected,[],[h.CurlyL]);if(this.peek(h.ParenthesisL)||this.peekIdent("not")?l.addChild(this._parseMediaCondition()):l.addChild(this._parseMediaFeature()),!this.accept(h.ParenthesisR))return this.finish(l,Hn.RightParenthesisExpected,[],[h.CurlyL]);m=this.acceptIdent("and")||this.acceptIdent("or")}return this.finish(l)},n.prototype._parseMediaFeature=function(){var l=this,m=[h.ParenthesisR],b=this.create(zt),i=function(){return l.acceptDelim("<")||l.acceptDelim(">")?(l.hasWhitespace()||l.acceptDelim("="),!0):!!l.acceptDelim("=")};if(b.addChild(this._parseMediaFeatureName())){if(this.accept(h.Colon)){if(!b.addChild(this._parseMediaFeatureValue()))return this.finish(b,Hn.TermExpected,[],m)}else if(i()){if(!b.addChild(this._parseMediaFeatureValue()))return this.finish(b,Hn.TermExpected,[],m);if(i()&&!b.addChild(this._parseMediaFeatureValue()))return this.finish(b,Hn.TermExpected,[],m)}}else{if(!b.addChild(this._parseMediaFeatureValue()))return this.finish(b,Hn.IdentifierExpected,[],m);if(!i())return this.finish(b,Hn.OperatorExpected,[],m);if(!b.addChild(this._parseMediaFeatureName()))return this.finish(b,Hn.IdentifierExpected,[],m);if(i()&&!b.addChild(this._parseMediaFeatureValue()))return this.finish(b,Hn.TermExpected,[],m)}return this.finish(b)},n.prototype._parseMediaFeatureName=function(){return this._parseIdent()},n.prototype._parseMediaFeatureValue=function(){return this._parseRatio()||this._parseTermExpression()},n.prototype._parseMedium=function(){var l=this.create(Te);return l.addChild(this._parseIdent())?this.finish(l):null},n.prototype._parsePageDeclaration=function(){return this._parsePageMarginBox()||this._parseRuleSetDeclaration()},n.prototype._parsePage=function(){if(!this.peekKeyword("@page"))return null;var l=this.create(Rt);if(this.consumeToken(),l.addChild(this._parsePageSelector()))for(;this.accept(h.Comma);)if(!l.addChild(this._parsePageSelector()))return this.finish(l,Hn.IdentifierExpected);return this._parseBody(l,this._parsePageDeclaration.bind(this))},n.prototype._parsePageMarginBox=function(){if(!this.peek(h.AtKeyword))return null;var l=this.create(Tt);return this.acceptOneKeyword(ci)||this.markError(l,Hn.UnknownAtRule,[],[h.CurlyL]),this._parseBody(l,this._parseRuleSetDeclaration.bind(this))},n.prototype._parsePageSelector=function(){if(!this.peek(h.Ident)&&!this.peek(h.Colon))return null;var l=this.create(Te);return l.addChild(this._parseIdent()),this.accept(h.Colon)&&!l.addChild(this._parseIdent())?this.finish(l,Hn.IdentifierExpected):this.finish(l)},n.prototype._parseDocument=function(){if(!this.peekKeyword("@-moz-document"))return null;var l=this.create(kt);return this.consumeToken(),this.resync([],[h.CurlyL]),this._parseBody(l,this._parseStylesheetStatement.bind(this))},n.prototype._parseUnknownAtRule=function(){if(!this.peek(h.AtKeyword))return null;var l=this.create(an);l.addChild(this._parseUnknownAtRuleName());var m=0,b=0,y=0,w=0;e:for(;;){switch(this.token.type){case h.SemiColon:if(0===b&&0===y&&0===w)break e;break;case h.EOF:return b>0?this.finish(l,Hn.RightCurlyExpected):w>0?this.finish(l,Hn.RightSquareBracketExpected):y>0?this.finish(l,Hn.RightParenthesisExpected):this.finish(l);case h.CurlyL:m++,b++;break;case h.CurlyR:if(b--,m>0&&0===b){if(this.consumeToken(),w>0)return this.finish(l,Hn.RightSquareBracketExpected);if(y>0)return this.finish(l,Hn.RightParenthesisExpected);break e}if(b<0){if(0===y&&0===w)break e;return this.finish(l,Hn.LeftCurlyExpected)}break;case h.ParenthesisL:y++;break;case h.ParenthesisR:if(--y<0)return this.finish(l,Hn.LeftParenthesisExpected);break;case h.BracketL:w++;break;case h.BracketR:if(--w<0)return this.finish(l,Hn.LeftSquareBracketExpected)}this.consumeToken()}return l},n.prototype._parseUnknownAtRuleName=function(){var l=this.create(Te);return this.accept(h.AtKeyword)?this.finish(l):l},n.prototype._parseOperator=function(){if(this.peekDelim("/")||this.peekDelim("*")||this.peekDelim("+")||this.peekDelim("-")||this.peek(h.Dashmatch)||this.peek(h.Includes)||this.peek(h.SubstringOperator)||this.peek(h.PrefixOperator)||this.peek(h.SuffixOperator)||this.peekDelim("=")){var l=this.createNode(Ee.Operator);return this.consumeToken(),this.finish(l)}return null},n.prototype._parseUnaryOperator=function(){if(!this.peekDelim("+")&&!this.peekDelim("-"))return null;var l=this.create(Te);return this.consumeToken(),this.finish(l)},n.prototype._parseCombinator=function(){if(this.peekDelim(">")){var l=this.create(Te);this.consumeToken();var h=this.mark();if(!this.hasWhitespace()&&this.acceptDelim(">")){if(!this.hasWhitespace()&&this.acceptDelim(">"))return l.type=Ee.SelectorCombinatorShadowPiercingDescendant,this.finish(l);this.restoreAtMark(h)}return l.type=Ee.SelectorCombinatorParent,this.finish(l)}if(this.peekDelim("+")){l=this.create(Te);return this.consumeToken(),l.type=Ee.SelectorCombinatorSibling,this.finish(l)}if(this.peekDelim("~")){l=this.create(Te);return this.consumeToken(),l.type=Ee.SelectorCombinatorAllSiblings,this.finish(l)}if(this.peekDelim("/")){l=this.create(Te);this.consumeToken();h=this.mark();if(!this.hasWhitespace()&&this.acceptIdent("deep")&&!this.hasWhitespace()&&this.acceptDelim("/"))return l.type=Ee.SelectorCombinatorShadowPiercingDescendant,this.finish(l);this.restoreAtMark(h)}return null},n.prototype._parseSimpleSelector=function(){var l=this.create(Le),h=0;for(l.addChild(this._parseElementName())&&h++;(0===h||!this.hasWhitespace())&&l.addChild(this._parseSimpleSelectorBody());)h++;return h>0?this.finish(l):null},n.prototype._parseSimpleSelectorBody=function(){return this._parsePseudo()||this._parseHash()||this._parseClass()||this._parseAttrib()},n.prototype._parseSelectorIdent=function(){return this._parseIdent()},n.prototype._parseHash=function(){if(!this.peek(h.Hash)&&!this.peekDelim("#"))return null;var l=this.createNode(Ee.IdentifierSelector);if(this.acceptDelim("#")){if(this.hasWhitespace()||!l.addChild(this._parseSelectorIdent()))return this.finish(l,Hn.IdentifierExpected)}else this.consumeToken();return this.finish(l)},n.prototype._parseClass=function(){if(!this.peekDelim("."))return null;var l=this.createNode(Ee.ClassSelector);return this.consumeToken(),this.hasWhitespace()||!l.addChild(this._parseSelectorIdent())?this.finish(l,Hn.IdentifierExpected):this.finish(l)},n.prototype._parseElementName=function(){var l=this.mark(),h=this.createNode(Ee.ElementNameSelector);return h.addChild(this._parseNamespacePrefix()),h.addChild(this._parseSelectorIdent())||this.acceptDelim("*")?this.finish(h):(this.restoreAtMark(l),null)},n.prototype._parseNamespacePrefix=function(){var l=this.mark(),h=this.createNode(Ee.NamespacePrefix);return!h.addChild(this._parseIdent())&&this.acceptDelim("*"),this.acceptDelim("|")?this.finish(h):(this.restoreAtMark(l),null)},n.prototype._parseAttrib=function(){if(!this.peek(h.BracketL))return null;var l=this.create(_t);return this.consumeToken(),l.setNamespacePrefix(this._parseNamespacePrefix()),l.setIdentifier(this._parseIdent())?(l.setOperator(this._parseOperator())&&(l.setValue(this._parseBinaryExpr()),this.acceptIdent("i"),this.acceptIdent("s")),this.accept(h.BracketR)?this.finish(l):this.finish(l,Hn.RightSquareBracketExpected)):this.finish(l,Hn.IdentifierExpected)},n.prototype._parsePseudo=function(){var l=this,m=this._tryParsePseudoIdentifier();if(m){if(!this.hasWhitespace()&&this.accept(h.ParenthesisL)){if(m.addChild(this.try((function(){var m=l.create(Te);if(!m.addChild(l._parseSelector(!1)))return null;for(;l.accept(h.Comma)&&m.addChild(l._parseSelector(!1)););return l.peek(h.ParenthesisR)?l.finish(m):null}))||this._parseBinaryExpr()),!this.accept(h.ParenthesisR))return this.finish(m,Hn.RightParenthesisExpected)}return this.finish(m)}return null},n.prototype._tryParsePseudoIdentifier=function(){if(!this.peek(h.Colon))return null;var l=this.mark(),m=this.createNode(Ee.PseudoSelector);return this.consumeToken(),this.hasWhitespace()?(this.restoreAtMark(l),null):(this.accept(h.Colon),this.hasWhitespace()||!m.addChild(this._parseIdent())?this.finish(m,Hn.IdentifierExpected):this.finish(m))},n.prototype._tryParsePrio=function(){var l=this.mark();return this._parsePrio()||(this.restoreAtMark(l),null)},n.prototype._parsePrio=function(){if(!this.peek(h.Exclamation))return null;var l=this.createNode(Ee.Prio);return this.accept(h.Exclamation)&&this.acceptIdent("important")?this.finish(l):null},n.prototype._parseExpr=function(l){void 0===l&&(l=!1);var m=this.create(It);if(!m.addChild(this._parseBinaryExpr()))return null;for(;;){if(this.peek(h.Comma)){if(l)return this.finish(m);this.consumeToken()}if(!m.addChild(this._parseBinaryExpr()))break}return this.finish(m)},n.prototype._parseNamedLine=function(){if(!this.peek(h.BracketL))return null;var l=this.createNode(Ee.GridLine);for(this.consumeToken();l.addChild(this._parseIdent()););return this.accept(h.BracketR)?this.finish(l):this.finish(l,Hn.RightSquareBracketExpected)},n.prototype._parseBinaryExpr=function(l,h){var m=this.create(Mt);if(!m.setLeft(l||this._parseTerm()))return null;if(!m.setOperator(h||this._parseOperator()))return this.finish(m);if(!m.setRight(this._parseTerm()))return this.finish(m,Hn.TermExpected);m=this.finish(m);var b=this._parseOperator();return b&&(m=this._parseBinaryExpr(m,b)),this.finish(m)},n.prototype._parseTerm=function(){var l=this.create(Pt);return l.setOperator(this._parseUnaryOperator()),l.setExpression(this._parseTermExpression())?this.finish(l):null},n.prototype._parseTermExpression=function(){return this._parseURILiteral()||this._parseFunction()||this._parseIdent()||this._parseStringLiteral()||this._parseNumeric()||this._parseHexColor()||this._parseOperation()||this._parseNamedLine()},n.prototype._parseOperation=function(){if(!this.peek(h.ParenthesisL))return null;var l=this.create(Te);return this.consumeToken(),l.addChild(this._parseExpr()),this.accept(h.ParenthesisR)?this.finish(l):this.finish(l,Hn.RightParenthesisExpected)},n.prototype._parseNumeric=function(){if(this.peek(h.Num)||this.peek(h.Percentage)||this.peek(h.Resolution)||this.peek(h.Length)||this.peek(h.EMS)||this.peek(h.EXS)||this.peek(h.Angle)||this.peek(h.Time)||this.peek(h.Dimension)||this.peek(h.Freq)){var l=this.create(Kt);return this.consumeToken(),this.finish(l)}return null},n.prototype._parseStringLiteral=function(){if(!this.peek(h.String)&&!this.peek(h.BadString))return null;var l=this.createNode(Ee.StringLiteral);return this.consumeToken(),this.finish(l)},n.prototype._parseURILiteral=function(){if(!this.peekRegExp(h.Ident,/^url(-prefix)?$/i))return null;var l=this.mark(),m=this.createNode(Ee.URILiteral);return this.accept(h.Ident),this.hasWhitespace()||!this.peek(h.ParenthesisL)?(this.restoreAtMark(l),null):(this.scanner.inURL=!0,this.consumeToken(),m.addChild(this._parseURLArgument()),this.scanner.inURL=!1,this.accept(h.ParenthesisR)?this.finish(m):this.finish(m,Hn.RightParenthesisExpected))},n.prototype._parseURLArgument=function(){var l=this.create(Te);return this.accept(h.String)||this.accept(h.BadString)||this.acceptUnquotedString()?this.finish(l):null},n.prototype._parseIdent=function(l){if(!this.peek(h.Ident))return null;var m=this.create(Me);return l&&(m.referenceTypes=l),m.isCustomProperty=this.peekRegExp(h.Ident,/^--/),this.consumeToken(),this.finish(m)},n.prototype._parseFunction=function(){var l=this.mark(),m=this.create(Ge);if(!m.setIdentifier(this._parseFunctionIdentifier()))return null;if(this.hasWhitespace()||!this.accept(h.ParenthesisL))return this.restoreAtMark(l),null;if(m.getArguments().addChild(this._parseFunctionArgument()))for(;this.accept(h.Comma)&&!this.peek(h.ParenthesisR);)m.getArguments().addChild(this._parseFunctionArgument())||this.markError(m,Hn.ExpressionExpected);return this.accept(h.ParenthesisR)?this.finish(m):this.finish(m,Hn.RightParenthesisExpected)},n.prototype._parseFunctionIdentifier=function(){if(!this.peek(h.Ident))return null;var l=this.create(Me);if(l.referenceTypes=[ze.Function],this.acceptIdent("progid")){if(this.accept(h.Colon))for(;this.accept(h.Ident)&&this.acceptDelim("."););return this.finish(l)}return this.consumeToken(),this.finish(l)},n.prototype._parseFunctionArgument=function(){var l=this.create(Je);return l.setValue(this._parseExpr(!0))?this.finish(l):null},n.prototype._parseHexColor=function(){if(this.peekRegExp(h.Hash,/^#([A-Fa-f0-9]{3}|[A-Fa-f0-9]{4}|[A-Fa-f0-9]{6}|[A-Fa-f0-9]{8})$/g)){var l=this.create(Nt);return this.consumeToken(),this.finish(l)}return null},n}();function Sr(l,h){return-1!==l.indexOf(h)}function Lt(){for(var l=[],h=0;h<arguments.length;h++)l[h]=arguments[h];for(var m=[],b=0,y=l;b<y.length;b++)for(var w=0,x=y[b];w<x.length;w++){var F=x[w];Sr(m,F)||m.push(F)}return m}var pi,hi=function(){var n=function(l,h){return(n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(l,h){l.__proto__=h}||function(l,h){for(var m in h)Object.prototype.hasOwnProperty.call(h,m)&&(l[m]=h[m])})(l,h)};return function(l,h){if("function"!=typeof h&&null!==h)throw new TypeError("Class extends value "+String(h)+" is not a constructor or null");function r(){this.constructor=l}n(l,h),l.prototype=null===h?Object.create(h):(r.prototype=h.prototype,new r)}}(),mi=function(){function n(l,h){this.offset=l,this.length=h,this.symbols=[],this.parent=null,this.children=[]}return n.prototype.addChild=function(l){this.children.push(l),l.setParent(this)},n.prototype.setParent=function(l){this.parent=l},n.prototype.findScope=function(l,h){return void 0===h&&(h=0),this.offset<=l&&this.offset+this.length>l+h||this.offset===l&&this.length===h?this.findInScope(l,h):null},n.prototype.findInScope=function(l,h){void 0===h&&(h=0);var m=l+h,b=function po(l,h){var m=0,b=l.length;if(0===b)return 0;for(;m<b;){var y=Math.floor((m+b)/2);h(l[y])?b=y:m=y+1}return m}(this.children,(function(l){return l.offset>m}));if(0===b)return this;var y=this.children[b-1];return y.offset<=l&&y.offset+y.length>=l+h?y.findInScope(l,h):this},n.prototype.addSymbol=function(l){this.symbols.push(l)},n.prototype.getSymbol=function(l,h){for(var m=0;m<this.symbols.length;m++){var b=this.symbols[m];if(b.name===l&&b.type===h)return b}return null},n.prototype.getSymbols=function(){return this.symbols},n}(),ui=function(l){function e(){return l.call(this,0,Number.MAX_VALUE)||this}return hi(e,l),e}(mi),fi=function l(h,m,b,y){this.name=h,this.value=m,this.node=b,this.type=y},gi=function(){function n(l){this.scope=l}return n.prototype.addSymbol=function(l,h,m,b){if(-1!==l.offset){var y=this.scope.findScope(l.offset,l.length);y&&y.addSymbol(new fi(h,m,l,b))}},n.prototype.addScope=function(l){if(-1!==l.offset){var h=this.scope.findScope(l.offset,l.length);if(h&&(h.offset!==l.offset||h.length!==l.length)){var m=new mi(l.offset,l.length);return h.addChild(m),m}return h}return null},n.prototype.addSymbolToChildScope=function(l,h,m,b,y){if(l&&-1!==l.offset){var w=this.addScope(l);w&&w.addSymbol(new fi(m,b,h,y))}},n.prototype.visitNode=function(l){switch(l.type){case Ee.Keyframe:return this.addSymbol(l,l.getName(),void 0,ze.Keyframe),!0;case Ee.CustomPropertyDeclaration:return this.visitCustomPropertyDeclarationNode(l);case Ee.VariableDeclaration:return this.visitVariableDeclarationNode(l);case Ee.Ruleset:return this.visitRuleSet(l);case Ee.MixinDeclaration:return this.addSymbol(l,l.getName(),void 0,ze.Mixin),!0;case Ee.FunctionDeclaration:return this.addSymbol(l,l.getName(),void 0,ze.Function),!0;case Ee.FunctionParameter:return this.visitFunctionParameterNode(l);case Ee.Declarations:return this.addScope(l),!0;case Ee.For:var h=l,m=h.getDeclarations();return m&&h.variable&&this.addSymbolToChildScope(m,h.variable,h.variable.getName(),void 0,ze.Variable),!0;case Ee.Each:var b=l,y=b.getDeclarations();if(y)for(var w=0,x=b.getVariables().getChildren();w<x.length;w++){var F=x[w];this.addSymbolToChildScope(y,F,F.getName(),void 0,ze.Variable)}return!0}return!0},n.prototype.visitRuleSet=function(l){var h=this.scope.findScope(l.offset,l.length);if(h)for(var m=0,b=l.getSelectors().getChildren();m<b.length;m++){var y=b[m];y instanceof We&&1===y.getChildren().length&&h.addSymbol(new fi(y.getChild(0).getText(),void 0,y,ze.Rule))}return!0},n.prototype.visitVariableDeclarationNode=function(l){var h=l.getValue()?l.getValue().getText():void 0;return this.addSymbol(l,l.getName(),h,ze.Variable),!0},n.prototype.visitFunctionParameterNode=function(l){var h=l.getParent().getDeclarations();if(h){var m=l.getDefaultValue(),b=m?m.getText():void 0;this.addSymbolToChildScope(h,l,l.getName(),b,ze.Variable)}return!0},n.prototype.visitCustomPropertyDeclarationNode=function(l){var h=l.getValue()?l.getValue().getText():"";return this.addCSSVariable(l.getProperty(),l.getProperty().getName(),h,ze.Variable),!0},n.prototype.addCSSVariable=function(l,h,m,b){-1!==l.offset&&this.scope.addSymbol(new fi(h,m,l,b))},n}(),bi=function(){function n(l){this.global=new ui,l.acceptVisitor(new gi(this.global))}return n.prototype.findSymbolsAtOffset=function(l,h){for(var m=this.global.findScope(l,0),b=[],y={};m;){for(var w=m.getSymbols(),x=0;x<w.length;x++){var F=w[x];F.type===h&&!y[F.name]&&(b.push(F),y[F.name]=!0)}m=m.parent}return b},n.prototype.internalFindSymbol=function(l,h){var m=l;if(l.parent instanceof He&&l.parent.getParent()instanceof Ae&&(m=l.parent.getParent().getDeclarations()),l.parent instanceof Je&&l.parent.getParent()instanceof Ge){var b=l.parent.getParent().getIdentifier();if(b){var y=this.internalFindSymbol(b,[ze.Function]);y&&(m=y.node.getDeclarations())}}if(!m)return null;for(var w=l.getText(),x=this.global.findScope(m.offset,m.length);x;){for(var F=0;F<h.length;F++){var E=h[F],z=x.getSymbol(w,E);if(z)return z}x=x.parent}return null},n.prototype.evaluateReferenceTypes=function(l){if(l instanceof Me){var h=l.referenceTypes;if(h)return h;if(l.isCustomProperty)return[ze.Variable];var m=function ni(l){var h=l.findParent(Ee.Declaration),m=h&&h.getValue();return m&&m.encloses(l)?h:null}(l);if(m){var b=m.getNonPrefixedPropertyName();if(("animation"===b||"animation-name"===b)&&m.getValue()&&m.getValue().offset===l.offset)return[ze.Keyframe]}}else if(l instanceof Zt)return[ze.Variable];return l.findAParent(Ee.Selector,Ee.ExtendsReference)?[ze.Rule]:null},n.prototype.findSymbolFromNode=function(l){if(!l)return null;for(;l.type===Ee.Interpolation;)l=l.getParent();var h=this.evaluateReferenceTypes(l);return h?this.internalFindSymbol(l,h):null},n.prototype.matchesSymbol=function(l,h){if(!l)return!1;for(;l.type===Ee.Interpolation;)l=l.getParent();if(!l.matches(h.name))return!1;var m=this.evaluateReferenceTypes(l);return!(!m||-1===m.indexOf(h.type))&&this.internalFindSymbol(l,m)===h},n.prototype.findSymbol=function(l,h,m){for(var b=this.global.findScope(m);b;){var y=b.getSymbol(l,h);if(y)return y;b=b.parent}return null},n}();pi=(()=>{var l={470:l=>{function i(l){if("string"!=typeof l)throw new TypeError("Path must be a string. Received "+JSON.stringify(l))}function o(l,h){for(var m,b="",y=0,w=-1,x=0,F=0;F<=l.length;++F){if(F<l.length)m=l.charCodeAt(F);else{if(47===m)break;m=47}if(47===m){if(w!==F-1&&1!==x)if(w!==F-1&&2===x){if(b.length<2||2!==y||46!==b.charCodeAt(b.length-1)||46!==b.charCodeAt(b.length-2))if(b.length>2){var E=b.lastIndexOf("/");if(E!==b.length-1){-1===E?(b="",y=0):y=(b=b.slice(0,E)).length-1-b.lastIndexOf("/"),w=F,x=0;continue}}else if(2===b.length||1===b.length){b="",y=0,w=F,x=0;continue}h&&(b.length>0?b+="/..":b="..",y=2)}else b.length>0?b+="/"+l.slice(w+1,F):b=l.slice(w+1,F),y=F-w-1;w=F,x=0}else 46===m&&-1!==x?++x:x=-1}return b}var h={resolve:function(){for(var l,h="",m=!1,b=arguments.length-1;b>=-1&&!m;b--){var y;b>=0?y=arguments[b]:(void 0===l&&(l=process.cwd()),y=l),i(y),0!==y.length&&(h=y+"/"+h,m=47===y.charCodeAt(0))}return h=o(h,!m),m?h.length>0?"/"+h:"/":h.length>0?h:"."},normalize:function(l){if(i(l),0===l.length)return".";var h=47===l.charCodeAt(0),m=47===l.charCodeAt(l.length-1);return 0!==(l=o(l,!h)).length||h||(l="."),l.length>0&&m&&(l+="/"),h?"/"+l:l},isAbsolute:function(l){return i(l),l.length>0&&47===l.charCodeAt(0)},join:function(){if(0===arguments.length)return".";for(var l,m=0;m<arguments.length;++m){var b=arguments[m];i(b),b.length>0&&(void 0===l?l=b:l+="/"+b)}return void 0===l?".":h.normalize(l)},relative:function(l,m){if(i(l),i(m),l===m||(l=h.resolve(l))===(m=h.resolve(m)))return"";for(var b=1;b<l.length&&47===l.charCodeAt(b);++b);for(var y=l.length,w=y-b,x=1;x<m.length&&47===m.charCodeAt(x);++x);for(var F=m.length-x,E=w<F?w:F,z=-1,D=0;D<=E;++D){if(D===E){if(F>E){if(47===m.charCodeAt(x+D))return m.slice(x+D+1);if(0===D)return m.slice(x+D)}else w>E&&(47===l.charCodeAt(b+D)?z=D:0===D&&(z=0));break}var R=l.charCodeAt(b+D);if(R!==m.charCodeAt(x+D))break;47===R&&(z=D)}var T="";for(D=b+z+1;D<=y;++D)D!==y&&47!==l.charCodeAt(D)||(0===T.length?T+="..":T+="/..");return T.length>0?T+m.slice(x+z):(x+=z,47===m.charCodeAt(x)&&++x,m.slice(x))},_makeLong:function(l){return l},dirname:function(l){if(i(l),0===l.length)return".";for(var h=l.charCodeAt(0),m=47===h,b=-1,y=!0,w=l.length-1;w>=1;--w)if(47===(h=l.charCodeAt(w))){if(!y){b=w;break}}else y=!1;return-1===b?m?"/":".":m&&1===b?"//":l.slice(0,b)},basename:function(l,h){if(void 0!==h&&"string"!=typeof h)throw new TypeError('"ext" argument must be a string');i(l);var m,b=0,y=-1,w=!0;if(void 0!==h&&h.length>0&&h.length<=l.length){if(h.length===l.length&&h===l)return"";var x=h.length-1,F=-1;for(m=l.length-1;m>=0;--m){var E=l.charCodeAt(m);if(47===E){if(!w){b=m+1;break}}else-1===F&&(w=!1,F=m+1),x>=0&&(E===h.charCodeAt(x)?-1==--x&&(y=m):(x=-1,y=F))}return b===y?y=F:-1===y&&(y=l.length),l.slice(b,y)}for(m=l.length-1;m>=0;--m)if(47===l.charCodeAt(m)){if(!w){b=m+1;break}}else-1===y&&(w=!1,y=m+1);return-1===y?"":l.slice(b,y)},extname:function(l){i(l);for(var h=-1,m=0,b=-1,y=!0,w=0,x=l.length-1;x>=0;--x){var F=l.charCodeAt(x);if(47!==F)-1===b&&(y=!1,b=x+1),46===F?-1===h?h=x:1!==w&&(w=1):-1!==h&&(w=-1);else if(!y){m=x+1;break}}return-1===h||-1===b||0===w||1===w&&h===b-1&&h===m+1?"":l.slice(h,b)},format:function(l){if(null===l||"object"!=typeof l)throw new TypeError('The "pathObject" argument must be of type Object. Received type '+typeof l);return m=(h=l).dir||h.root,b=h.base||(h.name||"")+(h.ext||""),m?m===h.root?m+b:m+"/"+b:b;var h,m,b},parse:function(l){i(l);var h={root:"",dir:"",base:"",ext:"",name:""};if(0===l.length)return h;var m,b=l.charCodeAt(0),y=47===b;y?(h.root="/",m=1):m=0;for(var w=-1,x=0,F=-1,E=!0,z=l.length-1,D=0;z>=m;--z)if(47!==(b=l.charCodeAt(z)))-1===F&&(E=!1,F=z+1),46===b?-1===w?w=z:1!==D&&(D=1):-1!==w&&(D=-1);else if(!E){x=z+1;break}return-1===w||-1===F||0===D||1===D&&w===F-1&&w===x+1?-1!==F&&(h.base=h.name=0===x&&y?l.slice(1,F):l.slice(x,F)):(0===x&&y?(h.name=l.slice(1,w),h.base=l.slice(1,F)):(h.name=l.slice(x,w),h.base=l.slice(x,F)),h.ext=l.slice(w,F)),x>0?h.dir=l.slice(0,x-1):y&&(h.dir="/"),h},sep:"/",delimiter:":",win32:null,posix:null};h.posix=h,l.exports=h},447:(l,h,m)=>{var b;if(m.r(h),m.d(h,{URI:()=>P,Utils:()=>W}),"object"==typeof process)b="win32"===process.platform;else if("object"==typeof navigator){var y=navigator.userAgent;b=y.indexOf("Windows")>=0}var w,x,F=(w=function(l,h){return(w=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(l,h){l.__proto__=h}||function(l,h){for(var m in h)Object.prototype.hasOwnProperty.call(h,m)&&(l[m]=h[m])})(l,h)},function(l,h){if("function"!=typeof h&&null!==h)throw new TypeError("Class extends value "+String(h)+" is not a constructor or null");function S(){this.constructor=l}w(l,h),l.prototype=null===h?Object.create(h):(S.prototype=h.prototype,new S)}),E=/^\w[\w\d+.-]*$/,z=/^\//,D=/^\/\//;function C(l,h){if(!l.scheme&&h)throw new Error('[UriError]: Scheme is missing: {scheme: "", authority: "'.concat(l.authority,'", path: "').concat(l.path,'", query: "').concat(l.query,'", fragment: "').concat(l.fragment,'"}'));if(l.scheme&&!E.test(l.scheme))throw new Error("[UriError]: Scheme contains illegal characters.");if(l.path)if(l.authority){if(!z.test(l.path))throw new Error('[UriError]: If a URI contains an authority component, then the path component must either be empty or begin with a slash ("/") character')}else if(D.test(l.path))throw new Error('[UriError]: If a URI does not contain an authority component, then the path cannot begin with two slash characters ("//")')}var R="",T="/",M=/^(([^:/?#]+?):)?(\/\/([^/?#]*))?([^?#]*)(\?([^#]*))?(#(.*))?/,P=function(){function k(l,h,m,b,y,w){var x,F;void 0===w&&(w=!1),"object"==typeof l?(this.scheme=l.scheme||R,this.authority=l.authority||R,this.path=l.path||R,this.query=l.query||R,this.fragment=l.fragment||R):(this.scheme=(F=w,(x=l)||F?x:"file"),this.authority=h||R,this.path=function(l,h){switch(l){case"https":case"http":case"file":h?h[0]!==T&&(h=T+h):h=T}return h}(this.scheme,m||R),this.query=b||R,this.fragment=y||R,C(this,w))}return k.isUri=function(l){return l instanceof k||!!l&&"string"==typeof l.authority&&"string"==typeof l.fragment&&"string"==typeof l.path&&"string"==typeof l.query&&"string"==typeof l.scheme&&"string"==typeof l.fsPath&&"function"==typeof l.with&&"function"==typeof l.toString},Object.defineProperty(k.prototype,"fsPath",{get:function(){return Yt(this,!1)},enumerable:!1,configurable:!0}),k.prototype.with=function(l){if(!l)return this;var h=l.scheme,m=l.authority,b=l.path,y=l.query,w=l.fragment;return void 0===h?h=this.scheme:null===h&&(h=R),void 0===m?m=this.authority:null===m&&(m=R),void 0===b?b=this.path:null===b&&(b=R),void 0===y?y=this.query:null===y&&(y=R),void 0===w?w=this.fragment:null===w&&(w=R),h===this.scheme&&m===this.authority&&b===this.path&&y===this.query&&w===this.fragment?this:new N(h,m,b,y,w)},k.parse=function(l,h){void 0===h&&(h=!1);var m=M.exec(l);return m?new N(m[2]||R,Ve(m[4]||R),Ve(m[5]||R),Ve(m[7]||R),Ve(m[9]||R),h):new N(R,R,R,R,R)},k.file=function(l){var h=R;if(b&&(l=l.replace(/\\/g,T)),l[0]===T&&l[1]===T){var m=l.indexOf(T,2);-1===m?(h=l.substring(2),l=T):(h=l.substring(2,m),l=l.substring(m)||T)}return new N("file",h,l,R,R)},k.from=function(l){var h=new N(l.scheme,l.authority,l.path,l.query,l.fragment);return C(h,!0),h},k.prototype.toString=function(l){return void 0===l&&(l=!1),Ne(this,l)},k.prototype.toJSON=function(){return this},k.revive=function(l){if(l){if(l instanceof k)return l;var h=new N(l);return h._formatted=l.external,h._fsPath=l._sep===_?l.fsPath:null,h}return l},k}(),_=b?1:void 0,N=function(l){function v(){var h=null!==l&&l.apply(this,arguments)||this;return h._formatted=null,h._fsPath=null,h}return F(v,l),Object.defineProperty(v.prototype,"fsPath",{get:function(){return this._fsPath||(this._fsPath=Yt(this,!1)),this._fsPath},enumerable:!1,configurable:!0}),v.prototype.toString=function(l){return void 0===l&&(l=!1),l?Ne(this,!0):(this._formatted||(this._formatted=Ne(this,!1)),this._formatted)},v.prototype.toJSON=function(){var l={$mid:1};return this._fsPath&&(l.fsPath=this._fsPath,l._sep=_),this._formatted&&(l.external=this._formatted),this.path&&(l.path=this.path),this.scheme&&(l.scheme=this.scheme),this.authority&&(l.authority=this.authority),this.query&&(l.query=this.query),this.fragment&&(l.fragment=this.fragment),l},v}(P),A=((x={})[58]="%3A",x[47]="%2F",x[63]="%3F",x[35]="%23",x[91]="%5B",x[93]="%5D",x[64]="%40",x[33]="%21",x[36]="%24",x[38]="%26",x[39]="%27",x[40]="%28",x[41]="%29",x[42]="%2A",x[43]="%2B",x[44]="%2C",x[59]="%3B",x[61]="%3D",x[32]="%20",x);function se(l,h){for(var m=void 0,b=-1,y=0;y<l.length;y++){var w=l.charCodeAt(y);if(w>=97&&w<=122||w>=65&&w<=90||w>=48&&w<=57||45===w||46===w||95===w||126===w||h&&47===w)-1!==b&&(m+=encodeURIComponent(l.substring(b,y)),b=-1),void 0!==m&&(m+=l.charAt(y));else{void 0===m&&(m=l.substr(0,y));var x=A[w];void 0!==x?(-1!==b&&(m+=encodeURIComponent(l.substring(b,y)),b=-1),m+=x):-1===b&&(b=y)}}return-1!==b&&(m+=encodeURIComponent(l.substring(b))),void 0!==m?m:l}function Qe(l){for(var h=void 0,m=0;m<l.length;m++){var b=l.charCodeAt(m);35===b||63===b?(void 0===h&&(h=l.substr(0,m)),h+=A[b]):void 0!==h&&(h+=l[m])}return void 0!==h?h:l}function Yt(l,h){var m;return m=l.authority&&l.path.length>1&&"file"===l.scheme?"//".concat(l.authority).concat(l.path):47===l.path.charCodeAt(0)&&(l.path.charCodeAt(1)>=65&&l.path.charCodeAt(1)<=90||l.path.charCodeAt(1)>=97&&l.path.charCodeAt(1)<=122)&&58===l.path.charCodeAt(2)?h?l.path.substr(1):l.path[1].toLowerCase()+l.path.substr(2):l.path,b&&(m=m.replace(/\//g,"\\")),m}function Ne(l,h){var m=h?Qe:se,b="",y=l.scheme,w=l.authority,x=l.path,F=l.query,E=l.fragment;if(y&&(b+=y,b+=":"),(w||"file"===y)&&(b+=T,b+=T),w){var z=w.indexOf("@");if(-1!==z){var D=w.substr(0,z);w=w.substr(z+1),-1===(z=D.indexOf(":"))?b+=m(D,!1):(b+=m(D.substr(0,z),!1),b+=":",b+=m(D.substr(z+1),!1)),b+="@"}-1===(z=(w=w.toLowerCase()).indexOf(":"))?b+=m(w,!1):(b+=m(w.substr(0,z),!1),b+=w.substr(z))}if(x){if(x.length>=3&&47===x.charCodeAt(0)&&58===x.charCodeAt(2))(R=x.charCodeAt(1))>=65&&R<=90&&(x="/".concat(String.fromCharCode(R+32),":").concat(x.substr(3)));else if(x.length>=2&&58===x.charCodeAt(1)){var R;(R=x.charCodeAt(0))>=65&&R<=90&&(x="".concat(String.fromCharCode(R+32),":").concat(x.substr(2)))}b+=m(x,!0)}return F&&(b+="?",b+=m(F,!1)),E&&(b+="#",b+=h?E:se(E,!1)),b}function wt(l){try{return decodeURIComponent(l)}catch{return l.length>3?l.substr(0,3)+wt(l.substr(3)):l}}var O=/(%[0-9A-Za-z][0-9A-Za-z])+/g;function Ve(l){return l.match(O)?l.replace(O,(function(l){return wt(l)})):l}var W,L,U=m(470),et=function(l,h,m){if(m||2===arguments.length)for(var b,y=0,w=h.length;y<w;y++)!b&&y in h||(b||(b=Array.prototype.slice.call(h,0,y)),b[y]=h[y]);return l.concat(b||Array.prototype.slice.call(h))},j=U.posix||U;(L=W||(W={})).joinPath=function(l){for(var h=[],m=1;m<arguments.length;m++)h[m-1]=arguments[m];return l.with({path:j.join.apply(j,et([l.path],h,!1))})},L.resolvePath=function(l){for(var h=[],m=1;m<arguments.length;m++)h[m-1]=arguments[m];var b=l.path||"/";return l.with({path:j.resolve.apply(j,et([b],h,!1))})},L.dirname=function(l){var h=j.dirname(l.path);return 1===h.length&&46===h.charCodeAt(0)?l:l.with({path:h})},L.basename=function(l){return j.basename(l.path)},L.extname=function(l){return j.extname(l.path)}}},h={};function t(m){if(h[m])return h[m].exports;var b=h[m]={exports:{}};return l[m](b,b.exports,t),b.exports}return t.d=(l,h)=>{for(var m in h)t.o(h,m)&&!t.o(l,m)&&Object.defineProperty(l,m,{enumerable:!0,get:h[m]})},t.o=(l,h)=>Object.prototype.hasOwnProperty.call(l,h),t.r=l=>{typeof Symbol<"u"&&Symbol.toStringTag&&Object.defineProperty(l,Symbol.toStringTag,{value:"Module"}),Object.defineProperty(l,"__esModule",{value:!0})},t(447)})();var{URI:vi,Utils:yi}=pi;function Fn(l){return yi.dirname(vi.parse(l)).toString()}function Vt(l){for(var h=[],m=1;m<arguments.length;m++)h[m-1]=arguments[m];return yi.joinPath.apply(yi,function(l,h,m){if(m||2===arguments.length)for(var b,y=0,w=h.length;y<w;y++)(b||!(y in h))&&(b||(b=Array.prototype.slice.call(h,0,y)),b[y]=h[y]);return l.concat(b||Array.prototype.slice.call(h))}([vi.parse(l)],h,!1)).toString()}var mo=function(l,h,m,b){return new(m||(m=Promise))((function(y,w){function s(l){try{c(b.next(l))}catch(l){w(l)}}function d(l){try{c(b.throw(l))}catch(l){w(l)}}function c(l){l.done?y(l.value):function i(l){return l instanceof m?l:new m((function(h){h(l)}))}(l.value).then(s,d)}c((b=b.apply(l,h||[])).next())}))},fo=function(l,h){var m,b,y,w,x={label:0,sent:function(){if(1&y[0])throw y[1];return y[1]},trys:[],ops:[]};return w={next:s(0),throw:s(1),return:s(2)},"function"==typeof Symbol&&(w[Symbol.iterator]=function(){return this}),w;function s(w){return function(F){return function d(w){if(m)throw new TypeError("Generator is already executing.");for(;x;)try{if(m=1,b&&(y=2&w[0]?b.return:w[0]?b.throw||((y=b.return)&&y.call(b),0):b.next)&&!(y=y.call(b,w[1])).done)return y;switch(b=0,y&&(w=[2&w[0],y.value]),w[0]){case 0:case 1:y=w;break;case 4:return x.label++,{value:w[1],done:!1};case 5:x.label++,b=w[1],w=[0];continue;case 7:w=x.ops.pop(),x.trys.pop();continue;default:if(!(y=(y=x.trys).length>0&&y[y.length-1])&&(6===w[0]||2===w[0])){x=0;continue}if(3===w[0]&&(!y||w[1]>y[0]&&w[1]<y[3])){x.label=w[1];break}if(6===w[0]&&x.label<y[1]){x.label=y[1],y=w;break}if(y&&x.label<y[2]){x.label=y[2],x.ops.push(w);break}y[2]&&x.ops.pop(),x.trys.pop();continue}w=h.call(l,x)}catch(l){w=[6,l],b=0}finally{m=y=0}if(5&w[0])throw w[1];return{value:w[0]?w[1]:void 0,done:!0}}([w,F])}}},wi=function(){function n(l){this.readDirectory=l,this.literalCompletions=[],this.importCompletions=[]}return n.prototype.onCssURILiteralValue=function(l){this.literalCompletions.push(l)},n.prototype.onCssImportPath=function(l){this.importCompletions.push(l)},n.prototype.computeCompletions=function(l,h){return mo(this,void 0,void 0,(function(){var m,b,y,w,x,F,E,z,D,R,T,M,P,_,N,A,O;return fo(this,(function(W){switch(W.label){case 0:m={items:[],isIncomplete:!1},b=0,y=this.literalCompletions,W.label=1;case 1:return b<y.length?(w=y[b],x=w.uriValue,"."===(P=kr(x))||".."===P?(m.isIncomplete=!0,[3,4]):[3,2]):[3,5];case 2:return[4,this.providePathSuggestions(x,w.position,w.range,l,h)];case 3:for(F=W.sent(),E=0,z=F;E<z.length;E++)O=z[E],m.items.push(O);W.label=4;case 4:return b++,[3,1];case 5:D=0,R=this.importCompletions,W.label=6;case 6:return D<R.length?(T=R[D],M=T.pathValue,"."===(P=kr(M))||".."===P?(m.isIncomplete=!0,[3,9]):[3,7]):[3,10];case 7:return[4,this.providePathSuggestions(M,T.position,T.range,l,h)];case 8:for(_=W.sent(),"scss"===l.languageId&&_.forEach((function(l){V(l.label,"_")&&en(l.label,".scss")&&(l.textEdit?l.textEdit.newText=l.label.slice(1,-5):l.label=l.label.slice(1,-5))})),N=0,A=_;N<A.length;N++)O=A[N],m.items.push(O);W.label=9;case 9:return D++,[3,6];case 10:return[2,m]}}))}))},n.prototype.providePathSuggestions=function(l,h,m,b,y){return mo(this,void 0,void 0,(function(){var w,x,F,E,z,D,R,T,M,P,_,N,A,O,W;return fo(this,(function(L){switch(L.label){case 0:if(w=kr(l),x=V(l,"'")||V(l,'"'),F=x?w.slice(0,h.character-(m.start.character+1)):w.slice(0,h.character-m.start.character),E=b.uri,z=x?function qa(l,h,m){var b=Dn(l.start,h),y=Dn(l.end,m);return bn.create(b,y)}(m,1,-1):m,D=function Ba(l,h,m){var b,y=l.lastIndexOf("/");if(-1===y)b=m;else{var w=h.slice(y+1),x=Dn(m.end,-w.length),F=w.indexOf(" "),E=void 0;E=-1!==F?Dn(x,F):m.end,b=bn.create(x,E)}return b}(F,w,z),R=F.substring(0,F.lastIndexOf("/")+1),!(T=y.resolveReference(R||".",E)))return[3,4];L.label=1;case 1:return L.trys.push([1,3,,4]),M=[],[4,this.readDirectory(T)];case 2:for(P=L.sent(),_=0,N=P;_<N.length;_++)A=N[_],O=A[0],W=A[1],O.charCodeAt(0)!==xi&&(W===Wr.Directory||Vt(T,O)!==E)&&M.push($a(O,W===Wr.Directory,D));return[2,M];case 3:return L.sent(),[3,4];case 4:return[2,[]]}}))}))},n}(),xi=".".charCodeAt(0);function kr(l){return V(l,"'")||V(l,'"')?l.slice(1,-1):l}function $a(l,h,m){return h?{label:En(l+="/"),kind:tr.Folder,textEdit:An.replace(m,En(l)),command:{title:"Suggest",command:"editor.action.triggerSuggest"}}:{label:En(l),kind:tr.File,textEdit:An.replace(m,En(l))}}function En(l){return l.replace(/(\s|\(|\)|,|"|')/g,"\\$1")}function Dn(l,h){return gn.create(l.line,l.character+h)}var Si,Ka=function(l,h,m,b){return new(m||(m=Promise))((function(y,w){function s(l){try{c(b.next(l))}catch(l){w(l)}}function d(l){try{c(b.throw(l))}catch(l){w(l)}}function c(l){l.done?y(l.value):function i(l){return l instanceof m?l:new m((function(h){h(l)}))}(l.value).then(s,d)}c((b=b.apply(l,h||[])).next())}))},Ga=function(l,h){var m,b,y,w,x={label:0,sent:function(){if(1&y[0])throw y[1];return y[1]},trys:[],ops:[]};return w={next:s(0),throw:s(1),return:s(2)},"function"==typeof Symbol&&(w[Symbol.iterator]=function(){return this}),w;function s(w){return function(F){return function d(w){if(m)throw new TypeError("Generator is already executing.");for(;x;)try{if(m=1,b&&(y=2&w[0]?b.return:w[0]?b.throw||((y=b.return)&&y.call(b),0):b.next)&&!(y=y.call(b,w[1])).done)return y;switch(b=0,y&&(w=[2&w[0],y.value]),w[0]){case 0:case 1:y=w;break;case 4:return x.label++,{value:w[1],done:!1};case 5:x.label++,b=w[1],w=[0];continue;case 7:w=x.ops.pop(),x.trys.pop();continue;default:if(!(y=(y=x.trys).length>0&&y[y.length-1])&&(6===w[0]||2===w[0])){x=0;continue}if(3===w[0]&&(!y||w[1]>y[0]&&w[1]<y[3])){x.label=w[1];break}if(6===w[0]&&x.label<y[1]){x.label=y[1],y=w;break}if(y&&x.label<y[2]){x.label=y[2],x.ops.push(w);break}y[2]&&x.ops.pop(),x.trys.pop();continue}w=h.call(l,x)}catch(l){w=[6,l],b=0}finally{m=y=0}if(5&w[0])throw w[1];return{value:w[0]?w[1]:void 0,done:!0}}([w,F])}}},ki=$(),Ci=nr.Snippet,Fi={title:"Suggest",command:"editor.action.triggerSuggest"};!function(l){l.Enums=" ",l.Normal="d",l.VendorPrefixed="x",l.Term="y",l.Variable="z"}(Si||(Si={}));var Ei=function(){function n(l,h,m){void 0===l&&(l=null),this.variablePrefix=l,this.lsOptions=h,this.cssDataManager=m,this.completionParticipants=[]}return n.prototype.configure=function(l){this.defaultSettings=l},n.prototype.getSymbolContext=function(){return this.symbolContext||(this.symbolContext=new bi(this.styleSheet)),this.symbolContext},n.prototype.setCompletionParticipants=function(l){this.completionParticipants=l||[]},n.prototype.doComplete2=function(l,h,m,b,y){return void 0===y&&(y=this.defaultSettings),Ka(this,void 0,void 0,(function(){var w,x,F,E;return Ga(this,(function(z){switch(z.label){case 0:if(!this.lsOptions.fileSystemProvider||!this.lsOptions.fileSystemProvider.readDirectory)return[2,this.doComplete(l,h,m,y)];w=new wi(this.lsOptions.fileSystemProvider.readDirectory),x=this.completionParticipants,this.completionParticipants=[w].concat(x),F=this.doComplete(l,h,m,y),z.label=1;case 1:return z.trys.push([1,,3,4]),[4,w.computeCompletions(l,b)];case 2:return E=z.sent(),[2,{isIncomplete:F.isIncomplete||E.isIncomplete,items:E.items.concat(F.items)}];case 3:return this.completionParticipants=x,[7];case 4:return[2]}}))}))},n.prototype.doComplete=function(l,h,m,b){this.offset=l.offsetAt(h),this.position=h,this.currentWord=function Qa(l,h){for(var m=h-1,b=l.getText();m>=0&&-1===' \t\n\r":{[()]},*>+'.indexOf(b.charAt(m));)m--;return b.substring(m+1,h)}(l,this.offset),this.defaultReplaceRange=bn.create(gn.create(this.position.line,this.position.character-this.currentWord.length),this.position),this.textDocument=l,this.styleSheet=m,this.documentSettings=b;try{var y={isIncomplete:!1,items:[]};this.nodePath=it(this.styleSheet,this.offset);for(var w=this.nodePath.length-1;w>=0;w--){var x=this.nodePath[w];if(x instanceof Ke)this.getCompletionsForDeclarationProperty(x.getParent(),y);else if(x instanceof It)x.parent instanceof Xt?this.getVariableProposals(null,y):this.getCompletionsForExpression(x,y);else if(x instanceof Le){var F=x.findAParent(Ee.ExtendsReference,Ee.Ruleset);if(F)if(F.type===Ee.ExtendsReference)this.getCompletionsForExtendsReference(F,x,y);else{var E=F;this.getCompletionsForSelector(E,E&&E.isNested(),y)}}else if(x instanceof Je)this.getCompletionsForFunctionArgument(x,x.getParent(),y);else if(x instanceof _e)this.getCompletionsForDeclarations(x,y);else if(x instanceof Jt)this.getCompletionsForVariableDeclaration(x,y);else if(x instanceof Oe)this.getCompletionsForRuleSet(x,y);else if(x instanceof Xt)this.getCompletionsForInterpolation(x,y);else if(x instanceof st)this.getCompletionsForFunctionDeclaration(x,y);else if(x instanceof on)this.getCompletionsForMixinReference(x,y);else if(x instanceof Ge)this.getCompletionsForFunctionArgument(null,x,y);else if(x instanceof St)this.getCompletionsForSupports(x,y);else if(x instanceof Dt)this.getCompletionsForSupportsCondition(x,y);else if(x instanceof Qt)this.getCompletionsForExtendsReference(x,null,y);else if(x.type===Ee.URILiteral)this.getCompletionForUriLiteralValue(x,y);else if(null===x.parent)this.getCompletionForTopLevel(y);else{if(x.type!==Ee.StringLiteral||!this.isImportPathParent(x.parent.type))continue;this.getCompletionForImportPath(x,y)}if(y.items.length>0||this.offset>x.offset)return this.finalize(y)}return this.getCompletionsForStylesheet(y),0===y.items.length&&this.variablePrefix&&0===this.currentWord.indexOf(this.variablePrefix)&&this.getVariableProposals(null,y),this.finalize(y)}finally{this.position=null,this.currentWord=null,this.textDocument=null,this.styleSheet=null,this.symbolContext=null,this.defaultReplaceRange=null,this.nodePath=null}},n.prototype.isImportPathParent=function(l){return l===Ee.Import},n.prototype.finalize=function(l){return l},n.prototype.findInNodePath=function(){for(var l=[],h=0;h<arguments.length;h++)l[h]=arguments[h];for(var m=this.nodePath.length-1;m>=0;m--){var b=this.nodePath[m];if(-1!==l.indexOf(b.type))return b}return null},n.prototype.getCompletionsForDeclarationProperty=function(l,h){return this.getPropertyProposals(l,h)},n.prototype.getPropertyProposals=function(l,h){var m=this,b=this.isTriggerPropertyValueCompletionEnabled,y=this.isCompletePropertyWithSemicolonEnabled;return this.cssDataManager.getProperties().forEach((function(w){var x,F,E=!1;l?(x=m.getCompletionRange(l.getProperty()),F=w.name,de(l.colonPosition)||(F+=": ",E=!0)):(x=m.getCompletionRange(null),F=w.name+": ",E=!0),!l&&y&&(F+="$0;"),l&&!l.semicolonPosition&&y&&m.offset>=m.textDocument.offsetAt(x.end)&&(F+="$0;");var z={label:w.name,documentation:Se(w,m.doesSupportMarkdown()),tags:Bt(w)?[rr.Deprecated]:[],textEdit:An.replace(x,F),insertTextFormat:nr.Snippet,kind:tr.Property};w.restrictions||(E=!1),b&&E&&(z.command=Fi);var D=(255-("number"==typeof w.relevance?Math.min(Math.max(w.relevance,0),99):50)).toString(16),R=V(w.name,"-")?Si.VendorPrefixed:Si.Normal;z.sortText=R+"_"+D,h.items.push(z)})),this.completionParticipants.forEach((function(l){l.onCssProperty&&l.onCssProperty({propertyName:m.currentWord,range:m.defaultReplaceRange})})),h},Object.defineProperty(n.prototype,"isTriggerPropertyValueCompletionEnabled",{get:function(){var l,h;return null===(h=null===(l=this.documentSettings)||void 0===l?void 0:l.triggerPropertyValueCompletion)||void 0===h||h},enumerable:!1,configurable:!0}),Object.defineProperty(n.prototype,"isCompletePropertyWithSemicolonEnabled",{get:function(){var l,h;return null===(h=null===(l=this.documentSettings)||void 0===l?void 0:l.completePropertyWithSemicolon)||void 0===h||h},enumerable:!1,configurable:!0}),n.prototype.getCompletionsForDeclarationValue=function(l,h){for(var m=this,b=l.getFullPropertyName(),y=this.cssDataManager.getProperty(b),w=l.getValue()||null;w&&w.hasChildren();)w=w.findChildAtOffset(this.offset,!1);if(this.completionParticipants.forEach((function(l){l.onCssPropertyValue&&l.onCssPropertyValue({propertyName:b,propertyValue:m.currentWord,range:m.getCompletionRange(w)})})),y){if(y.restrictions)for(var x=0,F=y.restrictions;x<F.length;x++){switch(F[x]){case"color":this.getColorProposals(y,w,h);break;case"position":this.getPositionProposals(y,w,h);break;case"repeat":this.getRepeatStyleProposals(y,w,h);break;case"line-style":this.getLineStyleProposals(y,w,h);break;case"line-width":this.getLineWidthProposals(y,w,h);break;case"geometry-box":this.getGeometryBoxProposals(y,w,h);break;case"box":this.getBoxProposals(y,w,h);break;case"image":this.getImageProposals(y,w,h);break;case"timing-function":this.getTimingFunctionProposals(y,w,h);break;case"shape":this.getBasicShapeProposals(y,w,h)}}this.getValueEnumProposals(y,w,h),this.getCSSWideKeywordProposals(y,w,h),this.getUnitProposals(y,w,h)}else for(var E=function Ja(l,h){var m=h.getFullPropertyName(),b=new zi;function i(l){return(l instanceof Me||l instanceof Kt||l instanceof Nt)&&b.add(l.getText()),!0}function o(l){var h=l.getFullPropertyName();return m===h}function a(l){if(l instanceof Be&&l!==h&&o(l)){var m=l.getValue();m&&m.accept(i)}return!0}return l.accept(a),b}(this.styleSheet,l),z=0,D=E.getEntries();z<D.length;z++){var R=D[z];h.items.push({label:R,textEdit:An.replace(this.getCompletionRange(w),R),kind:tr.Value})}return this.getVariableProposals(w,h),this.getTermProposals(y,w,h),h},n.prototype.getValueEnumProposals=function(l,h,m){if(l.values)for(var b=0,y=l.values;b<y.length;b++){var w=y[b],x=w.name,F=void 0;if(en(x,")")){var E=x.lastIndexOf("(");-1!==E&&(x=x.substr(0,E)+"($1)",F=Ci)}var z=Si.Enums;V(w.name,"-")&&(z+=Si.VendorPrefixed);var D={label:w.name,documentation:Se(w,this.doesSupportMarkdown()),tags:Bt(l)?[rr.Deprecated]:[],textEdit:An.replace(this.getCompletionRange(h),x),sortText:z,kind:tr.Value,insertTextFormat:F};m.items.push(D)}return m},n.prototype.getCSSWideKeywordProposals=function(l,h,m){for(var b in Zr)m.items.push({label:b,documentation:Zr[b],textEdit:An.replace(this.getCompletionRange(h),b),kind:tr.Value});for(var y in Qr){var w=ft(y);m.items.push({label:y,documentation:Qr[y],textEdit:An.replace(this.getCompletionRange(h),w),kind:tr.Function,insertTextFormat:Ci,command:V(y,"var")?Fi:void 0})}return m},n.prototype.getCompletionsForInterpolation=function(l,h){return this.offset>=l.offset+2&&this.getVariableProposals(null,h),h},n.prototype.getVariableProposals=function(l,h){for(var m=0,b=this.getSymbolContext().findSymbolsAtOffset(this.offset,ze.Variable);m<b.length;m++){var y=b[m],w=V(y.name,"--")?"var(".concat(y.name,")"):y.name,x={label:y.name,documentation:y.value?Gn(y.value):y.value,textEdit:An.replace(this.getCompletionRange(l),w),kind:tr.Variable,sortText:Si.Variable};if("string"==typeof x.documentation&&vo(x.documentation)&&(x.kind=tr.Color),y.node.type===Ee.FunctionParameter){var F=y.node.getParent();F.type===Ee.MixinDeclaration&&(x.detail=ki("completion.argument","argument from '{0}'",F.getName()))}h.items.push(x)}return h},n.prototype.getVariableProposalsForCSSVarFunction=function(l){var h=new zi;this.styleSheet.acceptVisitor(new Ri(h,this.offset));for(var m=0,b=this.getSymbolContext().findSymbolsAtOffset(this.offset,ze.Variable);m<b.length;m++){var y=b[m];if(V(y.name,"--"))"string"==typeof(E={label:y.name,documentation:y.value?Gn(y.value):y.value,textEdit:An.replace(this.getCompletionRange(null),y.name),kind:tr.Variable}).documentation&&vo(E.documentation)&&(E.kind=tr.Color),l.items.push(E);h.remove(y.name)}for(var w=0,x=h.getEntries();w<x.length;w++){var F=x[w];if(V(F,"--")){var E={label:F,textEdit:An.replace(this.getCompletionRange(null),F),kind:tr.Variable};l.items.push(E)}}return l},n.prototype.getUnitProposals=function(l,h,m){var b="0";if(this.currentWord.length>0){var y=this.currentWord.match(/^-?\d[\.\d+]*/);y&&(b=y[0],m.isIncomplete=b.length===this.currentWord.length)}else 0===this.currentWord.length&&(m.isIncomplete=!0);if(h&&h.parent&&h.parent.type===Ee.Term&&(h=h.getParent()),l.restrictions)for(var w=0,x=l.restrictions;w<x.length;w++){var F=x[w],E=si[F];if(E)for(var z=0,D=E;z<D.length;z++){var R=b+D[z];m.items.push({label:R,textEdit:An.replace(this.getCompletionRange(h),R),kind:tr.Unit})}}return m},n.prototype.getCompletionRange=function(l){if(l&&l.offset<=this.offset&&this.offset<=l.end){var h=-1!==l.end?this.textDocument.positionAt(l.end):this.position,m=this.textDocument.positionAt(l.offset);if(m.line===h.line)return bn.create(m,h)}return this.defaultReplaceRange},n.prototype.getColorProposals=function(l,h,m){for(var b in $r)m.items.push({label:b,documentation:$r[b],textEdit:An.replace(this.getCompletionRange(h),b),kind:tr.Color});for(var b in Kr)m.items.push({label:b,documentation:Kr[b],textEdit:An.replace(this.getCompletionRange(h),b),kind:tr.Value});var y=new zi;this.styleSheet.acceptVisitor(new Di(y,this.offset));for(var w=0,x=y.getEntries();w<x.length;w++){b=x[w];m.items.push({label:b,textEdit:An.replace(this.getCompletionRange(h),b),kind:tr.Color})}for(var d=function(l){var b=1,y=l.func.replace(/\[?\$(\w+)\]?/g,(function(l,h){return"${"+b+++":"+h+"}"}));m.items.push({label:l.func.substr(0,l.func.indexOf("(")),detail:l.func,documentation:l.desc,textEdit:An.replace(F.getCompletionRange(h),y),insertTextFormat:Ci,kind:tr.Function})},F=this,E=0,z=Br;E<z.length;E++){d(z[E])}return m},n.prototype.getPositionProposals=function(l,h,m){for(var b in qr)m.items.push({label:b,documentation:qr[b],textEdit:An.replace(this.getCompletionRange(h),b),kind:tr.Value});return m},n.prototype.getRepeatStyleProposals=function(l,h,m){for(var b in Gr)m.items.push({label:b,documentation:Gr[b],textEdit:An.replace(this.getCompletionRange(h),b),kind:tr.Value});return m},n.prototype.getLineStyleProposals=function(l,h,m){for(var b in Hr)m.items.push({label:b,documentation:Hr[b],textEdit:An.replace(this.getCompletionRange(h),b),kind:tr.Value});return m},n.prototype.getLineWidthProposals=function(l,h,m){for(var b=0,y=Jr;b<y.length;b++){var w=y[b];m.items.push({label:w,textEdit:An.replace(this.getCompletionRange(h),w),kind:tr.Value})}return m},n.prototype.getGeometryBoxProposals=function(l,h,m){for(var b in Yr)m.items.push({label:b,documentation:Yr[b],textEdit:An.replace(this.getCompletionRange(h),b),kind:tr.Value});return m},n.prototype.getBoxProposals=function(l,h,m){for(var b in Xr)m.items.push({label:b,documentation:Xr[b],textEdit:An.replace(this.getCompletionRange(h),b),kind:tr.Value});return m},n.prototype.getImageProposals=function(l,h,m){for(var b in ri){var y=ft(b);m.items.push({label:b,documentation:ri[b],textEdit:An.replace(this.getCompletionRange(h),y),kind:tr.Function,insertTextFormat:b!==y?Ci:void 0})}return m},n.prototype.getTimingFunctionProposals=function(l,h,m){for(var b in ii){var y=ft(b);m.items.push({label:b,documentation:ii[b],textEdit:An.replace(this.getCompletionRange(h),y),kind:tr.Function,insertTextFormat:b!==y?Ci:void 0})}return m},n.prototype.getBasicShapeProposals=function(l,h,m){for(var b in oi){var y=ft(b);m.items.push({label:b,documentation:oi[b],textEdit:An.replace(this.getCompletionRange(h),y),kind:tr.Function,insertTextFormat:b!==y?Ci:void 0})}return m},n.prototype.getCompletionsForStylesheet=function(l){var h=this.styleSheet.findFirstChildBeforeOffset(this.offset);return h?h instanceof Oe?this.getCompletionsForRuleSet(h,l):h instanceof St?this.getCompletionsForSupports(h,l):l:this.getCompletionForTopLevel(l)},n.prototype.getCompletionForTopLevel=function(l){var h=this;return this.cssDataManager.getAtDirectives().forEach((function(m){l.items.push({label:m.name,textEdit:An.replace(h.getCompletionRange(null),m.name),documentation:Se(m,h.doesSupportMarkdown()),tags:Bt(m)?[rr.Deprecated]:[],kind:tr.Keyword})})),this.getCompletionsForSelector(null,!1,l),l},n.prototype.getCompletionsForRuleSet=function(l,h){var m=l.getDeclarations();return m&&m.endsWith("}")&&this.offset>=m.end?this.getCompletionForTopLevel(h):!m||this.offset<=m.offset?this.getCompletionsForSelector(l,l.isNested(),h):this.getCompletionsForDeclarations(l.getDeclarations(),h)},n.prototype.getCompletionsForSelector=function(l,h,m){var b=this,y=this.findInNodePath(Ee.PseudoSelector,Ee.IdentifierSelector,Ee.ClassSelector,Ee.ElementNameSelector);if(!y&&this.hasCharacterAtPosition(this.offset-this.currentWord.length-1,":")&&(this.currentWord=":"+this.currentWord,this.hasCharacterAtPosition(this.offset-this.currentWord.length-1,":")&&(this.currentWord=":"+this.currentWord),this.defaultReplaceRange=bn.create(gn.create(this.position.line,this.position.character-this.currentWord.length),this.position)),this.cssDataManager.getPseudoClasses().forEach((function(l){var h=ft(l.name),w={label:l.name,textEdit:An.replace(b.getCompletionRange(y),h),documentation:Se(l,b.doesSupportMarkdown()),tags:Bt(l)?[rr.Deprecated]:[],kind:tr.Function,insertTextFormat:l.name!==h?Ci:void 0};V(l.name,":-")&&(w.sortText=Si.VendorPrefixed),m.items.push(w)})),this.cssDataManager.getPseudoElements().forEach((function(l){var h=ft(l.name),w={label:l.name,textEdit:An.replace(b.getCompletionRange(y),h),documentation:Se(l,b.doesSupportMarkdown()),tags:Bt(l)?[rr.Deprecated]:[],kind:tr.Function,insertTextFormat:l.name!==h?Ci:void 0};V(l.name,"::-")&&(w.sortText=Si.VendorPrefixed),m.items.push(w)})),!h){for(var w=0,x=ai;w<x.length;w++){var F=x[w];m.items.push({label:F,textEdit:An.replace(this.getCompletionRange(y),F),kind:tr.Keyword})}for(var E=0,z=li;E<z.length;E++){F=z[E];m.items.push({label:F,textEdit:An.replace(this.getCompletionRange(y),F),kind:tr.Keyword})}}var D={};D[this.currentWord]=!0;var R=this.textDocument.getText();if(this.styleSheet.accept((function(l){if(l.type===Ee.SimpleSelector&&l.length>0){var h=R.substr(l.offset,l.length);return"."===h.charAt(0)&&!D[h]&&(D[h]=!0,m.items.push({label:h,textEdit:An.replace(b.getCompletionRange(y),h),kind:tr.Keyword})),!1}return!0})),l&&l.isNested()){var T=l.getSelectors().findFirstChildBeforeOffset(this.offset);T&&0===l.getSelectors().getChildren().indexOf(T)&&this.getPropertyProposals(null,m)}return m},n.prototype.getCompletionsForDeclarations=function(l,h){if(!l||this.offset===l.offset)return h;var m=l.findFirstChildBeforeOffset(this.offset);if(!m)return this.getCompletionsForDeclarationProperty(null,h);if(m instanceof Ue){var b=m;if(!de(b.colonPosition)||this.offset<=b.colonPosition)return this.getCompletionsForDeclarationProperty(b,h);if(de(b.semicolonPosition)&&b.semicolonPosition<this.offset)return this.offset===b.semicolonPosition+1?h:this.getCompletionsForDeclarationProperty(null,h);if(b instanceof Be)return this.getCompletionsForDeclarationValue(b,h)}else m instanceof Qt?this.getCompletionsForExtendsReference(m,null,h):(this.currentWord&&"@"===this.currentWord[0]||m instanceof Oe)&&this.getCompletionsForDeclarationProperty(null,h);return h},n.prototype.getCompletionsForVariableDeclaration=function(l,h){return this.offset&&de(l.colonPosition)&&this.offset>l.colonPosition&&this.getVariableProposals(l.getValue(),h),h},n.prototype.getCompletionsForExpression=function(l,h){var m=l.getParent();if(m instanceof Je)return this.getCompletionsForFunctionArgument(m,m.getParent(),h),h;var b=l.findParent(Ee.Declaration);if(!b)return this.getTermProposals(void 0,null,h),h;var y=l.findChildAtOffset(this.offset,!0);return y?y instanceof Kt||y instanceof Me?this.getCompletionsForDeclarationValue(b,h):h:this.getCompletionsForDeclarationValue(b,h)},n.prototype.getCompletionsForFunctionArgument=function(l,h,m){var b=h.getIdentifier();return b&&b.matches("var")&&(!h.getArguments().hasChildren()||h.getArguments().getChild(0)===l)&&this.getVariableProposalsForCSSVarFunction(m),m},n.prototype.getCompletionsForFunctionDeclaration=function(l,h){var m=l.getDeclarations();return m&&this.offset>m.offset&&this.offset<m.end&&this.getTermProposals(void 0,null,h),h},n.prototype.getCompletionsForMixinReference=function(l,h){for(var m=this,b=0,y=this.getSymbolContext().findSymbolsAtOffset(this.offset,ze.Mixin);b<y.length;b++){var w=y[b];w.node instanceof sn&&h.items.push(this.makeTermProposal(w,w.node.getParameters(),null))}var x=l.getIdentifier()||null;return this.completionParticipants.forEach((function(l){l.onCssMixinReference&&l.onCssMixinReference({mixinName:m.currentWord,range:m.getCompletionRange(x)})})),h},n.prototype.getTermProposals=function(l,h,m){for(var b=0,y=this.getSymbolContext().findSymbolsAtOffset(this.offset,ze.Function);b<y.length;b++){var w=y[b];w.node instanceof st&&m.items.push(this.makeTermProposal(w,w.node.getParameters(),h))}return m},n.prototype.makeTermProposal=function(l,h,m){l.node;var b=h.getChildren().map((function(l){return l instanceof He?l.getName():l.getText()})),y=l.name+"("+b.map((function(l,h){return"${"+(h+1)+":"+l+"}"})).join(", ")+")";return{label:l.name,detail:l.name+"("+b.join(", ")+")",textEdit:An.replace(this.getCompletionRange(m),y),insertTextFormat:Ci,kind:tr.Function,sortText:Si.Term}},n.prototype.getCompletionsForSupportsCondition=function(l,h){var m=l.findFirstChildBeforeOffset(this.offset);if(m){if(m instanceof Be)return!de(m.colonPosition)||this.offset<=m.colonPosition?this.getCompletionsForDeclarationProperty(m,h):this.getCompletionsForDeclarationValue(m,h);if(m instanceof Dt)return this.getCompletionsForSupportsCondition(m,h)}return de(l.lParent)&&this.offset>l.lParent&&(!de(l.rParent)||this.offset<=l.rParent)?this.getCompletionsForDeclarationProperty(null,h):h},n.prototype.getCompletionsForSupports=function(l,h){var m=l.getDeclarations();if(!m||this.offset<=m.offset){var b=l.findFirstChildBeforeOffset(this.offset);return b instanceof Dt?this.getCompletionsForSupportsCondition(b,h):h}return this.getCompletionForTopLevel(h)},n.prototype.getCompletionsForExtendsReference=function(l,h,m){return m},n.prototype.getCompletionForUriLiteralValue=function(l,h){var m,b,y;if(l.hasChildren()){var w=l.getChild(0);m=w.getText(),b=this.position,y=this.getCompletionRange(w)}else{m="",b=this.position;var x=this.textDocument.positionAt(l.offset+4);y=bn.create(x,x)}return this.completionParticipants.forEach((function(l){l.onCssURILiteralValue&&l.onCssURILiteralValue({uriValue:m,position:b,range:y})})),h},n.prototype.getCompletionForImportPath=function(l,h){var m=this;return this.completionParticipants.forEach((function(h){h.onCssImportPath&&h.onCssImportPath({pathValue:l.getText(),position:m.position,range:m.getCompletionRange(l)})})),h},n.prototype.hasCharacterAtPosition=function(l,h){var m=this.textDocument.getText();return l>=0&&l<m.length&&m.charAt(l)===h},n.prototype.doesSupportMarkdown=function(){var l,h,m;if(!de(this.supportsMarkdown)){if(!de(this.lsOptions.clientCapabilities))return this.supportsMarkdown=!0,this.supportsMarkdown;var b=null===(m=null===(h=null===(l=this.lsOptions.clientCapabilities.textDocument)||void 0===l?void 0:l.completion)||void 0===h?void 0:h.completionItem)||void 0===m?void 0:m.documentationFormat;this.supportsMarkdown=Array.isArray(b)&&-1!==b.indexOf(Qn.Markdown)}return this.supportsMarkdown},n}();function Bt(l){return!(!l.status||"nonstandard"!==l.status&&"obsolete"!==l.status)}var zi=function(){function n(){this.entries={}}return n.prototype.add=function(l){this.entries[l]=!0},n.prototype.remove=function(l){delete this.entries[l]},n.prototype.getEntries=function(){return Object.keys(this.entries)},n}();function ft(l){return l.replace(/\(\)$/,"($1)")}var Di=function(){function n(l,h){this.entries=l,this.currentOffset=h}return n.prototype.visitNode=function(l){return(l instanceof Nt||l instanceof Ge&&function to(l){var h=l.getName();return!!h&&/^(rgb|rgba|hsl|hsla)$/gi.test(h)}(l))&&(this.currentOffset<l.offset||l.end<this.currentOffset)&&this.entries.add(l.getText()),!0},n}(),Ri=function(){function n(l,h){this.entries=l,this.currentOffset=h}return n.prototype.visitNode=function(l){return l instanceof Me&&l.isCustomProperty&&(this.currentOffset<l.offset||l.end<this.currentOffset)&&this.entries.add(l.getText()),!0},n}();function vo(l){return l.toLowerCase()in $r||/(^#[0-9A-F]{6}$)|(^#[0-9A-F]{3}$)/i.test(l)}var Ti,Ii=function(){var n=function(l,h){return(n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(l,h){l.__proto__=h}||function(l,h){for(var m in h)Object.prototype.hasOwnProperty.call(h,m)&&(l[m]=h[m])})(l,h)};return function(l,h){if("function"!=typeof h&&null!==h)throw new TypeError("Class extends value "+String(h)+" is not a constructor or null");function r(){this.constructor=l}n(l,h),l.prototype=null===h?Object.create(h):(r.prototype=h.prototype,new r)}}(),Mi=$(),Pi=function(){function n(){this.parent=null,this.children=null,this.attributes=null}return n.prototype.findAttribute=function(l){if(this.attributes)for(var h=0,m=this.attributes;h<m.length;h++){var b=m[h];if(b.name===l)return b.value}return null},n.prototype.addChild=function(l){l instanceof n&&(l.parent=this),this.children||(this.children=[]),this.children.push(l)},n.prototype.append=function(l){if(this.attributes){var h=this.attributes[this.attributes.length-1];h.value=h.value+l}},n.prototype.prepend=function(l){if(this.attributes){var h=this.attributes[0];h.value=l+h.value}},n.prototype.findRoot=function(){for(var l=this;l.parent&&!(l.parent instanceof _i);)l=l.parent;return l},n.prototype.removeChild=function(l){if(this.children){var h=this.children.indexOf(l);if(-1!==h)return this.children.splice(h,1),!0}return!1},n.prototype.addAttr=function(l,h){this.attributes||(this.attributes=[]);for(var m=0,b=this.attributes;m<b.length;m++){var y=b[m];if(y.name===l)return void(y.value+=" "+h)}this.attributes.push({name:l,value:h})},n.prototype.clone=function(l){void 0===l&&(l=!0);var h=new n;if(this.attributes){h.attributes=[];for(var m=0,b=this.attributes;m<b.length;m++){var y=b[m];h.addAttr(y.name,y.value)}}if(l&&this.children){h.children=[];for(var w=0;w<this.children.length;w++)h.addChild(this.children[w].clone())}return h},n.prototype.cloneWithParent=function(){var l=this.clone(!1);!this.parent||this.parent instanceof _i||this.parent.cloneWithParent().addChild(l);return l},n}(),_i=function(l){function e(){return null!==l&&l.apply(this,arguments)||this}return Ii(e,l),e}(Pi),Ni=function(l){function e(h){var m=l.call(this)||this;return m.addAttr("name",h),m}return Ii(e,l),e}(Pi),Ai=function(){function n(l){this.quote=l,this.result=[]}return n.prototype.print=function(l){return this.result=[],l instanceof _i?l.children&&this.doPrint(l.children,0):this.doPrint([l],0),[{language:"html",value:this.result.join("\n")}]},n.prototype.doPrint=function(l,h){for(var m=0,b=l;m<b.length;m++){var y=b[m];this.doPrintElement(y,h),y.children&&this.doPrint(y.children,h+1)}},n.prototype.writeLine=function(l,h){var m=new Array(l+1).join("  ");this.result.push(m+h)},n.prototype.doPrintElement=function(l,h){var m=l.findAttribute("name");if(l instanceof Ni||"…"===m)this.writeLine(h,m);else{var b=["<"];if(m?b.push(m):b.push("element"),l.attributes)for(var y=0,w=l.attributes;y<w.length;y++){var x=w[y];if("name"!==x.name){b.push(" "),b.push(x.name);var F=x.value;F&&(b.push("="),b.push(Ti.ensure(F,this.quote)))}}b.push(">"),this.writeLine(h,b.join(""))}},n}();!function(l){function t(l){var h=l.match(/^['"](.*)["']$/);return h?h[1]:l}l.ensure=function e(l,h){return h+t(l)+h},l.remove=t}(Ti||(Ti={}));var Oi=function l(){this.id=0,this.attr=0,this.tag=0};function xo(l,h){for(var m=new Pi,b=0,y=l.getChildren();b<y.length;b++){var w=y[b];switch(w.type){case Ee.SelectorCombinator:if(h){var x=w.getText().split("&");if(1===x.length){m.addAttr("name",x[0]);break}if(m=h.cloneWithParent(),x[0])m.findRoot().prepend(x[0]);for(var F=1;F<x.length;F++){if(F>1){var E=h.cloneWithParent();m.addChild(E.findRoot()),m=E}m.append(x[F])}}break;case Ee.SelectorPlaceholder:if(w.matches("@at-root"))return m;case Ee.ElementNameSelector:var z=w.getText();m.addAttr("name","*"===z?"element":he(z));break;case Ee.ClassSelector:m.addAttr("class",he(w.getText().substring(1)));break;case Ee.IdentifierSelector:m.addAttr("id",he(w.getText().substring(1)));break;case Ee.MixinDeclaration:m.addAttr("class",w.getName());break;case Ee.PseudoSelector:m.addAttr(he(w.getText()),"");break;case Ee.AttributeSelector:var D=w,R=D.getIdentifier();if(R){var T=D.getValue(),M=D.getOperator(),P=void 0;if(T&&M)switch(he(M.getText())){case"|=":P="".concat(Ti.remove(he(T.getText())),"-…");break;case"^=":P="".concat(Ti.remove(he(T.getText())),"…");break;case"$=":P="…".concat(Ti.remove(he(T.getText())));break;case"~=":P=" … ".concat(Ti.remove(he(T.getText()))," … ");break;case"*=":P="…".concat(Ti.remove(he(T.getText())),"…");break;default:P=Ti.remove(he(T.getText()))}m.addAttr(he(R.getText()),P)}}}return m}function he(l){var h=new Fe;h.setSource(l);var m=h.scanUnquotedString();return m?m.text:l}var Wi=function(){function n(l){this.cssDataManager=l}return n.prototype.selectorToMarkedString=function(l){var h=function rs(l){if(l.matches("@at-root"))return null;var h=new _i,m=[],b=l.getParent();if(b instanceof Oe)for(var y=b.getParent();y&&!ns(y);){if(y instanceof Oe){if(y.getSelectors().matches("@at-root"))break;m.push(y)}y=y.getParent()}for(var w=new Li(h),x=m.length-1;x>=0;x--){var F=m[x].getSelectors().getChild(0);F&&w.processSelector(F)}return w.processSelector(l),h}(l);if(h){var m=new Ai('"').print(h);return m.push(this.selectorToSpecificityMarkedString(l)),m}return[]},n.prototype.simpleSelectorToMarkedString=function(l){var h=xo(l),m=new Ai('"').print(h);return m.push(this.selectorToSpecificityMarkedString(l)),m},n.prototype.isPseudoElementIdentifier=function(l){var h=l.match(/^::?([\w-]+)/);return!!h&&!!this.cssDataManager.getPseudoElement("::"+h[1])},n.prototype.selectorToSpecificityMarkedString=function(l){var h=this,r=function(l){for(var b=0,y=l.getChildren();b<y.length;b++){var w=y[b];switch(w.type){case Ee.IdentifierSelector:m.id++;break;case Ee.ClassSelector:case Ee.AttributeSelector:m.attr++;break;case Ee.ElementNameSelector:if(w.matches("*"))break;m.tag++;break;case Ee.PseudoSelector:var x=w.getText();if(h.isPseudoElementIdentifier(x))m.tag++;else{if(x.match(/^:not/i))break;m.attr++}}w.getChildren().length>0&&r(w)}},m=new Oi;return r(l),Mi("specificity","[Selector Specificity](https://developer.mozilla.org/en-US/docs/Web/CSS/Specificity): ({0}, {1}, {2})",m.id,m.attr,m.tag)},n}(),Li=function(){function n(l){this.prev=null,this.element=l}return n.prototype.processSelector=function(l){var h=null;if(!(this.element instanceof _i)&&l.getChildren().some((function(l){return l.hasChildren()&&l.getChild(0).type===Ee.SelectorCombinator}))){var m=this.element.findRoot();m.parent instanceof _i&&(h=this.element,this.element=m.parent,this.element.removeChild(m),this.prev=null)}for(var b=0,y=l.getChildren();b<y.length;b++){var w=y[b];if(w instanceof Le){if(this.prev instanceof Le){var x=new Ni("…");this.element.addChild(x),this.element=x}else this.prev&&(this.prev.matches("+")||this.prev.matches("~"))&&this.element.parent&&(this.element=this.element.parent);this.prev&&this.prev.matches("~")&&this.element.addChild(new Ni("⋮"));var F=xo(w,h),E=F.findRoot();this.element.addChild(E),this.element=F}(w instanceof Le||w.type===Ee.SelectorCombinatorParent||w.type===Ee.SelectorCombinatorShadowPiercingDescendant||w.type===Ee.SelectorCombinatorSibling||w.type===Ee.SelectorCombinatorAllSiblings)&&(this.prev=w)}},n}();function ns(l){switch(l.type){case Ee.MixinDeclaration:case Ee.Stylesheet:return!0}return!1}var Ui=function(){function n(l,h){this.clientCapabilities=l,this.cssDataManager=h,this.selectorPrinting=new Wi(h)}return n.prototype.configure=function(l){this.defaultSettings=l},n.prototype.doHover=function(l,h,m,b){function o(h){return bn.create(l.positionAt(h.offset),l.positionAt(h.end))}void 0===b&&(b=this.defaultSettings);for(var y=it(m,l.offsetAt(h)),w=null,x=0;x<y.length;x++){var F=y[x];if(F instanceof We){w={contents:this.selectorPrinting.selectorToMarkedString(F),range:o(F)};break}if(F instanceof Le){V(F.getText(),"@")||(w={contents:this.selectorPrinting.simpleSelectorToMarkedString(F),range:o(F)});break}if(F instanceof Be){var E=F.getFullPropertyName();(D=this.cssDataManager.getProperty(E))&&(w=(R=Se(D,this.doesSupportMarkdown(),b))?{contents:R,range:o(F)}:null)}else if(F instanceof an){var z=F.getText();(D=this.cssDataManager.getAtDirective(z))&&(w=(R=Se(D,this.doesSupportMarkdown(),b))?{contents:R,range:o(F)}:null)}else if(F instanceof Te&&F.type===Ee.PseudoSelector){var D,R,T=F.getText();(D="::"===T.slice(0,2)?this.cssDataManager.getPseudoElement(T):this.cssDataManager.getPseudoClass(T))&&(w=(R=Se(D,this.doesSupportMarkdown(),b))?{contents:R,range:o(F)}:null)}else;}return w&&(w.contents=this.convertContents(w.contents)),w},n.prototype.convertContents=function(l){return this.doesSupportMarkdown()||"string"==typeof l?l:"kind"in l?{kind:"plaintext",value:l.value}:Array.isArray(l)?l.map((function(l){return"string"==typeof l?l:l.value})):l.value},n.prototype.doesSupportMarkdown=function(){if(!de(this.supportsMarkdown)){if(!de(this.clientCapabilities))return this.supportsMarkdown=!0,this.supportsMarkdown;var l=this.clientCapabilities.textDocument&&this.clientCapabilities.textDocument.hover;this.supportsMarkdown=l&&l.contentFormat&&Array.isArray(l.contentFormat)&&-1!==l.contentFormat.indexOf(Qn.Markdown)}return this.supportsMarkdown},n}(),$t=function(l,h,m,b){return new(m||(m=Promise))((function(y,w){function s(l){try{c(b.next(l))}catch(l){w(l)}}function d(l){try{c(b.throw(l))}catch(l){w(l)}}function c(l){l.done?y(l.value):function i(l){return l instanceof m?l:new m((function(h){h(l)}))}(l.value).then(s,d)}c((b=b.apply(l,h||[])).next())}))},qt=function(l,h){var m,b,y,w,x={label:0,sent:function(){if(1&y[0])throw y[1];return y[1]},trys:[],ops:[]};return w={next:s(0),throw:s(1),return:s(2)},"function"==typeof Symbol&&(w[Symbol.iterator]=function(){return this}),w;function s(w){return function(F){return function d(w){if(m)throw new TypeError("Generator is already executing.");for(;x;)try{if(m=1,b&&(y=2&w[0]?b.return:w[0]?b.throw||((y=b.return)&&y.call(b),0):b.next)&&!(y=y.call(b,w[1])).done)return y;switch(b=0,y&&(w=[2&w[0],y.value]),w[0]){case 0:case 1:y=w;break;case 4:return x.label++,{value:w[1],done:!1};case 5:x.label++,b=w[1],w=[0];continue;case 7:w=x.ops.pop(),x.trys.pop();continue;default:if(!(y=(y=x.trys).length>0&&y[y.length-1])&&(6===w[0]||2===w[0])){x=0;continue}if(3===w[0]&&(!y||w[1]>y[0]&&w[1]<y[3])){x.label=w[1];break}if(6===w[0]&&x.label<y[1]){x.label=y[1],y=w;break}if(y&&x.label<y[2]){x.label=y[2],x.ops.push(w);break}y[2]&&x.ops.pop(),x.trys.pop();continue}w=h.call(l,x)}catch(l){w=[6,l],b=0}finally{m=y=0}if(5&w[0])throw w[1];return{value:w[0]?w[1]:void 0,done:!0}}([w,F])}}},ji=$(),Vi=/^\w+:\/\//,Bi=/^data:/,$i=function(){function n(l,h){this.fileSystemProvider=l,this.resolveModuleReferences=h}return n.prototype.findDefinition=function(l,h,m){var b=new bi(m),y=tn(m,l.offsetAt(h));if(!y)return null;var w=b.findSymbolFromNode(y);return w?{uri:l.uri,range:Ye(w.node,l)}:null},n.prototype.findReferences=function(l,h,m){return this.findDocumentHighlights(l,h,m).map((function(h){return{uri:l.uri,range:h.range}}))},n.prototype.findDocumentHighlights=function(l,h,m){var b=[],y=tn(m,l.offsetAt(h));if(!y||y.type===Ee.Stylesheet||y.type===Ee.Declarations)return b;y.type===Ee.Identifier&&y.parent&&y.parent.type===Ee.ClassSelector&&(y=y.parent);var w=new bi(m),x=w.findSymbolFromNode(y),F=y.getText();return m.accept((function(h){if(x){if(w.matchesSymbol(h,x))return b.push({kind:Eo(h),range:Ye(h,l)}),!1}else y&&y.type===h.type&&h.matches(F)&&b.push({kind:Eo(h),range:Ye(h,l)});return!0})),b},n.prototype.isRawStringDocumentLinkNode=function(l){return l.type===Ee.Import},n.prototype.findDocumentLinks=function(l,h,m){for(var b=[],y=0,w=this.findUnresolvedLinks(l,h);y<w.length;y++){var x=w[y].link,F=x.target;if(F&&!Bi.test(F))if(Vi.test(F))b.push(x);else{var E=m.resolveReference(F,l.uri);E&&(x.target=E),b.push(x)}}return b},n.prototype.findDocumentLinks2=function(l,h,m){return $t(this,void 0,void 0,(function(){var b,y,w,x,F,E,z,D;return qt(this,(function(R){switch(R.label){case 0:b=this.findUnresolvedLinks(l,h),y=[],w=0,x=b,R.label=1;case 1:return w<x.length?(F=x[w],E=F.link,!(z=E.target)||Bi.test(z)?[3,5]:[3,2]):[3,6];case 2:return Vi.test(z)?(y.push(E),[3,5]):[3,3];case 3:return[4,this.resolveRelativeReference(z,l.uri,m,F.isRawLink)];case 4:void 0!==(D=R.sent())&&(E.target=D,y.push(E)),R.label=5;case 5:return w++,[3,1];case 6:return[2,y]}}))}))},n.prototype.findUnresolvedLinks=function(l,h){var m=this,b=[],o=function(h){var y=h.getText(),w=Ye(h,l);if(w.start.line!==w.end.line||w.start.character!==w.end.character){(V(y,"'")||V(y,'"'))&&(y=y.slice(1,-1));var x=!!h.parent&&m.isRawStringDocumentLinkNode(h.parent);b.push({link:{target:y,range:w},isRawLink:x})}};return h.accept((function(l){if(l.type===Ee.URILiteral){var h=l.getChild(0);return h&&o(h),!1}if(l.parent&&m.isRawStringDocumentLinkNode(l.parent)){var b=l.getText();return(V(b,"'")||V(b,'"'))&&o(l),!1}return!0})),b},n.prototype.findDocumentSymbols=function(l,h){var m=[];return h.accept((function(h){var b={name:null,kind:fr.Class,location:null},y=h;if(h instanceof We)return b.name=h.getText(),(y=h.findAParent(Ee.Ruleset,Ee.ExtendsReference))&&(b.location=yn.create(l.uri,Ye(y,l)),m.push(b)),!1;if(h instanceof Jt)b.name=h.getName(),b.kind=fr.Variable;else if(h instanceof sn)b.name=h.getName(),b.kind=fr.Method;else if(h instanceof st)b.name=h.getName(),b.kind=fr.Function;else if(h instanceof dt)b.name=ji("literal.keyframes","@keyframes {0}",h.getName());else if(h instanceof lt)b.name=ji("literal.fontface","@font-face");else if(h instanceof xt){var w=h.getChild(0);w instanceof Ct&&(b.name="@media "+w.getText(),b.kind=fr.Module)}return b.name&&(b.location=yn.create(l.uri,Ye(y,l)),m.push(b)),!0})),m},n.prototype.findDocumentColors=function(l,h){var m=[];return h.accept((function(h){var b=function is(l,h){var m=ro(l);if(m){return{color:m,range:Ye(l,h)}}return null}(h,l);return b&&m.push(b),!0})),m},n.prototype.getColorPresentations=function(l,h,m,b){var y,w=[],x=Math.round(255*m.red),F=Math.round(255*m.green),E=Math.round(255*m.blue);y=1===m.alpha?"rgb(".concat(x,", ").concat(F,", ").concat(E,")"):"rgba(".concat(x,", ").concat(F,", ").concat(E,", ").concat(m.alpha,")"),w.push({label:y,textEdit:An.replace(b,y)}),y=1===m.alpha?"#".concat(Xe(x)).concat(Xe(F)).concat(Xe(E)):"#".concat(Xe(x)).concat(Xe(F)).concat(Xe(E)).concat(Xe(Math.round(255*m.alpha))),w.push({label:y,textEdit:An.replace(b,y)});var z=function no(l){var h=l.red,m=l.green,b=l.blue,y=l.alpha,w=Math.max(h,m,b),x=Math.min(h,m,b),F=0,E=0,z=(x+w)/2,D=w-x;if(D>0){switch(E=Math.min(z<=.5?D/(2*z):D/(2-2*z),1),w){case h:F=(m-b)/D+(m<b?6:0);break;case m:F=(b-h)/D+2;break;case b:F=(h-m)/D+4}F*=60,F=Math.round(F)}return{h:F,s:E,l:z,a:y}}(m);return y=1===z.a?"hsl(".concat(z.h,", ").concat(Math.round(100*z.s),"%, ").concat(Math.round(100*z.l),"%)"):"hsla(".concat(z.h,", ").concat(Math.round(100*z.s),"%, ").concat(Math.round(100*z.l),"%, ").concat(z.a,")"),w.push({label:y,textEdit:An.replace(b,y)}),w},n.prototype.doRename=function(l,h,m,b){var y,w=this.findDocumentHighlights(l,h,b).map((function(l){return An.replace(l.range,m)}));return{changes:(y={},y[l.uri]=w,y)}},n.prototype.resolveModuleReference=function(l,h,m){return $t(this,void 0,void 0,(function(){var b,y,w,x,F;return qt(this,(function(E){switch(E.label){case 0:return V(h,"file://")?(b=function os(l){return"@"===l[0]?l.substring(0,l.indexOf("/",l.indexOf("/")+1)):l.substring(0,l.indexOf("/"))}(l),y=m.resolveReference("/",h),w=Fn(h),[4,this.resolvePathToModule(b,w,y)]):[3,2];case 1:if(x=E.sent())return F=l.substring(b.length+1),[2,Vt(x,F)];E.label=2;case 2:return[2,void 0]}}))}))},n.prototype.resolveRelativeReference=function(l,h,m,b){return $t(this,void 0,void 0,(function(){var b,y;return qt(this,(function(w){switch(w.label){case 0:return b=m.resolveReference(l,h),"~"===l[0]&&"/"!==l[1]&&this.fileSystemProvider?(l=l.substring(1),[4,this.resolveModuleReference(l,h,m)]):[3,2];case 1:return[2,w.sent()||b];case 2:return this.resolveModuleReferences?(y=b)?[4,this.fileExists(b)]:[3,4]:[3,7];case 3:y=w.sent(),w.label=4;case 4:return y?[2,b]:[3,5];case 5:return[4,this.resolveModuleReference(l,h,m)];case 6:return[2,w.sent()||b];case 7:return[2,b]}}))}))},n.prototype.resolvePathToModule=function(l,h,m){return $t(this,void 0,void 0,(function(){var b;return qt(this,(function(y){switch(y.label){case 0:return b=Vt(h,"node_modules",l,"package.json"),[4,this.fileExists(b)];case 1:return y.sent()?[2,Fn(b)]:m&&h.startsWith(m)&&h.length!==m.length?[2,this.resolvePathToModule(l,Fn(h),m)]:[2,void 0]}}))}))},n.prototype.fileExists=function(l){return $t(this,void 0,void 0,(function(){var h;return qt(this,(function(m){switch(m.label){case 0:if(!this.fileSystemProvider)return[2,!1];m.label=1;case 1:return m.trys.push([1,3,,4]),[4,this.fileSystemProvider.stat(l)];case 2:return(h=m.sent()).type===Wr.Unknown&&-1===h.size?[2,!1]:[2,!0];case 3:return m.sent(),[2,!1];case 4:return[2]}}))}))},n}();function Ye(l,h){return bn.create(h.positionAt(l.offset),h.positionAt(l.end))}function Eo(l){if(l.type===Ee.Selector)return mr.Write;if(l instanceof Me&&l.parent&&l.parent instanceof Ke&&l.isCustomProperty)return mr.Write;if(l.parent)switch(l.parent.type){case Ee.FunctionDeclaration:case Ee.MixinDeclaration:case Ee.Keyframe:case Ee.VariableDeclaration:case Ee.FunctionParameter:return mr.Write}return mr.Read}function Xe(l){var h=l.toString(16);return 2!==h.length?"0"+h:h}var qi=$(),Hi=Re.Warning,Ji=Re.Error,Qi=Re.Ignore,eo=function l(h,m,b){this.id=h,this.message=m,this.defaultValue=b},io=function l(h,m,b){this.id=h,this.message=m,this.defaultValue=b},oo={AllVendorPrefixes:new eo("compatibleVendorPrefixes",qi("rule.vendorprefixes.all","When using a vendor-specific prefix make sure to also include all other vendor-specific properties"),Qi),IncludeStandardPropertyWhenUsingVendorPrefix:new eo("vendorPrefix",qi("rule.standardvendorprefix.all","When using a vendor-specific prefix also include the standard property"),Hi),DuplicateDeclarations:new eo("duplicateProperties",qi("rule.duplicateDeclarations","Do not use duplicate style definitions"),Qi),EmptyRuleSet:new eo("emptyRules",qi("rule.emptyRuleSets","Do not use empty rulesets"),Hi),ImportStatemement:new eo("importStatement",qi("rule.importDirective","Import statements do not load in parallel"),Qi),BewareOfBoxModelSize:new eo("boxModel",qi("rule.bewareOfBoxModelSize","Do not use width or height when using padding or border"),Qi),UniversalSelector:new eo("universalSelector",qi("rule.universalSelector","The universal selector (*) is known to be slow"),Qi),ZeroWithUnit:new eo("zeroUnits",qi("rule.zeroWidthUnit","No unit for zero needed"),Qi),RequiredPropertiesForFontFace:new eo("fontFaceProperties",qi("rule.fontFaceProperties","@font-face rule must define 'src' and 'font-family' properties"),Hi),HexColorLength:new eo("hexColorLength",qi("rule.hexColor","Hex colors must consist of three, four, six or eight hex numbers"),Ji),ArgsInColorFunction:new eo("argumentsInColorFunction",qi("rule.colorFunction","Invalid number of parameters"),Ji),UnknownProperty:new eo("unknownProperties",qi("rule.unknownProperty","Unknown property."),Hi),UnknownAtRules:new eo("unknownAtRules",qi("rule.unknownAtRules","Unknown at-rule."),Hi),IEStarHack:new eo("ieHack",qi("rule.ieHack","IE hacks are only necessary when supporting IE7 and older"),Qi),UnknownVendorSpecificProperty:new eo("unknownVendorSpecificProperties",qi("rule.unknownVendorSpecificProperty","Unknown vendor specific property."),Qi),PropertyIgnoredDueToDisplay:new eo("propertyIgnoredDueToDisplay",qi("rule.propertyIgnoredDueToDisplay","Property is ignored due to the display."),Hi),AvoidImportant:new eo("important",qi("rule.avoidImportant","Avoid using !important. It is an indication that the specificity of the entire CSS has gotten out of control and needs to be refactored."),Qi),AvoidFloat:new eo("float",qi("rule.avoidFloat","Avoid using 'float'. Floats lead to fragile CSS that is easy to break if one aspect of the layout changes."),Qi),AvoidIdSelector:new eo("idSelector",qi("rule.avoidIdSelector","Selectors should not contain IDs because these rules are too tightly coupled with the HTML."),Qi)},so={ValidProperties:new io("validProperties",qi("rule.validProperties","A list of properties that are not validated against the `unknownProperties` rule."),[])},ao=function(){function n(l){void 0===l&&(l={}),this.conf=l}return n.prototype.getRule=function(l){if(this.conf.hasOwnProperty(l.id)){var h=function ss(l){switch(l){case"ignore":return Re.Ignore;case"warning":return Re.Warning;case"error":return Re.Error}return null}(this.conf[l.id]);if(h)return h}return l.defaultValue},n.prototype.getSetting=function(l){return this.conf[l.id]},n}();var co=$(),ho=function(){function n(l){this.cssDataManager=l}return n.prototype.doCodeActions=function(l,h,m,b){return this.doCodeActions2(l,h,m,b).map((function(h){var m=h.edit&&h.edit.documentChanges&&h.edit.documentChanges[0];return Nn.create(h.title,"_css.applyCodeAction",l.uri,l.version,m&&m.edits)}))},n.prototype.doCodeActions2=function(l,h,m,b){var y=[];if(m.diagnostics)for(var w=0,x=m.diagnostics;w<x.length;w++){var F=x[w];this.appendFixesForMarker(l,b,F,y)}return y},n.prototype.getFixesForUnknownProperty=function(l,h,m,b){var y=h.getName(),w=[];this.cssDataManager.getProperties().forEach((function(l){var h=function ei(l,h,m){void 0===m&&(m=4);var b=Math.abs(l.length-h.length);if(b>m)return 0;var y,w,x=[],F=[];for(y=0;y<h.length+1;++y)F.push(0);for(y=0;y<l.length+1;++y)x.push(F);for(y=1;y<l.length+1;++y)for(w=1;w<h.length+1;++w)l[y-1]===h[w-1]?x[y][w]=x[y-1][w-1]+1:x[y][w]=Math.max(x[y-1][w],x[y][w-1]);return x[l.length][h.length]-Math.sqrt(b)}(y,l.name);h>=y.length/2&&w.push({property:l.name,score:h})})),w.sort((function(l,h){return h.score-l.score||l.property.localeCompare(h.property)}));for(var x=3,F=0,E=w;F<E.length;F++){var z=E[F].property,D=co("css.codeaction.rename","Rename to '{0}'",z),R=An.replace(m.range,z),T=Xn.create(l.uri,l.version),M={documentChanges:[Un.create(T,[R])]},P=xr.create(D,M,yr.QuickFix);if(P.diagnostics=[m],b.push(P),--x<=0)return}},n.prototype.appendFixesForMarker=function(l,h,m,b){if(m.code===oo.UnknownProperty.id)for(var y=l.offsetAt(m.range.start),w=l.offsetAt(m.range.end),x=it(h,y),F=x.length-1;F>=0;F--){var E=x[F];if(E instanceof Be){var z=E.getProperty();if(z&&z.offset===y&&z.end===w)return void this.getFixesForUnknownProperty(l,z,m,b)}}},n}(),uo=function l(h){this.fullPropertyName=h.getFullPropertyName().toLowerCase(),this.node=h};function Gt(l,h,m,b){var y=l[h];y.value=m,m&&(Sr(y.properties,b)||y.properties.push(b))}function te(l,h,m,b){"top"===h||"right"===h||"bottom"===h||"left"===h?Gt(l,h,m,b):function cs(l,h,m){Gt(l,"top",h,m),Gt(l,"right",h,m),Gt(l,"bottom",h,m),Gt(l,"left",h,m)}(l,m,b)}function Dr(l,h,m){switch(h.length){case 1:te(l,void 0,h[0],m);break;case 2:te(l,"top",h[0],m),te(l,"bottom",h[0],m),te(l,"right",h[1],m),te(l,"left",h[1],m);break;case 3:te(l,"top",h[0],m),te(l,"right",h[1],m),te(l,"left",h[1],m),te(l,"bottom",h[2],m);break;case 4:te(l,"top",h[0],m),te(l,"right",h[1],m),te(l,"bottom",h[2],m),te(l,"left",h[3],m)}}function zr(l,h){for(var m=0,b=h;m<b.length;m++){var y=b[m];if(l.matches(y))return!0}return!1}function Ht(l,h){return void 0===h&&(h=!0),(!h||!zr(l,["initial","unset"]))&&0!==parseFloat(l.getText())}function Io(l,h){return void 0===h&&(h=!0),l.map((function(l){return Ht(l,h)}))}function In(l,h){return void 0===h&&(h=!0),!(zr(l,["none","hidden"])||h&&zr(l,["initial","unset"]))}function ds(l,h){return void 0===h&&(h=!0),l.map((function(l){return In(l,h)}))}function ps(l){var h=l.getChildren();if(1===h.length)return Ht(y=h[0])&&In(y);for(var m=0,b=h;m<b.length;m++){var y;if(!Ht(y=b[m],!1)||!In(y,!1))return!1}return!0}var go=$(),bo=function(){function n(){this.data={}}return n.prototype.add=function(l,h,m){var b=this.data[l];b||(b={nodes:[],names:[]},this.data[l]=b),b.names.push(h),m&&b.nodes.push(m)},n}(),yo=function(){function n(l,h,m){var b=this;this.cssDataManager=m,this.warnings=[],this.settings=h,this.documentText=l.getText(),this.keyframes=new bo,this.validProperties={};var y=h.getSetting(so.ValidProperties);Array.isArray(y)&&y.forEach((function(l){if("string"==typeof l){var h=l.trim().toLowerCase();h.length&&(b.validProperties[h]=!0)}}))}return n.entries=function(l,h,m,b,y){var w=new n(h,m,b);return l.acceptVisitor(w),w.completeValidations(),w.getEntries(y)},n.prototype.isValidPropertyDeclaration=function(l){var h=l.fullPropertyName;return this.validProperties[h]},n.prototype.fetch=function(l,h){for(var m=[],b=0,y=l;b<y.length;b++){var w=y[b];w.fullPropertyName===h&&m.push(w)}return m},n.prototype.fetchWithValue=function(l,h,m){for(var b=[],y=0,w=l;y<w.length;y++){var x=w[y];if(x.fullPropertyName===h){var F=x.node.getValue();F&&this.findValueInExpression(F,m)&&b.push(x)}}return b},n.prototype.findValueInExpression=function(l,h){var m=!1;return l.accept((function(l){return l.type===Ee.Identifier&&l.matches(h)&&(m=!0),!m})),m},n.prototype.getEntries=function(l){return void 0===l&&(l=Re.Warning|Re.Error),this.warnings.filter((function(h){return!!(h.getLevel()&l)}))},n.prototype.addEntry=function(l,h,m){var b=new hn(l,h,this.settings.getRule(h),m);this.warnings.push(b)},n.prototype.getMissingNames=function(l,h){for(var m=l.slice(0),b=0;b<h.length;b++){var y=m.indexOf(h[b]);-1!==y&&(m[y]=null)}var w=null;for(b=0;b<m.length;b++){var x=m[b];x&&(w=null===w?go("namelist.single","'{0}'",x):go("namelist.concatenated","{0}, '{1}'",w,x))}return w},n.prototype.visitNode=function(l){switch(l.type){case Ee.UnknownAtRule:return this.visitUnknownAtRule(l);case Ee.Keyframe:return this.visitKeyframe(l);case Ee.FontFace:return this.visitFontFace(l);case Ee.Ruleset:return this.visitRuleSet(l);case Ee.SimpleSelector:return this.visitSimpleSelector(l);case Ee.Function:return this.visitFunction(l);case Ee.NumericValue:return this.visitNumericValue(l);case Ee.Import:return this.visitImport(l);case Ee.HexColorValue:return this.visitHexColorValue(l);case Ee.Prio:return this.visitPrio(l);case Ee.IdentifierSelector:return this.visitIdentifierSelector(l)}return!0},n.prototype.completeValidations=function(){this.validateKeyframes()},n.prototype.visitUnknownAtRule=function(l){var h=l.getChild(0);return!!h&&(!this.cssDataManager.getAtDirective(h.getText())&&(this.addEntry(h,oo.UnknownAtRules,"Unknown at rule ".concat(h.getText())),!0))},n.prototype.visitKeyframe=function(l){var h=l.getKeyword();if(!h)return!1;var m=h.getText();return this.keyframes.add(l.getName(),m,"@keyframes"!==m?h:null),!0},n.prototype.validateKeyframes=function(){var l=["@-webkit-keyframes","@-moz-keyframes","@-o-keyframes"];for(var h in this.keyframes.data){var m=this.keyframes.data[h].names,b=-1===m.indexOf("@keyframes");if(b||1!==m.length){var y=this.getMissingNames(l,m);if(y||b)for(var w=0,x=this.keyframes.data[h].nodes;w<x.length;w++){var F=x[w];if(b){var E=go("keyframes.standardrule.missing","Always define standard rule '@keyframes' when defining keyframes.");this.addEntry(F,oo.IncludeStandardPropertyWhenUsingVendorPrefix,E)}if(y){E=go("keyframes.vendorspecific.missing","Always include all vendor specific rules: Missing: {0}",y);this.addEntry(F,oo.AllVendorPrefixes,E)}}}}return!0},n.prototype.visitSimpleSelector=function(l){var h=this.documentText.charAt(l.offset);return 1===l.length&&"*"===h&&this.addEntry(l,oo.UniversalSelector),!0},n.prototype.visitIdentifierSelector=function(l){return this.addEntry(l,oo.AvoidIdSelector),!0},n.prototype.visitImport=function(l){return this.addEntry(l,oo.ImportStatemement),!0},n.prototype.visitRuleSet=function(l){var h=l.getDeclarations();if(!h)return!1;h.hasChildren()||this.addEntry(l.getSelectors(),oo.EmptyRuleSet);for(var m=[],b=0,y=h.getChildren();b<y.length;b++){(A=y[b])instanceof Be&&m.push(new uo(A))}var w=function Rr(l){for(var h={top:{value:!1,properties:[]},right:{value:!1,properties:[]},bottom:{value:!1,properties:[]},left:{value:!1,properties:[]}},m=0,b=l;m<b.length;m++){var y=b[m],w=y.node.value;if(!(typeof w>"u"))switch(y.fullPropertyName){case"box-sizing":return{top:{value:!1,properties:[]},right:{value:!1,properties:[]},bottom:{value:!1,properties:[]},left:{value:!1,properties:[]}};case"width":h.width=y;break;case"height":h.height=y;break;default:var x=y.fullPropertyName.split("-");switch(x[0]){case"border":switch(x[1]){case void 0:case"top":case"right":case"bottom":case"left":switch(x[2]){case void 0:te(h,x[1],ps(w),y);break;case"width":te(h,x[1],Ht(w,!1),y);break;case"style":te(h,x[1],In(w,!0),y)}break;case"width":Dr(h,Io(w.getChildren(),!1),y);break;case"style":Dr(h,ds(w.getChildren(),!0),y)}break;case"padding":1===x.length?Dr(h,Io(w.getChildren(),!0),y):te(h,x[1],Ht(w,!0),y)}}}return h}(m);if(w.width){var x=[];if(w.right.value&&(x=Lt(x,w.right.properties)),w.left.value&&(x=Lt(x,w.left.properties)),0!==x.length){for(var F=0,E=x;F<E.length;F++){var z=E[F];this.addEntry(z.node,oo.BewareOfBoxModelSize)}this.addEntry(w.width.node,oo.BewareOfBoxModelSize)}}if(w.height){x=[];if(w.top.value&&(x=Lt(x,w.top.properties)),w.bottom.value&&(x=Lt(x,w.bottom.properties)),0!==x.length){for(var D=0,R=x;D<R.length;D++){z=R[D];this.addEntry(z.node,oo.BewareOfBoxModelSize)}this.addEntry(w.height.node,oo.BewareOfBoxModelSize)}}var T=this.fetchWithValue(m,"display","inline-block");if(T.length>0)for(var M=this.fetch(m,"float"),P=0;P<M.length;P++){var _=M[P].node;(W=_.getValue())&&!W.matches("none")&&this.addEntry(_,oo.PropertyIgnoredDueToDisplay,go("rule.propertyIgnoredDueToDisplayInlineBlock","inline-block is ignored due to the float. If 'float' has a value other than 'none', the box is floated and 'display' is treated as 'block'"))}if((T=this.fetchWithValue(m,"display","block")).length>0)for(M=this.fetch(m,"vertical-align"),P=0;P<M.length;P++)this.addEntry(M[P].node,oo.PropertyIgnoredDueToDisplay,go("rule.propertyIgnoredDueToDisplayBlock","Property is ignored due to the display. With 'display: block', vertical-align should not be used."));var N=this.fetch(m,"float");for(P=0;P<N.length;P++){var A=N[P];this.isValidPropertyDeclaration(A)||this.addEntry(A.node,oo.AvoidFloat)}for(var O=0;O<m.length;O++){var W;if("background"!==(A=m[O]).fullPropertyName&&!this.validProperties[A.fullPropertyName])if((W=A.node.getValue())&&"-"!==this.documentText.charAt(W.offset)){var L=this.fetch(m,A.fullPropertyName);if(L.length>1)for(var U=0;U<L.length;U++){var j=L[U].node.getValue();j&&"-"!==this.documentText.charAt(j.offset)&&L[U]!==A&&this.addEntry(A.node,oo.DuplicateDeclarations)}}}if(!l.getSelectors().matches(":export")){for(var B=new bo,q=!1,G=0,H=m;G<H.length;G++){var J=(A=H[G]).node;if(this.isCSSDeclaration(J)){var X=A.fullPropertyName,Y=X.charAt(0);if("-"===Y){if("-"!==X.charAt(1)){!this.cssDataManager.isKnownProperty(X)&&!this.validProperties[X]&&this.addEntry(J.getProperty(),oo.UnknownVendorSpecificProperty);var Z=J.getNonPrefixedPropertyName();B.add(Z,X,J.getProperty())}}else{var Q=X;("*"===Y||"_"===Y)&&(this.addEntry(J.getProperty(),oo.IEStarHack),X=X.substr(1)),!this.cssDataManager.isKnownProperty(Q)&&!this.cssDataManager.isKnownProperty(X)&&(this.validProperties[X]||this.addEntry(J.getProperty(),oo.UnknownProperty,go("property.unknownproperty.detailed","Unknown property: '{0}'",J.getFullPropertyName()))),B.add(X,X,null)}}else q=!0}if(!q)for(var ee in B.data){var ne=B.data[ee],re=ne.names,ie=this.cssDataManager.isStandardProperty(ee)&&-1===re.indexOf(ee);if(ie||1!==re.length){for(var oe=[],ae=(O=0,n.prefixes.length);O<ae;O++){var le=n.prefixes[O];this.cssDataManager.isStandardProperty(le+ee)&&oe.push(le+ee)}var ce=this.getMissingNames(oe,re);if(ce||ie)for(var pe=0,me=ne.nodes;pe<me.length;pe++){var ue=me[pe];if(ie){var fe=go("property.standard.missing","Also define the standard property '{0}' for compatibility",ee);this.addEntry(ue,oo.IncludeStandardPropertyWhenUsingVendorPrefix,fe)}if(ce){fe=go("property.vendorspecific.missing","Always include all vendor specific properties: Missing: {0}",ce);this.addEntry(ue,oo.AllVendorPrefixes,fe)}}}}}return!0},n.prototype.visitPrio=function(l){return this.addEntry(l,oo.AvoidImportant),!0},n.prototype.visitNumericValue=function(l){var h=l.findParent(Ee.Function);if(h&&"calc"===h.getName())return!0;var m=l.findParent(Ee.Declaration);if(m&&m.getValue()){var b=l.getValue();if(!b.unit||-1===si.length.indexOf(b.unit.toLowerCase()))return!0;0===parseFloat(b.value)&&b.unit&&!this.validProperties[m.getFullPropertyName()]&&this.addEntry(l,oo.ZeroWithUnit)}return!0},n.prototype.visitFontFace=function(l){var h=l.getDeclarations();if(!h)return!1;for(var m=!1,b=!1,y=!1,w=0,x=h.getChildren();w<x.length;w++){var F=x[w];if(this.isCSSDeclaration(F)){var E=F.getProperty().getName().toLowerCase();"src"===E&&(m=!0),"font-family"===E&&(b=!0)}else y=!0}return!y&&(!m||!b)&&this.addEntry(l,oo.RequiredPropertiesForFontFace),!0},n.prototype.isCSSDeclaration=function(l){if(l instanceof Be){if(!l.getValue())return!1;var h=l.getProperty();if(!h)return!1;var m=h.getIdentifier();return!(!m||m.containsInterpolation())}return!1},n.prototype.visitHexColorValue=function(l){var h=l.length;return 9!==h&&7!==h&&5!==h&&4!==h&&this.addEntry(l,oo.HexColorLength),!1},n.prototype.visitFunction=function(l){var h=l.getName().toLowerCase(),m=-1,b=0;switch(h){case"rgb(":case"hsl(":m=3;break;case"rgba(":case"hsla(":m=4}return-1!==m&&(l.getArguments().accept((function(l){return!(l instanceof Mt)||(b+=1,!1)})),b!==m&&this.addEntry(l,oo.ArgsInColorFunction)),!0},n.prefixes=["-ms-","-moz-","-o-","-webkit-"],n}(),wo=function(){function n(l){this.cssDataManager=l}return n.prototype.configure=function(l){this.settings=l},n.prototype.doValidation=function(l,h,m){if(void 0===m&&(m=this.settings),m&&!1===m.validate)return[];var b=[];b.push.apply(b,mn.entries(h)),b.push.apply(b,yo.entries(h,l,new ao(m&&m.lint),this.cssDataManager));var y=[];for(var w in oo)y.push(oo[w].id);return b.filter((function(l){return l.getLevel()!==Re.Ignore})).map((function s(h){var m=bn.create(l.positionAt(h.getOffset()),l.positionAt(h.getOffset()+h.getLength())),b=l.languageId;return{code:h.getRule().id,source:b,message:h.getMessage(),severity:h.getLevel()===Re.Warning?Tn.Warning:Tn.Error,range:m}}))},n}(),So=function(){var n=function(l,h){return(n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(l,h){l.__proto__=h}||function(l,h){for(var m in h)Object.prototype.hasOwnProperty.call(h,m)&&(l[m]=h[m])})(l,h)};return function(l,h){if("function"!=typeof h&&null!==h)throw new TypeError("Class extends value "+String(h)+" is not a constructor or null");function r(){this.constructor=l}n(l,h),l.prototype=null===h?Object.create(h):(r.prototype=h.prototype,new r)}}(),ko="/".charCodeAt(0),Co="\n".charCodeAt(0),Fo="\r".charCodeAt(0),zo="\f".charCodeAt(0),Do="$".charCodeAt(0),Ro="#".charCodeAt(0),To="{".charCodeAt(0),Mo="=".charCodeAt(0),Po="!".charCodeAt(0),No="<".charCodeAt(0),Ao=">".charCodeAt(0),Oo=".".charCodeAt(0),Wo=("@".charCodeAt(0),h.CustomToken),Lo=Wo++,Uo=Wo++,$o=(Wo++,Wo++),Jo=Wo++,Xo=Wo++,Yo=Wo++,Zo=Wo++,Qo=(Wo++,function(l){function e(){return null!==l&&l.apply(this,arguments)||this}return So(e,l),e.prototype.scanNext=function(m){if(this.stream.advanceIfChar(Do)){var b=["$"];if(this.ident(b))return this.finishToken(m,Lo,b.join(""));this.stream.goBackTo(m)}return this.stream.advanceIfChars([Ro,To])?this.finishToken(m,Uo):this.stream.advanceIfChars([Mo,Mo])?this.finishToken(m,$o):this.stream.advanceIfChars([Po,Mo])?this.finishToken(m,Jo):this.stream.advanceIfChar(No)?this.stream.advanceIfChar(Mo)?this.finishToken(m,Yo):this.finishToken(m,h.Delim):this.stream.advanceIfChar(Ao)?this.stream.advanceIfChar(Mo)?this.finishToken(m,Xo):this.finishToken(m,h.Delim):this.stream.advanceIfChars([Oo,Oo,Oo])?this.finishToken(m,Zo):l.prototype.scanNext.call(this,m)},e.prototype.comment=function(){return!!l.prototype.comment.call(this)||!(this.inURL||!this.stream.advanceIfChars([ko,ko]))&&(this.stream.advanceWhileChar((function(l){switch(l){case Co:case Fo:case zo:return!1;default:return!0}})),!0)},e}(Fe)),es=$(),ts=function l(h,m){this.id=h,this.message=m},as={FromExpected:new ts("scss-fromexpected",es("expected.from","'from' expected")),ThroughOrToExpected:new ts("scss-throughexpected",es("expected.through","'through' or 'to' expected")),InExpected:new ts("scss-fromexpected",es("expected.in","'in' expected"))},ls=function(){var n=function(l,h){return(n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(l,h){l.__proto__=h}||function(l,h){for(var m in h)Object.prototype.hasOwnProperty.call(h,m)&&(l[m]=h[m])})(l,h)};return function(l,h){if("function"!=typeof h&&null!==h)throw new TypeError("Class extends value "+String(h)+" is not a constructor or null");function r(){this.constructor=l}n(l,h),l.prototype=null===h?Object.create(h):(r.prototype=h.prototype,new r)}}(),hs=function(l){function e(){return l.call(this,new Qo)||this}return ls(e,l),e.prototype._parseStylesheetStatement=function(m){return void 0===m&&(m=!1),this.peek(h.AtKeyword)?this._parseWarnAndDebug()||this._parseControlStatement()||this._parseMixinDeclaration()||this._parseMixinContent()||this._parseMixinReference()||this._parseFunctionDeclaration()||this._parseForward()||this._parseUse()||this._parseRuleset(m)||l.prototype._parseStylesheetAtStatement.call(this,m):this._parseRuleset(!0)||this._parseVariableDeclaration()},e.prototype._parseImport=function(){if(!this.peekKeyword("@import"))return null;var l=this.create(ht);if(this.consumeToken(),!l.addChild(this._parseURILiteral())&&!l.addChild(this._parseStringLiteral()))return this.finish(l,Hn.URIOrStringExpected);for(;this.accept(h.Comma);)if(!l.addChild(this._parseURILiteral())&&!l.addChild(this._parseStringLiteral()))return this.finish(l,Hn.URIOrStringExpected);return!this.peek(h.SemiColon)&&!this.peek(h.EOF)&&l.setMedialist(this._parseMediaQueryList()),this.finish(l)},e.prototype._parseVariableDeclaration=function(l){if(void 0===l&&(l=[]),!this.peek(Lo))return null;var m=this.create(Jt);if(!m.setVariable(this._parseVariable()))return null;if(!this.accept(h.Colon))return this.finish(m,Hn.ColonExpected);if(this.prevToken&&(m.colonPosition=this.prevToken.offset),!m.setValue(this._parseExpr()))return this.finish(m,Hn.VariableValueExpected,[],l);for(;this.peek(h.Exclamation);)if(!m.addChild(this._tryParsePrio())){if(this.consumeToken(),!this.peekRegExp(h.Ident,/^(default|global)$/))return this.finish(m,Hn.UnknownKeyword);this.consumeToken()}return this.peek(h.SemiColon)&&(m.semicolonPosition=this.token.offset),this.finish(m)},e.prototype._parseMediaCondition=function(){return this._parseInterpolation()||l.prototype._parseMediaCondition.call(this)},e.prototype._parseMediaFeatureName=function(){return this._parseModuleMember()||this._parseFunction()||this._parseIdent()||this._parseVariable()},e.prototype._parseKeyframeSelector=function(){return this._tryParseKeyframeSelector()||this._parseControlStatement(this._parseKeyframeSelector.bind(this))||this._parseVariableDeclaration()||this._parseMixinContent()},e.prototype._parseVariable=function(){if(!this.peek(Lo))return null;var l=this.create(Zt);return this.consumeToken(),l},e.prototype._parseModuleMember=function(){var l=this.mark(),h=this.create(pn);return h.setIdentifier(this._parseIdent([ze.Module]))?this.hasWhitespace()||!this.acceptDelim(".")||this.hasWhitespace()?(this.restoreAtMark(l),null):h.addChild(this._parseVariable()||this._parseFunction())?h:this.finish(h,Hn.IdentifierOrVariableExpected):null},e.prototype._parseIdent=function(l){var m=this;if(!this.peek(h.Ident)&&!this.peek(Uo)&&!this.peekDelim("-"))return null;var b,y=this.create(Me);y.referenceTypes=l,y.isCustomProperty=this.peekRegExp(h.Ident,/^--/);for(var w=!1;(this.accept(h.Ident)||y.addChild((b=void 0,b=m.mark(),m.acceptDelim("-")&&(m.hasWhitespace()||m.acceptDelim("-"),m.hasWhitespace())?(m.restoreAtMark(b),null):m._parseInterpolation()))||w&&this.acceptRegexp(/^[\w-]/))&&(w=!0,!this.hasWhitespace()););return w?this.finish(y):null},e.prototype._parseTermExpression=function(){return this._parseModuleMember()||this._parseVariable()||this._parseSelectorCombinator()||l.prototype._parseTermExpression.call(this)},e.prototype._parseInterpolation=function(){if(this.peek(Uo)){var l=this.create(Xt);return this.consumeToken(),l.addChild(this._parseExpr())||this._parseSelectorCombinator()?this.accept(h.CurlyR)?this.finish(l):this.finish(l,Hn.RightCurlyExpected):this.accept(h.CurlyR)?this.finish(l):this.finish(l,Hn.ExpressionExpected)}return null},e.prototype._parseOperator=function(){if(this.peek($o)||this.peek(Jo)||this.peek(Xo)||this.peek(Yo)||this.peekDelim(">")||this.peekDelim("<")||this.peekIdent("and")||this.peekIdent("or")||this.peekDelim("%")){var h=this.createNode(Ee.Operator);return this.consumeToken(),this.finish(h)}return l.prototype._parseOperator.call(this)},e.prototype._parseUnaryOperator=function(){if(this.peekIdent("not")){var h=this.create(Te);return this.consumeToken(),this.finish(h)}return l.prototype._parseUnaryOperator.call(this)},e.prototype._parseRuleSetDeclaration=function(){return this.peek(h.AtKeyword)?this._parseKeyframe()||this._parseImport()||this._parseMedia(!0)||this._parseFontFace()||this._parseWarnAndDebug()||this._parseControlStatement()||this._parseFunctionDeclaration()||this._parseExtends()||this._parseMixinReference()||this._parseMixinContent()||this._parseMixinDeclaration()||this._parseRuleset(!0)||this._parseSupports(!0)||l.prototype._parseRuleSetDeclarationAtStatement.call(this):this._parseVariableDeclaration()||this._tryParseRuleset(!0)||l.prototype._parseRuleSetDeclaration.call(this)},e.prototype._parseDeclaration=function(l){var m=this._tryParseCustomPropertyDeclaration(l);if(m)return m;var b=this.create(Be);if(!b.setProperty(this._parseProperty()))return null;if(!this.accept(h.Colon))return this.finish(b,Hn.ColonExpected,[h.Colon],l||[h.SemiColon]);this.prevToken&&(b.colonPosition=this.prevToken.offset);var y=!1;if(b.setValue(this._parseExpr())&&(y=!0,b.addChild(this._parsePrio())),this.peek(h.CurlyL))b.setNestedProperties(this._parseNestedProperties());else if(!y)return this.finish(b,Hn.PropertyValueExpected);return this.peek(h.SemiColon)&&(b.semicolonPosition=this.token.offset),this.finish(b)},e.prototype._parseNestedProperties=function(){var l=this.create(ct);return this._parseBody(l,this._parseDeclaration.bind(this))},e.prototype._parseExtends=function(){if(this.peekKeyword("@extend")){var l=this.create(Qt);if(this.consumeToken(),!l.getSelectors().addChild(this._parseSimpleSelector()))return this.finish(l,Hn.SelectorExpected);for(;this.accept(h.Comma);)l.getSelectors().addChild(this._parseSimpleSelector());return this.accept(h.Exclamation)&&!this.acceptIdent("optional")?this.finish(l,Hn.UnknownKeyword):this.finish(l)}return null},e.prototype._parseSimpleSelectorBody=function(){return this._parseSelectorCombinator()||this._parseSelectorPlaceholder()||l.prototype._parseSimpleSelectorBody.call(this)},e.prototype._parseSelectorCombinator=function(){if(this.peekDelim("&")){var l=this.createNode(Ee.SelectorCombinator);for(this.consumeToken();!this.hasWhitespace()&&(this.acceptDelim("-")||this.accept(h.Num)||this.accept(h.Dimension)||l.addChild(this._parseIdent())||this.acceptDelim("&")););return this.finish(l)}return null},e.prototype._parseSelectorPlaceholder=function(){if(this.peekDelim("%")){var l=this.createNode(Ee.SelectorPlaceholder);return this.consumeToken(),this._parseIdent(),this.finish(l)}if(this.peekKeyword("@at-root")){l=this.createNode(Ee.SelectorPlaceholder);return this.consumeToken(),this.finish(l)}return null},e.prototype._parseElementName=function(){var m=this.mark(),b=l.prototype._parseElementName.call(this);return b&&!this.hasWhitespace()&&this.peek(h.ParenthesisL)?(this.restoreAtMark(m),null):b},e.prototype._tryParsePseudoIdentifier=function(){return this._parseInterpolation()||l.prototype._tryParsePseudoIdentifier.call(this)},e.prototype._parseWarnAndDebug=function(){if(!this.peekKeyword("@debug")&&!this.peekKeyword("@warn")&&!this.peekKeyword("@error"))return null;var l=this.createNode(Ee.Debug);return this.consumeToken(),l.addChild(this._parseExpr()),this.finish(l)},e.prototype._parseControlStatement=function(l){return void 0===l&&(l=this._parseRuleSetDeclaration.bind(this)),this.peek(h.AtKeyword)?this._parseIfStatement(l)||this._parseForStatement(l)||this._parseEachStatement(l)||this._parseWhileStatement(l):null},e.prototype._parseIfStatement=function(l){return this.peekKeyword("@if")?this._internalParseIfStatement(l):null},e.prototype._internalParseIfStatement=function(l){var m=this.create(Ze);if(this.consumeToken(),!m.setExpression(this._parseExpr(!0)))return this.finish(m,Hn.ExpressionExpected);if(this._parseBody(m,l),this.acceptKeyword("@else"))if(this.peekIdent("if"))m.setElseClause(this._internalParseIfStatement(l));else if(this.peek(h.CurlyL)){var b=this.create(ot);this._parseBody(b,l),m.setElseClause(b)}return this.finish(m)},e.prototype._parseForStatement=function(l){if(!this.peekKeyword("@for"))return null;var m=this.create(tt);return this.consumeToken(),m.setVariable(this._parseVariable())?this.acceptIdent("from")?m.addChild(this._parseBinaryExpr())?this.acceptIdent("to")||this.acceptIdent("through")?m.addChild(this._parseBinaryExpr())?this._parseBody(m,l):this.finish(m,Hn.ExpressionExpected,[h.CurlyR]):this.finish(m,as.ThroughOrToExpected,[h.CurlyR]):this.finish(m,Hn.ExpressionExpected,[h.CurlyR]):this.finish(m,as.FromExpected,[h.CurlyR]):this.finish(m,Hn.VariableNameExpected,[h.CurlyR])},e.prototype._parseEachStatement=function(l){if(!this.peekKeyword("@each"))return null;var m=this.create(nt);this.consumeToken();var b=m.getVariables();if(!b.addChild(this._parseVariable()))return this.finish(m,Hn.VariableNameExpected,[h.CurlyR]);for(;this.accept(h.Comma);)if(!b.addChild(this._parseVariable()))return this.finish(m,Hn.VariableNameExpected,[h.CurlyR]);return this.finish(b),this.acceptIdent("in")?m.addChild(this._parseExpr())?this._parseBody(m,l):this.finish(m,Hn.ExpressionExpected,[h.CurlyR]):this.finish(m,as.InExpected,[h.CurlyR])},e.prototype._parseWhileStatement=function(l){if(!this.peekKeyword("@while"))return null;var m=this.create(rt);return this.consumeToken(),m.addChild(this._parseBinaryExpr())?this._parseBody(m,l):this.finish(m,Hn.ExpressionExpected,[h.CurlyR])},e.prototype._parseFunctionBodyDeclaration=function(){return this._parseVariableDeclaration()||this._parseReturnStatement()||this._parseWarnAndDebug()||this._parseControlStatement(this._parseFunctionBodyDeclaration.bind(this))},e.prototype._parseFunctionDeclaration=function(){if(!this.peekKeyword("@function"))return null;var l=this.create(st);if(this.consumeToken(),!l.setIdentifier(this._parseIdent([ze.Function])))return this.finish(l,Hn.IdentifierExpected,[h.CurlyR]);if(!this.accept(h.ParenthesisL))return this.finish(l,Hn.LeftParenthesisExpected,[h.CurlyR]);if(l.getParameters().addChild(this._parseParameterDeclaration()))for(;this.accept(h.Comma)&&!this.peek(h.ParenthesisR);)if(!l.getParameters().addChild(this._parseParameterDeclaration()))return this.finish(l,Hn.VariableNameExpected);return this.accept(h.ParenthesisR)?this._parseBody(l,this._parseFunctionBodyDeclaration.bind(this)):this.finish(l,Hn.RightParenthesisExpected,[h.CurlyR])},e.prototype._parseReturnStatement=function(){if(!this.peekKeyword("@return"))return null;var l=this.createNode(Ee.ReturnStatement);return this.consumeToken(),l.addChild(this._parseExpr())?this.finish(l):this.finish(l,Hn.ExpressionExpected)},e.prototype._parseMixinDeclaration=function(){if(!this.peekKeyword("@mixin"))return null;var l=this.create(sn);if(this.consumeToken(),!l.setIdentifier(this._parseIdent([ze.Mixin])))return this.finish(l,Hn.IdentifierExpected,[h.CurlyR]);if(this.accept(h.ParenthesisL)){if(l.getParameters().addChild(this._parseParameterDeclaration()))for(;this.accept(h.Comma)&&!this.peek(h.ParenthesisR);)if(!l.getParameters().addChild(this._parseParameterDeclaration()))return this.finish(l,Hn.VariableNameExpected);if(!this.accept(h.ParenthesisR))return this.finish(l,Hn.RightParenthesisExpected,[h.CurlyR])}return this._parseBody(l,this._parseRuleSetDeclaration.bind(this))},e.prototype._parseParameterDeclaration=function(){var l=this.create(He);return l.setIdentifier(this._parseVariable())?(this.accept(Zo),this.accept(h.Colon)&&!l.setDefaultValue(this._parseExpr(!0))?this.finish(l,Hn.VariableValueExpected,[],[h.Comma,h.ParenthesisR]):this.finish(l)):null},e.prototype._parseMixinContent=function(){if(!this.peekKeyword("@content"))return null;var l=this.create(nn);if(this.consumeToken(),this.accept(h.ParenthesisL)){if(l.getArguments().addChild(this._parseFunctionArgument()))for(;this.accept(h.Comma)&&!this.peek(h.ParenthesisR);)if(!l.getArguments().addChild(this._parseFunctionArgument()))return this.finish(l,Hn.ExpressionExpected);if(!this.accept(h.ParenthesisR))return this.finish(l,Hn.RightParenthesisExpected)}return this.finish(l)},e.prototype._parseMixinReference=function(){if(!this.peekKeyword("@include"))return null;var l=this.create(on);this.consumeToken();var m=this._parseIdent([ze.Mixin]);if(!l.setIdentifier(m))return this.finish(l,Hn.IdentifierExpected,[h.CurlyR]);if(!this.hasWhitespace()&&this.acceptDelim(".")&&!this.hasWhitespace()){var b=this._parseIdent([ze.Mixin]);if(!b)return this.finish(l,Hn.IdentifierExpected,[h.CurlyR]);var y=this.create(pn);m.referenceTypes=[ze.Module],y.setIdentifier(m),l.setIdentifier(b),l.addChild(y)}if(this.accept(h.ParenthesisL)){if(l.getArguments().addChild(this._parseFunctionArgument()))for(;this.accept(h.Comma)&&!this.peek(h.ParenthesisR);)if(!l.getArguments().addChild(this._parseFunctionArgument()))return this.finish(l,Hn.ExpressionExpected);if(!this.accept(h.ParenthesisR))return this.finish(l,Hn.RightParenthesisExpected)}return(this.peekIdent("using")||this.peek(h.CurlyL))&&l.setContent(this._parseMixinContentDeclaration()),this.finish(l)},e.prototype._parseMixinContentDeclaration=function(){var l=this.create(rn);if(this.acceptIdent("using")){if(!this.accept(h.ParenthesisL))return this.finish(l,Hn.LeftParenthesisExpected,[h.CurlyL]);if(l.getParameters().addChild(this._parseParameterDeclaration()))for(;this.accept(h.Comma)&&!this.peek(h.ParenthesisR);)if(!l.getParameters().addChild(this._parseParameterDeclaration()))return this.finish(l,Hn.VariableNameExpected);if(!this.accept(h.ParenthesisR))return this.finish(l,Hn.RightParenthesisExpected,[h.CurlyL])}return this.peek(h.CurlyL)&&this._parseBody(l,this._parseMixinReferenceBodyStatement.bind(this)),this.finish(l)},e.prototype._parseMixinReferenceBodyStatement=function(){return this._tryParseKeyframeSelector()||this._parseRuleSetDeclaration()},e.prototype._parseFunctionArgument=function(){var l=this.create(Je),m=this.mark(),b=this._parseVariable();if(b)if(this.accept(h.Colon))l.setIdentifier(b);else{if(this.accept(Zo))return l.setValue(b),this.finish(l);this.restoreAtMark(m)}return l.setValue(this._parseExpr(!0))?(this.accept(Zo),l.addChild(this._parsePrio()),this.finish(l)):l.setValue(this._tryParsePrio())?this.finish(l):null},e.prototype._parseURLArgument=function(){var m=this.mark(),b=l.prototype._parseURLArgument.call(this);if(!b||!this.peek(h.ParenthesisR)){this.restoreAtMark(m);var y=this.create(Te);return y.addChild(this._parseBinaryExpr()),this.finish(y)}return b},e.prototype._parseOperation=function(){if(!this.peek(h.ParenthesisL))return null;var l=this.create(Te);for(this.consumeToken();l.addChild(this._parseListElement());)this.accept(h.Comma);return this.accept(h.ParenthesisR)?this.finish(l):this.finish(l,Hn.RightParenthesisExpected)},e.prototype._parseListElement=function(){var l=this.create(ln),m=this._parseBinaryExpr();if(!m)return null;if(this.accept(h.Colon)){if(l.setKey(m),!l.setValue(this._parseBinaryExpr()))return this.finish(l,Hn.ExpressionExpected)}else l.setValue(m);return this.finish(l)},e.prototype._parseUse=function(){if(!this.peekKeyword("@use"))return null;var l=this.create(mt);if(this.consumeToken(),!l.addChild(this._parseStringLiteral()))return this.finish(l,Hn.StringLiteralExpected);if(!this.peek(h.SemiColon)&&!this.peek(h.EOF)){if(!this.peekRegExp(h.Ident,/as|with/))return this.finish(l,Hn.UnknownKeyword);if(this.acceptIdent("as")&&!l.setIdentifier(this._parseIdent([ze.Module]))&&!this.acceptDelim("*"))return this.finish(l,Hn.IdentifierOrWildcardExpected);if(this.acceptIdent("with")){if(!this.accept(h.ParenthesisL))return this.finish(l,Hn.LeftParenthesisExpected,[h.ParenthesisR]);if(!l.getParameters().addChild(this._parseModuleConfigDeclaration()))return this.finish(l,Hn.VariableNameExpected);for(;this.accept(h.Comma)&&!this.peek(h.ParenthesisR);)if(!l.getParameters().addChild(this._parseModuleConfigDeclaration()))return this.finish(l,Hn.VariableNameExpected);if(!this.accept(h.ParenthesisR))return this.finish(l,Hn.RightParenthesisExpected)}}return this.accept(h.SemiColon)||this.accept(h.EOF)?this.finish(l):this.finish(l,Hn.SemiColonExpected)},e.prototype._parseModuleConfigDeclaration=function(){var l=this.create(gt);return l.setIdentifier(this._parseVariable())?this.accept(h.Colon)&&l.setValue(this._parseExpr(!0))?!this.accept(h.Exclamation)||!this.hasWhitespace()&&this.acceptIdent("default")?this.finish(l):this.finish(l,Hn.UnknownKeyword):this.finish(l,Hn.VariableValueExpected,[],[h.Comma,h.ParenthesisR]):null},e.prototype._parseForward=function(){if(!this.peekKeyword("@forward"))return null;var l=this.create(bt);if(this.consumeToken(),!l.addChild(this._parseStringLiteral()))return this.finish(l,Hn.StringLiteralExpected);if(this.acceptIdent("with")){if(!this.accept(h.ParenthesisL))return this.finish(l,Hn.LeftParenthesisExpected,[h.ParenthesisR]);if(!l.getParameters().addChild(this._parseModuleConfigDeclaration()))return this.finish(l,Hn.VariableNameExpected);for(;this.accept(h.Comma)&&!this.peek(h.ParenthesisR);)if(!l.getParameters().addChild(this._parseModuleConfigDeclaration()))return this.finish(l,Hn.VariableNameExpected);if(!this.accept(h.ParenthesisR))return this.finish(l,Hn.RightParenthesisExpected)}if(!this.peek(h.SemiColon)&&!this.peek(h.EOF)){if(!this.peekRegExp(h.Ident,/as|hide|show/))return this.finish(l,Hn.UnknownKeyword);if(this.acceptIdent("as")){var m=this._parseIdent([ze.Forward]);if(!l.setIdentifier(m))return this.finish(l,Hn.IdentifierExpected);if(this.hasWhitespace()||!this.acceptDelim("*"))return this.finish(l,Hn.WildcardExpected)}if((this.peekIdent("hide")||this.peekIdent("show"))&&!l.addChild(this._parseForwardVisibility()))return this.finish(l,Hn.IdentifierOrVariableExpected)}return this.accept(h.SemiColon)||this.accept(h.EOF)?this.finish(l):this.finish(l,Hn.SemiColonExpected)},e.prototype._parseForwardVisibility=function(){var l=this.create(vt);for(l.setIdentifier(this._parseIdent());l.addChild(this._parseVariable()||this._parseIdent());)this.accept(h.Comma);return l.getChildren().length>1?l:null},e.prototype._parseSupportsCondition=function(){return this._parseInterpolation()||l.prototype._parseSupportsCondition.call(this)},e}(di),ms=function(){var n=function(l,h){return(n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(l,h){l.__proto__=h}||function(l,h){for(var m in h)Object.prototype.hasOwnProperty.call(h,m)&&(l[m]=h[m])})(l,h)};return function(l,h){if("function"!=typeof h&&null!==h)throw new TypeError("Class extends value "+String(h)+" is not a constructor or null");function r(){this.constructor=l}n(l,h),l.prototype=null===h?Object.create(h):(r.prototype=h.prototype,new r)}}(),us=$(),fs=function(l){function e(h,m){var b=l.call(this,"$",h,m)||this;return _o(e.scssModuleLoaders),_o(e.scssModuleBuiltIns),b}return ms(e,l),e.prototype.isImportPathParent=function(h){return h===Ee.Forward||h===Ee.Use||l.prototype.isImportPathParent.call(this,h)},e.prototype.getCompletionForImportPath=function(h,m){var b=h.getParent().type;if(b===Ee.Forward||b===Ee.Use)for(var y=0,w=e.scssModuleBuiltIns;y<w.length;y++){var x=w[y],F={label:x.label,documentation:x.documentation,textEdit:An.replace(this.getCompletionRange(h),"'".concat(x.label,"'")),kind:tr.Module};m.items.push(F)}return l.prototype.getCompletionForImportPath.call(this,h,m)},e.prototype.createReplaceFunction=function(){var l=1;return function(h,m){return"\\"+m+": ${"+l+++":"+(e.variableDefaults[m]||"")+"}"}},e.prototype.createFunctionProposals=function(l,h,m,b){for(var y=0,w=l;y<w.length;y++){var x=w[y],F=x.func.replace(/\[?(\$\w+)\]?/g,this.createReplaceFunction()),E={label:x.func.substr(0,x.func.indexOf("(")),detail:x.func,documentation:x.desc,textEdit:An.replace(this.getCompletionRange(h),F),insertTextFormat:nr.Snippet,kind:tr.Function};m&&(E.sortText="z"),b.items.push(E)}return b},e.prototype.getCompletionsForSelector=function(h,m,b){return this.createFunctionProposals(e.selectorFuncs,null,!0,b),l.prototype.getCompletionsForSelector.call(this,h,m,b)},e.prototype.getTermProposals=function(h,m,b){var y=e.builtInFuncs;return h&&(y=y.filter((function(l){return!l.type||!h.restrictions||-1!==h.restrictions.indexOf(l.type)}))),this.createFunctionProposals(y,m,!0,b),l.prototype.getTermProposals.call(this,h,m,b)},e.prototype.getColorProposals=function(h,m,b){return this.createFunctionProposals(e.colorProposals,m,!1,b),l.prototype.getColorProposals.call(this,h,m,b)},e.prototype.getCompletionsForDeclarationProperty=function(h,m){return this.getCompletionForAtDirectives(m),this.getCompletionsForSelector(null,!0,m),l.prototype.getCompletionsForDeclarationProperty.call(this,h,m)},e.prototype.getCompletionsForExtendsReference=function(l,h,m){for(var b=0,y=this.getSymbolContext().findSymbolsAtOffset(this.offset,ze.Rule);b<y.length;b++){var w=y[b],x={label:w.name,textEdit:An.replace(this.getCompletionRange(h),w.name),kind:tr.Function};m.items.push(x)}return m},e.prototype.getCompletionForAtDirectives=function(l){var h;return(h=l.items).push.apply(h,e.scssAtDirectives),l},e.prototype.getCompletionForTopLevel=function(h){return this.getCompletionForAtDirectives(h),this.getCompletionForModuleLoaders(h),l.prototype.getCompletionForTopLevel.call(this,h),h},e.prototype.getCompletionForModuleLoaders=function(l){var h;return(h=l.items).push.apply(h,e.scssModuleLoaders),l},e.variableDefaults={$red:"1",$green:"2",$blue:"3",$alpha:"1.0",$color:"#000000",$weight:"0.5",$hue:"0",$saturation:"0%",$lightness:"0%",$degrees:"0",$amount:"0",$string:'""',$substring:'"s"',$number:"0",$limit:"1"},e.colorProposals=[{func:"red($color)",desc:us("scss.builtin.red","Gets the red component of a color.")},{func:"green($color)",desc:us("scss.builtin.green","Gets the green component of a color.")},{func:"blue($color)",desc:us("scss.builtin.blue","Gets the blue component of a color.")},{func:"mix($color, $color, [$weight])",desc:us("scss.builtin.mix","Mixes two colors together.")},{func:"hue($color)",desc:us("scss.builtin.hue","Gets the hue component of a color.")},{func:"saturation($color)",desc:us("scss.builtin.saturation","Gets the saturation component of a color.")},{func:"lightness($color)",desc:us("scss.builtin.lightness","Gets the lightness component of a color.")},{func:"adjust-hue($color, $degrees)",desc:us("scss.builtin.adjust-hue","Changes the hue of a color.")},{func:"lighten($color, $amount)",desc:us("scss.builtin.lighten","Makes a color lighter.")},{func:"darken($color, $amount)",desc:us("scss.builtin.darken","Makes a color darker.")},{func:"saturate($color, $amount)",desc:us("scss.builtin.saturate","Makes a color more saturated.")},{func:"desaturate($color, $amount)",desc:us("scss.builtin.desaturate","Makes a color less saturated.")},{func:"grayscale($color)",desc:us("scss.builtin.grayscale","Converts a color to grayscale.")},{func:"complement($color)",desc:us("scss.builtin.complement","Returns the complement of a color.")},{func:"invert($color)",desc:us("scss.builtin.invert","Returns the inverse of a color.")},{func:"alpha($color)",desc:us("scss.builtin.alpha","Gets the opacity component of a color.")},{func:"opacity($color)",desc:"Gets the alpha component (opacity) of a color."},{func:"rgba($color, $alpha)",desc:us("scss.builtin.rgba","Changes the alpha component for a color.")},{func:"opacify($color, $amount)",desc:us("scss.builtin.opacify","Makes a color more opaque.")},{func:"fade-in($color, $amount)",desc:us("scss.builtin.fade-in","Makes a color more opaque.")},{func:"transparentize($color, $amount)",desc:us("scss.builtin.transparentize","Makes a color more transparent.")},{func:"fade-out($color, $amount)",desc:us("scss.builtin.fade-out","Makes a color more transparent.")},{func:"adjust-color($color, [$red], [$green], [$blue], [$hue], [$saturation], [$lightness], [$alpha])",desc:us("scss.builtin.adjust-color","Increases or decreases one or more components of a color.")},{func:"scale-color($color, [$red], [$green], [$blue], [$saturation], [$lightness], [$alpha])",desc:us("scss.builtin.scale-color","Fluidly scales one or more properties of a color.")},{func:"change-color($color, [$red], [$green], [$blue], [$hue], [$saturation], [$lightness], [$alpha])",desc:us("scss.builtin.change-color","Changes one or more properties of a color.")},{func:"ie-hex-str($color)",desc:us("scss.builtin.ie-hex-str","Converts a color into the format understood by IE filters.")}],e.selectorFuncs=[{func:"selector-nest($selectors…)",desc:us("scss.builtin.selector-nest","Nests selector beneath one another like they would be nested in the stylesheet.")},{func:"selector-append($selectors…)",desc:us("scss.builtin.selector-append","Appends selectors to one another without spaces in between.")},{func:"selector-extend($selector, $extendee, $extender)",desc:us("scss.builtin.selector-extend","Extends $extendee with $extender within $selector.")},{func:"selector-replace($selector, $original, $replacement)",desc:us("scss.builtin.selector-replace","Replaces $original with $replacement within $selector.")},{func:"selector-unify($selector1, $selector2)",desc:us("scss.builtin.selector-unify","Unifies two selectors to produce a selector that matches elements matched by both.")},{func:"is-superselector($super, $sub)",desc:us("scss.builtin.is-superselector","Returns whether $super matches all the elements $sub does, and possibly more.")},{func:"simple-selectors($selector)",desc:us("scss.builtin.simple-selectors","Returns the simple selectors that comprise a compound selector.")},{func:"selector-parse($selector)",desc:us("scss.builtin.selector-parse","Parses a selector into the format returned by &.")}],e.builtInFuncs=[{func:"unquote($string)",desc:us("scss.builtin.unquote","Removes quotes from a string.")},{func:"quote($string)",desc:us("scss.builtin.quote","Adds quotes to a string.")},{func:"str-length($string)",desc:us("scss.builtin.str-length","Returns the number of characters in a string.")},{func:"str-insert($string, $insert, $index)",desc:us("scss.builtin.str-insert","Inserts $insert into $string at $index.")},{func:"str-index($string, $substring)",desc:us("scss.builtin.str-index","Returns the index of the first occurance of $substring in $string.")},{func:"str-slice($string, $start-at, [$end-at])",desc:us("scss.builtin.str-slice","Extracts a substring from $string.")},{func:"to-upper-case($string)",desc:us("scss.builtin.to-upper-case","Converts a string to upper case.")},{func:"to-lower-case($string)",desc:us("scss.builtin.to-lower-case","Converts a string to lower case.")},{func:"percentage($number)",desc:us("scss.builtin.percentage","Converts a unitless number to a percentage."),type:"percentage"},{func:"round($number)",desc:us("scss.builtin.round","Rounds a number to the nearest whole number.")},{func:"ceil($number)",desc:us("scss.builtin.ceil","Rounds a number up to the next whole number.")},{func:"floor($number)",desc:us("scss.builtin.floor","Rounds a number down to the previous whole number.")},{func:"abs($number)",desc:us("scss.builtin.abs","Returns the absolute value of a number.")},{func:"min($numbers)",desc:us("scss.builtin.min","Finds the minimum of several numbers.")},{func:"max($numbers)",desc:us("scss.builtin.max","Finds the maximum of several numbers.")},{func:"random([$limit])",desc:us("scss.builtin.random","Returns a random number.")},{func:"length($list)",desc:us("scss.builtin.length","Returns the length of a list.")},{func:"nth($list, $n)",desc:us("scss.builtin.nth","Returns a specific item in a list.")},{func:"set-nth($list, $n, $value)",desc:us("scss.builtin.set-nth","Replaces the nth item in a list.")},{func:"join($list1, $list2, [$separator])",desc:us("scss.builtin.join","Joins together two lists into one.")},{func:"append($list1, $val, [$separator])",desc:us("scss.builtin.append","Appends a single value onto the end of a list.")},{func:"zip($lists)",desc:us("scss.builtin.zip","Combines several lists into a single multidimensional list.")},{func:"index($list, $value)",desc:us("scss.builtin.index","Returns the position of a value within a list.")},{func:"list-separator(#list)",desc:us("scss.builtin.list-separator","Returns the separator of a list.")},{func:"map-get($map, $key)",desc:us("scss.builtin.map-get","Returns the value in a map associated with a given key.")},{func:"map-merge($map1, $map2)",desc:us("scss.builtin.map-merge","Merges two maps together into a new map.")},{func:"map-remove($map, $keys)",desc:us("scss.builtin.map-remove","Returns a new map with keys removed.")},{func:"map-keys($map)",desc:us("scss.builtin.map-keys","Returns a list of all keys in a map.")},{func:"map-values($map)",desc:us("scss.builtin.map-values","Returns a list of all values in a map.")},{func:"map-has-key($map, $key)",desc:us("scss.builtin.map-has-key","Returns whether a map has a value associated with a given key.")},{func:"keywords($args)",desc:us("scss.builtin.keywords","Returns the keywords passed to a function that takes variable arguments.")},{func:"feature-exists($feature)",desc:us("scss.builtin.feature-exists","Returns whether a feature exists in the current Sass runtime.")},{func:"variable-exists($name)",desc:us("scss.builtin.variable-exists","Returns whether a variable with the given name exists in the current scope.")},{func:"global-variable-exists($name)",desc:us("scss.builtin.global-variable-exists","Returns whether a variable with the given name exists in the global scope.")},{func:"function-exists($name)",desc:us("scss.builtin.function-exists","Returns whether a function with the given name exists.")},{func:"mixin-exists($name)",desc:us("scss.builtin.mixin-exists","Returns whether a mixin with the given name exists.")},{func:"inspect($value)",desc:us("scss.builtin.inspect","Returns the string representation of a value as it would be represented in Sass.")},{func:"type-of($value)",desc:us("scss.builtin.type-of","Returns the type of a value.")},{func:"unit($number)",desc:us("scss.builtin.unit","Returns the unit(s) associated with a number.")},{func:"unitless($number)",desc:us("scss.builtin.unitless","Returns whether a number has units.")},{func:"comparable($number1, $number2)",desc:us("scss.builtin.comparable","Returns whether two numbers can be added, subtracted, or compared.")},{func:"call($name, $args…)",desc:us("scss.builtin.call","Dynamically calls a Sass function.")}],e.scssAtDirectives=[{label:"@extend",documentation:us("scss.builtin.@extend","Inherits the styles of another selector."),kind:tr.Keyword},{label:"@at-root",documentation:us("scss.builtin.@at-root","Causes one or more rules to be emitted at the root of the document."),kind:tr.Keyword},{label:"@debug",documentation:us("scss.builtin.@debug","Prints the value of an expression to the standard error output stream. Useful for debugging complicated Sass files."),kind:tr.Keyword},{label:"@warn",documentation:us("scss.builtin.@warn","Prints the value of an expression to the standard error output stream. Useful for libraries that need to warn users of deprecations or recovering from minor mixin usage mistakes. Warnings can be turned off with the `--quiet` command-line option or the `:quiet` Sass option."),kind:tr.Keyword},{label:"@error",documentation:us("scss.builtin.@error","Throws the value of an expression as a fatal error with stack trace. Useful for validating arguments to mixins and functions."),kind:tr.Keyword},{label:"@if",documentation:us("scss.builtin.@if","Includes the body if the expression does not evaluate to `false` or `null`."),insertText:"@if ${1:expr} {\n\t$0\n}",insertTextFormat:nr.Snippet,kind:tr.Keyword},{label:"@for",documentation:us("scss.builtin.@for","For loop that repeatedly outputs a set of styles for each `$var` in the `from/through` or `from/to` clause."),insertText:"@for \\$${1:var} from ${2:start} ${3|to,through|} ${4:end} {\n\t$0\n}",insertTextFormat:nr.Snippet,kind:tr.Keyword},{label:"@each",documentation:us("scss.builtin.@each","Each loop that sets `$var` to each item in the list or map, then outputs the styles it contains using that value of `$var`."),insertText:"@each \\$${1:var} in ${2:list} {\n\t$0\n}",insertTextFormat:nr.Snippet,kind:tr.Keyword},{label:"@while",documentation:us("scss.builtin.@while","While loop that takes an expression and repeatedly outputs the nested styles until the statement evaluates to `false`."),insertText:"@while ${1:condition} {\n\t$0\n}",insertTextFormat:nr.Snippet,kind:tr.Keyword},{label:"@mixin",documentation:us("scss.builtin.@mixin","Defines styles that can be re-used throughout the stylesheet with `@include`."),insertText:"@mixin ${1:name} {\n\t$0\n}",insertTextFormat:nr.Snippet,kind:tr.Keyword},{label:"@include",documentation:us("scss.builtin.@include","Includes the styles defined by another mixin into the current rule."),kind:tr.Keyword},{label:"@function",documentation:us("scss.builtin.@function","Defines complex operations that can be re-used throughout stylesheets."),kind:tr.Keyword}],e.scssModuleLoaders=[{label:"@use",documentation:us("scss.builtin.@use","Loads mixins, functions, and variables from other Sass stylesheets as 'modules', and combines CSS from multiple stylesheets together."),references:[{name:"Sass documentation",url:"https://sass-lang.com/documentation/at-rules/use"}],insertText:"@use $0;",insertTextFormat:nr.Snippet,kind:tr.Keyword},{label:"@forward",documentation:us("scss.builtin.@forward","Loads a Sass stylesheet and makes its mixins, functions, and variables available when this stylesheet is loaded with the @use rule."),references:[{name:"Sass documentation",url:"https://sass-lang.com/documentation/at-rules/forward"}],insertText:"@forward $0;",insertTextFormat:nr.Snippet,kind:tr.Keyword}],e.scssModuleBuiltIns=[{label:"sass:math",documentation:us("scss.builtin.sass:math","Provides functions that operate on numbers."),references:[{name:"Sass documentation",url:"https://sass-lang.com/documentation/modules/math"}]},{label:"sass:string",documentation:us("scss.builtin.sass:string","Makes it easy to combine, search, or split apart strings."),references:[{name:"Sass documentation",url:"https://sass-lang.com/documentation/modules/string"}]},{label:"sass:color",documentation:us("scss.builtin.sass:color","Generates new colors based on existing ones, making it easy to build color themes."),references:[{name:"Sass documentation",url:"https://sass-lang.com/documentation/modules/color"}]},{label:"sass:list",documentation:us("scss.builtin.sass:list","Lets you access and modify values in lists."),references:[{name:"Sass documentation",url:"https://sass-lang.com/documentation/modules/list"}]},{label:"sass:map",documentation:us("scss.builtin.sass:map","Makes it possible to look up the value associated with a key in a map, and much more."),references:[{name:"Sass documentation",url:"https://sass-lang.com/documentation/modules/map"}]},{label:"sass:selector",documentation:us("scss.builtin.sass:selector","Provides access to Sass’s powerful selector engine."),references:[{name:"Sass documentation",url:"https://sass-lang.com/documentation/modules/selector"}]},{label:"sass:meta",documentation:us("scss.builtin.sass:meta","Exposes the details of Sass’s inner workings."),references:[{name:"Sass documentation",url:"https://sass-lang.com/documentation/modules/meta"}]}],e}(Ei);function _o(l){l.forEach((function(l){if(l.documentation&&l.references&&l.references.length>0){var h="string"==typeof l.documentation?{kind:"markdown",value:l.documentation}:{kind:"markdown",value:l.documentation.value};h.value+="\n\n",h.value+=l.references.map((function(l){return"[".concat(l.name,"](").concat(l.url,")")})).join(" | "),l.documentation=h}}))}var gs=function(){var n=function(l,h){return(n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(l,h){l.__proto__=h}||function(l,h){for(var m in h)Object.prototype.hasOwnProperty.call(h,m)&&(l[m]=h[m])})(l,h)};return function(l,h){if("function"!=typeof h&&null!==h)throw new TypeError("Class extends value "+String(h)+" is not a constructor or null");function r(){this.constructor=l}n(l,h),l.prototype=null===h?Object.create(h):(r.prototype=h.prototype,new r)}}(),bs="/".charCodeAt(0),vs="\n".charCodeAt(0),ys="\r".charCodeAt(0),ws="\f".charCodeAt(0),xs="`".charCodeAt(0),Ss=".".charCodeAt(0),ks=h.CustomToken,Cs=ks++,Fs=function(l){function e(){return null!==l&&l.apply(this,arguments)||this}return gs(e,l),e.prototype.scanNext=function(h){var m=this.escapedJavaScript();return null!==m?this.finishToken(h,m):this.stream.advanceIfChars([Ss,Ss,Ss])?this.finishToken(h,Cs):l.prototype.scanNext.call(this,h)},e.prototype.comment=function(){return!!l.prototype.comment.call(this)||!(this.inURL||!this.stream.advanceIfChars([bs,bs]))&&(this.stream.advanceWhileChar((function(l){switch(l){case vs:case ys:case ws:return!1;default:return!0}})),!0)},e.prototype.escapedJavaScript=function(){return this.stream.peekChar()===xs?(this.stream.advance(1),this.stream.advanceWhileChar((function(l){return l!==xs})),this.stream.advanceIfChar(xs)?h.EscapedJavaScript:h.BadEscapedJavaScript):null},e}(Fe),Es=function(){var n=function(l,h){return(n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(l,h){l.__proto__=h}||function(l,h){for(var m in h)Object.prototype.hasOwnProperty.call(h,m)&&(l[m]=h[m])})(l,h)};return function(l,h){if("function"!=typeof h&&null!==h)throw new TypeError("Class extends value "+String(h)+" is not a constructor or null");function r(){this.constructor=l}n(l,h),l.prototype=null===h?Object.create(h):(r.prototype=h.prototype,new r)}}(),zs=function(l){function e(){return l.call(this,new Fs)||this}return Es(e,l),e.prototype._parseStylesheetStatement=function(m){return void 0===m&&(m=!1),this.peek(h.AtKeyword)?this._parseVariableDeclaration()||this._parsePlugin()||l.prototype._parseStylesheetAtStatement.call(this,m):this._tryParseMixinDeclaration()||this._tryParseMixinReference()||this._parseFunction()||this._parseRuleset(!0)},e.prototype._parseImport=function(){if(!this.peekKeyword("@import")&&!this.peekKeyword("@import-once"))return null;var l=this.create(ht);if(this.consumeToken(),this.accept(h.ParenthesisL)){if(!this.accept(h.Ident))return this.finish(l,Hn.IdentifierExpected,[h.SemiColon]);do{if(!this.accept(h.Comma))break}while(this.accept(h.Ident));if(!this.accept(h.ParenthesisR))return this.finish(l,Hn.RightParenthesisExpected,[h.SemiColon])}return l.addChild(this._parseURILiteral())||l.addChild(this._parseStringLiteral())?(!this.peek(h.SemiColon)&&!this.peek(h.EOF)&&l.setMedialist(this._parseMediaQueryList()),this.finish(l)):this.finish(l,Hn.URIOrStringExpected,[h.SemiColon])},e.prototype._parsePlugin=function(){if(!this.peekKeyword("@plugin"))return null;var l=this.createNode(Ee.Plugin);return this.consumeToken(),l.addChild(this._parseStringLiteral())?this.accept(h.SemiColon)?this.finish(l):this.finish(l,Hn.SemiColonExpected):this.finish(l,Hn.StringLiteralExpected)},e.prototype._parseMediaQuery=function(){var h=l.prototype._parseMediaQuery.call(this);if(!h){var m=this.create(Ft);return m.addChild(this._parseVariable())?this.finish(m):null}return h},e.prototype._parseMediaDeclaration=function(l){return void 0===l&&(l=!1),this._tryParseRuleset(l)||this._tryToParseDeclaration()||this._tryParseMixinDeclaration()||this._tryParseMixinReference()||this._parseDetachedRuleSetMixin()||this._parseStylesheetStatement(l)},e.prototype._parseMediaFeatureName=function(){return this._parseIdent()||this._parseVariable()},e.prototype._parseVariableDeclaration=function(l){void 0===l&&(l=[]);var m=this.create(Jt),b=this.mark();if(!m.setVariable(this._parseVariable(!0)))return null;if(!this.accept(h.Colon))return this.restoreAtMark(b),null;if(this.prevToken&&(m.colonPosition=this.prevToken.offset),m.setValue(this._parseDetachedRuleSet()))m.needsSemicolon=!1;else if(!m.setValue(this._parseExpr()))return this.finish(m,Hn.VariableValueExpected,[],l);return m.addChild(this._parsePrio()),this.peek(h.SemiColon)&&(m.semicolonPosition=this.token.offset),this.finish(m)},e.prototype._parseDetachedRuleSet=function(){var l=this.mark();if(this.peekDelim("#")||this.peekDelim(".")){if(this.consumeToken(),this.hasWhitespace()||!this.accept(h.ParenthesisL))return this.restoreAtMark(l),null;var m=this.create(sn);if(m.getParameters().addChild(this._parseMixinParameter()))for(;(this.accept(h.Comma)||this.accept(h.SemiColon))&&!this.peek(h.ParenthesisR);)m.getParameters().addChild(this._parseMixinParameter())||this.markError(m,Hn.IdentifierExpected,[],[h.ParenthesisR]);if(!this.accept(h.ParenthesisR))return this.restoreAtMark(l),null}if(!this.peek(h.CurlyL))return null;var b=this.create(Ae);return this._parseBody(b,this._parseDetachedRuleSetBody.bind(this)),this.finish(b)},e.prototype._parseDetachedRuleSetBody=function(){return this._tryParseKeyframeSelector()||this._parseRuleSetDeclaration()},e.prototype._addLookupChildren=function(l){if(!l.addChild(this._parseLookupValue()))return!1;for(var m=!1;this.peek(h.BracketL)&&(m=!0),l.addChild(this._parseLookupValue());)m=!1;return!m},e.prototype._parseLookupValue=function(){var l=this.create(Te),m=this.mark();return this.accept(h.BracketL)&&((l.addChild(this._parseVariable(!1,!0))||l.addChild(this._parsePropertyIdentifier()))&&this.accept(h.BracketR)||this.accept(h.BracketR))?l:(this.restoreAtMark(m),null)},e.prototype._parseVariable=function(l,m){void 0===l&&(l=!1),void 0===m&&(m=!1);var b=!l&&this.peekDelim("$");if(!this.peekDelim("@")&&!b&&!this.peek(h.AtKeyword))return null;for(var y=this.create(Zt),w=this.mark();this.acceptDelim("@")||!l&&this.acceptDelim("$");)if(this.hasWhitespace())return this.restoreAtMark(w),null;return(this.accept(h.AtKeyword)||this.accept(h.Ident))&&(m||!this.peek(h.BracketL)||this._addLookupChildren(y))?y:(this.restoreAtMark(w),null)},e.prototype._parseTermExpression=function(){return this._parseVariable()||this._parseEscaped()||l.prototype._parseTermExpression.call(this)||this._tryParseMixinReference(!1)},e.prototype._parseEscaped=function(){if(this.peek(h.EscapedJavaScript)||this.peek(h.BadEscapedJavaScript)){var l=this.createNode(Ee.EscapedValue);return this.consumeToken(),this.finish(l)}if(this.peekDelim("~")){l=this.createNode(Ee.EscapedValue);return this.consumeToken(),this.accept(h.String)||this.accept(h.EscapedJavaScript)?this.finish(l):this.finish(l,Hn.TermExpected)}return null},e.prototype._parseOperator=function(){return this._parseGuardOperator()||l.prototype._parseOperator.call(this)},e.prototype._parseGuardOperator=function(){if(this.peekDelim(">")){var l=this.createNode(Ee.Operator);return this.consumeToken(),this.acceptDelim("="),l}if(this.peekDelim("=")){l=this.createNode(Ee.Operator);return this.consumeToken(),this.acceptDelim("<"),l}if(this.peekDelim("<")){l=this.createNode(Ee.Operator);return this.consumeToken(),this.acceptDelim("="),l}return null},e.prototype._parseRuleSetDeclaration=function(){return this.peek(h.AtKeyword)?this._parseKeyframe()||this._parseMedia(!0)||this._parseImport()||this._parseSupports(!0)||this._parseDetachedRuleSetMixin()||this._parseVariableDeclaration()||l.prototype._parseRuleSetDeclarationAtStatement.call(this):this._tryParseMixinDeclaration()||this._tryParseRuleset(!0)||this._tryParseMixinReference()||this._parseFunction()||this._parseExtend()||l.prototype._parseRuleSetDeclaration.call(this)},e.prototype._parseKeyframeIdent=function(){return this._parseIdent([ze.Keyframe])||this._parseVariable()},e.prototype._parseKeyframeSelector=function(){return this._parseDetachedRuleSetMixin()||l.prototype._parseKeyframeSelector.call(this)},e.prototype._parseSimpleSelectorBody=function(){return this._parseSelectorCombinator()||l.prototype._parseSimpleSelectorBody.call(this)},e.prototype._parseSelector=function(l){var m=this.create(We),b=!1;for(l&&(b=m.addChild(this._parseCombinator()));m.addChild(this._parseSimpleSelector());){b=!0;var y=this.mark();if(m.addChild(this._parseGuard())&&this.peek(h.CurlyL))break;this.restoreAtMark(y),m.addChild(this._parseCombinator())}return b?this.finish(m):null},e.prototype._parseSelectorCombinator=function(){if(this.peekDelim("&")){var l=this.createNode(Ee.SelectorCombinator);for(this.consumeToken();!this.hasWhitespace()&&(this.acceptDelim("-")||this.accept(h.Num)||this.accept(h.Dimension)||l.addChild(this._parseIdent())||this.acceptDelim("&")););return this.finish(l)}return null},e.prototype._parseSelectorIdent=function(){if(!this.peekInterpolatedIdent())return null;var l=this.createNode(Ee.SelectorInterpolation);return this._acceptInterpolatedIdent(l)?this.finish(l):null},e.prototype._parsePropertyIdentifier=function(l){void 0===l&&(l=!1);var h=/^[\w-]+/;if(!this.peekInterpolatedIdent()&&!this.peekRegExp(this.token.type,h))return null;var m=this.mark(),b=this.create(Me);b.isCustomProperty=this.acceptDelim("-")&&this.acceptDelim("-");return(l?b.isCustomProperty?b.addChild(this._parseIdent()):b.addChild(this._parseRegexp(h)):b.isCustomProperty?this._acceptInterpolatedIdent(b):this._acceptInterpolatedIdent(b,h))?(!l&&!this.hasWhitespace()&&(this.acceptDelim("+"),this.hasWhitespace()||this.acceptIdent("_")),this.finish(b)):(this.restoreAtMark(m),null)},e.prototype.peekInterpolatedIdent=function(){return this.peek(h.Ident)||this.peekDelim("@")||this.peekDelim("$")||this.peekDelim("-")},e.prototype._acceptInterpolatedIdent=function(l,m){for(var b=this,y=!1,a=function(){var l=b.mark();return b.acceptDelim("-")&&(b.hasWhitespace()||b.acceptDelim("-"),b.hasWhitespace())?(b.restoreAtMark(l),null):b._parseInterpolation()},w=m?function(){return b.acceptRegexp(m)}:function(){return b.accept(h.Ident)};(w()||l.addChild(this._parseInterpolation()||this.try(a)))&&(y=!0,!this.hasWhitespace()););return y},e.prototype._parseInterpolation=function(){var l=this.mark();if(this.peekDelim("@")||this.peekDelim("$")){var m=this.createNode(Ee.Interpolation);return this.consumeToken(),this.hasWhitespace()||!this.accept(h.CurlyL)?(this.restoreAtMark(l),null):m.addChild(this._parseIdent())?this.accept(h.CurlyR)?this.finish(m):this.finish(m,Hn.RightCurlyExpected):this.finish(m,Hn.IdentifierExpected)}return null},e.prototype._tryParseMixinDeclaration=function(){var l=this.mark(),m=this.create(sn);if(!m.setIdentifier(this._parseMixinDeclarationIdentifier())||!this.accept(h.ParenthesisL))return this.restoreAtMark(l),null;if(m.getParameters().addChild(this._parseMixinParameter()))for(;(this.accept(h.Comma)||this.accept(h.SemiColon))&&!this.peek(h.ParenthesisR);)m.getParameters().addChild(this._parseMixinParameter())||this.markError(m,Hn.IdentifierExpected,[],[h.ParenthesisR]);return this.accept(h.ParenthesisR)?(m.setGuard(this._parseGuard()),this.peek(h.CurlyL)?this._parseBody(m,this._parseMixInBodyDeclaration.bind(this)):(this.restoreAtMark(l),null)):(this.restoreAtMark(l),null)},e.prototype._parseMixInBodyDeclaration=function(){return this._parseFontFace()||this._parseRuleSetDeclaration()},e.prototype._parseMixinDeclarationIdentifier=function(){var l;if(this.peekDelim("#")||this.peekDelim(".")){if(l=this.create(Me),this.consumeToken(),this.hasWhitespace()||!l.addChild(this._parseIdent()))return null}else{if(!this.peek(h.Hash))return null;l=this.create(Me),this.consumeToken()}return l.referenceTypes=[ze.Mixin],this.finish(l)},e.prototype._parsePseudo=function(){if(!this.peek(h.Colon))return null;var m=this.mark(),b=this.create(Qt);return this.consumeToken(),this.acceptIdent("extend")?this._completeExtends(b):(this.restoreAtMark(m),l.prototype._parsePseudo.call(this))},e.prototype._parseExtend=function(){if(!this.peekDelim("&"))return null;var l=this.mark(),m=this.create(Qt);return this.consumeToken(),!this.hasWhitespace()&&this.accept(h.Colon)&&this.acceptIdent("extend")?this._completeExtends(m):(this.restoreAtMark(l),null)},e.prototype._completeExtends=function(l){if(!this.accept(h.ParenthesisL))return this.finish(l,Hn.LeftParenthesisExpected);var m=l.getSelectors();if(!m.addChild(this._parseSelector(!0)))return this.finish(l,Hn.SelectorExpected);for(;this.accept(h.Comma);)if(!m.addChild(this._parseSelector(!0)))return this.finish(l,Hn.SelectorExpected);return this.accept(h.ParenthesisR)?this.finish(l):this.finish(l,Hn.RightParenthesisExpected)},e.prototype._parseDetachedRuleSetMixin=function(){if(!this.peek(h.AtKeyword))return null;var l=this.mark(),m=this.create(on);return!m.addChild(this._parseVariable(!0))||!this.hasWhitespace()&&this.accept(h.ParenthesisL)?this.accept(h.ParenthesisR)?this.finish(m):this.finish(m,Hn.RightParenthesisExpected):(this.restoreAtMark(l),null)},e.prototype._tryParseMixinReference=function(l){void 0===l&&(l=!0);for(var m=this.mark(),b=this.create(on),y=this._parseMixinDeclarationIdentifier();y;){this.acceptDelim(">");var w=this._parseMixinDeclarationIdentifier();if(!w)break;b.getNamespaces().addChild(y),y=w}if(!b.setIdentifier(y))return this.restoreAtMark(m),null;var x=!1;if(this.accept(h.ParenthesisL)){if(x=!0,b.getArguments().addChild(this._parseMixinArgument()))for(;(this.accept(h.Comma)||this.accept(h.SemiColon))&&!this.peek(h.ParenthesisR);)if(!b.getArguments().addChild(this._parseMixinArgument()))return this.finish(b,Hn.ExpressionExpected);if(!this.accept(h.ParenthesisR))return this.finish(b,Hn.RightParenthesisExpected);y.referenceTypes=[ze.Mixin]}else y.referenceTypes=[ze.Mixin,ze.Rule];return this.peek(h.BracketL)?l||this._addLookupChildren(b):b.addChild(this._parsePrio()),x||this.peek(h.SemiColon)||this.peek(h.CurlyR)||this.peek(h.EOF)?this.finish(b):(this.restoreAtMark(m),null)},e.prototype._parseMixinArgument=function(){var l=this.create(Je),m=this.mark(),b=this._parseVariable();return b&&(this.accept(h.Colon)?l.setIdentifier(b):this.restoreAtMark(m)),l.setValue(this._parseDetachedRuleSet()||this._parseExpr(!0))?this.finish(l):(this.restoreAtMark(m),null)},e.prototype._parseMixinParameter=function(){var l=this.create(He);if(this.peekKeyword("@rest")){var m=this.create(Te);return this.consumeToken(),this.accept(Cs)?(l.setIdentifier(this.finish(m)),this.finish(l)):this.finish(l,Hn.DotExpected,[],[h.Comma,h.ParenthesisR])}if(this.peek(Cs)){var b=this.create(Te);return this.consumeToken(),l.setIdentifier(this.finish(b)),this.finish(l)}var y=!1;return l.setIdentifier(this._parseVariable())&&(this.accept(h.Colon),y=!0),l.setDefaultValue(this._parseDetachedRuleSet()||this._parseExpr(!0))||y?this.finish(l):null},e.prototype._parseGuard=function(){if(!this.peekIdent("when"))return null;var l=this.create(cn);if(this.consumeToken(),l.isNegated=this.acceptIdent("not"),!l.getConditions().addChild(this._parseGuardCondition()))return this.finish(l,Hn.ConditionExpected);for(;this.acceptIdent("and")||this.accept(h.Comma);)if(!l.getConditions().addChild(this._parseGuardCondition()))return this.finish(l,Hn.ConditionExpected);return this.finish(l)},e.prototype._parseGuardCondition=function(){if(!this.peek(h.ParenthesisL))return null;var l=this.create(dn);return this.consumeToken(),l.addChild(this._parseExpr()),this.accept(h.ParenthesisR)?this.finish(l):this.finish(l,Hn.RightParenthesisExpected)},e.prototype._parseFunction=function(){var l=this.mark(),m=this.create(Ge);if(!m.setIdentifier(this._parseFunctionIdentifier()))return null;if(this.hasWhitespace()||!this.accept(h.ParenthesisL))return this.restoreAtMark(l),null;if(m.getArguments().addChild(this._parseMixinArgument()))for(;(this.accept(h.Comma)||this.accept(h.SemiColon))&&!this.peek(h.ParenthesisR);)if(!m.getArguments().addChild(this._parseMixinArgument()))return this.finish(m,Hn.ExpressionExpected);return this.accept(h.ParenthesisR)?this.finish(m):this.finish(m,Hn.RightParenthesisExpected)},e.prototype._parseFunctionIdentifier=function(){if(this.peekDelim("%")){var h=this.create(Me);return h.referenceTypes=[ze.Function],this.consumeToken(),this.finish(h)}return l.prototype._parseFunctionIdentifier.call(this)},e.prototype._parseURLArgument=function(){var m=this.mark(),b=l.prototype._parseURLArgument.call(this);if(!b||!this.peek(h.ParenthesisR)){this.restoreAtMark(m);var y=this.create(Te);return y.addChild(this._parseBinaryExpr()),this.finish(y)}return b},e}(di),Ds=function(){var n=function(l,h){return(n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(l,h){l.__proto__=h}||function(l,h){for(var m in h)Object.prototype.hasOwnProperty.call(h,m)&&(l[m]=h[m])})(l,h)};return function(l,h){if("function"!=typeof h&&null!==h)throw new TypeError("Class extends value "+String(h)+" is not a constructor or null");function r(){this.constructor=l}n(l,h),l.prototype=null===h?Object.create(h):(r.prototype=h.prototype,new r)}}(),Rs=$(),Ts=function(l){function e(h,m){return l.call(this,"@",h,m)||this}return Ds(e,l),e.prototype.createFunctionProposals=function(l,h,m,b){for(var y=0,w=l;y<w.length;y++){var x=w[y],F={label:x.name,detail:x.example,documentation:x.description,textEdit:An.replace(this.getCompletionRange(h),x.name+"($0)"),insertTextFormat:nr.Snippet,kind:tr.Function};m&&(F.sortText="z"),b.items.push(F)}return b},e.prototype.getTermProposals=function(h,m,b){var y=e.builtInProposals;return h&&(y=y.filter((function(l){return!l.type||!h.restrictions||-1!==h.restrictions.indexOf(l.type)}))),this.createFunctionProposals(y,m,!0,b),l.prototype.getTermProposals.call(this,h,m,b)},e.prototype.getColorProposals=function(h,m,b){return this.createFunctionProposals(e.colorProposals,m,!1,b),l.prototype.getColorProposals.call(this,h,m,b)},e.prototype.getCompletionsForDeclarationProperty=function(h,m){return this.getCompletionsForSelector(null,!0,m),l.prototype.getCompletionsForDeclarationProperty.call(this,h,m)},e.builtInProposals=[{name:"if",example:"if(condition, trueValue [, falseValue]);",description:Rs("less.builtin.if","returns one of two values depending on a condition.")},{name:"boolean",example:"boolean(condition);",description:Rs("less.builtin.boolean",'"store" a boolean test for later evaluation in a guard or if().')},{name:"length",example:"length(@list);",description:Rs("less.builtin.length","returns the number of elements in a value list")},{name:"extract",example:"extract(@list, index);",description:Rs("less.builtin.extract","returns a value at the specified position in the list")},{name:"range",example:"range([start, ] end [, step]);",description:Rs("less.builtin.range","generate a list spanning a range of values")},{name:"each",example:"each(@list, ruleset);",description:Rs("less.builtin.each","bind the evaluation of a ruleset to each member of a list.")},{name:"escape",example:"escape(@string);",description:Rs("less.builtin.escape","URL encodes a string")},{name:"e",example:"e(@string);",description:Rs("less.builtin.e","escape string content")},{name:"replace",example:"replace(@string, @pattern, @replacement[, @flags]);",description:Rs("less.builtin.replace","string replace")},{name:"unit",example:"unit(@dimension, [@unit: '']);",description:Rs("less.builtin.unit","remove or change the unit of a dimension")},{name:"color",example:"color(@string);",description:Rs("less.builtin.color","parses a string to a color"),type:"color"},{name:"convert",example:"convert(@value, unit);",description:Rs("less.builtin.convert","converts numbers from one type into another")},{name:"data-uri",example:"data-uri([mimetype,] url);",description:Rs("less.builtin.data-uri","inlines a resource and falls back to `url()`"),type:"url"},{name:"abs",description:Rs("less.builtin.abs","absolute value of a number"),example:"abs(number);"},{name:"acos",description:Rs("less.builtin.acos","arccosine - inverse of cosine function"),example:"acos(number);"},{name:"asin",description:Rs("less.builtin.asin","arcsine - inverse of sine function"),example:"asin(number);"},{name:"ceil",example:"ceil(@number);",description:Rs("less.builtin.ceil","rounds up to an integer")},{name:"cos",description:Rs("less.builtin.cos","cosine function"),example:"cos(number);"},{name:"floor",description:Rs("less.builtin.floor","rounds down to an integer"),example:"floor(@number);"},{name:"percentage",description:Rs("less.builtin.percentage","converts to a %, e.g. 0.5 > 50%"),example:"percentage(@number);",type:"percentage"},{name:"round",description:Rs("less.builtin.round","rounds a number to a number of places"),example:"round(number, [places: 0]);"},{name:"sqrt",description:Rs("less.builtin.sqrt","calculates square root of a number"),example:"sqrt(number);"},{name:"sin",description:Rs("less.builtin.sin","sine function"),example:"sin(number);"},{name:"tan",description:Rs("less.builtin.tan","tangent function"),example:"tan(number);"},{name:"atan",description:Rs("less.builtin.atan","arctangent - inverse of tangent function"),example:"atan(number);"},{name:"pi",description:Rs("less.builtin.pi","returns pi"),example:"pi();"},{name:"pow",description:Rs("less.builtin.pow","first argument raised to the power of the second argument"),example:"pow(@base, @exponent);"},{name:"mod",description:Rs("less.builtin.mod","first argument modulus second argument"),example:"mod(number, number);"},{name:"min",description:Rs("less.builtin.min","returns the lowest of one or more values"),example:"min(@x, @y);"},{name:"max",description:Rs("less.builtin.max","returns the lowest of one or more values"),example:"max(@x, @y);"}],e.colorProposals=[{name:"argb",example:"argb(@color);",description:Rs("less.builtin.argb","creates a #AARRGGBB")},{name:"hsl",example:"hsl(@hue, @saturation, @lightness);",description:Rs("less.builtin.hsl","creates a color")},{name:"hsla",example:"hsla(@hue, @saturation, @lightness, @alpha);",description:Rs("less.builtin.hsla","creates a color")},{name:"hsv",example:"hsv(@hue, @saturation, @value);",description:Rs("less.builtin.hsv","creates a color")},{name:"hsva",example:"hsva(@hue, @saturation, @value, @alpha);",description:Rs("less.builtin.hsva","creates a color")},{name:"hue",example:"hue(@color);",description:Rs("less.builtin.hue","returns the `hue` channel of `@color` in the HSL space")},{name:"saturation",example:"saturation(@color);",description:Rs("less.builtin.saturation","returns the `saturation` channel of `@color` in the HSL space")},{name:"lightness",example:"lightness(@color);",description:Rs("less.builtin.lightness","returns the `lightness` channel of `@color` in the HSL space")},{name:"hsvhue",example:"hsvhue(@color);",description:Rs("less.builtin.hsvhue","returns the `hue` channel of `@color` in the HSV space")},{name:"hsvsaturation",example:"hsvsaturation(@color);",description:Rs("less.builtin.hsvsaturation","returns the `saturation` channel of `@color` in the HSV space")},{name:"hsvvalue",example:"hsvvalue(@color);",description:Rs("less.builtin.hsvvalue","returns the `value` channel of `@color` in the HSV space")},{name:"red",example:"red(@color);",description:Rs("less.builtin.red","returns the `red` channel of `@color`")},{name:"green",example:"green(@color);",description:Rs("less.builtin.green","returns the `green` channel of `@color`")},{name:"blue",example:"blue(@color);",description:Rs("less.builtin.blue","returns the `blue` channel of `@color`")},{name:"alpha",example:"alpha(@color);",description:Rs("less.builtin.alpha","returns the `alpha` channel of `@color`")},{name:"luma",example:"luma(@color);",description:Rs("less.builtin.luma","returns the `luma` value (perceptual brightness) of `@color`")},{name:"saturate",example:"saturate(@color, 10%);",description:Rs("less.builtin.saturate","return `@color` 10% points more saturated")},{name:"desaturate",example:"desaturate(@color, 10%);",description:Rs("less.builtin.desaturate","return `@color` 10% points less saturated")},{name:"lighten",example:"lighten(@color, 10%);",description:Rs("less.builtin.lighten","return `@color` 10% points lighter")},{name:"darken",example:"darken(@color, 10%);",description:Rs("less.builtin.darken","return `@color` 10% points darker")},{name:"fadein",example:"fadein(@color, 10%);",description:Rs("less.builtin.fadein","return `@color` 10% points less transparent")},{name:"fadeout",example:"fadeout(@color, 10%);",description:Rs("less.builtin.fadeout","return `@color` 10% points more transparent")},{name:"fade",example:"fade(@color, 50%);",description:Rs("less.builtin.fade","return `@color` with 50% transparency")},{name:"spin",example:"spin(@color, 10);",description:Rs("less.builtin.spin","return `@color` with a 10 degree larger in hue")},{name:"mix",example:"mix(@color1, @color2, [@weight: 50%]);",description:Rs("less.builtin.mix","return a mix of `@color1` and `@color2`")},{name:"greyscale",example:"greyscale(@color);",description:Rs("less.builtin.greyscale","returns a grey, 100% desaturated color")},{name:"contrast",example:"contrast(@color1, [@darkcolor: black], [@lightcolor: white], [@threshold: 43%]);",description:Rs("less.builtin.contrast","return `@darkcolor` if `@color1 is> 43% luma` otherwise return `@lightcolor`, see notes")},{name:"multiply",example:"multiply(@color1, @color2);"},{name:"screen",example:"screen(@color1, @color2);"},{name:"overlay",example:"overlay(@color1, @color2);"},{name:"softlight",example:"softlight(@color1, @color2);"},{name:"hardlight",example:"hardlight(@color1, @color2);"},{name:"difference",example:"difference(@color1, @color2);"},{name:"exclusion",example:"exclusion(@color1, @color2);"},{name:"average",example:"average(@color1, @color2);"},{name:"negation",example:"negation(@color1, @color2);"}],e}(Ei);function Vo(l,m){var b=function Ps(l){function e(h){return l.positionAt(h.offset).line}function t(h){return l.positionAt(h.offset+h.len).line}function r(){switch(l.languageId){case"scss":return new Qo;case"less":return new Fs;default:return new Fe}}function i(l,h){var m=e(l),b=t(l);return m!==b?{startLine:m,endLine:b,kind:h}:null}var m=[],b=[],y=r();y.ignoreComment=!1,y.setSource(l.getText());for(var w=y.scan(),x=null,p=function(){switch(w.type){case h.CurlyL:case Uo:b.push({line:e(w),type:"brace",isStart:!0});break;case h.CurlyR:if(0!==b.length){if(!(z=jo(b,"brace")))break;var F=t(w);"brace"===z.type&&(x&&t(x)!==F&&F--,z.line!==F&&m.push({startLine:z.line,endLine:F,kind:void 0}))}break;case h.Comment:var g=function(l){return"#region"===l?{line:e(w),type:"comment",isStart:!0}:{line:t(w),type:"comment",isStart:!1}},E=function(h){var m=h.text.match(/^\s*\/\*\s*(#region|#endregion)\b\s*(.*?)\s*\*\//);if(m)return g(m[1]);if("scss"===l.languageId||"less"===l.languageId){var b=h.text.match(/^\s*\/\/\s*(#region|#endregion)\b\s*(.*?)\s*/);if(b)return g(b[1])}return null}(w);if(E)if(E.isStart)b.push(E);else{var z;if(!(z=jo(b,"comment")))break;"comment"===z.type&&z.line!==E.line&&m.push({startLine:z.line,endLine:E.line,kind:"region"})}else{var D=i(w,"comment");D&&m.push(D)}}x=w,w=y.scan()};w.type!==h.EOF;)p();return m}(l);return function As(l,h){var m=h&&h.rangeLimit||Number.MAX_VALUE,b=l.sort((function(l,h){var m=l.startLine-h.startLine;return 0===m&&(m=l.endLine-h.endLine),m})),y=[],w=-1;return b.forEach((function(l){l.startLine<w&&w<l.endLine||(y.push(l),w=l.endLine)})),y.length<m?y:y.slice(0,m)}(b,m)}function jo(l,h){if(0===l.length)return null;for(var m=l.length-1;m>=0;m--)if(l[m].type===h&&l[m].isStart)return l.splice(m,1)[0];return null}var Is={version:1.1,properties:[{name:"additive-symbols",browsers:["FF33"],syntax:"[ <integer> && <symbol> ]#",relevance:50,description:"@counter-style descriptor. Specifies the symbols used by the marker-construction algorithm specified by the system descriptor. Needs to be specified if the counter system is 'additive'.",restrictions:["integer","string","image","identifier"]},{name:"align-content",values:[{name:"center",description:"Lines are packed toward the center of the flex container."},{name:"flex-end",description:"Lines are packed toward the end of the flex container."},{name:"flex-start",description:"Lines are packed toward the start of the flex container."},{name:"space-around",description:"Lines are evenly distributed in the flex container, with half-size spaces on either end."},{name:"space-between",description:"Lines are evenly distributed in the flex container."},{name:"stretch",description:"Lines stretch to take up the remaining space."}],syntax:"normal | <baseline-position> | <content-distribution> | <overflow-position>? <content-position>",relevance:62,description:"Aligns a flex container’s lines within the flex container when there is extra space in the cross-axis, similar to how 'justify-content' aligns individual items within the main-axis.",restrictions:["enum"]},{name:"align-items",values:[{name:"baseline",description:"If the flex item’s inline axis is the same as the cross axis, this value is identical to 'flex-start'. Otherwise, it participates in baseline alignment."},{name:"center",description:"The flex item’s margin box is centered in the cross axis within the line."},{name:"flex-end",description:"The cross-end margin edge of the flex item is placed flush with the cross-end edge of the line."},{name:"flex-start",description:"The cross-start margin edge of the flex item is placed flush with the cross-start edge of the line."},{name:"stretch",description:"If the cross size property of the flex item computes to auto, and neither of the cross-axis margins are auto, the flex item is stretched."}],syntax:"normal | stretch | <baseline-position> | [ <overflow-position>? <self-position> ]",relevance:86,description:"Aligns flex items along the cross axis of the current line of the flex container.",restrictions:["enum"]},{name:"justify-items",values:[{name:"auto"},{name:"normal"},{name:"end"},{name:"start"},{name:"flex-end",description:'"Flex items are packed toward the end of the line."'},{name:"flex-start",description:'"Flex items are packed toward the start of the line."'},{name:"self-end",description:"The item is packed flush to the edge of the alignment container of the end side of the item, in the appropriate axis."},{name:"self-start",description:"The item is packed flush to the edge of the alignment container of the start side of the item, in the appropriate axis.."},{name:"center",description:"The items are packed flush to each other toward the center of the of the alignment container."},{name:"left"},{name:"right"},{name:"baseline"},{name:"first baseline"},{name:"last baseline"},{name:"stretch",description:"If the cross size property of the flex item computes to auto, and neither of the cross-axis margins are auto, the flex item is stretched."},{name:"save"},{name:"unsave"},{name:"legacy"}],syntax:"normal | stretch | <baseline-position> | <overflow-position>? [ <self-position> | left | right ] | legacy | legacy && [ left | right | center ]",relevance:53,description:"Defines the default justify-self for all items of the box, giving them the default way of justifying each box along the appropriate axis",restrictions:["enum"]},{name:"justify-self",values:[{name:"auto"},{name:"normal"},{name:"end"},{name:"start"},{name:"flex-end",description:'"Flex items are packed toward the end of the line."'},{name:"flex-start",description:'"Flex items are packed toward the start of the line."'},{name:"self-end",description:"The item is packed flush to the edge of the alignment container of the end side of the item, in the appropriate axis."},{name:"self-start",description:"The item is packed flush to the edge of the alignment container of the start side of the item, in the appropriate axis.."},{name:"center",description:"The items are packed flush to each other toward the center of the of the alignment container."},{name:"left"},{name:"right"},{name:"baseline"},{name:"first baseline"},{name:"last baseline"},{name:"stretch",description:"If the cross size property of the flex item computes to auto, and neither of the cross-axis margins are auto, the flex item is stretched."},{name:"save"},{name:"unsave"}],syntax:"auto | normal | stretch | <baseline-position> | <overflow-position>? [ <self-position> | left | right ]",relevance:53,description:"Defines the way of justifying a box inside its container along the appropriate axis.",restrictions:["enum"]},{name:"align-self",values:[{name:"auto",description:"Computes to the value of 'align-items' on the element’s parent, or 'stretch' if the element has no parent. On absolutely positioned elements, it computes to itself."},{name:"baseline",description:"If the flex item’s inline axis is the same as the cross axis, this value is identical to 'flex-start'. Otherwise, it participates in baseline alignment."},{name:"center",description:"The flex item’s margin box is centered in the cross axis within the line."},{name:"flex-end",description:"The cross-end margin edge of the flex item is placed flush with the cross-end edge of the line."},{name:"flex-start",description:"The cross-start margin edge of the flex item is placed flush with the cross-start edge of the line."},{name:"stretch",description:"If the cross size property of the flex item computes to auto, and neither of the cross-axis margins are auto, the flex item is stretched."}],syntax:"auto | normal | stretch | <baseline-position> | <overflow-position>? <self-position>",relevance:72,description:"Allows the default alignment along the cross axis to be overridden for individual flex items.",restrictions:["enum"]},{name:"all",browsers:["E79","FF27","S9.1","C37","O24"],values:[],syntax:"initial | inherit | unset | revert",relevance:52,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/all"}],description:"Shorthand that resets all properties except 'direction' and 'unicode-bidi'.",restrictions:["enum"]},{name:"alt",browsers:["S9"],values:[],relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/alt"}],description:"Provides alternative text for assistive technology to replace the generated content of a ::before or ::after element.",restrictions:["string","enum"]},{name:"animation",values:[{name:"alternate",description:"The animation cycle iterations that are odd counts are played in the normal direction, and the animation cycle iterations that are even counts are played in a reverse direction."},{name:"alternate-reverse",description:"The animation cycle iterations that are odd counts are played in the reverse direction, and the animation cycle iterations that are even counts are played in a normal direction."},{name:"backwards",description:"The beginning property value (as defined in the first @keyframes at-rule) is applied before the animation is displayed, during the period defined by 'animation-delay'."},{name:"both",description:"Both forwards and backwards fill modes are applied."},{name:"forwards",description:"The final property value (as defined in the last @keyframes at-rule) is maintained after the animation completes."},{name:"infinite",description:"Causes the animation to repeat forever."},{name:"none",description:"No animation is performed"},{name:"normal",description:"Normal playback."},{name:"reverse",description:"All iterations of the animation are played in the reverse direction from the way they were specified."}],syntax:"<single-animation>#",relevance:82,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/animation"}],description:"Shorthand property combines six of the animation properties into a single property.",restrictions:["time","timing-function","enum","identifier","number"]},{name:"animation-delay",syntax:"<time>#",relevance:63,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/animation-delay"}],description:"Defines when the animation will start.",restrictions:["time"]},{name:"animation-direction",values:[{name:"alternate",description:"The animation cycle iterations that are odd counts are played in the normal direction, and the animation cycle iterations that are even counts are played in a reverse direction."},{name:"alternate-reverse",description:"The animation cycle iterations that are odd counts are played in the reverse direction, and the animation cycle iterations that are even counts are played in a normal direction."},{name:"normal",description:"Normal playback."},{name:"reverse",description:"All iterations of the animation are played in the reverse direction from the way they were specified."}],syntax:"<single-animation-direction>#",relevance:56,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/animation-direction"}],description:"Defines whether or not the animation should play in reverse on alternate cycles.",restrictions:["enum"]},{name:"animation-duration",syntax:"<time>#",relevance:70,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/animation-duration"}],description:"Defines the length of time that an animation takes to complete one cycle.",restrictions:["time"]},{name:"animation-fill-mode",values:[{name:"backwards",description:"The beginning property value (as defined in the first @keyframes at-rule) is applied before the animation is displayed, during the period defined by 'animation-delay'."},{name:"both",description:"Both forwards and backwards fill modes are applied."},{name:"forwards",description:"The final property value (as defined in the last @keyframes at-rule) is maintained after the animation completes."},{name:"none",description:"There is no change to the property value between the time the animation is applied and the time the animation begins playing or after the animation completes."}],syntax:"<single-animation-fill-mode>#",relevance:63,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/animation-fill-mode"}],description:"Defines what values are applied by the animation outside the time it is executing.",restrictions:["enum"]},{name:"animation-iteration-count",values:[{name:"infinite",description:"Causes the animation to repeat forever."}],syntax:"<single-animation-iteration-count>#",relevance:60,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/animation-iteration-count"}],description:"Defines the number of times an animation cycle is played. The default value is one, meaning the animation will play from beginning to end once.",restrictions:["number","enum"]},{name:"animation-name",values:[{name:"none",description:"No animation is performed"}],syntax:"[ none | <keyframes-name> ]#",relevance:70,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/animation-name"}],description:"Defines a list of animations that apply. Each name is used to select the keyframe at-rule that provides the property values for the animation.",restrictions:["identifier","enum"]},{name:"animation-play-state",values:[{name:"paused",description:"A running animation will be paused."},{name:"running",description:"Resume playback of a paused animation."}],syntax:"<single-animation-play-state>#",relevance:54,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/animation-play-state"}],description:"Defines whether the animation is running or paused.",restrictions:["enum"]},{name:"animation-timing-function",syntax:"<easing-function>#",relevance:70,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/animation-timing-function"}],description:"Describes how the animation will progress over one cycle of its duration.",restrictions:["timing-function"]},{name:"backface-visibility",values:[{name:"hidden",description:"Back side is hidden."},{name:"visible",description:"Back side is visible."}],syntax:"visible | hidden",relevance:59,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/backface-visibility"}],description:"Determines whether or not the 'back' side of a transformed element is visible when facing the viewer. With an identity transform, the front side of an element faces the viewer.",restrictions:["enum"]},{name:"background",values:[{name:"fixed",description:"The background is fixed with regard to the viewport. In paged media where there is no viewport, a 'fixed' background is fixed with respect to the page box and therefore replicated on every page."},{name:"local",description:"The background is fixed with regard to the element's contents: if the element has a scrolling mechanism, the background scrolls with the element's contents."},{name:"none",description:"A value of 'none' counts as an image layer but draws nothing."},{name:"scroll",description:"The background is fixed with regard to the element itself and does not scroll with its contents. (It is effectively attached to the element's border.)"}],syntax:"[ <bg-layer> , ]* <final-bg-layer>",relevance:93,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/background"}],description:"Shorthand property for setting most background properties at the same place in the style sheet.",restrictions:["enum","image","color","position","length","repeat","percentage","box"]},{name:"background-attachment",values:[{name:"fixed",description:"The background is fixed with regard to the viewport. In paged media where there is no viewport, a 'fixed' background is fixed with respect to the page box and therefore replicated on every page."},{name:"local",description:"The background is fixed with regard to the element’s contents: if the element has a scrolling mechanism, the background scrolls with the element’s contents."},{name:"scroll",description:"The background is fixed with regard to the element itself and does not scroll with its contents. (It is effectively attached to the element’s border.)"}],syntax:"<attachment>#",relevance:54,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/background-attachment"}],description:"Specifies whether the background images are fixed with regard to the viewport ('fixed') or scroll along with the element ('scroll') or its contents ('local').",restrictions:["enum"]},{name:"background-blend-mode",browsers:["E79","FF30","S8","C35","O22"],values:[{name:"normal",description:"Default attribute which specifies no blending"},{name:"multiply",description:"The source color is multiplied by the destination color and replaces the destination."},{name:"screen",description:"Multiplies the complements of the backdrop and source color values, then complements the result."},{name:"overlay",description:"Multiplies or screens the colors, depending on the backdrop color value."},{name:"darken",description:"Selects the darker of the backdrop and source colors."},{name:"lighten",description:"Selects the lighter of the backdrop and source colors."},{name:"color-dodge",description:"Brightens the backdrop color to reflect the source color."},{name:"color-burn",description:"Darkens the backdrop color to reflect the source color."},{name:"hard-light",description:"Multiplies or screens the colors, depending on the source color value."},{name:"soft-light",description:"Darkens or lightens the colors, depending on the source color value."},{name:"difference",description:"Subtracts the darker of the two constituent colors from the lighter color.."},{name:"exclusion",description:"Produces an effect similar to that of the Difference mode but lower in contrast."},{name:"hue",browsers:["E79","FF30","S8","C35","O22"],description:"Creates a color with the hue of the source color and the saturation and luminosity of the backdrop color."},{name:"saturation",browsers:["E79","FF30","S8","C35","O22"],description:"Creates a color with the saturation of the source color and the hue and luminosity of the backdrop color."},{name:"color",browsers:["E79","FF30","S8","C35","O22"],description:"Creates a color with the hue and saturation of the source color and the luminosity of the backdrop color."},{name:"luminosity",browsers:["E79","FF30","S8","C35","O22"],description:"Creates a color with the luminosity of the source color and the hue and saturation of the backdrop color."}],syntax:"<blend-mode>#",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/background-blend-mode"}],description:"Defines the blending mode of each background layer.",restrictions:["enum"]},{name:"background-clip",syntax:"<box>#",relevance:68,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/background-clip"}],description:"Determines the background painting area.",restrictions:["box"]},{name:"background-color",syntax:"<color>",relevance:94,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/background-color"}],description:"Sets the background color of an element.",restrictions:["color"]},{name:"background-image",values:[{name:"none",description:"Counts as an image layer but draws nothing."}],syntax:"<bg-image>#",relevance:89,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/background-image"}],description:"Sets the background image(s) of an element.",restrictions:["image","enum"]},{name:"background-origin",syntax:"<box>#",relevance:54,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/background-origin"}],description:"For elements rendered as a single box, specifies the background positioning area. For elements rendered as multiple boxes (e.g., inline boxes on several lines, boxes on several pages) specifies which boxes 'box-decoration-break' operates on to determine the background positioning area(s).",restrictions:["box"]},{name:"background-position",syntax:"<bg-position>#",relevance:88,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/background-position"}],description:"Specifies the initial position of the background image(s) (after any resizing) within their corresponding background positioning area.",restrictions:["position","length","percentage"]},{name:"background-position-x",values:[{name:"center",description:"Equivalent to '50%' ('left 50%') for the horizontal position if the horizontal position is not otherwise specified, or '50%' ('top 50%') for the vertical position if it is."},{name:"left",description:"Equivalent to '0%' for the horizontal position if one or two values are given, otherwise specifies the left edge as the origin for the next offset."},{name:"right",description:"Equivalent to '100%' for the horizontal position if one or two values are given, otherwise specifies the right edge as the origin for the next offset."}],status:"experimental",syntax:"[ center | [ [ left | right | x-start | x-end ]? <length-percentage>? ]! ]#",relevance:54,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/background-position-x"}],description:"If background images have been specified, this property specifies their initial position (after any resizing) within their corresponding background positioning area.",restrictions:["length","percentage"]},{name:"background-position-y",values:[{name:"bottom",description:"Equivalent to '100%' for the vertical position if one or two values are given, otherwise specifies the bottom edge as the origin for the next offset."},{name:"center",description:"Equivalent to '50%' ('left 50%') for the horizontal position if the horizontal position is not otherwise specified, or '50%' ('top 50%') for the vertical position if it is."},{name:"top",description:"Equivalent to '0%' for the vertical position if one or two values are given, otherwise specifies the top edge as the origin for the next offset."}],status:"experimental",syntax:"[ center | [ [ top | bottom | y-start | y-end ]? <length-percentage>? ]! ]#",relevance:53,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/background-position-y"}],description:"If background images have been specified, this property specifies their initial position (after any resizing) within their corresponding background positioning area.",restrictions:["length","percentage"]},{name:"background-repeat",values:[],syntax:"<repeat-style>#",relevance:86,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/background-repeat"}],description:"Specifies how background images are tiled after they have been sized and positioned.",restrictions:["repeat"]},{name:"background-size",values:[{name:"auto",description:"Resolved by using the image’s intrinsic ratio and the size of the other dimension, or failing that, using the image’s intrinsic size, or failing that, treating it as 100%."},{name:"contain",description:"Scale the image, while preserving its intrinsic aspect ratio (if any), to the largest size such that both its width and its height can fit inside the background positioning area."},{name:"cover",description:"Scale the image, while preserving its intrinsic aspect ratio (if any), to the smallest size such that both its width and its height can completely cover the background positioning area."}],syntax:"<bg-size>#",relevance:86,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/background-size"}],description:"Specifies the size of the background images.",restrictions:["length","percentage"]},{name:"behavior",browsers:["IE6"],relevance:50,description:"IE only. Used to extend behaviors of the browser.",restrictions:["url"]},{name:"block-size",browsers:["E79","FF41","S12.1","C57","O44"],values:[{name:"auto",description:"Depends on the values of other properties."}],syntax:"<'width'>",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/block-size"}],description:"Size of an element in the direction opposite that of the direction specified by 'writing-mode'.",restrictions:["length","percentage"]},{name:"border",syntax:"<line-width> || <line-style> || <color>",relevance:96,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/border"}],description:"Shorthand property for setting border width, style, and color.",restrictions:["length","line-width","line-style","color"]},{name:"border-block-end",browsers:["E79","FF41","S12.1","C69","O56"],syntax:"<'border-top-width'> || <'border-top-style'> || <color>",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/border-block-end"}],description:"Logical 'border-bottom'. Mapping depends on the parent element’s 'writing-mode', 'direction', and 'text-orientation'.",restrictions:["length","line-width","line-style","color"]},{name:"border-block-start",browsers:["E79","FF41","S12.1","C69","O56"],syntax:"<'border-top-width'> || <'border-top-style'> || <color>",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/border-block-start"}],description:"Logical 'border-top'. Mapping depends on the parent element’s 'writing-mode', 'direction', and 'text-orientation'.",restrictions:["length","line-width","line-style","color"]},{name:"border-block-end-color",browsers:["E79","FF41","S12.1","C69","O56"],syntax:"<'border-top-color'>",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/border-block-end-color"}],description:"Logical 'border-bottom-color'. Mapping depends on the parent element’s 'writing-mode', 'direction', and 'text-orientation'.",restrictions:["color"]},{name:"border-block-start-color",browsers:["E79","FF41","S12.1","C69","O56"],syntax:"<'border-top-color'>",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/border-block-start-color"}],description:"Logical 'border-top-color'. Mapping depends on the parent element’s 'writing-mode', 'direction', and 'text-orientation'.",restrictions:["color"]},{name:"border-block-end-style",browsers:["E79","FF41","S12.1","C69","O56"],syntax:"<'border-top-style'>",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/border-block-end-style"}],description:"Logical 'border-bottom-style'. Mapping depends on the parent element’s 'writing-mode', 'direction', and 'text-orientation'.",restrictions:["line-style"]},{name:"border-block-start-style",browsers:["E79","FF41","S12.1","C69","O56"],syntax:"<'border-top-style'>",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/border-block-start-style"}],description:"Logical 'border-top-style'. Mapping depends on the parent element’s 'writing-mode', 'direction', and 'text-orientation'.",restrictions:["line-style"]},{name:"border-block-end-width",browsers:["E79","FF41","S12.1","C69","O56"],syntax:"<'border-top-width'>",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/border-block-end-width"}],description:"Logical 'border-bottom-width'. Mapping depends on the parent element’s 'writing-mode', 'direction', and 'text-orientation'.",restrictions:["length","line-width"]},{name:"border-block-start-width",browsers:["E79","FF41","S12.1","C69","O56"],syntax:"<'border-top-width'>",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/border-block-start-width"}],description:"Logical 'border-top-width'. Mapping depends on the parent element’s 'writing-mode', 'direction', and 'text-orientation'.",restrictions:["length","line-width"]},{name:"border-bottom",syntax:"<line-width> || <line-style> || <color>",relevance:89,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/border-bottom"}],description:"Shorthand property for setting border width, style and color.",restrictions:["length","line-width","line-style","color"]},{name:"border-bottom-color",syntax:"<'border-top-color'>",relevance:71,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/border-bottom-color"}],description:"Sets the color of the bottom border.",restrictions:["color"]},{name:"border-bottom-left-radius",syntax:"<length-percentage>{1,2}",relevance:75,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/border-bottom-left-radius"}],description:"Defines the radii of the bottom left outer border edge.",restrictions:["length","percentage"]},{name:"border-bottom-right-radius",syntax:"<length-percentage>{1,2}",relevance:74,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/border-bottom-right-radius"}],description:"Defines the radii of the bottom right outer border edge.",restrictions:["length","percentage"]},{name:"border-bottom-style",syntax:"<line-style>",relevance:58,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/border-bottom-style"}],description:"Sets the style of the bottom border.",restrictions:["line-style"]},{name:"border-bottom-width",syntax:"<line-width>",relevance:62,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/border-bottom-width"}],description:"Sets the thickness of the bottom border.",restrictions:["length","line-width"]},{name:"border-collapse",values:[{name:"collapse",description:"Selects the collapsing borders model."},{name:"separate",description:"Selects the separated borders border model."}],syntax:"collapse | separate",relevance:74,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/border-collapse"}],description:"Selects a table's border model.",restrictions:["enum"]},{name:"border-color",values:[],syntax:"<color>{1,4}",relevance:87,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/border-color"}],description:"The color of the border around all four edges of an element.",restrictions:["color"]},{name:"border-image",values:[{name:"auto",description:"If 'auto' is specified then the border image width is the intrinsic width or height (whichever is applicable) of the corresponding image slice. If the image does not have the required intrinsic dimension then the corresponding border-width is used instead."},{name:"fill",description:"Causes the middle part of the border-image to be preserved."},{name:"none",description:"Use the border styles."},{name:"repeat",description:"The image is tiled (repeated) to fill the area."},{name:"round",description:"The image is tiled (repeated) to fill the area. If it does not fill the area with a whole number of tiles, the image is rescaled so that it does."},{name:"space",description:"The image is tiled (repeated) to fill the area. If it does not fill the area with a whole number of tiles, the extra space is distributed around the tiles."},{name:"stretch",description:"The image is stretched to fill the area."},{name:"url()"}],syntax:"<'border-image-source'> || <'border-image-slice'> [ / <'border-image-width'> | / <'border-image-width'>? / <'border-image-outset'> ]? || <'border-image-repeat'>",relevance:53,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/border-image"}],description:"Shorthand property for setting 'border-image-source', 'border-image-slice', 'border-image-width', 'border-image-outset' and 'border-image-repeat'. Omitted values are set to their initial values.",restrictions:["length","percentage","number","url","enum"]},{name:"border-image-outset",syntax:"[ <length> | <number> ]{1,4}",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/border-image-outset"}],description:"The values specify the amount by which the border image area extends beyond the border box on the top, right, bottom, and left sides respectively. If the fourth value is absent, it is the same as the second. If the third one is also absent, it is the same as the first. If the second one is also absent, it is the same as the first. Numbers represent multiples of the corresponding border-width.",restrictions:["length","number"]},{name:"border-image-repeat",values:[{name:"repeat",description:"The image is tiled (repeated) to fill the area."},{name:"round",description:"The image is tiled (repeated) to fill the area. If it does not fill the area with a whole number of tiles, the image is rescaled so that it does."},{name:"space",description:"The image is tiled (repeated) to fill the area. If it does not fill the area with a whole number of tiles, the extra space is distributed around the tiles."},{name:"stretch",description:"The image is stretched to fill the area."}],syntax:"[ stretch | repeat | round | space ]{1,2}",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/border-image-repeat"}],description:"Specifies how the images for the sides and the middle part of the border image are scaled and tiled. If the second keyword is absent, it is assumed to be the same as the first.",restrictions:["enum"]},{name:"border-image-slice",values:[{name:"fill",description:"Causes the middle part of the border-image to be preserved."}],syntax:"<number-percentage>{1,4} && fill?",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/border-image-slice"}],description:"Specifies inward offsets from the top, right, bottom, and left edges of the image, dividing it into nine regions: four corners, four edges and a middle.",restrictions:["number","percentage"]},{name:"border-image-source",values:[{name:"none",description:"Use the border styles."}],syntax:"none | <image>",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/border-image-source"}],description:"Specifies an image to use instead of the border styles given by the 'border-style' properties and as an additional background layer for the element. If the value is 'none' or if the image cannot be displayed, the border styles will be used.",restrictions:["image"]},{name:"border-image-width",values:[{name:"auto",description:"The border image width is the intrinsic width or height (whichever is applicable) of the corresponding image slice. If the image does not have the required intrinsic dimension then the corresponding border-width is used instead."}],syntax:"[ <length-percentage> | <number> | auto ]{1,4}",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/border-image-width"}],description:"The four values of 'border-image-width' specify offsets that are used to divide the border image area into nine parts. They represent inward distances from the top, right, bottom, and left sides of the area, respectively.",restrictions:["length","percentage","number"]},{name:"border-inline-end",browsers:["E79","FF41","S12.1","C69","O56"],syntax:"<'border-top-width'> || <'border-top-style'> || <color>",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/border-inline-end"}],description:"Logical 'border-right'. Mapping depends on the parent element’s 'writing-mode', 'direction', and 'text-orientation'.",restrictions:["length","line-width","line-style","color"]},{name:"border-inline-start",browsers:["E79","FF41","S12.1","C69","O56"],syntax:"<'border-top-width'> || <'border-top-style'> || <color>",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/border-inline-start"}],description:"Logical 'border-left'. Mapping depends on the parent element’s 'writing-mode', 'direction', and 'text-orientation'.",restrictions:["length","line-width","line-style","color"]},{name:"border-inline-end-color",browsers:["E79","FF41","S12.1","C69","O56"],syntax:"<'border-top-color'>",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/border-inline-end-color"}],description:"Logical 'border-right-color'. Mapping depends on the parent element’s 'writing-mode', 'direction', and 'text-orientation'.",restrictions:["color"]},{name:"border-inline-start-color",browsers:["E79","FF41","S12.1","C69","O56"],syntax:"<'border-top-color'>",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/border-inline-start-color"}],description:"Logical 'border-left-color'. Mapping depends on the parent element’s 'writing-mode', 'direction', and 'text-orientation'.",restrictions:["color"]},{name:"border-inline-end-style",browsers:["E79","FF41","S12.1","C69","O56"],syntax:"<'border-top-style'>",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/border-inline-end-style"}],description:"Logical 'border-right-style'. Mapping depends on the parent element’s 'writing-mode', 'direction', and 'text-orientation'.",restrictions:["line-style"]},{name:"border-inline-start-style",browsers:["E79","FF41","S12.1","C69","O56"],syntax:"<'border-top-style'>",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/border-inline-start-style"}],description:"Logical 'border-left-style'. Mapping depends on the parent element’s 'writing-mode', 'direction', and 'text-orientation'.",restrictions:["line-style"]},{name:"border-inline-end-width",browsers:["E79","FF41","S12.1","C69","O56"],syntax:"<'border-top-width'>",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/border-inline-end-width"}],description:"Logical 'border-right-width'. Mapping depends on the parent element’s 'writing-mode', 'direction', and 'text-orientation'.",restrictions:["length","line-width"]},{name:"border-inline-start-width",browsers:["E79","FF41","S12.1","C69","O56"],syntax:"<'border-top-width'>",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/border-inline-start-width"}],description:"Logical 'border-left-width'. Mapping depends on the parent element’s 'writing-mode', 'direction', and 'text-orientation'.",restrictions:["length","line-width"]},{name:"border-left",syntax:"<line-width> || <line-style> || <color>",relevance:83,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/border-left"}],description:"Shorthand property for setting border width, style and color",restrictions:["length","line-width","line-style","color"]},{name:"border-left-color",syntax:"<color>",relevance:65,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/border-left-color"}],description:"Sets the color of the left border.",restrictions:["color"]},{name:"border-left-style",syntax:"<line-style>",relevance:53,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/border-left-style"}],description:"Sets the style of the left border.",restrictions:["line-style"]},{name:"border-left-width",syntax:"<line-width>",relevance:58,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/border-left-width"}],description:"Sets the thickness of the left border.",restrictions:["length","line-width"]},{name:"border-radius",syntax:"<length-percentage>{1,4} [ / <length-percentage>{1,4} ]?",relevance:92,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/border-radius"}],description:"Defines the radii of the outer border edge.",restrictions:["length","percentage"]},{name:"border-right",syntax:"<line-width> || <line-style> || <color>",relevance:81,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/border-right"}],description:"Shorthand property for setting border width, style and color",restrictions:["length","line-width","line-style","color"]},{name:"border-right-color",syntax:"<color>",relevance:64,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/border-right-color"}],description:"Sets the color of the right border.",restrictions:["color"]},{name:"border-right-style",syntax:"<line-style>",relevance:53,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/border-right-style"}],description:"Sets the style of the right border.",restrictions:["line-style"]},{name:"border-right-width",syntax:"<line-width>",relevance:59,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/border-right-width"}],description:"Sets the thickness of the right border.",restrictions:["length","line-width"]},{name:"border-spacing",syntax:"<length> <length>?",relevance:68,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/border-spacing"}],description:"The lengths specify the distance that separates adjoining cell borders. If one length is specified, it gives both the horizontal and vertical spacing. If two are specified, the first gives the horizontal spacing and the second the vertical spacing. Lengths may not be negative.",restrictions:["length"]},{name:"border-style",values:[],syntax:"<line-style>{1,4}",relevance:81,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/border-style"}],description:"The style of the border around edges of an element.",restrictions:["line-style"]},{name:"border-top",syntax:"<line-width> || <line-style> || <color>",relevance:88,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/border-top"}],description:"Shorthand property for setting border width, style and color",restrictions:["length","line-width","line-style","color"]},{name:"border-top-color",syntax:"<color>",relevance:72,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/border-top-color"}],description:"Sets the color of the top border.",restrictions:["color"]},{name:"border-top-left-radius",syntax:"<length-percentage>{1,2}",relevance:75,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/border-top-left-radius"}],description:"Defines the radii of the top left outer border edge.",restrictions:["length","percentage"]},{name:"border-top-right-radius",syntax:"<length-percentage>{1,2}",relevance:75,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/border-top-right-radius"}],description:"Defines the radii of the top right outer border edge.",restrictions:["length","percentage"]},{name:"border-top-style",syntax:"<line-style>",relevance:58,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/border-top-style"}],description:"Sets the style of the top border.",restrictions:["line-style"]},{name:"border-top-width",syntax:"<line-width>",relevance:61,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/border-top-width"}],description:"Sets the thickness of the top border.",restrictions:["length","line-width"]},{name:"border-width",values:[],syntax:"<line-width>{1,4}",relevance:82,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/border-width"}],description:"Shorthand that sets the four 'border-*-width' properties. If it has four values, they set top, right, bottom and left in that order. If left is missing, it is the same as right; if bottom is missing, it is the same as top; if right is missing, it is the same as top.",restrictions:["length","line-width"]},{name:"bottom",values:[{name:"auto",description:"For non-replaced elements, the effect of this value depends on which of related properties have the value 'auto' as well"}],syntax:"<length> | <percentage> | auto",relevance:91,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/bottom"}],description:"Specifies how far an absolutely positioned box's bottom margin edge is offset above the bottom edge of the box's 'containing block'.",restrictions:["length","percentage"]},{name:"box-decoration-break",browsers:["E79","FF32","S7","C22","O15"],values:[{name:"clone",description:"Each box is independently wrapped with the border and padding."},{name:"slice",description:"The effect is as though the element were rendered with no breaks present, and then sliced by the breaks afterward."}],syntax:"slice | clone",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/box-decoration-break"}],description:"Specifies whether individual boxes are treated as broken pieces of one continuous box, or whether each box is individually wrapped with the border and padding.",restrictions:["enum"]},{name:"box-shadow",values:[{name:"inset",description:"Changes the drop shadow from an outer shadow (one that shadows the box onto the canvas, as if it were lifted above the canvas) to an inner shadow (one that shadows the canvas onto the box, as if the box were cut out of the canvas and shifted behind it)."},{name:"none",description:"No shadow."}],syntax:"none | <shadow>#",relevance:90,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/box-shadow"}],description:"Attaches one or more drop-shadows to the box. The property is a comma-separated list of shadows, each specified by 2-4 length values, an optional color, and an optional 'inset' keyword. Omitted lengths are 0; omitted colors are a user agent chosen color.",restrictions:["length","color","enum"]},{name:"box-sizing",values:[{name:"border-box",description:"The specified width and height (and respective min/max properties) on this element determine the border box of the element."},{name:"content-box",description:"Behavior of width and height as specified by CSS2.1. The specified width and height (and respective min/max properties) apply to the width and height respectively of the content box of the element."}],syntax:"content-box | border-box",relevance:93,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/box-sizing"}],description:"Specifies the behavior of the 'width' and 'height' properties.",restrictions:["enum"]},{name:"break-after",values:[{name:"always",description:"Always force a page break before/after the generated box."},{name:"auto",description:"Neither force nor forbid a page/column break before/after the principal box."},{name:"avoid",description:"Avoid a break before/after the principal box."},{name:"avoid-column",description:"Avoid a column break before/after the principal box."},{name:"avoid-page",description:"Avoid a page break before/after the principal box."},{name:"column",description:"Always force a column break before/after the principal box."},{name:"left",description:"Force one or two page breaks before/after the generated box so that the next page is formatted as a left page."},{name:"page",description:"Always force a page break before/after the principal box."},{name:"right",description:"Force one or two page breaks before/after the generated box so that the next page is formatted as a right page."}],syntax:"auto | avoid | always | all | avoid-page | page | left | right | recto | verso | avoid-column | column | avoid-region | region",relevance:50,description:"Describes the page/column/region break behavior after the generated box.",restrictions:["enum"]},{name:"break-before",values:[{name:"always",description:"Always force a page break before/after the generated box."},{name:"auto",description:"Neither force nor forbid a page/column break before/after the principal box."},{name:"avoid",description:"Avoid a break before/after the principal box."},{name:"avoid-column",description:"Avoid a column break before/after the principal box."},{name:"avoid-page",description:"Avoid a page break before/after the principal box."},{name:"column",description:"Always force a column break before/after the principal box."},{name:"left",description:"Force one or two page breaks before/after the generated box so that the next page is formatted as a left page."},{name:"page",description:"Always force a page break before/after the principal box."},{name:"right",description:"Force one or two page breaks before/after the generated box so that the next page is formatted as a right page."}],syntax:"auto | avoid | always | all | avoid-page | page | left | right | recto | verso | avoid-column | column | avoid-region | region",relevance:50,description:"Describes the page/column/region break behavior before the generated box.",restrictions:["enum"]},{name:"break-inside",values:[{name:"auto",description:"Impose no additional breaking constraints within the box."},{name:"avoid",description:"Avoid breaks within the box."},{name:"avoid-column",description:"Avoid a column break within the box."},{name:"avoid-page",description:"Avoid a page break within the box."}],syntax:"auto | avoid | avoid-page | avoid-column | avoid-region",relevance:51,description:"Describes the page/column/region break behavior inside the principal box.",restrictions:["enum"]},{name:"caption-side",values:[{name:"bottom",description:"Positions the caption box below the table box."},{name:"top",description:"Positions the caption box above the table box."}],syntax:"top | bottom | block-start | block-end | inline-start | inline-end",relevance:52,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/caption-side"}],description:"Specifies the position of the caption box with respect to the table box.",restrictions:["enum"]},{name:"caret-color",browsers:["E79","FF53","S11.1","C57","O44"],values:[{name:"auto",description:"The user agent selects an appropriate color for the caret. This is generally currentcolor, but the user agent may choose a different color to ensure good visibility and contrast with the surrounding content, taking into account the value of currentcolor, the background, shadows, and other factors."}],syntax:"auto | <color>",relevance:52,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/caret-color"}],description:"Controls the color of the text insertion indicator.",restrictions:["color","enum"]},{name:"clear",values:[{name:"both",description:"The clearance of the generated box is set to the amount necessary to place the top border edge below the bottom outer edge of any right-floating and left-floating boxes that resulted from elements earlier in the source document."},{name:"left",description:"The clearance of the generated box is set to the amount necessary to place the top border edge below the bottom outer edge of any left-floating boxes that resulted from elements earlier in the source document."},{name:"none",description:"No constraint on the box's position with respect to floats."},{name:"right",description:"The clearance of the generated box is set to the amount necessary to place the top border edge below the bottom outer edge of any right-floating boxes that resulted from elements earlier in the source document."}],syntax:"none | left | right | both | inline-start | inline-end",relevance:85,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/clear"}],description:"Indicates which sides of an element's box(es) may not be adjacent to an earlier floating box. The 'clear' property does not consider floats inside the element itself or in other block formatting contexts.",restrictions:["enum"]},{name:"clip",values:[{name:"auto",description:"The element does not clip."},{name:"rect()",description:"Specifies offsets from the edges of the border box."}],syntax:"<shape> | auto",relevance:74,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/clip"}],description:"Deprecated. Use the 'clip-path' property when support allows. Defines the visible portion of an element’s box.",restrictions:["enum"]},{name:"clip-path",values:[{name:"none",description:"No clipping path gets created."},{name:"url()",description:"References a <clipPath> element to create a clipping path."}],syntax:"<clip-source> | [ <basic-shape> || <geometry-box> ] | none",relevance:57,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/clip-path"}],description:"Specifies a clipping path where everything inside the path is visible and everything outside is clipped out.",restrictions:["url","shape","geometry-box","enum"]},{name:"clip-rule",browsers:["E","C5","FF3","IE10","O9","S6"],values:[{name:"evenodd",description:"Determines the ‘insideness’ of a point on the canvas by drawing a ray from that point to infinity in any direction and counting the number of path segments from the given shape that the ray crosses."},{name:"nonzero",description:"Determines the ‘insideness’ of a point on the canvas by drawing a ray from that point to infinity in any direction and then examining the places where a segment of the shape crosses the ray."}],relevance:50,description:"Indicates the algorithm which is to be used to determine what parts of the canvas are included inside the shape.",restrictions:["enum"]},{name:"color",syntax:"<color>",relevance:95,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/color"}],description:"Sets the color of an element's text",restrictions:["color"]},{name:"color-interpolation-filters",browsers:["E","C5","FF3","IE10","O9","S6"],values:[{name:"auto",description:"Color operations are not required to occur in a particular color space."},{name:"linearRGB",description:"Color operations should occur in the linearized RGB color space."},{name:"sRGB",description:"Color operations should occur in the sRGB color space."}],relevance:50,description:"Specifies the color space for imaging operations performed via filter effects.",restrictions:["enum"]},{name:"column-count",values:[{name:"auto",description:"Determines the number of columns by the 'column-width' property and the element width."}],syntax:"<integer> | auto",relevance:53,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/column-count"}],description:"Describes the optimal number of columns into which the content of the element will be flowed.",restrictions:["integer","enum"]},{name:"column-fill",values:[{name:"auto",description:"Fills columns sequentially."},{name:"balance",description:"Balance content equally between columns, if possible."}],syntax:"auto | balance | balance-all",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/column-fill"}],description:"In continuous media, this property will only be consulted if the length of columns has been constrained. Otherwise, columns will automatically be balanced.",restrictions:["enum"]},{name:"column-gap",values:[{name:"normal",description:"User agent specific and typically equivalent to 1em."}],syntax:"normal | <length-percentage>",relevance:55,description:"Sets the gap between columns. If there is a column rule between columns, it will appear in the middle of the gap.",restrictions:["length","enum"]},{name:"column-rule",syntax:"<'column-rule-width'> || <'column-rule-style'> || <'column-rule-color'>",relevance:51,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/column-rule"}],description:"Shorthand for setting 'column-rule-width', 'column-rule-style', and 'column-rule-color' at the same place in the style sheet. Omitted values are set to their initial values.",restrictions:["length","line-width","line-style","color"]},{name:"column-rule-color",syntax:"<color>",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/column-rule-color"}],description:"Sets the color of the column rule",restrictions:["color"]},{name:"column-rule-style",syntax:"<'border-style'>",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/column-rule-style"}],description:"Sets the style of the rule between columns of an element.",restrictions:["line-style"]},{name:"column-rule-width",syntax:"<'border-width'>",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/column-rule-width"}],description:"Sets the width of the rule between columns. Negative values are not allowed.",restrictions:["length","line-width"]},{name:"columns",values:[{name:"auto",description:"The width depends on the values of other properties."}],syntax:"<'column-width'> || <'column-count'>",relevance:51,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/columns"}],description:"A shorthand property which sets both 'column-width' and 'column-count'.",restrictions:["length","integer","enum"]},{name:"column-span",values:[{name:"all",description:"The element spans across all columns. Content in the normal flow that appears before the element is automatically balanced across all columns before the element appear."},{name:"none",description:"The element does not span multiple columns."}],syntax:"none | all",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/column-span"}],description:"Describes the page/column break behavior after the generated box.",restrictions:["enum"]},{name:"column-width",values:[{name:"auto",description:"The width depends on the values of other properties."}],syntax:"<length> | auto",relevance:51,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/column-width"}],description:"Describes the width of columns in multicol elements.",restrictions:["length","enum"]},{name:"contain",browsers:["E79","FF69","C52","O40"],values:[{name:"none",description:"Indicates that the property has no effect."},{name:"strict",description:"Turns on all forms of containment for the element."},{name:"content",description:"All containment rules except size are applied to the element."},{name:"size",description:"For properties that can have effects on more than just an element and its descendants, those effects don't escape the containing element."},{name:"layout",description:"Turns on layout containment for the element."},{name:"style",description:"Turns on style containment for the element."},{name:"paint",description:"Turns on paint containment for the element."}],syntax:"none | strict | content | [ size || layout || style || paint ]",relevance:58,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/contain"}],description:"Indicates that an element and its contents are, as much as possible, independent of the rest of the document tree.",restrictions:["enum"]},{name:"content",values:[{name:"attr()",description:"The attr(n) function returns as a string the value of attribute n for the subject of the selector."},{name:"counter(name)",description:"Counters are denoted by identifiers (see the 'counter-increment' and 'counter-reset' properties)."},{name:"icon",description:"The (pseudo-)element is replaced in its entirety by the resource referenced by its 'icon' property, and treated as a replaced element."},{name:"none",description:"On elements, this inhibits the children of the element from being rendered as children of this element, as if the element was empty. On pseudo-elements it causes the pseudo-element to have no content."},{name:"normal",description:"See http://www.w3.org/TR/css3-content/#content for computation rules."},{name:"url()"}],syntax:"normal | none | [ <content-replacement> | <content-list> ] [/ [ <string> | <counter> ]+ ]?",relevance:90,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/content"}],description:"Determines which page-based occurrence of a given element is applied to a counter or string value.",restrictions:["string","url"]},{name:"counter-increment",values:[{name:"none",description:"This element does not alter the value of any counters."}],syntax:"[ <counter-name> <integer>? ]+ | none",relevance:53,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/counter-increment"}],description:"Manipulate the value of existing counters.",restrictions:["identifier","integer"]},{name:"counter-reset",values:[{name:"none",description:"The counter is not modified."}],syntax:"[ <counter-name> <integer>? | <reversed-counter-name> <integer>? ]+ | none",relevance:53,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/counter-reset"}],description:"Property accepts one or more names of counters (identifiers), each one optionally followed by an integer. The integer gives the value that the counter is set to on each occurrence of the element.",restrictions:["identifier","integer"]},{name:"cursor",values:[{name:"alias",description:"Indicates an alias of/shortcut to something is to be created. Often rendered as an arrow with a small curved arrow next to it."},{name:"all-scroll",description:"Indicates that the something can be scrolled in any direction. Often rendered as arrows pointing up, down, left, and right with a dot in the middle."},{name:"auto",description:"The UA determines the cursor to display based on the current context."},{name:"cell",description:"Indicates that a cell or set of cells may be selected. Often rendered as a thick plus-sign with a dot in the middle."},{name:"col-resize",description:"Indicates that the item/column can be resized horizontally. Often rendered as arrows pointing left and right with a vertical bar separating them."},{name:"context-menu",description:"A context menu is available for the object under the cursor. Often rendered as an arrow with a small menu-like graphic next to it."},{name:"copy",description:"Indicates something is to be copied. Often rendered as an arrow with a small plus sign next to it."},{name:"crosshair",description:"A simple crosshair (e.g., short line segments resembling a '+' sign). Often used to indicate a two dimensional bitmap selection mode."},{name:"default",description:"The platform-dependent default cursor. Often rendered as an arrow."},{name:"e-resize",description:"Indicates that east edge is to be moved."},{name:"ew-resize",description:"Indicates a bidirectional east-west resize cursor."},{name:"grab",description:"Indicates that something can be grabbed."},{name:"grabbing",description:"Indicates that something is being grabbed."},{name:"help",description:"Help is available for the object under the cursor. Often rendered as a question mark or a balloon."},{name:"move",description:"Indicates something is to be moved."},{name:"-moz-grab",description:"Indicates that something can be grabbed."},{name:"-moz-grabbing",description:"Indicates that something is being grabbed."},{name:"-moz-zoom-in",description:"Indicates that something can be zoomed (magnified) in."},{name:"-moz-zoom-out",description:"Indicates that something can be zoomed (magnified) out."},{name:"ne-resize",description:"Indicates that movement starts from north-east corner."},{name:"nesw-resize",description:"Indicates a bidirectional north-east/south-west cursor."},{name:"no-drop",description:"Indicates that the dragged item cannot be dropped at the current cursor location. Often rendered as a hand or pointer with a small circle with a line through it."},{name:"none",description:"No cursor is rendered for the element."},{name:"not-allowed",description:"Indicates that the requested action will not be carried out. Often rendered as a circle with a line through it."},{name:"n-resize",description:"Indicates that north edge is to be moved."},{name:"ns-resize",description:"Indicates a bidirectional north-south cursor."},{name:"nw-resize",description:"Indicates that movement starts from north-west corner."},{name:"nwse-resize",description:"Indicates a bidirectional north-west/south-east cursor."},{name:"pointer",description:"The cursor is a pointer that indicates a link."},{name:"progress",description:"A progress indicator. The program is performing some processing, but is different from 'wait' in that the user may still interact with the program. Often rendered as a spinning beach ball, or an arrow with a watch or hourglass."},{name:"row-resize",description:"Indicates that the item/row can be resized vertically. Often rendered as arrows pointing up and down with a horizontal bar separating them."},{name:"se-resize",description:"Indicates that movement starts from south-east corner."},{name:"s-resize",description:"Indicates that south edge is to be moved."},{name:"sw-resize",description:"Indicates that movement starts from south-west corner."},{name:"text",description:"Indicates text that may be selected. Often rendered as a vertical I-beam."},{name:"vertical-text",description:"Indicates vertical-text that may be selected. Often rendered as a horizontal I-beam."},{name:"wait",description:"Indicates that the program is busy and the user should wait. Often rendered as a watch or hourglass."},{name:"-webkit-grab",description:"Indicates that something can be grabbed."},{name:"-webkit-grabbing",description:"Indicates that something is being grabbed."},{name:"-webkit-zoom-in",description:"Indicates that something can be zoomed (magnified) in."},{name:"-webkit-zoom-out",description:"Indicates that something can be zoomed (magnified) out."},{name:"w-resize",description:"Indicates that west edge is to be moved."},{name:"zoom-in",description:"Indicates that something can be zoomed (magnified) in."},{name:"zoom-out",description:"Indicates that something can be zoomed (magnified) out."}],syntax:"[ [ <url> [ <x> <y> ]? , ]* [ auto | default | none | context-menu | help | pointer | progress | wait | cell | crosshair | text | vertical-text | alias | copy | move | no-drop | not-allowed | e-resize | n-resize | ne-resize | nw-resize | s-resize | se-resize | sw-resize | w-resize | ew-resize | ns-resize | nesw-resize | nwse-resize | col-resize | row-resize | all-scroll | zoom-in | zoom-out | grab | grabbing ] ]",relevance:92,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/cursor"}],description:"Allows control over cursor appearance in an element",restrictions:["url","number","enum"]},{name:"direction",values:[{name:"ltr",description:"Left-to-right direction."},{name:"rtl",description:"Right-to-left direction."}],syntax:"ltr | rtl",relevance:70,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/direction"}],description:"Specifies the inline base direction or directionality of any bidi paragraph, embedding, isolate, or override established by the box. Note: for HTML content use the 'dir' attribute and 'bdo' element rather than this property.",restrictions:["enum"]},{name:"display",values:[{name:"block",description:"The element generates a block-level box"},{name:"contents",description:"The element itself does not generate any boxes, but its children and pseudo-elements still generate boxes as normal."},{name:"flex",description:"The element generates a principal flex container box and establishes a flex formatting context."},{name:"flexbox",description:"The element lays out its contents using flow layout (block-and-inline layout). Standardized as 'flex'."},{name:"flow-root",description:"The element generates a block container box, and lays out its contents using flow layout."},{name:"grid",description:"The element generates a principal grid container box, and establishes a grid formatting context."},{name:"inline",description:"The element generates an inline-level box."},{name:"inline-block",description:"A block box, which itself is flowed as a single inline box, similar to a replaced element. The inside of an inline-block is formatted as a block box, and the box itself is formatted as an inline box."},{name:"inline-flex",description:"Inline-level flex container."},{name:"inline-flexbox",description:"Inline-level flex container. Standardized as 'inline-flex'"},{name:"inline-table",description:"Inline-level table wrapper box containing table box."},{name:"list-item",description:"One or more block boxes and one marker box."},{name:"-moz-box",description:"The element lays out its contents using flow layout (block-and-inline layout). Standardized as 'flex'."},{name:"-moz-deck"},{name:"-moz-grid"},{name:"-moz-grid-group"},{name:"-moz-grid-line"},{name:"-moz-groupbox"},{name:"-moz-inline-box",description:"Inline-level flex container. Standardized as 'inline-flex'"},{name:"-moz-inline-grid"},{name:"-moz-inline-stack"},{name:"-moz-marker"},{name:"-moz-popup"},{name:"-moz-stack"},{name:"-ms-flexbox",description:"The element lays out its contents using flow layout (block-and-inline layout). Standardized as 'flex'."},{name:"-ms-grid",description:"The element generates a principal grid container box, and establishes a grid formatting context."},{name:"-ms-inline-flexbox",description:"Inline-level flex container. Standardized as 'inline-flex'"},{name:"-ms-inline-grid",description:"Inline-level grid container."},{name:"none",description:"The element and its descendants generates no boxes."},{name:"ruby",description:"The element generates a principal ruby container box, and establishes a ruby formatting context."},{name:"ruby-base"},{name:"ruby-base-container"},{name:"ruby-text"},{name:"ruby-text-container"},{name:"run-in",description:"The element generates a run-in box. Run-in elements act like inlines or blocks, depending on the surrounding elements."},{name:"table",description:"The element generates a principal table wrapper box containing an additionally-generated table box, and establishes a table formatting context."},{name:"table-caption"},{name:"table-cell"},{name:"table-column"},{name:"table-column-group"},{name:"table-footer-group"},{name:"table-header-group"},{name:"table-row"},{name:"table-row-group"},{name:"-webkit-box",description:"The element lays out its contents using flow layout (block-and-inline layout). Standardized as 'flex'."},{name:"-webkit-flex",description:"The element lays out its contents using flow layout (block-and-inline layout)."},{name:"-webkit-inline-box",description:"Inline-level flex container. Standardized as 'inline-flex'"},{name:"-webkit-inline-flex",description:"Inline-level flex container."}],syntax:"[ <display-outside> || <display-inside> ] | <display-listitem> | <display-internal> | <display-box> | <display-legacy>",relevance:96,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/display"}],description:"In combination with 'float' and 'position', determines the type of box or boxes that are generated for an element.",restrictions:["enum"]},{name:"empty-cells",values:[{name:"hide",description:"No borders or backgrounds are drawn around/behind empty cells."},{name:"-moz-show-background"},{name:"show",description:"Borders and backgrounds are drawn around/behind empty cells (like normal cells)."}],syntax:"show | hide",relevance:51,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/empty-cells"}],description:"In the separated borders model, this property controls the rendering of borders and backgrounds around cells that have no visible content.",restrictions:["enum"]},{name:"enable-background",values:[{name:"accumulate",description:"If the ancestor container element has a property of new, then all graphics elements within the current container are rendered both on the parent's background image and onto the target."},{name:"new",description:"Create a new background image canvas. All children of the current container element can access the background, and they will be rendered onto both the parent's background image canvas in addition to the target device."}],relevance:50,description:"Deprecated. Use 'isolation' property instead when support allows. Specifies how the accumulation of the background image is managed.",restrictions:["integer","length","percentage","enum"]},{name:"fallback",browsers:["FF33"],syntax:"<counter-style-name>",relevance:50,description:"@counter-style descriptor. Specifies a fallback counter style to be used when the current counter style can’t create a representation for a given counter value.",restrictions:["identifier"]},{name:"fill",values:[{name:"url()",description:"A URL reference to a paint server element, which is an element that defines a paint server: ‘hatch’, ‘linearGradient’, ‘mesh’, ‘pattern’, ‘radialGradient’ and ‘solidcolor’."},{name:"none",description:"No paint is applied in this layer."}],relevance:77,description:"Paints the interior of the given graphical element.",restrictions:["color","enum","url"]},{name:"fill-opacity",relevance:52,description:"Specifies the opacity of the painting operation used to paint the interior the current object.",restrictions:["number(0-1)"]},{name:"fill-rule",values:[{name:"evenodd",description:"Determines the ‘insideness’ of a point on the canvas by drawing a ray from that point to infinity in any direction and counting the number of path segments from the given shape that the ray crosses."},{name:"nonzero",description:"Determines the ‘insideness’ of a point on the canvas by drawing a ray from that point to infinity in any direction and then examining the places where a segment of the shape crosses the ray."}],relevance:50,description:"Indicates the algorithm (or winding rule) which is to be used to determine what parts of the canvas are included inside the shape.",restrictions:["enum"]},{name:"filter",browsers:["E12","FF35","S9.1","C53","O40"],values:[{name:"none",description:"No filter effects are applied."},{name:"blur()",description:"Applies a Gaussian blur to the input image."},{name:"brightness()",description:"Applies a linear multiplier to input image, making it appear more or less bright."},{name:"contrast()",description:"Adjusts the contrast of the input."},{name:"drop-shadow()",description:"Applies a drop shadow effect to the input image."},{name:"grayscale()",description:"Converts the input image to grayscale."},{name:"hue-rotate()",description:"Applies a hue rotation on the input image. "},{name:"invert()",description:"Inverts the samples in the input image."},{name:"opacity()",description:"Applies transparency to the samples in the input image."},{name:"saturate()",description:"Saturates the input image."},{name:"sepia()",description:"Converts the input image to sepia."},{name:"url()",browsers:["E12","FF35","S9.1","C53","O40"],description:"A filter reference to a <filter> element."}],syntax:"none | <filter-function-list>",relevance:66,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/filter"}],description:"Processes an element’s rendering before it is displayed in the document, by applying one or more filter effects.",restrictions:["enum","url"]},{name:"flex",values:[{name:"auto",description:"Retrieves the value of the main size property as the used 'flex-basis'."},{name:"content",description:"Indicates automatic sizing, based on the flex item’s content."},{name:"none",description:"Expands to '0 0 auto'."}],syntax:"none | [ <'flex-grow'> <'flex-shrink'>? || <'flex-basis'> ]",relevance:80,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/flex"}],description:"Specifies the components of a flexible length: the flex grow factor and flex shrink factor, and the flex basis.",restrictions:["length","number","percentage"]},{name:"flex-basis",values:[{name:"auto",description:"Retrieves the value of the main size property as the used 'flex-basis'."},{name:"content",description:"Indicates automatic sizing, based on the flex item’s content."}],syntax:"content | <'width'>",relevance:65,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/flex-basis"}],description:"Sets the flex basis.",restrictions:["length","number","percentage"]},{name:"flex-direction",values:[{name:"column",description:"The flex container’s main axis has the same orientation as the block axis of the current writing mode."},{name:"column-reverse",description:"Same as 'column', except the main-start and main-end directions are swapped."},{name:"row",description:"The flex container’s main axis has the same orientation as the inline axis of the current writing mode."},{name:"row-reverse",description:"Same as 'row', except the main-start and main-end directions are swapped."}],syntax:"row | row-reverse | column | column-reverse",relevance:83,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/flex-direction"}],description:"Specifies how flex items are placed in the flex container, by setting the direction of the flex container’s main axis.",restrictions:["enum"]},{name:"flex-flow",values:[{name:"column",description:"The flex container’s main axis has the same orientation as the block axis of the current writing mode."},{name:"column-reverse",description:"Same as 'column', except the main-start and main-end directions are swapped."},{name:"nowrap",description:"The flex container is single-line."},{name:"row",description:"The flex container’s main axis has the same orientation as the inline axis of the current writing mode."},{name:"row-reverse",description:"Same as 'row', except the main-start and main-end directions are swapped."},{name:"wrap",description:"The flexbox is multi-line."},{name:"wrap-reverse",description:"Same as 'wrap', except the cross-start and cross-end directions are swapped."}],syntax:"<'flex-direction'> || <'flex-wrap'>",relevance:61,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/flex-flow"}],description:"Specifies how flexbox items are placed in the flexbox.",restrictions:["enum"]},{name:"flex-grow",syntax:"<number>",relevance:75,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/flex-grow"}],description:"Sets the flex grow factor. Negative numbers are invalid.",restrictions:["number"]},{name:"flex-shrink",syntax:"<number>",relevance:74,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/flex-shrink"}],description:"Sets the flex shrink factor. Negative numbers are invalid.",restrictions:["number"]},{name:"flex-wrap",values:[{name:"nowrap",description:"The flex container is single-line."},{name:"wrap",description:"The flexbox is multi-line."},{name:"wrap-reverse",description:"Same as 'wrap', except the cross-start and cross-end directions are swapped."}],syntax:"nowrap | wrap | wrap-reverse",relevance:79,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/flex-wrap"}],description:"Controls whether the flex container is single-line or multi-line, and the direction of the cross-axis, which determines the direction new lines are stacked in.",restrictions:["enum"]},{name:"float",values:[{name:"inline-end",description:"A keyword indicating that the element must float on the end side of its containing block. That is the right side with ltr scripts, and the left side with rtl scripts."},{name:"inline-start",description:"A keyword indicating that the element must float on the start side of its containing block. That is the left side with ltr scripts, and the right side with rtl scripts."},{name:"left",description:"The element generates a block box that is floated to the left. Content flows on the right side of the box, starting at the top (subject to the 'clear' property)."},{name:"none",description:"The box is not floated."},{name:"right",description:"Similar to 'left', except the box is floated to the right, and content flows on the left side of the box, starting at the top."}],syntax:"left | right | none | inline-start | inline-end",relevance:91,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/float"}],description:"Specifies how a box should be floated. It may be set for any element, but only applies to elements that generate boxes that are not absolutely positioned.",restrictions:["enum"]},{name:"flood-color",browsers:["E","C5","FF3","IE10","O9","S6"],relevance:50,description:"Indicates what color to use to flood the current filter primitive subregion.",restrictions:["color"]},{name:"flood-opacity",browsers:["E","C5","FF3","IE10","O9","S6"],relevance:50,description:"Indicates what opacity to use to flood the current filter primitive subregion.",restrictions:["number(0-1)","percentage"]},{name:"font",values:[{name:"100",description:"Thin"},{name:"200",description:"Extra Light (Ultra Light)"},{name:"300",description:"Light"},{name:"400",description:"Normal"},{name:"500",description:"Medium"},{name:"600",description:"Semi Bold (Demi Bold)"},{name:"700",description:"Bold"},{name:"800",description:"Extra Bold (Ultra Bold)"},{name:"900",description:"Black (Heavy)"},{name:"bold",description:"Same as 700"},{name:"bolder",description:"Specifies the weight of the face bolder than the inherited value."},{name:"caption",description:"The font used for captioned controls (e.g., buttons, drop-downs, etc.)."},{name:"icon",description:"The font used to label icons."},{name:"italic",description:"Selects a font that is labeled 'italic', or, if that is not available, one labeled 'oblique'."},{name:"large"},{name:"larger"},{name:"lighter",description:"Specifies the weight of the face lighter than the inherited value."},{name:"medium"},{name:"menu",description:"The font used in menus (e.g., dropdown menus and menu lists)."},{name:"message-box",description:"The font used in dialog boxes."},{name:"normal",description:"Specifies a face that is not labeled as a small-caps font."},{name:"oblique",description:"Selects a font that is labeled 'oblique'."},{name:"small"},{name:"small-caps",description:"Specifies a font that is labeled as a small-caps font. If a genuine small-caps font is not available, user agents should simulate a small-caps font."},{name:"small-caption",description:"The font used for labeling small controls."},{name:"smaller"},{name:"status-bar",description:"The font used in window status bars."},{name:"x-large"},{name:"x-small"},{name:"xx-large"},{name:"xx-small"}],syntax:"[ [ <'font-style'> || <font-variant-css21> || <'font-weight'> || <'font-stretch'> ]? <'font-size'> [ / <'line-height'> ]? <'font-family'> ] | caption | icon | menu | message-box | small-caption | status-bar",relevance:84,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/font"}],description:"Shorthand property for setting 'font-style', 'font-variant', 'font-weight', 'font-size', 'line-height', and 'font-family', at the same place in the style sheet. The syntax of this property is based on a traditional typographical shorthand notation to set multiple properties related to fonts.",restrictions:["font"]},{name:"font-family",values:[{name:"-apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, Oxygen, Ubuntu, Cantarell, 'Open Sans', 'Helvetica Neue', sans-serif"},{name:"Arial, Helvetica, sans-serif"},{name:"Cambria, Cochin, Georgia, Times, 'Times New Roman', serif"},{name:"'Courier New', Courier, monospace"},{name:"cursive"},{name:"fantasy"},{name:"'Franklin Gothic Medium', 'Arial Narrow', Arial, sans-serif"},{name:"Georgia, 'Times New Roman', Times, serif"},{name:"'Gill Sans', 'Gill Sans MT', Calibri, 'Trebuchet MS', sans-serif"},{name:"Impact, Haettenschweiler, 'Arial Narrow Bold', sans-serif"},{name:"'Lucida Sans', 'Lucida Sans Regular', 'Lucida Grande', 'Lucida Sans Unicode', Geneva, Verdana, sans-serif"},{name:"monospace"},{name:"sans-serif"},{name:"'Segoe UI', Tahoma, Geneva, Verdana, sans-serif"},{name:"serif"},{name:"'Times New Roman', Times, serif"},{name:"'Trebuchet MS', 'Lucida Sans Unicode', 'Lucida Grande', 'Lucida Sans', Arial, sans-serif"},{name:"Verdana, Geneva, Tahoma, sans-serif"}],syntax:"<family-name>",relevance:94,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/font-family"}],description:"Specifies a prioritized list of font family names or generic family names. A user agent iterates through the list of family names until it matches an available font that contains a glyph for the character to be rendered.",restrictions:["font"]},{name:"font-feature-settings",values:[{name:'"aalt"',description:"Access All Alternates."},{name:'"abvf"',description:"Above-base Forms. Required in Khmer script."},{name:'"abvm"',description:"Above-base Mark Positioning. Required in Indic scripts."},{name:'"abvs"',description:"Above-base Substitutions. Required in Indic scripts."},{name:'"afrc"',description:"Alternative Fractions."},{name:'"akhn"',description:"Akhand. Required in most Indic scripts."},{name:'"blwf"',description:"Below-base Form. Required in a number of Indic scripts."},{name:'"blwm"',description:"Below-base Mark Positioning. Required in Indic scripts."},{name:'"blws"',description:"Below-base Substitutions. Required in Indic scripts."},{name:'"calt"',description:"Contextual Alternates."},{name:'"case"',description:"Case-Sensitive Forms. Applies only to European scripts; particularly prominent in Spanish-language setting."},{name:'"ccmp"',description:"Glyph Composition/Decomposition."},{name:'"cfar"',description:"Conjunct Form After Ro. Required in Khmer scripts."},{name:'"cjct"',description:"Conjunct Forms. Required in Indic scripts that show similarity to Devanagari."},{name:'"clig"',description:"Contextual Ligatures."},{name:'"cpct"',description:"Centered CJK Punctuation. Used primarily in Chinese fonts."},{name:'"cpsp"',description:"Capital Spacing. Should not be used in connecting scripts (e.g. most Arabic)."},{name:'"cswh"',description:"Contextual Swash."},{name:'"curs"',description:"Cursive Positioning. Can be used in any cursive script."},{name:'"c2pc"',description:"Petite Capitals From Capitals. Applies only to bicameral scripts."},{name:'"c2sc"',description:"Small Capitals From Capitals. Applies only to bicameral scripts."},{name:'"dist"',description:"Distances. Required in Indic scripts."},{name:'"dlig"',description:"Discretionary ligatures."},{name:'"dnom"',description:"Denominators."},{name:'"dtls"',description:"Dotless Forms. Applied to math formula layout."},{name:'"expt"',description:"Expert Forms. Applies only to Japanese."},{name:'"falt"',description:"Final Glyph on Line Alternates. Can be used in any cursive script."},{name:'"fin2"',description:"Terminal Form #2. Used only with the Syriac script."},{name:'"fin3"',description:"Terminal Form #3. Used only with the Syriac script."},{name:'"fina"',description:"Terminal Forms. Can be used in any alphabetic script."},{name:'"flac"',description:"Flattened ascent forms. Applied to math formula layout."},{name:'"frac"',description:"Fractions."},{name:'"fwid"',description:"Full Widths. Applies to any script which can use monospaced forms."},{name:'"half"',description:"Half Forms. Required in Indic scripts that show similarity to Devanagari."},{name:'"haln"',description:"Halant Forms. Required in Indic scripts."},{name:'"halt"',description:"Alternate Half Widths. Used only in CJKV fonts."},{name:'"hist"',description:"Historical Forms."},{name:'"hkna"',description:"Horizontal Kana Alternates. Applies only to fonts that support kana (hiragana and katakana)."},{name:'"hlig"',description:"Historical Ligatures."},{name:'"hngl"',description:"Hangul. Korean only."},{name:'"hojo"',description:"Hojo Kanji Forms (JIS X 0212-1990 Kanji Forms). Used only with Kanji script."},{name:'"hwid"',description:"Half Widths. Generally used only in CJKV fonts."},{name:'"init"',description:"Initial Forms. Can be used in any alphabetic script."},{name:'"isol"',description:"Isolated Forms. Can be used in any cursive script."},{name:'"ital"',description:"Italics. Applies mostly to Latin; note that many non-Latin fonts contain Latin as well."},{name:'"jalt"',description:"Justification Alternates. Can be used in any cursive script."},{name:'"jp78"',description:"JIS78 Forms. Applies only to Japanese."},{name:'"jp83"',description:"JIS83 Forms. Applies only to Japanese."},{name:'"jp90"',description:"JIS90 Forms. Applies only to Japanese."},{name:'"jp04"',description:"JIS2004 Forms. Applies only to Japanese."},{name:'"kern"',description:"Kerning."},{name:'"lfbd"',description:"Left Bounds."},{name:'"liga"',description:"Standard Ligatures."},{name:'"ljmo"',description:"Leading Jamo Forms. Required for Hangul script when Ancient Hangul writing system is supported."},{name:'"lnum"',description:"Lining Figures."},{name:'"locl"',description:"Localized Forms."},{name:'"ltra"',description:"Left-to-right glyph alternates."},{name:'"ltrm"',description:"Left-to-right mirrored forms."},{name:'"mark"',description:"Mark Positioning."},{name:'"med2"',description:"Medial Form #2. Used only with the Syriac script."},{name:'"medi"',description:"Medial Forms."},{name:'"mgrk"',description:"Mathematical Greek."},{name:'"mkmk"',description:"Mark to Mark Positioning."},{name:'"nalt"',description:"Alternate Annotation Forms."},{name:'"nlck"',description:"NLC Kanji Forms. Used only with Kanji script."},{name:'"nukt"',description:"Nukta Forms. Required in Indic scripts.."},{name:'"numr"',description:"Numerators."},{name:'"onum"',description:"Oldstyle Figures."},{name:'"opbd"',description:"Optical Bounds."},{name:'"ordn"',description:"Ordinals. Applies mostly to Latin script."},{name:'"ornm"',description:"Ornaments."},{name:'"palt"',description:"Proportional Alternate Widths. Used mostly in CJKV fonts."},{name:'"pcap"',description:"Petite Capitals."},{name:'"pkna"',description:"Proportional Kana. Generally used only in Japanese fonts."},{name:'"pnum"',description:"Proportional Figures."},{name:'"pref"',description:"Pre-base Forms. Required in Khmer and Myanmar (Burmese) scripts and southern Indic scripts that may display a pre-base form of Ra."},{name:'"pres"',description:"Pre-base Substitutions. Required in Indic scripts."},{name:'"pstf"',description:"Post-base Forms. Required in scripts of south and southeast Asia that have post-base forms for consonants eg: Gurmukhi, Malayalam, Khmer."},{name:'"psts"',description:"Post-base Substitutions."},{name:'"pwid"',description:"Proportional Widths."},{name:'"qwid"',description:"Quarter Widths. Generally used only in CJKV fonts."},{name:'"rand"',description:"Randomize."},{name:'"rclt"',description:"Required Contextual Alternates. May apply to any script, but is especially important for many styles of Arabic."},{name:'"rlig"',description:"Required Ligatures. Applies to Arabic and Syriac. May apply to some other scripts."},{name:'"rkrf"',description:"Rakar Forms. Required in Devanagari and Gujarati scripts."},{name:'"rphf"',description:"Reph Form. Required in Indic scripts. E.g. Devanagari, Kannada."},{name:'"rtbd"',description:"Right Bounds."},{name:'"rtla"',description:"Right-to-left alternates."},{name:'"rtlm"',description:"Right-to-left mirrored forms."},{name:'"ruby"',description:"Ruby Notation Forms. Applies only to Japanese."},{name:'"salt"',description:"Stylistic Alternates."},{name:'"sinf"',description:"Scientific Inferiors."},{name:'"size"',description:"Optical size."},{name:'"smcp"',description:"Small Capitals. Applies only to bicameral scripts."},{name:'"smpl"',description:"Simplified Forms. Applies only to Chinese and Japanese."},{name:'"ssty"',description:"Math script style alternates."},{name:'"stch"',description:"Stretching Glyph Decomposition."},{name:'"subs"',description:"Subscript."},{name:'"sups"',description:"Superscript."},{name:'"swsh"',description:"Swash. Does not apply to ideographic scripts."},{name:'"titl"',description:"Titling."},{name:'"tjmo"',description:"Trailing Jamo Forms. Required for Hangul script when Ancient Hangul writing system is supported."},{name:'"tnam"',description:"Traditional Name Forms. Applies only to Japanese."},{name:'"tnum"',description:"Tabular Figures."},{name:'"trad"',description:"Traditional Forms. Applies only to Chinese and Japanese."},{name:'"twid"',description:"Third Widths. Generally used only in CJKV fonts."},{name:'"unic"',description:"Unicase."},{name:'"valt"',description:"Alternate Vertical Metrics. Applies only to scripts with vertical writing modes."},{name:'"vatu"',description:"Vattu Variants. Used for Indic scripts. E.g. Devanagari."},{name:'"vert"',description:"Vertical Alternates. Applies only to scripts with vertical writing modes."},{name:'"vhal"',description:"Alternate Vertical Half Metrics. Used only in CJKV fonts."},{name:'"vjmo"',description:"Vowel Jamo Forms. Required for Hangul script when Ancient Hangul writing system is supported."},{name:'"vkna"',description:"Vertical Kana Alternates. Applies only to fonts that support kana (hiragana and katakana)."},{name:'"vkrn"',description:"Vertical Kerning."},{name:'"vpal"',description:"Proportional Alternate Vertical Metrics. Used mostly in CJKV fonts."},{name:'"vrt2"',description:"Vertical Alternates and Rotation. Applies only to scripts with vertical writing modes."},{name:'"zero"',description:"Slashed Zero."},{name:"normal",description:"No change in glyph substitution or positioning occurs."},{name:"off",description:"Disable feature."},{name:"on",description:"Enable feature."}],syntax:"normal | <feature-tag-value>#",relevance:56,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/font-feature-settings"}],description:"Provides low-level control over OpenType font features. It is intended as a way of providing access to font features that are not widely used but are needed for a particular use case.",restrictions:["string","integer"]},{name:"font-kerning",browsers:["E79","FF32","S9","C33","O20"],values:[{name:"auto",description:"Specifies that kerning is applied at the discretion of the user agent."},{name:"none",description:"Specifies that kerning is not applied."},{name:"normal",description:"Specifies that kerning is applied."}],syntax:"auto | normal | none",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/font-kerning"}],description:"Kerning is the contextual adjustment of inter-glyph spacing. This property controls metric kerning, kerning that utilizes adjustment data contained in the font.",restrictions:["enum"]},{name:"font-language-override",browsers:["FF34"],values:[{name:"normal",description:"Implies that when rendering with OpenType fonts the language of the document is used to infer the OpenType language system, used to select language specific features when rendering."}],syntax:"normal | <string>",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/font-language-override"}],description:"The value of 'normal' implies that when rendering with OpenType fonts the language of the document is used to infer the OpenType language system, used to select language specific features when rendering.",restrictions:["string"]},{name:"font-size",values:[{name:"large"},{name:"larger"},{name:"medium"},{name:"small"},{name:"smaller"},{name:"x-large"},{name:"x-small"},{name:"xx-large"},{name:"xx-small"}],syntax:"<absolute-size> | <relative-size> | <length-percentage>",relevance:95,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/font-size"}],description:"Indicates the desired height of glyphs from the font. For scalable fonts, the font-size is a scale factor applied to the EM unit of the font. (Note that certain glyphs may bleed outside their EM box.) For non-scalable fonts, the font-size is converted into absolute units and matched against the declared font-size of the font, using the same absolute coordinate space for both of the matched values.",restrictions:["length","percentage"]},{name:"font-size-adjust",browsers:["E79","FF40","C43","O30"],values:[{name:"none",description:"Do not preserve the font’s x-height."}],syntax:"none | [ ex-height | cap-height | ch-width | ic-width | ic-height ]? [ from-font | <number> ]",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/font-size-adjust"}],description:"Preserves the readability of text when font fallback occurs by adjusting the font-size so that the x-height is the same regardless of the font used.",restrictions:["number"]},{name:"font-stretch",values:[{name:"condensed"},{name:"expanded"},{name:"extra-condensed"},{name:"extra-expanded"},{name:"narrower",description:"Indicates a narrower value relative to the width of the parent element."},{name:"normal"},{name:"semi-condensed"},{name:"semi-expanded"},{name:"ultra-condensed"},{name:"ultra-expanded"},{name:"wider",description:"Indicates a wider value relative to the width of the parent element."}],syntax:"<font-stretch-absolute>{1,2}",relevance:56,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/font-stretch"}],description:"Selects a normal, condensed, or expanded face from a font family.",restrictions:["enum"]},{name:"font-style",values:[{name:"italic",description:"Selects a font that is labeled as an 'italic' face, or an 'oblique' face if one is not"},{name:"normal",description:"Selects a face that is classified as 'normal'."},{name:"oblique",description:"Selects a font that is labeled as an 'oblique' face, or an 'italic' face if one is not."}],syntax:"normal | italic | oblique <angle>{0,2}",relevance:90,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/font-style"}],description:"Allows italic or oblique faces to be selected. Italic forms are generally cursive in nature while oblique faces are typically sloped versions of the regular face.",restrictions:["enum"]},{name:"font-synthesis",browsers:["E97","FF34","S9","C97","O83"],values:[{name:"none",description:"Disallow all synthetic faces."},{name:"style",description:"Allow synthetic italic faces."},{name:"weight",description:"Allow synthetic bold faces."}],syntax:"none | [ weight || style || small-caps ]",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/font-synthesis"}],description:"Controls whether user agents are allowed to synthesize bold or oblique font faces when a font family lacks bold or italic faces.",restrictions:["enum"]},{name:"font-variant",values:[{name:"normal",description:"Specifies a face that is not labeled as a small-caps font."},{name:"small-caps",description:"Specifies a font that is labeled as a small-caps font. If a genuine small-caps font is not available, user agents should simulate a small-caps font."}],syntax:"normal | none | [ <common-lig-values> || <discretionary-lig-values> || <historical-lig-values> || <contextual-alt-values> || stylistic(<feature-value-name>) || historical-forms || styleset(<feature-value-name>#) || character-variant(<feature-value-name>#) || swash(<feature-value-name>) || ornaments(<feature-value-name>) || annotation(<feature-value-name>) || [ small-caps | all-small-caps | petite-caps | all-petite-caps | unicase | titling-caps ] || <numeric-figure-values> || <numeric-spacing-values> || <numeric-fraction-values> || ordinal || slashed-zero || <east-asian-variant-values> || <east-asian-width-values> || ruby ]",relevance:65,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/font-variant"}],description:"Specifies variant representations of the font",restrictions:["enum"]},{name:"font-variant-alternates",browsers:["FF34","S9.1"],values:[{name:"annotation()",description:"Enables display of alternate annotation forms."},{name:"character-variant()",description:"Enables display of specific character variants."},{name:"historical-forms",description:"Enables display of historical forms."},{name:"normal",description:"None of the features are enabled."},{name:"ornaments()",description:"Enables replacement of default glyphs with ornaments, if provided in the font."},{name:"styleset()",description:"Enables display with stylistic sets."},{name:"stylistic()",description:"Enables display of stylistic alternates."},{name:"swash()",description:"Enables display of swash glyphs."}],syntax:"normal | [ stylistic( <feature-value-name> ) || historical-forms || styleset( <feature-value-name># ) || character-variant( <feature-value-name># ) || swash( <feature-value-name> ) || ornaments( <feature-value-name> ) || annotation( <feature-value-name> ) ]",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/font-variant-alternates"}],description:"For any given character, fonts can provide a variety of alternate glyphs in addition to the default glyph for that character. This property provides control over the selection of these alternate glyphs.",restrictions:["enum"]},{name:"font-variant-caps",browsers:["E79","FF34","S9.1","C52","O39"],values:[{name:"all-petite-caps",description:"Enables display of petite capitals for both upper and lowercase letters."},{name:"all-small-caps",description:"Enables display of small capitals for both upper and lowercase letters."},{name:"normal",description:"None of the features are enabled."},{name:"petite-caps",description:"Enables display of petite capitals."},{name:"small-caps",description:"Enables display of small capitals. Small-caps glyphs typically use the form of uppercase letters but are reduced to the size of lowercase letters."},{name:"titling-caps",description:"Enables display of titling capitals."},{name:"unicase",description:"Enables display of mixture of small capitals for uppercase letters with normal lowercase letters."}],syntax:"normal | small-caps | all-small-caps | petite-caps | all-petite-caps | unicase | titling-caps",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/font-variant-caps"}],description:"Specifies control over capitalized forms.",restrictions:["enum"]},{name:"font-variant-east-asian",browsers:["E79","FF34","S9.1","C63","O50"],values:[{name:"full-width",description:"Enables rendering of full-width variants."},{name:"jis04",description:"Enables rendering of JIS04 forms."},{name:"jis78",description:"Enables rendering of JIS78 forms."},{name:"jis83",description:"Enables rendering of JIS83 forms."},{name:"jis90",description:"Enables rendering of JIS90 forms."},{name:"normal",description:"None of the features are enabled."},{name:"proportional-width",description:"Enables rendering of proportionally-spaced variants."},{name:"ruby",description:"Enables display of ruby variant glyphs."},{name:"simplified",description:"Enables rendering of simplified forms."},{name:"traditional",description:"Enables rendering of traditional forms."}],syntax:"normal | [ <east-asian-variant-values> || <east-asian-width-values> || ruby ]",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/font-variant-east-asian"}],description:"Allows control of glyph substitute and positioning in East Asian text.",restrictions:["enum"]},{name:"font-variant-ligatures",browsers:["E79","FF34","S9.1","C34","O21"],values:[{name:"additional-ligatures",description:"Enables display of additional ligatures."},{name:"common-ligatures",description:"Enables display of common ligatures."},{name:"contextual",browsers:["E79","FF34","S9.1","C34","O21"],description:"Enables display of contextual alternates."},{name:"discretionary-ligatures",description:"Enables display of discretionary ligatures."},{name:"historical-ligatures",description:"Enables display of historical ligatures."},{name:"no-additional-ligatures",description:"Disables display of additional ligatures."},{name:"no-common-ligatures",description:"Disables display of common ligatures."},{name:"no-contextual",browsers:["E79","FF34","S9.1","C34","O21"],description:"Disables display of contextual alternates."},{name:"no-discretionary-ligatures",description:"Disables display of discretionary ligatures."},{name:"no-historical-ligatures",description:"Disables display of historical ligatures."},{name:"none",browsers:["E79","FF34","S9.1","C34","O21"],description:"Disables all ligatures."},{name:"normal",description:"Implies that the defaults set by the font are used."}],syntax:"normal | none | [ <common-lig-values> || <discretionary-lig-values> || <historical-lig-values> || <contextual-alt-values> ]",relevance:52,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/font-variant-ligatures"}],description:"Specifies control over which ligatures are enabled or disabled. A value of ‘normal’ implies that the defaults set by the font are used.",restrictions:["enum"]},{name:"font-variant-numeric",browsers:["E79","FF34","S9.1","C52","O39"],values:[{name:"diagonal-fractions",description:"Enables display of lining diagonal fractions."},{name:"lining-nums",description:"Enables display of lining numerals."},{name:"normal",description:"None of the features are enabled."},{name:"oldstyle-nums",description:"Enables display of old-style numerals."},{name:"ordinal",description:"Enables display of letter forms used with ordinal numbers."},{name:"proportional-nums",description:"Enables display of proportional numerals."},{name:"slashed-zero",description:"Enables display of slashed zeros."},{name:"stacked-fractions",description:"Enables display of lining stacked fractions."},{name:"tabular-nums",description:"Enables display of tabular numerals."}],syntax:"normal | [ <numeric-figure-values> || <numeric-spacing-values> || <numeric-fraction-values> || ordinal || slashed-zero ]",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/font-variant-numeric"}],description:"Specifies control over numerical forms.",restrictions:["enum"]},{name:"font-variant-position",browsers:["FF34","S9.1"],values:[{name:"normal",description:"None of the features are enabled."},{name:"sub",description:"Enables display of subscript variants (OpenType feature: subs)."},{name:"super",description:"Enables display of superscript variants (OpenType feature: sups)."}],syntax:"normal | sub | super",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/font-variant-position"}],description:"Specifies the vertical position",restrictions:["enum"]},{name:"font-weight",values:[{name:"100",description:"Thin"},{name:"200",description:"Extra Light (Ultra Light)"},{name:"300",description:"Light"},{name:"400",description:"Normal"},{name:"500",description:"Medium"},{name:"600",description:"Semi Bold (Demi Bold)"},{name:"700",description:"Bold"},{name:"800",description:"Extra Bold (Ultra Bold)"},{name:"900",description:"Black (Heavy)"},{name:"bold",description:"Same as 700"},{name:"bolder",description:"Specifies the weight of the face bolder than the inherited value."},{name:"lighter",description:"Specifies the weight of the face lighter than the inherited value."},{name:"normal",description:"Same as 400"}],syntax:"<font-weight-absolute>{1,2}",relevance:94,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/font-weight"}],description:"Specifies weight of glyphs in the font, their degree of blackness or stroke thickness.",restrictions:["enum"]},{name:"glyph-orientation-horizontal",relevance:50,description:"Controls glyph orientation when the inline-progression-direction is horizontal.",restrictions:["angle","number"]},{name:"glyph-orientation-vertical",values:[{name:"auto",description:"Sets the orientation based on the fullwidth or non-fullwidth characters and the most common orientation."}],relevance:50,description:"Controls glyph orientation when the inline-progression-direction is vertical.",restrictions:["angle","number","enum"]},{name:"grid-area",browsers:["E16","FF52","S10.1","C57","O44"],values:[{name:"auto",description:"The property contributes nothing to the grid item’s placement, indicating auto-placement, an automatic span, or a default span of one."},{name:"span",description:"Contributes a grid span to the grid item’s placement such that the corresponding edge of the grid item’s grid area is N lines from its opposite edge."}],syntax:"<grid-line> [ / <grid-line> ]{0,3}",relevance:53,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/grid-area"}],description:"Determine a grid item’s size and location within the grid by contributing a line, a span, or nothing (automatic) to its grid placement. Shorthand for 'grid-row-start', 'grid-column-start', 'grid-row-end', and 'grid-column-end'.",restrictions:["identifier","integer"]},{name:"grid",browsers:["E16","FF52","S10.1","C57","O44"],syntax:"<'grid-template'> | <'grid-template-rows'> / [ auto-flow && dense? ] <'grid-auto-columns'>? | [ auto-flow && dense? ] <'grid-auto-rows'>? / <'grid-template-columns'>",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/grid"}],description:"The grid CSS property is a shorthand property that sets all of the explicit grid properties ('grid-template-rows', 'grid-template-columns', and 'grid-template-areas'), and all the implicit grid properties ('grid-auto-rows', 'grid-auto-columns', and 'grid-auto-flow'), in a single declaration.",restrictions:["identifier","length","percentage","string","enum"]},{name:"grid-auto-columns",values:[{name:"min-content",description:"Represents the largest min-content contribution of the grid items occupying the grid track."},{name:"max-content",description:"Represents the largest max-content contribution of the grid items occupying the grid track."},{name:"auto",description:"As a maximum, identical to 'max-content'. As a minimum, represents the largest minimum size (as specified by min-width/min-height) of the grid items occupying the grid track."},{name:"minmax()",description:"Defines a size range greater than or equal to min and less than or equal to max."}],syntax:"<track-size>+",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/grid-auto-columns"}],description:"Specifies the size of implicitly created columns.",restrictions:["length","percentage"]},{name:"grid-auto-flow",browsers:["E16","FF52","S10.1","C57","O44"],values:[{name:"row",description:"The auto-placement algorithm places items by filling each row in turn, adding new rows as necessary."},{name:"column",description:"The auto-placement algorithm places items by filling each column in turn, adding new columns as necessary."},{name:"dense",description:"If specified, the auto-placement algorithm uses a “dense” packing algorithm, which attempts to fill in holes earlier in the grid if smaller items come up later."}],syntax:"[ row | column ] || dense",relevance:52,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/grid-auto-flow"}],description:"Controls how the auto-placement algorithm works, specifying exactly how auto-placed items get flowed into the grid.",restrictions:["enum"]},{name:"grid-auto-rows",values:[{name:"min-content",description:"Represents the largest min-content contribution of the grid items occupying the grid track."},{name:"max-content",description:"Represents the largest max-content contribution of the grid items occupying the grid track."},{name:"auto",description:"As a maximum, identical to 'max-content'. As a minimum, represents the largest minimum size (as specified by min-width/min-height) of the grid items occupying the grid track."},{name:"minmax()",description:"Defines a size range greater than or equal to min and less than or equal to max."}],syntax:"<track-size>+",relevance:51,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/grid-auto-rows"}],description:"Specifies the size of implicitly created rows.",restrictions:["length","percentage"]},{name:"grid-column",browsers:["E16","FF52","S10.1","C57","O44"],values:[{name:"auto",description:"The property contributes nothing to the grid item’s placement, indicating auto-placement, an automatic span, or a default span of one."},{name:"span",description:"Contributes a grid span to the grid item’s placement such that the corresponding edge of the grid item’s grid area is N lines from its opposite edge."}],syntax:"<grid-line> [ / <grid-line> ]?",relevance:53,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/grid-column"}],description:"Shorthand for 'grid-column-start' and 'grid-column-end'.",restrictions:["identifier","integer","enum"]},{name:"grid-column-end",browsers:["E16","FF52","S10.1","C57","O44"],values:[{name:"auto",description:"The property contributes nothing to the grid item’s placement, indicating auto-placement, an automatic span, or a default span of one."},{name:"span",description:"Contributes a grid span to the grid item’s placement such that the corresponding edge of the grid item’s grid area is N lines from its opposite edge."}],syntax:"<grid-line>",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/grid-column-end"}],description:"Determine a grid item’s size and location within the grid by contributing a line, a span, or nothing (automatic) to its grid placement.",restrictions:["identifier","integer","enum"]},{name:"grid-column-gap",browsers:["FF52","C57","S10.1","O44"],status:"obsolete",syntax:"<length-percentage>",relevance:2,description:"Specifies the gutters between grid columns. Replaced by 'column-gap' property.",restrictions:["length"]},{name:"grid-column-start",browsers:["E16","FF52","S10.1","C57","O44"],values:[{name:"auto",description:"The property contributes nothing to the grid item’s placement, indicating auto-placement, an automatic span, or a default span of one."},{name:"span",description:"Contributes a grid span to the grid item’s placement such that the corresponding edge of the grid item’s grid area is N lines from its opposite edge."}],syntax:"<grid-line>",relevance:51,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/grid-column-start"}],description:"Determine a grid item’s size and location within the grid by contributing a line, a span, or nothing (automatic) to its grid placement.",restrictions:["identifier","integer","enum"]},{name:"grid-gap",browsers:["FF52","C57","S10.1","O44"],status:"obsolete",syntax:"<'grid-row-gap'> <'grid-column-gap'>?",relevance:3,description:"Shorthand that specifies the gutters between grid columns and grid rows in one declaration. Replaced by 'gap' property.",restrictions:["length"]},{name:"grid-row",browsers:["E16","FF52","S10.1","C57","O44"],values:[{name:"auto",description:"The property contributes nothing to the grid item’s placement, indicating auto-placement, an automatic span, or a default span of one."},{name:"span",description:"Contributes a grid span to the grid item’s placement such that the corresponding edge of the grid item’s grid area is N lines from its opposite edge."}],syntax:"<grid-line> [ / <grid-line> ]?",relevance:52,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/grid-row"}],description:"Shorthand for 'grid-row-start' and 'grid-row-end'.",restrictions:["identifier","integer","enum"]},{name:"grid-row-end",browsers:["E16","FF52","S10.1","C57","O44"],values:[{name:"auto",description:"The property contributes nothing to the grid item’s placement, indicating auto-placement, an automatic span, or a default span of one."},{name:"span",description:"Contributes a grid span to the grid item’s placement such that the corresponding edge of the grid item’s grid area is N lines from its opposite edge."}],syntax:"<grid-line>",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/grid-row-end"}],description:"Determine a grid item’s size and location within the grid by contributing a line, a span, or nothing (automatic) to its grid placement.",restrictions:["identifier","integer","enum"]},{name:"grid-row-gap",browsers:["FF52","C57","S10.1","O44"],status:"obsolete",syntax:"<length-percentage>",relevance:1,description:"Specifies the gutters between grid rows. Replaced by 'row-gap' property.",restrictions:["length"]},{name:"grid-row-start",browsers:["E16","FF52","S10.1","C57","O44"],values:[{name:"auto",description:"The property contributes nothing to the grid item’s placement, indicating auto-placement, an automatic span, or a default span of one."},{name:"span",description:"Contributes a grid span to the grid item’s placement such that the corresponding edge of the grid item’s grid area is N lines from its opposite edge."}],syntax:"<grid-line>",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/grid-row-start"}],description:"Determine a grid item’s size and location within the grid by contributing a line, a span, or nothing (automatic) to its grid placement.",restrictions:["identifier","integer","enum"]},{name:"grid-template",browsers:["E16","FF52","S10.1","C57","O44"],values:[{name:"none",description:"Sets all three properties to their initial values."},{name:"min-content",description:"Represents the largest min-content contribution of the grid items occupying the grid track."},{name:"max-content",description:"Represents the largest max-content contribution of the grid items occupying the grid track."},{name:"auto",description:"As a maximum, identical to 'max-content'. As a minimum, represents the largest minimum size (as specified by min-width/min-height) of the grid items occupying the grid track."},{name:"subgrid",description:"Sets 'grid-template-rows' and 'grid-template-columns' to 'subgrid', and 'grid-template-areas' to its initial value."},{name:"minmax()",description:"Defines a size range greater than or equal to min and less than or equal to max."},{name:"repeat()",description:"Represents a repeated fragment of the track list, allowing a large number of columns or rows that exhibit a recurring pattern to be written in a more compact form."}],syntax:"none | [ <'grid-template-rows'> / <'grid-template-columns'> ] | [ <line-names>? <string> <track-size>? <line-names>? ]+ [ / <explicit-track-list> ]?",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/grid-template"}],description:"Shorthand for setting grid-template-columns, grid-template-rows, and grid-template-areas in a single declaration.",restrictions:["identifier","length","percentage","string","enum"]},{name:"grid-template-areas",browsers:["E16","FF52","S10.1","C57","O44"],values:[{name:"none",description:"The grid container doesn’t define any named grid areas."}],syntax:"none | <string>+",relevance:52,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/grid-template-areas"}],description:"Specifies named grid areas, which are not associated with any particular grid item, but can be referenced from the grid-placement properties.",restrictions:["string"]},{name:"grid-template-columns",values:[{name:"none",description:"There is no explicit grid; any rows/columns will be implicitly generated."},{name:"min-content",description:"Represents the largest min-content contribution of the grid items occupying the grid track."},{name:"max-content",description:"Represents the largest max-content contribution of the grid items occupying the grid track."},{name:"auto",description:"As a maximum, identical to 'max-content'. As a minimum, represents the largest minimum size (as specified by min-width/min-height) of the grid items occupying the grid track."},{name:"subgrid",description:"Indicates that the grid will align to its parent grid in that axis."},{name:"minmax()",description:"Defines a size range greater than or equal to min and less than or equal to max."},{name:"repeat()",description:"Represents a repeated fragment of the track list, allowing a large number of columns or rows that exhibit a recurring pattern to be written in a more compact form."}],syntax:"none | <track-list> | <auto-track-list> | subgrid <line-name-list>?",relevance:58,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/grid-template-columns"}],description:"specifies, as a space-separated track list, the line names and track sizing functions of the grid.",restrictions:["identifier","length","percentage","enum"]},{name:"grid-template-rows",values:[{name:"none",description:"There is no explicit grid; any rows/columns will be implicitly generated."},{name:"min-content",description:"Represents the largest min-content contribution of the grid items occupying the grid track."},{name:"max-content",description:"Represents the largest max-content contribution of the grid items occupying the grid track."},{name:"auto",description:"As a maximum, identical to 'max-content'. As a minimum, represents the largest minimum size (as specified by min-width/min-height) of the grid items occupying the grid track."},{name:"subgrid",description:"Indicates that the grid will align to its parent grid in that axis."},{name:"minmax()",description:"Defines a size range greater than or equal to min and less than or equal to max."},{name:"repeat()",description:"Represents a repeated fragment of the track list, allowing a large number of columns or rows that exhibit a recurring pattern to be written in a more compact form."}],syntax:"none | <track-list> | <auto-track-list> | subgrid <line-name-list>?",relevance:53,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/grid-template-rows"}],description:"specifies, as a space-separated track list, the line names and track sizing functions of the grid.",restrictions:["identifier","length","percentage","string","enum"]},{name:"height",values:[{name:"auto",description:"The height depends on the values of other properties."},{name:"fit-content",description:"Use the fit-content inline size or fit-content block size, as appropriate to the writing mode."},{name:"max-content",description:"Use the max-content inline size or max-content block size, as appropriate to the writing mode."},{name:"min-content",description:"Use the min-content inline size or min-content block size, as appropriate to the writing mode."}],syntax:"<viewport-length>{1,2}",relevance:96,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/height"}],description:"Specifies the height of the content area, padding area or border area (depending on 'box-sizing') of certain boxes.",restrictions:["length","percentage"]},{name:"hyphens",values:[{name:"auto",description:"Conditional hyphenation characters inside a word, if present, take priority over automatic resources when determining hyphenation points within the word."},{name:"manual",description:"Words are only broken at line breaks where there are characters inside the word that suggest line break opportunities"},{name:"none",description:"Words are not broken at line breaks, even if characters inside the word suggest line break points."}],syntax:"none | manual | auto",relevance:55,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/hyphens"}],description:"Controls whether hyphenation is allowed to create more break opportunities within a line of text.",restrictions:["enum"]},{name:"image-orientation",browsers:["E81","FF26","S13.1","C81","O67"],values:[{name:"flip",description:"After rotating by the precededing angle, the image is flipped horizontally. Defaults to 0deg if the angle is ommitted."},{name:"from-image",description:"If the image has an orientation specified in its metadata, such as EXIF, this value computes to the angle that the metadata specifies is necessary to correctly orient the image."}],syntax:"from-image | <angle> | [ <angle>? flip ]",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/image-orientation"}],description:"Specifies an orthogonal rotation to be applied to an image before it is laid out.",restrictions:["angle"]},{name:"image-rendering",browsers:["E79","FF3.6","S6","C13","O15"],values:[{name:"auto",description:"The image should be scaled with an algorithm that maximizes the appearance of the image."},{name:"crisp-edges",description:"The image must be scaled with an algorithm that preserves contrast and edges in the image, and which does not smooth colors or introduce blur to the image in the process."},{name:"-moz-crisp-edges",browsers:["E79","FF3.6","S6","C13","O15"]},{name:"optimizeQuality",description:"Deprecated."},{name:"optimizeSpeed",description:"Deprecated."},{name:"pixelated",description:"When scaling the image up, the 'nearest neighbor' or similar algorithm must be used, so that the image appears to be simply composed of very large pixels."}],syntax:"auto | crisp-edges | pixelated",relevance:55,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/image-rendering"}],description:"Provides a hint to the user-agent about what aspects of an image are most important to preserve when the image is scaled, to aid the user-agent in the choice of an appropriate scaling algorithm.",restrictions:["enum"]},{name:"ime-mode",browsers:["E12","FF3","IE5"],values:[{name:"active",description:"The input method editor is initially active; text entry is performed using it unless the user specifically dismisses it."},{name:"auto",description:"No change is made to the current input method editor state. This is the default."},{name:"disabled",description:"The input method editor is disabled and may not be activated by the user."},{name:"inactive",description:"The input method editor is initially inactive, but the user may activate it if they wish."},{name:"normal",description:"The IME state should be normal; this value can be used in a user style sheet to override the page setting."}],status:"obsolete",syntax:"auto | normal | active | inactive | disabled",relevance:0,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/ime-mode"}],description:"Controls the state of the input method editor for text fields.",restrictions:["enum"]},{name:"inline-size",browsers:["E79","FF41","S12.1","C57","O44"],values:[{name:"auto",description:"Depends on the values of other properties."}],syntax:"<'width'>",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/inline-size"}],description:"Size of an element in the direction specified by 'writing-mode'.",restrictions:["length","percentage"]},{name:"isolation",browsers:["E79","FF36","S8","C41","O30"],values:[{name:"auto",description:"Elements are not isolated unless an operation is applied that causes the creation of a stacking context."},{name:"isolate",description:"In CSS will turn the element into a stacking context."}],syntax:"auto | isolate",relevance:51,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/isolation"}],description:"In CSS setting to 'isolate' will turn the element into a stacking context. In SVG, it defines whether an element is isolated or not.",restrictions:["enum"]},{name:"justify-content",values:[{name:"center",description:"Flex items are packed toward the center of the line."},{name:"start",description:"The items are packed flush to each other toward the start edge of the alignment container in the main axis."},{name:"end",description:"The items are packed flush to each other toward the end edge of the alignment container in the main axis."},{name:"left",description:"The items are packed flush to each other toward the left edge of the alignment container in the main axis."},{name:"right",description:"The items are packed flush to each other toward the right edge of the alignment container in the main axis."},{name:"safe",description:"If the size of the item overflows the alignment container, the item is instead aligned as if the alignment mode were start."},{name:"unsafe",description:"Regardless of the relative sizes of the item and alignment container, the given alignment value is honored."},{name:"stretch",description:"If the combined size of the alignment subjects is less than the size of the alignment container, any auto-sized alignment subjects have their size increased equally (not proportionally), while still respecting the constraints imposed by max-height/max-width (or equivalent functionality), so that the combined size exactly fills the alignment container."},{name:"space-evenly",description:"The items are evenly distributed within the alignment container along the main axis."},{name:"flex-end",description:"Flex items are packed toward the end of the line."},{name:"flex-start",description:"Flex items are packed toward the start of the line."},{name:"space-around",description:"Flex items are evenly distributed in the line, with half-size spaces on either end."},{name:"space-between",description:"Flex items are evenly distributed in the line."},{name:"baseline",description:"Specifies participation in first-baseline alignment."},{name:"first baseline",description:"Specifies participation in first-baseline alignment."},{name:"last baseline",description:"Specifies participation in last-baseline alignment."}],syntax:"normal | <content-distribution> | <overflow-position>? [ <content-position> | left | right ]",relevance:86,description:"Aligns flex items along the main axis of the current line of the flex container.",restrictions:["enum"]},{name:"kerning",values:[{name:"auto",description:"Indicates that the user agent should adjust inter-glyph spacing based on kerning tables that are included in the font that will be used."}],relevance:50,description:"Indicates whether the user agent should adjust inter-glyph spacing based on kerning tables that are included in the relevant font or instead disable auto-kerning and set inter-character spacing to a specific length.",restrictions:["length","enum"]},{name:"left",values:[{name:"auto",description:"For non-replaced elements, the effect of this value depends on which of related properties have the value 'auto' as well"}],syntax:"<length> | <percentage> | auto",relevance:95,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/left"}],description:"Specifies how far an absolutely positioned box's left margin edge is offset to the right of the left edge of the box's 'containing block'.",restrictions:["length","percentage"]},{name:"letter-spacing",values:[{name:"normal",description:"The spacing is the normal spacing for the current font. It is typically zero-length."}],syntax:"normal | <length>",relevance:82,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/letter-spacing"}],description:"Specifies the minimum, maximum, and optimal spacing between grapheme clusters.",restrictions:["length"]},{name:"lighting-color",browsers:["E","C5","FF3","IE10","O9","S6"],relevance:50,description:"Defines the color of the light source for filter primitives 'feDiffuseLighting' and 'feSpecularLighting'.",restrictions:["color"]},{name:"line-break",values:[{name:"auto",description:"The UA determines the set of line-breaking restrictions to use for CJK scripts, and it may vary the restrictions based on the length of the line; e.g., use a less restrictive set of line-break rules for short lines."},{name:"loose",description:"Breaks text using the least restrictive set of line-breaking rules. Typically used for short lines, such as in newspapers."},{name:"normal",description:"Breaks text using the most common set of line-breaking rules."},{name:"strict",description:"Breaks CJK scripts using a more restrictive set of line-breaking rules than 'normal'."}],syntax:"auto | loose | normal | strict | anywhere",relevance:51,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/line-break"}],description:"Specifies what set of line breaking restrictions are in effect within the element.",restrictions:["enum"]},{name:"line-height",values:[{name:"normal",description:"Tells user agents to set the computed value to a 'reasonable' value based on the font size of the element."}],syntax:"normal | <number> | <length> | <percentage>",relevance:93,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/line-height"}],description:"Determines the block-progression dimension of the text content area of an inline box.",restrictions:["number","length","percentage"]},{name:"list-style",values:[{name:"armenian"},{name:"circle",description:"A hollow circle."},{name:"decimal"},{name:"decimal-leading-zero"},{name:"disc",description:"A filled circle."},{name:"georgian"},{name:"inside",description:"The marker box is outside the principal block box, as described in the section on the ::marker pseudo-element below."},{name:"lower-alpha"},{name:"lower-greek"},{name:"lower-latin"},{name:"lower-roman"},{name:"none"},{name:"outside",description:"The ::marker pseudo-element is an inline element placed immediately before all ::before pseudo-elements in the principal block box, after which the element's content flows."},{name:"square",description:"A filled square."},{name:"symbols()",description:"Allows a counter style to be defined inline."},{name:"upper-alpha"},{name:"upper-latin"},{name:"upper-roman"},{name:"url()"}],syntax:"<'list-style-type'> || <'list-style-position'> || <'list-style-image'>",relevance:86,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/list-style"}],description:"Shorthand for setting 'list-style-type', 'list-style-position' and 'list-style-image'",restrictions:["image","enum","url"]},{name:"list-style-image",values:[{name:"none",description:"The default contents of the of the list item’s marker are given by 'list-style-type' instead."}],syntax:"<image> | none",relevance:52,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/list-style-image"}],description:"Sets the image that will be used as the list item marker. When the image is available, it will replace the marker set with the 'list-style-type' marker.",restrictions:["image"]},{name:"list-style-position",values:[{name:"inside",description:"The marker box is outside the principal block box, as described in the section on the ::marker pseudo-element below."},{name:"outside",description:"The ::marker pseudo-element is an inline element placed immediately before all ::before pseudo-elements in the principal block box, after which the element's content flows."}],syntax:"inside | outside",relevance:55,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/list-style-position"}],description:"Specifies the position of the '::marker' pseudo-element's box in the list item.",restrictions:["enum"]},{name:"list-style-type",values:[{name:"armenian",description:"Traditional uppercase Armenian numbering."},{name:"circle",description:"A hollow circle."},{name:"decimal",description:"Western decimal numbers."},{name:"decimal-leading-zero",description:"Decimal numbers padded by initial zeros."},{name:"disc",description:"A filled circle."},{name:"georgian",description:"Traditional Georgian numbering."},{name:"lower-alpha",description:"Lowercase ASCII letters."},{name:"lower-greek",description:"Lowercase classical Greek."},{name:"lower-latin",description:"Lowercase ASCII letters."},{name:"lower-roman",description:"Lowercase ASCII Roman numerals."},{name:"none",description:"No marker"},{name:"square",description:"A filled square."},{name:"symbols()",description:"Allows a counter style to be defined inline."},{name:"upper-alpha",description:"Uppercase ASCII letters."},{name:"upper-latin",description:"Uppercase ASCII letters."},{name:"upper-roman",description:"Uppercase ASCII Roman numerals."}],syntax:"<counter-style> | <string> | none",relevance:75,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/list-style-type"}],description:"Used to construct the default contents of a list item’s marker",restrictions:["enum","string"]},{name:"margin",values:[{name:"auto"}],syntax:"[ <length> | <percentage> | auto ]{1,4}",relevance:96,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/margin"}],description:"Shorthand property to set values for the thickness of the margin area. If left is omitted, it is the same as right. If bottom is omitted it is the same as top, if right is omitted it is the same as top. Negative values for margin properties are allowed, but there may be implementation-specific limits.",restrictions:["length","percentage"]},{name:"margin-block-end",browsers:["E79","FF41","S12.1","C69","O56"],values:[{name:"auto"}],syntax:"<'margin-left'>",relevance:53,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/margin-block-end"}],description:"Logical 'margin-bottom'. Mapping depends on the parent element’s 'writing-mode', 'direction', and 'text-orientation'.",restrictions:["length","percentage"]},{name:"margin-block-start",browsers:["E79","FF41","S12.1","C69","O56"],values:[{name:"auto"}],syntax:"<'margin-left'>",relevance:53,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/margin-block-start"}],description:"Logical 'margin-top'. Mapping depends on the parent element’s 'writing-mode', 'direction', and 'text-orientation'.",restrictions:["length","percentage"]},{name:"margin-bottom",values:[{name:"auto"}],syntax:"<length> | <percentage> | auto",relevance:92,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/margin-bottom"}],description:"Shorthand property to set values for the thickness of the margin area. If left is omitted, it is the same as right. If bottom is omitted it is the same as top, if right is omitted it is the same as top. Negative values for margin properties are allowed, but there may be implementation-specific limits..",restrictions:["length","percentage"]},{name:"margin-inline-end",browsers:["E79","FF41","S12.1","C69","O56"],values:[{name:"auto"}],syntax:"<'margin-left'>",relevance:51,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/margin-inline-end"}],description:"Logical 'margin-right'. Mapping depends on the parent element’s 'writing-mode', 'direction', and 'text-orientation'.",restrictions:["length","percentage"]},{name:"margin-inline-start",browsers:["E79","FF41","S12.1","C69","O56"],values:[{name:"auto"}],syntax:"<'margin-left'>",relevance:51,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/margin-inline-start"}],description:"Logical 'margin-left'. Mapping depends on the parent element’s 'writing-mode', 'direction', and 'text-orientation'.",restrictions:["length","percentage"]},{name:"margin-left",values:[{name:"auto"}],syntax:"<length> | <percentage> | auto",relevance:92,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/margin-left"}],description:"Shorthand property to set values for the thickness of the margin area. If left is omitted, it is the same as right. If bottom is omitted it is the same as top, if right is omitted it is the same as top. Negative values for margin properties are allowed, but there may be implementation-specific limits..",restrictions:["length","percentage"]},{name:"margin-right",values:[{name:"auto"}],syntax:"<length> | <percentage> | auto",relevance:91,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/margin-right"}],description:"Shorthand property to set values for the thickness of the margin area. If left is omitted, it is the same as right. If bottom is omitted it is the same as top, if right is omitted it is the same as top. Negative values for margin properties are allowed, but there may be implementation-specific limits..",restrictions:["length","percentage"]},{name:"margin-top",values:[{name:"auto"}],syntax:"<length> | <percentage> | auto",relevance:95,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/margin-top"}],description:"Shorthand property to set values for the thickness of the margin area. If left is omitted, it is the same as right. If bottom is omitted it is the same as top, if right is omitted it is the same as top. Negative values for margin properties are allowed, but there may be implementation-specific limits..",restrictions:["length","percentage"]},{name:"marker",values:[{name:"none",description:"Indicates that no marker symbol will be drawn at the given vertex or vertices."},{name:"url()",description:"Indicates that the <marker> element referenced will be used."}],relevance:50,description:"Specifies the marker symbol that shall be used for all points on the sets the value for all vertices on the given ‘path’ element or basic shape.",restrictions:["url"]},{name:"marker-end",values:[{name:"none",description:"Indicates that no marker symbol will be drawn at the given vertex or vertices."},{name:"url()",description:"Indicates that the <marker> element referenced will be used."}],relevance:50,description:"Specifies the marker that will be drawn at the last vertices of the given markable element.",restrictions:["url"]},{name:"marker-mid",values:[{name:"none",description:"Indicates that no marker symbol will be drawn at the given vertex or vertices."},{name:"url()",description:"Indicates that the <marker> element referenced will be used."}],relevance:50,description:"Specifies the marker that will be drawn at all vertices except the first and last.",restrictions:["url"]},{name:"marker-start",values:[{name:"none",description:"Indicates that no marker symbol will be drawn at the given vertex or vertices."},{name:"url()",description:"Indicates that the <marker> element referenced will be used."}],relevance:50,description:"Specifies the marker that will be drawn at the first vertices of the given markable element.",restrictions:["url"]},{name:"mask-image",browsers:["E79","FF53","S4","C1","O15"],values:[{name:"none",description:"Counts as a transparent black image layer."},{name:"url()",description:"Reference to a <mask element or to a CSS image."}],syntax:"<mask-reference>#",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/mask-image"}],description:"Sets the mask layer image of an element.",restrictions:["url","image","enum"]},{name:"mask-mode",browsers:["FF53"],values:[{name:"alpha",description:"Alpha values of the mask layer image should be used as the mask values."},{name:"auto",description:"Use alpha values if 'mask-image' is an image, luminance if a <mask> element or a CSS image."},{name:"luminance",description:"Luminance values of the mask layer image should be used as the mask values."}],syntax:"<masking-mode>#",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/mask-mode"}],description:"Indicates whether the mask layer image is treated as luminance mask or alpha mask.",restrictions:["url","image","enum"]},{name:"mask-origin",browsers:["E79","FF53","S4","C1","O15"],syntax:"<geometry-box>#",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/mask-origin"}],description:"Specifies the mask positioning area.",restrictions:["geometry-box","enum"]},{name:"mask-position",browsers:["E79","FF53","S3.1","C1","O15"],syntax:"<position>#",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/mask-position"}],description:"Specifies how mask layer images are positioned.",restrictions:["position","length","percentage"]},{name:"mask-repeat",browsers:["E79","FF53","S3.1","C1","O15"],syntax:"<repeat-style>#",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/mask-repeat"}],description:"Specifies how mask layer images are tiled after they have been sized and positioned.",restrictions:["repeat"]},{name:"mask-size",browsers:["E79","FF53","S4","C4","O15"],values:[{name:"auto",description:"Resolved by using the image’s intrinsic ratio and the size of the other dimension, or failing that, using the image’s intrinsic size, or failing that, treating it as 100%."},{name:"contain",description:"Scale the image, while preserving its intrinsic aspect ratio (if any), to the largest size such that both its width and its height can fit inside the background positioning area."},{name:"cover",description:"Scale the image, while preserving its intrinsic aspect ratio (if any), to the smallest size such that both its width and its height can completely cover the background positioning area."}],syntax:"<bg-size>#",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/mask-size"}],description:"Specifies the size of the mask layer images.",restrictions:["length","percentage","enum"]},{name:"mask-type",browsers:["E79","FF35","S7","C24","O15"],values:[{name:"alpha",description:"Indicates that the alpha values of the mask should be used."},{name:"luminance",description:"Indicates that the luminance values of the mask should be used."}],syntax:"luminance | alpha",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/mask-type"}],description:"Defines whether the content of the <mask> element is treated as as luminance mask or alpha mask.",restrictions:["enum"]},{name:"max-block-size",browsers:["E79","FF41","S12.1","C57","O44"],values:[{name:"none",description:"No limit on the width of the box."}],syntax:"<'max-width'>",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/max-block-size"}],description:"Maximum size of an element in the direction opposite that of the direction specified by 'writing-mode'.",restrictions:["length","percentage"]},{name:"max-height",values:[{name:"none",description:"No limit on the height of the box."},{name:"fit-content",description:"Use the fit-content inline size or fit-content block size, as appropriate to the writing mode."},{name:"max-content",description:"Use the max-content inline size or max-content block size, as appropriate to the writing mode."},{name:"min-content",description:"Use the min-content inline size or min-content block size, as appropriate to the writing mode."}],syntax:"<viewport-length>",relevance:86,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/max-height"}],description:"Allows authors to constrain content height to a certain range.",restrictions:["length","percentage"]},{name:"max-inline-size",browsers:["E79","FF41","S12.1","C57","O44"],values:[{name:"none",description:"No limit on the height of the box."}],syntax:"<'max-width'>",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/max-inline-size"}],description:"Maximum size of an element in the direction specified by 'writing-mode'.",restrictions:["length","percentage"]},{name:"max-width",values:[{name:"none",description:"No limit on the width of the box."},{name:"fit-content",description:"Use the fit-content inline size or fit-content block size, as appropriate to the writing mode."},{name:"max-content",description:"Use the max-content inline size or max-content block size, as appropriate to the writing mode."},{name:"min-content",description:"Use the min-content inline size or min-content block size, as appropriate to the writing mode."}],syntax:"<viewport-length>",relevance:91,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/max-width"}],description:"Allows authors to constrain content width to a certain range.",restrictions:["length","percentage"]},{name:"min-block-size",browsers:["E79","FF41","S12.1","C57","O44"],syntax:"<'min-width'>",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/min-block-size"}],description:"Minimal size of an element in the direction opposite that of the direction specified by 'writing-mode'.",restrictions:["length","percentage"]},{name:"min-height",values:[{name:"auto"},{name:"fit-content",description:"Use the fit-content inline size or fit-content block size, as appropriate to the writing mode."},{name:"max-content",description:"Use the max-content inline size or max-content block size, as appropriate to the writing mode."},{name:"min-content",description:"Use the min-content inline size or min-content block size, as appropriate to the writing mode."}],syntax:"<viewport-length>",relevance:90,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/min-height"}],description:"Allows authors to constrain content height to a certain range.",restrictions:["length","percentage"]},{name:"min-inline-size",browsers:["E79","FF41","S12.1","C57","O44"],syntax:"<'min-width'>",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/min-inline-size"}],description:"Minimal size of an element in the direction specified by 'writing-mode'.",restrictions:["length","percentage"]},{name:"min-width",values:[{name:"auto"},{name:"fit-content",description:"Use the fit-content inline size or fit-content block size, as appropriate to the writing mode."},{name:"max-content",description:"Use the max-content inline size or max-content block size, as appropriate to the writing mode."},{name:"min-content",description:"Use the min-content inline size or min-content block size, as appropriate to the writing mode."}],syntax:"<viewport-length>",relevance:89,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/min-width"}],description:"Allows authors to constrain content width to a certain range.",restrictions:["length","percentage"]},{name:"mix-blend-mode",browsers:["E79","FF32","S8","C41","O28"],values:[{name:"normal",description:"Default attribute which specifies no blending"},{name:"multiply",description:"The source color is multiplied by the destination color and replaces the destination."},{name:"screen",description:"Multiplies the complements of the backdrop and source color values, then complements the result."},{name:"overlay",description:"Multiplies or screens the colors, depending on the backdrop color value."},{name:"darken",description:"Selects the darker of the backdrop and source colors."},{name:"lighten",description:"Selects the lighter of the backdrop and source colors."},{name:"color-dodge",description:"Brightens the backdrop color to reflect the source color."},{name:"color-burn",description:"Darkens the backdrop color to reflect the source color."},{name:"hard-light",description:"Multiplies or screens the colors, depending on the source color value."},{name:"soft-light",description:"Darkens or lightens the colors, depending on the source color value."},{name:"difference",description:"Subtracts the darker of the two constituent colors from the lighter color.."},{name:"exclusion",description:"Produces an effect similar to that of the Difference mode but lower in contrast."},{name:"hue",browsers:["E79","FF32","S8","C41","O28"],description:"Creates a color with the hue of the source color and the saturation and luminosity of the backdrop color."},{name:"saturation",browsers:["E79","FF32","S8","C41","O28"],description:"Creates a color with the saturation of the source color and the hue and luminosity of the backdrop color."},{name:"color",browsers:["E79","FF32","S8","C41","O28"],description:"Creates a color with the hue and saturation of the source color and the luminosity of the backdrop color."},{name:"luminosity",browsers:["E79","FF32","S8","C41","O28"],description:"Creates a color with the luminosity of the source color and the hue and saturation of the backdrop color."}],syntax:"<blend-mode>",relevance:52,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/mix-blend-mode"}],description:"Defines the formula that must be used to mix the colors with the backdrop.",restrictions:["enum"]},{name:"motion",browsers:["C46","O33"],values:[{name:"none",description:"No motion path gets created."},{name:"path()",description:"Defines an SVG path as a string, with optional 'fill-rule' as the first argument."},{name:"auto",description:"Indicates that the object is rotated by the angle of the direction of the motion path."},{name:"reverse",description:"Indicates that the object is rotated by the angle of the direction of the motion path plus 180 degrees."}],relevance:50,description:"Shorthand property for setting 'motion-path', 'motion-offset' and 'motion-rotation'.",restrictions:["url","length","percentage","angle","shape","geometry-box","enum"]},{name:"motion-offset",browsers:["C46","O33"],relevance:50,description:"A distance that describes the position along the specified motion path.",restrictions:["length","percentage"]},{name:"motion-path",browsers:["C46","O33"],values:[{name:"none",description:"No motion path gets created."},{name:"path()",description:"Defines an SVG path as a string, with optional 'fill-rule' as the first argument."}],relevance:50,description:"Specifies the motion path the element gets positioned at.",restrictions:["url","shape","geometry-box","enum"]},{name:"motion-rotation",browsers:["C46","O33"],values:[{name:"auto",description:"Indicates that the object is rotated by the angle of the direction of the motion path."},{name:"reverse",description:"Indicates that the object is rotated by the angle of the direction of the motion path plus 180 degrees."}],relevance:50,description:"Defines the direction of the element while positioning along the motion path.",restrictions:["angle"]},{name:"-moz-animation",browsers:["FF9"],values:[{name:"alternate",description:"The animation cycle iterations that are odd counts are played in the normal direction, and the animation cycle iterations that are even counts are played in a reverse direction."},{name:"alternate-reverse",description:"The animation cycle iterations that are odd counts are played in the reverse direction, and the animation cycle iterations that are even counts are played in a normal direction."},{name:"backwards",description:"The beginning property value (as defined in the first @keyframes at-rule) is applied before the animation is displayed, during the period defined by 'animation-delay'."},{name:"both",description:"Both forwards and backwards fill modes are applied."},{name:"forwards",description:"The final property value (as defined in the last @keyframes at-rule) is maintained after the animation completes."},{name:"infinite",description:"Causes the animation to repeat forever."},{name:"none",description:"No animation is performed"},{name:"normal",description:"Normal playback."},{name:"reverse",description:"All iterations of the animation are played in the reverse direction from the way they were specified."}],relevance:50,description:"Shorthand property combines six of the animation properties into a single property.",restrictions:["time","enum","timing-function","identifier","number"]},{name:"-moz-animation-delay",browsers:["FF9"],relevance:50,description:"Defines when the animation will start.",restrictions:["time"]},{name:"-moz-animation-direction",browsers:["FF9"],values:[{name:"alternate",description:"The animation cycle iterations that are odd counts are played in the normal direction, and the animation cycle iterations that are even counts are played in a reverse direction."},{name:"alternate-reverse",description:"The animation cycle iterations that are odd counts are played in the reverse direction, and the animation cycle iterations that are even counts are played in a normal direction."},{name:"normal",description:"Normal playback."},{name:"reverse",description:"All iterations of the animation are played in the reverse direction from the way they were specified."}],relevance:50,description:"Defines whether or not the animation should play in reverse on alternate cycles.",restrictions:["enum"]},{name:"-moz-animation-duration",browsers:["FF9"],relevance:50,description:"Defines the length of time that an animation takes to complete one cycle.",restrictions:["time"]},{name:"-moz-animation-iteration-count",browsers:["FF9"],values:[{name:"infinite",description:"Causes the animation to repeat forever."}],relevance:50,description:"Defines the number of times an animation cycle is played. The default value is one, meaning the animation will play from beginning to end once.",restrictions:["number","enum"]},{name:"-moz-animation-name",browsers:["FF9"],values:[{name:"none",description:"No animation is performed"}],relevance:50,description:"Defines a list of animations that apply. Each name is used to select the keyframe at-rule that provides the property values for the animation.",restrictions:["identifier","enum"]},{name:"-moz-animation-play-state",browsers:["FF9"],values:[{name:"paused",description:"A running animation will be paused."},{name:"running",description:"Resume playback of a paused animation."}],relevance:50,description:"Defines whether the animation is running or paused.",restrictions:["enum"]},{name:"-moz-animation-timing-function",browsers:["FF9"],relevance:50,description:"Describes how the animation will progress over one cycle of its duration. See the 'transition-timing-function'.",restrictions:["timing-function"]},{name:"-moz-appearance",browsers:["FF1"],values:[{name:"button"},{name:"button-arrow-down"},{name:"button-arrow-next"},{name:"button-arrow-previous"},{name:"button-arrow-up"},{name:"button-bevel"},{name:"checkbox"},{name:"checkbox-container"},{name:"checkbox-label"},{name:"dialog"},{name:"groupbox"},{name:"listbox"},{name:"menuarrow"},{name:"menuimage"},{name:"menuitem"},{name:"menuitemtext"},{name:"menulist"},{name:"menulist-button"},{name:"menulist-text"},{name:"menulist-textfield"},{name:"menupopup"},{name:"menuradio"},{name:"menuseparator"},{name:"-moz-mac-unified-toolbar"},{name:"-moz-win-borderless-glass"},{name:"-moz-win-browsertabbar-toolbox"},{name:"-moz-win-communications-toolbox"},{name:"-moz-win-glass"},{name:"-moz-win-media-toolbox"},{name:"none"},{name:"progressbar"},{name:"progresschunk"},{name:"radio"},{name:"radio-container"},{name:"radio-label"},{name:"radiomenuitem"},{name:"resizer"},{name:"resizerpanel"},{name:"scrollbarbutton-down"},{name:"scrollbarbutton-left"},{name:"scrollbarbutton-right"},{name:"scrollbarbutton-up"},{name:"scrollbar-small"},{name:"scrollbartrack-horizontal"},{name:"scrollbartrack-vertical"},{name:"separator"},{name:"spinner"},{name:"spinner-downbutton"},{name:"spinner-textfield"},{name:"spinner-upbutton"},{name:"statusbar"},{name:"statusbarpanel"},{name:"tab"},{name:"tabpanels"},{name:"tab-scroll-arrow-back"},{name:"tab-scroll-arrow-forward"},{name:"textfield"},{name:"textfield-multiline"},{name:"toolbar"},{name:"toolbox"},{name:"tooltip"},{name:"treeheadercell"},{name:"treeheadersortarrow"},{name:"treeitem"},{name:"treetwistyopen"},{name:"treeview"},{name:"treewisty"},{name:"window"}],status:"nonstandard",syntax:"none | button | button-arrow-down | button-arrow-next | button-arrow-previous | button-arrow-up | button-bevel | button-focus | caret | checkbox | checkbox-container | checkbox-label | checkmenuitem | dualbutton | groupbox | listbox | listitem | menuarrow | menubar | menucheckbox | menuimage | menuitem | menuitemtext | menulist | menulist-button | menulist-text | menulist-textfield | menupopup | menuradio | menuseparator | meterbar | meterchunk | progressbar | progressbar-vertical | progresschunk | progresschunk-vertical | radio | radio-container | radio-label | radiomenuitem | range | range-thumb | resizer | resizerpanel | scale-horizontal | scalethumbend | scalethumb-horizontal | scalethumbstart | scalethumbtick | scalethumb-vertical | scale-vertical | scrollbarbutton-down | scrollbarbutton-left | scrollbarbutton-right | scrollbarbutton-up | scrollbarthumb-horizontal | scrollbarthumb-vertical | scrollbartrack-horizontal | scrollbartrack-vertical | searchfield | separator | sheet | spinner | spinner-downbutton | spinner-textfield | spinner-upbutton | splitter | statusbar | statusbarpanel | tab | tabpanel | tabpanels | tab-scroll-arrow-back | tab-scroll-arrow-forward | textfield | textfield-multiline | toolbar | toolbarbutton | toolbarbutton-dropdown | toolbargripper | toolbox | tooltip | treeheader | treeheadercell | treeheadersortarrow | treeitem | treeline | treetwisty | treetwistyopen | treeview | -moz-mac-unified-toolbar | -moz-win-borderless-glass | -moz-win-browsertabbar-toolbox | -moz-win-communicationstext | -moz-win-communications-toolbox | -moz-win-exclude-glass | -moz-win-glass | -moz-win-mediatext | -moz-win-media-toolbox | -moz-window-button-box | -moz-window-button-box-maximized | -moz-window-button-close | -moz-window-button-maximize | -moz-window-button-minimize | -moz-window-button-restore | -moz-window-frame-bottom | -moz-window-frame-left | -moz-window-frame-right | -moz-window-titlebar | -moz-window-titlebar-maximized",relevance:0,description:"Used in Gecko (Firefox) to display an element using a platform-native styling based on the operating system's theme.",restrictions:["enum"]},{name:"-moz-backface-visibility",browsers:["FF10"],values:[{name:"hidden"},{name:"visible"}],relevance:50,description:"Determines whether or not the 'back' side of a transformed element is visible when facing the viewer. With an identity transform, the front side of an element faces the viewer.",restrictions:["enum"]},{name:"-moz-background-clip",browsers:["FF1-3.6"],values:[{name:"padding"}],relevance:50,description:"Determines the background painting area.",restrictions:["box","enum"]},{name:"-moz-background-inline-policy",browsers:["FF1"],values:[{name:"bounding-box"},{name:"continuous"},{name:"each-box"}],relevance:50,description:"In Gecko-based applications like Firefox, the -moz-background-inline-policy CSS property specifies how the background image of an inline element is determined when the content of the inline element wraps onto multiple lines. The choice of position has significant effects on repetition.",restrictions:["enum"]},{name:"-moz-background-origin",browsers:["FF1"],relevance:50,description:"For elements rendered as a single box, specifies the background positioning area. For elements rendered as multiple boxes (e.g., inline boxes on several lines, boxes on several pages) specifies which boxes 'box-decoration-break' operates on to determine the background positioning area(s).",restrictions:["box"]},{name:"-moz-border-bottom-colors",browsers:["FF1"],status:"nonstandard",syntax:"<color>+ | none",relevance:0,description:"Sets a list of colors for the bottom border.",restrictions:["color"]},{name:"-moz-border-image",browsers:["FF3.6"],values:[{name:"auto",description:"If 'auto' is specified then the border image width is the intrinsic width or height (whichever is applicable) of the corresponding image slice. If the image does not have the required intrinsic dimension then the corresponding border-width is used instead."},{name:"fill",description:"Causes the middle part of the border-image to be preserved."},{name:"none"},{name:"repeat",description:"The image is tiled (repeated) to fill the area."},{name:"round",description:"The image is tiled (repeated) to fill the area. If it does not fill the area with a whole number of tiles, the image is rescaled so that it does."},{name:"space",description:"The image is tiled (repeated) to fill the area. If it does not fill the area with a whole number of tiles, the extra space is distributed around the tiles."},{name:"stretch",description:"The image is stretched to fill the area."},{name:"url()"}],relevance:50,description:"Shorthand property for setting 'border-image-source', 'border-image-slice', 'border-image-width', 'border-image-outset' and 'border-image-repeat'. Omitted values are set to their initial values.",restrictions:["length","percentage","number","url","enum"]},{name:"-moz-border-left-colors",browsers:["FF1"],status:"nonstandard",syntax:"<color>+ | none",relevance:0,description:"Sets a list of colors for the bottom border.",restrictions:["color"]},{name:"-moz-border-right-colors",browsers:["FF1"],status:"nonstandard",syntax:"<color>+ | none",relevance:0,description:"Sets a list of colors for the bottom border.",restrictions:["color"]},{name:"-moz-border-top-colors",browsers:["FF1"],status:"nonstandard",syntax:"<color>+ | none",relevance:0,description:"Ske Firefox, -moz-border-bottom-colors sets a list of colors for the bottom border.",restrictions:["color"]},{name:"-moz-box-align",browsers:["FF1"],values:[{name:"baseline",description:"If this box orientation is inline-axis or horizontal, all children are placed with their baselines aligned, and extra space placed before or after as necessary. For block flows, the baseline of the first non-empty line box located within the element is used. For tables, the baseline of the first cell is used."},{name:"center",description:"Any extra space is divided evenly, with half placed above the child and the other half placed after the child."},{name:"end",description:"For normal direction boxes, the bottom edge of each child is placed along the bottom of the box. Extra space is placed above the element. For reverse direction boxes, the top edge of each child is placed along the top of the box. Extra space is placed below the element."},{name:"start",description:"For normal direction boxes, the top edge of each child is placed along the top of the box. Extra space is placed below the element. For reverse direction boxes, the bottom edge of each child is placed along the bottom of the box. Extra space is placed above the element."},{name:"stretch",description:"The height of each child is adjusted to that of the containing block."}],relevance:50,description:"Specifies how a XUL box aligns its contents across (perpendicular to) the direction of its layout. The effect of this is only visible if there is extra space in the box.",restrictions:["enum"]},{name:"-moz-box-direction",browsers:["FF1"],values:[{name:"normal",description:"A box with a computed value of horizontal for box-orient displays its children from left to right. A box with a computed value of vertical displays its children from top to bottom."},{name:"reverse",description:"A box with a computed value of horizontal for box-orient displays its children from right to left. A box with a computed value of vertical displays its children from bottom to top."}],relevance:50,description:"Specifies whether a box lays out its contents normally (from the top or left edge), or in reverse (from the bottom or right edge).",restrictions:["enum"]},{name:"-moz-box-flex",browsers:["FF1"],relevance:50,description:"Specifies how a box grows to fill the box that contains it, in the direction of the containing box's layout.",restrictions:["number"]},{name:"-moz-box-flexgroup",browsers:["FF1"],relevance:50,description:"Flexible elements can be assigned to flex groups using the 'box-flex-group' property.",restrictions:["integer"]},{name:"-moz-box-ordinal-group",browsers:["FF1"],relevance:50,description:"Indicates the ordinal group the element belongs to. Elements with a lower ordinal group are displayed before those with a higher ordinal group.",restrictions:["integer"]},{name:"-moz-box-orient",browsers:["FF1"],values:[{name:"block-axis",description:"Elements are oriented along the box's axis."},{name:"horizontal",description:"The box displays its children from left to right in a horizontal line."},{name:"inline-axis",description:"Elements are oriented vertically."},{name:"vertical",description:"The box displays its children from stacked from top to bottom vertically."}],relevance:50,description:"In Mozilla applications, -moz-box-orient specifies whether a box lays out its contents horizontally or vertically.",restrictions:["enum"]},{name:"-moz-box-pack",browsers:["FF1"],values:[{name:"center",description:"The extra space is divided evenly, with half placed before the first child and the other half placed after the last child."},{name:"end",description:"For normal direction boxes, the right edge of the last child is placed at the right side, with all extra space placed before the first child. For reverse direction boxes, the left edge of the first child is placed at the left side, with all extra space placed after the last child."},{name:"justify",description:"The space is divided evenly in-between each child, with none of the extra space placed before the first child or after the last child. If there is only one child, treat the pack value as if it were start."},{name:"start",description:"For normal direction boxes, the left edge of the first child is placed at the left side, with all extra space placed after the last child. For reverse direction boxes, the right edge of the last child is placed at the right side, with all extra space placed before the first child."}],relevance:50,description:"Specifies how a box packs its contents in the direction of its layout. The effect of this is only visible if there is extra space in the box.",restrictions:["enum"]},{name:"-moz-box-sizing",browsers:["FF1"],values:[{name:"border-box",description:"The specified width and height (and respective min/max properties) on this element determine the border box of the element."},{name:"content-box",description:"Behavior of width and height as specified by CSS2.1. The specified width and height (and respective min/max properties) apply to the width and height respectively of the content box of the element."},{name:"padding-box",description:"The specified width and height (and respective min/max properties) on this element determine the padding box of the element."}],relevance:50,description:"Box Model addition in CSS3.",restrictions:["enum"]},{name:"-moz-column-count",browsers:["FF3.5"],values:[{name:"auto",description:"Determines the number of columns by the 'column-width' property and the element width."}],relevance:50,description:"Describes the optimal number of columns into which the content of the element will be flowed.",restrictions:["integer"]},{name:"-moz-column-gap",browsers:["FF3.5"],values:[{name:"normal",description:"User agent specific and typically equivalent to 1em."}],relevance:50,description:"Sets the gap between columns. If there is a column rule between columns, it will appear in the middle of the gap.",restrictions:["length"]},{name:"-moz-column-rule",browsers:["FF3.5"],relevance:50,description:"Shorthand for setting 'column-rule-width', 'column-rule-style', and 'column-rule-color' at the same place in the style sheet. Omitted values are set to their initial values.",restrictions:["length","line-width","line-style","color"]},{name:"-moz-column-rule-color",browsers:["FF3.5"],relevance:50,description:"Sets the color of the column rule",restrictions:["color"]},{name:"-moz-column-rule-style",browsers:["FF3.5"],relevance:50,description:"Sets the style of the rule between columns of an element.",restrictions:["line-style"]},{name:"-moz-column-rule-width",browsers:["FF3.5"],relevance:50,description:"Sets the width of the rule between columns. Negative values are not allowed.",restrictions:["length","line-width"]},{name:"-moz-columns",browsers:["FF9"],values:[{name:"auto",description:"The width depends on the values of other properties."}],relevance:50,description:"A shorthand property which sets both 'column-width' and 'column-count'.",restrictions:["length","integer"]},{name:"-moz-column-width",browsers:["FF3.5"],values:[{name:"auto",description:"The width depends on the values of other properties."}],relevance:50,description:"This property describes the width of columns in multicol elements.",restrictions:["length"]},{name:"-moz-font-feature-settings",browsers:["FF4"],values:[{name:'"c2cs"'},{name:'"dlig"'},{name:'"kern"'},{name:'"liga"'},{name:'"lnum"'},{name:'"onum"'},{name:'"smcp"'},{name:'"swsh"'},{name:'"tnum"'},{name:"normal",description:"No change in glyph substitution or positioning occurs."},{name:"off",browsers:["FF4"]},{name:"on",browsers:["FF4"]}],relevance:50,description:"Provides low-level control over OpenType font features. It is intended as a way of providing access to font features that are not widely used but are needed for a particular use case.",restrictions:["string","integer"]},{name:"-moz-hyphens",browsers:["FF9"],values:[{name:"auto",description:"Conditional hyphenation characters inside a word, if present, take priority over automatic resources when determining hyphenation points within the word."},{name:"manual",description:"Words are only broken at line breaks where there are characters inside the word that suggest line break opportunities"},{name:"none",description:"Words are not broken at line breaks, even if characters inside the word suggest line break points."}],relevance:50,description:"Controls whether hyphenation is allowed to create more break opportunities within a line of text.",restrictions:["enum"]},{name:"-moz-perspective",browsers:["FF10"],values:[{name:"none",description:"No perspective transform is applied."}],relevance:50,description:"Applies the same transform as the perspective(<number>) transform function, except that it applies only to the positioned or transformed children of the element, not to the transform on the element itself.",restrictions:["length"]},{name:"-moz-perspective-origin",browsers:["FF10"],relevance:50,description:"Establishes the origin for the perspective property. It effectively sets the X and Y position at which the viewer appears to be looking at the children of the element.",restrictions:["position","percentage","length"]},{name:"-moz-text-align-last",browsers:["FF12"],values:[{name:"auto"},{name:"center",description:"The inline contents are centered within the line box."},{name:"justify",description:"The text is justified according to the method specified by the 'text-justify' property."},{name:"left",description:"The inline contents are aligned to the left edge of the line box. In vertical text, 'left' aligns to the edge of the line box that would be the start edge for left-to-right text."},{name:"right",description:"The inline contents are aligned to the right edge of the line box. In vertical text, 'right' aligns to the edge of the line box that would be the end edge for left-to-right text."}],relevance:50,description:"Describes how the last line of a block or a line right before a forced line break is aligned when 'text-align' is set to 'justify'.",restrictions:["enum"]},{name:"-moz-text-decoration-color",browsers:["FF6"],relevance:50,description:"Specifies the color of text decoration (underlines overlines, and line-throughs) set on the element with text-decoration-line.",restrictions:["color"]},{name:"-moz-text-decoration-line",browsers:["FF6"],values:[{name:"line-through",description:"Each line of text has a line through the middle."},{name:"none",description:"Neither produces nor inhibits text decoration."},{name:"overline",description:"Each line of text has a line above it."},{name:"underline",description:"Each line of text is underlined."}],relevance:50,description:"Specifies what line decorations, if any, are added to the element.",restrictions:["enum"]},{name:"-moz-text-decoration-style",browsers:["FF6"],values:[{name:"dashed",description:"Produces a dashed line style."},{name:"dotted",description:"Produces a dotted line."},{name:"double",description:"Produces a double line."},{name:"none",description:"Produces no line."},{name:"solid",description:"Produces a solid line."},{name:"wavy",description:"Produces a wavy line."}],relevance:50,description:"Specifies the line style for underline, line-through and overline text decoration.",restrictions:["enum"]},{name:"-moz-text-size-adjust",browsers:["FF"],values:[{name:"auto",description:"Renderers must use the default size adjustment when displaying on a small device."},{name:"none",description:"Renderers must not do size adjustment when displaying on a small device."}],relevance:50,description:"Specifies a size adjustment for displaying text content in mobile browsers.",restrictions:["enum","percentage"]},{name:"-moz-transform",browsers:["FF3.5"],values:[{name:"matrix()",description:"Specifies a 2D transformation in the form of a transformation matrix of six values. matrix(a,b,c,d,e,f) is equivalent to applying the transformation matrix [a b c d e f]"},{name:"matrix3d()",description:"Specifies a 3D transformation as a 4x4 homogeneous matrix of 16 values in column-major order."},{name:"none"},{name:"perspective",description:"Specifies a perspective projection matrix."},{name:"rotate()",description:"Specifies a 2D rotation by the angle specified in the parameter about the origin of the element, as defined by the transform-origin property."},{name:"rotate3d()",description:"Specifies a clockwise 3D rotation by the angle specified in last parameter about the [x,y,z] direction vector described by the first 3 parameters."},{name:"rotateX('angle')",description:"Specifies a clockwise rotation by the given angle about the X axis."},{name:"rotateY('angle')",description:"Specifies a clockwise rotation by the given angle about the Y axis."},{name:"rotateZ('angle')",description:"Specifies a clockwise rotation by the given angle about the Z axis."},{name:"scale()",description:"Specifies a 2D scale operation by the [sx,sy] scaling vector described by the 2 parameters. If the second parameter is not provided, it is takes a value equal to the first."},{name:"scale3d()",description:"Specifies a 3D scale operation by the [sx,sy,sz] scaling vector described by the 3 parameters."},{name:"scaleX()",description:"Specifies a scale operation using the [sx,1] scaling vector, where sx is given as the parameter."},{name:"scaleY()",description:"Specifies a scale operation using the [sy,1] scaling vector, where sy is given as the parameter."},{name:"scaleZ()",description:"Specifies a scale operation using the [1,1,sz] scaling vector, where sz is given as the parameter."},{name:"skew()",description:"Specifies a skew transformation along the X and Y axes. The first angle parameter specifies the skew on the X axis. The second angle parameter specifies the skew on the Y axis. If the second parameter is not given then a value of 0 is used for the Y angle (ie: no skew on the Y axis)."},{name:"skewX()",description:"Specifies a skew transformation along the X axis by the given angle."},{name:"skewY()",description:"Specifies a skew transformation along the Y axis by the given angle."},{name:"translate()",description:"Specifies a 2D translation by the vector [tx, ty], where tx is the first translation-value parameter and ty is the optional second translation-value parameter."},{name:"translate3d()",description:"Specifies a 3D translation by the vector [tx,ty,tz], with tx, ty and tz being the first, second and third translation-value parameters respectively."},{name:"translateX()",description:"Specifies a translation by the given amount in the X direction."},{name:"translateY()",description:"Specifies a translation by the given amount in the Y direction."},{name:"translateZ()",description:"Specifies a translation by the given amount in the Z direction. Note that percentage values are not allowed in the translateZ translation-value, and if present are evaluated as 0."}],relevance:50,description:"A two-dimensional transformation is applied to an element through the 'transform' property. This property contains a list of transform functions similar to those allowed by SVG.",restrictions:["enum"]},{name:"-moz-transform-origin",browsers:["FF3.5"],relevance:50,description:"Establishes the origin of transformation for an element.",restrictions:["position","length","percentage"]},{name:"-moz-transition",browsers:["FF4"],values:[{name:"all",description:"Every property that is able to undergo a transition will do so."},{name:"none",description:"No property will transition."}],relevance:50,description:"Shorthand property combines four of the transition properties into a single property.",restrictions:["time","property","timing-function","enum"]},{name:"-moz-transition-delay",browsers:["FF4"],relevance:50,description:"Defines when the transition will start. It allows a transition to begin execution some period of time from when it is applied.",restrictions:["time"]},{name:"-moz-transition-duration",browsers:["FF4"],relevance:50,description:"Specifies how long the transition from the old value to the new value should take.",restrictions:["time"]},{name:"-moz-transition-property",browsers:["FF4"],values:[{name:"all",description:"Every property that is able to undergo a transition will do so."},{name:"none",description:"No property will transition."}],relevance:50,description:"Specifies the name of the CSS property to which the transition is applied.",restrictions:["property"]},{name:"-moz-transition-timing-function",browsers:["FF4"],relevance:50,description:"Describes how the intermediate values used during a transition will be calculated.",restrictions:["timing-function"]},{name:"-moz-user-focus",browsers:["FF1"],values:[{name:"ignore"},{name:"normal"}],status:"nonstandard",syntax:"ignore | normal | select-after | select-before | select-menu | select-same | select-all | none",relevance:0,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/-moz-user-focus"}],description:"Used to indicate whether the element can have focus."},{name:"-moz-user-select",browsers:["FF1.5"],values:[{name:"all"},{name:"element"},{name:"elements"},{name:"-moz-all"},{name:"-moz-none"},{name:"none"},{name:"text"},{name:"toggle"}],relevance:50,description:"Controls the appearance of selection.",restrictions:["enum"]},{name:"-ms-accelerator",browsers:["E","IE10"],values:[{name:"false",description:"The element does not contain an accelerator key sequence."},{name:"true",description:"The element contains an accelerator key sequence."}],status:"nonstandard",syntax:"false | true",relevance:0,description:"IE only. Has the ability to turn off its system underlines for accelerator keys until the ALT key is pressed",restrictions:["enum"]},{name:"-ms-behavior",browsers:["IE8"],relevance:50,description:"IE only. Used to extend behaviors of the browser",restrictions:["url"]},{name:"-ms-block-progression",browsers:["IE8"],values:[{name:"bt",description:"Bottom-to-top block flow. Layout is horizontal."},{name:"lr",description:"Left-to-right direction. The flow orientation is vertical."},{name:"rl",description:"Right-to-left direction. The flow orientation is vertical."},{name:"tb",description:"Top-to-bottom direction. The flow orientation is horizontal."}],status:"nonstandard",syntax:"tb | rl | bt | lr",relevance:0,description:"Sets the block-progression value and the flow orientation",restrictions:["enum"]},{name:"-ms-content-zoom-chaining",browsers:["E","IE10"],values:[{name:"chained",description:"The nearest zoomable parent element begins zooming when the user hits a zoom limit during a manipulation. No bounce effect is shown."},{name:"none",description:"A bounce effect is shown when the user hits a zoom limit during a manipulation."}],status:"nonstandard",syntax:"none | chained",relevance:0,description:"Specifies the zoom behavior that occurs when a user hits the zoom limit during a manipulation."},{name:"-ms-content-zooming",browsers:["E","IE10"],values:[{name:"none",description:"The element is not zoomable."},{name:"zoom",description:"The element is zoomable."}],status:"nonstandard",syntax:"none | zoom",relevance:0,description:"Specifies whether zooming is enabled.",restrictions:["enum"]},{name:"-ms-content-zoom-limit",browsers:["E","IE10"],status:"nonstandard",syntax:"<'-ms-content-zoom-limit-min'> <'-ms-content-zoom-limit-max'>",relevance:0,description:"Shorthand property for the -ms-content-zoom-limit-min and -ms-content-zoom-limit-max properties.",restrictions:["percentage"]},{name:"-ms-content-zoom-limit-max",browsers:["E","IE10"],status:"nonstandard",syntax:"<percentage>",relevance:0,description:"Specifies the maximum zoom factor.",restrictions:["percentage"]},{name:"-ms-content-zoom-limit-min",browsers:["E","IE10"],status:"nonstandard",syntax:"<percentage>",relevance:0,description:"Specifies the minimum zoom factor.",restrictions:["percentage"]},{name:"-ms-content-zoom-snap",browsers:["E","IE10"],values:[{name:"mandatory",description:"Indicates that the motion of the content after the contact is picked up is always adjusted so that it lands on a snap-point."},{name:"none",description:"Indicates that zooming is unaffected by any defined snap-points."},{name:"proximity",description:'Indicates that the motion of the content after the contact is picked up may be adjusted if the content would normally stop "close enough" to a snap-point.'},{name:"snapInterval(100%, 100%)",description:"Specifies where the snap-points will be placed."},{name:"snapList()",description:"Specifies the position of individual snap-points as a comma-separated list of zoom factors."}],status:"nonstandard",syntax:"<'-ms-content-zoom-snap-type'> || <'-ms-content-zoom-snap-points'>",relevance:0,description:"Shorthand property for the -ms-content-zoom-snap-type and -ms-content-zoom-snap-points properties."},{name:"-ms-content-zoom-snap-points",browsers:["E","IE10"],values:[{name:"snapInterval(100%, 100%)",description:"Specifies where the snap-points will be placed."},{name:"snapList()",description:"Specifies the position of individual snap-points as a comma-separated list of zoom factors."}],status:"nonstandard",syntax:"snapInterval( <percentage>, <percentage> ) | snapList( <percentage># )",relevance:0,description:"Defines where zoom snap-points are located."},{name:"-ms-content-zoom-snap-type",browsers:["E","IE10"],values:[{name:"mandatory",description:"Indicates that the motion of the content after the contact is picked up is always adjusted so that it lands on a snap-point."},{name:"none",description:"Indicates that zooming is unaffected by any defined snap-points."},{name:"proximity",description:'Indicates that the motion of the content after the contact is picked up may be adjusted if the content would normally stop "close enough" to a snap-point.'}],status:"nonstandard",syntax:"none | proximity | mandatory",relevance:0,description:"Specifies how zooming is affected by defined snap-points.",restrictions:["enum"]},{name:"-ms-filter",browsers:["IE8-9"],status:"nonstandard",syntax:"<string>",relevance:0,description:"IE only. Used to produce visual effects.",restrictions:["string"]},{name:"-ms-flex",browsers:["IE10"],values:[{name:"auto",description:"Retrieves the value of the main size property as the used 'flex-basis'."},{name:"none",description:"Expands to '0 0 auto'."}],relevance:50,description:"specifies the parameters of a flexible length: the positive and negative flexibility, and the preferred size.",restrictions:["length","number","percentage"]},{name:"-ms-flex-align",browsers:["IE10"],values:[{name:"baseline",description:"If the flex item’s inline axis is the same as the cross axis, this value is identical to 'flex-start'. Otherwise, it participates in baseline alignment."},{name:"center",description:"The flex item’s margin box is centered in the cross axis within the line."},{name:"end",description:"The cross-end margin edge of the flex item is placed flush with the cross-end edge of the line."},{name:"start",description:"The cross-start margin edge of the flexbox item is placed flush with the cross-start edge of the line."},{name:"stretch",description:"If the cross size property of the flexbox item is anything other than 'auto', this value is identical to 'start'."}],relevance:50,description:"Aligns flex items along the cross axis of the current line of the flex container.",restrictions:["enum"]},{name:"-ms-flex-direction",browsers:["IE10"],values:[{name:"column",description:"The flex container’s main axis has the same orientation as the block axis of the current writing mode."},{name:"column-reverse",description:"Same as 'column', except the main-start and main-end directions are swapped."},{name:"row",description:"The flex container’s main axis has the same orientation as the inline axis of the current writing mode."},{name:"row-reverse",description:"Same as 'row', except the main-start and main-end directions are swapped."}],relevance:50,description:"Specifies how flex items are placed in the flex container, by setting the direction of the flex container’s main axis.",restrictions:["enum"]},{name:"-ms-flex-flow",browsers:["IE10"],values:[{name:"column",description:"The flex container’s main axis has the same orientation as the block axis of the current writing mode."},{name:"column-reverse",description:"Same as 'column', except the main-start and main-end directions are swapped."},{name:"nowrap",description:"The flex container is single-line."},{name:"row",description:"The flex container’s main axis has the same orientation as the inline axis of the current writing mode."},{name:"wrap",description:"The flexbox is multi-line."},{name:"wrap-reverse",description:"Same as 'wrap', except the cross-start and cross-end directions are swapped."}],relevance:50,description:"Specifies how flexbox items are placed in the flexbox.",restrictions:["enum"]},{name:"-ms-flex-item-align",browsers:["IE10"],values:[{name:"auto",description:"Computes to the value of 'align-items' on the element’s parent, or 'stretch' if the element has no parent. On absolutely positioned elements, it computes to itself."},{name:"baseline",description:"If the flex item’s inline axis is the same as the cross axis, this value is identical to 'flex-start'. Otherwise, it participates in baseline alignment."},{name:"center",description:"The flex item’s margin box is centered in the cross axis within the line."},{name:"end",description:"The cross-end margin edge of the flex item is placed flush with the cross-end edge of the line."},{name:"start",description:"The cross-start margin edge of the flex item is placed flush with the cross-start edge of the line."},{name:"stretch",description:"If the cross size property of the flex item computes to auto, and neither of the cross-axis margins are auto, the flex item is stretched."}],relevance:50,description:"Allows the default alignment along the cross axis to be overridden for individual flex items.",restrictions:["enum"]},{name:"-ms-flex-line-pack",browsers:["IE10"],values:[{name:"center",description:"Lines are packed toward the center of the flex container."},{name:"distribute",description:"Lines are evenly distributed in the flex container, with half-size spaces on either end."},{name:"end",description:"Lines are packed toward the end of the flex container."},{name:"justify",description:"Lines are evenly distributed in the flex container."},{name:"start",description:"Lines are packed toward the start of the flex container."},{name:"stretch",description:"Lines stretch to take up the remaining space."}],relevance:50,description:"Aligns a flex container’s lines within the flex container when there is extra space in the cross-axis, similar to how 'justify-content' aligns individual items within the main-axis.",restrictions:["enum"]},{name:"-ms-flex-order",browsers:["IE10"],relevance:50,description:"Controls the order in which children of a flex container appear within the flex container, by assigning them to ordinal groups.",restrictions:["integer"]},{name:"-ms-flex-pack",browsers:["IE10"],values:[{name:"center",description:"Flex items are packed toward the center of the line."},{name:"distribute",description:"Flex items are evenly distributed in the line, with half-size spaces on either end."},{name:"end",description:"Flex items are packed toward the end of the line."},{name:"justify",description:"Flex items are evenly distributed in the line."},{name:"start",description:"Flex items are packed toward the start of the line."}],relevance:50,description:"Aligns flex items along the main axis of the current line of the flex container.",restrictions:["enum"]},{name:"-ms-flex-wrap",browsers:["IE10"],values:[{name:"nowrap",description:"The flex container is single-line."},{name:"wrap",description:"The flexbox is multi-line."},{name:"wrap-reverse",description:"Same as 'wrap', except the cross-start and cross-end directions are swapped."}],relevance:50,description:"Controls whether the flex container is single-line or multi-line, and the direction of the cross-axis, which determines the direction new lines are stacked in.",restrictions:["enum"]},{name:"-ms-flow-from",browsers:["E","IE10"],values:[{name:"none",description:"The block container is not a CSS Region."}],status:"nonstandard",syntax:"[ none | <custom-ident> ]#",relevance:0,description:"Makes a block container a region and associates it with a named flow.",restrictions:["identifier"]},{name:"-ms-flow-into",browsers:["E","IE10"],values:[{name:"none",description:"The element is not moved to a named flow and normal CSS processing takes place."}],status:"nonstandard",syntax:"[ none | <custom-ident> ]#",relevance:0,description:"Places an element or its contents into a named flow.",restrictions:["identifier"]},{name:"-ms-grid-column",browsers:["E12","IE10"],values:[{name:"auto"},{name:"end"},{name:"start"}],relevance:50,description:"Used to place grid items and explicitly defined grid cells in the Grid.",restrictions:["integer","string","enum"]},{name:"-ms-grid-column-align",browsers:["E12","IE10"],values:[{name:"center",description:"Places the center of the Grid Item's margin box at the center of the Grid Item's column."},{name:"end",description:"Aligns the end edge of the Grid Item's margin box to the end edge of the Grid Item's column."},{name:"start",description:"Aligns the starting edge of the Grid Item's margin box to the starting edge of the Grid Item's column."},{name:"stretch",description:"Ensures that the Grid Item's margin box is equal to the size of the Grid Item's column."}],relevance:50,description:"Aligns the columns in a grid.",restrictions:["enum"]},{name:"-ms-grid-columns",browsers:["E","IE10"],status:"nonstandard",syntax:"none | <track-list> | <auto-track-list>",relevance:0,description:"Lays out the columns of the grid."},{name:"-ms-grid-column-span",browsers:["E12","IE10"],relevance:50,description:"Specifies the number of columns to span.",restrictions:["integer"]},{name:"-ms-grid-layer",browsers:["E","IE10"],relevance:50,description:"Grid-layer is similar in concept to z-index, but avoids overloading the meaning of the z-index property, which is applicable only to positioned elements.",restrictions:["integer"]},{name:"-ms-grid-row",browsers:["E12","IE10"],values:[{name:"auto"},{name:"end"},{name:"start"}],relevance:50,description:"grid-row is used to place grid items and explicitly defined grid cells in the Grid.",restrictions:["integer","string","enum"]},{name:"-ms-grid-row-align",browsers:["E12","IE10"],values:[{name:"center",description:"Places the center of the Grid Item's margin box at the center of the Grid Item's row."},{name:"end",description:"Aligns the end edge of the Grid Item's margin box to the end edge of the Grid Item's row."},{name:"start",description:"Aligns the starting edge of the Grid Item's margin box to the starting edge of the Grid Item's row."},{name:"stretch",description:"Ensures that the Grid Item's margin box is equal to the size of the Grid Item's row."}],relevance:50,description:"Aligns the rows in a grid.",restrictions:["enum"]},{name:"-ms-grid-rows",browsers:["E","IE10"],status:"nonstandard",syntax:"none | <track-list> | <auto-track-list>",relevance:0,description:"Lays out the columns of the grid."},{name:"-ms-grid-row-span",browsers:["E12","IE10"],relevance:50,description:"Specifies the number of rows to span.",restrictions:["integer"]},{name:"-ms-high-contrast-adjust",browsers:["E","IE10"],values:[{name:"auto",description:"Properties will be adjusted as applicable."},{name:"none",description:"No adjustments will be applied."}],status:"nonstandard",syntax:"auto | none",relevance:0,description:"Specifies if properties should be adjusted in high contrast mode.",restrictions:["enum"]},{name:"-ms-hyphenate-limit-chars",browsers:["E","IE10"],values:[{name:"auto",description:"The user agent chooses a value that adapts to the current layout."}],status:"nonstandard",syntax:"auto | <integer>{1,3}",relevance:0,description:"Specifies the minimum number of characters in a hyphenated word.",restrictions:["integer"]},{name:"-ms-hyphenate-limit-lines",browsers:["E","IE10"],values:[{name:"no-limit",description:"There is no limit."}],status:"nonstandard",syntax:"no-limit | <integer>",relevance:0,description:"Indicates the maximum number of successive hyphenated lines in an element.",restrictions:["integer"]},{name:"-ms-hyphenate-limit-zone",browsers:["E","IE10"],status:"nonstandard",syntax:"<percentage> | <length>",relevance:0,description:"Specifies the maximum amount of unfilled space (before justification) that may be left in the line box before hyphenation is triggered to pull part of a word from the next line back up into the current line.",restrictions:["percentage","length"]},{name:"-ms-hyphens",browsers:["E","IE10"],values:[{name:"auto",description:"Conditional hyphenation characters inside a word, if present, take priority over automatic resources when determining hyphenation points within the word."},{name:"manual",description:"Words are only broken at line breaks where there are characters inside the word that suggest line break opportunities"},{name:"none",description:"Words are not broken at line breaks, even if characters inside the word suggest line break points."}],relevance:50,description:"Controls whether hyphenation is allowed to create more break opportunities within a line of text.",restrictions:["enum"]},{name:"-ms-ime-mode",browsers:["IE10"],values:[{name:"active",description:"The input method editor is initially active; text entry is performed using it unless the user specifically dismisses it."},{name:"auto",description:"No change is made to the current input method editor state. This is the default."},{name:"disabled",description:"The input method editor is disabled and may not be activated by the user."},{name:"inactive",description:"The input method editor is initially inactive, but the user may activate it if they wish."},{name:"normal",description:"The IME state should be normal; this value can be used in a user style sheet to override the page setting."}],relevance:50,description:"Controls the state of the input method editor for text fields.",restrictions:["enum"]},{name:"-ms-interpolation-mode",browsers:["IE7"],values:[{name:"bicubic"},{name:"nearest-neighbor"}],relevance:50,description:"Gets or sets the interpolation (resampling) method used to stretch images.",restrictions:["enum"]},{name:"-ms-layout-grid",browsers:["E","IE10"],values:[{name:"char",description:"Any of the range of character values available to the -ms-layout-grid-char property."},{name:"line",description:"Any of the range of line values available to the -ms-layout-grid-line property."},{name:"mode",description:"Any of the range of mode values available to the -ms-layout-grid-mode property."},{name:"type",description:"Any of the range of type values available to the -ms-layout-grid-type property."}],relevance:50,description:"Sets or retrieves the composite document grid properties that specify the layout of text characters."},{name:"-ms-layout-grid-char",browsers:["E","IE10"],values:[{name:"auto",description:"Largest character in the font of the element is used to set the character grid."},{name:"none",description:"Default. No character grid is set."}],relevance:50,description:"Sets or retrieves the size of the character grid used for rendering the text content of an element.",restrictions:["enum","length","percentage"]},{name:"-ms-layout-grid-line",browsers:["E","IE10"],values:[{name:"auto",description:"Largest character in the font of the element is used to set the character grid."},{name:"none",description:"Default. No grid line is set."}],relevance:50,description:"Sets or retrieves the gridline value used for rendering the text content of an element.",restrictions:["length"]},{name:"-ms-layout-grid-mode",browsers:["E","IE10"],values:[{name:"both",description:"Default. Both the char and line grid modes are enabled. This setting is necessary to fully enable the layout grid on an element."},{name:"char",description:"Only a character grid is used. This is recommended for use with block-level elements, such as a blockquote, where the line grid is intended to be disabled."},{name:"line",description:"Only a line grid is used. This is recommended for use with inline elements, such as a span, to disable the horizontal grid on runs of text that act as a single entity in the grid layout."},{name:"none",description:"No grid is used."}],relevance:50,description:"Gets or sets whether the text layout grid uses two dimensions.",restrictions:["enum"]},{name:"-ms-layout-grid-type",browsers:["E","IE10"],values:[{name:"fixed",description:"Grid used for monospaced layout. All noncursive characters are treated as equal; every character is centered within a single grid space by default."},{name:"loose",description:"Default. Grid used for Japanese and Korean characters."},{name:"strict",description:"Grid used for Chinese, as well as Japanese (Genko) and Korean characters. Only the ideographs, kanas, and wide characters are snapped to the grid."}],relevance:50,description:"Sets or retrieves the type of grid used for rendering the text content of an element.",restrictions:["enum"]},{name:"-ms-line-break",browsers:["E","IE10"],values:[{name:"auto",description:"The UA determines the set of line-breaking restrictions to use for CJK scripts, and it may vary the restrictions based on the length of the line; e.g., use a less restrictive set of line-break rules for short lines."},{name:"keep-all",description:"Sequences of CJK characters can no longer break on implied break points. This option should only be used where the presence of word separator characters still creates line-breaking opportunities, as in Korean."},{name:"newspaper",description:"Breaks CJK scripts using the least restrictive set of line-breaking rules. Typically used for short lines, such as in newspapers."},{name:"normal",description:"Breaks CJK scripts using a normal set of line-breaking rules."},{name:"strict",description:"Breaks CJK scripts using a more restrictive set of line-breaking rules than 'normal'."}],relevance:50,description:"Specifies what set of line breaking restrictions are in effect within the element.",restrictions:["enum"]},{name:"-ms-overflow-style",browsers:["E","IE10"],values:[{name:"auto",description:"No preference, UA should use the first scrolling method in the list that it supports."},{name:"-ms-autohiding-scrollbar",description:"Indicates the element displays auto-hiding scrollbars during mouse interactions and panning indicators during touch and keyboard interactions."},{name:"none",description:"Indicates the element does not display scrollbars or panning indicators, even when its content overflows."},{name:"scrollbar",description:'Scrollbars are typically narrow strips inserted on one or two edges of an element and which often have arrows to click on and a "thumb" to drag up and down (or left and right) to move the contents of the element.'}],status:"nonstandard",syntax:"auto | none | scrollbar | -ms-autohiding-scrollbar",relevance:0,description:"Specify whether content is clipped when it overflows the element's content area.",restrictions:["enum"]},{name:"-ms-perspective",browsers:["IE10"],values:[{name:"none",description:"No perspective transform is applied."}],relevance:50,description:"Applies the same transform as the perspective(<number>) transform function, except that it applies only to the positioned or transformed children of the element, not to the transform on the element itself.",restrictions:["length"]},{name:"-ms-perspective-origin",browsers:["IE10"],relevance:50,description:"Establishes the origin for the perspective property. It effectively sets the X and Y position at which the viewer appears to be looking at the children of the element.",restrictions:["position","percentage","length"]},{name:"-ms-perspective-origin-x",browsers:["IE10"],relevance:50,description:"Establishes the origin for the perspective property. It effectively sets the X  position at which the viewer appears to be looking at the children of the element.",restrictions:["position","percentage","length"]},{name:"-ms-perspective-origin-y",browsers:["IE10"],relevance:50,description:"Establishes the origin for the perspective property. It effectively sets the Y position at which the viewer appears to be looking at the children of the element.",restrictions:["position","percentage","length"]},{name:"-ms-progress-appearance",browsers:["IE10"],values:[{name:"bar"},{name:"ring"}],relevance:50,description:"Gets or sets a value that specifies whether a progress control displays as a bar or a ring.",restrictions:["enum"]},{name:"-ms-scrollbar-3dlight-color",browsers:["IE8"],status:"nonstandard",syntax:"<color>",relevance:0,description:"Determines the color of the top and left edges of the scroll box and scroll arrows of a scroll bar.",restrictions:["color"]},{name:"-ms-scrollbar-arrow-color",browsers:["IE8"],status:"nonstandard",syntax:"<color>",relevance:0,description:"Determines the color of the arrow elements of a scroll arrow.",restrictions:["color"]},{name:"-ms-scrollbar-base-color",browsers:["IE8"],status:"nonstandard",syntax:"<color>",relevance:0,description:"Determines the color of the main elements of a scroll bar, which include the scroll box, track, and scroll arrows.",restrictions:["color"]},{name:"-ms-scrollbar-darkshadow-color",browsers:["IE8"],status:"nonstandard",syntax:"<color>",relevance:0,description:"Determines the color of the gutter of a scroll bar.",restrictions:["color"]},{name:"-ms-scrollbar-face-color",browsers:["IE8"],status:"nonstandard",syntax:"<color>",relevance:0,description:"Determines the color of the scroll box and scroll arrows of a scroll bar.",restrictions:["color"]},{name:"-ms-scrollbar-highlight-color",browsers:["IE8"],status:"nonstandard",syntax:"<color>",relevance:0,description:"Determines the color of the top and left edges of the scroll box and scroll arrows of a scroll bar.",restrictions:["color"]},{name:"-ms-scrollbar-shadow-color",browsers:["IE8"],status:"nonstandard",syntax:"<color>",relevance:0,description:"Determines the color of the bottom and right edges of the scroll box and scroll arrows of a scroll bar.",restrictions:["color"]},{name:"-ms-scrollbar-track-color",browsers:["IE5"],status:"nonstandard",syntax:"<color>",relevance:0,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/-ms-scrollbar-track-color"}],description:"Determines the color of the track element of a scroll bar.",restrictions:["color"]},{name:"-ms-scroll-chaining",browsers:["E","IE10"],values:[{name:"chained"},{name:"none"}],status:"nonstandard",syntax:"chained | none",relevance:0,description:"Gets or sets a value that indicates the scrolling behavior that occurs when a user hits the content boundary during a manipulation.",restrictions:["enum","length"]},{name:"-ms-scroll-limit",browsers:["E","IE10"],values:[{name:"auto"}],status:"nonstandard",syntax:"<'-ms-scroll-limit-x-min'> <'-ms-scroll-limit-y-min'> <'-ms-scroll-limit-x-max'> <'-ms-scroll-limit-y-max'>",relevance:0,description:"Gets or sets a shorthand value that sets values for the -ms-scroll-limit-x-min, -ms-scroll-limit-y-min, -ms-scroll-limit-x-max, and -ms-scroll-limit-y-max properties.",restrictions:["length"]},{name:"-ms-scroll-limit-x-max",browsers:["E","IE10"],values:[{name:"auto"}],status:"nonstandard",syntax:"auto | <length>",relevance:0,description:"Gets or sets a value that specifies the maximum value for the scrollLeft property.",restrictions:["length"]},{name:"-ms-scroll-limit-x-min",browsers:["E","IE10"],status:"nonstandard",syntax:"<length>",relevance:0,description:"Gets or sets a value that specifies the minimum value for the scrollLeft property.",restrictions:["length"]},{name:"-ms-scroll-limit-y-max",browsers:["E","IE10"],values:[{name:"auto"}],status:"nonstandard",syntax:"auto | <length>",relevance:0,description:"Gets or sets a value that specifies the maximum value for the scrollTop property.",restrictions:["length"]},{name:"-ms-scroll-limit-y-min",browsers:["E","IE10"],status:"nonstandard",syntax:"<length>",relevance:0,description:"Gets or sets a value that specifies the minimum value for the scrollTop property.",restrictions:["length"]},{name:"-ms-scroll-rails",browsers:["E","IE10"],values:[{name:"none"},{name:"railed"}],status:"nonstandard",syntax:"none | railed",relevance:0,description:"Gets or sets a value that indicates whether or not small motions perpendicular to the primary axis of motion will result in either changes to both the scrollTop and scrollLeft properties or a change to the primary axis (for instance, either the scrollTop or scrollLeft properties will change, but not both).",restrictions:["enum","length"]},{name:"-ms-scroll-snap-points-x",browsers:["E","IE10"],values:[{name:"snapInterval(100%, 100%)"},{name:"snapList()"}],status:"nonstandard",syntax:"snapInterval( <length-percentage>, <length-percentage> ) | snapList( <length-percentage># )",relevance:0,description:"Gets or sets a value that defines where snap-points will be located along the x-axis.",restrictions:["enum"]},{name:"-ms-scroll-snap-points-y",browsers:["E","IE10"],values:[{name:"snapInterval(100%, 100%)"},{name:"snapList()"}],status:"nonstandard",syntax:"snapInterval( <length-percentage>, <length-percentage> ) | snapList( <length-percentage># )",relevance:0,description:"Gets or sets a value that defines where snap-points will be located along the y-axis.",restrictions:["enum"]},{name:"-ms-scroll-snap-type",browsers:["E","IE10"],values:[{name:"none",description:"The visual viewport of this scroll container must ignore snap points, if any, when scrolled."},{name:"mandatory",description:"The visual viewport of this scroll container is guaranteed to rest on a snap point when there are no active scrolling operations."},{name:"proximity",description:"The visual viewport of this scroll container may come to rest on a snap point at the termination of a scroll at the discretion of the UA given the parameters of the scroll."}],status:"nonstandard",syntax:"none | proximity | mandatory",relevance:0,description:"Gets or sets a value that defines what type of snap-point should be used for the current element. There are two type of snap-points, with the primary difference being whether or not the user is guaranteed to always stop on a snap-point.",restrictions:["enum"]},{name:"-ms-scroll-snap-x",browsers:["E","IE10"],values:[{name:"mandatory"},{name:"none"},{name:"proximity"},{name:"snapInterval(100%, 100%)"},{name:"snapList()"}],status:"nonstandard",syntax:"<'-ms-scroll-snap-type'> <'-ms-scroll-snap-points-x'>",relevance:0,description:"Gets or sets a shorthand value that sets values for the -ms-scroll-snap-type and -ms-scroll-snap-points-x properties.",restrictions:["enum"]},{name:"-ms-scroll-snap-y",browsers:["E","IE10"],values:[{name:"mandatory"},{name:"none"},{name:"proximity"},{name:"snapInterval(100%, 100%)"},{name:"snapList()"}],status:"nonstandard",syntax:"<'-ms-scroll-snap-type'> <'-ms-scroll-snap-points-y'>",relevance:0,description:"Gets or sets a shorthand value that sets values for the -ms-scroll-snap-type and -ms-scroll-snap-points-y properties.",restrictions:["enum"]},{name:"-ms-scroll-translation",browsers:["E","IE10"],values:[{name:"none"},{name:"vertical-to-horizontal"}],status:"nonstandard",syntax:"none | vertical-to-horizontal",relevance:0,description:"Gets or sets a value that specifies whether vertical-to-horizontal scroll wheel translation occurs on the specified element.",restrictions:["enum"]},{name:"-ms-text-align-last",browsers:["E","IE8"],values:[{name:"auto"},{name:"center",description:"The inline contents are centered within the line box."},{name:"justify",description:"The text is justified according to the method specified by the 'text-justify' property."},{name:"left",description:"The inline contents are aligned to the left edge of the line box. In vertical text, 'left' aligns to the edge of the line box that would be the start edge for left-to-right text."},{name:"right",description:"The inline contents are aligned to the right edge of the line box. In vertical text, 'right' aligns to the edge of the line box that would be the end edge for left-to-right text."}],relevance:50,description:"Describes how the last line of a block or a line right before a forced line break is aligned when 'text-align' is set to 'justify'.",restrictions:["enum"]},{name:"-ms-text-autospace",browsers:["E","IE8"],values:[{name:"ideograph-alpha",description:"Creates 1/4em extra spacing between runs of ideographic letters and non-ideographic letters, such as Latin-based, Cyrillic, Greek, Arabic or Hebrew."},{name:"ideograph-numeric",description:"Creates 1/4em extra spacing between runs of ideographic letters and numeric glyphs."},{name:"ideograph-parenthesis",description:"Creates extra spacing between normal (non wide) parenthesis and ideographs."},{name:"ideograph-space",description:"Extends the width of the space character while surrounded by ideographs."},{name:"none",description:"No extra space is created."},{name:"punctuation",description:"Creates extra non-breaking spacing around punctuation as required by language-specific typographic conventions."}],status:"nonstandard",syntax:"none | ideograph-alpha | ideograph-numeric | ideograph-parenthesis | ideograph-space",relevance:0,description:"Determines whether or not a full-width punctuation mark character should be trimmed if it appears at the beginning of a line, so that its 'ink' lines up with the first glyph in the line above and below.",restrictions:["enum"]},{name:"-ms-text-combine-horizontal",browsers:["E","IE11"],values:[{name:"all",description:"Attempt to typeset horizontally all consecutive characters within the box such that they take up the space of a single character within the vertical line box."},{name:"digits",description:"Attempt to typeset horizontally each maximal sequence of consecutive ASCII digits (U+0030–U+0039) that has as many or fewer characters than the specified integer such that it takes up the space of a single character within the vertical line box."},{name:"none",description:"No special processing."}],relevance:50,description:"This property specifies the combination of multiple characters into the space of a single character.",restrictions:["enum","integer"]},{name:"-ms-text-justify",browsers:["E","IE8"],values:[{name:"auto",description:"The UA determines the justification algorithm to follow, based on a balance between performance and adequate presentation quality."},{name:"distribute",description:"Justification primarily changes spacing both at word separators and at grapheme cluster boundaries in all scripts except those in the connected and cursive groups. This value is sometimes used in e.g. Japanese, often with the 'text-align-last' property."},{name:"inter-cluster",description:"Justification primarily changes spacing at word separators and at grapheme cluster boundaries in clustered scripts. This value is typically used for Southeast Asian scripts such as Thai."},{name:"inter-ideograph",description:"Justification primarily changes spacing at word separators and at inter-graphemic boundaries in scripts that use no word spaces. This value is typically used for CJK languages."},{name:"inter-word",description:"Justification primarily changes spacing at word separators. This value is typically used for languages that separate words using spaces, like English or (sometimes) Korean."},{name:"kashida",description:"Justification primarily stretches Arabic and related scripts through the use of kashida or other calligraphic elongation."}],relevance:50,description:"Selects the justification algorithm used when 'text-align' is set to 'justify'. The property applies to block containers, but the UA may (but is not required to) also support it on inline elements.",restrictions:["enum"]},{name:"-ms-text-kashida-space",browsers:["E","IE10"],relevance:50,description:"Sets or retrieves the ratio of kashida expansion to white space expansion when justifying lines of text in the object.",restrictions:["percentage"]},{name:"-ms-text-overflow",browsers:["IE10"],values:[{name:"clip",description:"Clip inline content that overflows. Characters may be only partially rendered."},{name:"ellipsis",description:"Render an ellipsis character (U+2026) to represent clipped inline content."}],relevance:50,description:"Text can overflow for example when it is prevented from wrapping",restrictions:["enum"]},{name:"-ms-text-size-adjust",browsers:["E","IE10"],values:[{name:"auto",description:"Renderers must use the default size adjustment when displaying on a small device."},{name:"none",description:"Renderers must not do size adjustment when displaying on a small device."}],relevance:50,description:"Specifies a size adjustment for displaying text content in mobile browsers.",restrictions:["enum","percentage"]},{name:"-ms-text-underline-position",browsers:["E","IE10"],values:[{name:"alphabetic",description:"The underline is aligned with the alphabetic baseline. In this case the underline is likely to cross some descenders."},{name:"auto",description:"The user agent may use any algorithm to determine the underline's position. In horizontal line layout, the underline should be aligned as for alphabetic. In vertical line layout, if the language is set to Japanese or Korean, the underline should be aligned as for over."},{name:"over",description:"The underline is aligned with the 'top' (right in vertical writing) edge of the element's em-box. In this mode, an overline also switches sides."},{name:"under",description:"The underline is aligned with the 'bottom' (left in vertical writing) edge of the element's em-box. In this case the underline usually does not cross the descenders. This is sometimes called 'accounting' underline."}],relevance:50,description:"Sets the position of an underline specified on the same element: it does not affect underlines specified by ancestor elements.This property is typically used in vertical writing contexts such as in Japanese documents where it often desired to have the underline appear 'over' (to the right of) the affected run of text",restrictions:["enum"]},{name:"-ms-touch-action",browsers:["IE10"],values:[{name:"auto",description:"The element is a passive element, with several exceptions."},{name:"double-tap-zoom",description:"The element will zoom on double-tap."},{name:"manipulation",description:"The element is a manipulation-causing element."},{name:"none",description:"The element is a manipulation-blocking element."},{name:"pan-x",description:"The element permits touch-driven panning on the horizontal axis. The touch pan is performed on the nearest ancestor with horizontally scrollable content."},{name:"pan-y",description:"The element permits touch-driven panning on the vertical axis. The touch pan is performed on the nearest ancestor with vertically scrollable content."},{name:"pinch-zoom",description:"The element permits pinch-zooming. The pinch-zoom is performed on the nearest ancestor with zoomable content."}],relevance:50,description:"Gets or sets a value that indicates whether and how a given region can be manipulated by the user.",restrictions:["enum"]},{name:"-ms-touch-select",browsers:["E","IE10"],values:[{name:"grippers",description:"Grippers are always on."},{name:"none",description:"Grippers are always off."}],status:"nonstandard",syntax:"grippers | none",relevance:0,description:"Gets or sets a value that toggles the 'gripper' visual elements that enable touch text selection.",restrictions:["enum"]},{name:"-ms-transform",browsers:["IE9-9"],values:[{name:"matrix()",description:"Specifies a 2D transformation in the form of a transformation matrix of six values. matrix(a,b,c,d,e,f) is equivalent to applying the transformation matrix [a b c d e f]"},{name:"matrix3d()",description:"Specifies a 3D transformation as a 4x4 homogeneous matrix of 16 values in column-major order."},{name:"none"},{name:"rotate()",description:"Specifies a 2D rotation by the angle specified in the parameter about the origin of the element, as defined by the transform-origin property."},{name:"rotate3d()",description:"Specifies a clockwise 3D rotation by the angle specified in last parameter about the [x,y,z] direction vector described by the first 3 parameters."},{name:"rotateX('angle')",description:"Specifies a clockwise rotation by the given angle about the X axis."},{name:"rotateY('angle')",description:"Specifies a clockwise rotation by the given angle about the Y axis."},{name:"rotateZ('angle')",description:"Specifies a clockwise rotation by the given angle about the Z axis."},{name:"scale()",description:"Specifies a 2D scale operation by the [sx,sy] scaling vector described by the 2 parameters. If the second parameter is not provided, it is takes a value equal to the first."},{name:"scale3d()",description:"Specifies a 3D scale operation by the [sx,sy,sz] scaling vector described by the 3 parameters."},{name:"scaleX()",description:"Specifies a scale operation using the [sx,1] scaling vector, where sx is given as the parameter."},{name:"scaleY()",description:"Specifies a scale operation using the [sy,1] scaling vector, where sy is given as the parameter."},{name:"scaleZ()",description:"Specifies a scale operation using the [1,1,sz] scaling vector, where sz is given as the parameter."},{name:"skew()",description:"Specifies a skew transformation along the X and Y axes. The first angle parameter specifies the skew on the X axis. The second angle parameter specifies the skew on the Y axis. If the second parameter is not given then a value of 0 is used for the Y angle (ie: no skew on the Y axis)."},{name:"skewX()",description:"Specifies a skew transformation along the X axis by the given angle."},{name:"skewY()",description:"Specifies a skew transformation along the Y axis by the given angle."},{name:"translate()",description:"Specifies a 2D translation by the vector [tx, ty], where tx is the first translation-value parameter and ty is the optional second translation-value parameter."},{name:"translate3d()",description:"Specifies a 3D translation by the vector [tx,ty,tz], with tx, ty and tz being the first, second and third translation-value parameters respectively."},{name:"translateX()",description:"Specifies a translation by the given amount in the X direction."},{name:"translateY()",description:"Specifies a translation by the given amount in the Y direction."},{name:"translateZ()",description:"Specifies a translation by the given amount in the Z direction. Note that percentage values are not allowed in the translateZ translation-value, and if present are evaluated as 0."}],relevance:50,description:"A two-dimensional transformation is applied to an element through the 'transform' property. This property contains a list of transform functions similar to those allowed by SVG.",restrictions:["enum"]},{name:"-ms-transform-origin",browsers:["IE9-9"],relevance:50,description:"Establishes the origin of transformation for an element.",restrictions:["position","length","percentage"]},{name:"-ms-transform-origin-x",browsers:["IE10"],relevance:50,description:"The x coordinate of the origin for transforms applied to an element with respect to its border box.",restrictions:["length","percentage"]},{name:"-ms-transform-origin-y",browsers:["IE10"],relevance:50,description:"The y coordinate of the origin for transforms applied to an element with respect to its border box.",restrictions:["length","percentage"]},{name:"-ms-transform-origin-z",browsers:["IE10"],relevance:50,description:"The z coordinate of the origin for transforms applied to an element with respect to its border box.",restrictions:["length","percentage"]},{name:"-ms-user-select",browsers:["E","IE10"],values:[{name:"element"},{name:"none"},{name:"text"}],status:"nonstandard",syntax:"none | element | text",relevance:0,description:"Controls the appearance of selection.",restrictions:["enum"]},{name:"-ms-word-break",browsers:["IE8"],values:[{name:"break-all",description:"Lines may break between any two grapheme clusters for non-CJK scripts."},{name:"keep-all",description:"Block characters can no longer create implied break points."},{name:"normal",description:"Breaks non-CJK scripts according to their own rules."}],relevance:50,description:"Specifies line break opportunities for non-CJK scripts.",restrictions:["enum"]},{name:"-ms-word-wrap",browsers:["IE8"],values:[{name:"break-word",description:"An unbreakable 'word' may be broken at an arbitrary point if there are no otherwise-acceptable break points in the line."},{name:"normal",description:"Lines may break only at allowed break points."}],relevance:50,description:"Specifies whether the UA may break within a word to prevent overflow when an otherwise-unbreakable string is too long to fit.",restrictions:["enum"]},{name:"-ms-wrap-flow",browsers:["E","IE10"],values:[{name:"auto",description:"For floats an exclusion is created, for all other elements an exclusion is not created."},{name:"both",description:"Inline flow content can flow on all sides of the exclusion."},{name:"clear",description:"Inline flow content can only wrap on top and bottom of the exclusion and must leave the areas to the start and end edges of the exclusion box empty."},{name:"end",description:"Inline flow content can wrap on the end side of the exclusion area but must leave the area to the start edge of the exclusion area empty."},{name:"maximum",description:"Inline flow content can wrap on the side of the exclusion with the largest available space for the given line, and must leave the other side of the exclusion empty."},{name:"minimum",description:"Inline flow content can flow around the edge of the exclusion with the smallest available space within the flow content’s containing block, and must leave the other edge of the exclusion empty."},{name:"start",description:"Inline flow content can wrap on the start edge of the exclusion area but must leave the area to end edge of the exclusion area empty."}],status:"nonstandard",syntax:"auto | both | start | end | maximum | clear",relevance:0,description:"An element becomes an exclusion when its 'wrap-flow' property has a computed value other than 'auto'.",restrictions:["enum"]},{name:"-ms-wrap-margin",browsers:["E","IE10"],status:"nonstandard",syntax:"<length>",relevance:0,description:"Gets or sets a value that is used to offset the inner wrap shape from other shapes.",restrictions:["length","percentage"]},{name:"-ms-wrap-through",browsers:["E","IE10"],values:[{name:"none",description:"The exclusion element does not inherit its parent node's wrapping context. Its descendants are only subject to exclusion shapes defined inside the element."},{name:"wrap",description:"The exclusion element inherits its parent node's wrapping context. Its descendant inline content wraps around exclusions defined outside the element."}],status:"nonstandard",syntax:"wrap | none",relevance:0,description:"Specifies if an element inherits its parent wrapping context. In other words if it is subject to the exclusions defined outside the element.",restrictions:["enum"]},{name:"-ms-writing-mode",browsers:["IE8"],values:[{name:"bt-lr"},{name:"bt-rl"},{name:"lr-bt"},{name:"lr-tb"},{name:"rl-bt"},{name:"rl-tb"},{name:"tb-lr"},{name:"tb-rl"}],relevance:50,description:"Shorthand property for both 'direction' and 'block-progression'.",restrictions:["enum"]},{name:"-ms-zoom",browsers:["IE8"],values:[{name:"normal"}],relevance:50,description:"Sets or retrieves the magnification scale of the object.",restrictions:["enum","integer","number","percentage"]},{name:"-ms-zoom-animation",browsers:["IE10"],values:[{name:"default"},{name:"none"}],relevance:50,description:"Gets or sets a value that indicates whether an animation is used when zooming.",restrictions:["enum"]},{name:"nav-down",browsers:["O9.5"],values:[{name:"auto",description:"The user agent automatically determines which element to navigate the focus to in response to directional navigational input."},{name:"current",description:"Indicates that the user agent should target the frame that the element is in."},{name:"root",description:"Indicates that the user agent should target the full window."}],relevance:50,description:"Provides an way to control directional focus navigation.",restrictions:["enum","identifier","string"]},{name:"nav-index",browsers:["O9.5"],values:[{name:"auto",description:"The element's sequential navigation order is assigned automatically by the user agent."}],relevance:50,description:"Provides an input-method-neutral way of specifying the sequential navigation order (also known as 'tabbing order').",restrictions:["number"]},{name:"nav-left",browsers:["O9.5"],values:[{name:"auto",description:"The user agent automatically determines which element to navigate the focus to in response to directional navigational input."},{name:"current",description:"Indicates that the user agent should target the frame that the element is in."},{name:"root",description:"Indicates that the user agent should target the full window."}],relevance:50,description:"Provides an way to control directional focus navigation.",restrictions:["enum","identifier","string"]},{name:"nav-right",browsers:["O9.5"],values:[{name:"auto",description:"The user agent automatically determines which element to navigate the focus to in response to directional navigational input."},{name:"current",description:"Indicates that the user agent should target the frame that the element is in."},{name:"root",description:"Indicates that the user agent should target the full window."}],relevance:50,description:"Provides an way to control directional focus navigation.",restrictions:["enum","identifier","string"]},{name:"nav-up",browsers:["O9.5"],values:[{name:"auto",description:"The user agent automatically determines which element to navigate the focus to in response to directional navigational input."},{name:"current",description:"Indicates that the user agent should target the frame that the element is in."},{name:"root",description:"Indicates that the user agent should target the full window."}],relevance:50,description:"Provides an way to control directional focus navigation.",restrictions:["enum","identifier","string"]},{name:"negative",browsers:["FF33"],syntax:"<symbol> <symbol>?",relevance:50,description:"@counter-style descriptor. Defines how to alter the representation when the counter value is negative.",restrictions:["image","identifier","string"]},{name:"-o-animation",browsers:["O12"],values:[{name:"alternate",description:"The animation cycle iterations that are odd counts are played in the normal direction, and the animation cycle iterations that are even counts are played in a reverse direction."},{name:"alternate-reverse",description:"The animation cycle iterations that are odd counts are played in the reverse direction, and the animation cycle iterations that are even counts are played in a normal direction."},{name:"backwards",description:"The beginning property value (as defined in the first @keyframes at-rule) is applied before the animation is displayed, during the period defined by 'animation-delay'."},{name:"both",description:"Both forwards and backwards fill modes are applied."},{name:"forwards",description:"The final property value (as defined in the last @keyframes at-rule) is maintained after the animation completes."},{name:"infinite",description:"Causes the animation to repeat forever."},{name:"none",description:"No animation is performed"},{name:"normal",description:"Normal playback."},{name:"reverse",description:"All iterations of the animation are played in the reverse direction from the way they were specified."}],relevance:50,description:"Shorthand property combines six of the animation properties into a single property.",restrictions:["time","enum","timing-function","identifier","number"]},{name:"-o-animation-delay",browsers:["O12"],relevance:50,description:"Defines when the animation will start.",restrictions:["time"]},{name:"-o-animation-direction",browsers:["O12"],values:[{name:"alternate",description:"The animation cycle iterations that are odd counts are played in the normal direction, and the animation cycle iterations that are even counts are played in a reverse direction."},{name:"alternate-reverse",description:"The animation cycle iterations that are odd counts are played in the reverse direction, and the animation cycle iterations that are even counts are played in a normal direction."},{name:"normal",description:"Normal playback."},{name:"reverse",description:"All iterations of the animation are played in the reverse direction from the way they were specified."}],relevance:50,description:"Defines whether or not the animation should play in reverse on alternate cycles.",restrictions:["enum"]},{name:"-o-animation-duration",browsers:["O12"],relevance:50,description:"Defines the length of time that an animation takes to complete one cycle.",restrictions:["time"]},{name:"-o-animation-fill-mode",browsers:["O12"],values:[{name:"backwards",description:"The beginning property value (as defined in the first @keyframes at-rule) is applied before the animation is displayed, during the period defined by 'animation-delay'."},{name:"both",description:"Both forwards and backwards fill modes are applied."},{name:"forwards",description:"The final property value (as defined in the last @keyframes at-rule) is maintained after the animation completes."},{name:"none",description:"There is no change to the property value between the time the animation is applied and the time the animation begins playing or after the animation completes."}],relevance:50,description:"Defines what values are applied by the animation outside the time it is executing.",restrictions:["enum"]},{name:"-o-animation-iteration-count",browsers:["O12"],values:[{name:"infinite",description:"Causes the animation to repeat forever."}],relevance:50,description:"Defines the number of times an animation cycle is played. The default value is one, meaning the animation will play from beginning to end once.",restrictions:["number","enum"]},{name:"-o-animation-name",browsers:["O12"],values:[{name:"none",description:"No animation is performed"}],relevance:50,description:"Defines a list of animations that apply. Each name is used to select the keyframe at-rule that provides the property values for the animation.",restrictions:["identifier","enum"]},{name:"-o-animation-play-state",browsers:["O12"],values:[{name:"paused",description:"A running animation will be paused."},{name:"running",description:"Resume playback of a paused animation."}],relevance:50,description:"Defines whether the animation is running or paused.",restrictions:["enum"]},{name:"-o-animation-timing-function",browsers:["O12"],relevance:50,description:"Describes how the animation will progress over one cycle of its duration. See the 'transition-timing-function'.",restrictions:["timing-function"]},{name:"object-fit",browsers:["E79","FF36","S10","C32","O19"],values:[{name:"contain",description:"The replaced content is sized to maintain its aspect ratio while fitting within the element’s content box: its concrete object size is resolved as a contain constraint against the element's used width and height."},{name:"cover",description:"The replaced content is sized to maintain its aspect ratio while filling the element's entire content box: its concrete object size is resolved as a cover constraint against the element’s used width and height."},{name:"fill",description:"The replaced content is sized to fill the element’s content box: the object's concrete object size is the element's used width and height."},{name:"none",description:"The replaced content is not resized to fit inside the element's content box"},{name:"scale-down",description:"Size the content as if ‘none’ or ‘contain’ were specified, whichever would result in a smaller concrete object size."}],syntax:"fill | contain | cover | none | scale-down",relevance:69,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/object-fit"}],description:"Specifies how the contents of a replaced element should be scaled relative to the box established by its used height and width.",restrictions:["enum"]},{name:"object-position",browsers:["E79","FF36","S10","C32","O19"],syntax:"<position>",relevance:54,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/object-position"}],description:"Determines the alignment of the replaced element inside its box.",restrictions:["position","length","percentage"]},{name:"-o-border-image",browsers:["O11.6"],values:[{name:"auto",description:"If 'auto' is specified then the border image width is the intrinsic width or height (whichever is applicable) of the corresponding image slice. If the image does not have the required intrinsic dimension then the corresponding border-width is used instead."},{name:"fill",description:"Causes the middle part of the border-image to be preserved."},{name:"none"},{name:"repeat",description:"The image is tiled (repeated) to fill the area."},{name:"round",description:"The image is tiled (repeated) to fill the area. If it does not fill the area with a whole number of tiles, the image is rescaled so that it does."},{name:"space",description:"The image is tiled (repeated) to fill the area. If it does not fill the area with a whole number of tiles, the extra space is distributed around the tiles."},{name:"stretch",description:"The image is stretched to fill the area."}],relevance:50,description:"Shorthand property for setting 'border-image-source', 'border-image-slice', 'border-image-width', 'border-image-outset' and 'border-image-repeat'. Omitted values are set to their initial values.",restrictions:["length","percentage","number","image","enum"]},{name:"-o-object-fit",browsers:["O10.6"],values:[{name:"contain",description:"The replaced content is sized to maintain its aspect ratio while fitting within the element’s content box: its concrete object size is resolved as a contain constraint against the element's used width and height."},{name:"cover",description:"The replaced content is sized to maintain its aspect ratio while filling the element's entire content box: its concrete object size is resolved as a cover constraint against the element’s used width and height."},{name:"fill",description:"The replaced content is sized to fill the element’s content box: the object's concrete object size is the element's used width and height."},{name:"none",description:"The replaced content is not resized to fit inside the element's content box"},{name:"scale-down",description:"Size the content as if ‘none’ or ‘contain’ were specified, whichever would result in a smaller concrete object size."}],relevance:50,description:"Specifies how the contents of a replaced element should be scaled relative to the box established by its used height and width.",restrictions:["enum"]},{name:"-o-object-position",browsers:["O10.6"],relevance:50,description:"Determines the alignment of the replaced element inside its box.",restrictions:["position","length","percentage"]},{name:"opacity",syntax:"<alpha-value>",relevance:94,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/opacity"}],description:"Opacity of an element's text, where 1 is opaque and 0 is entirely transparent.",restrictions:["number(0-1)"]},{name:"order",syntax:"<integer>",relevance:64,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/order"}],description:"Controls the order in which children of a flex container appear within the flex container, by assigning them to ordinal groups.",restrictions:["integer"]},{name:"orphans",browsers:["E12","S1.3","C25","IE8","O9.2"],syntax:"<integer>",relevance:51,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/orphans"}],description:"Specifies the minimum number of line boxes in a block container that must be left in a fragment before a fragmentation break.",restrictions:["integer"]},{name:"-o-table-baseline",browsers:["O9.6"],relevance:50,description:"Determines which row of a inline-table should be used as baseline of inline-table.",restrictions:["integer"]},{name:"-o-tab-size",browsers:["O10.6"],relevance:50,description:"This property determines the width of the tab character (U+0009), in space characters (U+0020), when rendered.",restrictions:["integer","length"]},{name:"-o-text-overflow",browsers:["O10"],values:[{name:"clip",description:"Clip inline content that overflows. Characters may be only partially rendered."},{name:"ellipsis",description:"Render an ellipsis character (U+2026) to represent clipped inline content."}],relevance:50,description:"Text can overflow for example when it is prevented from wrapping",restrictions:["enum"]},{name:"-o-transform",browsers:["O10.5"],values:[{name:"matrix()",description:"Specifies a 2D transformation in the form of a transformation matrix of six values. matrix(a,b,c,d,e,f) is equivalent to applying the transformation matrix [a b c d e f]"},{name:"matrix3d()",description:"Specifies a 3D transformation as a 4x4 homogeneous matrix of 16 values in column-major order."},{name:"none"},{name:"rotate()",description:"Specifies a 2D rotation by the angle specified in the parameter about the origin of the element, as defined by the transform-origin property."},{name:"rotate3d()",description:"Specifies a clockwise 3D rotation by the angle specified in last parameter about the [x,y,z] direction vector described by the first 3 parameters."},{name:"rotateX('angle')",description:"Specifies a clockwise rotation by the given angle about the X axis."},{name:"rotateY('angle')",description:"Specifies a clockwise rotation by the given angle about the Y axis."},{name:"rotateZ('angle')",description:"Specifies a clockwise rotation by the given angle about the Z axis."},{name:"scale()",description:"Specifies a 2D scale operation by the [sx,sy] scaling vector described by the 2 parameters. If the second parameter is not provided, it is takes a value equal to the first."},{name:"scale3d()",description:"Specifies a 3D scale operation by the [sx,sy,sz] scaling vector described by the 3 parameters."},{name:"scaleX()",description:"Specifies a scale operation using the [sx,1] scaling vector, where sx is given as the parameter."},{name:"scaleY()",description:"Specifies a scale operation using the [sy,1] scaling vector, where sy is given as the parameter."},{name:"scaleZ()",description:"Specifies a scale operation using the [1,1,sz] scaling vector, where sz is given as the parameter."},{name:"skew()",description:"Specifies a skew transformation along the X and Y axes. The first angle parameter specifies the skew on the X axis. The second angle parameter specifies the skew on the Y axis. If the second parameter is not given then a value of 0 is used for the Y angle (ie: no skew on the Y axis)."},{name:"skewX()",description:"Specifies a skew transformation along the X axis by the given angle."},{name:"skewY()",description:"Specifies a skew transformation along the Y axis by the given angle."},{name:"translate()",description:"Specifies a 2D translation by the vector [tx, ty], where tx is the first translation-value parameter and ty is the optional second translation-value parameter."},{name:"translate3d()",description:"Specifies a 3D translation by the vector [tx,ty,tz], with tx, ty and tz being the first, second and third translation-value parameters respectively."},{name:"translateX()",description:"Specifies a translation by the given amount in the X direction."},{name:"translateY()",description:"Specifies a translation by the given amount in the Y direction."},{name:"translateZ()",description:"Specifies a translation by the given amount in the Z direction. Note that percentage values are not allowed in the translateZ translation-value, and if present are evaluated as 0."}],relevance:50,description:"A two-dimensional transformation is applied to an element through the 'transform' property. This property contains a list of transform functions similar to those allowed by SVG.",restrictions:["enum"]},{name:"-o-transform-origin",browsers:["O10.5"],relevance:50,description:"Establishes the origin of transformation for an element.",restrictions:["positon","length","percentage"]},{name:"-o-transition",browsers:["O11.5"],values:[{name:"all",description:"Every property that is able to undergo a transition will do so."},{name:"none",description:"No property will transition."}],relevance:50,description:"Shorthand property combines four of the transition properties into a single property.",restrictions:["time","property","timing-function","enum"]},{name:"-o-transition-delay",browsers:["O11.5"],relevance:50,description:"Defines when the transition will start. It allows a transition to begin execution some period of time from when it is applied.",restrictions:["time"]},{name:"-o-transition-duration",browsers:["O11.5"],relevance:50,description:"Specifies how long the transition from the old value to the new value should take.",restrictions:["time"]},{name:"-o-transition-property",browsers:["O11.5"],values:[{name:"all",description:"Every property that is able to undergo a transition will do so."},{name:"none",description:"No property will transition."}],relevance:50,description:"Specifies the name of the CSS property to which the transition is applied.",restrictions:["property"]},{name:"-o-transition-timing-function",browsers:["O11.5"],relevance:50,description:"Describes how the intermediate values used during a transition will be calculated.",restrictions:["timing-function"]},{name:"offset-block-end",browsers:["FF41"],values:[{name:"auto",description:"For non-replaced elements, the effect of this value depends on which of related properties have the value 'auto' as well."}],relevance:50,description:"Logical 'bottom'. Mapping depends on the parent element’s 'writing-mode', 'direction', and 'text-orientation'.",restrictions:["length","percentage"]},{name:"offset-block-start",browsers:["FF41"],values:[{name:"auto",description:"For non-replaced elements, the effect of this value depends on which of related properties have the value 'auto' as well."}],relevance:50,description:"Logical 'top'. Mapping depends on the parent element’s 'writing-mode', 'direction', and 'text-orientation'.",restrictions:["length","percentage"]},{name:"offset-inline-end",browsers:["FF41"],values:[{name:"auto",description:"For non-replaced elements, the effect of this value depends on which of related properties have the value 'auto' as well."}],relevance:50,description:"Logical 'right'. Mapping depends on the parent element’s 'writing-mode', 'direction', and 'text-orientation'.",restrictions:["length","percentage"]},{name:"offset-inline-start",browsers:["FF41"],values:[{name:"auto",description:"For non-replaced elements, the effect of this value depends on which of related properties have the value 'auto' as well."}],relevance:50,description:"Logical 'left'. Mapping depends on the parent element’s 'writing-mode', 'direction', and 'text-orientation'.",restrictions:["length","percentage"]},{name:"outline",values:[{name:"auto",description:"Permits the user agent to render a custom outline style, typically the default platform style."},{name:"invert",description:"Performs a color inversion on the pixels on the screen."}],syntax:"[ <'outline-color'> || <'outline-style'> || <'outline-width'> ]",relevance:88,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/outline"}],description:"Shorthand property for 'outline-style', 'outline-width', and 'outline-color'.",restrictions:["length","line-width","line-style","color","enum"]},{name:"outline-color",values:[{name:"invert",description:"Performs a color inversion on the pixels on the screen."}],syntax:"<color> | invert",relevance:54,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/outline-color"}],description:"The color of the outline.",restrictions:["enum","color"]},{name:"outline-offset",browsers:["E15","FF1.5","S1.2","C1","O9.5"],syntax:"<length>",relevance:68,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/outline-offset"}],description:"Offset the outline and draw it beyond the border edge.",restrictions:["length"]},{name:"outline-style",values:[{name:"auto",description:"Permits the user agent to render a custom outline style, typically the default platform style."}],syntax:"auto | <'border-style'>",relevance:61,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/outline-style"}],description:"Style of the outline.",restrictions:["line-style","enum"]},{name:"outline-width",syntax:"<line-width>",relevance:61,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/outline-width"}],description:"Width of the outline.",restrictions:["length","line-width"]},{name:"overflow",values:[{name:"auto",description:"The behavior of the 'auto' value is UA-dependent, but should cause a scrolling mechanism to be provided for overflowing boxes."},{name:"hidden",description:"Content is clipped and no scrolling mechanism should be provided to view the content outside the clipping region."},{name:"-moz-hidden-unscrollable",description:"Same as the standardized 'clip', except doesn’t establish a block formatting context."},{name:"scroll",description:"Content is clipped and if the user agent uses a scrolling mechanism that is visible on the screen (such as a scroll bar or a panner), that mechanism should be displayed for a box whether or not any of its content is clipped."},{name:"visible",description:"Content is not clipped, i.e., it may be rendered outside the content box."}],syntax:"[ visible | hidden | clip | scroll | auto ]{1,2}",relevance:93,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/overflow"}],description:"Shorthand for setting 'overflow-x' and 'overflow-y'.",restrictions:["enum"]},{name:"overflow-wrap",values:[{name:"break-word",description:"An otherwise unbreakable sequence of characters may be broken at an arbitrary point if there are no otherwise-acceptable break points in the line."},{name:"normal",description:"Lines may break only at allowed break points."}],syntax:"normal | break-word | anywhere",relevance:64,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/overflow-wrap"}],description:"Specifies whether the UA may break within a word to prevent overflow when an otherwise-unbreakable string is too long to fit within the line box.",restrictions:["enum"]},{name:"overflow-x",values:[{name:"auto",description:"The behavior of the 'auto' value is UA-dependent, but should cause a scrolling mechanism to be provided for overflowing boxes."},{name:"hidden",description:"Content is clipped and no scrolling mechanism should be provided to view the content outside the clipping region."},{name:"scroll",description:"Content is clipped and if the user agent uses a scrolling mechanism that is visible on the screen (such as a scroll bar or a panner), that mechanism should be displayed for a box whether or not any of its content is clipped."},{name:"visible",description:"Content is not clipped, i.e., it may be rendered outside the content box."}],syntax:"visible | hidden | clip | scroll | auto",relevance:82,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/overflow-x"}],description:"Specifies the handling of overflow in the horizontal direction.",restrictions:["enum"]},{name:"overflow-y",values:[{name:"auto",description:"The behavior of the 'auto' value is UA-dependent, but should cause a scrolling mechanism to be provided for overflowing boxes."},{name:"hidden",description:"Content is clipped and no scrolling mechanism should be provided to view the content outside the clipping region."},{name:"scroll",description:"Content is clipped and if the user agent uses a scrolling mechanism that is visible on the screen (such as a scroll bar or a panner), that mechanism should be displayed for a box whether or not any of its content is clipped."},{name:"visible",description:"Content is not clipped, i.e., it may be rendered outside the content box."}],syntax:"visible | hidden | clip | scroll | auto",relevance:83,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/overflow-y"}],description:"Specifies the handling of overflow in the vertical direction.",restrictions:["enum"]},{name:"pad",browsers:["FF33"],syntax:"<integer> && <symbol>",relevance:50,description:"@counter-style descriptor. Specifies a “fixed-width” counter style, where representations shorter than the pad value are padded with a particular <symbol>",restrictions:["integer","image","string","identifier"]},{name:"padding",values:[],syntax:"[ <length> | <percentage> ]{1,4}",relevance:96,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/padding"}],description:"Shorthand property to set values for the thickness of the padding area. If left is omitted, it is the same as right. If bottom is omitted it is the same as top, if right is omitted it is the same as top. The value may not be negative.",restrictions:["length","percentage"]},{name:"padding-bottom",syntax:"<length> | <percentage>",relevance:90,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/padding-bottom"}],description:"Shorthand property to set values for the thickness of the padding area. If left is omitted, it is the same as right. If bottom is omitted it is the same as top, if right is omitted it is the same as top. The value may not be negative.",restrictions:["length","percentage"]},{name:"padding-block-end",browsers:["E79","FF41","S12.1","C69","O56"],syntax:"<'padding-left'>",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/padding-block-end"}],description:"Logical 'padding-bottom'. Mapping depends on the parent element’s 'writing-mode', 'direction', and 'text-orientation'.",restrictions:["length","percentage"]},{name:"padding-block-start",browsers:["E79","FF41","S12.1","C69","O56"],syntax:"<'padding-left'>",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/padding-block-start"}],description:"Logical 'padding-top'. Mapping depends on the parent element’s 'writing-mode', 'direction', and 'text-orientation'.",restrictions:["length","percentage"]},{name:"padding-inline-end",browsers:["E79","FF41","S12.1","C69","O56"],syntax:"<'padding-left'>",relevance:51,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/padding-inline-end"}],description:"Logical 'padding-right'. Mapping depends on the parent element’s 'writing-mode', 'direction', and 'text-orientation'.",restrictions:["length","percentage"]},{name:"padding-inline-start",browsers:["E79","FF41","S12.1","C69","O56"],syntax:"<'padding-left'>",relevance:51,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/padding-inline-start"}],description:"Logical 'padding-left'. Mapping depends on the parent element’s 'writing-mode', 'direction', and 'text-orientation'.",restrictions:["length","percentage"]},{name:"padding-left",syntax:"<length> | <percentage>",relevance:91,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/padding-left"}],description:"Shorthand property to set values for the thickness of the padding area. If left is omitted, it is the same as right. If bottom is omitted it is the same as top, if right is omitted it is the same as top. The value may not be negative.",restrictions:["length","percentage"]},{name:"padding-right",syntax:"<length> | <percentage>",relevance:90,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/padding-right"}],description:"Shorthand property to set values for the thickness of the padding area. If left is omitted, it is the same as right. If bottom is omitted it is the same as top, if right is omitted it is the same as top. The value may not be negative.",restrictions:["length","percentage"]},{name:"padding-top",syntax:"<length> | <percentage>",relevance:91,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/padding-top"}],description:"Shorthand property to set values for the thickness of the padding area. If left is omitted, it is the same as right. If bottom is omitted it is the same as top, if right is omitted it is the same as top. The value may not be negative.",restrictions:["length","percentage"]},{name:"page-break-after",values:[{name:"always",description:"Always force a page break after the generated box."},{name:"auto",description:"Neither force nor forbid a page break after generated box."},{name:"avoid",description:"Avoid a page break after the generated box."},{name:"left",description:"Force one or two page breaks after the generated box so that the next page is formatted as a left page."},{name:"right",description:"Force one or two page breaks after the generated box so that the next page is formatted as a right page."}],syntax:"auto | always | avoid | left | right | recto | verso",relevance:52,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/page-break-after"}],description:"Defines rules for page breaks after an element.",restrictions:["enum"]},{name:"page-break-before",values:[{name:"always",description:"Always force a page break before the generated box."},{name:"auto",description:"Neither force nor forbid a page break before the generated box."},{name:"avoid",description:"Avoid a page break before the generated box."},{name:"left",description:"Force one or two page breaks before the generated box so that the next page is formatted as a left page."},{name:"right",description:"Force one or two page breaks before the generated box so that the next page is formatted as a right page."}],syntax:"auto | always | avoid | left | right | recto | verso",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/page-break-before"}],description:"Defines rules for page breaks before an element.",restrictions:["enum"]},{name:"page-break-inside",values:[{name:"auto",description:"Neither force nor forbid a page break inside the generated box."},{name:"avoid",description:"Avoid a page break inside the generated box."}],syntax:"auto | avoid",relevance:53,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/page-break-inside"}],description:"Defines rules for page breaks inside an element.",restrictions:["enum"]},{name:"paint-order",browsers:["E17","FF60","S8","C35","O22"],values:[{name:"fill"},{name:"markers"},{name:"normal",description:"The element is painted with the standard order of painting operations: the 'fill' is painted first, then its 'stroke' and finally its markers."},{name:"stroke"}],syntax:"normal | [ fill || stroke || markers ]",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/paint-order"}],description:"Controls the order that the three paint operations that shapes and text are rendered with: their fill, their stroke and any markers they might have.",restrictions:["enum"]},{name:"perspective",values:[{name:"none",description:"No perspective transform is applied."}],syntax:"none | <length>",relevance:55,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/perspective"}],description:"Applies the same transform as the perspective(<number>) transform function, except that it applies only to the positioned or transformed children of the element, not to the transform on the element itself.",restrictions:["length","enum"]},{name:"perspective-origin",syntax:"<position>",relevance:51,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/perspective-origin"}],description:"Establishes the origin for the perspective property. It effectively sets the X and Y position at which the viewer appears to be looking at the children of the element.",restrictions:["position","percentage","length"]},{name:"pointer-events",values:[{name:"all",description:"The given element can be the target element for pointer events whenever the pointer is over either the interior or the perimeter of the element."},{name:"fill",description:"The given element can be the target element for pointer events whenever the pointer is over the interior of the element."},{name:"none",description:"The given element does not receive pointer events."},{name:"painted",description:'The given element can be the target element for pointer events when the pointer is over a "painted" area. '},{name:"stroke",description:"The given element can be the target element for pointer events whenever the pointer is over the perimeter of the element."},{name:"visible",description:"The given element can be the target element for pointer events when the ‘visibility’ property is set to visible and the pointer is over either the interior or the perimeter of the element."},{name:"visibleFill",description:"The given element can be the target element for pointer events when the ‘visibility’ property is set to visible and when the pointer is over the interior of the element."},{name:"visiblePainted",description:"The given element can be the target element for pointer events when the ‘visibility’ property is set to visible and when the pointer is over a ‘painted’ area."},{name:"visibleStroke",description:"The given element can be the target element for pointer events when the ‘visibility’ property is set to visible and when the pointer is over the perimeter of the element."}],syntax:"auto | none | visiblePainted | visibleFill | visibleStroke | visible | painted | fill | stroke | all | inherit",relevance:83,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/pointer-events"}],description:"Specifies under what circumstances a given element can be the target element for a pointer event.",restrictions:["enum"]},{name:"position",values:[{name:"absolute",description:"The box's position (and possibly size) is specified with the 'top', 'right', 'bottom', and 'left' properties. These properties specify offsets with respect to the box's 'containing block'."},{name:"fixed",description:"The box's position is calculated according to the 'absolute' model, but in addition, the box is fixed with respect to some reference. As with the 'absolute' model, the box's margins do not collapse with any other margins."},{name:"-ms-page",description:"The box's position is calculated according to the 'absolute' model."},{name:"relative",description:"The box's position is calculated according to the normal flow (this is called the position in normal flow). Then the box is offset relative to its normal position."},{name:"static",description:"The box is a normal box, laid out according to the normal flow. The 'top', 'right', 'bottom', and 'left' properties do not apply."},{name:"sticky",description:"The box's position is calculated according to the normal flow. Then the box is offset relative to its flow root and containing block and in all cases, including table elements, does not affect the position of any following boxes."},{name:"-webkit-sticky",description:"The box's position is calculated according to the normal flow. Then the box is offset relative to its flow root and containing block and in all cases, including table elements, does not affect the position of any following boxes."}],syntax:"static | relative | absolute | sticky | fixed",relevance:96,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/position"}],description:"The position CSS property sets how an element is positioned in a document. The top, right, bottom, and left properties determine the final location of positioned elements.",restrictions:["enum"]},{name:"prefix",browsers:["FF33"],syntax:"<symbol>",relevance:50,description:"@counter-style descriptor. Specifies a <symbol> that is prepended to the marker representation.",restrictions:["image","string","identifier"]},{name:"quotes",values:[{name:"none",description:"The 'open-quote' and 'close-quote' values of the 'content' property produce no quotations marks, as if they were 'no-open-quote' and 'no-close-quote' respectively."}],syntax:"none | auto | [ <string> <string> ]+",relevance:54,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/quotes"}],description:"Specifies quotation marks for any number of embedded quotations.",restrictions:["string"]},{name:"range",browsers:["FF33"],values:[{name:"auto",description:"The range depends on the counter system."},{name:"infinite",description:"If used as the first value in a range, it represents negative infinity; if used as the second value, it represents positive infinity."}],syntax:"[ [ <integer> | infinite ]{2} ]# | auto",relevance:50,description:"@counter-style descriptor. Defines the ranges over which the counter style is defined.",restrictions:["integer","enum"]},{name:"resize",browsers:["E79","FF4","S3","C1","O12.1"],values:[{name:"both",description:"The UA presents a bidirectional resizing mechanism to allow the user to adjust both the height and the width of the element."},{name:"horizontal",description:"The UA presents a unidirectional horizontal resizing mechanism to allow the user to adjust only the width of the element."},{name:"none",description:"The UA does not present a resizing mechanism on the element, and the user is given no direct manipulation mechanism to resize the element."},{name:"vertical",description:"The UA presents a unidirectional vertical resizing mechanism to allow the user to adjust only the height of the element."}],syntax:"none | both | horizontal | vertical | block | inline",relevance:60,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/resize"}],description:"Specifies whether or not an element is resizable by the user, and if so, along which axis/axes.",restrictions:["enum"]},{name:"right",values:[{name:"auto",description:"For non-replaced elements, the effect of this value depends on which of related properties have the value 'auto' as well"}],syntax:"<length> | <percentage> | auto",relevance:92,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/right"}],description:"Specifies how far an absolutely positioned box's right margin edge is offset to the left of the right edge of the box's 'containing block'.",restrictions:["length","percentage"]},{name:"ruby-align",browsers:["FF38"],values:[{name:"auto",browsers:["FF38"],description:"The user agent determines how the ruby contents are aligned. This is the initial value."},{name:"center",description:"The ruby content is centered within its box."},{name:"distribute-letter",browsers:["FF38"],description:"If the width of the ruby text is smaller than that of the base, then the ruby text contents are evenly distributed across the width of the base, with the first and last ruby text glyphs lining up with the corresponding first and last base glyphs. If the width of the ruby text is at least the width of the base, then the letters of the base are evenly distributed across the width of the ruby text."},{name:"distribute-space",browsers:["FF38"],description:"If the width of the ruby text is smaller than that of the base, then the ruby text contents are evenly distributed across the width of the base, with a certain amount of white space preceding the first and following the last character in the ruby text. That amount of white space is normally equal to half the amount of inter-character space of the ruby text."},{name:"left",description:"The ruby text content is aligned with the start edge of the base."},{name:"line-edge",browsers:["FF38"],description:"If the ruby text is not adjacent to a line edge, it is aligned as in 'auto'. If it is adjacent to a line edge, then it is still aligned as in auto, but the side of the ruby text that touches the end of the line is lined up with the corresponding edge of the base."},{name:"right",browsers:["FF38"],description:"The ruby text content is aligned with the end edge of the base."},{name:"start",browsers:["FF38"],description:"The ruby text content is aligned with the start edge of the base."},{name:"space-between",browsers:["FF38"],description:"The ruby content expands as defined for normal text justification (as defined by 'text-justify'),"},{name:"space-around",browsers:["FF38"],description:"As for 'space-between' except that there exists an extra justification opportunities whose space is distributed half before and half after the ruby content."}],status:"experimental",syntax:"start | center | space-between | space-around",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/ruby-align"}],description:"Specifies how text is distributed within the various ruby boxes when their contents do not exactly fill their respective boxes.",restrictions:["enum"]},{name:"ruby-overhang",browsers:["FF10","IE5"],values:[{name:"auto",description:"The ruby text can overhang text adjacent to the base on either side. This is the initial value."},{name:"end",description:"The ruby text can overhang the text that follows it."},{name:"none",description:"The ruby text cannot overhang any text adjacent to its base, only its own base."},{name:"start",description:"The ruby text can overhang the text that precedes it."}],relevance:50,description:"Determines whether, and on which side, ruby text is allowed to partially overhang any adjacent text in addition to its own base, when the ruby text is wider than the ruby base.",restrictions:["enum"]},{name:"ruby-position",browsers:["E84","FF38","S7","C84","O70"],values:[{name:"after",description:"The ruby text appears after the base. This is a relatively rare setting used in ideographic East Asian writing systems, most easily found in educational text."},{name:"before",description:"The ruby text appears before the base. This is the most common setting used in ideographic East Asian writing systems."},{name:"inline"},{name:"right",description:"The ruby text appears on the right of the base. Unlike 'before' and 'after', this value is not relative to the text flow direction."}],status:"experimental",syntax:"[ alternate || [ over | under ] ] | inter-character",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/ruby-position"}],description:"Used by the parent of elements with display: ruby-text to control the position of the ruby text with respect to its base.",restrictions:["enum"]},{name:"ruby-span",browsers:["FF10"],values:[{name:"attr(x)",description:"The value of attribute 'x' is a string value. The string value is evaluated as a <number> to determine the number of ruby base elements to be spanned by the annotation element."},{name:"none",description:"No spanning. The computed value is '1'."}],relevance:50,description:"Determines whether, and on which side, ruby text is allowed to partially overhang any adjacent text in addition to its own base, when the ruby text is wider than the ruby base.",restrictions:["enum"]},{name:"scrollbar-3dlight-color",browsers:["IE5"],relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/scrollbar-3dlight-color"}],description:"Determines the color of the top and left edges of the scroll box and scroll arrows of a scroll bar.",restrictions:["color"]},{name:"scrollbar-arrow-color",browsers:["IE5"],relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/scrollbar-arrow-color"}],description:"Determines the color of the arrow elements of a scroll arrow.",restrictions:["color"]},{name:"scrollbar-base-color",browsers:["IE5"],relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/scrollbar-base-color"}],description:"Determines the color of the main elements of a scroll bar, which include the scroll box, track, and scroll arrows.",restrictions:["color"]},{name:"scrollbar-darkshadow-color",browsers:["IE5"],relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/scrollbar-darkshadow-color"}],description:"Determines the color of the gutter of a scroll bar.",restrictions:["color"]},{name:"scrollbar-face-color",browsers:["IE5"],relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/scrollbar-face-color"}],description:"Determines the color of the scroll box and scroll arrows of a scroll bar.",restrictions:["color"]},{name:"scrollbar-highlight-color",browsers:["IE5"],relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/scrollbar-highlight-color"}],description:"Determines the color of the top and left edges of the scroll box and scroll arrows of a scroll bar.",restrictions:["color"]},{name:"scrollbar-shadow-color",browsers:["IE5"],relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/scrollbar-shadow-color"}],description:"Determines the color of the bottom and right edges of the scroll box and scroll arrows of a scroll bar.",restrictions:["color"]},{name:"scrollbar-track-color",browsers:["IE6"],relevance:50,description:"Determines the color of the track element of a scroll bar.",restrictions:["color"]},{name:"scroll-behavior",browsers:["E79","FF36","Spreview","C61","O48"],values:[{name:"auto",description:"Scrolls in an instant fashion."},{name:"smooth",description:"Scrolls in a smooth fashion using a user-agent-defined timing function and time period."}],syntax:"auto | smooth",relevance:53,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/scroll-behavior"}],description:"Specifies the scrolling behavior for a scrolling box, when scrolling happens due to navigation or CSSOM scrolling APIs.",restrictions:["enum"]},{name:"scroll-snap-coordinate",browsers:["FF39"],values:[{name:"none",description:"Specifies that this element does not contribute a snap point."}],status:"obsolete",syntax:"none | <position>#",relevance:0,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/scroll-snap-coordinate"}],description:"Defines the x and y coordinate within the element which will align with the nearest ancestor scroll container’s snap-destination for the respective axis.",restrictions:["position","length","percentage","enum"]},{name:"scroll-snap-destination",browsers:["FF39"],status:"obsolete",syntax:"<position>",relevance:0,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/scroll-snap-destination"}],description:"Define the x and y coordinate within the scroll container’s visual viewport which element snap points will align with.",restrictions:["position","length","percentage"]},{name:"scroll-snap-points-x",browsers:["FF39","S9"],values:[{name:"none",description:"No snap points are defined by this scroll container."},{name:"repeat()",description:"Defines an interval at which snap points are defined, starting from the container’s relevant start edge."}],status:"obsolete",syntax:"none | repeat( <length-percentage> )",relevance:0,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/scroll-snap-points-x"}],description:"Defines the positioning of snap points along the x axis of the scroll container it is applied to.",restrictions:["enum"]},{name:"scroll-snap-points-y",browsers:["FF39","S9"],values:[{name:"none",description:"No snap points are defined by this scroll container."},{name:"repeat()",description:"Defines an interval at which snap points are defined, starting from the container’s relevant start edge."}],status:"obsolete",syntax:"none | repeat( <length-percentage> )",relevance:0,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/scroll-snap-points-y"}],description:"Defines the positioning of snap points along the y axis of the scroll container it is applied to.",restrictions:["enum"]},{name:"scroll-snap-type",values:[{name:"none",description:"The visual viewport of this scroll container must ignore snap points, if any, when scrolled."},{name:"mandatory",description:"The visual viewport of this scroll container is guaranteed to rest on a snap point when there are no active scrolling operations."},{name:"proximity",description:"The visual viewport of this scroll container may come to rest on a snap point at the termination of a scroll at the discretion of the UA given the parameters of the scroll."}],syntax:"none | [ x | y | block | inline | both ] [ mandatory | proximity ]?",relevance:52,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/scroll-snap-type"}],description:"Defines how strictly snap points are enforced on the scroll container.",restrictions:["enum"]},{name:"shape-image-threshold",browsers:["E79","FF62","S10.1","C37","O24"],syntax:"<alpha-value>",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/shape-image-threshold"}],description:"Defines the alpha channel threshold used to extract the shape using an image. A value of 0.5 means that the shape will enclose all the pixels that are more than 50% opaque.",restrictions:["number"]},{name:"shape-margin",browsers:["E79","FF62","S10.1","C37","O24"],syntax:"<length-percentage>",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/shape-margin"}],description:"Adds a margin to a 'shape-outside'. This defines a new shape that is the smallest contour that includes all the points that are the 'shape-margin' distance outward in the perpendicular direction from a point on the underlying shape.",restrictions:["url","length","percentage"]},{name:"shape-outside",browsers:["E79","FF62","S10.1","C37","O24"],values:[{name:"margin-box",description:"The background is painted within (clipped to) the margin box."},{name:"none",description:"The float area is unaffected."}],syntax:"none | [ <shape-box> || <basic-shape> ] | <image>",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/shape-outside"}],description:"Specifies an orthogonal rotation to be applied to an image before it is laid out.",restrictions:["image","box","shape","enum"]},{name:"shape-rendering",values:[{name:"auto",description:"Suppresses aural rendering."},{name:"crispEdges",description:"Emphasize the contrast between clean edges of artwork over rendering speed and geometric precision."},{name:"geometricPrecision",description:"Emphasize geometric precision over speed and crisp edges."},{name:"optimizeSpeed",description:"Emphasize rendering speed over geometric precision and crisp edges."}],relevance:50,description:"Provides hints about what tradeoffs to make as it renders vector graphics elements such as <path> elements and basic shapes such as circles and rectangles.",restrictions:["enum"]},{name:"size",browsers:["C","O8"],syntax:"<length>{1,2} | auto | [ <page-size> || [ portrait | landscape ] ]",relevance:53,description:"The size CSS at-rule descriptor, used with the @page at-rule, defines the size and orientation of the box which is used to represent a page. Most of the time, this size corresponds to the target size of the printed page if applicable.",restrictions:["length"]},{name:"src",values:[{name:"url()",description:"Reference font by URL"},{name:"format()",description:"Optional hint describing the format of the font resource."},{name:"local()",description:"Format-specific string that identifies a locally available copy of a given font."}],syntax:"[ <url> [ format( <string># ) ]? | local( <family-name> ) ]#",relevance:87,description:"@font-face descriptor. Specifies the resource containing font data. It is required, whether the font is downloadable or locally installed.",restrictions:["enum","url","identifier"]},{name:"stop-color",relevance:51,description:"Indicates what color to use at that gradient stop.",restrictions:["color"]},{name:"stop-opacity",relevance:50,description:"Defines the opacity of a given gradient stop.",restrictions:["number(0-1)"]},{name:"stroke",values:[{name:"url()",description:"A URL reference to a paint server element, which is an element that defines a paint server: ‘hatch’, ‘linearGradient’, ‘mesh’, ‘pattern’, ‘radialGradient’ and ‘solidcolor’."},{name:"none",description:"No paint is applied in this layer."}],relevance:64,description:"Paints along the outline of the given graphical element.",restrictions:["color","enum","url"]},{name:"stroke-dasharray",values:[{name:"none",description:"Indicates that no dashing is used."}],relevance:58,description:"Controls the pattern of dashes and gaps used to stroke paths.",restrictions:["length","percentage","number","enum"]},{name:"stroke-dashoffset",relevance:58,description:"Specifies the distance into the dash pattern to start the dash.",restrictions:["percentage","length"]},{name:"stroke-linecap",values:[{name:"butt",description:"Indicates that the stroke for each subpath does not extend beyond its two endpoints."},{name:"round",description:"Indicates that at each end of each subpath, the shape representing the stroke will be extended by a half circle with a radius equal to the stroke width."},{name:"square",description:"Indicates that at the end of each subpath, the shape representing the stroke will be extended by a rectangle with the same width as the stroke width and whose length is half of the stroke width."}],relevance:53,description:"Specifies the shape to be used at the end of open subpaths when they are stroked.",restrictions:["enum"]},{name:"stroke-linejoin",values:[{name:"bevel",description:"Indicates that a bevelled corner is to be used to join path segments."},{name:"miter",description:"Indicates that a sharp corner is to be used to join path segments."},{name:"round",description:"Indicates that a round corner is to be used to join path segments."}],relevance:50,description:"Specifies the shape to be used at the corners of paths or basic shapes when they are stroked.",restrictions:["enum"]},{name:"stroke-miterlimit",relevance:50,description:"When two line segments meet at a sharp angle and miter joins have been specified for 'stroke-linejoin', it is possible for the miter to extend far beyond the thickness of the line stroking the path.",restrictions:["number"]},{name:"stroke-opacity",relevance:52,description:"Specifies the opacity of the painting operation used to stroke the current object.",restrictions:["number(0-1)"]},{name:"stroke-width",relevance:61,description:"Specifies the width of the stroke on the current object.",restrictions:["percentage","length"]},{name:"suffix",browsers:["FF33"],syntax:"<symbol>",relevance:50,description:"@counter-style descriptor. Specifies a <symbol> that is appended to the marker representation.",restrictions:["image","string","identifier"]},{name:"system",browsers:["FF33"],values:[{name:"additive",description:"Represents “sign-value” numbering systems, which, rather than using reusing digits in different positions to change their value, define additional digits with much larger values, so that the value of the number can be obtained by adding all the digits together."},{name:"alphabetic",description:'Interprets the list of counter symbols as digits to an alphabetic numbering system, similar to the default lower-alpha counter style, which wraps from "a", "b", "c", to "aa", "ab", "ac".'},{name:"cyclic",description:"Cycles repeatedly through its provided symbols, looping back to the beginning when it reaches the end of the list."},{name:"extends",description:"Use the algorithm of another counter style, but alter other aspects."},{name:"fixed",description:"Runs through its list of counter symbols once, then falls back."},{name:"numeric",description:"interprets the list of counter symbols as digits to a \"place-value\" numbering system, similar to the default 'decimal' counter style."},{name:"symbolic",description:"Cycles repeatedly through its provided symbols, doubling, tripling, etc. the symbols on each successive pass through the list."}],syntax:"cyclic | numeric | alphabetic | symbolic | additive | [ fixed <integer>? ] | [ extends <counter-style-name> ]",relevance:50,description:"@counter-style descriptor. Specifies which algorithm will be used to construct the counter’s representation based on the counter value.",restrictions:["enum","integer"]},{name:"symbols",browsers:["FF33"],syntax:"<symbol>+",relevance:50,description:"@counter-style descriptor. Specifies the symbols used by the marker-construction algorithm specified by the system descriptor.",restrictions:["image","string","identifier"]},{name:"table-layout",values:[{name:"auto",description:"Use any automatic table layout algorithm."},{name:"fixed",description:"Use the fixed table layout algorithm."}],syntax:"auto | fixed",relevance:60,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/table-layout"}],description:"Controls the algorithm used to lay out the table cells, rows, and columns.",restrictions:["enum"]},{name:"tab-size",browsers:["E79","FF91","S7","C21","O15"],syntax:"<integer> | <length>",relevance:51,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/tab-size"}],description:"Determines the width of the tab character (U+0009), in space characters (U+0020), when rendered.",restrictions:["integer","length"]},{name:"text-align",values:[{name:"center",description:"The inline contents are centered within the line box."},{name:"end",description:"The inline contents are aligned to the end edge of the line box."},{name:"justify",description:"The text is justified according to the method specified by the 'text-justify' property."},{name:"left",description:"The inline contents are aligned to the left edge of the line box. In vertical text, 'left' aligns to the edge of the line box that would be the start edge for left-to-right text."},{name:"right",description:"The inline contents are aligned to the right edge of the line box. In vertical text, 'right' aligns to the edge of the line box that would be the end edge for left-to-right text."},{name:"start",description:"The inline contents are aligned to the start edge of the line box."}],syntax:"start | end | left | right | center | justify | match-parent",relevance:94,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/text-align"}],description:"Describes how inline contents of a block are horizontally aligned if the contents do not completely fill the line box.",restrictions:["string"]},{name:"text-align-last",browsers:["E12","FF49","C47","IE5.5","O34"],values:[{name:"auto",description:"Content on the affected line is aligned per 'text-align' unless 'text-align' is set to 'justify', in which case it is 'start-aligned'."},{name:"center",description:"The inline contents are centered within the line box."},{name:"justify",description:"The text is justified according to the method specified by the 'text-justify' property."},{name:"left",description:"The inline contents are aligned to the left edge of the line box. In vertical text, 'left' aligns to the edge of the line box that would be the start edge for left-to-right text."},{name:"right",description:"The inline contents are aligned to the right edge of the line box. In vertical text, 'right' aligns to the edge of the line box that would be the end edge for left-to-right text."}],syntax:"auto | start | end | left | right | center | justify",relevance:51,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/text-align-last"}],description:"Describes how the last line of a block or a line right before a forced line break is aligned when 'text-align' is set to 'justify'.",restrictions:["enum"]},{name:"text-anchor",values:[{name:"end",description:"The rendered characters are aligned such that the end of the resulting rendered text is at the initial current text position."},{name:"middle",description:"The rendered characters are aligned such that the geometric middle of the resulting rendered text is at the initial current text position."},{name:"start",description:"The rendered characters are aligned such that the start of the resulting rendered text is at the initial current text position."}],relevance:50,description:"Used to align (start-, middle- or end-alignment) a string of text relative to a given point.",restrictions:["enum"]},{name:"text-decoration",values:[{name:"dashed",description:"Produces a dashed line style."},{name:"dotted",description:"Produces a dotted line."},{name:"double",description:"Produces a double line."},{name:"line-through",description:"Each line of text has a line through the middle."},{name:"none",description:"Produces no line."},{name:"overline",description:"Each line of text has a line above it."},{name:"solid",description:"Produces a solid line."},{name:"underline",description:"Each line of text is underlined."},{name:"wavy",description:"Produces a wavy line."}],syntax:"<'text-decoration-line'> || <'text-decoration-style'> || <'text-decoration-color'> || <'text-decoration-thickness'>",relevance:92,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/text-decoration"}],description:"Decorations applied to font used for an element's text.",restrictions:["enum","color"]},{name:"text-decoration-color",browsers:["E79","FF36","S12.1","C57","O44"],syntax:"<color>",relevance:52,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/text-decoration-color"}],description:"Specifies the color of text decoration (underlines overlines, and line-throughs) set on the element with text-decoration-line.",restrictions:["color"]},{name:"text-decoration-line",browsers:["E79","FF36","S12.1","C57","O44"],values:[{name:"line-through",description:"Each line of text has a line through the middle."},{name:"none",description:"Neither produces nor inhibits text decoration."},{name:"overline",description:"Each line of text has a line above it."},{name:"underline",description:"Each line of text is underlined."}],syntax:"none | [ underline || overline || line-through || blink ] | spelling-error | grammar-error",relevance:51,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/text-decoration-line"}],description:"Specifies what line decorations, if any, are added to the element.",restrictions:["enum"]},{name:"text-decoration-style",browsers:["E79","FF36","S12.1","C57","O44"],values:[{name:"dashed",description:"Produces a dashed line style."},{name:"dotted",description:"Produces a dotted line."},{name:"double",description:"Produces a double line."},{name:"none",description:"Produces no line."},{name:"solid",description:"Produces a solid line."},{name:"wavy",description:"Produces a wavy line."}],syntax:"solid | double | dotted | dashed | wavy",relevance:51,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/text-decoration-style"}],description:"Specifies the line style for underline, line-through and overline text decoration.",restrictions:["enum"]},{name:"text-indent",values:[],syntax:"<length-percentage> && hanging? && each-line?",relevance:68,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/text-indent"}],description:"Specifies the indentation applied to lines of inline content in a block. The indentation only affects the first line of inline content in the block unless the 'hanging' keyword is specified, in which case it affects all lines except the first.",restrictions:["percentage","length"]},{name:"text-justify",browsers:["E12","FF55","C32","IE11","O19"],values:[{name:"auto",description:"The UA determines the justification algorithm to follow, based on a balance between performance and adequate presentation quality."},{name:"distribute",description:"Justification primarily changes spacing both at word separators and at grapheme cluster boundaries in all scripts except those in the connected and cursive groups. This value is sometimes used in e.g. Japanese, often with the 'text-align-last' property."},{name:"distribute-all-lines"},{name:"inter-cluster",description:"Justification primarily changes spacing at word separators and at grapheme cluster boundaries in clustered scripts. This value is typically used for Southeast Asian scripts such as Thai."},{name:"inter-ideograph",description:"Justification primarily changes spacing at word separators and at inter-graphemic boundaries in scripts that use no word spaces. This value is typically used for CJK languages."},{name:"inter-word",description:"Justification primarily changes spacing at word separators. This value is typically used for languages that separate words using spaces, like English or (sometimes) Korean."},{name:"kashida",description:"Justification primarily stretches Arabic and related scripts through the use of kashida or other calligraphic elongation."},{name:"newspaper"}],syntax:"auto | inter-character | inter-word | none",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/text-justify"}],description:"Selects the justification algorithm used when 'text-align' is set to 'justify'. The property applies to block containers, but the UA may (but is not required to) also support it on inline elements.",restrictions:["enum"]},{name:"text-orientation",browsers:["E79","FF41","S14","C48","O35"],values:[{name:"sideways",browsers:["E79","FF41","S14","C48","O35"],description:"This value is equivalent to 'sideways-right' in 'vertical-rl' writing mode and equivalent to 'sideways-left' in 'vertical-lr' writing mode."},{name:"sideways-right",browsers:["E79","FF41","S14","C48","O35"],description:"In vertical writing modes, this causes text to be set as if in a horizontal layout, but rotated 90° clockwise."},{name:"upright",description:"In vertical writing modes, characters from horizontal-only scripts are rendered upright, i.e. in their standard horizontal orientation."}],syntax:"mixed | upright | sideways",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/text-orientation"}],description:"Specifies the orientation of text within a line.",restrictions:["enum"]},{name:"text-overflow",values:[{name:"clip",description:"Clip inline content that overflows. Characters may be only partially rendered."},{name:"ellipsis",description:"Render an ellipsis character (U+2026) to represent clipped inline content."}],syntax:"[ clip | ellipsis | <string> ]{1,2}",relevance:82,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/text-overflow"}],description:"Text can overflow for example when it is prevented from wrapping.",restrictions:["enum","string"]},{name:"text-rendering",browsers:["E79","FF1","S5","C4","O15"],values:[{name:"auto"},{name:"geometricPrecision",description:"Indicates that the user agent shall emphasize geometric precision over legibility and rendering speed."},{name:"optimizeLegibility",description:"Indicates that the user agent shall emphasize legibility over rendering speed and geometric precision."},{name:"optimizeSpeed",description:"Indicates that the user agent shall emphasize rendering speed over legibility and geometric precision."}],syntax:"auto | optimizeSpeed | optimizeLegibility | geometricPrecision",relevance:68,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/text-rendering"}],description:"The creator of SVG content might want to provide a hint to the implementation about what tradeoffs to make as it renders text. The ‘text-rendering’ property provides these hints.",restrictions:["enum"]},{name:"text-shadow",values:[{name:"none",description:"No shadow."}],syntax:"none | <shadow-t>#",relevance:75,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/text-shadow"}],description:"Enables shadow effects to be applied to the text of the element.",restrictions:["length","color"]},{name:"text-transform",values:[{name:"capitalize",description:"Puts the first typographic letter unit of each word in titlecase."},{name:"lowercase",description:"Puts all letters in lowercase."},{name:"none",description:"No effects."},{name:"uppercase",description:"Puts all letters in uppercase."}],syntax:"none | capitalize | uppercase | lowercase | full-width | full-size-kana",relevance:86,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/text-transform"}],description:"Controls capitalization effects of an element’s text.",restrictions:["enum"]},{name:"text-underline-position",values:[{name:"above"},{name:"auto",description:"The user agent may use any algorithm to determine the underline’s position. In horizontal line layout, the underline should be aligned as for alphabetic. In vertical line layout, if the language is set to Japanese or Korean, the underline should be aligned as for over."},{name:"below",description:"The underline is aligned with the under edge of the element’s content box."}],syntax:"auto | from-font | [ under || [ left | right ] ]",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/text-underline-position"}],description:"Sets the position of an underline specified on the same element: it does not affect underlines specified by ancestor elements. This property is typically used in vertical writing contexts such as in Japanese documents where it often desired to have the underline appear 'over' (to the right of) the affected run of text",restrictions:["enum"]},{name:"top",values:[{name:"auto",description:"For non-replaced elements, the effect of this value depends on which of related properties have the value 'auto' as well"}],syntax:"<length> | <percentage> | auto",relevance:95,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/top"}],description:"Specifies how far an absolutely positioned box's top margin edge is offset below the top edge of the box's 'containing block'.",restrictions:["length","percentage"]},{name:"touch-action",values:[{name:"auto",description:"The user agent may determine any permitted touch behaviors for touches that begin on the element."},{name:"cross-slide-x"},{name:"cross-slide-y"},{name:"double-tap-zoom"},{name:"manipulation",description:"The user agent may consider touches that begin on the element only for the purposes of scrolling and continuous zooming."},{name:"none",description:"Touches that begin on the element must not trigger default touch behaviors."},{name:"pan-x",description:"The user agent may consider touches that begin on the element only for the purposes of horizontally scrolling the element’s nearest ancestor with horizontally scrollable content."},{name:"pan-y",description:"The user agent may consider touches that begin on the element only for the purposes of vertically scrolling the element’s nearest ancestor with vertically scrollable content."},{name:"pinch-zoom"}],syntax:"auto | none | [ [ pan-x | pan-left | pan-right ] || [ pan-y | pan-up | pan-down ] || pinch-zoom ] | manipulation",relevance:68,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/touch-action"}],description:"Determines whether touch input may trigger default behavior supplied by user agent.",restrictions:["enum"]},{name:"transform",values:[{name:"matrix()",description:"Specifies a 2D transformation in the form of a transformation matrix of six values. matrix(a,b,c,d,e,f) is equivalent to applying the transformation matrix [a b c d e f]"},{name:"matrix3d()",description:"Specifies a 3D transformation as a 4x4 homogeneous matrix of 16 values in column-major order."},{name:"none"},{name:"perspective()",description:"Specifies a perspective projection matrix."},{name:"rotate()",description:"Specifies a 2D rotation by the angle specified in the parameter about the origin of the element, as defined by the transform-origin property."},{name:"rotate3d()",description:"Specifies a clockwise 3D rotation by the angle specified in last parameter about the [x,y,z] direction vector described by the first 3 parameters."},{name:"rotateX('angle')",description:"Specifies a clockwise rotation by the given angle about the X axis."},{name:"rotateY('angle')",description:"Specifies a clockwise rotation by the given angle about the Y axis."},{name:"rotateZ('angle')",description:"Specifies a clockwise rotation by the given angle about the Z axis."},{name:"scale()",description:"Specifies a 2D scale operation by the [sx,sy] scaling vector described by the 2 parameters. If the second parameter is not provided, it is takes a value equal to the first."},{name:"scale3d()",description:"Specifies a 3D scale operation by the [sx,sy,sz] scaling vector described by the 3 parameters."},{name:"scaleX()",description:"Specifies a scale operation using the [sx,1] scaling vector, where sx is given as the parameter."},{name:"scaleY()",description:"Specifies a scale operation using the [sy,1] scaling vector, where sy is given as the parameter."},{name:"scaleZ()",description:"Specifies a scale operation using the [1,1,sz] scaling vector, where sz is given as the parameter."},{name:"skew()",description:"Specifies a skew transformation along the X and Y axes. The first angle parameter specifies the skew on the X axis. The second angle parameter specifies the skew on the Y axis. If the second parameter is not given then a value of 0 is used for the Y angle (ie: no skew on the Y axis)."},{name:"skewX()",description:"Specifies a skew transformation along the X axis by the given angle."},{name:"skewY()",description:"Specifies a skew transformation along the Y axis by the given angle."},{name:"translate()",description:"Specifies a 2D translation by the vector [tx, ty], where tx is the first translation-value parameter and ty is the optional second translation-value parameter."},{name:"translate3d()",description:"Specifies a 3D translation by the vector [tx,ty,tz], with tx, ty and tz being the first, second and third translation-value parameters respectively."},{name:"translateX()",description:"Specifies a translation by the given amount in the X direction."},{name:"translateY()",description:"Specifies a translation by the given amount in the Y direction."},{name:"translateZ()",description:"Specifies a translation by the given amount in the Z direction. Note that percentage values are not allowed in the translateZ translation-value, and if present are evaluated as 0."}],syntax:"none | <transform-list>",relevance:91,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/transform"}],description:"A two-dimensional transformation is applied to an element through the 'transform' property. This property contains a list of transform functions similar to those allowed by SVG.",restrictions:["enum"]},{name:"transform-origin",syntax:"[ <length-percentage> | left | center | right | top | bottom ] | [ [ <length-percentage> | left | center | right ] && [ <length-percentage> | top | center | bottom ] ] <length>?",relevance:77,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/transform-origin"}],description:"Establishes the origin of transformation for an element.",restrictions:["position","length","percentage"]},{name:"transform-style",browsers:["E12","FF16","S9","C36","O23"],values:[{name:"flat",description:"All children of this element are rendered flattened into the 2D plane of the element."},{name:"preserve-3d",browsers:["E12","FF16","S9","C36","O23"],description:"Flattening is not performed, so children maintain their position in 3D space."}],syntax:"flat | preserve-3d",relevance:55,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/transform-style"}],description:"Defines how nested elements are rendered in 3D space.",restrictions:["enum"]},{name:"transition",values:[{name:"all",description:"Every property that is able to undergo a transition will do so."},{name:"none",description:"No property will transition."}],syntax:"<single-transition>#",relevance:89,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/transition"}],description:"Shorthand property combines four of the transition properties into a single property.",restrictions:["time","property","timing-function","enum"]},{name:"transition-delay",syntax:"<time>#",relevance:63,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/transition-delay"}],description:"Defines when the transition will start. It allows a transition to begin execution some period of time from when it is applied.",restrictions:["time"]},{name:"transition-duration",syntax:"<time>#",relevance:63,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/transition-duration"}],description:"Specifies how long the transition from the old value to the new value should take.",restrictions:["time"]},{name:"transition-property",values:[{name:"all",description:"Every property that is able to undergo a transition will do so."},{name:"none",description:"No property will transition."}],syntax:"none | <single-transition-property>#",relevance:64,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/transition-property"}],description:"Specifies the name of the CSS property to which the transition is applied.",restrictions:["property"]},{name:"transition-timing-function",syntax:"<easing-function>#",relevance:64,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/transition-timing-function"}],description:"Describes how the intermediate values used during a transition will be calculated.",restrictions:["timing-function"]},{name:"unicode-bidi",values:[{name:"bidi-override",description:"Inside the element, reordering is strictly in sequence according to the 'direction' property; the implicit part of the bidirectional algorithm is ignored."},{name:"embed",description:"If the element is inline-level, this value opens an additional level of embedding with respect to the bidirectional algorithm. The direction of this embedding level is given by the 'direction' property."},{name:"isolate",description:"The contents of the element are considered to be inside a separate, independent paragraph."},{name:"isolate-override",description:"This combines the isolation behavior of 'isolate' with the directional override behavior of 'bidi-override'"},{name:"normal",description:"The element does not open an additional level of embedding with respect to the bidirectional algorithm. For inline-level elements, implicit reordering works across element boundaries."},{name:"plaintext",description:"For the purposes of the Unicode bidirectional algorithm, the base directionality of each bidi paragraph for which the element forms the containing block is determined not by the element's computed 'direction'."}],syntax:"normal | embed | isolate | bidi-override | isolate-override | plaintext",relevance:57,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/unicode-bidi"}],description:"The level of embedding with respect to the bidirectional algorithm.",restrictions:["enum"]},{name:"unicode-range",values:[{name:"U+26",description:"Ampersand."},{name:"U+20-24F, U+2B0-2FF, U+370-4FF, U+1E00-1EFF, U+2000-20CF, U+2100-23FF, U+2500-26FF, U+E000-F8FF, U+FB00–FB4F",description:"WGL4 character set (Pan-European)."},{name:"U+20-17F, U+2B0-2FF, U+2000-206F, U+20A0-20CF, U+2100-21FF, U+2600-26FF",description:"The Multilingual European Subset No. 1. Latin. Covers ~44 languages."},{name:"U+20-2FF, U+370-4FF, U+1E00-20CF, U+2100-23FF, U+2500-26FF, U+FB00-FB4F, U+FFF0-FFFD",description:"The Multilingual European Subset No. 2. Latin, Greek, and Cyrillic. Covers ~128 language."},{name:"U+20-4FF, U+530-58F, U+10D0-10FF, U+1E00-23FF, U+2440-245F, U+2500-26FF, U+FB00-FB4F, U+FE20-FE2F, U+FFF0-FFFD",description:"The Multilingual European Subset No. 3. Covers all characters belonging to European scripts."},{name:"U+00-7F",description:"Basic Latin (ASCII)."},{name:"U+80-FF",description:"Latin-1 Supplement. Accented characters for Western European languages, common punctuation characters, multiplication and division signs."},{name:"U+100-17F",description:"Latin Extended-A. Accented characters for for Czech, Dutch, Polish, and Turkish."},{name:"U+180-24F",description:"Latin Extended-B. Croatian, Slovenian, Romanian, Non-European and historic latin, Khoisan, Pinyin, Livonian, Sinology."},{name:"U+1E00-1EFF",description:"Latin Extended Additional. Vietnamese, German captial sharp s, Medievalist, Latin general use."},{name:"U+250-2AF",description:"International Phonetic Alphabet Extensions."},{name:"U+370-3FF",description:"Greek and Coptic."},{name:"U+1F00-1FFF",description:"Greek Extended. Accented characters for polytonic Greek."},{name:"U+400-4FF",description:"Cyrillic."},{name:"U+500-52F",description:"Cyrillic Supplement. Extra letters for Komi, Khanty, Chukchi, Mordvin, Kurdish, Aleut, Chuvash, Abkhaz, Azerbaijani, and Orok."},{name:"U+00-52F, U+1E00-1FFF, U+2200–22FF",description:"Latin, Greek, Cyrillic, some punctuation and symbols."},{name:"U+530–58F",description:"Armenian."},{name:"U+590–5FF",description:"Hebrew."},{name:"U+600–6FF",description:"Arabic."},{name:"U+750–77F",description:"Arabic Supplement. Additional letters for African languages, Khowar, Torwali, Burushaski, and early Persian."},{name:"U+8A0–8FF",description:"Arabic Extended-A. Additional letters for African languages, European and Central Asian languages, Rohingya, Tamazight, Arwi, and Koranic annotation signs."},{name:"U+700–74F",description:"Syriac."},{name:"U+900–97F",description:"Devanagari."},{name:"U+980–9FF",description:"Bengali."},{name:"U+A00–A7F",description:"Gurmukhi."},{name:"U+A80–AFF",description:"Gujarati."},{name:"U+B00–B7F",description:"Oriya."},{name:"U+B80–BFF",description:"Tamil."},{name:"U+C00–C7F",description:"Telugu."},{name:"U+C80–CFF",description:"Kannada."},{name:"U+D00–D7F",description:"Malayalam."},{name:"U+D80–DFF",description:"Sinhala."},{name:"U+118A0–118FF",description:"Warang Citi."},{name:"U+E00–E7F",description:"Thai."},{name:"U+1A20–1AAF",description:"Tai Tham."},{name:"U+AA80–AADF",description:"Tai Viet."},{name:"U+E80–EFF",description:"Lao."},{name:"U+F00–FFF",description:"Tibetan."},{name:"U+1000–109F",description:"Myanmar (Burmese)."},{name:"U+10A0–10FF",description:"Georgian."},{name:"U+1200–137F",description:"Ethiopic."},{name:"U+1380–139F",description:"Ethiopic Supplement. Extra Syllables for Sebatbeit, and Tonal marks"},{name:"U+2D80–2DDF",description:"Ethiopic Extended. Extra Syllables for Me'en, Blin, and Sebatbeit."},{name:"U+AB00–AB2F",description:"Ethiopic Extended-A. Extra characters for Gamo-Gofa-Dawro, Basketo, and Gumuz."},{name:"U+1780–17FF",description:"Khmer."},{name:"U+1800–18AF",description:"Mongolian."},{name:"U+1B80–1BBF",description:"Sundanese."},{name:"U+1CC0–1CCF",description:"Sundanese Supplement. Punctuation."},{name:"U+4E00–9FD5",description:"CJK (Chinese, Japanese, Korean) Unified Ideographs. Most common ideographs for modern Chinese and Japanese."},{name:"U+3400–4DB5",description:"CJK Unified Ideographs Extension A. Rare ideographs."},{name:"U+2F00–2FDF",description:"Kangxi Radicals."},{name:"U+2E80–2EFF",description:"CJK Radicals Supplement. Alternative forms of Kangxi Radicals."},{name:"U+1100–11FF",description:"Hangul Jamo."},{name:"U+AC00–D7AF",description:"Hangul Syllables."},{name:"U+3040–309F",description:"Hiragana."},{name:"U+30A0–30FF",description:"Katakana."},{name:"U+A5, U+4E00-9FFF, U+30??, U+FF00-FF9F",description:"Japanese Kanji, Hiragana and Katakana characters plus Yen/Yuan symbol."},{name:"U+A4D0–A4FF",description:"Lisu."},{name:"U+A000–A48F",description:"Yi Syllables."},{name:"U+A490–A4CF",description:"Yi Radicals."},{name:"U+2000-206F",description:"General Punctuation."},{name:"U+3000–303F",description:"CJK Symbols and Punctuation."},{name:"U+2070–209F",description:"Superscripts and Subscripts."},{name:"U+20A0–20CF",description:"Currency Symbols."},{name:"U+2100–214F",description:"Letterlike Symbols."},{name:"U+2150–218F",description:"Number Forms."},{name:"U+2190–21FF",description:"Arrows."},{name:"U+2200–22FF",description:"Mathematical Operators."},{name:"U+2300–23FF",description:"Miscellaneous Technical."},{name:"U+E000-F8FF",description:"Private Use Area."},{name:"U+FB00–FB4F",description:"Alphabetic Presentation Forms. Ligatures for latin, Armenian, and Hebrew."},{name:"U+FB50–FDFF",description:"Arabic Presentation Forms-A. Contextual forms / ligatures for Persian, Urdu, Sindhi, Central Asian languages, etc, Arabic pedagogical symbols, word ligatures."},{name:"U+1F600–1F64F",description:"Emoji: Emoticons."},{name:"U+2600–26FF",description:"Emoji: Miscellaneous Symbols."},{name:"U+1F300–1F5FF",description:"Emoji: Miscellaneous Symbols and Pictographs."},{name:"U+1F900–1F9FF",description:"Emoji: Supplemental Symbols and Pictographs."},{name:"U+1F680–1F6FF",description:"Emoji: Transport and Map Symbols."}],syntax:"<unicode-range>#",relevance:73,description:"@font-face descriptor. Defines the set of Unicode codepoints that may be supported by the font face for which it is declared.",restrictions:["unicode-range"]},{name:"user-select",values:[{name:"all",description:"The content of the element must be selected atomically"},{name:"auto"},{name:"contain",description:"UAs must not allow a selection which is started in this element to be extended outside of this element."},{name:"none",description:"The UA must not allow selections to be started in this element."},{name:"text",description:"The element imposes no constraint on the selection."}],syntax:"auto | text | none | contain | all",relevance:78,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/user-select"}],description:"Controls the appearance of selection.",restrictions:["enum"]},{name:"vertical-align",values:[{name:"auto",description:"Align the dominant baseline of the parent box with the equivalent, or heuristically reconstructed, baseline of the element inline box."},{name:"baseline",description:"Align the 'alphabetic' baseline of the element with the 'alphabetic' baseline of the parent element."},{name:"bottom",description:"Align the after edge of the extended inline box with the after-edge of the line box."},{name:"middle",description:"Align the 'middle' baseline of the inline element with the middle baseline of the parent."},{name:"sub",description:"Lower the baseline of the box to the proper position for subscripts of the parent's box. (This value has no effect on the font size of the element's text.)"},{name:"super",description:"Raise the baseline of the box to the proper position for superscripts of the parent's box. (This value has no effect on the font size of the element's text.)"},{name:"text-bottom",description:"Align the bottom of the box with the after-edge of the parent element's font."},{name:"text-top",description:"Align the top of the box with the before-edge of the parent element's font."},{name:"top",description:"Align the before edge of the extended inline box with the before-edge of the line box."},{name:"-webkit-baseline-middle"}],syntax:"baseline | sub | super | text-top | text-bottom | middle | top | bottom | <percentage> | <length>",relevance:92,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/vertical-align"}],description:"Affects the vertical positioning of the inline boxes generated by an inline-level element inside a line box.",restrictions:["percentage","length"]},{name:"visibility",values:[{name:"collapse",description:"Table-specific. If used on elements other than rows, row groups, columns, or column groups, 'collapse' has the same meaning as 'hidden'."},{name:"hidden",description:"The generated box is invisible (fully transparent, nothing is drawn), but still affects layout."},{name:"visible",description:"The generated box is visible."}],syntax:"visible | hidden | collapse",relevance:88,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/visibility"}],description:"Specifies whether the boxes generated by an element are rendered. Invisible boxes still affect layout (set the ‘display’ property to ‘none’ to suppress box generation altogether).",restrictions:["enum"]},{name:"-webkit-animation",browsers:["C","S5"],values:[{name:"alternate",description:"The animation cycle iterations that are odd counts are played in the normal direction, and the animation cycle iterations that are even counts are played in a reverse direction."},{name:"alternate-reverse",description:"The animation cycle iterations that are odd counts are played in the reverse direction, and the animation cycle iterations that are even counts are played in a normal direction."},{name:"backwards",description:"The beginning property value (as defined in the first @keyframes at-rule) is applied before the animation is displayed, during the period defined by 'animation-delay'."},{name:"both",description:"Both forwards and backwards fill modes are applied."},{name:"forwards",description:"The final property value (as defined in the last @keyframes at-rule) is maintained after the animation completes."},{name:"infinite",description:"Causes the animation to repeat forever."},{name:"none",description:"No animation is performed"},{name:"normal",description:"Normal playback."},{name:"reverse",description:"All iterations of the animation are played in the reverse direction from the way they were specified."}],relevance:50,description:"Shorthand property combines six of the animation properties into a single property.",restrictions:["time","enum","timing-function","identifier","number"]},{name:"-webkit-animation-delay",browsers:["C","S5"],relevance:50,description:"Defines when the animation will start.",restrictions:["time"]},{name:"-webkit-animation-direction",browsers:["C","S5"],values:[{name:"alternate",description:"The animation cycle iterations that are odd counts are played in the normal direction, and the animation cycle iterations that are even counts are played in a reverse direction."},{name:"alternate-reverse",description:"The animation cycle iterations that are odd counts are played in the reverse direction, and the animation cycle iterations that are even counts are played in a normal direction."},{name:"normal",description:"Normal playback."},{name:"reverse",description:"All iterations of the animation are played in the reverse direction from the way they were specified."}],relevance:50,description:"Defines whether or not the animation should play in reverse on alternate cycles.",restrictions:["enum"]},{name:"-webkit-animation-duration",browsers:["C","S5"],relevance:50,description:"Defines the length of time that an animation takes to complete one cycle.",restrictions:["time"]},{name:"-webkit-animation-fill-mode",browsers:["C","S5"],values:[{name:"backwards",description:"The beginning property value (as defined in the first @keyframes at-rule) is applied before the animation is displayed, during the period defined by 'animation-delay'."},{name:"both",description:"Both forwards and backwards fill modes are applied."},{name:"forwards",description:"The final property value (as defined in the last @keyframes at-rule) is maintained after the animation completes."},{name:"none",description:"There is no change to the property value between the time the animation is applied and the time the animation begins playing or after the animation completes."}],relevance:50,description:"Defines what values are applied by the animation outside the time it is executing.",restrictions:["enum"]},{name:"-webkit-animation-iteration-count",browsers:["C","S5"],values:[{name:"infinite",description:"Causes the animation to repeat forever."}],relevance:50,description:"Defines the number of times an animation cycle is played. The default value is one, meaning the animation will play from beginning to end once.",restrictions:["number","enum"]},{name:"-webkit-animation-name",browsers:["C","S5"],values:[{name:"none",description:"No animation is performed"}],relevance:50,description:"Defines a list of animations that apply. Each name is used to select the keyframe at-rule that provides the property values for the animation.",restrictions:["identifier","enum"]},{name:"-webkit-animation-play-state",browsers:["C","S5"],values:[{name:"paused",description:"A running animation will be paused."},{name:"running",description:"Resume playback of a paused animation."}],relevance:50,description:"Defines whether the animation is running or paused.",restrictions:["enum"]},{name:"-webkit-animation-timing-function",browsers:["C","S5"],relevance:50,description:"Describes how the animation will progress over one cycle of its duration. See the 'transition-timing-function'.",restrictions:["timing-function"]},{name:"-webkit-appearance",browsers:["C","S3"],values:[{name:"button"},{name:"button-bevel"},{name:"caps-lock-indicator"},{name:"caret"},{name:"checkbox"},{name:"default-button"},{name:"listbox"},{name:"listitem"},{name:"media-fullscreen-button"},{name:"media-mute-button"},{name:"media-play-button"},{name:"media-seek-back-button"},{name:"media-seek-forward-button"},{name:"media-slider"},{name:"media-sliderthumb"},{name:"menulist"},{name:"menulist-button"},{name:"menulist-text"},{name:"menulist-textfield"},{name:"none"},{name:"push-button"},{name:"radio"},{name:"scrollbarbutton-down"},{name:"scrollbarbutton-left"},{name:"scrollbarbutton-right"},{name:"scrollbarbutton-up"},{name:"scrollbargripper-horizontal"},{name:"scrollbargripper-vertical"},{name:"scrollbarthumb-horizontal"},{name:"scrollbarthumb-vertical"},{name:"scrollbartrack-horizontal"},{name:"scrollbartrack-vertical"},{name:"searchfield"},{name:"searchfield-cancel-button"},{name:"searchfield-decoration"},{name:"searchfield-results-button"},{name:"searchfield-results-decoration"},{name:"slider-horizontal"},{name:"sliderthumb-horizontal"},{name:"sliderthumb-vertical"},{name:"slider-vertical"},{name:"square-button"},{name:"textarea"},{name:"textfield"}],status:"nonstandard",syntax:"none | button | button-bevel | caret | checkbox | default-button | inner-spin-button | listbox | listitem | media-controls-background | media-controls-fullscreen-background | media-current-time-display | media-enter-fullscreen-button | media-exit-fullscreen-button | media-fullscreen-button | media-mute-button | media-overlay-play-button | media-play-button | media-seek-back-button | media-seek-forward-button | media-slider | media-sliderthumb | media-time-remaining-display | media-toggle-closed-captions-button | media-volume-slider | media-volume-slider-container | media-volume-sliderthumb | menulist | menulist-button | menulist-text | menulist-textfield | meter | progress-bar | progress-bar-value | push-button | radio | searchfield | searchfield-cancel-button | searchfield-decoration | searchfield-results-button | searchfield-results-decoration | slider-horizontal | slider-vertical | sliderthumb-horizontal | sliderthumb-vertical | square-button | textarea | textfield | -apple-pay-button",relevance:0,description:"Changes the appearance of buttons and other controls to resemble native controls.",restrictions:["enum"]},{name:"-webkit-backdrop-filter",browsers:["S9"],values:[{name:"none",description:"No filter effects are applied."},{name:"blur()",description:"Applies a Gaussian blur to the input image."},{name:"brightness()",description:"Applies a linear multiplier to input image, making it appear more or less bright."},{name:"contrast()",description:"Adjusts the contrast of the input."},{name:"drop-shadow()",description:"Applies a drop shadow effect to the input image."},{name:"grayscale()",description:"Converts the input image to grayscale."},{name:"hue-rotate()",description:"Applies a hue rotation on the input image. "},{name:"invert()",description:"Inverts the samples in the input image."},{name:"opacity()",description:"Applies transparency to the samples in the input image."},{name:"saturate()",description:"Saturates the input image."},{name:"sepia()",description:"Converts the input image to sepia."},{name:"url()",description:"A filter reference to a <filter> element."}],relevance:50,description:"Applies a filter effect where the first filter in the list takes the element's background image as the input image.",restrictions:["enum","url"]},{name:"-webkit-backface-visibility",browsers:["C","S5"],values:[{name:"hidden"},{name:"visible"}],relevance:50,description:"Determines whether or not the 'back' side of a transformed element is visible when facing the viewer. With an identity transform, the front side of an element faces the viewer.",restrictions:["enum"]},{name:"-webkit-background-clip",browsers:["C","S3"],relevance:50,description:"Determines the background painting area.",restrictions:["box"]},{name:"-webkit-background-composite",browsers:["C","S3"],values:[{name:"border"},{name:"padding"}],relevance:50,restrictions:["enum"]},{name:"-webkit-background-origin",browsers:["C","S3"],relevance:50,description:"For elements rendered as a single box, specifies the background positioning area. For elements rendered as multiple boxes (e.g., inline boxes on several lines, boxes on several pages) specifies which boxes 'box-decoration-break' operates on to determine the background positioning area(s).",restrictions:["box"]},{name:"-webkit-border-image",browsers:["C","S5"],values:[{name:"auto",description:"If 'auto' is specified then the border image width is the intrinsic width or height (whichever is applicable) of the corresponding image slice. If the image does not have the required intrinsic dimension then the corresponding border-width is used instead."},{name:"fill",description:"Causes the middle part of the border-image to be preserved."},{name:"none"},{name:"repeat",description:"The image is tiled (repeated) to fill the area."},{name:"round",description:"The image is tiled (repeated) to fill the area. If it does not fill the area with a whole number of tiles, the image is rescaled so that it does."},{name:"space",description:"The image is tiled (repeated) to fill the area. If it does not fill the area with a whole number of tiles, the extra space is distributed around the tiles."},{name:"stretch",description:"The image is stretched to fill the area."},{name:"url()"}],relevance:50,description:"Shorthand property for setting 'border-image-source', 'border-image-slice', 'border-image-width', 'border-image-outset' and 'border-image-repeat'. Omitted values are set to their initial values.",restrictions:["length","percentage","number","url","enum"]},{name:"-webkit-box-align",browsers:["C","S3"],values:[{name:"baseline",description:"If this box orientation is inline-axis or horizontal, all children are placed with their baselines aligned, and extra space placed before or after as necessary. For block flows, the baseline of the first non-empty line box located within the element is used. For tables, the baseline of the first cell is used."},{name:"center",description:"Any extra space is divided evenly, with half placed above the child and the other half placed after the child."},{name:"end",description:"For normal direction boxes, the bottom edge of each child is placed along the bottom of the box. Extra space is placed above the element. For reverse direction boxes, the top edge of each child is placed along the top of the box. Extra space is placed below the element."},{name:"start",description:"For normal direction boxes, the top edge of each child is placed along the top of the box. Extra space is placed below the element. For reverse direction boxes, the bottom edge of each child is placed along the bottom of the box. Extra space is placed above the element."},{name:"stretch",description:"The height of each child is adjusted to that of the containing block."}],relevance:50,description:"Specifies the alignment of nested elements within an outer flexible box element.",restrictions:["enum"]},{name:"-webkit-box-direction",browsers:["C","S3"],values:[{name:"normal",description:"A box with a computed value of horizontal for box-orient displays its children from left to right. A box with a computed value of vertical displays its children from top to bottom."},{name:"reverse",description:"A box with a computed value of horizontal for box-orient displays its children from right to left. A box with a computed value of vertical displays its children from bottom to top."}],relevance:50,description:"In webkit applications, -webkit-box-direction specifies whether a box lays out its contents normally (from the top or left edge), or in reverse (from the bottom or right edge).",restrictions:["enum"]},{name:"-webkit-box-flex",browsers:["C","S3"],relevance:50,description:"Specifies an element's flexibility.",restrictions:["number"]},{name:"-webkit-box-flex-group",browsers:["C","S3"],relevance:50,description:"Flexible elements can be assigned to flex groups using the 'box-flex-group' property.",restrictions:["integer"]},{name:"-webkit-box-ordinal-group",browsers:["C","S3"],relevance:50,description:"Indicates the ordinal group the element belongs to. Elements with a lower ordinal group are displayed before those with a higher ordinal group.",restrictions:["integer"]},{name:"-webkit-box-orient",browsers:["C","S3"],values:[{name:"block-axis",description:"Elements are oriented along the box's axis."},{name:"horizontal",description:"The box displays its children from left to right in a horizontal line."},{name:"inline-axis",description:"Elements are oriented vertically."},{name:"vertical",description:"The box displays its children from stacked from top to bottom vertically."}],relevance:50,description:"In webkit applications, -webkit-box-orient specifies whether a box lays out its contents horizontally or vertically.",restrictions:["enum"]},{name:"-webkit-box-pack",browsers:["C","S3"],values:[{name:"center",description:"The extra space is divided evenly, with half placed before the first child and the other half placed after the last child."},{name:"end",description:"For normal direction boxes, the right edge of the last child is placed at the right side, with all extra space placed before the first child. For reverse direction boxes, the left edge of the first child is placed at the left side, with all extra space placed after the last child."},{name:"justify",description:"The space is divided evenly in-between each child, with none of the extra space placed before the first child or after the last child. If there is only one child, treat the pack value as if it were start."},{name:"start",description:"For normal direction boxes, the left edge of the first child is placed at the left side, with all extra space placed after the last child. For reverse direction boxes, the right edge of the last child is placed at the right side, with all extra space placed before the first child."}],relevance:50,description:"Specifies alignment of child elements within the current element in the direction of orientation.",restrictions:["enum"]},{name:"-webkit-box-reflect",browsers:["E79","S4","C4","O15"],values:[{name:"above",description:"The reflection appears above the border box."},{name:"below",description:"The reflection appears below the border box."},{name:"left",description:"The reflection appears to the left of the border box."},{name:"right",description:"The reflection appears to the right of the border box."}],status:"nonstandard",syntax:"[ above | below | right | left ]? <length>? <image>?",relevance:0,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/-webkit-box-reflect"}],description:"Defines a reflection of a border box."},{name:"-webkit-box-sizing",browsers:["C","S3"],values:[{name:"border-box",description:"The specified width and height (and respective min/max properties) on this element determine the border box of the element."},{name:"content-box",description:"Behavior of width and height as specified by CSS2.1. The specified width and height (and respective min/max properties) apply to the width and height respectively of the content box of the element."}],relevance:50,description:"Box Model addition in CSS3.",restrictions:["enum"]},{name:"-webkit-break-after",browsers:["S7"],values:[{name:"always",description:"Always force a page break before/after the generated box."},{name:"auto",description:"Neither force nor forbid a page/column break before/after the generated box."},{name:"avoid",description:"Avoid a page/column break before/after the generated box."},{name:"avoid-column",description:"Avoid a column break before/after the generated box."},{name:"avoid-page",description:"Avoid a page break before/after the generated box."},{name:"avoid-region"},{name:"column",description:"Always force a column break before/after the generated box."},{name:"left",description:"Force one or two page breaks before/after the generated box so that the next page is formatted as a left page."},{name:"page",description:"Always force a page break before/after the generated box."},{name:"region"},{name:"right",description:"Force one or two page breaks before/after the generated box so that the next page is formatted as a right page."}],relevance:50,description:"Describes the page/column break behavior before the generated box.",restrictions:["enum"]},{name:"-webkit-break-before",browsers:["S7"],values:[{name:"always",description:"Always force a page break before/after the generated box."},{name:"auto",description:"Neither force nor forbid a page/column break before/after the generated box."},{name:"avoid",description:"Avoid a page/column break before/after the generated box."},{name:"avoid-column",description:"Avoid a column break before/after the generated box."},{name:"avoid-page",description:"Avoid a page break before/after the generated box."},{name:"avoid-region"},{name:"column",description:"Always force a column break before/after the generated box."},{name:"left",description:"Force one or two page breaks before/after the generated box so that the next page is formatted as a left page."},{name:"page",description:"Always force a page break before/after the generated box."},{name:"region"},{name:"right",description:"Force one or two page breaks before/after the generated box so that the next page is formatted as a right page."}],relevance:50,description:"Describes the page/column break behavior before the generated box.",restrictions:["enum"]},{name:"-webkit-break-inside",browsers:["S7"],values:[{name:"auto",description:"Neither force nor forbid a page/column break inside the generated box."},{name:"avoid",description:"Avoid a page/column break inside the generated box."},{name:"avoid-column",description:"Avoid a column break inside the generated box."},{name:"avoid-page",description:"Avoid a page break inside the generated box."},{name:"avoid-region"}],relevance:50,description:"Describes the page/column break behavior inside the generated box.",restrictions:["enum"]},{name:"-webkit-column-break-after",browsers:["C","S3"],values:[{name:"always",description:"Always force a page break before/after the generated box."},{name:"auto",description:"Neither force nor forbid a page/column break before/after the generated box."},{name:"avoid",description:"Avoid a page/column break before/after the generated box."},{name:"avoid-column",description:"Avoid a column break before/after the generated box."},{name:"avoid-page",description:"Avoid a page break before/after the generated box."},{name:"avoid-region"},{name:"column",description:"Always force a column break before/after the generated box."},{name:"left",description:"Force one or two page breaks before/after the generated box so that the next page is formatted as a left page."},{name:"page",description:"Always force a page break before/after the generated box."},{name:"region"},{name:"right",description:"Force one or two page breaks before/after the generated box so that the next page is formatted as a right page."}],relevance:50,description:"Describes the page/column break behavior before the generated box.",restrictions:["enum"]},{name:"-webkit-column-break-before",browsers:["C","S3"],values:[{name:"always",description:"Always force a page break before/after the generated box."},{name:"auto",description:"Neither force nor forbid a page/column break before/after the generated box."},{name:"avoid",description:"Avoid a page/column break before/after the generated box."},{name:"avoid-column",description:"Avoid a column break before/after the generated box."},{name:"avoid-page",description:"Avoid a page break before/after the generated box."},{name:"avoid-region"},{name:"column",description:"Always force a column break before/after the generated box."},{name:"left",description:"Force one or two page breaks before/after the generated box so that the next page is formatted as a left page."},{name:"page",description:"Always force a page break before/after the generated box."},{name:"region"},{name:"right",description:"Force one or two page breaks before/after the generated box so that the next page is formatted as a right page."}],relevance:50,description:"Describes the page/column break behavior before the generated box.",restrictions:["enum"]},{name:"-webkit-column-break-inside",browsers:["C","S3"],values:[{name:"auto",description:"Neither force nor forbid a page/column break inside the generated box."},{name:"avoid",description:"Avoid a page/column break inside the generated box."},{name:"avoid-column",description:"Avoid a column break inside the generated box."},{name:"avoid-page",description:"Avoid a page break inside the generated box."},{name:"avoid-region"}],relevance:50,description:"Describes the page/column break behavior inside the generated box.",restrictions:["enum"]},{name:"-webkit-column-count",browsers:["C","S3"],values:[{name:"auto",description:"Determines the number of columns by the 'column-width' property and the element width."}],relevance:50,description:"Describes the optimal number of columns into which the content of the element will be flowed.",restrictions:["integer"]},{name:"-webkit-column-gap",browsers:["C","S3"],values:[{name:"normal",description:"User agent specific and typically equivalent to 1em."}],relevance:50,description:"Sets the gap between columns. If there is a column rule between columns, it will appear in the middle of the gap.",restrictions:["length"]},{name:"-webkit-column-rule",browsers:["C","S3"],relevance:50,description:"This property is a shorthand for setting 'column-rule-width', 'column-rule-style', and 'column-rule-color' at the same place in the style sheet. Omitted values are set to their initial values.",restrictions:["length","line-width","line-style","color"]},{name:"-webkit-column-rule-color",browsers:["C","S3"],relevance:50,description:"Sets the color of the column rule",restrictions:["color"]},{name:"-webkit-column-rule-style",browsers:["C","S3"],relevance:50,description:"Sets the style of the rule between columns of an element.",restrictions:["line-style"]},{name:"-webkit-column-rule-width",browsers:["C","S3"],relevance:50,description:"Sets the width of the rule between columns. Negative values are not allowed.",restrictions:["length","line-width"]},{name:"-webkit-columns",browsers:["C","S3"],values:[{name:"auto",description:"The width depends on the values of other properties."}],relevance:50,description:"A shorthand property which sets both 'column-width' and 'column-count'.",restrictions:["length","integer"]},{name:"-webkit-column-span",browsers:["C","S3"],values:[{name:"all",description:"The element spans across all columns. Content in the normal flow that appears before the element is automatically balanced across all columns before the element appear."},{name:"none",description:"The element does not span multiple columns."}],relevance:50,description:"Describes the page/column break behavior after the generated box.",restrictions:["enum"]},{name:"-webkit-column-width",browsers:["C","S3"],values:[{name:"auto",description:"The width depends on the values of other properties."}],relevance:50,description:"This property describes the width of columns in multicol elements.",restrictions:["length"]},{name:"-webkit-filter",browsers:["C18","O15","S6"],values:[{name:"none",description:"No filter effects are applied."},{name:"blur()",description:"Applies a Gaussian blur to the input image."},{name:"brightness()",description:"Applies a linear multiplier to input image, making it appear more or less bright."},{name:"contrast()",description:"Adjusts the contrast of the input."},{name:"drop-shadow()",description:"Applies a drop shadow effect to the input image."},{name:"grayscale()",description:"Converts the input image to grayscale."},{name:"hue-rotate()",description:"Applies a hue rotation on the input image. "},{name:"invert()",description:"Inverts the samples in the input image."},{name:"opacity()",description:"Applies transparency to the samples in the input image."},{name:"saturate()",description:"Saturates the input image."},{name:"sepia()",description:"Converts the input image to sepia."},{name:"url()",description:"A filter reference to a <filter> element."}],relevance:50,description:"Processes an element’s rendering before it is displayed in the document, by applying one or more filter effects.",restrictions:["enum","url"]},{name:"-webkit-flow-from",browsers:["S6.1"],values:[{name:"none",description:"The block container is not a CSS Region."}],relevance:50,description:"Makes a block container a region and associates it with a named flow.",restrictions:["identifier"]},{name:"-webkit-flow-into",browsers:["S6.1"],values:[{name:"none",description:"The element is not moved to a named flow and normal CSS processing takes place."}],relevance:50,description:"Places an element or its contents into a named flow.",restrictions:["identifier"]},{name:"-webkit-font-feature-settings",browsers:["C16"],values:[{name:'"c2cs"'},{name:'"dlig"'},{name:'"kern"'},{name:'"liga"'},{name:'"lnum"'},{name:'"onum"'},{name:'"smcp"'},{name:'"swsh"'},{name:'"tnum"'},{name:"normal",description:"No change in glyph substitution or positioning occurs."},{name:"off"},{name:"on"}],relevance:50,description:"This property provides low-level control over OpenType font features. It is intended as a way of providing access to font features that are not widely used but are needed for a particular use case.",restrictions:["string","integer"]},{name:"-webkit-hyphens",browsers:["S5.1"],values:[{name:"auto",description:"Conditional hyphenation characters inside a word, if present, take priority over automatic resources when determining hyphenation points within the word."},{name:"manual",description:"Words are only broken at line breaks where there are characters inside the word that suggest line break opportunities"},{name:"none",description:"Words are not broken at line breaks, even if characters inside the word suggest line break points."}],relevance:50,description:"Controls whether hyphenation is allowed to create more break opportunities within a line of text.",restrictions:["enum"]},{name:"-webkit-line-break",browsers:["C","S3"],values:[{name:"after-white-space"},{name:"normal"}],relevance:50,description:"Specifies line-breaking rules for CJK (Chinese, Japanese, and Korean) text."},{name:"-webkit-margin-bottom-collapse",browsers:["C","S3"],values:[{name:"collapse"},{name:"discard"},{name:"separate"}],relevance:50,restrictions:["enum"]},{name:"-webkit-margin-collapse",browsers:["C","S3"],values:[{name:"collapse"},{name:"discard"},{name:"separate"}],relevance:50,restrictions:["enum"]},{name:"-webkit-margin-start",browsers:["C","S3"],values:[{name:"auto"}],relevance:50,restrictions:["percentage","length"]},{name:"-webkit-margin-top-collapse",browsers:["C","S3"],values:[{name:"collapse"},{name:"discard"},{name:"separate"}],relevance:50,restrictions:["enum"]},{name:"-webkit-mask-clip",browsers:["C","O15","S4"],status:"nonstandard",syntax:"[ <box> | border | padding | content | text ]#",relevance:0,description:"Determines the mask painting area, which determines the area that is affected by the mask.",restrictions:["box"]},{name:"-webkit-mask-image",browsers:["C","O15","S4"],values:[{name:"none",description:"Counts as a transparent black image layer."},{name:"url()",description:"Reference to a <mask element or to a CSS image."}],status:"nonstandard",syntax:"<mask-reference>#",relevance:0,description:"Sets the mask layer image of an element.",restrictions:["url","image","enum"]},{name:"-webkit-mask-origin",browsers:["C","O15","S4"],status:"nonstandard",syntax:"[ <box> | border | padding | content ]#",relevance:0,description:"Specifies the mask positioning area.",restrictions:["box"]},{name:"-webkit-mask-repeat",browsers:["C","O15","S4"],status:"nonstandard",syntax:"<repeat-style>#",relevance:0,description:"Specifies how mask layer images are tiled after they have been sized and positioned.",restrictions:["repeat"]},{name:"-webkit-mask-size",browsers:["C","O15","S4"],values:[{name:"auto",description:"Resolved by using the image’s intrinsic ratio and the size of the other dimension, or failing that, using the image’s intrinsic size, or failing that, treating it as 100%."},{name:"contain",description:"Scale the image, while preserving its intrinsic aspect ratio (if any), to the largest size such that both its width and its height can fit inside the background positioning area."},{name:"cover",description:"Scale the image, while preserving its intrinsic aspect ratio (if any), to the smallest size such that both its width and its height can completely cover the background positioning area."}],status:"nonstandard",syntax:"<bg-size>#",relevance:0,description:"Specifies the size of the mask layer images.",restrictions:["length","percentage","enum"]},{name:"-webkit-nbsp-mode",browsers:["C","S3"],values:[{name:"normal"},{name:"space"}],relevance:50,description:"Defines the behavior of nonbreaking spaces within text."},{name:"-webkit-overflow-scrolling",browsers:["C","S5"],values:[{name:"auto"},{name:"touch"}],status:"nonstandard",syntax:"auto | touch",relevance:0,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/-webkit-overflow-scrolling"}],description:"Specifies whether to use native-style scrolling in an overflow:scroll element."},{name:"-webkit-padding-start",browsers:["C","S3"],relevance:50,restrictions:["percentage","length"]},{name:"-webkit-perspective",browsers:["C","S4"],values:[{name:"none",description:"No perspective transform is applied."}],relevance:50,description:"Applies the same transform as the perspective(<number>) transform function, except that it applies only to the positioned or transformed children of the element, not to the transform on the element itself.",restrictions:["length"]},{name:"-webkit-perspective-origin",browsers:["C","S4"],relevance:50,description:"Establishes the origin for the perspective property. It effectively sets the X and Y position at which the viewer appears to be looking at the children of the element.",restrictions:["position","percentage","length"]},{name:"-webkit-region-fragment",browsers:["S7"],values:[{name:"auto",description:"Content flows as it would in a regular content box."},{name:"break",description:"If the content fits within the CSS Region, then this property has no effect."}],relevance:50,description:"The 'region-fragment' property controls the behavior of the last region associated with a named flow.",restrictions:["enum"]},{name:"-webkit-tap-highlight-color",browsers:["E12","C16","O15"],status:"nonstandard",syntax:"<color>",relevance:0,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/-webkit-tap-highlight-color"}],restrictions:["color"]},{name:"-webkit-text-fill-color",browsers:["E12","FF49","S3","C1","O15"],status:"nonstandard",syntax:"<color>",relevance:0,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/-webkit-text-fill-color"}],restrictions:["color"]},{name:"-webkit-text-size-adjust",browsers:["E","C","S3"],values:[{name:"auto",description:"Renderers must use the default size adjustment when displaying on a small device."},{name:"none",description:"Renderers must not do size adjustment when displaying on a small device."}],relevance:50,description:"Specifies a size adjustment for displaying text content in mobile browsers.",restrictions:["percentage"]},{name:"-webkit-text-stroke",browsers:["E15","FF49","S3","C4","O15"],status:"nonstandard",syntax:"<length> || <color>",relevance:0,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/-webkit-text-stroke"}],restrictions:["length","line-width","color","percentage"]},{name:"-webkit-text-stroke-color",browsers:["E15","FF49","S3","C1","O15"],status:"nonstandard",syntax:"<color>",relevance:0,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/-webkit-text-stroke-color"}],restrictions:["color"]},{name:"-webkit-text-stroke-width",browsers:["E15","FF49","S3","C1","O15"],status:"nonstandard",syntax:"<length>",relevance:0,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/-webkit-text-stroke-width"}],restrictions:["length","line-width","percentage"]},{name:"-webkit-touch-callout",browsers:["S3"],values:[{name:"none"}],status:"nonstandard",syntax:"default | none",relevance:0,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/-webkit-touch-callout"}],restrictions:["enum"]},{name:"-webkit-transform",browsers:["C","O12","S3.1"],values:[{name:"matrix()",description:"Specifies a 2D transformation in the form of a transformation matrix of six values. matrix(a,b,c,d,e,f) is equivalent to applying the transformation matrix [a b c d e f]"},{name:"matrix3d()",description:"Specifies a 3D transformation as a 4x4 homogeneous matrix of 16 values in column-major order."},{name:"none"},{name:"perspective()",description:"Specifies a perspective projection matrix."},{name:"rotate()",description:"Specifies a 2D rotation by the angle specified in the parameter about the origin of the element, as defined by the transform-origin property."},{name:"rotate3d()",description:"Specifies a clockwise 3D rotation by the angle specified in last parameter about the [x,y,z] direction vector described by the first 3 parameters."},{name:"rotateX('angle')",description:"Specifies a clockwise rotation by the given angle about the X axis."},{name:"rotateY('angle')",description:"Specifies a clockwise rotation by the given angle about the Y axis."},{name:"rotateZ('angle')",description:"Specifies a clockwise rotation by the given angle about the Z axis."},{name:"scale()",description:"Specifies a 2D scale operation by the [sx,sy] scaling vector described by the 2 parameters. If the second parameter is not provided, it is takes a value equal to the first."},{name:"scale3d()",description:"Specifies a 3D scale operation by the [sx,sy,sz] scaling vector described by the 3 parameters."},{name:"scaleX()",description:"Specifies a scale operation using the [sx,1] scaling vector, where sx is given as the parameter."},{name:"scaleY()",description:"Specifies a scale operation using the [sy,1] scaling vector, where sy is given as the parameter."},{name:"scaleZ()",description:"Specifies a scale operation using the [1,1,sz] scaling vector, where sz is given as the parameter."},{name:"skew()",description:"Specifies a skew transformation along the X and Y axes. The first angle parameter specifies the skew on the X axis. The second angle parameter specifies the skew on the Y axis. If the second parameter is not given then a value of 0 is used for the Y angle (ie: no skew on the Y axis)."},{name:"skewX()",description:"Specifies a skew transformation along the X axis by the given angle."},{name:"skewY()",description:"Specifies a skew transformation along the Y axis by the given angle."},{name:"translate()",description:"Specifies a 2D translation by the vector [tx, ty], where tx is the first translation-value parameter and ty is the optional second translation-value parameter."},{name:"translate3d()",description:"Specifies a 3D translation by the vector [tx,ty,tz], with tx, ty and tz being the first, second and third translation-value parameters respectively."},{name:"translateX()",description:"Specifies a translation by the given amount in the X direction."},{name:"translateY()",description:"Specifies a translation by the given amount in the Y direction."},{name:"translateZ()",description:"Specifies a translation by the given amount in the Z direction. Note that percentage values are not allowed in the translateZ translation-value, and if present are evaluated as 0."}],relevance:50,description:"A two-dimensional transformation is applied to an element through the 'transform' property. This property contains a list of transform functions similar to those allowed by SVG.",restrictions:["enum"]},{name:"-webkit-transform-origin",browsers:["C","O15","S3.1"],relevance:50,description:"Establishes the origin of transformation for an element.",restrictions:["position","length","percentage"]},{name:"-webkit-transform-origin-x",browsers:["C","S3.1"],relevance:50,description:"The x coordinate of the origin for transforms applied to an element with respect to its border box.",restrictions:["length","percentage"]},{name:"-webkit-transform-origin-y",browsers:["C","S3.1"],relevance:50,description:"The y coordinate of the origin for transforms applied to an element with respect to its border box.",restrictions:["length","percentage"]},{name:"-webkit-transform-origin-z",browsers:["C","S4"],relevance:50,description:"The z coordinate of the origin for transforms applied to an element with respect to its border box.",restrictions:["length","percentage"]},{name:"-webkit-transform-style",browsers:["C","S4"],values:[{name:"flat",description:"All children of this element are rendered flattened into the 2D plane of the element."}],relevance:50,description:"Defines how nested elements are rendered in 3D space.",restrictions:["enum"]},{name:"-webkit-transition",browsers:["C","O12","S5"],values:[{name:"all",description:"Every property that is able to undergo a transition will do so."},{name:"none",description:"No property will transition."}],relevance:50,description:"Shorthand property combines four of the transition properties into a single property.",restrictions:["time","property","timing-function","enum"]},{name:"-webkit-transition-delay",browsers:["C","O12","S5"],relevance:50,description:"Defines when the transition will start. It allows a transition to begin execution some period of time from when it is applied.",restrictions:["time"]},{name:"-webkit-transition-duration",browsers:["C","O12","S5"],relevance:50,description:"Specifies how long the transition from the old value to the new value should take.",restrictions:["time"]},{name:"-webkit-transition-property",browsers:["C","O12","S5"],values:[{name:"all",description:"Every property that is able to undergo a transition will do so."},{name:"none",description:"No property will transition."}],relevance:50,description:"Specifies the name of the CSS property to which the transition is applied.",restrictions:["property"]},{name:"-webkit-transition-timing-function",browsers:["C","O12","S5"],relevance:50,description:"Describes how the intermediate values used during a transition will be calculated.",restrictions:["timing-function"]},{name:"-webkit-user-drag",browsers:["S3"],values:[{name:"auto"},{name:"element"},{name:"none"}],relevance:50,restrictions:["enum"]},{name:"-webkit-user-modify",browsers:["C","S3"],values:[{name:"read-only"},{name:"read-write"},{name:"read-write-plaintext-only"}],status:"nonstandard",syntax:"read-only | read-write | read-write-plaintext-only",relevance:0,description:"Determines whether a user can edit the content of an element.",restrictions:["enum"]},{name:"-webkit-user-select",browsers:["C","S3"],values:[{name:"auto"},{name:"none"},{name:"text"}],relevance:50,description:"Controls the appearance of selection.",restrictions:["enum"]},{name:"white-space",values:[{name:"normal",description:"Sets 'white-space-collapsing' to 'collapse' and 'text-wrap' to 'normal'."},{name:"nowrap",description:"Sets 'white-space-collapsing' to 'collapse' and 'text-wrap' to 'none'."},{name:"pre",description:"Sets 'white-space-collapsing' to 'preserve' and 'text-wrap' to 'none'."},{name:"pre-line",description:"Sets 'white-space-collapsing' to 'preserve-breaks' and 'text-wrap' to 'normal'."},{name:"pre-wrap",description:"Sets 'white-space-collapsing' to 'preserve' and 'text-wrap' to 'normal'."}],syntax:"normal | pre | nowrap | pre-wrap | pre-line | break-spaces",relevance:90,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/white-space"}],description:"Shorthand property for the 'white-space-collapsing' and 'text-wrap' properties.",restrictions:["enum"]},{name:"widows",browsers:["E12","S1.3","C25","IE8","O9.2"],syntax:"<integer>",relevance:51,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/widows"}],description:"Specifies the minimum number of line boxes of a block container that must be left in a fragment after a break.",restrictions:["integer"]},{name:"width",values:[{name:"auto",description:"The width depends on the values of other properties."},{name:"fit-content",description:"Use the fit-content inline size or fit-content block size, as appropriate to the writing mode."},{name:"max-content",description:"Use the max-content inline size or max-content block size, as appropriate to the writing mode."},{name:"min-content",description:"Use the min-content inline size or min-content block size, as appropriate to the writing mode."}],syntax:"<viewport-length>{1,2}",relevance:96,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/width"}],description:"Specifies the width of the content area, padding area or border area (depending on 'box-sizing') of certain boxes.",restrictions:["length","percentage"]},{name:"will-change",browsers:["E79","FF36","S9.1","C36","O24"],values:[{name:"auto",description:"Expresses no particular intent."},{name:"contents",description:"Indicates that the author expects to animate or change something about the element’s contents in the near future."},{name:"scroll-position",description:"Indicates that the author expects to animate or change the scroll position of the element in the near future."}],syntax:"auto | <animateable-feature>#",relevance:64,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/will-change"}],description:"Provides a rendering hint to the user agent, stating what kinds of changes the author expects to perform on the element.",restrictions:["enum","identifier"]},{name:"word-break",values:[{name:"break-all",description:"Lines may break between any two grapheme clusters for non-CJK scripts."},{name:"keep-all",description:"Block characters can no longer create implied break points."},{name:"normal",description:"Breaks non-CJK scripts according to their own rules."}],syntax:"normal | break-all | keep-all | break-word",relevance:75,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/word-break"}],description:"Specifies line break opportunities for non-CJK scripts.",restrictions:["enum"]},{name:"word-spacing",values:[{name:"normal",description:"No additional spacing is applied. Computes to zero."}],syntax:"normal | <length>",relevance:57,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/word-spacing"}],description:"Specifies additional spacing between “words”.",restrictions:["length","percentage"]},{name:"word-wrap",values:[{name:"break-word",description:"An otherwise unbreakable sequence of characters may be broken at an arbitrary point if there are no otherwise-acceptable break points in the line."},{name:"normal",description:"Lines may break only at allowed break points."}],syntax:"normal | break-word",relevance:78,description:"Specifies whether the UA may break within a word to prevent overflow when an otherwise-unbreakable string is too long to fit.",restrictions:["enum"]},{name:"writing-mode",values:[{name:"horizontal-tb",description:"Top-to-bottom block flow direction. The writing mode is horizontal."},{name:"sideways-lr",description:"Left-to-right block flow direction. The writing mode is vertical, while the typographic mode is horizontal."},{name:"sideways-rl",description:"Right-to-left block flow direction. The writing mode is vertical, while the typographic mode is horizontal."},{name:"vertical-lr",description:"Left-to-right block flow direction. The writing mode is vertical."},{name:"vertical-rl",description:"Right-to-left block flow direction. The writing mode is vertical."}],syntax:"horizontal-tb | vertical-rl | vertical-lr | sideways-rl | sideways-lr",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/writing-mode"}],description:"This is a shorthand property for both 'direction' and 'block-progression'.",restrictions:["enum"]},{name:"z-index",values:[{name:"auto",description:"The stack level of the generated box in the current stacking context is 0. The box does not establish a new stacking context unless it is the root element."}],syntax:"auto | <integer>",relevance:92,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/z-index"}],description:"For a positioned box, the 'z-index' property specifies the stack level of the box in the current stacking context and whether the box establishes a local stacking context.",restrictions:["integer"]},{name:"zoom",browsers:["E12","S3.1","C1","IE5.5","O15"],values:[{name:"normal"}],syntax:"auto | <number> | <percentage>",relevance:68,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/zoom"}],description:"Non-standard. Specifies the magnification scale of the object. See 'transform: scale()' for a standards-based alternative.",restrictions:["enum","integer","number","percentage"]},{name:"-ms-ime-align",status:"nonstandard",syntax:"auto | after",relevance:0,description:"Aligns the Input Method Editor (IME) candidate window box relative to the element on which the IME composition is active."},{name:"-moz-binding",status:"nonstandard",syntax:"<url> | none",relevance:0,browsers:["FF1"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/-moz-binding"}],description:"The -moz-binding CSS property is used by Mozilla-based applications to attach an XBL binding to a DOM element."},{name:"-moz-context-properties",status:"nonstandard",syntax:"none | [ fill | fill-opacity | stroke | stroke-opacity ]#",relevance:0,browsers:["FF55"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/-moz-context-properties"}],description:"If you reference an SVG image in a webpage (such as with the <img> element or as a background image), the SVG image can coordinate with the embedding element (its context) to have the image adopt property values set on the embedding element. To do this the embedding element needs to list the properties that are to be made available to the image by listing them as values of the -moz-context-properties property, and the image needs to opt in to using those properties by using values such as the context-fill value.\n\nThis feature is available since Firefox 55, but is only currently supported with SVG images loaded via chrome:// or resource:// URLs. To experiment with the feature in SVG on the Web it is necessary to set the svg.context-properties.content.enabled pref to true."},{name:"-moz-float-edge",status:"nonstandard",syntax:"border-box | content-box | margin-box | padding-box",relevance:0,browsers:["FF1"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/-moz-float-edge"}],description:"The non-standard -moz-float-edge CSS property specifies whether the height and width properties of the element include the margin, border, or padding thickness."},{name:"-moz-force-broken-image-icon",status:"nonstandard",syntax:"0 | 1",relevance:0,browsers:["FF1"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/-moz-force-broken-image-icon"}],description:"The -moz-force-broken-image-icon extended CSS property can be used to force the broken image icon to be shown even when a broken image has an alt attribute."},{name:"-moz-image-region",status:"nonstandard",syntax:"<shape> | auto",relevance:0,browsers:["FF1"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/-moz-image-region"}],description:"For certain XUL elements and pseudo-elements that use an image from the list-style-image property, this property specifies a region of the image that is used in place of the whole image. This allows elements to use different pieces of the same image to improve performance."},{name:"-moz-orient",status:"nonstandard",syntax:"inline | block | horizontal | vertical",relevance:0,browsers:["FF6"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/-moz-orient"}],description:"The -moz-orient CSS property specifies the orientation of the element to which it's applied."},{name:"-moz-outline-radius",status:"nonstandard",syntax:"<outline-radius>{1,4} [ / <outline-radius>{1,4} ]?",relevance:0,browsers:["FF1"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/-moz-outline-radius"}],description:"In Mozilla applications like Firefox, the -moz-outline-radius CSS property can be used to give an element's outline rounded corners."},{name:"-moz-outline-radius-bottomleft",status:"nonstandard",syntax:"<outline-radius>",relevance:0,browsers:["FF1"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/-moz-outline-radius-bottomleft"}],description:"In Mozilla applications, the -moz-outline-radius-bottomleft CSS property can be used to round the bottom-left corner of an element's outline."},{name:"-moz-outline-radius-bottomright",status:"nonstandard",syntax:"<outline-radius>",relevance:0,browsers:["FF1"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/-moz-outline-radius-bottomright"}],description:"In Mozilla applications, the -moz-outline-radius-bottomright CSS property can be used to round the bottom-right corner of an element's outline."},{name:"-moz-outline-radius-topleft",status:"nonstandard",syntax:"<outline-radius>",relevance:0,browsers:["FF1"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/-moz-outline-radius-topleft"}],description:"In Mozilla applications, the -moz-outline-radius-topleft CSS property can be used to round the top-left corner of an element's outline."},{name:"-moz-outline-radius-topright",status:"nonstandard",syntax:"<outline-radius>",relevance:0,browsers:["FF1"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/-moz-outline-radius-topright"}],description:"In Mozilla applications, the -moz-outline-radius-topright CSS property can be used to round the top-right corner of an element's outline."},{name:"-moz-stack-sizing",status:"nonstandard",syntax:"ignore | stretch-to-fit",relevance:0,description:"-moz-stack-sizing is an extended CSS property. Normally, a stack will change its size so that all of its child elements are completely visible. For example, moving a child of the stack far to the right will widen the stack so the child remains visible."},{name:"-moz-text-blink",status:"nonstandard",syntax:"none | blink",relevance:0,description:"The -moz-text-blink non-standard Mozilla CSS extension specifies the blink mode."},{name:"-moz-user-input",status:"nonstandard",syntax:"auto | none | enabled | disabled",relevance:0,browsers:["FF1"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/-moz-user-input"}],description:"In Mozilla applications, -moz-user-input determines if an element will accept user input."},{name:"-moz-user-modify",status:"nonstandard",syntax:"read-only | read-write | write-only",relevance:0,description:"The -moz-user-modify property has no effect. It was originally planned to determine whether or not the content of an element can be edited by a user."},{name:"-moz-window-dragging",status:"nonstandard",syntax:"drag | no-drag",relevance:0,description:"The -moz-window-dragging CSS property specifies whether a window is draggable or not. It only works in Chrome code, and only on Mac OS X."},{name:"-moz-window-shadow",status:"nonstandard",syntax:"default | menu | tooltip | sheet | none",relevance:0,description:"The -moz-window-shadow CSS property specifies whether a window will have a shadow. It only works on Mac OS X."},{name:"-webkit-border-before",status:"nonstandard",syntax:"<'border-width'> || <'border-style'> || <color>",relevance:0,browsers:["E79","S5.1","C8","O15"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/-webkit-border-before"}],description:"The -webkit-border-before CSS property is a shorthand property for setting the individual logical block start border property values in a single place in the style sheet."},{name:"-webkit-border-before-color",status:"nonstandard",syntax:"<color>",relevance:0,description:"The -webkit-border-before-color CSS property sets the color of the individual logical block start border in a single place in the style sheet."},{name:"-webkit-border-before-style",status:"nonstandard",syntax:"<'border-style'>",relevance:0,description:"The -webkit-border-before-style CSS property sets the style of the individual logical block start border in a single place in the style sheet."},{name:"-webkit-border-before-width",status:"nonstandard",syntax:"<'border-width'>",relevance:0,description:"The -webkit-border-before-width CSS property sets the width of the individual logical block start border in a single place in the style sheet."},{name:"-webkit-line-clamp",syntax:"none | <integer>",relevance:50,browsers:["E17","FF68","S5","C6","O15"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/-webkit-line-clamp"}],description:"The -webkit-line-clamp CSS property allows limiting of the contents of a block container to the specified number of lines."},{name:"-webkit-mask",status:"nonstandard",syntax:"[ <mask-reference> || <position> [ / <bg-size> ]? || <repeat-style> || [ <box> | border | padding | content | text ] || [ <box> | border | padding | content ] ]#",relevance:0,description:"The mask CSS property alters the visibility of an element by either partially or fully hiding it. This is accomplished by either masking or clipping the image at specific points."},{name:"-webkit-mask-attachment",status:"nonstandard",syntax:"<attachment>#",relevance:0,browsers:["S4","C1"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/-webkit-mask-attachment"}],description:"If a -webkit-mask-image is specified, -webkit-mask-attachment determines whether the mask image's position is fixed within the viewport, or scrolls along with its containing block."},{name:"-webkit-mask-composite",status:"nonstandard",syntax:"<composite-style>#",relevance:0,browsers:["E18","FF53","S3.1","C1","O15"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/-webkit-mask-composite"}],description:"The -webkit-mask-composite property specifies the manner in which multiple mask images applied to the same element are composited with one another. Mask images are composited in the opposite order that they are declared with the -webkit-mask-image property."},{name:"-webkit-mask-position",status:"nonstandard",syntax:"<position>#",relevance:0,description:"The mask-position CSS property sets the initial position, relative to the mask position layer defined by mask-origin, for each defined mask image."},{name:"-webkit-mask-position-x",status:"nonstandard",syntax:"[ <length-percentage> | left | center | right ]#",relevance:0,browsers:["E18","FF49","S3.1","C1","O15"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/-webkit-mask-position-x"}],description:"The -webkit-mask-position-x CSS property sets the initial horizontal position of a mask image."},{name:"-webkit-mask-position-y",status:"nonstandard",syntax:"[ <length-percentage> | top | center | bottom ]#",relevance:0,browsers:["E18","FF49","S3.1","C1","O15"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/-webkit-mask-position-y"}],description:"The -webkit-mask-position-y CSS property sets the initial vertical position of a mask image."},{name:"-webkit-mask-repeat-x",status:"nonstandard",syntax:"repeat | no-repeat | space | round",relevance:0,browsers:["E18","S5","C3","O15"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/-webkit-mask-repeat-x"}],description:"The -webkit-mask-repeat-x property specifies whether and how a mask image is repeated (tiled) horizontally."},{name:"-webkit-mask-repeat-y",status:"nonstandard",syntax:"repeat | no-repeat | space | round",relevance:0,browsers:["E18","S5","C3","O15"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/-webkit-mask-repeat-y"}],description:"The -webkit-mask-repeat-y property specifies whether and how a mask image is repeated (tiled) vertically."},{name:"accent-color",syntax:"auto | <color>",relevance:50,browsers:["E93","FF92","Spreview","C93","O79"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/accent-color"}],description:"Sets the color of the elements accent"},{name:"align-tracks",status:"experimental",syntax:"[ normal | <baseline-position> | <content-distribution> | <overflow-position>? <content-position> ]#",relevance:50,browsers:["FF77"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/align-tracks"}],description:"The align-tracks CSS property sets the alignment in the masonry axis for grid containers that have masonry in their block axis."},{name:"appearance",status:"experimental",syntax:"none | auto | textfield | menulist-button | <compat-auto>",relevance:62,browsers:["E84","FF80","Spreview","C84","O70"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/appearance"}],description:"Changes the appearance of buttons and other controls to resemble native controls."},{name:"aspect-ratio",status:"experimental",syntax:"auto | <ratio>",relevance:53,browsers:["E88","FF89","S15","C88","O74"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/aspect-ratio"}],description:"The aspect-ratio   CSS property sets a preferred aspect ratio for the box, which will be used in the calculation of auto sizes and some other layout functions."},{name:"azimuth",status:"obsolete",syntax:"<angle> | [ [ left-side | far-left | left | center-left | center | center-right | right | far-right | right-side ] || behind ] | leftwards | rightwards",relevance:0,description:"In combination with elevation, the azimuth CSS property enables different audio sources to be positioned spatially for aural presentation. This is important in that it provides a natural way to tell several voices apart, as each can be positioned to originate at a different location on the sound stage. Stereo output produce a lateral sound stage, while binaural headphones and multi-speaker setups allow for a fully three-dimensional stage."},{name:"backdrop-filter",syntax:"none | <filter-function-list>",relevance:53,browsers:["E17","FF70","S9","C76","O63"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/backdrop-filter"}],description:"The backdrop-filter CSS property lets you apply graphical effects such as blurring or color shifting to the area behind an element. Because it applies to everything behind the element, to see the effect you must make the element or its background at least partially transparent."},{name:"border-block",syntax:"<'border-top-width'> || <'border-top-style'> || <color>",relevance:50,browsers:["E87","FF66","S14.1","C87","O73"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/border-block"}],description:"The border-block CSS property is a shorthand property for setting the individual logical block border property values in a single place in the style sheet."},{name:"border-block-color",syntax:"<'border-top-color'>{1,2}",relevance:50,browsers:["E87","FF66","S14.1","C87","O73"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/border-block-color"}],description:"The border-block-color CSS property defines the color of the logical block borders of an element, which maps to a physical border color depending on the element's writing mode, directionality, and text orientation. It corresponds to the border-top-color and border-bottom-color, or border-right-color and border-left-color property depending on the values defined for writing-mode, direction, and text-orientation."},{name:"border-block-style",syntax:"<'border-top-style'>",relevance:50,browsers:["E87","FF66","S14.1","C87","O73"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/border-block-style"}],description:"The border-block-style CSS property defines the style of the logical block borders of an element, which maps to a physical border style depending on the element's writing mode, directionality, and text orientation. It corresponds to the border-top-style and border-bottom-style, or border-left-style and border-right-style properties depending on the values defined for writing-mode, direction, and text-orientation."},{name:"border-block-width",syntax:"<'border-top-width'>",relevance:50,browsers:["E87","FF66","S14.1","C87","O73"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/border-block-width"}],description:"The border-block-width CSS property defines the width of the logical block borders of an element, which maps to a physical border width depending on the element's writing mode, directionality, and text orientation. It corresponds to the border-top-width and border-bottom-width, or border-left-width, and border-right-width property depending on the values defined for writing-mode, direction, and text-orientation."},{name:"border-end-end-radius",syntax:"<length-percentage>{1,2}",relevance:50,browsers:["E89","FF66","S15","C89","O75"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/border-end-end-radius"}],description:"The border-end-end-radius CSS property defines a logical border radius on an element, which maps to a physical border radius that depends on on the element's writing-mode, direction, and text-orientation."},{name:"border-end-start-radius",syntax:"<length-percentage>{1,2}",relevance:50,browsers:["E89","FF66","S15","C89","O75"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/border-end-start-radius"}],description:"The border-end-start-radius CSS property defines a logical border radius on an element, which maps to a physical border radius depending on the element's writing-mode, direction, and text-orientation."},{name:"border-inline",syntax:"<'border-top-width'> || <'border-top-style'> || <color>",relevance:50,browsers:["E87","FF66","S14.1","C87","O73"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/border-inline"}],description:"The border-inline CSS property is a shorthand property for setting the individual logical inline border property values in a single place in the style sheet."},{name:"border-inline-color",syntax:"<'border-top-color'>{1,2}",relevance:50,browsers:["E87","FF66","S14.1","C87","O73"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/border-inline-color"}],description:"The border-inline-color CSS property defines the color of the logical inline borders of an element, which maps to a physical border color depending on the element's writing mode, directionality, and text orientation. It corresponds to the border-top-color and border-bottom-color, or border-right-color and border-left-color property depending on the values defined for writing-mode, direction, and text-orientation."},{name:"border-inline-style",syntax:"<'border-top-style'>",relevance:50,browsers:["E87","FF66","S14.1","C87","O73"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/border-inline-style"}],description:"The border-inline-style CSS property defines the style of the logical inline borders of an element, which maps to a physical border style depending on the element's writing mode, directionality, and text orientation. It corresponds to the border-top-style and border-bottom-style, or border-left-style and border-right-style properties depending on the values defined for writing-mode, direction, and text-orientation."},{name:"border-inline-width",syntax:"<'border-top-width'>",relevance:50,browsers:["E87","FF66","S14.1","C87","O73"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/border-inline-width"}],description:"The border-inline-width CSS property defines the width of the logical inline borders of an element, which maps to a physical border width depending on the element's writing mode, directionality, and text orientation. It corresponds to the border-top-width and border-bottom-width, or border-left-width, and border-right-width property depending on the values defined for writing-mode, direction, and text-orientation."},{name:"border-start-end-radius",syntax:"<length-percentage>{1,2}",relevance:50,browsers:["E89","FF66","S15","C89","O75"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/border-start-end-radius"}],description:"The border-start-end-radius CSS property defines a logical border radius on an element, which maps to a physical border radius depending on the element's writing-mode, direction, and text-orientation."},{name:"border-start-start-radius",syntax:"<length-percentage>{1,2}",relevance:50,browsers:["E89","FF66","S15","C89","O75"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/border-start-start-radius"}],description:"The border-start-start-radius CSS property defines a logical border radius on an element, which maps to a physical border radius that depends on the element's writing-mode, direction, and text-orientation."},{name:"box-align",status:"nonstandard",syntax:"start | center | end | baseline | stretch",relevance:0,browsers:["E12","FF1","S3","C1","O15"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/box-align"}],description:"The box-align CSS property specifies how an element aligns its contents across its layout in a perpendicular direction. The effect of the property is only visible if there is extra space in the box."},{name:"box-direction",status:"nonstandard",syntax:"normal | reverse | inherit",relevance:0,browsers:["E12","FF1","S3","C1","O15"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/box-direction"}],description:"The box-direction CSS property specifies whether a box lays out its contents normally (from the top or left edge), or in reverse (from the bottom or right edge)."},{name:"box-flex",status:"nonstandard",syntax:"<number>",relevance:0,browsers:["E12","FF1","S3","C1","O15"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/box-flex"}],description:"The -moz-box-flex and -webkit-box-flex CSS properties specify how a -moz-box or -webkit-box grows to fill the box that contains it, in the direction of the containing box's layout."},{name:"box-flex-group",status:"nonstandard",syntax:"<integer>",relevance:0,browsers:["S3","C1","O15"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/box-flex-group"}],description:"The box-flex-group CSS property assigns the flexbox's child elements to a flex group."},{name:"box-lines",status:"nonstandard",syntax:"single | multiple",relevance:0,browsers:["S3","C1","O15"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/box-lines"}],description:"The box-lines CSS property determines whether the box may have a single or multiple lines (rows for horizontally oriented boxes, columns for vertically oriented boxes)."},{name:"box-ordinal-group",status:"nonstandard",syntax:"<integer>",relevance:0,browsers:["E12","FF1","S3","C1","O15"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/box-ordinal-group"}],description:"The box-ordinal-group CSS property assigns the flexbox's child elements to an ordinal group."},{name:"box-orient",status:"nonstandard",syntax:"horizontal | vertical | inline-axis | block-axis | inherit",relevance:0,browsers:["E12","FF1","S3","C1","O15"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/box-orient"}],description:"The box-orient CSS property specifies whether an element lays out its contents horizontally or vertically."},{name:"box-pack",status:"nonstandard",syntax:"start | center | end | justify",relevance:0,browsers:["E12","FF1","S3","C1","O15"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/box-pack"}],description:"The -moz-box-pack and -webkit-box-pack CSS properties specify how a -moz-box or -webkit-box packs its contents in the direction of its layout. The effect of this is only visible if there is extra space in the box."},{name:"color-adjust",syntax:"economy | exact",relevance:50,browsers:["E79","FF48","S6","C49","O15"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/color-adjust"}],description:"The color-adjust property is a non-standard CSS extension that can be used to force printing of background colors and images in browsers based on the WebKit engine."},{name:"color-scheme",syntax:"normal | [ light | dark | <custom-ident> ]+ && only?",relevance:51,browsers:["E81","FF96","S13","C81","O68"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/color-scheme"}],description:"The color-scheme CSS property allows an element to indicate which color schemes it can comfortably be rendered in."},{name:"content-visibility",syntax:"visible | auto | hidden",relevance:52,browsers:["E85","C85","O71"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/content-visibility"}],description:"Controls whether or not an element renders its contents at all, along with forcing a strong set of containments, allowing user agents to potentially omit large swathes of layout and rendering work until it becomes needed."},{name:"counter-set",syntax:"[ <counter-name> <integer>? ]+ | none",relevance:50,browsers:["E85","FF68","C85","O71"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/counter-set"}],description:"The counter-set CSS property sets a CSS counter to a given value. It manipulates the value of existing counters, and will only create new counters if there isn't already a counter of the given name on the element."},{name:"font-optical-sizing",syntax:"auto | none",relevance:50,browsers:["E17","FF62","S11","C79","O66"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/font-optical-sizing"}],description:"The font-optical-sizing CSS property allows developers to control whether browsers render text with slightly differing visual representations to optimize viewing at different sizes, or not. This only works for fonts that have an optical size variation axis."},{name:"font-variation-settings",syntax:"normal | [ <string> <number> ]#",relevance:50,browsers:["E17","FF62","S11","C62","O49"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/font-variation-settings"}],description:"The font-variation-settings CSS property provides low-level control over OpenType or TrueType font variations, by specifying the four letter axis names of the features you want to vary, along with their variation values."},{name:"font-smooth",status:"nonstandard",syntax:"auto | never | always | <absolute-size> | <length>",relevance:0,browsers:["E79","FF25","S4","C5","O15"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/font-smooth"}],description:"The font-smooth CSS property controls the application of anti-aliasing when fonts are rendered."},{name:"forced-color-adjust",status:"experimental",syntax:"auto | none",relevance:51,browsers:["E79","C89","IE10"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/forced-color-adjust"}],description:"Allows authors to opt certain elements out of forced colors mode. This then restores the control of those values to CSS"},{name:"gap",syntax:"<'row-gap'> <'column-gap'>?",relevance:53,browsers:["E84","FF63","S14.1","C84","O70"],description:"The gap CSS property is a shorthand property for row-gap and column-gap specifying the gutters between grid rows and columns."},{name:"hanging-punctuation",syntax:"none | [ first || [ force-end | allow-end ] || last ]",relevance:50,browsers:["S10"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/hanging-punctuation"}],description:"The hanging-punctuation CSS property specifies whether a punctuation mark should hang at the start or end of a line of text. Hanging punctuation may be placed outside the line box."},{name:"hyphenate-character",syntax:"auto | <string>",relevance:50,description:"A hyphenate character used at the end of a line."},{name:"image-resolution",status:"experimental",syntax:"[ from-image || <resolution> ] && snap?",relevance:50,description:"The image-resolution property specifies the intrinsic resolution of all raster images used in or on the element. It affects both content images (e.g. replaced elements and generated content) and decorative images (such as background-image). The intrinsic resolution of an image is used to determine the image’s intrinsic dimensions."},{name:"initial-letter",status:"experimental",syntax:"normal | [ <number> <integer>? ]",relevance:50,browsers:["S9"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/initial-letter"}],description:"The initial-letter CSS property specifies styling for dropped, raised, and sunken initial letters."},{name:"initial-letter-align",status:"experimental",syntax:"[ auto | alphabetic | hanging | ideographic ]",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/initial-letter-align"}],description:"The initial-letter-align CSS property specifies the alignment of initial letters within a paragraph."},{name:"input-security",syntax:"auto | none",relevance:50,description:"Enables or disables the obscuring a sensitive test input."},{name:"inset",syntax:"<'top'>{1,4}",relevance:51,browsers:["E87","FF66","S14.1","C87","O73"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/inset"}],description:"The inset CSS property defines the logical block and inline start and end offsets of an element, which map to physical offsets depending on the element's writing mode, directionality, and text orientation. It corresponds to the top and bottom, or right and left properties depending on the values defined for writing-mode, direction, and text-orientation."},{name:"inset-block",syntax:"<'top'>{1,2}",relevance:50,browsers:["E87","FF63","S14.1","C87","O73"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/inset-block"}],description:"The inset-block CSS property defines the logical block start and end offsets of an element, which maps to physical offsets depending on the element's writing mode, directionality, and text orientation. It corresponds to the top and bottom, or right and left properties depending on the values defined for writing-mode, direction, and text-orientation."},{name:"inset-block-end",syntax:"<'top'>",relevance:50,browsers:["E87","FF63","S14.1","C87","O73"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/inset-block-end"}],description:"The inset-block-end CSS property defines the logical block end offset of an element, which maps to a physical offset depending on the element's writing mode, directionality, and text orientation. It corresponds to the top, right, bottom, or left property depending on the values defined for writing-mode, direction, and text-orientation."},{name:"inset-block-start",syntax:"<'top'>",relevance:50,browsers:["E87","FF63","S14.1","C87","O73"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/inset-block-start"}],description:"The inset-block-start CSS property defines the logical block start offset of an element, which maps to a physical offset depending on the element's writing mode, directionality, and text orientation. It corresponds to the top, right, bottom, or left property depending on the values defined for writing-mode, direction, and text-orientation."},{name:"inset-inline",syntax:"<'top'>{1,2}",relevance:50,browsers:["E87","FF63","S14.1","C87","O73"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/inset-inline"}],description:"The inset-inline CSS property defines the logical block start and end offsets of an element, which maps to physical offsets depending on the element's writing mode, directionality, and text orientation. It corresponds to the top and bottom, or right and left properties depending on the values defined for writing-mode, direction, and text-orientation."},{name:"inset-inline-end",syntax:"<'top'>",relevance:50,browsers:["E87","FF63","S14.1","C87","O73"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/inset-inline-end"}],description:"The inset-inline-end CSS property defines the logical inline end inset of an element, which maps to a physical inset depending on the element's writing mode, directionality, and text orientation. It corresponds to the top, right, bottom, or left property depending on the values defined for writing-mode, direction, and text-orientation."},{name:"inset-inline-start",syntax:"<'top'>",relevance:50,browsers:["E87","FF63","S14.1","C87","O73"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/inset-inline-start"}],description:"The inset-inline-start CSS property defines the logical inline start inset of an element, which maps to a physical offset depending on the element's writing mode, directionality, and text orientation. It corresponds to the top, right, bottom, or left property depending on the values defined for writing-mode, direction, and text-orientation."},{name:"justify-tracks",status:"experimental",syntax:"[ normal | <content-distribution> | <overflow-position>? [ <content-position> | left | right ] ]#",relevance:50,browsers:["FF77"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/justify-tracks"}],description:"The justify-tracks CSS property sets the alignment in the masonry axis for grid containers that have masonry in their inline axis"},{name:"line-clamp",status:"experimental",syntax:"none | <integer>",relevance:50,description:"The line-clamp property allows limiting the contents of a block container to the specified number of lines; remaining content is fragmented away and neither rendered nor measured. Optionally, it also allows inserting content into the last line box to indicate the continuity of truncated/interrupted content."},{name:"line-height-step",status:"experimental",syntax:"<length>",relevance:50,browsers:["E79","C60","O47"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/line-height-step"}],description:"The line-height-step CSS property defines the step units for line box heights. When the step unit is positive, line box heights are rounded up to the closest multiple of the unit. Negative values are invalid."},{name:"margin-block",syntax:"<'margin-left'>{1,2}",relevance:50,browsers:["E87","FF66","S14.1","C87","O73"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/margin-block"}],description:"The margin-block CSS property defines the logical block start and end margins of an element, which maps to physical margins depending on the element's writing mode, directionality, and text orientation."},{name:"margin-inline",syntax:"<'margin-left'>{1,2}",relevance:50,browsers:["E87","FF66","S14.1","C87","O73"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/margin-inline"}],description:"The margin-inline CSS property defines the logical inline start and end margins of an element, which maps to physical margins depending on the element's writing mode, directionality, and text orientation."},{name:"margin-trim",status:"experimental",syntax:"none | in-flow | all",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/margin-trim"}],description:"The margin-trim property allows the container to trim the margins of its children where they adjoin the container’s edges."},{name:"mask",syntax:"<mask-layer>#",relevance:50,browsers:["E79","FF2","S3.1","C1","O15"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/mask"}],description:"The mask CSS property alters the visibility of an element by either partially or fully hiding it. This is accomplished by either masking or clipping the image at specific points."},{name:"mask-border",syntax:"<'mask-border-source'> || <'mask-border-slice'> [ / <'mask-border-width'>? [ / <'mask-border-outset'> ]? ]? || <'mask-border-repeat'> || <'mask-border-mode'>",relevance:50,browsers:["E79","S3.1","C1","O15"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/mask-border"}],description:"The mask-border CSS property lets you create a mask along the edge of an element's border.\n\nThis property is a shorthand for mask-border-source, mask-border-slice, mask-border-width, mask-border-outset, mask-border-repeat, and mask-border-mode. As with all shorthand properties, any omitted sub-values will be set to their initial value."},{name:"mask-border-mode",syntax:"luminance | alpha",relevance:50,description:"The mask-border-mode CSS property specifies the blending mode used in a mask border."},{name:"mask-border-outset",syntax:"[ <length> | <number> ]{1,4}",relevance:50,browsers:["E79","S3.1","C1","O15"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/mask-border-outset"}],description:"The mask-border-outset CSS property specifies the distance by which an element's mask border is set out from its border box."},{name:"mask-border-repeat",syntax:"[ stretch | repeat | round | space ]{1,2}",relevance:50,browsers:["E79","S3.1","C1","O15"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/mask-border-repeat"}],description:"The mask-border-repeat CSS property defines how the edge regions of a source image are adjusted to fit the dimensions of an element's mask border."},{name:"mask-border-slice",syntax:"<number-percentage>{1,4} fill?",relevance:50,browsers:["E79","S3.1","C1","O15"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/mask-border-slice"}],description:"The mask-border-slice CSS property divides the image specified by mask-border-source into regions. These regions are used to form the components of an element's mask border."},{name:"mask-border-source",syntax:"none | <image>",relevance:50,browsers:["E79","S3.1","C1","O15"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/mask-border-source"}],description:"The mask-border-source CSS property specifies the source image used to create an element's mask border.\n\nThe mask-border-slice property is used to divide the source image into regions, which are then dynamically applied to the final mask border."},{name:"mask-border-width",syntax:"[ <length-percentage> | <number> | auto ]{1,4}",relevance:50,browsers:["E79","S3.1","C1","O15"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/mask-border-width"}],description:"The mask-border-width CSS property specifies the width of an element's mask border."},{name:"mask-clip",syntax:"[ <geometry-box> | no-clip ]#",relevance:50,browsers:["E79","FF53","S4","C1","O15"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/mask-clip"}],description:"The mask-clip CSS property determines the area, which is affected by a mask. The painted content of an element must be restricted to this area."},{name:"mask-composite",syntax:"<compositing-operator>#",relevance:50,browsers:["E18","FF53"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/mask-composite"}],description:"The mask-composite CSS property represents a compositing operation used on the current mask layer with the mask layers below it."},{name:"masonry-auto-flow",status:"experimental",syntax:"[ pack | next ] || [ definite-first | ordered ]",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/masonry-auto-flow"}],description:"The masonry-auto-flow CSS property modifies how items are placed when using masonry in CSS Grid Layout."},{name:"math-style",syntax:"normal | compact",relevance:50,browsers:["FF83","S14.1","C83"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/math-style"}],description:"The math-style property indicates whether MathML equations should render with normal or compact height."},{name:"max-lines",status:"experimental",syntax:"none | <integer>",relevance:50,description:"The max-liens property forces a break after a set number of lines"},{name:"offset",syntax:"[ <'offset-position'>? [ <'offset-path'> [ <'offset-distance'> || <'offset-rotate'> ]? ]? ]! [ / <'offset-anchor'> ]?",relevance:50,browsers:["E79","FF72","C55","O42"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/offset"}],description:"The offset CSS property is a shorthand property for animating an element along a defined path."},{name:"offset-anchor",syntax:"auto | <position>",relevance:50,browsers:["E79","FF72","C79"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/offset-anchor"}],description:"Defines an anchor point of the box positioned along the path. The anchor point specifies the point of the box which is to be considered as the point that is moved along the path."},{name:"offset-distance",syntax:"<length-percentage>",relevance:50,browsers:["E79","FF72","C55","O42"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/offset-distance"}],description:"The offset-distance CSS property specifies a position along an offset-path."},{name:"offset-path",syntax:"none | ray( [ <angle> && <size> && contain? ] ) | <path()> | <url> | [ <basic-shape> || <geometry-box> ]",relevance:50,browsers:["E79","FF72","C55","O45"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/offset-path"}],description:'The offset-path CSS property specifies the offset path where the element gets positioned. The exact element’s position on the offset path is determined by the offset-distance property. An offset path is either a specified path with one or multiple sub-paths or the geometry of a not-styled basic shape. Each shape or path must define an initial position for the computed value of "0" for offset-distance and an initial direction which specifies the rotation of the object to the initial position.\n\nIn this specification, a direction (or rotation) of 0 degrees is equivalent to the direction of the positive x-axis in the object’s local coordinate system. In other words, a rotation of 0 degree points to the right side of the UA if the object and its ancestors have no transformation applied.'},{name:"offset-position",status:"experimental",syntax:"auto | <position>",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/offset-position"}],description:"Specifies the initial position of the offset path. If position is specified with static, offset-position would be ignored."},{name:"offset-rotate",syntax:"[ auto | reverse ] || <angle>",relevance:50,browsers:["E79","FF72","C56","O43"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/offset-rotate"}],description:"The offset-rotate CSS property defines the direction of the element while positioning along the offset path."},{name:"overflow-anchor",syntax:"auto | none",relevance:52,browsers:["E79","FF66","C56","O43"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/overflow-anchor"}],description:"The overflow-anchor CSS property provides a way to opt out browser scroll anchoring behavior which adjusts scroll position to minimize content shifts."},{name:"overflow-block",syntax:"visible | hidden | clip | scroll | auto",relevance:50,browsers:["FF69"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/overflow-block"}],description:"The overflow-block CSS media feature can be used to test how the output device handles content that overflows the initial containing block along the block axis."},{name:"overflow-clip-box",status:"nonstandard",syntax:"padding-box | content-box",relevance:0,browsers:["FF29"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Mozilla/Gecko/Chrome/CSS/overflow-clip-box"}],description:"The overflow-clip-box CSS property specifies relative to which box the clipping happens when there is an overflow. It is short hand for the overflow-clip-box-inline and overflow-clip-box-block properties."},{name:"overflow-clip-margin",syntax:"<visual-box> || <length [0,∞]>",relevance:50,browsers:["E90","C90","O76"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/overflow-clip-margin"}],description:"The overflow-clip-margin CSS property determines how far outside its bounds an element with overflow: clip may be painted before being clipped."},{name:"overflow-inline",syntax:"visible | hidden | clip | scroll | auto",relevance:50,browsers:["FF69"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/overflow-inline"}],description:"The overflow-inline CSS media feature can be used to test how the output device handles content that overflows the initial containing block along the inline axis."},{name:"overscroll-behavior",syntax:"[ contain | none | auto ]{1,2}",relevance:50,browsers:["E18","FF59","C63","O50"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/overscroll-behavior"}],description:"The overscroll-behavior CSS property is shorthand for the overscroll-behavior-x and overscroll-behavior-y properties, which allow you to control the browser's scroll overflow behavior — what happens when the boundary of a scrolling area is reached."},{name:"overscroll-behavior-block",syntax:"contain | none | auto",relevance:50,browsers:["E79","FF73","C77","O64"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/overscroll-behavior-block"}],description:"The overscroll-behavior-block CSS property sets the browser's behavior when the block direction boundary of a scrolling area is reached."},{name:"overscroll-behavior-inline",syntax:"contain | none | auto",relevance:50,browsers:["E79","FF73","C77","O64"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/overscroll-behavior-inline"}],description:"The overscroll-behavior-inline CSS property sets the browser's behavior when the inline direction boundary of a scrolling area is reached."},{name:"overscroll-behavior-x",syntax:"contain | none | auto",relevance:50,browsers:["E18","FF59","C63","O50"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/overscroll-behavior-x"}],description:"The overscroll-behavior-x CSS property is allows you to control the browser's scroll overflow behavior — what happens when the boundary of a scrolling area is reached — in the x axis direction."},{name:"overscroll-behavior-y",syntax:"contain | none | auto",relevance:50,browsers:["E18","FF59","C63","O50"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/overscroll-behavior-y"}],description:"The overscroll-behavior-y CSS property is allows you to control the browser's scroll overflow behavior — what happens when the boundary of a scrolling area is reached — in the y axis direction."},{name:"padding-block",syntax:"<'padding-left'>{1,2}",relevance:50,browsers:["E87","FF66","S14.1","C87","O73"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/padding-block"}],description:"The padding-block CSS property defines the logical block start and end padding of an element, which maps to physical padding properties depending on the element's writing mode, directionality, and text orientation."},{name:"padding-inline",syntax:"<'padding-left'>{1,2}",relevance:50,browsers:["E87","FF66","S14.1","C87","O73"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/padding-inline"}],description:"The padding-inline CSS property defines the logical inline start and end padding of an element, which maps to physical padding properties depending on the element's writing mode, directionality, and text orientation."},{name:"place-content",syntax:"<'align-content'> <'justify-content'>?",relevance:50,browsers:["E79","FF45","S9","C59","O46"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/place-content"}],description:"The place-content CSS shorthand property sets both the align-content and justify-content properties."},{name:"place-items",syntax:"<'align-items'> <'justify-items'>?",relevance:50,browsers:["E79","FF45","S11","C59","O46"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/place-items"}],description:"The CSS place-items shorthand property sets both the align-items and justify-items properties. The first value is the align-items property value, the second the justify-items one. If the second value is not present, the first value is also used for it."},{name:"place-self",syntax:"<'align-self'> <'justify-self'>?",relevance:50,browsers:["E79","FF45","S11","C59","O46"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/place-self"}],description:"The place-self CSS property is a shorthand property sets both the align-self and justify-self properties. The first value is the align-self property value, the second the justify-self one. If the second value is not present, the first value is also used for it."},{name:"rotate",syntax:"none | <angle> | [ x | y | z | <number>{3} ] && <angle>",relevance:50,browsers:["FF72","S14.1"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/rotate"}],description:"The rotate CSS property allows you to specify rotation transforms individually and independently of the transform property. This maps better to typical user interface usage, and saves having to remember the exact order of transform functions to specify in the transform value."},{name:"row-gap",syntax:"normal | <length-percentage>",relevance:50,browsers:["E84","FF63","S14.1","C84","O70"],description:"The row-gap CSS property specifies the gutter between grid rows."},{name:"ruby-merge",status:"experimental",syntax:"separate | collapse | auto",relevance:50,description:"This property controls how ruby annotation boxes should be rendered when there are more than one in a ruby container box: whether each pair should be kept separate, the annotations should be collapsed and rendered as a group, or the separation should be determined based on the space available."},{name:"scale",syntax:"none | <number>{1,3}",relevance:50,browsers:["FF72","S14.1"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/scale"}],description:"The scale CSS property allows you to specify scale transforms individually and independently of the transform property. This maps better to typical user interface usage, and saves having to remember the exact order of transform functions to specify in the transform value."},{name:"scrollbar-color",syntax:"auto | <color>{2}",relevance:50,browsers:["FF64"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/scrollbar-color"}],description:"The scrollbar-color CSS property sets the color of the scrollbar track and thumb."},{name:"scrollbar-gutter",syntax:"auto | stable && both-edges?",relevance:50,browsers:["E94","FF97","C94","O80"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/scrollbar-gutter"}],description:"The scrollbar-gutter CSS property allows authors to reserve space for the scrollbar, preventing unwanted layout changes as the content grows while also avoiding unnecessary visuals when scrolling isn't needed."},{name:"scrollbar-width",syntax:"auto | thin | none",relevance:50,browsers:["FF64"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/scrollbar-width"}],description:"The scrollbar-width property allows the author to set the maximum thickness of an element’s scrollbars when they are shown. "},{name:"scroll-margin",syntax:"<length>{1,4}",relevance:50,browsers:["E79","FF90","S14.1","C69","O56"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/scroll-margin"}],description:"The scroll-margin property is a shorthand property which sets all of the scroll-margin longhands, assigning values much like the margin property does for the margin-* longhands."},{name:"scroll-margin-block",syntax:"<length>{1,2}",relevance:50,browsers:["E79","FF68","S14.1","C69","O56"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/scroll-margin-block"}],description:"The scroll-margin-block property is a shorthand property which sets the scroll-margin longhands in the block dimension."},{name:"scroll-margin-block-start",syntax:"<length>",relevance:50,browsers:["E79","FF68","S14.1","C69","O56"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/scroll-margin-block-start"}],description:"The scroll-margin-block-start property defines the margin of the scroll snap area at the start of the block dimension that is used for snapping this box to the snapport. The scroll snap area is determined by taking the transformed border box, finding its rectangular bounding box (axis-aligned in the scroll container’s coordinate space), then adding the specified outsets."},{name:"scroll-margin-block-end",syntax:"<length>",relevance:50,browsers:["E79","FF68","S14.1","C69","O56"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/scroll-margin-block-end"}],description:"The scroll-margin-block-end property defines the margin of the scroll snap area at the end of the block dimension that is used for snapping this box to the snapport. The scroll snap area is determined by taking the transformed border box, finding its rectangular bounding box (axis-aligned in the scroll container’s coordinate space), then adding the specified outsets."},{name:"scroll-margin-bottom",syntax:"<length>",relevance:50,browsers:["E79","FF68","S14.1","C69","O56"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/scroll-margin-bottom"}],description:"The scroll-margin-bottom property defines the bottom margin of the scroll snap area that is used for snapping this box to the snapport. The scroll snap area is determined by taking the transformed border box, finding its rectangular bounding box (axis-aligned in the scroll container’s coordinate space), then adding the specified outsets."},{name:"scroll-margin-inline",syntax:"<length>{1,2}",relevance:50,browsers:["E79","FF68","S14.1","C69","O56"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/scroll-margin-inline"}],description:"The scroll-margin-inline property is a shorthand property which sets the scroll-margin longhands in the inline dimension."},{name:"scroll-margin-inline-start",syntax:"<length>",relevance:50,browsers:["E79","FF68","S14.1","C69","O56"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/scroll-margin-inline-start"}],description:"The scroll-margin-inline-start property defines the margin of the scroll snap area at the start of the inline dimension that is used for snapping this box to the snapport. The scroll snap area is determined by taking the transformed border box, finding its rectangular bounding box (axis-aligned in the scroll container’s coordinate space), then adding the specified outsets."},{name:"scroll-margin-inline-end",syntax:"<length>",relevance:50,browsers:["E79","FF68","S14.1","C69","O56"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/scroll-margin-inline-end"}],description:"The scroll-margin-inline-end property defines the margin of the scroll snap area at the end of the inline dimension that is used for snapping this box to the snapport. The scroll snap area is determined by taking the transformed border box, finding its rectangular bounding box (axis-aligned in the scroll container’s coordinate space), then adding the specified outsets."},{name:"scroll-margin-left",syntax:"<length>",relevance:50,browsers:["E79","FF68","S14.1","C69","O56"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/scroll-margin-left"}],description:"The scroll-margin-left property defines the left margin of the scroll snap area that is used for snapping this box to the snapport. The scroll snap area is determined by taking the transformed border box, finding its rectangular bounding box (axis-aligned in the scroll container’s coordinate space), then adding the specified outsets."},{name:"scroll-margin-right",syntax:"<length>",relevance:50,browsers:["E79","FF68","S14.1","C69","O56"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/scroll-margin-right"}],description:"The scroll-margin-right property defines the right margin of the scroll snap area that is used for snapping this box to the snapport. The scroll snap area is determined by taking the transformed border box, finding its rectangular bounding box (axis-aligned in the scroll container’s coordinate space), then adding the specified outsets."},{name:"scroll-margin-top",syntax:"<length>",relevance:50,browsers:["E79","FF68","S14.1","C69","O56"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/scroll-margin-top"}],description:"The scroll-margin-top property defines the top margin of the scroll snap area that is used for snapping this box to the snapport. The scroll snap area is determined by taking the transformed border box, finding its rectangular bounding box (axis-aligned in the scroll container’s coordinate space), then adding the specified outsets."},{name:"scroll-padding",syntax:"[ auto | <length-percentage> ]{1,4}",relevance:50,browsers:["E79","FF68","S14.1","C69","O56"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/scroll-padding"}],description:"The scroll-padding property is a shorthand property which sets all of the scroll-padding longhands, assigning values much like the padding property does for the padding-* longhands."},{name:"scroll-padding-block",syntax:"[ auto | <length-percentage> ]{1,2}",relevance:50,browsers:["E79","FF68","S15","C69","O56"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/scroll-padding-block"}],description:"The scroll-padding-block property is a shorthand property which sets the scroll-padding longhands for the block dimension."},{name:"scroll-padding-block-start",syntax:"auto | <length-percentage>",relevance:50,browsers:["E79","FF68","S15","C69","O56"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/scroll-padding-block-start"}],description:"The scroll-padding-block-start property defines offsets for the start edge in the block dimension of the optimal viewing region of the scrollport: the region used as the target region for placing things in view of the user. This allows the author to exclude regions of the scrollport that are obscured by other content (such as fixed-positioned toolbars or sidebars) or simply to put more breathing room between a targeted element and the edges of the scrollport."},{name:"scroll-padding-block-end",syntax:"auto | <length-percentage>",relevance:50,browsers:["E79","FF68","S15","C69","O56"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/scroll-padding-block-end"}],description:"The scroll-padding-block-end property defines offsets for the end edge in the block dimension of the optimal viewing region of the scrollport: the region used as the target region for placing things in view of the user. This allows the author to exclude regions of the scrollport that are obscured by other content (such as fixed-positioned toolbars or sidebars) or simply to put more breathing room between a targeted element and the edges of the scrollport."},{name:"scroll-padding-bottom",syntax:"auto | <length-percentage>",relevance:50,browsers:["E79","FF68","S14.1","C69","O56"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/scroll-padding-bottom"}],description:"The scroll-padding-bottom property defines offsets for the bottom of the optimal viewing region of the scrollport: the region used as the target region for placing things in view of the user. This allows the author to exclude regions of the scrollport that are obscured by other content (such as fixed-positioned toolbars or sidebars) or simply to put more breathing room between a targeted element and the edges of the scrollport."},{name:"scroll-padding-inline",syntax:"[ auto | <length-percentage> ]{1,2}",relevance:50,browsers:["E79","FF68","S15","C69","O56"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/scroll-padding-inline"}],description:"The scroll-padding-inline property is a shorthand property which sets the scroll-padding longhands for the inline dimension."},{name:"scroll-padding-inline-start",syntax:"auto | <length-percentage>",relevance:50,browsers:["E79","FF68","S15","C69","O56"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/scroll-padding-inline-start"}],description:"The scroll-padding-inline-start property defines offsets for the start edge in the inline dimension of the optimal viewing region of the scrollport: the region used as the target region for placing things in view of the user. This allows the author to exclude regions of the scrollport that are obscured by other content (such as fixed-positioned toolbars or sidebars) or simply to put more breathing room between a targeted element and the edges of the scrollport."},{name:"scroll-padding-inline-end",syntax:"auto | <length-percentage>",relevance:50,browsers:["E79","FF68","S15","C69","O56"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/scroll-padding-inline-end"}],description:"The scroll-padding-inline-end property defines offsets for the end edge in the inline dimension of the optimal viewing region of the scrollport: the region used as the target region for placing things in view of the user. This allows the author to exclude regions of the scrollport that are obscured by other content (such as fixed-positioned toolbars or sidebars) or simply to put more breathing room between a targeted element and the edges of the scrollport."},{name:"scroll-padding-left",syntax:"auto | <length-percentage>",relevance:50,browsers:["E79","FF68","S14.1","C69","O56"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/scroll-padding-left"}],description:"The scroll-padding-left property defines offsets for the left of the optimal viewing region of the scrollport: the region used as the target region for placing things in view of the user. This allows the author to exclude regions of the scrollport that are obscured by other content (such as fixed-positioned toolbars or sidebars) or simply to put more breathing room between a targeted element and the edges of the scrollport."},{name:"scroll-padding-right",syntax:"auto | <length-percentage>",relevance:50,browsers:["E79","FF68","S14.1","C69","O56"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/scroll-padding-right"}],description:"The scroll-padding-right property defines offsets for the right of the optimal viewing region of the scrollport: the region used as the target region for placing things in view of the user. This allows the author to exclude regions of the scrollport that are obscured by other content (such as fixed-positioned toolbars or sidebars) or simply to put more breathing room between a targeted element and the edges of the scrollport."},{name:"scroll-padding-top",syntax:"auto | <length-percentage>",relevance:51,browsers:["E79","FF68","S14.1","C69","O56"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/scroll-padding-top"}],description:"The scroll-padding-top property defines offsets for the top of the optimal viewing region of the scrollport: the region used as the target region for placing things in view of the user. This allows the author to exclude regions of the scrollport that are obscured by other content (such as fixed-positioned toolbars or sidebars) or simply to put more breathing room between a targeted element and the edges of the scrollport."},{name:"scroll-snap-align",syntax:"[ none | start | end | center ]{1,2}",relevance:53,browsers:["E79","FF68","S11","C69","O56"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/scroll-snap-align"}],description:"The scroll-snap-align property specifies the box’s snap position as an alignment of its snap area (as the alignment subject) within its snap container’s snapport (as the alignment container). The two values specify the snapping alignment in the block axis and inline axis, respectively. If only one value is specified, the second value defaults to the same value."},{name:"scroll-snap-stop",syntax:"normal | always",relevance:50,browsers:["E79","S15","C75","O62"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/scroll-snap-stop"}],description:'The scroll-snap-stop CSS property defines whether the scroll container is allowed to "pass over" possible snap positions.'},{name:"scroll-snap-type-x",status:"obsolete",syntax:"none | mandatory | proximity",relevance:0,browsers:["FF39","S9"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/scroll-snap-type-x"}],description:"The scroll-snap-type-x CSS property defines how strictly snap points are enforced on the horizontal axis of the scroll container in case there is one.\n\nSpecifying any precise animations or physics used to enforce those snap points is not covered by this property but instead left up to the user agent."},{name:"scroll-snap-type-y",status:"obsolete",syntax:"none | mandatory | proximity",relevance:0,browsers:["FF39"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/scroll-snap-type-y"}],description:"The scroll-snap-type-y CSS property defines how strictly snap points are enforced on the vertical axis of the scroll container in case there is one.\n\nSpecifying any precise animations or physics used to enforce those snap points is not covered by this property but instead left up to the user agent."},{name:"text-combine-upright",syntax:"none | all | [ digits <integer>? ]",relevance:50,references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/text-combine-upright"}],description:"The text-combine-upright CSS property specifies the combination of multiple characters into the space of a single character. If the combined text is wider than 1em, the user agent must fit the contents within 1em. The resulting composition is treated as a single upright glyph for layout and decoration. This property only has an effect in vertical writing modes.\n\nThis is used to produce an effect that is known as tate-chū-yoko (縦中横) in Japanese, or as 直書橫向 in Chinese."},{name:"text-decoration-skip",status:"experimental",syntax:"none | [ objects || [ spaces | [ leading-spaces || trailing-spaces ] ] || edges || box-decoration ]",relevance:52,browsers:["S12.1","C57","O44"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/text-decoration-skip"}],description:"The text-decoration-skip CSS property specifies what parts of the element’s content any text decoration affecting the element must skip over. It controls all text decoration lines drawn by the element and also any text decoration lines drawn by its ancestors."},{name:"text-decoration-skip-ink",syntax:"auto | all | none",relevance:50,browsers:["E79","FF70","Spreview","C64","O50"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/text-decoration-skip-ink"}],description:"The text-decoration-skip-ink CSS property specifies how overlines and underlines are drawn when they pass over glyph ascenders and descenders."},{name:"text-decoration-thickness",syntax:"auto | from-font | <length> | <percentage> ",relevance:50,browsers:["E89","FF70","S12.1","C89","O75"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/text-decoration-thickness"}],description:"The text-decoration-thickness CSS property sets the thickness, or width, of the decoration line that is used on text in an element, such as a line-through, underline, or overline."},{name:"text-emphasis",syntax:"<'text-emphasis-style'> || <'text-emphasis-color'>",relevance:50,browsers:["E79","FF46","S7","C25","O15"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/text-emphasis"}],description:"The text-emphasis CSS property is a shorthand property for setting text-emphasis-style and text-emphasis-color in one declaration. This property will apply the specified emphasis mark to each character of the element's text, except separator characters, like spaces,  and control characters."},{name:"text-emphasis-color",syntax:"<color>",relevance:50,browsers:["E79","FF46","S7","C25","O15"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/text-emphasis-color"}],description:"The text-emphasis-color CSS property defines the color used to draw emphasis marks on text being rendered in the HTML document. This value can also be set and reset using the text-emphasis shorthand."},{name:"text-emphasis-position",syntax:"[ over | under ] && [ right | left ]",relevance:50,browsers:["E79","FF46","S7","C25","O15"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/text-emphasis-position"}],description:"The text-emphasis-position CSS property describes where emphasis marks are drawn at. The effect of emphasis marks on the line height is the same as for ruby text: if there isn't enough place, the line height is increased."},{name:"text-emphasis-style",syntax:"none | [ [ filled | open ] || [ dot | circle | double-circle | triangle | sesame ] ] | <string>",relevance:50,browsers:["E79","FF46","S7","C25","O15"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/text-emphasis-style"}],description:"The text-emphasis-style CSS property defines the type of emphasis used. It can also be set, and reset, using the text-emphasis shorthand."},{name:"text-size-adjust",status:"experimental",syntax:"none | auto | <percentage>",relevance:57,browsers:["E79","C54","O41"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/text-size-adjust"}],description:"The text-size-adjust CSS property controls the text inflation algorithm used on some smartphones and tablets. Other browsers will ignore this property."},{name:"text-underline-offset",syntax:"auto | <length> | <percentage> ",relevance:50,browsers:["E87","FF70","S12.1","C87","O73"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/text-underline-offset"}],description:"The text-underline-offset CSS property sets the offset distance of an underline text decoration line (applied using text-decoration) from its original position."},{name:"transform-box",syntax:"content-box | border-box | fill-box | stroke-box | view-box",relevance:50,browsers:["E79","FF55","S11","C64","O51"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/transform-box"}],description:"The transform-box CSS property defines the layout box to which the transform and transform-origin properties relate."},{name:"translate",syntax:"none | <length-percentage> [ <length-percentage> <length>? ]?",relevance:50,browsers:["FF72","S14.1"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/translate"}],description:"The translate CSS property allows you to specify translation transforms individually and independently of the transform property. This maps better to typical user interface usage, and saves having to remember the exact order of transform functions to specify in the transform value."},{name:"speak-as",syntax:"auto | bullets | numbers | words | spell-out | <counter-style-name>",relevance:50,description:"The speak-as descriptor specifies how a counter symbol constructed with a given @counter-style will be represented in the spoken form. For example, an author can specify a counter symbol to be either spoken as its numerical value or just represented with an audio cue."},{name:"ascent-override",status:"experimental",syntax:"normal | <percentage>",relevance:50,description:"Describes the ascent metric of a font."},{name:"descent-override",status:"experimental",syntax:"normal | <percentage>",relevance:50,description:"Describes the descent metric of a font."},{name:"font-display",status:"experimental",syntax:"[ auto | block | swap | fallback | optional ]",relevance:71,description:"The font-display descriptor determines how a font face is displayed based on whether and when it is downloaded and ready to use."},{name:"line-gap-override",status:"experimental",syntax:"normal | <percentage>",relevance:50,description:"Describes the line-gap metric of a font."},{name:"size-adjust",status:"experimental",syntax:"<percentage>",relevance:50,description:"A multiplier for glyph outlines and metrics of a font."},{name:"bleed",syntax:"auto | <length>",relevance:50,description:"The bleed CSS at-rule descriptor, used with the @page at-rule, specifies the extent of the page bleed area outside the page box. This property only has effect if crop marks are enabled using the marks property."},{name:"marks",syntax:"none | [ crop || cross ]",relevance:50,description:"The marks CSS at-rule descriptor, used with the @page at-rule, adds crop and/or cross marks to the presentation of the document. Crop marks indicate where the page should be cut. Cross marks are used to align sheets."},{name:"syntax",status:"experimental",syntax:"<string>",relevance:50,description:"Specifies the syntax of the custom property registration represented by the @property rule, controlling how the property’s value is parsed at computed value time."},{name:"inherits",status:"experimental",syntax:"true | false",relevance:50,description:"Specifies the inherit flag of the custom property registration represented by the @property rule, controlling whether or not the property inherits by default."},{name:"initial-value",status:"experimental",syntax:"<string>",relevance:50,description:"Specifies the initial value of the custom property registration represented by the @property rule, controlling the property’s initial value."},{name:"max-zoom",syntax:"auto | <number> | <percentage>",relevance:50,description:"The max-zoom CSS descriptor sets the maximum zoom factor of a document defined by the @viewport at-rule. The browser will not zoom in any further than this, whether automatically or at the user's request.\n\nA zoom factor of 1.0 or 100% corresponds to no zooming. Larger values are zoomed in. Smaller values are zoomed out."},{name:"min-zoom",syntax:"auto | <number> | <percentage>",relevance:50,description:"The min-zoom CSS descriptor sets the minimum zoom factor of a document defined by the @viewport at-rule. The browser will not zoom out any further than this, whether automatically or at the user's request.\n\nA zoom factor of 1.0 or 100% corresponds to no zooming. Larger values are zoomed in. Smaller values are zoomed out."},{name:"orientation",syntax:"auto | portrait | landscape",relevance:50,description:"The orientation CSS @media media feature can be used to apply styles based on the orientation of the viewport (or the page box, for paged media)."},{name:"user-zoom",syntax:"zoom | fixed",relevance:50,description:"The user-zoom CSS descriptor controls whether or not the user can change the zoom factor of a document defined by @viewport."},{name:"viewport-fit",syntax:"auto | contain | cover",relevance:50,description:"The border-block-style CSS property defines the style of the logical block borders of an element, which maps to a physical border style depending on the element's writing mode, directionality, and text orientation."}],atDirectives:[{name:"@charset",references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/@charset"}],description:"Defines character set of the document."},{name:"@counter-style",browsers:["E91","FF33","C91","O77"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/@counter-style"}],description:"Defines a custom counter style."},{name:"@font-face",references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/@font-face"}],description:"Allows for linking to fonts that are automatically activated when needed. This permits authors to work around the limitation of 'web-safe' fonts, allowing for consistent rendering independent of the fonts available in a given user's environment."},{name:"@font-feature-values",browsers:["FF34","S9.1"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/@font-feature-values"}],description:"Defines named values for the indices used to select alternate glyphs for a given font family."},{name:"@import",references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/@import"}],description:"Includes content of another file."},{name:"@keyframes",references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/@keyframes"}],description:"Defines set of animation key frames."},{name:"@media",references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/@media"}],description:"Defines a stylesheet for a particular media type."},{name:"@-moz-document",browsers:["FF1.8"],description:"Gecko-specific at-rule that restricts the style rules contained within it based on the URL of the document."},{name:"@-moz-keyframes",browsers:["FF5"],description:"Defines set of animation key frames."},{name:"@-ms-viewport",browsers:["E","IE10"],description:"Specifies the size, zoom factor, and orientation of the viewport."},{name:"@namespace",references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/@namespace"}],description:"Declares a prefix and associates it with a namespace name."},{name:"@-o-keyframes",browsers:["O12"],description:"Defines set of animation key frames."},{name:"@-o-viewport",browsers:["O11"],description:"Specifies the size, zoom factor, and orientation of the viewport."},{name:"@page",browsers:["E12","FF19","C2","IE8","O6"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/@page"}],description:"Directive defines various page parameters."},{name:"@supports",browsers:["E12","FF22","S9","C28","O12.1"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/@supports"}],description:"A conditional group rule whose condition tests whether the user agent supports CSS property:value pairs."},{name:"@-webkit-keyframes",browsers:["C","S4"],description:"Defines set of animation key frames."}],pseudoClasses:[{name:":active",references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/:active"}],description:"Applies while an element is being activated by the user. For example, between the times the user presses the mouse button and releases it."},{name:":any-link",browsers:["E79","FF50","S9","C65","O52"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/:any-link"}],description:"Represents an element that acts as the source anchor of a hyperlink. Applies to both visited and unvisited links."},{name:":checked",references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/:checked"}],description:"Radio and checkbox elements can be toggled by the user. Some menu items are 'checked' when the user selects them. When such elements are toggled 'on' the :checked pseudo-class applies."},{name:":corner-present",browsers:["C","S5"],description:"Non-standard. Indicates whether or not a scrollbar corner is present."},{name:":decrement",browsers:["C","S5"],description:"Non-standard. Applies to buttons and track pieces. Indicates whether or not the button or track piece will decrement the view’s position when used."},{name:":default",browsers:["E79","FF4","S5","C10","O10"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/:default"}],description:"Applies to the one or more UI elements that are the default among a set of similar elements. Typically applies to context menu items, buttons, and select lists/menus."},{name:":disabled",references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/:disabled"}],description:"Represents user interface elements that are in a disabled state; such elements have a corresponding enabled state."},{name:":double-button",browsers:["C","S5"],description:"Non-standard. Applies to buttons and track pieces. Applies when both buttons are displayed together at the same end of the scrollbar."},{name:":empty",references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/:empty"}],description:"Represents an element that has no children at all."},{name:":enabled",references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/:enabled"}],description:"Represents user interface elements that are in an enabled state; such elements have a corresponding disabled state."},{name:":end",browsers:["C","S5"],description:"Non-standard. Applies to buttons and track pieces. Indicates whether the object is placed after the thumb."},{name:":first",browsers:["E12","S6","C18","IE8","O9.2"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/:first"}],description:"When printing double-sided documents, the page boxes on left and right pages may be different. This can be expressed through CSS pseudo-classes defined in the  page context."},{name:":first-child",references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/:first-child"}],description:"Same as :nth-child(1). Represents an element that is the first child of some other element."},{name:":first-of-type",references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/:first-of-type"}],description:"Same as :nth-of-type(1). Represents an element that is the first sibling of its type in the list of children of its parent element."},{name:":focus",references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/:focus"}],description:"Applies while an element has the focus (accepts keyboard or mouse events, or other forms of input)."},{name:":fullscreen",references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/:fullscreen"}],description:"Matches any element that has its fullscreen flag set."},{name:":future",browsers:["S7"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/:future"}],description:"Represents any element that is defined to occur entirely after a :current element."},{name:":horizontal",browsers:["C","S5"],description:"Non-standard. Applies to any scrollbar pieces that have a horizontal orientation."},{name:":host",browsers:["E79","FF63","S10","C54","O41"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/:host"}],description:"When evaluated in the context of a shadow tree, matches the shadow tree’s host element."},{name:":host()",browsers:["C35","O22"],description:"When evaluated in the context of a shadow tree, it matches the shadow tree’s host element if the host element, in its normal context, matches the selector argument."},{name:":host-context()",browsers:["C35","O22"],description:"Tests whether there is an ancestor, outside the shadow tree, which matches a particular selector."},{name:":hover",references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/:hover"}],description:"Applies while the user designates an element with a pointing device, but does not necessarily activate it. For example, a visual user agent could apply this pseudo-class when the cursor (mouse pointer) hovers over a box generated by the element."},{name:":increment",browsers:["C","S5"],description:"Non-standard. Applies to buttons and track pieces. Indicates whether or not the button or track piece will increment the view’s position when used."},{name:":indeterminate",references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/:indeterminate"}],description:"Applies to UI elements whose value is in an indeterminate state."},{name:":in-range",browsers:["E13","FF29","S5.1","C10","O11"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/:in-range"}],description:"Used in conjunction with the min and max attributes, whether on a range input, a number field, or any other types that accept those attributes."},{name:":invalid",references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/:invalid"}],description:"An element is :valid or :invalid when it is, respectively, valid or invalid with respect to data validity semantics defined by a different specification."},{name:":lang()",browsers:["E","C","FF1","IE8","O8","S3"],description:"Represents an element that is in language specified."},{name:":last-child",references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/:last-child"}],description:"Same as :nth-last-child(1). Represents an element that is the last child of some other element."},{name:":last-of-type",references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/:last-of-type"}],description:"Same as :nth-last-of-type(1). Represents an element that is the last sibling of its type in the list of children of its parent element."},{name:":left",browsers:["E12","S5.1","C6","IE8","O9.2"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/:left"}],description:"When printing double-sided documents, the page boxes on left and right pages may be different. This can be expressed through CSS pseudo-classes defined in the  page context."},{name:":link",references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/:link"}],description:"Applies to links that have not yet been visited."},{name:":matches()",browsers:["S9"],description:"Takes a selector list as its argument. It represents an element that is represented by its argument."},{name:":-moz-any()",browsers:["FF4"],description:"Represents an element that is represented by the selector list passed as its argument. Standardized as :matches()."},{name:":-moz-any-link",browsers:["FF1"],description:"Represents an element that acts as the source anchor of a hyperlink. Applies to both visited and unvisited links."},{name:":-moz-broken",browsers:["FF3"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/:-moz-broken"}],description:"Non-standard. Matches elements representing broken images."},{name:":-moz-drag-over",browsers:["FF1"],description:"Non-standard. Matches elements when a drag-over event applies to it."},{name:":-moz-first-node",browsers:["FF1"],description:"Non-standard. Represents an element that is the first child node of some other element."},{name:":-moz-focusring",browsers:["FF4"],description:"Non-standard. Matches an element that has focus and focus ring drawing is enabled in the browser."},{name:":-moz-full-screen",browsers:["FF9"],description:"Matches any element that has its fullscreen flag set. Standardized as :fullscreen."},{name:":-moz-last-node",browsers:["FF1"],description:"Non-standard. Represents an element that is the last child node of some other element."},{name:":-moz-loading",browsers:["FF3"],description:"Non-standard. Matches elements, such as images, that haven’t started loading yet."},{name:":-moz-only-whitespace",browsers:["FF1"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/:-moz-only-whitespace"}],description:"The same as :empty, except that it additionally matches elements that only contain code points affected by whitespace processing. Standardized as :blank."},{name:":-moz-placeholder",browsers:["FF4"],description:"Deprecated. Represents placeholder text in an input field. Use ::-moz-placeholder for Firefox 19+."},{name:":-moz-submit-invalid",browsers:["FF88"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/:-moz-submit-invalid"}],description:"Non-standard. Represents any submit button when the contents of the associated form are not valid."},{name:":-moz-suppressed",browsers:["FF3"],description:"Non-standard. Matches elements representing images that have been blocked from loading."},{name:":-moz-ui-invalid",browsers:["FF4"],description:"Non-standard. Represents any validated form element whose value isn't valid "},{name:":-moz-ui-valid",browsers:["FF4"],description:"Non-standard. Represents any validated form element whose value is valid "},{name:":-moz-user-disabled",browsers:["FF3"],description:"Non-standard. Matches elements representing images that have been disabled due to the user’s preferences."},{name:":-moz-window-inactive",browsers:["FF4"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/:-moz-window-inactive"}],description:"Non-standard. Matches elements in an inactive window."},{name:":-ms-fullscreen",browsers:["IE11"],description:"Matches any element that has its fullscreen flag set."},{name:":-ms-input-placeholder",browsers:["IE10"],description:"Represents placeholder text in an input field. Note: for Edge use the pseudo-element ::-ms-input-placeholder. Standardized as ::placeholder."},{name:":-ms-keyboard-active",browsers:["IE10"],description:"Windows Store apps only. Applies one or more styles to an element when it has focus and the user presses the space bar."},{name:":-ms-lang()",browsers:["E","IE10"],description:"Represents an element that is in the language specified. Accepts a comma separated list of language tokens."},{name:":no-button",browsers:["C","S5"],description:"Non-standard. Applies to track pieces. Applies when there is no button at that end of the track."},{name:":not()",browsers:["E","C","FF1","IE9","O9.5","S2"],description:"The negation pseudo-class, :not(X), is a functional notation taking a simple selector (excluding the negation pseudo-class itself) as an argument. It represents an element that is not represented by its argument."},{name:":nth-child()",browsers:["E","C","FF3.5","IE9","O9.5","S3.1"],description:"Represents an element that has an+b-1 siblings before it in the document tree, for any positive integer or zero value of n, and has a parent element."},{name:":nth-last-child()",browsers:["E","C","FF3.5","IE9","O9.5","S3.1"],description:"Represents an element that has an+b-1 siblings after it in the document tree, for any positive integer or zero value of n, and has a parent element."},{name:":nth-last-of-type()",browsers:["E","C","FF3.5","IE9","O9.5","S3.1"],description:"Represents an element that has an+b-1 siblings with the same expanded element name after it in the document tree, for any zero or positive integer value of n, and has a parent element."},{name:":nth-of-type()",browsers:["E","C","FF3.5","IE9","O9.5","S3.1"],description:"Represents an element that has an+b-1 siblings with the same expanded element name before it in the document tree, for any zero or positive integer value of n, and has a parent element."},{name:":only-child",references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/:only-child"}],description:"Represents an element that has a parent element and whose parent element has no other element children. Same as :first-child:last-child or :nth-child(1):nth-last-child(1), but with a lower specificity."},{name:":only-of-type",references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/:only-of-type"}],description:"Matches every element that is the only child of its type, of its parent. Same as :first-of-type:last-of-type or :nth-of-type(1):nth-last-of-type(1), but with a lower specificity."},{name:":optional",references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/:optional"}],description:"A form element is :required or :optional if a value for it is, respectively, required or optional before the form it belongs to is submitted. Elements that are not form elements are neither required nor optional."},{name:":out-of-range",browsers:["E13","FF29","S5.1","C10","O11"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/:out-of-range"}],description:"Used in conjunction with the min and max attributes, whether on a range input, a number field, or any other types that accept those attributes."},{name:":past",browsers:["S7"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/:past"}],description:"Represents any element that is defined to occur entirely prior to a :current element."},{name:":read-only",browsers:["E13","FF78","S4","C1","O9"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/:read-only"}],description:"An element whose contents are not user-alterable is :read-only. However, elements whose contents are user-alterable (such as text input fields) are considered to be in a :read-write state. In typical documents, most elements are :read-only."},{name:":read-write",browsers:["E13","FF78","S4","C1","O9"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/:read-write"}],description:"An element whose contents are not user-alterable is :read-only. However, elements whose contents are user-alterable (such as text input fields) are considered to be in a :read-write state. In typical documents, most elements are :read-only."},{name:":required",references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/:required"}],description:"A form element is :required or :optional if a value for it is, respectively, required or optional before the form it belongs to is submitted. Elements that are not form elements are neither required nor optional."},{name:":right",browsers:["E12","S5.1","C6","IE8","O9.2"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/:right"}],description:"When printing double-sided documents, the page boxes on left and right pages may be different. This can be expressed through CSS pseudo-classes defined in the  page context."},{name:":root",references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/:root"}],description:"Represents an element that is the root of the document. In HTML 4, this is always the HTML element."},{name:":scope",browsers:["E79","FF32","S7","C27","O15"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/:scope"}],description:"Represents any element that is in the contextual reference element set."},{name:":single-button",browsers:["C","S5"],description:"Non-standard. Applies to buttons and track pieces. Applies when both buttons are displayed separately at either end of the scrollbar."},{name:":start",browsers:["C","S5"],description:"Non-standard. Applies to buttons and track pieces. Indicates whether the object is placed before the thumb."},{name:":target",references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/:target"}],description:"Some URIs refer to a location within a resource. This kind of URI ends with a 'number sign' (#) followed by an anchor identifier (called the fragment identifier)."},{name:":valid",references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/:valid"}],description:"An element is :valid or :invalid when it is, respectively, valid or invalid with respect to data validity semantics defined by a different specification."},{name:":vertical",browsers:["C","S5"],description:"Non-standard. Applies to any scrollbar pieces that have a vertical orientation."},{name:":visited",references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/:visited"}],description:"Applies once the link has been visited by the user."},{name:":-webkit-any()",browsers:["C","S5"],description:"Represents an element that is represented by the selector list passed as its argument. Standardized as :matches()."},{name:":-webkit-full-screen",browsers:["C","S6"],description:"Matches any element that has its fullscreen flag set. Standardized as :fullscreen."},{name:":window-inactive",browsers:["C","S3"],description:"Non-standard. Applies to all scrollbar pieces. Indicates whether or not the window containing the scrollbar is currently active."},{name:":current",status:"experimental",description:"The :current CSS pseudo-class selector is a time-dimensional pseudo-class that represents the element, or an ancestor of the element, that is currently being displayed"},{name:":blank",status:"experimental",references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/:blank"}],description:"The :blank CSS pseudo-class selects empty user input elements (eg. <input> or <textarea>)."},{name:":defined",status:"experimental",browsers:["E79","FF63","S10","C54","O41"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/:defined"}],description:"The :defined CSS pseudo-class represents any element that has been defined. This includes any standard element built in to the browser, and custom elements that have been successfully defined (i.e. with the CustomElementRegistry.define() method)."},{name:":dir",browsers:["FF49"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/:dir"}],description:"The :dir() CSS pseudo-class matches elements based on the directionality of the text contained in them."},{name:":focus-visible",browsers:["E86","FF85","C86","O72"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/:focus-visible"}],description:"The :focus-visible pseudo-class applies while an element matches the :focus pseudo-class and the UA determines via heuristics that the focus should be made evident on the element."},{name:":focus-within",browsers:["E79","FF52","S10.1","C60","O47"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/:focus-within"}],description:"The :focus-within pseudo-class applies to any element for which the :focus pseudo class applies as well as to an element whose descendant in the flat tree (including non-element nodes, such as text nodes) matches the conditions for matching :focus."},{name:":has",status:"experimental",browsers:["Spreview"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/:has"}],description:":The :has() CSS pseudo-class represents an element if any of the selectors passed as parameters (relative to the :scope of the given element), match at least one element."},{name:":is",status:"experimental",browsers:["E88","FF78","S14","C88","O74"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/:is"}],description:"The :is() CSS pseudo-class function takes a selector list as its argument, and selects any element that can be selected by one of the selectors in that list. This is useful for writing large selectors in a more compact form."},{name:":local-link",status:"experimental",description:"The :local-link CSS pseudo-class represents an link to the same document"},{name:":nth-col",status:"experimental",description:"The :nth-col() CSS pseudo-class is designed for tables and grids. It accepts the An+B notation such as used with the :nth-child selector, using this to target every nth column. "},{name:":nth-last-col",status:"experimental",description:"The :nth-last-col() CSS pseudo-class is designed for tables and grids. It accepts the An+B notation such as used with the :nth-child selector, using this to target every nth column before it, therefore counting back from the end of the set of columns."},{name:":paused",status:"experimental",description:"The :paused CSS pseudo-class selector is a resource state pseudo-class that will match an audio, video, or similar resource that is capable of being “played” or “paused”, when that element is “paused”."},{name:":placeholder-shown",status:"experimental",references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/:placeholder-shown"}],description:"The :placeholder-shown CSS pseudo-class represents any <input> or <textarea> element that is currently displaying placeholder text."},{name:":playing",status:"experimental",description:"The :playing CSS pseudo-class selector is a resource state pseudo-class that will match an audio, video, or similar resource that is capable of being “played” or “paused”, when that element is “playing”. "},{name:":target-within",status:"experimental",references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/:target-within"}],description:"The :target-within CSS pseudo-class represents an element that is a target element or contains an element that is a target. A target element is a unique element with an id matching the URL's fragment."},{name:":user-invalid",status:"experimental",browsers:["FF88"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/:user-invalid"}],description:"The :user-invalid CSS pseudo-class represents any validated form element whose value isn't valid based on their validation constraints, after the user has interacted with it."},{name:":user-valid",status:"experimental",browsers:["FF88"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/:user-valid"}],description:"The :user-valid CSS pseudo-class represents any validated form element whose value validates correctly based on its validation constraints. However, unlike :valid it only matches once the user has interacted with it."},{name:":where",status:"experimental",browsers:["E88","FF78","S14","C88","O74"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/:where"}],description:"The :where() CSS pseudo-class function takes a selector list as its argument, and selects any element that can be selected by one of the selectors in that list."},{name:":picture-in-picture",status:"experimental",description:"The :picture-in-picture CSS pseudo-class matches the element which is currently in picture-in-picture mode."}],pseudoElements:[{name:"::after",references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/::after"}],description:"Represents a styleable child pseudo-element immediately after the originating element’s actual content."},{name:"::backdrop",references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/::backdrop"}],description:"Used to create a backdrop that hides the underlying document for an element in a top layer (such as an element that is displayed fullscreen)."},{name:"::before",references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/::before"}],description:"Represents a styleable child pseudo-element immediately before the originating element’s actual content."},{name:"::content",browsers:["C35","O22"],description:"Deprecated. Matches the distribution list itself, on elements that have one. Use ::slotted for forward compatibility."},{name:"::cue",browsers:["E79","FF55","S7","C26","O15"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/::cue"}]},{name:"::cue()",browsers:["C","O16","S6"]},{name:"::cue-region",browsers:["C","O16","S6"]},{name:"::cue-region()",browsers:["C","O16","S6"]},{name:"::first-letter",references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/::first-letter"}],description:"Represents the first letter of an element, if it is not preceded by any other content (such as images or inline tables) on its line."},{name:"::first-line",references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/::first-line"}],description:"Describes the contents of the first formatted line of its originating element."},{name:"::-moz-focus-inner",browsers:["FF4"]},{name:"::-moz-focus-outer",browsers:["FF4"]},{name:"::-moz-list-bullet",browsers:["FF1"],description:"Used to style the bullet of a list element. Similar to the standardized ::marker."},{name:"::-moz-list-number",browsers:["FF1"],description:"Used to style the numbers of a list element. Similar to the standardized ::marker."},{name:"::-moz-placeholder",browsers:["FF19"],description:"Represents placeholder text in an input field"},{name:"::-moz-progress-bar",browsers:["FF9"],description:"Represents the bar portion of a progress bar."},{name:"::-moz-selection",browsers:["FF1"],description:"Represents the portion of a document that has been highlighted by the user."},{name:"::-ms-backdrop",browsers:["IE11"],description:"Used to create a backdrop that hides the underlying document for an element in a top layer (such as an element that is displayed fullscreen)."},{name:"::-ms-browse",browsers:["E","IE10"],description:"Represents the browse button of an input type=file control."},{name:"::-ms-check",browsers:["E","IE10"],description:"Represents the check of a checkbox or radio button input control."},{name:"::-ms-clear",browsers:["E","IE10"],description:"Represents the clear button of a text input control"},{name:"::-ms-expand",browsers:["E","IE10"],description:"Represents the drop-down button of a select control."},{name:"::-ms-fill",browsers:["E","IE10"],description:"Represents the bar portion of a progress bar."},{name:"::-ms-fill-lower",browsers:["E","IE10"],description:"Represents the portion of the slider track from its smallest value up to the value currently selected by the thumb. In a left-to-right layout, this is the portion of the slider track to the left of the thumb."},{name:"::-ms-fill-upper",browsers:["E","IE10"],description:"Represents the portion of the slider track from the value currently selected by the thumb up to the slider's largest value. In a left-to-right layout, this is the portion of the slider track to the right of the thumb."},{name:"::-ms-reveal",browsers:["E","IE10"],description:"Represents the password reveal button of an input type=password control."},{name:"::-ms-thumb",browsers:["E","IE10"],description:"Represents the portion of range input control (also known as a slider control) that the user drags."},{name:"::-ms-ticks-after",browsers:["E","IE10"],description:"Represents the tick marks of a slider that begin just after the thumb and continue up to the slider's largest value. In a left-to-right layout, these are the ticks to the right of the thumb."},{name:"::-ms-ticks-before",browsers:["E","IE10"],description:"Represents the tick marks of a slider that represent its smallest values up to the value currently selected by the thumb. In a left-to-right layout, these are the ticks to the left of the thumb."},{name:"::-ms-tooltip",browsers:["E","IE10"],description:"Represents the tooltip of a slider (input type=range)."},{name:"::-ms-track",browsers:["E","IE10"],description:"Represents the track of a slider."},{name:"::-ms-value",browsers:["E","IE10"],description:"Represents the content of a text or password input control, or a select control."},{name:"::selection",references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/::selection"}],description:"Represents the portion of a document that has been highlighted by the user."},{name:"::shadow",browsers:["C35","O22"],description:"Matches the shadow root if an element has a shadow tree."},{name:"::-webkit-file-upload-button",browsers:["C","O","S6"]},{name:"::-webkit-inner-spin-button",browsers:["E79","S5","C6","O15"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/::-webkit-inner-spin-button"}]},{name:"::-webkit-input-placeholder",browsers:["C","S4"]},{name:"::-webkit-keygen-select",browsers:["C","O","S6"]},{name:"::-webkit-meter-bar",browsers:["E79","S5.1","C12","O15"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/::-webkit-meter-bar"}]},{name:"::-webkit-meter-even-less-good-value",browsers:["E79","S5.1","C12","O15"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/::-webkit-meter-even-less-good-value"}]},{name:"::-webkit-meter-optimum-value",browsers:["E79","S5.1","C12","O15"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/::-webkit-meter-optimum-value"}]},{name:"::-webkit-meter-suboptimum-value",browsers:["E79","S5.1","C12","O15"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/::-webkit-meter-suboptimum-value"}]},{name:"::-webkit-outer-spin-button",browsers:["S5","C6"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/::-webkit-outer-spin-button"}]},{name:"::-webkit-progress-bar",browsers:["E79","S7","C25","O15"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/::-webkit-progress-bar"}]},{name:"::-webkit-progress-inner-element",browsers:["E79","S7","C23","O15"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/::-webkit-progress-inner-element"}]},{name:"::-webkit-progress-value",browsers:["E79","S7","C25","O15"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/::-webkit-progress-value"}]},{name:"::-webkit-resizer",browsers:["E79","S4","C2","O15"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/::-webkit-scrollbar"}]},{name:"::-webkit-scrollbar",browsers:["E79","S4","C2","O15"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/::-webkit-scrollbar"}]},{name:"::-webkit-scrollbar-button",browsers:["E79","S4","C2","O15"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/::-webkit-scrollbar"}]},{name:"::-webkit-scrollbar-corner",browsers:["E79","S4","C2","O15"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/::-webkit-scrollbar"}]},{name:"::-webkit-scrollbar-thumb",browsers:["E79","S4","C2","O15"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/::-webkit-scrollbar"}]},{name:"::-webkit-scrollbar-track",browsers:["E79","S4","C2","O15"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/::-webkit-scrollbar"}]},{name:"::-webkit-scrollbar-track-piece",browsers:["E79","S4","C2","O15"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/::-webkit-scrollbar"}]},{name:"::-webkit-search-cancel-button",browsers:["E79","S3","C1","O15"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/::-webkit-search-cancel-button"}]},{name:"::-webkit-search-decoration",browsers:["C","S4"]},{name:"::-webkit-search-results-button",browsers:["E79","S3","C1","O15"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/::-webkit-search-results-button"}]},{name:"::-webkit-search-results-decoration",browsers:["C","S4"]},{name:"::-webkit-slider-runnable-track",browsers:["C","O","S6"]},{name:"::-webkit-slider-thumb",browsers:["C","O","S6"]},{name:"::-webkit-textfield-decoration-container",browsers:["C","O","S6"]},{name:"::-webkit-validation-bubble",browsers:["C","O","S6"]},{name:"::-webkit-validation-bubble-arrow",browsers:["C","O","S6"]},{name:"::-webkit-validation-bubble-arrow-clipper",browsers:["C","O","S6"]},{name:"::-webkit-validation-bubble-heading",browsers:["C","O","S6"]},{name:"::-webkit-validation-bubble-message",browsers:["C","O","S6"]},{name:"::-webkit-validation-bubble-text-block",browsers:["C","O","S6"]},{name:"::target-text",status:"experimental",browsers:["E89","C89","O75"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/::target-text"}],description:"The ::target-text CSS pseudo-element represents the text that has been scrolled to if the browser supports scroll-to-text fragments. It allows authors to choose how to highlight that section of text."},{name:"::-moz-range-progress",status:"nonstandard",browsers:["FF22"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/::-moz-range-progress"}],description:'The ::-moz-range-progress CSS pseudo-element is a Mozilla extension that represents the lower portion of the track (i.e., groove) in which the indicator slides in an <input> of type="range". This portion corresponds to values lower than the value currently selected by the thumb (i.e., virtual knob).'},{name:"::-moz-range-thumb",status:"nonstandard",browsers:["FF21"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/::-moz-range-thumb"}],description:'The ::-moz-range-thumb CSS pseudo-element is a Mozilla extension that represents the thumb (i.e., virtual knob) of an <input> of type="range". The user can move the thumb along the input\'s track to alter its numerical value.'},{name:"::-moz-range-track",status:"nonstandard",browsers:["FF21"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/::-moz-range-track"}],description:'The ::-moz-range-track CSS pseudo-element is a Mozilla extension that represents the track (i.e., groove) in which the indicator slides in an <input> of type="range".'},{name:"::-webkit-progress-inner-value",status:"nonstandard",description:"The ::-webkit-progress-value CSS pseudo-element represents the filled-in portion of the bar of a <progress> element. It is a child of the ::-webkit-progress-bar pseudo-element.\n\nIn order to let ::-webkit-progress-value take effect, -webkit-appearance needs to be set to none on the <progress> element."},{name:"::grammar-error",status:"experimental",references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/::grammar-error"}],description:"The ::grammar-error CSS pseudo-element represents a text segment which the user agent has flagged as grammatically incorrect."},{name:"::marker",browsers:["E86","FF68","S11.1","C86","O72"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/::marker"}],description:"The ::marker CSS pseudo-element selects the marker box of a list item, which typically contains a bullet or number. It works on any element or pseudo-element set to display: list-item, such as the <li> and <summary> elements."},{name:"::part",status:"experimental",browsers:["E79","FF72","S13.1","C73","O60"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/::part"}],description:"The ::part CSS pseudo-element represents any element within a shadow tree that has a matching part attribute."},{name:"::placeholder",browsers:["E79","FF51","S10.1","C57","O44"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/::placeholder"}],description:"The ::placeholder CSS pseudo-element represents the placeholder text of a form element."},{name:"::slotted",browsers:["E79","FF63","S10","C50","O37"],references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/::slotted"}],description:"The :slotted() CSS pseudo-element represents any element that has been placed into a slot inside an HTML template."},{name:"::spelling-error",status:"experimental",references:[{name:"MDN Reference",url:"https://developer.mozilla.org/docs/Web/CSS/::spelling-error"}],description:"The ::spelling-error CSS pseudo-element represents a text segment which the user agent has flagged as incorrectly spelled."}]},Ms=function(){function n(l){this._properties=[],this._atDirectives=[],this._pseudoClasses=[],this._pseudoElements=[],this.addData(l)}return n.prototype.provideProperties=function(){return this._properties},n.prototype.provideAtDirectives=function(){return this._atDirectives},n.prototype.providePseudoClasses=function(){return this._pseudoClasses},n.prototype.providePseudoElements=function(){return this._pseudoElements},n.prototype.addData=function(l){if(Array.isArray(l.properties))for(var h=0,m=l.properties;h<m.length;h++){Ns(z=m[h])&&this._properties.push(z)}if(Array.isArray(l.atDirectives))for(var b=0,y=l.atDirectives;b<y.length;b++){_s(z=y[b])&&this._atDirectives.push(z)}if(Array.isArray(l.pseudoClasses))for(var w=0,x=l.pseudoClasses;w<x.length;w++){Os(z=x[w])&&this._pseudoClasses.push(z)}if(Array.isArray(l.pseudoElements))for(var F=0,E=l.pseudoElements;F<E.length;F++){var z;Ws(z=E[F])&&this._pseudoElements.push(z)}},n}();function Ns(l){return"string"==typeof l.name}function _s(l){return"string"==typeof l.name}function Os(l){return"string"==typeof l.name}function Ws(l){return"string"==typeof l.name}var Ls=function(){function n(l){this.dataProviders=[],this._propertySet={},this._atDirectiveSet={},this._pseudoClassSet={},this._pseudoElementSet={},this._properties=[],this._atDirectives=[],this._pseudoClasses=[],this._pseudoElements=[],this.setDataProviders(!1!==(null==l?void 0:l.useDefaultDataProvider),(null==l?void 0:l.customDataProviders)||[])}return n.prototype.setDataProviders=function(l,h){var m;this.dataProviders=[],l&&this.dataProviders.push(new Ms(Is)),(m=this.dataProviders).push.apply(m,h),this.collectData()},n.prototype.collectData=function(){var l=this;this._propertySet={},this._atDirectiveSet={},this._pseudoClassSet={},this._pseudoElementSet={},this.dataProviders.forEach((function(h){h.provideProperties().forEach((function(h){l._propertySet[h.name]||(l._propertySet[h.name]=h)})),h.provideAtDirectives().forEach((function(h){l._atDirectiveSet[h.name]||(l._atDirectiveSet[h.name]=h)})),h.providePseudoClasses().forEach((function(h){l._pseudoClassSet[h.name]||(l._pseudoClassSet[h.name]=h)})),h.providePseudoElements().forEach((function(h){l._pseudoElementSet[h.name]||(l._pseudoElementSet[h.name]=h)}))})),this._properties=Wt(this._propertySet),this._atDirectives=Wt(this._atDirectiveSet),this._pseudoClasses=Wt(this._pseudoClassSet),this._pseudoElements=Wt(this._pseudoElementSet)},n.prototype.getProperty=function(l){return this._propertySet[l]},n.prototype.getAtDirective=function(l){return this._atDirectiveSet[l]},n.prototype.getPseudoClass=function(l){return this._pseudoClassSet[l]},n.prototype.getPseudoElement=function(l){return this._pseudoElementSet[l]},n.prototype.getProperties=function(){return this._properties},n.prototype.getAtDirectives=function(){return this._atDirectives},n.prototype.getPseudoClasses=function(){return this._pseudoClasses},n.prototype.getPseudoElements=function(){return this._pseudoElements},n.prototype.isKnownProperty=function(l){return l.toLowerCase()in this._propertySet},n.prototype.isStandardProperty=function(l){return this.isKnownProperty(l)&&(!this._propertySet[l.toLowerCase()].status||"standard"===this._propertySet[l.toLowerCase()].status)},n}();function Bo(l,h,m){return h.map((function r(h){for(var b=function i(h){var b=l.offsetAt(h),y=m.findChildAtOffset(b,!0);if(!y)return[];for(var w=[];y;)y.parent&&y.offset===y.parent.offset&&y.end===y.parent.end||(y.type===Ee.Declarations&&b>y.offset&&b<y.end&&w.push([y.offset+1,y.end-1]),w.push([y.offset,y.end])),y=y.parent;return w}(h),y=void 0,w=b.length-1;w>=0;w--)y=Tr.create(bn.create(l.positionAt(b[w][0]),l.positionAt(b[w][1])),y);return y||(y=Tr.create(bn.create(h,h))),y}))}var Vs=function(){var n=function(l,h){return(n=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(l,h){l.__proto__=h}||function(l,h){for(var m in h)Object.prototype.hasOwnProperty.call(h,m)&&(l[m]=h[m])})(l,h)};return function(l,h){if("function"!=typeof h&&null!==h)throw new TypeError("Class extends value "+String(h)+" is not a constructor or null");function r(){this.constructor=l}n(l,h),l.prototype=null===h?Object.create(h):(r.prototype=h.prototype,new r)}}(),Us=function(l,h,m,b){return new(m||(m=Promise))((function(y,w){function s(l){try{c(b.next(l))}catch(l){w(l)}}function d(l){try{c(b.throw(l))}catch(l){w(l)}}function c(l){l.done?y(l.value):function i(l){return l instanceof m?l:new m((function(h){h(l)}))}(l.value).then(s,d)}c((b=b.apply(l,h||[])).next())}))},js=function(l,h){var m,b,y,w,x={label:0,sent:function(){if(1&y[0])throw y[1];return y[1]},trys:[],ops:[]};return w={next:s(0),throw:s(1),return:s(2)},"function"==typeof Symbol&&(w[Symbol.iterator]=function(){return this}),w;function s(w){return function(F){return function d(w){if(m)throw new TypeError("Generator is already executing.");for(;x;)try{if(m=1,b&&(y=2&w[0]?b.return:w[0]?b.throw||((y=b.return)&&y.call(b),0):b.next)&&!(y=y.call(b,w[1])).done)return y;switch(b=0,y&&(w=[2&w[0],y.value]),w[0]){case 0:case 1:y=w;break;case 4:return x.label++,{value:w[1],done:!1};case 5:x.label++,b=w[1],w=[0];continue;case 7:w=x.ops.pop(),x.trys.pop();continue;default:if(!(y=(y=x.trys).length>0&&y[y.length-1])&&(6===w[0]||2===w[0])){x=0;continue}if(3===w[0]&&(!y||w[1]>y[0]&&w[1]<y[3])){x.label=w[1];break}if(6===w[0]&&x.label<y[1]){x.label=y[1],y=w;break}if(y&&x.label<y[2]){x.label=y[2],x.ops.push(w);break}y[2]&&x.ops.pop(),x.trys.pop();continue}w=h.call(l,x)}catch(l){w=[6,l],b=0}finally{m=y=0}if(5&w[0])throw w[1];return{value:w[0]?w[1]:void 0,done:!0}}([w,F])}}},$s=function(l){function e(h){return l.call(this,h,!0)||this}return Vs(e,l),e.prototype.isRawStringDocumentLinkNode=function(h){return l.prototype.isRawStringDocumentLinkNode.call(this,h)||h.type===Ee.Use||h.type===Ee.Forward},e.prototype.resolveRelativeReference=function(h,m,b,y){return Us(this,void 0,void 0,(function(){var w,x,F,E;return js(this,(function(z){switch(z.label){case 0:return V(h,"sass:")?[2,void 0]:[4,l.prototype.resolveRelativeReference.call(this,h,m,b,y)];case 1:if(w=z.sent(),!(this.fileSystemProvider&&w&&y))return[3,8];x=vi.parse(w),z.label=2;case 2:if(z.trys.push([2,7,,8]),F=function a(l){if(""!==l.path&&!l.path.endsWith(".scss")&&!l.path.endsWith(".css")){if(l.path.endsWith("/"))return[l.with({path:l.path+"index.scss"}).toString(),l.with({path:l.path+"_index.scss"}).toString()];var h=l.path.split("/"),m=h[h.length-1],b=l.path.slice(0,-m.length);if(m.startsWith("_"))return l.path.endsWith(".scss")?void 0:[l.with({path:l.path+".scss"}).toString()];var y=m+".scss",I=function(h){return l.with({path:b+h}).toString()};return[I(y),I("_"+y),I(y.slice(0,-5)+"/index.scss"),I(y.slice(0,-5)+"/_index.scss"),I(y.slice(0,-5)+".css")]}}(x),!F)return[3,6];E=0,z.label=3;case 3:return E<F.length?[4,this.fileExists(F[E])]:[3,6];case 4:if(z.sent())return[2,F[E]];z.label=5;case 5:return E++,[3,3];case 6:return[3,8];case 7:return z.sent(),[3,8];case 8:return[2,w]}}))}))},e}($i);function qo(l){return new Ms(l)}function Ur(l,h,m,b,y,w,x){return{configure:function(l){w.configure(l),h.configure(null==l?void 0:l.completion),m.configure(null==l?void 0:l.hover)},setDataProviders:x.setDataProviders.bind(x),doValidation:w.doValidation.bind(w),parseStylesheet:l.parseStylesheet.bind(l),doComplete:h.doComplete.bind(h),doComplete2:h.doComplete2.bind(h),setCompletionParticipants:h.setCompletionParticipants.bind(h),doHover:m.doHover.bind(m),findDefinition:b.findDefinition.bind(b),findReferences:b.findReferences.bind(b),findDocumentHighlights:b.findDocumentHighlights.bind(b),findDocumentLinks:b.findDocumentLinks.bind(b),findDocumentLinks2:b.findDocumentLinks2.bind(b),findDocumentSymbols:b.findDocumentSymbols.bind(b),doCodeActions:y.doCodeActions.bind(y),doCodeActions2:y.doCodeActions2.bind(y),findDocumentColors:b.findDocumentColors.bind(b),getColorPresentations:b.getColorPresentations.bind(b),doRename:b.doRename.bind(b),getFoldingRanges:Vo,getSelectionRanges:Bo}}var Ks={};var qs=class{_ctx;_languageService;_languageSettings;_languageId;constructor(l,h){this._ctx=l,this._languageSettings=h.options,this._languageId=h.languageId;let m=h.options.data,b=m?.useDefaultDataProvider,y=[];if(m?.dataProviders)for(let l in m.dataProviders)y.push(qo(m.dataProviders[l]));let w={customDataProviders:y,useDefaultDataProvider:b};switch(this._languageId){case"css":this._languageService=function Ko(l){void 0===l&&(l=Ks);var h=new Ls(l);return Ur(new di,new Ei(null,l,h),new Ui(l&&l.clientCapabilities,h),new $i(l&&l.fileSystemProvider,!1),new ho(h),new wo(h),h)}(w);break;case"less":this._languageService=function Ho(l){void 0===l&&(l=Ks);var h=new Ls(l);return Ur(new zs,new Ts(l,h),new Ui(l&&l.clientCapabilities,h),new $i(l&&l.fileSystemProvider,!0),new ho(h),new wo(h),h)}(w);break;case"scss":this._languageService=function Go(l){void 0===l&&(l=Ks);var h=new Ls(l);return Ur(new hs,new fs(l,h),new Ui(l&&l.clientCapabilities,h),new $s(l&&l.fileSystemProvider),new ho(h),new wo(h),h)}(w);break;default:throw new Error("Invalid language id: "+this._languageId)}this._languageService.configure(this._languageSettings)}async doValidation(l){let h=this._getTextDocument(l);if(h){let l=this._languageService.parseStylesheet(h),m=this._languageService.doValidation(h,l);return Promise.resolve(m)}return Promise.resolve([])}async doComplete(l,h){let m=this._getTextDocument(l);if(!m)return null;let b=this._languageService.parseStylesheet(m),y=this._languageService.doComplete(m,h,b);return Promise.resolve(y)}async doHover(l,h){let m=this._getTextDocument(l);if(!m)return null;let b=this._languageService.parseStylesheet(m),y=this._languageService.doHover(m,h,b);return Promise.resolve(y)}async findDefinition(l,h){let m=this._getTextDocument(l);if(!m)return null;let b=this._languageService.parseStylesheet(m),y=this._languageService.findDefinition(m,h,b);return Promise.resolve(y)}async findReferences(l,h){let m=this._getTextDocument(l);if(!m)return[];let b=this._languageService.parseStylesheet(m),y=this._languageService.findReferences(m,h,b);return Promise.resolve(y)}async findDocumentHighlights(l,h){let m=this._getTextDocument(l);if(!m)return[];let b=this._languageService.parseStylesheet(m),y=this._languageService.findDocumentHighlights(m,h,b);return Promise.resolve(y)}async findDocumentSymbols(l){let h=this._getTextDocument(l);if(!h)return[];let m=this._languageService.parseStylesheet(h),b=this._languageService.findDocumentSymbols(h,m);return Promise.resolve(b)}async doCodeActions(l,h,m){let b=this._getTextDocument(l);if(!b)return[];let y=this._languageService.parseStylesheet(b),w=this._languageService.doCodeActions(b,h,m,y);return Promise.resolve(w)}async findDocumentColors(l){let h=this._getTextDocument(l);if(!h)return[];let m=this._languageService.parseStylesheet(h),b=this._languageService.findDocumentColors(h,m);return Promise.resolve(b)}async getColorPresentations(l,h,m){let b=this._getTextDocument(l);if(!b)return[];let y=this._languageService.parseStylesheet(b),w=this._languageService.getColorPresentations(b,y,h,m);return Promise.resolve(w)}async getFoldingRanges(l,h){let m=this._getTextDocument(l);if(!m)return[];let b=this._languageService.getFoldingRanges(m,h);return Promise.resolve(b)}async getSelectionRanges(l,h){let m=this._getTextDocument(l);if(!m)return[];let b=this._languageService.parseStylesheet(m),y=this._languageService.getSelectionRanges(m,h,b);return Promise.resolve(y)}async doRename(l,h,m){let b=this._getTextDocument(l);if(!b)return null;let y=this._languageService.parseStylesheet(b),w=this._languageService.doRename(b,h,m,y);return Promise.resolve(w)}_getTextDocument(l){let h=this._ctx.getMirrorModels();for(let m of h)if(m.uri.toString()===l)return Ar.create(l,this._languageId,m.version,m.getValue());return null}};function Bs(l,h){return new qs(l,h)}return x(F)})()));