/*!-----------------------------------------------------------------------------
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Version: 0.32.1(29a273516805a852aa8edc5e05059f119b13eff0)
 * Released under the MIT license
 * https://github.com/microsoft/monaco-editor/blob/main/LICENSE.txt
 *-----------------------------------------------------------------------------*/
define("vs/language/css/cssMode",["require","require"],(a=>(()=>{var c,d=Object.create,h=Object.defineProperty,p=Object.getOwnPropertyDescriptor,v=Object.getOwnPropertyNames,w=Object.getPrototypeOf,b=Object.prototype.hasOwnProperty,le=a=>h(a,"__esModule",{value:!0}),y=(c=function(c){if(void 0!==a)return a.apply(this,arguments);throw new Error('Dynamic require of "'+c+'" is not supported')},void 0!==a?a:"undefined"!=typeof Proxy?new Proxy(c,{get:(c,d)=>(void 0!==a?a:c)[d]}):c),U=(a,c,d,w)=>{if(c&&"object"==typeof c||"function"==typeof c)for(let y of v(c))!b.call(a,y)&&(d||"default"!==y)&&h(a,y,{get:()=>c[y],enumerable:!(w=p(c,y))||w.enumerable});return a},ge=(a,c)=>U(le(h(null!=a?d(w(a)):{},"default",!c&&a&&a.__esModule?{get:()=>a.default,enumerable:!0}:{value:a,enumerable:!0})),a),x=(a=>(c,d)=>a&&a.get(c)||(d=U(le({}),c,1),a&&a.set(c,d),d))("undefined"!=typeof WeakMap?new WeakMap:0),C=((a,c)=>()=>(c||a((c={exports:{}}).exports,c),c.exports))(((a,c)=>{var d=ge(y("vs/editor/editor.api"));c.exports=d})),E={};((a,c)=>{for(var d in c)h(a,d,{get:c[d],enumerable:!0})})(E,{CompletionAdapter:()=>He,DefinitionAdapter:()=>Xe,DiagnosticsAdapter:()=>Ve,DocumentColorAdapter:()=>rt,DocumentFormattingEditProvider:()=>tt,DocumentHighlightAdapter:()=>ze,DocumentLinkAdapter:()=>et,DocumentRangeFormattingEditProvider:()=>nt,DocumentSymbolAdapter:()=>Ge,FoldingRangeAdapter:()=>it,HoverAdapter:()=>Ke,ReferenceAdapter:()=>qe,RenameAdapter:()=>Qe,SelectionRangeAdapter:()=>ot,WorkerManager:()=>ne,fromPosition:()=>_,fromRange:()=>de,setupMode:()=>wn,toRange:()=>T,toTextEdit:()=>S});var A={};U(A,ge(C()));var I,R,D,M,P,L,j,F,O,N,W,V,H,K,z,B,X,$,q,J,Y,Z,Q,G,ee,te,ne=class{_defaults;_idleCheckInterval;_lastUsedTime;_configChangeListener;_worker;_client;constructor(a){this._defaults=a,this._worker=null,this._client=null,this._idleCheckInterval=window.setInterval((()=>this._checkIfIdle()),3e4),this._lastUsedTime=0,this._configChangeListener=this._defaults.onDidChange((()=>this._stopWorker()))}_stopWorker(){this._worker&&(this._worker.dispose(),this._worker=null),this._client=null}dispose(){clearInterval(this._idleCheckInterval),this._configChangeListener.dispose(),this._stopWorker()}_checkIfIdle(){this._worker&&Date.now()-this._lastUsedTime>12e4&&this._stopWorker()}_getClient(){return this._lastUsedTime=Date.now(),this._client||(this._worker=A.editor.createWebWorker({moduleId:"vs/language/css/cssWorker",label:this._defaults.languageId,createData:{options:this._defaults.options,languageId:this._defaults.languageId}}),this._client=this._worker.getProxy()),this._client}getLanguageServiceWorker(...a){let c;return this._getClient().then((a=>{c=a})).then((c=>{if(this._worker)return this._worker.withSyncedResources(a)})).then((a=>c))}};!function(a){a.MIN_VALUE=-2147483648,a.MAX_VALUE=2147483647}(I||(I={})),function(a){a.MIN_VALUE=0,a.MAX_VALUE=2147483647}(R||(R={})),function(a){a.create=function t(a,c){return a===Number.MAX_VALUE&&(a=R.MAX_VALUE),c===Number.MAX_VALUE&&(c=R.MAX_VALUE),{line:a,character:c}},a.is=function i(a){var c=a;return Ue.objectLiteral(c)&&Ue.uinteger(c.line)&&Ue.uinteger(c.character)}}(D||(D={})),function(a){a.create=function t(a,c,d,h){if(Ue.uinteger(a)&&Ue.uinteger(c)&&Ue.uinteger(d)&&Ue.uinteger(h))return{start:D.create(a,c),end:D.create(d,h)};if(D.is(a)&&D.is(c))return{start:a,end:c};throw new Error("Range#create called with invalid arguments["+a+", "+c+", "+d+", "+h+"]")},a.is=function i(a){var c=a;return Ue.objectLiteral(c)&&D.is(c.start)&&D.is(c.end)}}(M||(M={})),function(a){a.create=function t(a,c){return{uri:a,range:c}},a.is=function i(a){var c=a;return Ue.defined(c)&&M.is(c.range)&&(Ue.string(c.uri)||Ue.undefined(c.uri))}}(P||(P={})),function(a){a.create=function t(a,c,d,h){return{targetUri:a,targetRange:c,targetSelectionRange:d,originSelectionRange:h}},a.is=function i(a){var c=a;return Ue.defined(c)&&M.is(c.targetRange)&&Ue.string(c.targetUri)&&(M.is(c.targetSelectionRange)||Ue.undefined(c.targetSelectionRange))&&(M.is(c.originSelectionRange)||Ue.undefined(c.originSelectionRange))}}(L||(L={})),function(a){a.create=function t(a,c,d,h){return{red:a,green:c,blue:d,alpha:h}},a.is=function i(a){var c=a;return Ue.numberRange(c.red,0,1)&&Ue.numberRange(c.green,0,1)&&Ue.numberRange(c.blue,0,1)&&Ue.numberRange(c.alpha,0,1)}}(j||(j={})),function(a){a.create=function t(a,c){return{range:a,color:c}},a.is=function i(a){var c=a;return M.is(c.range)&&j.is(c.color)}}(F||(F={})),function(a){a.create=function t(a,c,d){return{label:a,textEdit:c,additionalTextEdits:d}},a.is=function i(a){var c=a;return Ue.string(c.label)&&(Ue.undefined(c.textEdit)||$.is(c))&&(Ue.undefined(c.additionalTextEdits)||Ue.typedArray(c.additionalTextEdits,$.is))}}(O||(O={})),function(a){a.Comment="comment",a.Imports="imports",a.Region="region"}(N||(N={})),function(a){a.create=function t(a,c,d,h,p){var v={startLine:a,endLine:c};return Ue.defined(d)&&(v.startCharacter=d),Ue.defined(h)&&(v.endCharacter=h),Ue.defined(p)&&(v.kind=p),v},a.is=function i(a){var c=a;return Ue.uinteger(c.startLine)&&Ue.uinteger(c.startLine)&&(Ue.undefined(c.startCharacter)||Ue.uinteger(c.startCharacter))&&(Ue.undefined(c.endCharacter)||Ue.uinteger(c.endCharacter))&&(Ue.undefined(c.kind)||Ue.string(c.kind))}}(W||(W={})),function(a){a.create=function t(a,c){return{location:a,message:c}},a.is=function i(a){var c=a;return Ue.defined(c)&&P.is(c.location)&&Ue.string(c.message)}}(V||(V={})),function(a){a.Error=1,a.Warning=2,a.Information=3,a.Hint=4}(H||(H={})),function(a){a.Unnecessary=1,a.Deprecated=2}(K||(K={})),function(a){a.is=function t(a){var c=a;return null!=c&&Ue.string(c.href)}}(z||(z={})),function(a){a.create=function t(a,c,d,h,p,v){var w={range:a,message:c};return Ue.defined(d)&&(w.severity=d),Ue.defined(h)&&(w.code=h),Ue.defined(p)&&(w.source=p),Ue.defined(v)&&(w.relatedInformation=v),w},a.is=function i(a){var c,d=a;return Ue.defined(d)&&M.is(d.range)&&Ue.string(d.message)&&(Ue.number(d.severity)||Ue.undefined(d.severity))&&(Ue.integer(d.code)||Ue.string(d.code)||Ue.undefined(d.code))&&(Ue.undefined(d.codeDescription)||Ue.string(null===(c=d.codeDescription)||void 0===c?void 0:c.href))&&(Ue.string(d.source)||Ue.undefined(d.source))&&(Ue.undefined(d.relatedInformation)||Ue.typedArray(d.relatedInformation,V.is))}}(B||(B={})),function(a){a.create=function t(a,c){for(var d=[],h=2;h<arguments.length;h++)d[h-2]=arguments[h];var p={title:a,command:c};return Ue.defined(d)&&d.length>0&&(p.arguments=d),p},a.is=function i(a){var c=a;return Ue.defined(c)&&Ue.string(c.title)&&Ue.string(c.command)}}(X||(X={})),function(a){a.replace=function t(a,c){return{range:a,newText:c}},a.insert=function i(a,c){return{range:{start:a,end:a},newText:c}},a.del=function r(a){return{range:a,newText:""}},a.is=function e(a){var c=a;return Ue.objectLiteral(c)&&Ue.string(c.newText)&&M.is(c.range)}}($||($={})),function(a){a.create=function t(a,c,d){var h={label:a};return void 0!==c&&(h.needsConfirmation=c),void 0!==d&&(h.description=d),h},a.is=function i(a){var c=a;return void 0!==c&&Ue.objectLiteral(c)&&Ue.string(c.label)&&(Ue.boolean(c.needsConfirmation)||void 0===c.needsConfirmation)&&(Ue.string(c.description)||void 0===c.description)}}(q||(q={})),function(a){a.is=function t(a){return"string"==typeof a}}(J||(J={})),function(a){a.replace=function t(a,c,d){return{range:a,newText:c,annotationId:d}},a.insert=function i(a,c,d){return{range:{start:a,end:a},newText:c,annotationId:d}},a.del=function r(a,c){return{range:a,newText:"",annotationId:c}},a.is=function e(a){var c=a;return $.is(c)&&(q.is(c.annotationId)||J.is(c.annotationId))}}(Y||(Y={})),function(a){a.create=function t(a,c){return{textDocument:a,edits:c}},a.is=function i(a){var c=a;return Ue.defined(c)&&oe.is(c.textDocument)&&Array.isArray(c.edits)}}(Z||(Z={})),function(a){a.create=function t(a,c,d){var h={kind:"create",uri:a};return void 0!==c&&(void 0!==c.overwrite||void 0!==c.ignoreIfExists)&&(h.options=c),void 0!==d&&(h.annotationId=d),h},a.is=function i(a){var c=a;return c&&"create"===c.kind&&Ue.string(c.uri)&&(void 0===c.options||(void 0===c.options.overwrite||Ue.boolean(c.options.overwrite))&&(void 0===c.options.ignoreIfExists||Ue.boolean(c.options.ignoreIfExists)))&&(void 0===c.annotationId||J.is(c.annotationId))}}(Q||(Q={})),function(a){a.create=function t(a,c,d,h){var p={kind:"rename",oldUri:a,newUri:c};return void 0!==d&&(void 0!==d.overwrite||void 0!==d.ignoreIfExists)&&(p.options=d),void 0!==h&&(p.annotationId=h),p},a.is=function i(a){var c=a;return c&&"rename"===c.kind&&Ue.string(c.oldUri)&&Ue.string(c.newUri)&&(void 0===c.options||(void 0===c.options.overwrite||Ue.boolean(c.options.overwrite))&&(void 0===c.options.ignoreIfExists||Ue.boolean(c.options.ignoreIfExists)))&&(void 0===c.annotationId||J.is(c.annotationId))}}(G||(G={})),function(a){a.create=function t(a,c,d){var h={kind:"delete",uri:a};return void 0!==c&&(void 0!==c.recursive||void 0!==c.ignoreIfNotExists)&&(h.options=c),void 0!==d&&(h.annotationId=d),h},a.is=function i(a){var c=a;return c&&"delete"===c.kind&&Ue.string(c.uri)&&(void 0===c.options||(void 0===c.options.recursive||Ue.boolean(c.options.recursive))&&(void 0===c.options.ignoreIfNotExists||Ue.boolean(c.options.ignoreIfNotExists)))&&(void 0===c.annotationId||J.is(c.annotationId))}}(ee||(ee={})),function(a){a.is=function t(a){var c=a;return c&&(void 0!==c.changes||void 0!==c.documentChanges)&&(void 0===c.documentChanges||c.documentChanges.every((function(a){return Ue.string(a.kind)?Q.is(a)||G.is(a)||ee.is(a):Z.is(a)})))}}(te||(te={}));var re,ie,oe,ae,se,ue,ce,fe,he,pe,ve,me,_e,we,be,ke,ye,xe,Ce,Ee,Ae,Ie,Se,Te,Re,De,Me,Pe,Le,je,Fe,Oe=function(){function n(a,c){this.edits=a,this.changeAnnotations=c}return n.prototype.insert=function(a,c,d){var h,p;if(void 0===d?h=$.insert(a,c):J.is(d)?(p=d,h=Y.insert(a,c,d)):(this.assertChangeAnnotations(this.changeAnnotations),p=this.changeAnnotations.manage(d),h=Y.insert(a,c,p)),this.edits.push(h),void 0!==p)return p},n.prototype.replace=function(a,c,d){var h,p;if(void 0===d?h=$.replace(a,c):J.is(d)?(p=d,h=Y.replace(a,c,d)):(this.assertChangeAnnotations(this.changeAnnotations),p=this.changeAnnotations.manage(d),h=Y.replace(a,c,p)),this.edits.push(h),void 0!==p)return p},n.prototype.delete=function(a,c){var d,h;if(void 0===c?d=$.del(a):J.is(c)?(h=c,d=Y.del(a,c)):(this.assertChangeAnnotations(this.changeAnnotations),h=this.changeAnnotations.manage(c),d=Y.del(a,h)),this.edits.push(d),void 0!==h)return h},n.prototype.add=function(a){this.edits.push(a)},n.prototype.all=function(){return this.edits},n.prototype.clear=function(){this.edits.splice(0,this.edits.length)},n.prototype.assertChangeAnnotations=function(a){if(void 0===a)throw new Error("Text edit change is not configured to manage change annotations.")},n}(),Ne=function(){function n(a){this._annotations=void 0===a?Object.create(null):a,this._counter=0,this._size=0}return n.prototype.all=function(){return this._annotations},Object.defineProperty(n.prototype,"size",{get:function(){return this._size},enumerable:!1,configurable:!0}),n.prototype.manage=function(a,c){var d;if(J.is(a)?d=a:(d=this.nextId(),c=a),void 0!==this._annotations[d])throw new Error("Id "+d+" is already in use.");if(void 0===c)throw new Error("No annotation provided for id "+d);return this._annotations[d]=c,this._size++,d},n.prototype.nextId=function(){return this._counter++,this._counter.toString()},n}();!function(){function n(a){var c=this;this._textEditChanges=Object.create(null),void 0!==a?(this._workspaceEdit=a,a.documentChanges?(this._changeAnnotations=new Ne(a.changeAnnotations),a.changeAnnotations=this._changeAnnotations.all(),a.documentChanges.forEach((function(a){if(Z.is(a)){var d=new Oe(a.edits,c._changeAnnotations);c._textEditChanges[a.textDocument.uri]=d}}))):a.changes&&Object.keys(a.changes).forEach((function(d){var h=new Oe(a.changes[d]);c._textEditChanges[d]=h}))):this._workspaceEdit={}}Object.defineProperty(n.prototype,"edit",{get:function(){return this.initDocumentChanges(),void 0!==this._changeAnnotations&&(0===this._changeAnnotations.size?this._workspaceEdit.changeAnnotations=void 0:this._workspaceEdit.changeAnnotations=this._changeAnnotations.all()),this._workspaceEdit},enumerable:!1,configurable:!0}),n.prototype.getTextEditChange=function(a){if(oe.is(a)){if(this.initDocumentChanges(),void 0===this._workspaceEdit.documentChanges)throw new Error("Workspace edit is not configured for document changes.");var c={uri:a.uri,version:a.version};if(!(h=this._textEditChanges[c.uri])){var d={textDocument:c,edits:p=[]};this._workspaceEdit.documentChanges.push(d),h=new Oe(p,this._changeAnnotations),this._textEditChanges[c.uri]=h}return h}if(this.initChanges(),void 0===this._workspaceEdit.changes)throw new Error("Workspace edit is not configured for normal text edit changes.");var h;if(!(h=this._textEditChanges[a])){var p=[];this._workspaceEdit.changes[a]=p,h=new Oe(p),this._textEditChanges[a]=h}return h},n.prototype.initDocumentChanges=function(){void 0===this._workspaceEdit.documentChanges&&void 0===this._workspaceEdit.changes&&(this._changeAnnotations=new Ne,this._workspaceEdit.documentChanges=[],this._workspaceEdit.changeAnnotations=this._changeAnnotations.all())},n.prototype.initChanges=function(){void 0===this._workspaceEdit.documentChanges&&void 0===this._workspaceEdit.changes&&(this._workspaceEdit.changes=Object.create(null))},n.prototype.createFile=function(a,c,d){if(this.initDocumentChanges(),void 0===this._workspaceEdit.documentChanges)throw new Error("Workspace edit is not configured for document changes.");var h,p,v;if(q.is(c)||J.is(c)?h=c:d=c,void 0===h?p=Q.create(a,d):(v=J.is(h)?h:this._changeAnnotations.manage(h),p=Q.create(a,d,v)),this._workspaceEdit.documentChanges.push(p),void 0!==v)return v},n.prototype.renameFile=function(a,c,d,h){if(this.initDocumentChanges(),void 0===this._workspaceEdit.documentChanges)throw new Error("Workspace edit is not configured for document changes.");var p,v,w;if(q.is(d)||J.is(d)?p=d:h=d,void 0===p?v=G.create(a,c,h):(w=J.is(p)?p:this._changeAnnotations.manage(p),v=G.create(a,c,h,w)),this._workspaceEdit.documentChanges.push(v),void 0!==w)return w},n.prototype.deleteFile=function(a,c,d){if(this.initDocumentChanges(),void 0===this._workspaceEdit.documentChanges)throw new Error("Workspace edit is not configured for document changes.");var h,p,v;if(q.is(c)||J.is(c)?h=c:d=c,void 0===h?p=ee.create(a,d):(v=J.is(h)?h:this._changeAnnotations.manage(h),p=ee.create(a,d,v)),this._workspaceEdit.documentChanges.push(p),void 0!==v)return v}}();!function(a){a.create=function t(a){return{uri:a}},a.is=function i(a){var c=a;return Ue.defined(c)&&Ue.string(c.uri)}}(re||(re={})),function(a){a.create=function t(a,c){return{uri:a,version:c}},a.is=function i(a){var c=a;return Ue.defined(c)&&Ue.string(c.uri)&&Ue.integer(c.version)}}(ie||(ie={})),function(a){a.create=function t(a,c){return{uri:a,version:c}},a.is=function i(a){var c=a;return Ue.defined(c)&&Ue.string(c.uri)&&(null===c.version||Ue.integer(c.version))}}(oe||(oe={})),function(a){a.create=function t(a,c,d,h){return{uri:a,languageId:c,version:d,text:h}},a.is=function i(a){var c=a;return Ue.defined(c)&&Ue.string(c.uri)&&Ue.string(c.languageId)&&Ue.integer(c.version)&&Ue.string(c.text)}}(ae||(ae={})),function(a){a.PlainText="plaintext",a.Markdown="markdown"}(se||(se={})),function(a){a.is=function t(c){var d=c;return d===a.PlainText||d===a.Markdown}}(se||(se={})),function(a){a.is=function t(a){var c=a;return Ue.objectLiteral(a)&&se.is(c.kind)&&Ue.string(c.value)}}(ue||(ue={})),function(a){a.Text=1,a.Method=2,a.Function=3,a.Constructor=4,a.Field=5,a.Variable=6,a.Class=7,a.Interface=8,a.Module=9,a.Property=10,a.Unit=11,a.Value=12,a.Enum=13,a.Keyword=14,a.Snippet=15,a.Color=16,a.File=17,a.Reference=18,a.Folder=19,a.EnumMember=20,a.Constant=21,a.Struct=22,a.Event=23,a.Operator=24,a.TypeParameter=25}(ce||(ce={})),function(a){a.PlainText=1,a.Snippet=2}(fe||(fe={})),function(a){a.Deprecated=1}(he||(he={})),function(a){a.create=function t(a,c,d){return{newText:a,insert:c,replace:d}},a.is=function i(a){var c=a;return c&&Ue.string(c.newText)&&M.is(c.insert)&&M.is(c.replace)}}(pe||(pe={})),function(a){a.asIs=1,a.adjustIndentation=2}(ve||(ve={})),function(a){a.create=function t(a){return{label:a}}}(me||(me={})),function(a){a.create=function t(a,c){return{items:a||[],isIncomplete:!!c}}}(_e||(_e={})),function(a){a.fromPlainText=function t(a){return a.replace(/[\\`*_{}[\]()#+\-.!]/g,"\\$&")},a.is=function i(a){var c=a;return Ue.string(c)||Ue.objectLiteral(c)&&Ue.string(c.language)&&Ue.string(c.value)}}(we||(we={})),function(a){a.is=function t(a){var c=a;return!!c&&Ue.objectLiteral(c)&&(ue.is(c.contents)||we.is(c.contents)||Ue.typedArray(c.contents,we.is))&&(void 0===a.range||M.is(a.range))}}(be||(be={})),function(a){a.create=function t(a,c){return c?{label:a,documentation:c}:{label:a}}}(ke||(ke={})),function(a){a.create=function t(a,c){for(var d=[],h=2;h<arguments.length;h++)d[h-2]=arguments[h];var p={label:a};return Ue.defined(c)&&(p.documentation=c),Ue.defined(d)?p.parameters=d:p.parameters=[],p}}(ye||(ye={})),function(a){a.Text=1,a.Read=2,a.Write=3}(xe||(xe={})),function(a){a.create=function t(a,c){var d={range:a};return Ue.number(c)&&(d.kind=c),d}}(Ce||(Ce={})),function(a){a.File=1,a.Module=2,a.Namespace=3,a.Package=4,a.Class=5,a.Method=6,a.Property=7,a.Field=8,a.Constructor=9,a.Enum=10,a.Interface=11,a.Function=12,a.Variable=13,a.Constant=14,a.String=15,a.Number=16,a.Boolean=17,a.Array=18,a.Object=19,a.Key=20,a.Null=21,a.EnumMember=22,a.Struct=23,a.Event=24,a.Operator=25,a.TypeParameter=26}(Ee||(Ee={})),function(a){a.Deprecated=1}(Ae||(Ae={})),function(a){a.create=function t(a,c,d,h,p){var v={name:a,kind:c,location:{uri:h,range:d}};return p&&(v.containerName=p),v}}(Ie||(Ie={})),function(a){a.create=function t(a,c,d,h,p,v){var w={name:a,detail:c,kind:d,range:h,selectionRange:p};return void 0!==v&&(w.children=v),w},a.is=function i(a){var c=a;return c&&Ue.string(c.name)&&Ue.number(c.kind)&&M.is(c.range)&&M.is(c.selectionRange)&&(void 0===c.detail||Ue.string(c.detail))&&(void 0===c.deprecated||Ue.boolean(c.deprecated))&&(void 0===c.children||Array.isArray(c.children))&&(void 0===c.tags||Array.isArray(c.tags))}}(Se||(Se={})),function(a){a.Empty="",a.QuickFix="quickfix",a.Refactor="refactor",a.RefactorExtract="refactor.extract",a.RefactorInline="refactor.inline",a.RefactorRewrite="refactor.rewrite",a.Source="source",a.SourceOrganizeImports="source.organizeImports",a.SourceFixAll="source.fixAll"}(Te||(Te={})),function(a){a.create=function t(a,c){var d={diagnostics:a};return null!=c&&(d.only=c),d},a.is=function i(a){var c=a;return Ue.defined(c)&&Ue.typedArray(c.diagnostics,B.is)&&(void 0===c.only||Ue.typedArray(c.only,Ue.string))}}(Re||(Re={})),function(a){a.create=function t(a,c,d){var h={title:a},p=!0;return"string"==typeof c?(p=!1,h.kind=c):X.is(c)?h.command=c:h.edit=c,p&&void 0!==d&&(h.kind=d),h},a.is=function i(a){var c=a;return c&&Ue.string(c.title)&&(void 0===c.diagnostics||Ue.typedArray(c.diagnostics,B.is))&&(void 0===c.kind||Ue.string(c.kind))&&(void 0!==c.edit||void 0!==c.command)&&(void 0===c.command||X.is(c.command))&&(void 0===c.isPreferred||Ue.boolean(c.isPreferred))&&(void 0===c.edit||te.is(c.edit))}}(De||(De={})),function(a){a.create=function t(a,c){var d={range:a};return Ue.defined(c)&&(d.data=c),d},a.is=function i(a){var c=a;return Ue.defined(c)&&M.is(c.range)&&(Ue.undefined(c.command)||X.is(c.command))}}(Me||(Me={})),function(a){a.create=function t(a,c){return{tabSize:a,insertSpaces:c}},a.is=function i(a){var c=a;return Ue.defined(c)&&Ue.uinteger(c.tabSize)&&Ue.boolean(c.insertSpaces)}}(Pe||(Pe={})),function(a){a.create=function t(a,c,d){return{range:a,target:c,data:d}},a.is=function i(a){var c=a;return Ue.defined(c)&&M.is(c.range)&&(Ue.undefined(c.target)||Ue.string(c.target))}}(Le||(Le={})),function(a){a.create=function t(a,c){return{range:a,parent:c}},a.is=function i(c){var d=c;return void 0!==d&&M.is(d.range)&&(void 0===d.parent||a.is(d.parent))}}(je||(je={})),function(a){function e(a,c){if(a.length<=1)return a;var d=a.length/2|0,h=a.slice(0,d),p=a.slice(d);e(h,c),e(p,c);for(var v=0,w=0,b=0;v<h.length&&w<p.length;){var y=c(h[v],p[w]);a[b++]=y<=0?h[v++]:p[w++]}for(;v<h.length;)a[b++]=h[v++];for(;w<p.length;)a[b++]=p[w++];return a}a.create=function t(a,c,d,h){return new We(a,c,d,h)},a.is=function i(a){var c=a;return!!(Ue.defined(c)&&Ue.string(c.uri)&&(Ue.undefined(c.languageId)||Ue.string(c.languageId))&&Ue.uinteger(c.lineCount)&&Ue.func(c.getText)&&Ue.func(c.positionAt)&&Ue.func(c.offsetAt))},a.applyEdits=function r(a,c){for(var d=a.getText(),h=e(c,(function(a,c){var d=a.range.start.line-c.range.start.line;return 0===d?a.range.start.character-c.range.start.character:d})),p=d.length,v=h.length-1;v>=0;v--){var w=h[v],b=a.offsetAt(w.range.start),y=a.offsetAt(w.range.end);if(!(y<=p))throw new Error("Overlapping edit");d=d.substring(0,b)+w.newText+d.substring(y,d.length),p=b}return d}}(Fe||(Fe={}));var Ue,We=function(){function n(a,c,d,h){this._uri=a,this._languageId=c,this._version=d,this._content=h,this._lineOffsets=void 0}return Object.defineProperty(n.prototype,"uri",{get:function(){return this._uri},enumerable:!1,configurable:!0}),Object.defineProperty(n.prototype,"languageId",{get:function(){return this._languageId},enumerable:!1,configurable:!0}),Object.defineProperty(n.prototype,"version",{get:function(){return this._version},enumerable:!1,configurable:!0}),n.prototype.getText=function(a){if(a){var c=this.offsetAt(a.start),d=this.offsetAt(a.end);return this._content.substring(c,d)}return this._content},n.prototype.update=function(a,c){this._content=a.text,this._version=c,this._lineOffsets=void 0},n.prototype.getLineOffsets=function(){if(void 0===this._lineOffsets){for(var a=[],c=this._content,d=!0,h=0;h<c.length;h++){d&&(a.push(h),d=!1);var p=c.charAt(h);d="\r"===p||"\n"===p,"\r"===p&&h+1<c.length&&"\n"===c.charAt(h+1)&&h++}d&&c.length>0&&a.push(c.length),this._lineOffsets=a}return this._lineOffsets},n.prototype.positionAt=function(a){a=Math.max(Math.min(a,this._content.length),0);var c=this.getLineOffsets(),d=0,h=c.length;if(0===h)return D.create(0,a);for(;d<h;){var p=Math.floor((d+h)/2);c[p]>a?h=p:d=p+1}var v=d-1;return D.create(v,a-c[v])},n.prototype.offsetAt=function(a){var c=this.getLineOffsets();if(a.line>=c.length)return this._content.length;if(a.line<0)return 0;var d=c[a.line],h=a.line+1<c.length?c[a.line+1]:this._content.length;return Math.max(Math.min(d+a.character,h),d)},Object.defineProperty(n.prototype,"lineCount",{get:function(){return this.getLineOffsets().length},enumerable:!1,configurable:!0}),n}();!function(a){var c=Object.prototype.toString;a.defined=function i(a){return typeof a<"u"},a.undefined=function r(a){return typeof a>"u"},a.boolean=function e(a){return!0===a||!1===a},a.string=function o(a){return"[object String]"===c.call(a)},a.number=function s(a){return"[object Number]"===c.call(a)},a.numberRange=function u(a,d,h){return"[object Number]"===c.call(a)&&d<=a&&a<=h},a.integer=function l(a){return"[object Number]"===c.call(a)&&-2147483648<=a&&a<=2147483647},a.uinteger=function f(a){return"[object Number]"===c.call(a)&&0<=a&&a<=2147483647},a.func=function g(a){return"[object Function]"===c.call(a)},a.objectLiteral=function m(a){return null!==a&&"object"==typeof a},a.typedArray=function k(a,c){return Array.isArray(a)&&a.every(c)}}(Ue||(Ue={}));var Ve=class{constructor(a,c,d){this._languageId=a,this._worker=c;let e=a=>{let c,d=a.getLanguageId();d===this._languageId&&(this._listener[a.uri.toString()]=a.onDidChangeContent((()=>{window.clearTimeout(c),c=window.setTimeout((()=>this._doValidate(a.uri,d)),500)})),this._doValidate(a.uri,d))},o=a=>{A.editor.setModelMarkers(a,this._languageId,[]);let c=a.uri.toString(),d=this._listener[c];d&&(d.dispose(),delete this._listener[c])};this._disposables.push(A.editor.onDidCreateModel(e)),this._disposables.push(A.editor.onWillDisposeModel(o)),this._disposables.push(A.editor.onDidChangeModelLanguage((a=>{o(a.model),e(a.model)}))),this._disposables.push(d((a=>{A.editor.getModels().forEach((a=>{a.getLanguageId()===this._languageId&&(o(a),e(a))}))}))),this._disposables.push({dispose:()=>{A.editor.getModels().forEach(o);for(let a in this._listener)this._listener[a].dispose()}}),A.editor.getModels().forEach(e)}_disposables=[];_listener=Object.create(null);dispose(){this._disposables.forEach((a=>a&&a.dispose())),this._disposables.length=0}_doValidate(a,c){this._worker(a).then((c=>c.doValidation(a.toString()))).then((d=>{let h=d.map((a=>function hn(a,c){let d="number"==typeof c.code?String(c.code):c.code;return{severity:pn(c.severity),startLineNumber:c.range.start.line+1,startColumn:c.range.start.character+1,endLineNumber:c.range.end.line+1,endColumn:c.range.end.character+1,message:c.message,code:d,source:c.source}}(0,a))),p=A.editor.getModel(a);p&&p.getLanguageId()===c&&A.editor.setModelMarkers(p,c,h)})).then(void 0,(a=>{console.error(a)}))}};function pn(a){switch(a){case H.Error:return A.MarkerSeverity.Error;case H.Warning:return A.MarkerSeverity.Warning;case H.Information:return A.MarkerSeverity.Info;case H.Hint:return A.MarkerSeverity.Hint;default:return A.MarkerSeverity.Info}}var He=class{constructor(a,c){this._worker=a,this._triggerCharacters=c}get triggerCharacters(){return this._triggerCharacters}provideCompletionItems(a,c,d,h){let p=a.uri;return this._worker(p).then((a=>a.doComplete(p.toString(),_(c)))).then((d=>{if(!d)return;let h=a.getWordUntilPosition(c),p=new A.Range(c.lineNumber,h.startColumn,c.lineNumber,h.endColumn),v=d.items.map((a=>{let c={label:a.label,insertText:a.insertText||a.label,sortText:a.sortText,filterText:a.filterText,documentation:a.documentation,detail:a.detail,command:yn(a.command),range:p,kind:vn(a.kind)};return a.textEdit&&(function mn(a){return typeof a.insert<"u"&&typeof a.replace<"u"}(a.textEdit)?c.range={insert:T(a.textEdit.insert),replace:T(a.textEdit.replace)}:c.range=T(a.textEdit.range),c.insertText=a.textEdit.newText),a.additionalTextEdits&&(c.additionalTextEdits=a.additionalTextEdits.map(S)),a.insertTextFormat===fe.Snippet&&(c.insertTextRules=A.languages.CompletionItemInsertTextRule.InsertAsSnippet),c}));return{isIncomplete:d.isIncomplete,suggestions:v}}))}};function _(a){if(a)return{character:a.column-1,line:a.lineNumber-1}}function de(a){if(a)return{start:{line:a.startLineNumber-1,character:a.startColumn-1},end:{line:a.endLineNumber-1,character:a.endColumn-1}}}function T(a){if(a)return new A.Range(a.start.line+1,a.start.character+1,a.end.line+1,a.end.character+1)}function vn(a){let c=A.languages.CompletionItemKind;switch(a){case ce.Text:return c.Text;case ce.Method:return c.Method;case ce.Function:return c.Function;case ce.Constructor:return c.Constructor;case ce.Field:return c.Field;case ce.Variable:return c.Variable;case ce.Class:return c.Class;case ce.Interface:return c.Interface;case ce.Module:return c.Module;case ce.Property:return c.Property;case ce.Unit:return c.Unit;case ce.Value:return c.Value;case ce.Enum:return c.Enum;case ce.Keyword:return c.Keyword;case ce.Snippet:return c.Snippet;case ce.Color:return c.Color;case ce.File:return c.File;case ce.Reference:return c.Reference}return c.Property}function S(a){if(a)return{range:T(a.range),text:a.newText}}function yn(a){return a&&"editor.action.triggerSuggest"===a.command?{id:a.command,title:a.title,arguments:a.arguments}:void 0}var Ke=class{constructor(a){this._worker=a}provideHover(a,c,d){let h=a.uri;return this._worker(h).then((a=>a.doHover(h.toString(),_(c)))).then((a=>{if(a)return{range:T(a.range),contents:xn(a.contents)}}))}};function Be(a){return"string"==typeof a?{value:a}:function Tn(a){return a&&"object"==typeof a&&"string"==typeof a.kind}(a)?"plaintext"===a.kind?{value:a.value.replace(/[\\`*_{}[\]()#+\-.!]/g,"\\$&")}:{value:a.value}:{value:"```"+a.language+"\n"+a.value+"\n```\n"}}function xn(a){if(a)return Array.isArray(a)?a.map(Be):[Be(a)]}var ze=class{constructor(a){this._worker=a}provideDocumentHighlights(a,c,d){let h=a.uri;return this._worker(h).then((a=>a.findDocumentHighlights(h.toString(),_(c)))).then((a=>{if(a)return a.map((a=>({range:T(a.range),kind:kn(a.kind)})))}))}};function kn(a){switch(a){case xe.Read:return A.languages.DocumentHighlightKind.Read;case xe.Write:return A.languages.DocumentHighlightKind.Write;case xe.Text:return A.languages.DocumentHighlightKind.Text}return A.languages.DocumentHighlightKind.Text}var Xe=class{constructor(a){this._worker=a}provideDefinition(a,c,d){let h=a.uri;return this._worker(h).then((a=>a.findDefinition(h.toString(),_(c)))).then((a=>{if(a)return[$e(a)]}))}};function $e(a){return{uri:A.Uri.parse(a.uri),range:T(a.range)}}var qe=class{constructor(a){this._worker=a}provideReferences(a,c,d,h){let p=a.uri;return this._worker(p).then((a=>a.findReferences(p.toString(),_(c)))).then((a=>{if(a)return a.map($e)}))}},Qe=class{constructor(a){this._worker=a}provideRenameEdits(a,c,d,h){let p=a.uri;return this._worker(p).then((a=>a.doRename(p.toString(),_(c),d))).then((a=>function In(a){if(!a||!a.changes)return;let c=[];for(let d in a.changes){let h=A.Uri.parse(d);for(let p of a.changes[d])c.push({resource:h,edit:{range:T(p.range),text:p.newText}})}return{edits:c}}(a)))}};var Ge=class{constructor(a){this._worker=a}provideDocumentSymbols(a,c){let d=a.uri;return this._worker(d).then((a=>a.findDocumentSymbols(d.toString()))).then((a=>{if(a)return a.map((a=>({name:a.name,detail:"",containerName:a.containerName,kind:Cn(a.kind),range:T(a.location.range),selectionRange:T(a.location.range),tags:[]})))}))}};function Cn(a){let c=A.languages.SymbolKind;switch(a){case Ee.File:return c.Array;case Ee.Module:return c.Module;case Ee.Namespace:return c.Namespace;case Ee.Package:return c.Package;case Ee.Class:return c.Class;case Ee.Method:return c.Method;case Ee.Property:return c.Property;case Ee.Field:return c.Field;case Ee.Constructor:return c.Constructor;case Ee.Enum:return c.Enum;case Ee.Interface:return c.Interface;case Ee.Function:return c.Function;case Ee.Variable:return c.Variable;case Ee.Constant:return c.Constant;case Ee.String:return c.String;case Ee.Number:return c.Number;case Ee.Boolean:return c.Boolean;case Ee.Array:return c.Array}return c.Function}var et=class{constructor(a){this._worker=a}provideLinks(a,c){let d=a.uri;return this._worker(d).then((a=>a.findDocumentLinks(d.toString()))).then((a=>{if(a)return{links:a.map((a=>({range:T(a.range),url:a.target})))}}))}},tt=class{constructor(a){this._worker=a}provideDocumentFormattingEdits(a,c,d){let h=a.uri;return this._worker(h).then((a=>a.format(h.toString(),null,Je(c)).then((a=>{if(a&&0!==a.length)return a.map(S)}))))}},nt=class{constructor(a){this._worker=a}provideDocumentRangeFormattingEdits(a,c,d,h){let p=a.uri;return this._worker(p).then((a=>a.format(p.toString(),de(c),Je(d)).then((a=>{if(a&&0!==a.length)return a.map(S)}))))}};function Je(a){return{tabSize:a.tabSize,insertSpaces:a.insertSpaces}}var rt=class{constructor(a){this._worker=a}provideDocumentColors(a,c){let d=a.uri;return this._worker(d).then((a=>a.findDocumentColors(d.toString()))).then((a=>{if(a)return a.map((a=>({color:a.color,range:T(a.range)})))}))}provideColorPresentations(a,c,d){let h=a.uri;return this._worker(h).then((a=>a.getColorPresentations(h.toString(),c.color,de(c.range)))).then((a=>{if(a)return a.map((a=>{let c={label:a.label};return a.textEdit&&(c.textEdit=S(a.textEdit)),a.additionalTextEdits&&(c.additionalTextEdits=a.additionalTextEdits.map(S)),c}))}))}},it=class{constructor(a){this._worker=a}provideFoldingRanges(a,c,d){let h=a.uri;return this._worker(h).then((a=>a.getFoldingRanges(h.toString(),c))).then((a=>{if(a)return a.map((a=>{let c={start:a.startLine+1,end:a.endLine+1};return typeof a.kind<"u"&&(c.kind=function _n(a){switch(a){case N.Comment:return A.languages.FoldingRangeKind.Comment;case N.Imports:return A.languages.FoldingRangeKind.Imports;case N.Region:return A.languages.FoldingRangeKind.Region}}(a.kind)),c}))}))}};var ot=class{constructor(a){this._worker=a}provideSelectionRanges(a,c,d){let h=a.uri;return this._worker(h).then((a=>a.getSelectionRanges(h.toString(),c.map(_)))).then((a=>{if(a)return a.map((a=>{let c=[];for(;a;)c.push({range:T(a.range)}),a=a.parent;return c}))}))}};function wn(a){let c=[],d=[],h=new ne(a);c.push(h);let e=(...a)=>h.getLanguageServiceWorker(...a);return function o(){let{languageId:c,modeConfiguration:h}=a;Ze(d),h.completionItems&&d.push(A.languages.registerCompletionItemProvider(c,new He(e,["/","-",":"]))),h.hovers&&d.push(A.languages.registerHoverProvider(c,new Ke(e))),h.documentHighlights&&d.push(A.languages.registerDocumentHighlightProvider(c,new ze(e))),h.definitions&&d.push(A.languages.registerDefinitionProvider(c,new Xe(e))),h.references&&d.push(A.languages.registerReferenceProvider(c,new qe(e))),h.documentSymbols&&d.push(A.languages.registerDocumentSymbolProvider(c,new Ge(e))),h.rename&&d.push(A.languages.registerRenameProvider(c,new Qe(e))),h.colors&&d.push(A.languages.registerColorProvider(c,new rt(e))),h.foldingRanges&&d.push(A.languages.registerFoldingRangeProvider(c,new it(e))),h.diagnostics&&d.push(new Ve(c,e,a.onDidChange)),h.selectionRanges&&d.push(A.languages.registerSelectionRangeProvider(c,new ot(e)))}(),c.push(Ye(d)),Ye(c)}function Ye(a){return{dispose:()=>Ze(a)}}function Ze(a){for(;a.length;)a.pop().dispose()}return x(E)})()));