/**
@license
Copyright (c) 2017 Vaadin Ltd.
This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
*/
import{PolymerElement as e}from"../../../@polymer/polymer/polymer-element.js";import{TextFieldMixin as t}from"./vaadin-text-field-mixin.js";import{ControlStateMixin as i}from"../../vaadin-control-state-mixin/vaadin-control-state-mixin.js";import{ThemableMixin as r}from"../../vaadin-themable-mixin/vaadin-themable-mixin.js";import{ElementMixin as l}from"../../vaadin-element-mixin/vaadin-element-mixin.js";import{html as a}from"../../../@polymer/polymer/lib/utils/html-tag.js";class TextFieldElement extends(l(t(i(r(e))))){static get template(){return a`
    <style include="vaadin-text-field-shared-styles">
      /* polymer-cli linter breaks with empty line */
    </style>

    <div class="vaadin-text-field-container">

      <label part="label" on-click="focus" id="[[_labelId]]">[[label]]</label>

      <div part="input-field" id="[[_inputId]]">

        <slot name="prefix"></slot>

        <slot name="input">
          <input part="value">
        </slot>

        <div part="clear-button" id="clearButton" role="button" aria-label\$="[[i18n.clear]]"></div>
        <slot name="suffix"></slot>

      </div>

      <div part="helper-text" id="[[_helperTextId]]">
        <slot name="helper">[[helperText]]</slot>
      </div>

      <div part="error-message" id="[[_errorId]]" aria-live="assertive" aria-hidden\$="[[_getErrorMessageAriaHidden(invalid, errorMessage, _errorId)]]">[[errorMessage]]</div>

    </div>
`}static get is(){return"vaadin-text-field"}static get version(){return"2.10.0"}static get properties(){return{list:{type:String},pattern:{type:String},title:{type:String}}}}customElements.define(TextFieldElement.is,TextFieldElement);export{TextFieldElement};