/**
@license
Copyright (c) 2017 Vaadin Ltd.
This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
*/
import{PolymerElement as e}from"../../../@polymer/polymer/polymer-element.js";import{TextFieldMixin as t}from"./vaadin-text-field-mixin.js";import{ControlStateMixin as i}from"../../vaadin-control-state-mixin/vaadin-control-state-mixin.js";import{ThemableMixin as a}from"../../vaadin-themable-mixin/vaadin-themable-mixin.js";import{ElementMixin as r}from"../../vaadin-element-mixin/vaadin-element-mixin.js";import{html as l}from"../../../@polymer/polymer/lib/utils/html-tag.js";class TextAreaElement extends(r(t(i(a(e))))){static get template(){return l`
    <style include="vaadin-text-field-shared-styles">
      .vaadin-text-area-container {
        flex: auto;
        max-height: inherit; /* MSIE 11 */
        min-height: inherit; /* MSIE 11 */
      }

      /* The label, helper text and the error message should neither grow nor shrink. */
      [part="label"],
      [part="helper-text"],
      [part="error-message"] {
        flex: none;
      }

      [part="input-field"] {
        overflow: auto;
        -webkit-overflow-scrolling: touch;
      }

      [part="value"] {
        resize: none;
      }

      [part="value"],
      [part="input-field"] ::slotted(*) {
        align-self: flex-start;
      }

      @keyframes vaadin-text-area-appear {
        to {
          opacity: 1;
        }
      }

      :host {
        animation: 1ms vaadin-text-area-appear;
      }

      /* Workaround https://bugzilla.mozilla.org/show_bug.cgi?id=1739079 */
      :host([disabled]) [part='value'] {
        user-select: none;
      }
    </style>

    <div class="vaadin-text-area-container">

      <label part="label" on-click="focus" id="[[_labelId]]">[[label]]</label>

      <div part="input-field" id="[[_inputId]]" on-scroll="__scrollPositionUpdated">

        <slot name="prefix"></slot>

        <slot name="textarea">
          <textarea part="value"></textarea>
        </slot>

        <div part="clear-button" id="clearButton" role="button" aria-label\$="[[i18n.clear]]"></div>
        <slot name="suffix"></slot>

      </div>

      <div part="helper-text" id="[[_helperTextId]]">
        <slot name="helper">[[helperText]]</slot>
      </div>

      <div part="error-message" id="[[_errorId]]" aria-live="assertive" aria-hidden\$="[[_getErrorMessageAriaHidden(invalid, errorMessage, _errorId)]]">[[errorMessage]]</div>

    </div>
`}static get is(){return"vaadin-text-area"}static get version(){return"2.10.0"}static get properties(){return{pattern:{type:String}}}static get observers(){return["_textAreaValueChanged(value)"]}ready(){super.ready(),this._updateHeight(),this.addEventListener("animationend",this._onAnimationEnd),this._inputField=this.root.querySelector("[part=input-field]"),this._inputField.addEventListener("wheel",(e=>{const t=this._inputField.scrollTop;this._inputField.scrollTop+=e.deltaY,t!==this._inputField.scrollTop&&(e.preventDefault(),this.__scrollPositionUpdated())})),this.__scrollPositionUpdated()}__scrollPositionUpdated(){this.updateStyles({"--_text-area-vertical-scroll-position":this._inputField.scrollTop+"px"})}_onAnimationEnd(e){0===e.animationName.indexOf("vaadin-text-area-appear")&&this._updateHeight()}get _slottedTagName(){return"textarea"}_textAreaValueChanged(e){this._updateHeight()}_updateHeight(){const e=this.root.querySelector("[part=input-field]"),t=e.scrollTop,i=this.inputElement,a=this.value?this.value.length:0;if(this._oldValueLength>=a){const t=getComputedStyle(e).height,a=getComputedStyle(i).width;e.style.display="block",e.style.height=t,i.style.maxWidth=a,i.style.height="auto"}this._oldValueLength=a;const r=i.scrollHeight;r>i.clientHeight&&(i.style.height=r+"px"),i.style.removeProperty("max-width"),e.style.removeProperty("display"),e.style.removeProperty("height"),e.scrollTop=t,this._dispatchIronResizeEventIfNeeded("InputHeight",r)}checkValidity(){if(!super.checkValidity())return!1;if(!this.pattern||!this._inputElementValue)return!0;try{const e=this._inputElementValue.match(this.pattern);return!!e&&e[0]===e.input}catch(e){return!0}}}customElements.define(TextAreaElement.is,TextAreaElement);export{TextAreaElement};