/**
@license
Copyright (c) 2017 Vaadin Ltd.
This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
*/
import"../../../@polymer/polymer/polymer-legacy.js";import{ThemableMixin as e}from"../../vaadin-themable-mixin/vaadin-themable-mixin.js";import{DisabledMixin as t}from"./vaadin-grid-disabled-mixin.js";import{ScrollerElement as i}from"./vaadin-grid-scroller.js";import{A11yMixin as r}from"./vaadin-grid-a11y-mixin.js";import{ActiveItemMixin as o}from"./vaadin-grid-active-item-mixin.js";import{ArrayDataProviderMixin as s}from"./vaadin-grid-array-data-provider-mixin.js";import{ColumnResizingMixin as n}from"./vaadin-grid-column-resizing-mixin.js";import{DataProviderMixin as l}from"./vaadin-grid-data-provider-mixin.js";import{DynamicColumnsMixin as a}from"./vaadin-grid-dynamic-columns-mixin.js";import{EventContextMixin as d}from"./vaadin-grid-event-context-mixin.js";import{FilterMixin as h}from"./vaadin-grid-filter-mixin.js";import{RowDetailsMixin as c}from"./vaadin-grid-row-details-mixin.js";import{ScrollMixin as m}from"./vaadin-grid-scroll-mixin.js";import{SelectionMixin as _}from"./vaadin-grid-selection-mixin.js";import{SortMixin as u}from"./vaadin-grid-sort-mixin.js";import{StylingMixin as p}from"./vaadin-grid-styling-mixin.js";import{DragAndDropMixin as g}from"./vaadin-grid-drag-and-drop-mixin.js";import{KeyboardNavigationMixin as f}from"./vaadin-grid-keyboard-navigation-mixin.js";import{ColumnReorderingMixin as v}from"./vaadin-grid-column-reordering-mixin.js";import"./vaadin-grid-column.js";import"./vaadin-grid-styles.js";import{ElementMixin as y}from"../../vaadin-element-mixin/vaadin-element-mixin.js";import{html as C}from"../../../@polymer/polymer/lib/utils/html-tag.js";import{beforeNextRender as b}from"../../../@polymer/polymer/lib/utils/render-status.js";import{Debouncer as w}from"../../../@polymer/polymer/lib/utils/debounce.js";import{timeOut as x,animationFrame as R}from"../../../@polymer/polymer/lib/utils/async.js";const A=(()=>{try{return document.createEvent("TouchEvent"),!0}catch(e){return!1}})();class GridElement extends(y(e(l(s(a(o(m(_(u(c(f(r(h(v(n(d(g(p(t(i)))))))))))))))))))){static get template(){return C`
    <style include="vaadin-grid-styles"></style>

    <div id="scroller" safari\$="[[_safari]]" ios\$="[[_ios]]" ie\$="[[_ie]]" loading\$="[[loading]]" column-reordering-allowed\$="[[columnReorderingAllowed]]">

      <table id="table" role="grid" aria-multiselectable="true" tabindex="0">
        <caption id="sizer" part="row"></caption>
        <thead id="header" role="rowgroup"></thead>
        <tbody id="items" role="rowgroup"></tbody>
        <tfoot id="footer" role="rowgroup"></tfoot>
      </table>

      <div part="reorder-ghost"></div>
    </div>

    <!-- The template needs at least one slot or else shady doesn't distribute -->
    <slot name="nodistribute"></slot>

    <div id="focusexit" tabindex="0"></div>
`}static get is(){return"vaadin-grid"}static get version(){return"5.10.1"}static get observers(){return["_columnTreeChanged(_columnTree, _columnTree.*)"]}static get properties(){return{_chrome:{type:Boolean,value:/Chrome/.test(navigator.userAgent)&&/Google Inc/.test(navigator.vendor)},_safari:{type:Boolean,value:/^((?!chrome|android).)*safari/i.test(navigator.userAgent)},_ios:{type:Boolean,value:/iPad|iPhone|iPod/.test(navigator.userAgent)&&!window.MSStream||"MacIntel"===navigator.platform&&navigator.maxTouchPoints>1},_edge:{type:Boolean,value:"undefined"!=typeof CSS&&CSS.supports("(-ms-ime-align:auto)")},_ie:{type:Boolean,value:!(!navigator.userAgent.match(/Trident/)||navigator.userAgent.match(/MSIE/))},_firefox:{type:Boolean,value:navigator.userAgent.toLowerCase().indexOf("firefox")>-1},_android:{type:Boolean,value:/android/i.test(navigator.userAgent)},_touchDevice:{type:Boolean,value:A},heightByRows:{type:Boolean,value:!1,reflectToAttribute:!0,observer:"_allRowsVisibleChanged"},allRowsVisible:{type:Boolean,value:!1,reflectToAttribute:!0,observer:"_allRowsVisibleChanged"},_recalculateColumnWidthOnceLoadingFinished:{type:Boolean,value:!0}}}constructor(){super(),this.addEventListener("animationend",this._onAnimationEnd)}connectedCallback(){super.connectedCallback(),this.recalculateColumnWidths()}attributeChangedCallback(e,t,i){super.attributeChangedCallback(e,t,i),"dir"===e&&(this.__isRTL="rtl"===i,this._updateScrollerMeasurements())}__hasRowsWithClientHeight(){return!!Array.from(this.$.items.children).filter((e=>e.clientHeight)).length}__flushPendingRecalculateColumnWidths(){this._recalculateColumnWidthOnceLoadingFinished&&!this._cache.isLoading()&&this.__hasRowsWithClientHeight()&&!this.__isCreatingRows()&&(this._recalculateColumnWidthOnceLoadingFinished=!1,this.recalculateColumnWidths())}__getIntrinsicWidth(e){const t=e.width,i=e.flexGrow;e.width="auto",e.flexGrow=0;const r=e._allCells.reduce(((e,t)=>Math.max(e,t.offsetWidth+1)),0);return e.flexGrow=i,e.width=t,r}__getDistributedWidth(e,t){if(null==e||e===this)return 0;const i=Math.max(this.__getIntrinsicWidth(e),this.__getDistributedWidth(e.parentElement,e));if(!t)return i;const r=i,o=e._visibleChildColumns.map((e=>this.__getIntrinsicWidth(e))).reduce(((e,t)=>e+t),0),s=Math.max(0,r-o),n=this.__getIntrinsicWidth(t)/o*s;return this.__getIntrinsicWidth(t)+n}_recalculateColumnWidths(e){e.forEach((e=>{e.width=`${this.__getDistributedWidth(e)}px`}))}recalculateColumnWidths(){if(this._columnTree)if(this._cache.isLoading()||this.__isCreatingRows())this._recalculateColumnWidthOnceLoadingFinished=!0;else{const e=this._getColumns().filter((e=>!e.hidden&&e.autoWidth));this._recalculateColumnWidths(e)}}_createScrollerRows(e){const t=[];for(var i=0;i<e;i++){const e=document.createElement("tr");e.setAttribute("part","row"),e.setAttribute("role","row"),this._columnTree&&this._updateRow(e,this._columnTree[this._columnTree.length-1],"body",!1,!0),t.push(e)}return this._columnTree&&this._columnTree[this._columnTree.length-1].forEach((e=>e.isConnected&&e.notifyPath&&e.notifyPath("_cells.*",e._cells))),b(this,(()=>{this._updateFirstAndLastColumn(),this._resetKeyboardNavigation()})),t}_getRowTarget(){return this.$.items}_createCell(e){const t="vaadin-grid-cell-content-"+(this._contentIndex=this._contentIndex+1||0),i=document.createElement("vaadin-grid-cell-content");i.setAttribute("slot",t);const r=document.createElement(e);r.id=t.replace("-content-","-"),r.setAttribute("tabindex","-1"),r.setAttribute("role","td"===e?"gridcell":"columnheader");const o=document.createElement("slot");return o.setAttribute("name",t),r.appendChild(o),r._content=i,i.addEventListener("mousedown",(()=>{if(this._chrome){const mouseUpListener=e=>{const t=i.contains(this.getRootNode().activeElement),o=e.composedPath().indexOf(i)>=0;!t&&o&&r.focus(),document.removeEventListener("mouseup",mouseUpListener,!0)};document.addEventListener("mouseup",mouseUpListener,!0)}else setTimeout((()=>{i.contains(this.getRootNode().activeElement)||r.focus()}))})),r}_updateRow(e,t,i,r,o){i=i||"body";const s=document.createDocumentFragment();Array.from(e.children).forEach((e=>e._vacant=!0)),e.innerHTML="","sizer"!==e.id&&(e.hidden=!0),t.filter((e=>!e.hidden)).forEach(((t,n,l)=>{let a;if("body"===i){if(t._cells=t._cells||[],a=t._cells.filter((e=>e._vacant))[0],a||(a=this._createCell("td"),t._cells.push(a)),a.setAttribute("part","cell body-cell"),e.appendChild(a),n===l.length-1&&(this._rowDetailsTemplate||this.rowDetailsRenderer)){this._detailsCells=this._detailsCells||[];const t=this._detailsCells.filter((e=>e._vacant))[0]||this._createCell("td");-1===this._detailsCells.indexOf(t)&&this._detailsCells.push(t),t._content.parentElement||s.appendChild(t._content),this._configureDetailsCell(t),e.appendChild(t),this._a11ySetRowDetailsCell(e,t),t._vacant=!1}t.notifyPath&&!o&&t.notifyPath("_cells.*",t._cells)}else{const o="header"===i?"th":"td";r||"vaadin-grid-column-group"===t.localName?(a=t[`_${i}Cell`]||this._createCell(o),a._column=t,e.appendChild(a),t[`_${i}Cell`]=a):(t._emptyCells=t._emptyCells||[],a=t._emptyCells.filter((e=>e._vacant))[0]||this._createCell(o),a._column=t,e.appendChild(a),-1===t._emptyCells.indexOf(a)&&t._emptyCells.push(a)),a.setAttribute("part",`cell ${i}-cell`),this.__updateHeaderFooterRowVisibility(e)}a._content.parentElement||s.appendChild(a._content),a._vacant=!1,a._column=t})),this.appendChild(s),this._frozenCellsChanged(),this._updateFirstAndLastColumnForRow(e)}__updateHeaderFooterRowVisibility(e){if(!e)return;const t=Array.from(e.children).filter((t=>{const i=t._column;if(i._emptyCells&&i._emptyCells.indexOf(t)>-1)return!1;if(e.parentElement===this.$.header){if(i.headerRenderer||i._headerTemplate)return!0;if(null===i.header)return!1;if(i.path||void 0!==i.header)return!0}else if(i.footerRenderer||i._footerTemplate)return!0}));e.hidden!==!t.length&&(e.hidden=!t.length,this.notifyResize())}_updateScrollerItem(e,t){this._preventScrollerRotatingCellFocus(e,t),this._columnTree&&(this._toggleAttribute("first",0===t,e),this._toggleAttribute("last",t===this._effectiveSize-1,e),this._toggleAttribute("odd",t%2,e),this._a11yUpdateRowRowindex(e,t),this._getItem(t,e))}_columnTreeChanged(e,t){this._renderColumnTree(e),this.recalculateColumnWidths()}_renderColumnTree(e){for(Array.from(this.$.items.children).forEach((t=>this._updateRow(t,e[e.length-1],null,!1,!0)));this.$.header.children.length<e.length;){const e=document.createElement("tr");e.setAttribute("part","row"),e.setAttribute("role","row"),this.$.header.appendChild(e);const t=document.createElement("tr");t.setAttribute("part","row"),t.setAttribute("role","row"),this.$.footer.appendChild(t)}for(;this.$.header.children.length>e.length;)this.$.header.removeChild(this.$.header.firstElementChild),this.$.footer.removeChild(this.$.footer.firstElementChild);Array.from(this.$.header.children).forEach(((t,i)=>this._updateRow(t,e[i],"header",i===e.length-1))),Array.from(this.$.footer.children).forEach(((t,i)=>this._updateRow(t,e[e.length-1-i],"footer",0===i))),this._updateRow(this.$.sizer,e[e.length-1]),this._resizeHandler(),this._frozenCellsChanged(),this._updateFirstAndLastColumn(),this._resetKeyboardNavigation(),this._a11yUpdateHeaderRows(),this._a11yUpdateFooterRows(),this.__updateFooterPositioning()}__updateFooterPositioning(){if(this._firefox&&(this.$.items.style.paddingBottom=0,this.heightByRows||this.allRowsVisible||(this.$.items.style.paddingBottom=`${this.$.footer.offsetHeight}px`)),this._ios){!window.CSS.supports("position","sticky")&&(this.$.table.style.height="",this.$.table.style.minHeight="100%",this.$.table.style.maxHeight="100%",setTimeout((()=>this.$.table.style.height=`${this.$.scroller.offsetHeight}px`)))}}_updateItem(e,t){e._item=t;const i=this.__getRowModel(e);this._toggleAttribute("selected",i.selected,e),this._a11yUpdateRowSelected(e,i.selected),this._a11yUpdateRowLevel(e,i.level),this._toggleAttribute("expanded",i.expanded,e),this._toggleAttribute("details-opened",this._isDetailsOpened(t),e),(this._rowDetailsTemplate||this.rowDetailsRenderer)&&this._toggleDetailsCell(e,t),this._generateCellClassNames(e,i),this._filterDragAndDrop(e,i),Array.from(e.children).forEach((e=>{if(e._renderer){const t=e._column||this;e._renderer.call(t,e._content,t,i)}else e._instance&&(e._instance.__detailsOpened__=i.detailsOpened,e._instance.__selected__=i.selected,e._instance.__level__=i.level,e._instance.__expanded__=i.expanded,e._instance.setProperties(i))})),this._debouncerUpdateHeights=w.debounce(this._debouncerUpdateHeights,x.after(1),(()=>{this._updateMetrics(),this._positionItems(),this._updateScrollerSize()}))}_resizeHandler(){this._updateDetailsCellHeights(),this._accessIronListAPI(super._resizeHandler,!0),this._updateScrollerMeasurements(),this.__updateFooterPositioning()}_onAnimationEnd(e){0===e.animationName.indexOf("vaadin-grid-appear")&&(this._render(),e.stopPropagation(),this.notifyResize(),this.__flushPendingRecalculateColumnWidths(),requestAnimationFrame((()=>{this.__scrollToPendingIndex(),this.$.table.style.webkitOverflowScrolling="touch"})))}_toggleAttribute(e,t,i){i.hasAttribute(e)===!t&&(t?i.setAttribute(e,""):i.removeAttribute(e))}__getRowModel(e){return{index:e.index,item:e._item,level:this._getIndexLevel(e.index),expanded:this._isExpanded(e._item),selected:this._isSelected(e._item),detailsOpened:!(!this._rowDetailsTemplate&&!this.rowDetailsRenderer)&&this._isDetailsOpened(e._item)}}render(){this._columnTree&&(this._columnTree.forEach((e=>{e.forEach((e=>e._renderHeaderAndFooter()))})),this._update())}notifyResize(){super.notifyResize()}_allRowsVisibleChanged(e,t){(e||t)&&this.notifyResize()}__forceReflow(){this._debouncerForceReflow=w.debounce(this._debouncerForceReflow,R,(()=>{this.$.scroller.style.overflow="hidden",setTimeout((()=>this.$.scroller.style.overflow=""))}))}}customElements.define(GridElement.is,GridElement);export{GridElement};