/**
@license
Copyright (c) 2019 Vaadin Ltd.
This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
*/
const t="between",e="on-top-or-between",r="on-grid",i="on-top",o="above",a="below",s="empty";export const DragAndDropMixin=n=>class DragAndDropMixin extends n{static get properties(){return{dropMode:String,rowsDraggable:Boolean,dragFilter:Function,dropFilter:Function,__dndAutoScrollThreshold:{value:50}}}static get observers(){return["_dragDropAccessChanged(rowsDraggable, dropMode, dragFilter, dropFilter, loading)"]}ready(){super.ready(),this.$.table.addEventListener("dragstart",this._onDragStart.bind(this)),this.$.table.addEventListener("dragend",this._onDragEnd.bind(this)),this.$.table.addEventListener("dragover",this._onDragOver.bind(this)),this.$.table.addEventListener("dragleave",this._onDragLeave.bind(this)),this.$.table.addEventListener("drop",this._onDrop.bind(this)),this.$.table.addEventListener("dragenter",(t=>{this.dropMode&&(t.preventDefault(),t.stopPropagation())}))}_onDragStart(t){if(this.rowsDraggable){let e=t.target;if("vaadin-grid-cell-content"===e.localName&&(e=e.assignedSlot.parentNode.parentNode),e.parentNode!==this.$.items)return;if(t.stopPropagation(),this._toggleAttribute("dragging-rows",!0,this),this._safari){const t=e.style.transform;e.style.top=/translateY\((.*)\)/.exec(t)[1],e.style.transform="none",requestAnimationFrame((()=>{e.style.top="",e.style.transform=t}))}const r=e.getBoundingClientRect();window.ShadyDOM||(this._ios?t.dataTransfer.setDragImage(e):t.dataTransfer.setDragImage(e,t.clientX-r.left,t.clientY-r.top));let i=[e];this._isSelected(e._item)&&(i=this.__getViewportRows().filter((t=>this._isSelected(t._item))).filter((t=>!this.dragFilter||this.dragFilter(this.__getRowModel(t))))),t.dataTransfer.setData("text",this.__formatDefaultTransferData(i)),e.setAttribute("dragstart",i.length>1?i.length:""),this.updateStyles({"--_grid-drag-start-x":t.clientX-r.left+20+"px","--_grid-drag-start-y":t.clientY-r.top+10+"px"}),requestAnimationFrame((()=>{e.removeAttribute("dragstart"),this.updateStyles({"--_grid-drag-start-x":"","--_grid-drag-start-y":""})}));const o=new CustomEvent("grid-dragstart",{detail:{draggedItems:i.map((t=>t._item)),setDragData:(e,r)=>t.dataTransfer.setData(e,r),setDraggedItemsCount:t=>e.setAttribute("dragstart",t)}});o.originalEvent=t,this.dispatchEvent(o)}}_onDragEnd(t){this._toggleAttribute("dragging-rows",!1,this),t.stopPropagation();const e=new CustomEvent("grid-dragend");e.originalEvent=t,this.dispatchEvent(e)}_onDragLeave(t){t.stopPropagation(),this._clearDragStyles()}_onDragOver(n){if(this.dropMode){if(this._dropLocation=void 0,this._dragOverItem=void 0,this.__dndAutoScroll(n.clientY))return void this._clearDragStyles();let d=n.composedPath().filter((t=>"tr"===t.localName))[0];if(this._effectiveSize&&this.dropMode!==r)if(d&&d.parentNode===this.$.items){const r=d.getBoundingClientRect();if(this._dropLocation=i,this.dropMode===t){const t=n.clientY-r.top<r.bottom-n.clientY;this._dropLocation=t?o:a}else this.dropMode===e&&(n.clientY-r.top<r.height/3?this._dropLocation=o:n.clientY-r.top>r.height/3*2&&(this._dropLocation=a))}else{if(d)return;if(this.dropMode!==t&&this.dropMode!==e)return;d=Array.from(this.$.items.children).filter((t=>!t.hidden)).pop(),this._dropLocation=a}else this._dropLocation=s;if(d&&d.hasAttribute("drop-disabled"))return void(this._dropLocation=void 0);n.stopPropagation(),n.preventDefault(),this._dropLocation===s?this._toggleAttribute("dragover",!0,this):d?(this._dragOverItem=d._item,d.getAttribute("dragover")!==this._dropLocation&&d.setAttribute("dragover",this._dropLocation)):this._clearDragStyles()}}__dndAutoScroll(t){if(this.__dndAutoScrolling)return!0;const e=this.$.header.getBoundingClientRect().bottom,r=this.$.footer.getBoundingClientRect().top,i=e-t+this.__dndAutoScrollThreshold,o=t-r+this.__dndAutoScrollThreshold;let a=0;if(o>0?a=2*o:i>0&&(a=2*-i),a){const t=this.$.table.scrollTop;this.$.table.scrollTop+=a;if(t!==this.$.table.scrollTop)return this.__dndAutoScrolling=!0,setTimeout((()=>this.__dndAutoScrolling=!1),20),this._scrollHandler(),!0}}__getViewportRows(){this.$.header.style.outline="0px solid transparent";const t=this.$.scroller.getBoundingClientRect(),e=Math.max(this.$.header.getBoundingClientRect().bottom,t.top),r=Math.min(this.$.footer.getBoundingClientRect().top,t.bottom);return Array.from(this.$.items.children).filter((t=>{const i=t.getBoundingClientRect();return i.bottom>e&&i.top<r}))}_clearDragStyles(){this.removeAttribute("dragover"),Array.from(this.$.items.children).forEach((t=>t.removeAttribute("dragover")))}_onDrop(t){if(this.dropMode){t.stopPropagation(),t.preventDefault();const e=t.dataTransfer.types&&Array.from(t.dataTransfer.types).map((e=>({type:e,data:t.dataTransfer.getData(e)})));this._clearDragStyles();const r=new CustomEvent("grid-drop",{bubbles:t.bubbles,cancelable:t.cancelable,detail:{dropTargetItem:this._dragOverItem,dropLocation:this._dropLocation,dragData:e}});r.originalEvent=t,this.dispatchEvent(r)}}__formatDefaultTransferData(t){return t.map((t=>Array.from(t.children).filter((t=>!t.hidden&&-1===t.getAttribute("part").indexOf("details-cell"))).sort(((t,e)=>t._column._order>e._column._order?1:-1)).map((t=>t._content.textContent.trim())).filter((t=>t)).join("\t"))).join("\n")}_dragDropAccessChanged(t,e,r,i){this.filterDragAndDrop()}filterDragAndDrop(){Array.from(this.$.items.children).filter((t=>!t.hidden)).forEach((t=>{this._filterDragAndDrop(t,this.__getRowModel(t))}))}_filterDragAndDrop(t,e){const r=this.loading||t.hasAttribute("loading"),i=!this.rowsDraggable||r||this.dragFilter&&!this.dragFilter(e),o=!this.dropMode||r||this.dropFilter&&!this.dropFilter(e);(window.ShadyDOM?[t]:Array.from(t.children).map((t=>t._content))).forEach((t=>{i?t.removeAttribute("draggable"):t.setAttribute("draggable",!0)})),this._toggleAttribute("drag-disabled",i,t),this._toggleAttribute("drop-disabled",o,t)}};