/**
 * DO NOT EDIT
 *
 * This file was automatically generated by
 *   https://github.com/Polymer/tools/tree/master/packages/gen-typescript-declarations
 *
 * To modify these typings, edit the source file(s):
 *   src/vaadin-grid-drag-and-drop-mixin.js
 */


// tslint:disable:variable-name Describing an API that's defined elsewhere.
// tslint:disable:no-any describes the API as best we are able today

export {DragAndDropMixin};

declare function DragAndDropMixin<T extends new (...args: any[]) => {}>(base: T): T & DragAndDropMixinConstructor;

interface DragAndDropMixinConstructor {
  new(...args: any[]): DragAndDropMixin;
}

export {DragAndDropMixinConstructor};

interface DragAndDropMixin {

  /**
   * Defines the locations within the Grid row where an element can be dropped.
   *
   * Possible values are:
   * - `between`: The drop event can happen between Grid rows.
   * - `on-top`: The drop event can happen on top of Grid rows.
   * - `on-top-or-between`: The drop event can happen either on top of or between Grid rows.
   * - `on-grid`: The drop event will not happen on any specific row, it will show the drop target outline around the whole grid.
   * @attr {between|on-top|on-top-or-between|on-grid} drop-mode
   */
  dropMode: GridDropMode|null|undefined;

  /**
   * Marks the grid's rows to be available for dragging.
   * @attr {boolean} rows-draggable
   */
  rowsDraggable: boolean|null|undefined;

  /**
   * A function that filters dragging of specific grid rows. The return value should be false
   * if dragging of the row should be disabled.
   *
   * Receives one argument:
   * - `model` The object with the properties related with
   *   the rendered item, contains:
   *   - `model.index` The index of the item.
   *   - `model.item` The item.
   *   - `model.expanded` Sublevel toggle state.
   *   - `model.level` Level of the tree represented with a horizontal offset of the toggle button.
   *   - `model.selected` Selected state.
   */
  dragFilter: GridDragAndDropFilter|null|undefined;

  /**
   * A function that filters dropping on specific grid rows. The return value should be false
   * if dropping on the row should be disabled.
   *
   * Receives one argument:
   * - `model` The object with the properties related with
   *   the rendered item, contains:
   *   - `model.index` The index of the item.
   *   - `model.item` The item.
   *   - `model.expanded` Sublevel toggle state.
   *   - `model.level` Level of the tree represented with a horizontal offset of the toggle button.
   *   - `model.selected` Selected state.
   */
  dropFilter: GridDragAndDropFilter|null|undefined;
  ready(): void;
  _clearDragStyles(): void;

  /**
   * Runs the `dragFilter` and `dropFilter` hooks for the visible cells.
   * If the filter depends on varying conditions, you may need to
   * call this function manually in order to update the draggability when
   * the conditions change.
   */
  filterDragAndDrop(): void;
  _filterDragAndDrop(row: HTMLElement, model: GridItemModel): void;
}

import {GridDropMode} from '../@types/interfaces';

import {GridDragAndDropFilter} from '../@types/interfaces';

import {GridItemModel} from '../@types/interfaces';
