/**
@license
Copyright (c) 2018 Vaadin Ltd.
This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
*/
import{PolymerElement as e}from"../../../@polymer/polymer/polymer-element.js";import{FlattenedNodesObserver as t}from"../../../@polymer/polymer/lib/utils/flattened-nodes-observer.js";import{DirMixin as r}from"../../vaadin-element-mixin/vaadin-dir-mixin.js";import{Templatizer as l}from"./vaadin-grid-templatizer.js";import{Debouncer as n}from"../../../@polymer/polymer/lib/utils/debounce.js";import{animationFrame as i}from"../../../@polymer/polymer/lib/utils/async.js";export const ColumnBaseMixin=e=>class ColumnBaseMixin extends e{static get properties(){return{resizable:{type:Boolean,value:function(){if("vaadin-grid-column-group"===this.localName)return;const e=this.parentNode;return e&&"vaadin-grid-column-group"===e.localName&&e.resizable||!1}},_headerTemplate:{type:Object},_footerTemplate:{type:Object},frozen:{type:Boolean,value:!1},hidden:{type:Boolean},header:{type:String},textAlign:{type:String},_lastFrozen:{type:Boolean,value:!1},_order:Number,_reorderStatus:Boolean,_emptyCells:Array,_headerCell:Object,_footerCell:Object,_grid:Object,headerRenderer:Function,footerRenderer:Function}}static get observers(){return["_widthChanged(width, _headerCell, _footerCell, _cells.*)","_frozenChanged(frozen, _headerCell, _footerCell, _cells.*)","_flexGrowChanged(flexGrow, _headerCell, _footerCell, _cells.*)","_pathOrHeaderChanged(path, header, _headerCell, _footerCell, _cells.*, renderer, headerRenderer, _bodyTemplate, _headerTemplate)","_textAlignChanged(textAlign, _cells.*, _headerCell, _footerCell)","_orderChanged(_order, _headerCell, _footerCell, _cells.*)","_lastFrozenChanged(_lastFrozen)","_setBodyTemplateOrRenderer(_bodyTemplate, renderer, _cells, _cells.*)","_setHeaderTemplateOrRenderer(_headerTemplate, headerRenderer, _headerCell)","_setFooterTemplateOrRenderer(_footerTemplate, footerRenderer, _footerCell)","_resizableChanged(resizable, _headerCell)","_reorderStatusChanged(_reorderStatus, _headerCell, _footerCell, _cells.*)","_hiddenChanged(hidden, _headerCell, _footerCell, _cells.*)"]}connectedCallback(){super.connectedCallback(),this._bodyTemplate&&(this._bodyTemplate.templatizer._grid=this._grid),this._headerTemplate&&(this._headerTemplate.templatizer._grid=this._grid),this._footerTemplate&&(this._footerTemplate.templatizer._grid=this._grid),this._templateObserver.flush(),this._bodyTemplate||this._templateObserver.callback(),requestAnimationFrame((()=>{this._allCells.forEach((e=>{e._content.parentNode||this._grid&&this._grid.appendChild(e._content)}))}))}disconnectedCallback(){super.disconnectedCallback(),requestAnimationFrame((()=>{this._findHostGrid()||this._allCells.forEach((e=>{e._content.parentNode&&e._content.parentNode.removeChild(e._content)}))})),this._gridValue=void 0}_findHostGrid(){let e=this;for(;e&&!/^vaadin.*grid(-pro)?$/.test(e.localName);)e=e.assignedSlot?e.assignedSlot.parentNode:e.parentNode;return e||void 0}get _grid(){return this._gridValue||(this._gridValue=this._findHostGrid()),this._gridValue}get _allCells(){return[].concat(this._cells||[]).concat(this._emptyCells||[]).concat(this._headerCell).concat(this._footerCell).filter((e=>e))}constructor(){super(),this._templateObserver=new t(this,(e=>{this._headerTemplate=this._prepareHeaderTemplate(),this._footerTemplate=this._prepareFooterTemplate(),this._bodyTemplate=this._prepareBodyTemplate()}))}_prepareHeaderTemplate(){return this._prepareTemplatizer(this._findTemplate(!0)||null,{})}_prepareFooterTemplate(){return this._prepareTemplatizer(this._findTemplate(!1,!0)||null,{})}_prepareBodyTemplate(){return this._prepareTemplatizer(this._findTemplate()||null)}_prepareTemplatizer(e,t){if(e&&!e.templatizer){const r=new l;r._grid=this._grid,r.dataHost=this.dataHost,r._instanceProps=t||r._instanceProps,r.template=e,e.templatizer=r}return e}_renderHeaderAndFooter(){this.headerRenderer&&this._headerCell&&this.__runRenderer(this.headerRenderer,this._headerCell),this.footerRenderer&&this._footerCell&&this.__runRenderer(this.footerRenderer,this._footerCell)}__runRenderer(e,t,r){const l=[t._content,this];r&&r.item&&l.push(r),e.apply(this,l)}__setColumnTemplateOrRenderer(e,t,r){if(e&&t)throw new Error("You should only use either a renderer or a template");r.forEach((r=>{const l=r.parentElement;if(!l)return;const n=this._grid.__getRowModel(l);if(t)r._renderer=t,(n.item||t===this.headerRenderer||t===this.footerRenderer)&&this.__runRenderer(t,r,n);else if(r._template!==e){r._template=e,r._content.innerHTML="",e.templatizer._grid=e.templatizer._grid||this._grid;const t=e.templatizer.createInstance();r._content.appendChild(t.root),r._instance=t,n.item&&r._instance.setProperties(n)}}))}_setBodyTemplateOrRenderer(e,t,r,l){(e||t)&&r&&this.__setColumnTemplateOrRenderer(e,t,r)}_setHeaderTemplateOrRenderer(e,t,r){(e||t)&&r&&this.__setColumnTemplateOrRenderer(e,t,[r])}_setFooterTemplateOrRenderer(e,t,r){(e||t)&&r&&(this.__setColumnTemplateOrRenderer(e,t,[r]),this._grid&&this._grid.__updateHeaderFooterRowVisibility(r.parentElement))}_selectFirstTemplate(e=!1,r=!1){return t.getFlattenedNodes(this).filter((t=>"template"===t.localName&&t.classList.contains("header")===e&&t.classList.contains("footer")===r))[0]}_findTemplate(e,t){const r=this._selectFirstTemplate(e,t);return r&&this.dataHost&&(r._rootDataHost=this.dataHost._rootDataHost||this.dataHost),r}_flexGrowChanged(e,t,r,l){this.parentElement&&this.parentElement._columnPropChanged&&this.parentElement._columnPropChanged("flexGrow"),this._allCells.forEach((t=>t.style.flexGrow=e))}_orderChanged(e,t,r,l){this._allCells.forEach((t=>t.style.order=e))}_widthChanged(e,t,r,l){this.parentElement&&this.parentElement._columnPropChanged&&this.parentElement._columnPropChanged("width"),this._allCells.forEach((t=>t.style.width=e)),this._grid&&this._grid.__forceReflow&&this._grid.__forceReflow()}_frozenChanged(e,t,r,l){this.parentElement&&this.parentElement._columnPropChanged&&this.parentElement._columnPropChanged("frozen",e),this._allCells.forEach((t=>this._toggleAttribute("frozen",e,t))),this._grid&&this._grid._frozenCellsChanged&&this._grid._frozenCellsChanged()}_lastFrozenChanged(e){this._allCells.forEach((t=>this._toggleAttribute("last-frozen",e,t))),this.parentElement&&this.parentElement._columnPropChanged&&(this.parentElement._lastFrozen=e)}_pathOrHeaderChanged(e,t,r,l,n,i,a,o,s){const d=void 0!==t;if(!a&&!s&&d&&r&&this.__setTextContent(r._content,t),e&&n.value){if(!i&&!o){const pathRenderer=(t,r,{item:l})=>this.__setTextContent(t,this.get(e,l));this.__setColumnTemplateOrRenderer(void 0,pathRenderer,n.value)}a||s||d||!r||null===t||this.__setTextContent(r._content,this._generateHeader(e))}r&&this._grid&&this._grid.__updateHeaderFooterRowVisibility(r.parentElement)}__setTextContent(e,t){e.textContent!==t&&(e.textContent=t)}_generateHeader(e){return e.substr(e.lastIndexOf(".")+1).replace(/([A-Z])/g,"-$1").toLowerCase().replace(/-/g," ").replace(/^./,(e=>e.toUpperCase()))}_toggleAttribute(e,t,r){r.hasAttribute(e)===!t&&(t?r.setAttribute(e,""):r.removeAttribute(e))}_reorderStatusChanged(e,t,r,l){this._allCells.forEach((t=>t.setAttribute("reorder-status",e)))}_resizableChanged(e,t){void 0!==e&&void 0!==t&&t&&[t].concat(this._emptyCells).forEach((t=>{if(t){const r=t.querySelector('[part~="resize-handle"]');if(r&&t.removeChild(r),e){const e=document.createElement("div");e.setAttribute("part","resize-handle"),t.appendChild(e)}}}))}_textAlignChanged(e,t,r,l){if(void 0===e)return;if(-1===["start","end","center"].indexOf(e))return void console.warn('textAlign can only be set as "start", "end" or "center"');let n;"ltr"===getComputedStyle(this._grid).direction?"start"===e?n="left":"end"===e&&(n="right"):"start"===e?n="right":"end"===e&&(n="left"),this._allCells.forEach((t=>{t._content.style.textAlign=e,getComputedStyle(t._content).textAlign!==e&&(t._content.style.textAlign=n)}))}_hiddenChanged(e,t,r,l){this.parentElement&&this.parentElement._columnPropChanged&&this.parentElement._columnPropChanged("hidden",e),!!e!=!!this._previousHidden&&this._grid&&(!0===e&&this._allCells.forEach((e=>{e._content.parentNode&&e._content.parentNode.removeChild(e._content)})),this._grid._debouncerHiddenChanged=n.debounce(this._grid._debouncerHiddenChanged,i,(()=>{this._grid&&this._grid._renderColumnTree&&this._grid._renderColumnTree(this._grid._columnTree)})),this._grid._updateLastFrozen&&this._grid._updateLastFrozen(),this._grid.notifyResize&&this._grid.notifyResize(),this._grid._resetKeyboardNavigation&&this._grid._resetKeyboardNavigation()),this._previousHidden=e}};class GridColumnElement extends(ColumnBaseMixin(r(e))){static get is(){return"vaadin-grid-column"}static get properties(){return{width:{type:String,value:"100px"},flexGrow:{type:Number,value:1},renderer:Function,path:{type:String},autoWidth:{type:Boolean,value:!1},_bodyTemplate:{type:Object},_cells:Array}}}customElements.define(GridColumnElement.is,GridColumnElement);export{GridColumnElement};