/**
@license
Copyright (c) 2017 Vaadin Ltd.
This program is available under Apache License Version 2.0, available at https://vaadin.com/license/
*/
import{PolymerElement as e}from"../../../@polymer/polymer/polymer-element.js";import{FlattenedNodesObserver as t}from"../../../@polymer/polymer/lib/utils/flattened-nodes-observer.js";import{ThemableMixin as i}from"../../vaadin-themable-mixin/vaadin-themable-mixin.js";import{DirMixin as r}from"../../vaadin-element-mixin/vaadin-dir-mixin.js";import{CheckboxElement as a}from"./vaadin-checkbox.js";import{html as s}from"../../../@polymer/polymer/lib/utils/html-tag.js";class CheckboxGroupElement extends(i(r(e))){static get template(){return s`
    <style>
      :host {
        display: inline-flex;

        /* Prevent horizontal overflow in IE 11 instead of wrapping checkboxes */
        max-width: 100%;
      }

      :host::before {
        content: "\\2003";
        width: 0;
        display: inline-block;
      }

      :host([hidden]) {
        display: none !important;
      }

      .vaadin-group-field-container {
        display: flex;
        flex-direction: column;

        /* Prevent horizontal overflow in IE 11 instead of wrapping checkboxes */
        width: 100%;
      }

      [part="label"]:empty {
        display: none;
      }
    </style>

    <div class="vaadin-group-field-container">
      <label part="label">[[label]]</label>

      <div part="group-field">
        <slot id="slot"></slot>
      </div>

      <div part="helper-text" aria-live="assertive" aria-hidden\$="[[_getHelperTextAriaHidden(helperText, _hasSlottedHelper)]]">
        <slot name="helper">[[helperText]]</slot>
      </div>

      <div part="error-message" aria-live="assertive" aria-hidden\$="[[_getErrorMessageAriaHidden(invalid, errorMessage)]]">[[errorMessage]]</div>

    </div>
`}static get is(){return"vaadin-checkbox-group"}static get properties(){return{disabled:{type:Boolean,reflectToAttribute:!0,observer:"_disabledChanged"},label:{type:String,value:"",observer:"_labelChanged"},value:{type:Array,value:()=>[],notify:!0},errorMessage:{type:String,value:"",observer:"_errorMessageChanged"},helperText:{type:String,value:"",observer:"_helperTextChanged"},required:{type:Boolean,reflectToAttribute:!0},invalid:{type:Boolean,reflectToAttribute:!0,notify:!0,value:!1},_hasSlottedHelper:Boolean}}static get observers(){return["_updateValue(value, value.splices)"]}ready(){super.ready(),this.addEventListener("focusin",(()=>this._setFocused(this._containsFocus()))),this.addEventListener("focusout",(e=>{this._checkboxes.some((t=>e.relatedTarget===t||t.shadowRoot.contains(e.relatedTarget)))||(this.validate(),this._setFocused(!1))}));const checkedChangedListener=e=>{this._changeSelectedCheckbox(e.target)};this._observer=new t(this,(e=>{const t=this._filterCheckboxes(e.addedNodes);t.forEach((e=>{e.addEventListener("checked-changed",checkedChangedListener),this.disabled&&(e.disabled=!0),e.checked?this._addCheckboxToValue(e.value):this.value.indexOf(e.value)>-1&&(e.checked=!0)})),this._filterCheckboxes(e.removedNodes).forEach((e=>{e.removeEventListener("checked-changed",checkedChangedListener),e.checked&&this._removeCheckboxFromValue(e.value)})),this._setOrToggleHasHelperAttribute();t.every((e=>{const{value:t}=e;return e.hasAttribute("value")||t&&"on"!==t}))||console.warn("Please add value attribute to all checkboxes in checkbox group")}))}_setInvalid(e){this._shouldSetInvalid(e)&&(this.invalid=e)}_shouldSetInvalid(e){return!0}validate(){const e=!(this.required&&0===this.value.length);return this._setInvalid(!e),this.dispatchEvent(new CustomEvent("validated",{detail:{valid:e}})),e}get _checkboxes(){return this._filterCheckboxes(this.querySelectorAll("*"))}_filterCheckboxes(e){return Array.from(e).filter((e=>e instanceof a))}_disabledChanged(e){this.setAttribute("aria-disabled",e),this._checkboxes.forEach((t=>t.disabled=e))}_addCheckboxToValue(e){-1===this.value.indexOf(e)&&(this.value=this.value.concat(e))}_removeCheckboxFromValue(e){this.value=this.value.filter((t=>t!==e))}_changeSelectedCheckbox(e){this._updatingValue||(e.checked?this._addCheckboxToValue(e.value):this._removeCheckboxFromValue(e.value))}_updateValue(e,t){0===e.length&&void 0===this._oldValue||(e.length?this.setAttribute("has-value",""):this.removeAttribute("has-value"),this._oldValue=e,this._updatingValue=!0,this._checkboxes.forEach((t=>{t.checked=e.indexOf(t.value)>-1})),this._updatingValue=!1,this.validate())}_labelChanged(e){this._setOrToggleAttribute("has-label",!!e)}_errorMessageChanged(e){this._setOrToggleAttribute("has-error-message",!!e)}_helperTextChanged(e){this._setOrToggleAttribute("has-helper",!!e)}_setOrToggleAttribute(e,t){e&&(t?this.setAttribute(e,"boolean"==typeof t?"":t):this.removeAttribute(e))}_getErrorMessageAriaHidden(e,t){return(!t||!e).toString()}_containsFocus(){const e=this.getRootNode(),t=void 0!==e._activeElement?e._activeElement:e.activeElement;return this.contains(t)}_setFocused(e){e?this.setAttribute("focused",""):this.removeAttribute("focused")}_setOrToggleHasHelperAttribute(){const e=this.shadowRoot.querySelector('[name="helper"]').assignedNodes();this._hasSlottedHelper=e.filter((e=>3!==e.nodeType)).length>0,this._setOrToggleAttribute("has-helper",this._hasSlottedHelper?"slotted":!!this.helperText)}_getHelperTextAriaHidden(e,t){return(!(e||t)).toString()}}customElements.define(CheckboxGroupElement.is,CheckboxGroupElement);export{CheckboxGroupElement};