function toArray(e){return e=e||[],Array.isArray(e)?e:[e]}function log(e){return`[Vaadin.Router] ${e}`}const e="module",t="nomodule",n=[e,t];function ensureBundle(e){if(!e.match(/.+\.[m]?js$/))throw new Error(log(`Unsupported type for bundle "${e}": .js or .mjs expected.`))}function ensureRoute(r){if(!r||!isString(r.path))throw new Error(log('Expected route config to be an object with a "path" string property, or an array of such objects'));const o=r.bundle,i=["component","redirect","bundle"];if(!(isFunction(r.action)||Array.isArray(r.children)||isFunction(r.children)||isObject(o)||i.some((e=>isString(r[e])))))throw new Error(log(`Expected route config "${r.path}" to include either "${i.join('", "')}" or "action" function but none found.`));if(o)if(isString(o))ensureBundle(o);else{if(!n.some((e=>e in o)))throw new Error(log('Expected route bundle to include either "'+t+'" or "'+e+'" keys, or both'));n.forEach((e=>e in o&&ensureBundle(o[e])))}r.redirect&&["bundle","component"].forEach((e=>{e in r&&console.warn(log(`Route config "${r.path}" has both "redirect" and "${e}" properties, and "redirect" will always override the latter. Did you mean to only use "${e}"?`))}))}function ensureRoutes(e){toArray(e).forEach((e=>ensureRoute(e)))}function loadScript(n,r){let o=document.head.querySelector('script[src="'+n+'"][async]');return o||(o=document.createElement("script"),o.setAttribute("src",n),r===e?o.setAttribute("type",e):r===t&&o.setAttribute(t,""),o.async=!0),new Promise(((e,t)=>{o.onreadystatechange=o.onload=t=>{o.__dynamicImportLoaded=!0,e(t)},o.onerror=e=>{o.parentNode&&o.parentNode.removeChild(o),t(e)},null===o.parentNode?document.head.appendChild(o):o.__dynamicImportLoaded&&e()}))}function fireRouterEvent(e,t){return!window.dispatchEvent(new CustomEvent(`vaadin-router-${e}`,{cancelable:"go"===e,detail:t}))}function isObject(e){return"object"==typeof e&&!!e}function isFunction(e){return"function"==typeof e}function isString(e){return"string"==typeof e}function getNotFoundError(e){const t=new Error(log(`Page not found (${e.pathname})`));return t.context=e,t.code=404,t}const r=new class NotFoundResult{};function vaadinRouterGlobalClickHandler(e){if(e.defaultPrevented)return;if(0!==e.button)return;if(e.shiftKey||e.ctrlKey||e.altKey||e.metaKey)return;let t=e.target;const n=e.composedPath?e.composedPath():e.path||[];for(let e=0;e<n.length;e++){const r=n[e];if(r.nodeName&&"a"===r.nodeName.toLowerCase()){t=r;break}}for(;t&&"a"!==t.nodeName.toLowerCase();)t=t.parentNode;if(!t||"a"!==t.nodeName.toLowerCase())return;if(t.target&&"_self"!==t.target.toLowerCase())return;if(t.hasAttribute("download"))return;if(t.hasAttribute("router-ignore"))return;if(t.pathname===window.location.pathname&&""!==t.hash)return;const r=t.origin||function getAnchorOrigin(e){const t=e.port,n=e.protocol;return`${n}//${"http:"===n&&"80"===t||"https:"===n&&"443"===t?e.hostname:e.host}`}(t);if(r!==window.location.origin)return;const{pathname:o,search:i,hash:a}=t;fireRouterEvent("go",{pathname:o,search:i,hash:a})&&(e.preventDefault(),e&&"click"===e.type&&window.scrollTo(0,0))}const o={activate(){window.document.addEventListener("click",vaadinRouterGlobalClickHandler)},inactivate(){window.document.removeEventListener("click",vaadinRouterGlobalClickHandler)}};function vaadinRouterGlobalPopstateHandler(e){if("vaadin-router-ignore"===e.state)return;const{pathname:t,search:n,hash:r}=window.location;fireRouterEvent("go",{pathname:t,search:n,hash:r})}/Trident/.test(navigator.userAgent)&&!isFunction(window.PopStateEvent)&&(window.PopStateEvent=function(e,t){t=t||{};var n=document.createEvent("Event");return n.initEvent(e,Boolean(t.bubbles),Boolean(t.cancelable)),n.state=t.state||null,n},window.PopStateEvent.prototype=window.Event.prototype);const i={activate(){window.addEventListener("popstate",vaadinRouterGlobalPopstateHandler)},inactivate(){window.removeEventListener("popstate",vaadinRouterGlobalPopstateHandler)}};var a=pathToRegexp$1,s=parse,c=function compile(e,t){return tokensToFunction(parse(e,t))},l=tokensToFunction,u=tokensToRegExp,h="/",d="./",p=new RegExp(["(\\\\.)","(?:\\:(\\w+)(?:\\(((?:\\\\.|[^\\\\()])+)\\))?|\\(((?:\\\\.|[^\\\\()])+)\\))([+*?])?"].join("|"),"g");function parse(e,t){for(var n,r=[],o=0,i=0,a="",s=t&&t.delimiter||h,c=t&&t.delimiters||d,l=!1;null!==(n=p.exec(e));){var u=n[0],_=n[1],f=n.index;if(a+=e.slice(i,f),i=f+u.length,_)a+=_[1],l=!0;else{var m="",g=e[i],v=n[2],w=n[3],y=n[4],R=n[5];if(!l&&a.length){var b=a.length-1;c.indexOf(a[b])>-1&&(m=a[b],a=a.slice(0,b))}a&&(r.push(a),a="",l=!1);var E=""!==m&&void 0!==g&&g!==m,x="+"===R||"*"===R,C="?"===R||"*"===R,A=m||s,P=w||y;r.push({name:v||o++,prefix:m,delimiter:A,optional:C,repeat:x,partial:E,pattern:P?escapeGroup(P):"[^"+escapeString(A)+"]+?"})}}return(a||i<e.length)&&r.push(a+e.substr(i)),r}function tokensToFunction(e){for(var t=new Array(e.length),n=0;n<e.length;n++)"object"==typeof e[n]&&(t[n]=new RegExp("^(?:"+e[n].pattern+")$"));return function(n,r){for(var o="",i=r&&r.encode||encodeURIComponent,a=0;a<e.length;a++){var s=e[a];if("string"!=typeof s){var c,l=n?n[s.name]:void 0;if(Array.isArray(l)){if(!s.repeat)throw new TypeError('Expected "'+s.name+'" to not repeat, but got array');if(0===l.length){if(s.optional)continue;throw new TypeError('Expected "'+s.name+'" to not be empty')}for(var u=0;u<l.length;u++){if(c=i(l[u],s),!t[a].test(c))throw new TypeError('Expected all "'+s.name+'" to match "'+s.pattern+'"');o+=(0===u?s.prefix:s.delimiter)+c}}else if("string"!=typeof l&&"number"!=typeof l&&"boolean"!=typeof l){if(!s.optional)throw new TypeError('Expected "'+s.name+'" to be '+(s.repeat?"an array":"a string"));s.partial&&(o+=s.prefix)}else{if(c=i(String(l),s),!t[a].test(c))throw new TypeError('Expected "'+s.name+'" to match "'+s.pattern+'", but got "'+c+'"');o+=s.prefix+c}}else o+=s}return o}}function escapeString(e){return e.replace(/([.+*?=^!:${}()[\]|/\\])/g,"\\$1")}function escapeGroup(e){return e.replace(/([=!:$/()])/g,"\\$1")}function flags(e){return e&&e.sensitive?"":"i"}function tokensToRegExp(e,t,n){for(var r=(n=n||{}).strict,o=!1!==n.start,i=!1!==n.end,a=escapeString(n.delimiter||h),s=n.delimiters||d,c=[].concat(n.endsWith||[]).map(escapeString).concat("$").join("|"),l=o?"^":"",u=0===e.length,p=0;p<e.length;p++){var _=e[p];if("string"==typeof _)l+=escapeString(_),u=p===e.length-1&&s.indexOf(_[_.length-1])>-1;else{var f=_.repeat?"(?:"+_.pattern+")(?:"+escapeString(_.delimiter)+"(?:"+_.pattern+"))*":_.pattern;t&&t.push(_),_.optional?_.partial?l+=escapeString(_.prefix)+"("+f+")?":l+="(?:"+escapeString(_.prefix)+"("+f+"))?":l+=escapeString(_.prefix)+"("+f+")"}}return i?(r||(l+="(?:"+a+")?"),l+="$"===c?"$":"(?="+c+")"):(r||(l+="(?:"+a+"(?="+c+"))?"),u||(l+="(?="+a+"|"+c+")")),new RegExp(l,flags(n))}function pathToRegexp$1(e,t,n){return e instanceof RegExp?function regexpToRegexp(e,t){if(!t)return e;var n=e.source.match(/\((?!\?)/g);if(n)for(var r=0;r<n.length;r++)t.push({name:r,prefix:null,delimiter:null,optional:!1,repeat:!1,partial:!1,pattern:null});return e}(e,t):Array.isArray(e)?function arrayToRegexp(e,t,n){for(var r=[],o=0;o<e.length;o++)r.push(pathToRegexp$1(e[o],t,n).source);return new RegExp("(?:"+r.join("|")+")",flags(n))}(e,t,n):function stringToRegexp(e,t,n){return tokensToRegExp(parse(e,n),t,n)}(e,t,n)}a.parse=s,a.compile=c,a.tokensToFunction=l,a.tokensToRegExp=u;const{hasOwnProperty:_}=Object.prototype,f=new Map;function decodeParam(e){try{return decodeURIComponent(e)}catch(t){return e}}function matchRoute(e,t,n,r,o){let i,s,c=0,l=e.path||"";return"/"===l.charAt(0)&&(n&&(l=l.substr(1)),n=!0),{next(u){if(e===u)return{done:!0};const h=e.__children=e.__children||e.children;if(!i&&(i=function matchPath(e,t,n,r,o){const i=`${e}|${n=!!n}`;let s=f.get(i);if(!s){const t=[];s={keys:t,pattern:a(e,t,{end:n,strict:""===e})},f.set(i,s)}const c=s.pattern.exec(t);if(!c)return null;const l=Object.assign({},o);for(let e=1;e<c.length;e++){const t=s.keys[e-1],n=t.name,r=c[e];void 0===r&&_.call(l,n)||(t.repeat?l[n]=r?r.split(t.delimiter).map(decodeParam):[]:l[n]=r?decodeParam(r):r)}return{path:c[0],keys:(r||[]).concat(s.keys),params:l}}(l,t,!h,r,o),i))return{done:!1,value:{route:e,keys:i.keys,params:i.params,path:i.path}};if(i&&h)for(;c<h.length;){if(!s){const r=h[c];r.parent=e;let o=i.path.length;o>0&&"/"===t.charAt(o)&&(o+=1),s=matchRoute(r,t.substr(o),n,i.keys,i.params)}const r=s.next(u);if(!r.done)return{done:!1,value:r.value};s=null,c++}return{done:!0}}}}function resolveRoute(e){if(isFunction(e.route.action))return e.route.action(e)}f.set("|false",{keys:[],pattern:/(?:)/});class Resolver{constructor(e,t={}){if(Object(e)!==e)throw new TypeError("Invalid routes");this.baseUrl=t.baseUrl||"",this.errorHandler=t.errorHandler,this.resolveRoute=t.resolveRoute||resolveRoute,this.context=Object.assign({resolver:this},t.context),this.root=Array.isArray(e)?{path:"",__children:e,parent:null,__synthetic:!0}:e,this.root.parent=null}getRoutes(){return[...this.root.__children]}setRoutes(e){ensureRoutes(e);const t=[...toArray(e)];this.root.__children=t}addRoutes(e){return ensureRoutes(e),this.root.__children.push(...toArray(e)),this.getRoutes()}removeRoutes(){this.setRoutes([])}resolve(e){const t=Object.assign({},this.context,isString(e)?{pathname:e}:e),n=matchRoute(this.root,this.__normalizePathname(t.pathname),this.baseUrl),o=this.resolveRoute;let i=null,a=null,s=t;function next(e,c=i.value.route,l){const u=null===l&&i.value.route;return i=a||n.next(u),a=null,e||!i.done&&function isChildRoute(e,t){let n=t;for(;n;)if(n=n.parent,n===e)return!0;return!1}(c,i.value.route)?i.done?Promise.reject(getNotFoundError(t)):(s=Object.assign(s?{chain:s.chain?s.chain.slice(0):[]}:{},t,i.value),function updateChainForRoute(e,t){const{route:n,path:r}=t;if(n&&!n.__synthetic){const t={path:r,route:n};if(e.chain){if(n.parent){let t=e.chain.length;for(;t--&&e.chain[t].route&&e.chain[t].route!==n.parent;)e.chain.pop()}}else e.chain=[];e.chain.push(t)}}(s,i.value),Promise.resolve(o(s)).then((t=>null!=t&&t!==r?(s.result=t.result||t,s):next(e,c,t)))):(a=i,Promise.resolve(r))}return t.next=next,Promise.resolve().then((()=>next(!0,this.root))).catch((e=>{const t=function generateErrorMessage(e){let t=`Path '${e.pathname}' is not properly resolved due to an error.`;const n=(e.route||{}).path;return n&&(t+=` Resolution had failed on route: '${n}'`),t}(s);if(e?console.warn(t):e=new Error(t),e.context=e.context||s,e instanceof DOMException||(e.code=e.code||500),this.errorHandler)return s.result=this.errorHandler(e),s;throw e}))}static __createUrl(e,t){return new URL(e,t)}get __effectiveBaseUrl(){return this.baseUrl?this.constructor.__createUrl(this.baseUrl,document.baseURI||document.URL).href.replace(/[^\/]*$/,""):""}__normalizePathname(e){if(!this.baseUrl)return e;const t=this.__effectiveBaseUrl,n=this.constructor.__createUrl(e,t).href;return n.slice(0,t.length)===t?n.slice(t.length):void 0}}Resolver.pathToRegexp=a;const{pathToRegexp:m}=Resolver,g=new Map;function cacheRoutes(e,t,n){const r=t.name||t.component;if(r&&(e.has(r)?e.get(r).push(t):e.set(r,[t])),Array.isArray(n))for(let r=0;r<n.length;r++){const o=n[r];o.parent=t,cacheRoutes(e,o,o.__children||o.children)}}function getRouteByName(e,t){const n=e.get(t);if(n&&n.length>1)throw new Error(`Duplicate route with name "${t}". Try seting unique 'name' route properties.`);return n&&n[0]}function getRoutePath(e){let t=e.path;return t=Array.isArray(t)?t[0]:t,void 0!==t?t:""}function generateUrls(e,t={}){if(!(e instanceof Resolver))throw new TypeError("An instance of Resolver is expected");const n=new Map;return(r,o)=>{let i=getRouteByName(n,r);if(!i&&(n.clear(),cacheRoutes(n,e.root,e.root.__children),i=getRouteByName(n,r),!i))throw new Error(`Route "${r}" not found`);let a=g.get(i.fullPath);if(!a){let e=getRoutePath(i),t=i.parent;for(;t;){const n=getRoutePath(t);n&&(e=n.replace(/\/$/,"")+"/"+e.replace(/^\//,"")),t=t.parent}const n=m.parse(e),r=m.tokensToFunction(n),o=Object.create(null);for(let e=0;e<n.length;e++)isString(n[e])||(o[n[e].name]=!0);a={toPath:r,keys:o},g.set(e,a),i.fullPath=e}let s=a.toPath(o,t)||"/";if(t.stringifyQueryParams&&o){const e={},n=Object.keys(o);for(let t=0;t<n.length;t++){const r=n[t];a.keys[r]||(e[r]=o[r])}const r=t.stringifyQueryParams(e);r&&(s+="?"===r.charAt(0)?r:`?${r}`)}return s}}let v=[];function setNavigationTriggers(e){v.forEach((e=>e.inactivate())),e.forEach((e=>e.activate())),v=e}function animate(e,t){return e.classList.add(t),new Promise((n=>{if((e=>{const t=getComputedStyle(e).getPropertyValue("animation-name");return t&&"none"!==t})(e)){const r=e.getBoundingClientRect(),o=`height: ${r.bottom-r.top}px; width: ${r.right-r.left}px`;e.setAttribute("style",`position: absolute; ${o}`),((e,t)=>{const listener=()=>{e.removeEventListener("animationend",listener),t()};e.addEventListener("animationend",listener)})(e,(()=>{e.classList.remove(t),e.removeAttribute("style"),n()}))}else e.classList.remove(t),n()}))}function isResultNotEmpty(e){return null!=e}function createLocation({pathname:e="",search:t="",hash:n="",chain:r=[],params:o={},redirectFrom:i,resolver:a},s){const c=r.map((e=>e.route));return{baseUrl:a&&a.baseUrl||"",pathname:e,search:t,hash:n,routes:c,route:s||c.length&&c[c.length-1]||null,params:o,redirectFrom:i,getUrl:(e={})=>getPathnameForRouter(Router.pathToRegexp.compile(getMatchedPath(c))(Object.assign({},o,e)),a)}}function createRedirect(e,t){const n=Object.assign({},e.params);return{redirect:{pathname:t,from:e.pathname,params:n}}}function runCallbackIfPossible(e,t,n){if(isFunction(e))return e.apply(n,t)}function amend(e,t,n){return r=>r&&(r.cancel||r.redirect)?r:n?runCallbackIfPossible(n[e],t,n):void 0}function removeDomNodes(e){if(e&&e.length){const t=e[0].parentNode;for(let n=0;n<e.length;n++)t.removeChild(e[n])}}function getPathnameForRouter(e,t){const n=t.__effectiveBaseUrl;return n?t.constructor.__createUrl(e.replace(/^\//,""),n).pathname:e}function getMatchedPath(e){return e.map((e=>e.path)).reduce(((e,t)=>t.length?e.replace(/\/$/,"")+"/"+t.replace(/^\//,""):e),"")}class Router extends Resolver{constructor(e,t){const n=document.head.querySelector("base"),r=n&&n.getAttribute("href");super([],Object.assign({baseUrl:r&&Resolver.__createUrl(r,document.URL).pathname.replace(/[^\/]*$/,"")},t)),this.resolveRoute=e=>this.__resolveRoute(e);const o=Router.NavigationTrigger;Router.setTriggers.apply(Router,Object.keys(o).map((e=>o[e]))),this.baseUrl,this.ready,this.ready=Promise.resolve(e),this.location,this.location=createLocation({resolver:this}),this.__lastStartedRenderId=0,this.__navigationEventHandler=this.__onNavigationEvent.bind(this),this.setOutlet(e),this.subscribe(),this.__createdByRouter=new WeakMap,this.__addedByRouter=new WeakMap}__resolveRoute(e){const t=e.route;let o=Promise.resolve();isFunction(t.children)&&(o=o.then((()=>t.children(function copyContextWithoutNext(e){const t=Object.assign({},e);return delete t.next,t}(e)))).then((e=>{isResultNotEmpty(e)||isFunction(t.children)||(e=t.children),function processNewChildren(e,t){if(!Array.isArray(e)&&!isObject(e))throw new Error(log(`Incorrect "children" value for the route ${t.path}: expected array or object, but got ${e}`));t.__children=[];const n=toArray(e);for(let e=0;e<n.length;e++)ensureRoute(n[e]),t.__children.push(n[e])}(e,t)})));const i={redirect:t=>createRedirect(e,t),component:e=>{const t=document.createElement(e);return this.__createdByRouter.set(t,!0),t}};return o.then((()=>{if(this.__isLatestRender(e))return runCallbackIfPossible(t.action,[e,i],t)})).then((e=>isResultNotEmpty(e)&&(e instanceof HTMLElement||e.redirect||e===r)?e:isString(t.redirect)?i.redirect(t.redirect):t.bundle?function loadBundle(e){return isString(e)?loadScript(e):Promise.race(n.filter((t=>t in e)).map((t=>loadScript(e[t],t))))}(t.bundle).then((()=>{}),(()=>{throw new Error(log(`Bundle not found: ${t.bundle}. Check if the file name is correct`))})):void 0)).then((e=>isResultNotEmpty(e)?e:isString(t.component)?i.component(t.component):void 0))}setOutlet(e){e&&this.__ensureOutlet(e),this.__outlet=e}getOutlet(){return this.__outlet}setRoutes(e,t=!1){return this.__previousContext=void 0,this.__urlForName=void 0,super.setRoutes(e),t||this.__onNavigationEvent(),this.ready}render(e,t){const n=++this.__lastStartedRenderId,r=Object.assign({search:"",hash:""},isString(e)?{pathname:e}:e,{__renderId:n});return this.ready=this.resolve(r).then((e=>this.__fullyResolveChain(e))).then((e=>{if(this.__isLatestRender(e)){const r=this.__previousContext;if(e===r)return this.__updateBrowserHistory(r,!0),this.location;if(this.location=createLocation(e),t&&this.__updateBrowserHistory(e,1===n),fireRouterEvent("location-changed",{router:this,location:this.location}),e.__skipAttach)return this.__copyUnchangedElements(e,r),this.__previousContext=e,this.location;this.__addAppearingContent(e,r);const o=this.__animateIfNeeded(e);return this.__runOnAfterEnterCallbacks(e),this.__runOnAfterLeaveCallbacks(e,r),o.then((()=>{if(this.__isLatestRender(e))return this.__removeDisappearingContent(),this.__previousContext=e,this.location}))}})).catch((e=>{if(n===this.__lastStartedRenderId)throw t&&this.__updateBrowserHistory(r),removeDomNodes(this.__outlet&&this.__outlet.children),this.location=createLocation(Object.assign(r,{resolver:this})),fireRouterEvent("error",Object.assign({router:this,error:e},r)),e})),this.ready}__fullyResolveChain(e,t=e){return this.__findComponentContextAfterAllRedirects(t).then((n=>{const o=n!==t?n:e,i=getPathnameForRouter(getMatchedPath(n.chain),n.resolver)===n.pathname,findNextContextIfAny=(e,t=e.route,n)=>e.next(void 0,t,n).then((n=>null===n||n===r?i?e:null!==t.parent?findNextContextIfAny(e,t.parent,n):n:n));return findNextContextIfAny(n).then((e=>{if(null===e||e===r)throw getNotFoundError(o);return e&&e!==r&&e!==n?this.__fullyResolveChain(o,e):this.__amendWithOnBeforeCallbacks(n)}))}))}__findComponentContextAfterAllRedirects(e){const t=e.result;return t instanceof HTMLElement?(function renderElement(e,t){t.location=createLocation(e);const n=e.chain.map((e=>e.route)).indexOf(e.route);return e.chain[n].element=t,t}(e,t),Promise.resolve(e)):t.redirect?this.__redirect(t.redirect,e.__redirectCount,e.__renderId).then((e=>this.__findComponentContextAfterAllRedirects(e))):t instanceof Error?Promise.reject(t):Promise.reject(new Error(log(`Invalid route resolution result for path "${e.pathname}". Expected redirect object or HTML element, but got: "${function logValue(e){if("object"!=typeof e)return String(e);const t=Object.prototype.toString.call(e).match(/ (.*)\]$/)[1];return"Object"===t||"Array"===t?`${t} ${JSON.stringify(e)}`:t}(t)}". Double check the action return value for the route.`)))}__amendWithOnBeforeCallbacks(e){return this.__runOnBeforeCallbacks(e).then((t=>t===this.__previousContext||t===e?t:this.__fullyResolveChain(t)))}__runOnBeforeCallbacks(e){const t=this.__previousContext||{},n=t.chain||[],r=e.chain;let o=Promise.resolve();const prevent=()=>({cancel:!0}),redirect=t=>createRedirect(e,t);if(e.__divergedChainIndex=0,e.__skipAttach=!1,n.length){for(let t=0;t<Math.min(n.length,r.length)&&(n[t].route===r[t].route&&(n[t].path===r[t].path||n[t].element===r[t].element)&&this.__isReusableElement(n[t].element,r[t].element));t=++e.__divergedChainIndex);if(e.__skipAttach=r.length===n.length&&e.__divergedChainIndex==r.length&&this.__isReusableElement(e.result,t.result),e.__skipAttach){for(let t=r.length-1;t>=0;t--)o=this.__runOnBeforeLeaveCallbacks(o,e,{prevent},n[t]);for(let t=0;t<r.length;t++)o=this.__runOnBeforeEnterCallbacks(o,e,{prevent,redirect},r[t]),n[t].element.location=createLocation(e,n[t].route)}else for(let t=n.length-1;t>=e.__divergedChainIndex;t--)o=this.__runOnBeforeLeaveCallbacks(o,e,{prevent},n[t])}if(!e.__skipAttach)for(let t=0;t<r.length;t++)t<e.__divergedChainIndex?t<n.length&&n[t].element&&(n[t].element.location=createLocation(e,n[t].route)):(o=this.__runOnBeforeEnterCallbacks(o,e,{prevent,redirect},r[t]),r[t].element&&(r[t].element.location=createLocation(e,r[t].route)));return o.then((t=>{if(t){if(t.cancel)return this.__previousContext.__renderId=e.__renderId,this.__previousContext;if(t.redirect)return this.__redirect(t.redirect,e.__redirectCount,e.__renderId)}return e}))}__runOnBeforeLeaveCallbacks(e,t,n,r){const o=createLocation(t);return e.then((e=>{if(this.__isLatestRender(t)){return amend("onBeforeLeave",[o,n,this],r.element)(e)}})).then((e=>{if(!(e||{}).redirect)return e}))}__runOnBeforeEnterCallbacks(e,t,n,r){const o=createLocation(t,r.route);return e.then((e=>{if(this.__isLatestRender(t)){return amend("onBeforeEnter",[o,n,this],r.element)(e)}}))}__isReusableElement(e,t){return!(!e||!t)&&(this.__createdByRouter.get(e)&&this.__createdByRouter.get(t)?e.localName===t.localName:e===t)}__isLatestRender(e){return e.__renderId===this.__lastStartedRenderId}__redirect(e,t,n){if(t>256)throw new Error(log(`Too many redirects when rendering ${e.from}`));return this.resolve({pathname:this.urlForPath(e.pathname,e.params),redirectFrom:e.from,__redirectCount:(t||0)+1,__renderId:n})}__ensureOutlet(e=this.__outlet){if(!(e instanceof Node))throw new TypeError(log(`Expected router outlet to be a valid DOM Node (but got ${e})`))}__updateBrowserHistory({pathname:e,search:t="",hash:n=""},r){if(window.location.pathname!==e||window.location.search!==t||window.location.hash!==n){const o=r?"replaceState":"pushState";window.history[o](null,document.title,e+t+n),window.dispatchEvent(new PopStateEvent("popstate",{state:"vaadin-router-ignore"}))}}__copyUnchangedElements(e,t){let n=this.__outlet;for(let r=0;r<e.__divergedChainIndex;r++){const o=t&&t.chain[r].element;if(o){if(o.parentNode!==n)break;e.chain[r].element=o,n=o}}return n}__addAppearingContent(e,t){this.__ensureOutlet(),this.__removeAppearingContent();const n=this.__copyUnchangedElements(e,t);this.__appearingContent=[],this.__disappearingContent=Array.from(n.children).filter((t=>this.__addedByRouter.get(t)&&t!==e.result));let r=n;for(let t=e.__divergedChainIndex;t<e.chain.length;t++){const o=e.chain[t].element;o&&(r.appendChild(o),this.__addedByRouter.set(o,!0),r===n&&this.__appearingContent.push(o),r=o)}}__removeDisappearingContent(){this.__disappearingContent&&removeDomNodes(this.__disappearingContent),this.__disappearingContent=null,this.__appearingContent=null}__removeAppearingContent(){this.__disappearingContent&&this.__appearingContent&&(removeDomNodes(this.__appearingContent),this.__disappearingContent=null,this.__appearingContent=null)}__runOnAfterLeaveCallbacks(e,t){if(t)for(let n=t.chain.length-1;n>=e.__divergedChainIndex&&this.__isLatestRender(e);n--){const r=t.chain[n].element;if(r)try{const n=createLocation(e);runCallbackIfPossible(r.onAfterLeave,[n,{},t.resolver],r)}finally{this.__disappearingContent.indexOf(r)>-1&&removeDomNodes(r.children)}}}__runOnAfterEnterCallbacks(e){for(let t=e.__divergedChainIndex;t<e.chain.length&&this.__isLatestRender(e);t++){const n=e.chain[t].element||{},r=createLocation(e,e.chain[t].route);runCallbackIfPossible(n.onAfterEnter,[r,{},e.resolver],n)}}__animateIfNeeded(e){const t=(this.__disappearingContent||[])[0],n=(this.__appearingContent||[])[0],r=[],o=e.chain;let i;for(let e=o.length;e>0;e--)if(o[e-1].route.animate){i=o[e-1].route.animate;break}if(t&&n&&i){const e=isObject(i)&&i.leave||"leaving",o=isObject(i)&&i.enter||"entering";r.push(animate(t,e)),r.push(animate(n,o))}return Promise.all(r).then((()=>e))}subscribe(){window.addEventListener("vaadin-router-go",this.__navigationEventHandler)}unsubscribe(){window.removeEventListener("vaadin-router-go",this.__navigationEventHandler)}__onNavigationEvent(e){const{pathname:t,search:n,hash:r}=e?e.detail:window.location;isString(this.__normalizePathname(t))&&(e&&e.preventDefault&&e.preventDefault(),this.render({pathname:t,search:n,hash:r},!0))}static setTriggers(...e){setNavigationTriggers(e)}urlForName(e,t){return this.__urlForName||(this.__urlForName=generateUrls(this)),getPathnameForRouter(this.__urlForName(e,t),this)}urlForPath(e,t){return getPathnameForRouter(Router.pathToRegexp.compile(e)(t),this)}static go(e){const{pathname:t,search:n,hash:r}=isString(e)?this.__createUrl(e,"http://a"):e;return fireRouterEvent("go",{pathname:t,search:n,hash:r})}}const w=/\/\*[\*!]\s+vaadin-dev-mode:start([\s\S]*)vaadin-dev-mode:end\s+\*\*\//i,y=window.Vaadin&&window.Vaadin.Flow&&window.Vaadin.Flow.clients;function uncommentAndRun(e,t){if("function"!=typeof e)return;const n=w.exec(e.toString());if(n)try{e=new Function(n[1])}catch(e){console.log("vaadin-development-mode-detector: uncommentAndRun() failed",e)}return e(t)}window.Vaadin=window.Vaadin||{};const runIfDevelopmentMode=function(e,t){if(window.Vaadin.developmentMode)return uncommentAndRun(e,t)};function maybeGatherAndSendStats(){}void 0===window.Vaadin.developmentMode&&(window.Vaadin.developmentMode=function isDevelopmentMode(){try{return!!function isForcedDevelopmentMode(){return localStorage.getItem("vaadin.developmentmode.force")}()||!!function isLocalhost(){return["localhost","127.0.0.1"].indexOf(window.location.hostname)>=0}()&&(y?!function isFlowProductionMode(){return!!(y&&Object.keys(y).map((e=>y[e])).filter((e=>e.productionMode)).length>0)}():!function isMinified(){return uncommentAndRun((function test(){return!0}))}())}catch(e){return!1}}());window.Vaadin=window.Vaadin||{},window.Vaadin.registrations=window.Vaadin.registrations||[],window.Vaadin.registrations.push({is:"@vaadin/router",version:"1.7.4"}),runIfDevelopmentMode(maybeGatherAndSendStats),Router.NavigationTrigger={POPSTATE:i,CLICK:o};export{Resolver,Router};