/**
@license
Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
Code distributed by Google as part of the polymer project is also
subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
*/
import{PolymerElement as t}from"../../polymer-element.js";import{TemplateInstanceBase as e,templatize as s,modelForElement as n}from"../utils/templatize.js";import{Debouncer as i}from"../utils/debounce.js";import{enqueueDebouncer as r,flush as _}from"../utils/flush.js";import{OptionalMutableData as h}from"../mixins/mutable-data.js";import{matches as o,translate as a}from"../utils/path.js";import{timeOut as l,microTask as d}from"../utils/async.js";import{wrap as u}from"../utils/wrap.js";import{hideElementsGlobally as c}from"../utils/hide-template-controls.js";import{suppressTemplateNotifications as m}from"../utils/settings.js";const p=h(t);export class DomRepeat extends p{static get is(){return"dom-repeat"}static get template(){return null}static get properties(){return{items:{type:Array},as:{type:String,value:"item"},indexAs:{type:String,value:"index"},itemsIndexAs:{type:String,value:"itemsIndex"},sort:{type:Function,observer:"__sortChanged"},filter:{type:Function,observer:"__filterChanged"},observe:{type:String,observer:"__observeChanged"},delay:Number,renderedItemCount:{type:Number,notify:!m,readOnly:!0},initialCount:{type:Number},targetFramerate:{type:Number,value:20},_targetFrameTime:{type:Number,computed:"__computeFrameTime(targetFramerate)"},notifyDomChange:{type:Boolean},reuseChunkedInstances:{type:Boolean}}}static get observers(){return["__itemsChanged(items.*)"]}constructor(){super(),this.__instances=[],this.__renderDebouncer=null,this.__itemsIdxToInstIdx={},this.__chunkCount=null,this.__renderStartTime=null,this.__itemsArrayChanged=!1,this.__shouldMeasureChunk=!1,this.__shouldContinueChunking=!1,this.__chunkingId=0,this.__sortFn=null,this.__filterFn=null,this.__observePaths=null,this.__ctor=null,this.__isDetached=!0,this.template=null,this._templateInfo}disconnectedCallback(){super.disconnectedCallback(),this.__isDetached=!0;for(let t=0;t<this.__instances.length;t++)this.__detachInstance(t);this.__chunkingId&&cancelAnimationFrame(this.__chunkingId)}connectedCallback(){if(super.connectedCallback(),c()||(this.style.display="none"),this.__isDetached){this.__isDetached=!1;let t=u(u(this).parentNode);for(let e=0;e<this.__instances.length;e++)this.__attachInstance(e,t);this.__chunkingId&&this.__render()}}__ensureTemplatized(){if(!this.__ctor){const t=this;let e=this.template=t._templateInfo?t:this.querySelector("template");if(!e){let t=new MutationObserver((()=>{if(!this.querySelector("template"))throw new Error("dom-repeat requires a <template> child");t.disconnect(),this.__render()}));return t.observe(this,{childList:!0}),!1}let n={};n[this.as]=!0,n[this.indexAs]=!0,n[this.itemsIndexAs]=!0,this.__ctor=s(e,this,{mutableData:this.mutableData,parentModel:!0,instanceProps:n,forwardHostProp:function(t,e){let s=this.__instances;for(let n,i=0;i<s.length&&(n=s[i]);i++)n.forwardHostProp(t,e)},notifyInstanceProp:function(t,e,s){if(o(this.as,e)){let n=t[this.itemsIndexAs];e==this.as&&(this.items[n]=s);let i=a(this.as,`${JSCompiler_renameProperty("items",this)}.${n}`,e);this.notifyPath(i,s)}}})}return!0}__getMethodHost(){return this.__dataHost._methodHost||this.__dataHost}__functionFromPropertyValue(t){if("string"==typeof t){let e=t,s=this.__getMethodHost();return function(){return s[e].apply(s,arguments)}}return t}__sortChanged(t){this.__sortFn=this.__functionFromPropertyValue(t),this.items&&this.__debounceRender(this.__render)}__filterChanged(t){this.__filterFn=this.__functionFromPropertyValue(t),this.items&&this.__debounceRender(this.__render)}__computeFrameTime(t){return Math.ceil(1e3/t)}__observeChanged(){this.__observePaths=this.observe&&this.observe.replace(".*",".").split(" ")}__handleObservedPaths(t){if(this.__sortFn||this.__filterFn)if(t){if(this.__observePaths){let e=this.__observePaths;for(let s=0;s<e.length;s++)0===t.indexOf(e[s])&&this.__debounceRender(this.__render,this.delay)}}else this.__debounceRender(this.__render,this.delay)}__itemsChanged(t){this.items&&!Array.isArray(this.items)&&console.warn("dom-repeat expected array for `items`, found",this.items),this.__handleItemPath(t.path,t.value)||("items"===t.path&&(this.__itemsArrayChanged=!0),this.__debounceRender(this.__render))}__debounceRender(t,e=0){this.__renderDebouncer=i.debounce(this.__renderDebouncer,e>0?l.after(e):d,t.bind(this)),r(this.__renderDebouncer)}render(){this.__debounceRender(this.__render),_()}__render(){if(!this.__ensureTemplatized())return;let t=this.items||[];const e=this.__sortAndFilterItems(t),s=this.__calculateLimit(e.length);this.__updateInstances(t,s,e),this.initialCount&&(this.__shouldMeasureChunk||this.__shouldContinueChunking)&&(cancelAnimationFrame(this.__chunkingId),this.__chunkingId=requestAnimationFrame((()=>{this.__chunkingId=null,this.__continueChunking()}))),this._setRenderedItemCount(this.__instances.length),m&&!this.notifyDomChange||this.dispatchEvent(new CustomEvent("dom-change",{bubbles:!0,composed:!0}))}__sortAndFilterItems(t){let e=new Array(t.length);for(let s=0;s<t.length;s++)e[s]=s;return this.__filterFn&&(e=e.filter(((e,s,n)=>this.__filterFn(t[e],s,n)))),this.__sortFn&&e.sort(((e,s)=>this.__sortFn(t[e],t[s]))),e}__calculateLimit(t){let e=t;const s=this.__instances.length;if(this.initialCount){let n;!this.__chunkCount||this.__itemsArrayChanged&&!this.reuseChunkedInstances?(e=Math.min(t,this.initialCount),n=Math.max(e-s,0),this.__chunkCount=n||1):(n=Math.min(Math.max(t-s,0),this.__chunkCount),e=Math.min(s+n,t)),this.__shouldMeasureChunk=n===this.__chunkCount,this.__shouldContinueChunking=e<t,this.__renderStartTime=performance.now()}return this.__itemsArrayChanged=!1,e}__continueChunking(){if(this.__shouldMeasureChunk){const t=performance.now()-this.__renderStartTime,e=this._targetFrameTime/t;this.__chunkCount=Math.round(this.__chunkCount*e)||1}this.__shouldContinueChunking&&this.__debounceRender(this.__render)}__updateInstances(t,e,s){const n=this.__itemsIdxToInstIdx={};let i;for(i=0;i<e;i++){let e=this.__instances[i],r=s[i],_=t[r];n[r]=i,e?(e._setPendingProperty(this.as,_),e._setPendingProperty(this.indexAs,i),e._setPendingProperty(this.itemsIndexAs,r),e._flushProperties()):this.__insertInstance(_,i,r)}for(let t=this.__instances.length-1;t>=i;t--)this.__detachAndRemoveInstance(t)}__detachInstance(t){let e=this.__instances[t];const s=u(e.root);for(let t=0;t<e.children.length;t++){let n=e.children[t];s.appendChild(n)}return e}__attachInstance(t,e){let s=this.__instances[t];e.insertBefore(s.root,this)}__detachAndRemoveInstance(t){this.__detachInstance(t),this.__instances.splice(t,1)}__stampInstance(t,e,s){let n={};return n[this.as]=t,n[this.indexAs]=e,n[this.itemsIndexAs]=s,new this.__ctor(n)}__insertInstance(t,e,s){const n=this.__stampInstance(t,e,s);let i=this.__instances[e+1],r=i?i.children[0]:this;return u(u(this).parentNode).insertBefore(n.root,r),this.__instances[e]=n,n}_showHideChildren(t){for(let e=0;e<this.__instances.length;e++)this.__instances[e]._showHideChildren(t)}__handleItemPath(t,e){let s=t.slice(6),n=s.indexOf("."),i=n<0?s:s.substring(0,n);if(i==parseInt(i,10)){let t=n<0?"":s.substring(n+1);this.__handleObservedPaths(t);let r=this.__itemsIdxToInstIdx[i],_=this.__instances[r];if(_){let s=this.as+(t?"."+t:"");_._setPendingPropertyOrPath(s,e,!1,!0),_._flushProperties()}return!0}}itemForElement(t){let e=this.modelForElement(t);return e&&e[this.as]}indexForElement(t){let e=this.modelForElement(t);return e&&e[this.indexAs]}modelForElement(t){return n(this.template,t)}}customElements.define(DomRepeat.is,DomRepeat);