/**
@license
Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at
http://polymer.github.io/LICENSE.txt The complete set of authors may be found at
http://polymer.github.io/AUTHORS.txt The complete set of contributors may be
found at http://polymer.github.io/CONTRIBUTORS.txt Code distributed by Google as
part of the polymer project is also subject to an additional IP rights grant
found at http://polymer.github.io/PATENTS.txt
*/
import"../polymer/polymer-legacy.js";import"./iron-doc-viewer-styles.js";import{Polymer as e}from"../polymer/lib/legacy/polymer-fn.js";import{dom as t,flush as i}from"../polymer/lib/legacy/polymer.dom.js";import{html as o}from"../polymer/lib/utils/html-tag.js";function _section(e,t,i){for(var o=[],a=0;a<(i||[]).length;a++){var s=i[a],r=s.tagname?"<"+s.tagname+">":s.name;if(r){for(var n=t+(s.tagname||s.name),l=[],p=0;p<(s.demos||[]).length;p++){var d=s.demos[p];if(d.url){var m=d.description?d.description.toLowerCase().replace(/\s+/g,"-"):d.url;l.push({path:n+"/demos/"+m,description:d.description||"Demo"})}}o.push({name:r,path:n,demos:l})}}return o.sort((function(e,t){return e.name.localeCompare(t.name)})),{heading:e,items:o}}e({_template:o`
    <style include="iron-doc-viewer-styles">
      :host {
        display: block;
      }

      section {
        @apply --iron-doc-font-body;
        border-bottom: 1px solid #e0e0e0;
      }

      h3 {
        @apply --paper-font-subhead;
        color: #717171;
        padding: 0 24px;
      }

      ul {
        list-style: none;
        padding: 0;
      }

      li {
        line-height: 30px;
      }

      a {
        color: #333;
        padding: 0 24px;
        display: block;
        text-decoration: none;
      }

      a:hover {
        color: var(--iron-doc-accent-color-internal) !important;
      }

      a[selected] {
        color: var(--iron-doc-accent-color-internal);
      }

      .tray {
        transition: height 180ms linear, opacity 180ms linear;
        box-sizing: border-box;
        overflow: hidden;
      }

      .tray:not([expanded]) {
        height: 0 !important;
        opacity: 0;
        visibility: hidden; /** Prevent keyboard etc. focus. */
      }

      .tray[expanded] {
        opacity: 1;
        visibility: visible;
      }

      .tray ul {
        padding: 10px 0;
        margin: 10px 0;
        white-space: nowrap;
        background-color: #eee;
        border-top: 1px solid #dedede;
        border-bottom: 1px solid white;
      }

      .tray a {
        padding-left: 35px;
        color: #333;
      }
    </style>

    <template is="dom-repeat" items="[[_sections]]" as="section">
      <section hidden\$="[[!section.items.length]]">
        <h3>[[section.heading]]</h3>
        <ul>
          <template is="dom-repeat" items="[[section.items]]">
            <li>
              <a href="[[baseHref]][[item.path]]" title\$="[[item.name]]" on-tap="_select" selected\$="[[_isSelected(item.path, path)]]">
                [[item.name]]
              </a>

              <div class="tray" expanded\$="[[_isExpanded(item, path)]]">
                <ul>
                  <template is="dom-repeat" items="[[item.demos]]" as="demo">
                    <li>
                      <a href="[[baseHref]][[demo.path]]" title\$="[[demo.description]]" on-tap="_select" selected\$="[[_isSelected(demo.path, path)]]">
                        [[demo.description]]
                      </a>
                    </li>
                  </template>
                </ul>
              </div>
            </li>
          </template>
        </ul>
      </section>
    </template>
`,is:"iron-doc-nav",properties:{descriptor:{type:Object,observer:"_descriptorChanged"},path:String,baseHref:{type:String,value:"#"},_sections:Array},_descriptorChanged(e){e=e||{},this._sections=[_section("Namespaces","/namespaces/",e.namespaces),_section("Elements","/elements/",e.elements),_section("Behaviors","/behaviors/",((e.metadata||{}).polymer||{}).behaviors),_section("Mixins","/mixins/",e.mixins),_section("Classes","/classes/",e.classes)],i();for(var o=t(this.root).querySelectorAll(".tray"),a=0;a<o.length;a++){var s=o[a],r=s.hasAttribute("expanded");r||s.setAttribute("expanded",""),s.style.height="auto",s.style.height=s.offsetHeight+"px",r||s.removeAttribute("expanded","")}},_select(e){this.fire("select")},_isSelected:(e,t)=>e===t,_isExpanded:(e,t)=>!(!(e&&t&&e.path&&e.demos&&e.demos.length>0)||t!==e.path&&0!==t.indexOf(e.path+"/"))});