/**
@license
Copyright (c) 2015 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at
http://polymer.github.io/LICENSE.txt The complete set of authors may be found at
http://polymer.github.io/AUTHORS.txt The complete set of contributors may be
found at http://polymer.github.io/CONTRIBUTORS.txt Code distributed by Google as
part of the polymer project is also subject to an additional IP rights grant
found at http://polymer.github.io/PATENTS.txt
*/
import"../polymer/polymer-legacy.js";import"../marked-element/marked-element.js";import"../prism-element/prism-highlighter.js";import"../prism-element/prism-theme-default.js";import{Polymer as e}from"../polymer/lib/legacy/polymer-fn.js";import{dom as t}from"../polymer/lib/legacy/polymer.dom.js";import{html as o}from"../polymer/lib/utils/html-tag.js";e({_template:o`
    <style include="prism-theme-default">
      :host {
        display: block;

        box-shadow: 0 2px 2px 0 rgba(0, 0, 0, 0.14),
                    0 1px 5px 0 rgba(0, 0, 0, 0.12),
                    0 3px 1px -2px rgba(0, 0, 0, 0.2);
        margin-bottom: 40px;
        @apply --demo-snippet;
      }

      .demo {
        display: block;
        border-bottom: 1px solid #e0e0e0;
        background-color: white;
        margin: 0;
        padding: 20px;
        @apply --demo-snippet-demo;
      }

      .code-container {
        margin: 0;
        background-color: #f5f5f5;
        font-size: 13px;
        overflow: auto;
        position: relative;
        padding: 0 20px;
        @apply --demo-snippet-code;
      }

      .code {
        padding: 20px;
        margin: 0;
        background-color: var(--google-grey-100);
        font-size: 13px;
        overflow: auto;
        @apply --demo-snippet-code;
      }
      .code > pre {
        margin: 0;
        padding: 0 0 10px 0;
      }

      button {
        position: absolute;
        top: 0;
        right: 0px;
        text-transform: uppercase;
        border: none;
        cursor: pointer;
        background: #e0e0e0;
      }
    </style>

    <prism-highlighter></prism-highlighter>

    <div class="demo">
      <slot id="content"></slot>
    </div>

    <div class="code-container">
      <marked-element markdown="[[_markdown]]" id="marked">
         <div class="code" slot="markdown-html" id="code"></div>
      </marked-element>
      <button id="copyButton" title="copy to clipboard" on-tap="_copyToClipboard">Copy</button>
    </div>
`,is:"demo-snippet",properties:{_markdown:{type:String}},attached:function(){this._observer=t(this.$.content).observeNodes(function(e){this._updateMarkdown()}.bind(this))},detached:function(){this._observer&&(t(this.$.content).unobserveNodes(this._observer),this._observer=null)},_updateMarkdown:function(){var e=t(this).queryDistributedElements("template")[0];if(e){var o=this.$.marked.unindent(e.innerHTML);o=(o=o.replace(/ class=""/g,"")).replace(/=""/g,""),this._markdown="```\n"+o+"\n```",e.hasAttribute("is")||(t(this.$.content).unobserveNodes(this._observer),this._observer=null,t(this).appendChild(document.importNode(e.content,!0))),this.dispatchEvent(new CustomEvent("dom-ready"))}else this._markdown=""},_copyToClipboard:function(){var e=document.createRange();e.selectNodeContents(this.$.code);var t=window.getSelection();t.removeAllRanges(),t.addRange(e);var o=!1;try{o=document.execCommand("copy"),this.$.copyButton.textContent="done"}catch(e){console.error(e),this.$.copyButton.textContent="error"}return setTimeout(this._resetCopyButtonState.bind(this),1e3),t.removeAllRanges(),o},_resetCopyButtonState:function(){this.$.copyButton.textContent="copy"}});