/**
@license
Copyright (c) 2015 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at
http://polymer.github.io/LICENSE.txt The complete set of authors may be found at
http://polymer.github.io/AUTHORS.txt The complete set of contributors may be
found at http://polymer.github.io/CONTRIBUTORS.txt Code distributed by Google as
part of the polymer project is also subject to an additional IP rights grant
found at http://polymer.github.io/PATENTS.txt
*/
import"../polymer/polymer-legacy.js";import"../app-layout/app-drawer-layout/app-drawer-layout.js";import"../app-layout/app-drawer/app-drawer.js";import"../app-layout/app-header-layout/app-header-layout.js";import"../app-layout/app-header/app-header.js";import"../app-layout/app-toolbar/app-toolbar.js";import"../iron-ajax/iron-ajax.js";import"../iron-doc-viewer/default-theme.js";import"../iron-doc-viewer/iron-doc-nav.js";import"../iron-doc-viewer/iron-doc-viewer.js";import"../iron-icons/iron-icons.js";import"../paper-icon-button/paper-icon-button.js";import"../paper-styles/color.js";import"../paper-styles/typography.js";import"../paper-toast/paper-toast.js";import{Polymer as r}from"../polymer/lib/legacy/polymer-fn.js";import{html as e}from"../polymer/lib/utils/html-tag.js";function _flatten(r,e){e||(e={namespaces:[],elements:[],metadata:{polymer:{behaviors:[]}},mixins:[],classes:[]});for(var o=0;o<(r.namespaces||[]).length;o++)_flatten(r.namespaces[o],e),e.namespaces.push(r.namespaces[o]);for(o=0;o<(r.classes||[]).length;o++)e.classes.push(r.classes[o]);for(o=0;o<(r.elements||[]).length;o++)e.elements.push(r.elements[o]);var a=((r.metadata||{}).polymer||{}).behaviors;for(o=0;o<(a||[]).length;o++)e.metadata.polymer.behaviors.push(a[o]);for(o=0;o<(r.mixins||[]).length;o++)e.mixins.push(r.mixins[o]);return e}r({_template:e`
    <style include="iron-doc-default-theme">
      :host {
        --app-drawer-width: 300px;
      }

      [hidden] {
        display: none;
      }

      app-header {
        @apply --paper-font-headline;
        color: white;
        background-color: var(--iron-component-page-header-color,
                              var(--iron-doc-accent-color, #5a5a5a));
      }

      [drawer-toggle] {
        flex-shrink: 0;
      }

      [condensed-title] {
        white-space: nowrap;
      }

      app-drawer {
        --app-drawer-content-container: {
          background-color: #fbfbfb;
        }
        box-shadow: 0 0 8px rgba(0, 0, 0, 0.3);
      }

      iron-doc-nav {
        height: 100%;
        overflow-y: auto;
        overflow-x: hidden;
      }

      iron-doc-viewer {
        height: 100%;
        --iron-doc-title: {
          display: none;
        }
      }

      iron-doc-viewer:not([demo]) {
        padding: 5px 20px 20px 20px;
        max-width: 56em;
      }

      #error-toast {
        background-color: var(--paper-red-600);
      }
    </style>

    <iron-ajax auto url="[[descriptorUrl]]" handle-as="json" last-response="{{_descriptor}}" loading="{{_loading}}" last-error="{{_descriptorError}}">
    </iron-ajax>

    <paper-toast id="loading-toast" opened="[[_loading]]" duration="0">
      Loading descriptor ...
    </paper-toast>

    <paper-toast id="error-toast" opened="[[_descriptorError]]" duration="0">
      Could not load descriptor "[[descriptorUrl]]". <br> [[_descriptorError.error]]
    </paper-toast>

    <app-drawer-layout fullbleed narrow="{{_narrow}}">

      <app-drawer id="drawer" slot="drawer" swipe-open>
        <iron-doc-nav descriptor="[[_descriptor]]" base-href="[[baseHref]]" path="[[_path]]" on-select="_onNavSelect">
        </iron-doc-nav>
      </app-drawer>

      <app-header-layout has-scrolling-region>
        <app-header slot="header" fixed>
          <app-toolbar>
            <paper-icon-button icon="menu" drawer-toggle hidden$="[[!_narrow]]">
            </paper-icon-button>

            <div>[[_title]]</div>
          </app-toolbar>
        </app-header>

        <iron-doc-viewer id="viewer" descriptor="[[_descriptor]]" root-namespace="[[rootNamespace]]" base-href="[[baseHref]]" demo-src-prefix="[[demoSrcPrefix]]" title="{{_title}}" path="{{_path}}" on-view-changed="_onViewChanged">
        </iron-doc-viewer>

      </app-header-layout>
    </app-drawer-layout>
`,is:"iron-component-page",properties:{descriptorUrl:{type:String,value:"analysis.json",observer:"_descriptorUrlChanged"},baseHref:String,rootNamespace:String,demoSrcPrefix:String,_loading:Boolean,_descriptorError:Object,_descriptor:{type:Object,observer:"_descriptorChanged"},_path:String,_narrow:Boolean,_title:{type:String,observer:"_titleChanged"}},_onViewChanged(){this.$.viewer.scrollIntoView()},_onNavSelect(){this.$.viewer.scrollIntoView(),this._narrow&&this.$.drawer.close()},_descriptorUrlChanged(){this._descriptorError=null},_descriptorChanged(r){r&&!this._changing&&(this._changing=!0,this._descriptor=_flatten(r),this._changing=!1)},_titleChanged(r){window.document.title=r}});