import{LitElement as e,html as t,css as i}from"../../lit/index.js";import{IntersectionObserverMixin as a}from"../intersection-element/lib/IntersectionObserverMixin.js";class WikipediaQuery extends(a(e)){static get styles(){return[i`
        :host {
          display: block;
          --wikipedia-query-body-height: 160px;
          --wikipedia-query-background-color: #f8f8f8;
        }
        :host [hidden] {
          display: none;
        }
        #result {
          height: var(--wikipedia-query-body-height);
          overflow: scroll;
          border: 1px grey solid;
          padding: 8px 16px;
        }
        citation-element {
          background-color: var(--wikipedia-query-background-color);
          padding: 16px 8px;
          font-size: 12px;
        }
      `]}constructor(){super(),this.hideTitle=!1;const e=globalThis.document.body.getAttribute("xml:lang")||globalThis.document.body.getAttribute("lang")||globalThis.document.documentElement.getAttribute("xml:lang")||globalThis.document.documentElement.getAttribute("lang")||globalThis.navigator.language||"en";this.language=e.split("-")[0],this.headers={cache:"force-cache"};let t=new Date(Date.now());this.__now=t.getDate()+"/"+(t.getMonth()+1)+"/"+t.getFullYear()}static get tag(){return"wikipedia-query"}render(){return t` ${this.elementVisible?t` <h3 .hidden="${this.hideTitle}" part="heading-3">
            ${this._title}
          </h3>
          <div id="result"></div>
          <citation-element
            creator="{Wikipedia contributors}"
            scope="sibling"
            license="by-sa"
            title="${this.search} --- {Wikipedia}{,} The Free Encyclopedia"
            source="https://${this.language}.wikipedia.org/w/index.php?title=${this.search}"
            date="${this.__now}"
          ></citation-element>`:""}`}updateArticle(e,t,i){fetch(`https://${i}.wikipedia.org/w/api.php?origin=*&action=query&titles=${e}&prop=extracts&format=json`,t).then((e=>{if(e.ok)return e.json()})).then((e=>{this.handleResponse(e)}))}updated(e){e.forEach(((e,t)=>{"elementVisible"==t&&this[t]&&import("../citation-element/citation-element.js"),["elementVisible","search","headers","language"].includes(t)&&this.search&&this.headers&&this.elementVisible&&this.language&&(clearTimeout(this._debounce),this._debounce=setTimeout((()=>{this.updateArticle(this.search,this.headers,this.language)}),10)),"search"==t&&(this.title?this._title=this.title:this._title=this[t].replace("_"," ")+" Wikipedia article"),"title"==t&&this.title&&(this._title=this.title)}))}static get properties(){let e={};return super.properties&&(e=super.properties),{...e,title:{type:String},__now:{type:String},_title:{type:String},headers:{type:Object},hideTitle:{type:Boolean,attribute:"hide-title"},search:{type:String},language:{type:String}}}handleResponse(e){if(void 0!==e&&e.query)for(var t in e.query.pages)if(e.query.pages.hasOwnProperty(t)&&e.query.pages[t].extract&&this.shadowRoot&&this.shadowRoot.querySelector("#result")){let i=e.query.pages[t].extract;i=i.replace(/<script[\s\S]*?>/gi,"&lt;script&gt;"),i=i.replace(/<\/script>/gi,"&lt;/script&gt;"),i=i.replace(/<style[\s\S]*?>/gi,"&lt;style&gt;"),i=i.replace(/<\/style>/gi,"&lt;/style&gt;"),this.shadowRoot.querySelector("#result").innerHTML=i}}haxHooks(){return{gizmoRegistration:"haxgizmoRegistration"}}haxgizmoRegistration(e){globalThis.dispatchEvent(new CustomEvent("i18n-manager-register-element",{detail:{namespace:"wikipedia-query.haxProperties",localesPath:new URL("./locales",import.meta.url).href,locales:["es","fr"]}})),e.validGizmoTypes.push("wikipedia"),0===e.appList.filter(((e,t)=>e.connection.url===this.language+".wikipedia.org")).length&&globalThis.dispatchEvent(new CustomEvent("hax-register-app",{bubbles:!1,composed:!1,cancelable:!1,detail:this.haxAppDetails}))}get haxAppDetails(){return{details:{title:"Wikipedia",icon:"account-balance",color:"grey",author:"Wikimedia",description:"Encyclopedia of the world.",status:"available",tags:["Search","source","wikipedia","content","encyclopedia","wiki"]},connection:{protocol:"https",url:this.language+".wikipedia.org",data:{action:"query",list:"search",format:"json",origin:"*"},operations:{browse:{method:"GET",endPoint:"w/api.php",pagination:{style:"offset",props:{offset:"sroffset"}},search:{srsearch:{title:"Search",type:"string"}},data:{},resultMap:{image:"https://"+this.language+".wikipedia.org/static/images/project-logos/enwiki.png",defaultGizmoType:"wikipedia",items:"query.search",preview:{title:"title",details:"snippet",id:"title"},gizmo:{_url_source:"https://"+this.language+".wikipedia.org/wiki/<%= id %>",id:"title",title:"title",caption:"snippet",description:"snippet"}}}}}}}static get haxProperties(){return new URL(`./lib/${this.tag}.haxProperties.json`,import.meta.url).href}}customElements.define(WikipediaQuery.tag,WikipediaQuery);export{WikipediaQuery};