/**
 * Copyright 2021 The Pennsylvania State University
 * @license Apache-2.0, see License.md for full text.
 */
import{LitElement as t,html as e,css as i}from"../../lit/index.js";import"../simple-popover/simple-popover.js";import"../simple-modal/lib/simple-modal-template.js";class VocabTerm extends t{static get properties(){return{popoverMode:{type:Boolean,reflect:!0,attribute:"popover-mode"},detailsOpen:{type:Boolean},links:{type:Array,converter:{fromAttribute:t=>t.split(/\r?\n/).map((t=>{let e=t.split(",");return{title:e[0],href:e[1]}})),toAttribute:t=>t.map((t=>`${t.title},${t.href}`)).join("\n")}},information:{type:String},term:{type:String}}}constructor(){super(),this._haxstate=!1,this.popoverMode=!1,this.term=null,this.information=null,this.links=[],this.detailsOpen=!1,this.querySelector("summary")&&(this.term=this.querySelector("summary").textContent),this.querySelector('[slot="information"]')&&(this.information=this.querySelector('[slot="information"]').textContent)}haxHooks(){return{editModeChanged:"haxeditModeChanged",activeElementChanged:"haxactiveElementChanged"}}haxactiveElementChanged(t,e){e&&(this._haxstate=e)}haxeditModeChanged(t){this._haxstate=t}static get styles(){let t=[];return super.styles&&(t=super.styles),[t,i`
        :host {
          display: inline-flex;
        }
        simple-modal-template {
          --simple-modal-resize: both;
          --simple-modal-width: 300px;
          --simple-modal-height: 300px;
          --simple-modal-min-width: 300px;
          --simple-modal-min-height: 300px;
        }
        summary {
          list-style: none;
          border-bottom: var(--vocab-term-border-bottom, 1px dashed gray);
          color: var(--vocab-term-color, black);
        }
      `]}render(){return e` ${this.popoverMode?e`
          <details>
            <summary id="summary">${this.term}</summary>
            <div part="information">
              <simple-popover for="summary" position="top" auto>
                <p>${this.information}</p>
                <div part="links">
                  ${this.links&&this.links.length>0&&this.links.map?e`
                        <ul>
                          ${this.links.map((t=>e`
                              <li>
                                <a
                                  href="${t.href}"
                                  target="_blank"
                                  rel="noopener noreferrer"
                                  >${t.title}</a
                                >
                              </li>
                            `))}
                        </ul>
                      `:""}
                </div>
              </simple-popover>
            </div>
          </details>
        `:e`
          <div>
            <div part="term">
              <summary id="summary">${this.term}</summary>
            </div>
            <simple-modal-template title="${this.term?this.term:""}">
              <p slot="content">${this.information}</p>
              ${this.links&&this.links.length>0&&this.links.map?e` <ul slot="content">
                    ${this.links.map((t=>e`
                        <li>
                          <a
                            href="${t.href}"
                            target="_blank"
                            rel="noopener noreferrer"
                            >${t.title}</a
                          >
                        </li>
                      `))}
                  </ul>`:""}
            </simple-modal-template>
          </div>
        `}`}static get tag(){return"vocab-term"}_handleClick(t){this._haxstate||(t.preventDefault(),t.stopPropagation(),t.stopImmediatePropagation()),this.details&&void 0===this.detailsOpen&&(this.requestUpdate(),this.toggleOpen())}_handleKeyup(t){this._haxstate||(t.preventDefault(),t.stopPropagation(),t.stopImmediatePropagation()),(this.details&&void 0===this.detailsOpen&&13==t.keyCode||32==t.keyCode)&&this.toggleOpen()}toggleOpen(){this._haxstate||(console.log(this._haxstate),this.details.hasAttribute("open")?(this.details.removeAttribute("open"),this.detailsOpen&&(this.detailsOpen=!1)):(this.details.setAttribute("open","open"),this.detailsOpen&&(this.detailsOpen=!0)))}firstUpdated(t){super.firstUpdated&&super.firstUpdated(t),!this.term&&this.innerHTML&&(this.term=this.innerHTML),!1===this.popoverMode?(this.shadowRoot.querySelector("simple-modal-template").associateEvents(this.shadowRoot.querySelector("summary")),this.shadowRoot.querySelector("summary").addEventListener("focus",this.detailsFocusOut.bind(this))):this.details=this.shadowRoot.querySelector("details"),this.querySelector(".links a")&&this.querySelectorAll(".links a").forEach((t=>{this.links.push({title:t.textContent,href:t.getAttribute("href")})})),this.links=[...this.links]}detailsFocusOut(){this.shadowRoot.querySelector("details").removeAttribute("open"),this.shadowRoot.querySelector("summary").removeEventListener("focus",this.detailsFocusOut.bind(this))}updated(t){t.forEach(((t,e)=>{"popoverMode"===e&&(this[e]?(this.detailsOpen=!1,this.shadowRoot&&(this.details=this.shadowRoot.querySelector("details")),this.addEventListener("click",this._handleClick)):this.removeEventListener("click",this._handleClick))}))}static get haxProperties(){return new URL(`./lib/${this.tag}.haxProperties.json`,import.meta.url).href}}customElements.define(VocabTerm.tag,VocabTerm);export{VocabTerm};