/**
 * Copyright 2019 The Pennsylvania State University
 * @license Apache-2.0, see License.md for full text.
 */
import{LitElement as t,html as n}from"../../lit/index.js";const UndoManagerBehaviors=function(t){return class extends t{static get properties(){return{...super.properties,canUndo:{type:Boolean,attribute:"can-undo"},canRedo:{type:Boolean,attribute:"can-redo"},undoStackObserverProps:{type:Object},target:{type:Object},stack:{type:Object}}}constructor(){super(),this.__StackDebounce,this.undoStackLimit=20,this.undoStackTimer=300,this.undoStackIgnore=!1,this.undoStackObserver=null,this.undoStackObserverProps={attributes:!0,attributeOldValue:!0,childList:!0,characterData:!0,characterDataOldValue:!0,subtree:!0},this.undoStackInitialValue=this.innerHTML,this.undoStackPrevValue=this.undoStackInitialValue}connectedCallback(){this.undoStackObserver=new MutationObserver((t=>{clearTimeout(this.__StackDebounce),this.__StackDebounce=setTimeout((()=>{this.undoStackIgnore?this.undoStackIgnore=!1:this.undoManagerStackLogic(t)}),this.undoStackTimer)})),this.undoStackObserver.observe(this,this.undoStackObserverProps),this.undoManagerStackLogic({}),super.connectedCallback()}undoManagerStackLogic(t){const n=this.innerHTML;this.undoStack&&""!=n&&n!=this.undoStackPrevValue&&this.undoStackInitialValue!=n&&(this.undoStack.execute(new UndoManagerCommand(this,this.undoStackPrevValue,n)),this.undoStackPrevValue=n,this.dispatchEvent(new CustomEvent("stack-changed",{detail:{value:this.undoStack},bubbles:!0,composed:!0})))}disconnectedCallback(){this.undoStackObserver&&this.undoStackObserver.disconnect(),super.disconnectedCallback()}firstUpdated(t){super.firstUpdated&&super.firstUpdated(t),this.undoStack=new Undo,this.undoStack.undoStackLimit=this.undoStackLimit,this.undoStack.undoStackPosition=-1,this.undoStack.commands=[],this.undoStack.changed=t=>{this.canRedo=this.undoStack.canRedo(),this.canUndo=this.undoStack.canUndo()},this.undoStack.changed()}updated(t){super.updated&&super.updated(t),t.forEach(((t,n)=>{"canUndo"==n&&this.dispatchEvent(new CustomEvent("can-undo-changed",{detail:{value:this[n]},bubbles:!0,composed:!0})),"canRedo"==n&&this.dispatchEvent(new CustomEvent("can-redo-changed",{detail:{value:this[n]},bubbles:!0,composed:!0}))}))}undo(){return this.undoStack.undo()}redo(){return this.undoStack.redo()}commands(){return this.undoStack.commands}}};class UndoManager extends(UndoManagerBehaviors(t)){static get tag(){return"undo-manager"}render(){return n`<slot></slot>`}}customElements.define("undo-manager",UndoManager);class Undo{constructor(){this.commands=[],this.undoStackPosition=-1,this.undoStackLimit=20}execute(t){this._clearRedo(),t.execute(),this.undoStackLimit==this.commands.length?this.commands.splice(Math.round(this.commands.length/3),1):this.undoStackPosition++,this.commands.push(t),this.changed()}undo(){this.commands[this.undoStackPosition]&&(this.commands[this.undoStackPosition].undo(),this.undoStackPosition--,this.changed())}canUndo(){return this.undoStackPosition>=0}redo(){this.commands[this.undoStackPosition+1]&&(this.undoStackPosition++,this.commands[this.undoStackPosition].redo(),this.changed())}canRedo(){return this.undoStackPosition<this.commands.length-1}_clearRedo(){this.commands=this.commands.slice(0,this.undoStackPosition+1)}changed(){}}class UndoManagerCommand{constructor(t,n,e){this.el=t,this.oldValue=n,this.newValue=e}execute(){}undo(){this.el.undoStackIgnore=!0,this.el.undoStack.commands&&this.el.undoStack.commands[this.el.undoStack.undoStackPosition-1]?this.el.innerHTML=this.el.undoStack.commands[this.el.undoStack.undoStackPosition-1].newValue:this.el.undoStack.commands&&0===this.el.undoStack.undoStackPosition?this.el.innerHTML=this.el.undoStackInitialValue:this.el.innerHTML=this.oldValue}redo(){this.el.undoStackIgnore=!0,this.el.innerHTML=this.newValue}}export{UndoManager,Undo,UndoManagerCommand,UndoManagerBehaviors};