/**
 * Copyright 2020 The Pennsylvania State University
 * @license Apache-2.0, see License.md for full text.
 */
import{LitElement as e,html as t,css as i}from"../../lit/index.js";import{IntersectionObserverMixin as r}from"../intersection-element/lib/IntersectionObserverMixin.js";class TypeWriter extends(r(e)){static get styles(){return[i`
        :host {
          display: inline-block;
          margin: 0px 0.1em;
        }

        @keyframes flickerAnimation {
          0% {
            opacity: 1;
          }

          50% {
            opacity: 0;
          }

          100% {
            opacity: 1;
          }
        }
        @-o-keyframes flickerAnimation {
          0% {
            opacity: 1;
          }

          50% {
            opacity: 0;
          }

          100% {
            opacity: 1;
          }
        }
        @-moz-keyframes flickerAnimation {
          0% {
            opacity: 1;
          }

          50% {
            opacity: 0;
          }

          100% {
            opacity: 1;
          }
        }
        @-webkit-keyframes flickerAnimation {
          0% {
            opacity: 1;
          }

          50% {
            opacity: 0;
          }

          100% {
            opacity: 1;
          }
        }

        #cursor {
          display: none;
          opacity: 0;
        }

        :host([typing]) #cursor {
          display: inline;
          -webkit-animation: flickerAnimation 1s infinite;
          -moz-animation: flickerAnimation 1s infinite;
          -o-animation: flickerAnimation 1s infinite;
          animation: flickerAnimation 1s infinite;
        }
      `]}render(){return t` <span id="text"></span><span id="cursor">|</span>`}static get haxProperties(){return{canScale:!0,canEditSource:!0,gizmo:{title:"Type writer",description:"typewritter effect",icon:"hardware:keyboard",color:"green",tags:["Other","interactive","fancy","Writer","type"],handles:[],meta:{author:"HAXTheWeb",owner:"The Pennsylvania State University"}},settings:{configure:[{property:"delay",description:"",inputMethod:"textfield",required:!1},{property:"cursorDuration",description:"",inputMethod:"textfield",required:!1},{property:"text",description:"",inputMethod:"textfield",required:!1},{property:"speed",description:"",inputMethod:"textfield",required:!1},{property:"typing",description:"",inputMethod:"boolean",required:!1}],advanced:[]},saveOptions:{unsetAttributes:["element-visible"]}}}static get properties(){return{...super.properties,delay:{type:Number},cursorDuration:{type:Number,attribute:"cursor-duration"},text:{type:String},speed:{type:Number},elementVisible:{type:Boolean},eraseSpeed:{type:Number,attribute:"erase-speed"},typing:{type:Boolean,reflect:!0},_length:{type:Number},_oldText:{type:String}}}static get tag(){return"type-writer"}constructor(){super(),this.delay=100,this.cursorDuration=0,this.speed=150,this.eraseSpeed=80,this.typing=!1}_observeText(e,t,i){if(e&&void 0!==t&&i){if(this.shadowRoot.querySelector("#text").textContent)return this._oldText=this.shadowRoot.querySelector("#text").textContent,this.typing&&this._cancel&&(clearTimeout(this._cancel),this._cancel=null),this.erase();this._length=0,setTimeout((()=>{this.type()}),this.delay)}}type(){this.typing=!0,this.shadowRoot.querySelector("#text").textContent=this.text.substr(0,this._length++),this._length<this.text.length+1?this._cancel=setTimeout((()=>{this.type()}),this.speed+(Math.random()-.5)*this.speed/2):setTimeout((()=>{this.typing=!1,this.dispatchEvent(new CustomEvent("type-writer-end",{detail:this.text,bubbles:!0,composed:!0}))}),this.cursorDuration)}erase(){this.typing=!0,this.shadowRoot.querySelector("#text").textContent=this._oldText.substr(0,this._length--),this._length>=0?this._cancel=setTimeout((()=>{this.erase()}),this.eraseSpeed||this.speed):this.type()}updated(e){e.forEach(((e,t)=>{["text","delay","elementVisible"].includes(t)&&this._observeText(this.text,this.delay,this.elementVisible)}))}}customElements.define(TypeWriter.tag,TypeWriter);export{TypeWriter};