/**
 * Copyright 2024
 * @license Apache-2.0, see License.md for full text.
 */
import{html as e,css as t}from"../../lit/index.js";import{QuestionElement as r}from"../multiple-choice/lib/QuestionElement.js";import{DDD as s}from"../d-d-d/d-d-d.js";class TaggingQuestion extends r{static get tag(){return"tagging-question"}constructor(){super(),this.guessDataValue="selectedAnswers",this.dragEnter=!1,this.dragEnterAnswer=!1,this.dragging=!1,this.selectedAnswers=[]}static get styles(){return[super.styles,t`
        :host {
          display: block;
        }
        .tag-container {
          position: relative;
          display: flex;
          flex-direction: column;
          align-items: center;
          overflow: hidden;
          margin: var(--tagging-question-tag-container-margin, auto);
          padding: var(--ddd-spacing-5);
          height: var(--tagging-question-tag-container-height, auto);
          max-width: var(--tagging-question-tag-container-max-width, 600px);
          transition: height 0.3s ease;
        }

        .tag-option-container {
          width: var(--tagging-question-tag-option-container-width, 100%);
          border-radius: var(--ddd-radius-sm);
          box-sizing: border-box;
        }

        #user-choice-container {
          display: flex;
          transition: all 0.3s ease-in-out;
          flex-wrap: wrap;
          justify-content: center;
          overflow-y: auto;
          gap: var(--ddd-spacing-4);
          min-height: var(--ddd-spacing-18);
          margin-bottom: var(--ddd-spacing-5);
          padding: var(--ddd-spacing-5);
          border: var(--ddd-border-sm);
          border-radius: var(--ddd-radius-sm);
          box-sizing: border-box;
          background-color: (var(--ddd-theme-default-coalyGray));
        }

        #possible-container {
          display: flex;
          padding: var(--ddd-spacing-3);
          border-radius: var(--ddd-radius-sm);
          border: var(--ddd-border-xs);
          flex-wrap: wrap;
          justify-content: center;
          gap: var(--ddd-spacing-4);
          min-height: var(--ddd-spacing-12);
        }

        :host([show-answer]) .tag-option {
          cursor: unset;
        }

        :host(:not([show-answer])) .tag-option:hover,
        :host(:not([show-answer])) .tag-option:focus {
          background-color: var(--ddd-theme-default-disable);
        }

        :host([dragging]) #user-choice-container {
          border-style: dashed;
          border-color: gray;
        }
        :host([drag-enter-answer][dragging]) #user-choice-container {
          border-style: dashed;
          border-color: black;
          background-color: (var(--ddd-theme-default-coalyGray));
        }
        :host([drag-enter][dragging]) #possible-container {
          border-color: black;
          border-style: dashed;
          background-color: (var(--ddd-theme-default-coalyGray));
        }

        .tag-option {
          font-size: var(--ddd-font-size-s);
          height: auto;
          display: inline-block;
          font-family: var(--ddd-font-navigation);
          padding: var(--ddd-spacing-2) var(--ddd-spacing-3);
          border: var(--ddd-border-sm);
          border-radius: var(--ddd-radius-sm);
          background-color: var(--ddd-theme-default-coalyGray);
          cursor: pointer;
          user-select: none;
          transition: background-color 0.3s ease;
        }
      `]}renderDirections(){return e`<p>
      Select all that apply. When you are done, press
      <strong>${this.t.checkAnswer}</strong>. You will get feedback indicating
      correctness of your answer and how to proceed.
    </p>`}renderInteraction(){return e`<div class="tag-option-container">
      <div
        id="user-choice-container"
        @drop="${this.handleDrop}"
        @dragover="${this.allowDropAnswer}"
      >
        ${this.selectedAnswers.map((t=>e`
            <button
              ?disabled="${this.disabled||this.showAnswer}"
              class="tag-option ${this.showAnswer?t.correct?"correct":"incorrect":""}"
              draggable="${this.showAnswer?"false":"true"}"
              @dragstart="${this.handleDrag}"
              @dragend="${this.handleDragEnd}"
              @click="${()=>this.handleTagClick(t)}"
            >
              ${t.label}
            </button>
          `))}
      </div>
      <div
        id="possible-container"
        @drop="${this.handleDrop}"
        @dragover="${this.allowDrop}"
      >
        ${this.displayedAnswers.map((t=>e`
            <button
              ?disabled="${this.disabled||this.showAnswer}"
              class="tag-option"
              draggable="${this.showAnswer?"false":"true"}"
              @dragstart="${this.handleDrag}"
              @dragend="${this.handleDragEnd}"
              @click="${()=>this.handleTagClick(t)}"
            >
              ${t.label}
            </button>
          `))}
      </div>
    </div>`}isCorrect(){return this.answers.filter((e=>e.correct)).length===this.selectedAnswers.filter((e=>e.correct)).length&&this.selectedAnswers.filter((e=>e.correct)).length===this.selectedAnswers.length}renderFeedback(){return e` ${this.edit?this.renderEditModeFeedbackAreas():e`
          ${this.showAnswer&&!this.isCorrect()?e` <p class="feedback">${this.incorrectText}</p>
                ${this.querySelector&&this.querySelector('[slot="feedbackIncorrect"]')?e`<slot name="feedbackIncorrect"></slot>`:""}`:""}
          ${this.showAnswer&&this.isCorrect()?e` <p class="feedback">${this.correctText}</p>
                ${this.querySelector&&this.querySelector('[slot="feedbackCorrect"]')?e`<slot name="feedbackCorrect"></slot>`:""}`:""}
          ${this.showAnswer?e`
      <p class="feedback">${this.selectedAnswers.filter((e=>e.correct)).length} out of ${this.answers.filter((e=>e.correct)).length} correct${this.selectedAnswers.length>this.answers.filter((e=>e.correct)).length&&this.selectedAnswers.length>this.selectedAnswers.filter((e=>e.correct)).length?e`, <strong>but too many options present!</strong>`:"."}</p>
      <h4>Answers selected</h4>
      <dl>
      ${this.selectedAnswers.map((t=>e`
          <dt class="${t.correct?"correct":"incorrect"}">
            ${t.label}
          </dt>
          <dd>${t.selectedFeedback}</dd>
        `))}
      </dl>
      <h4>Answers not selected</h4>
      <p>Incorrectness implies it should have been selected. Correctness implies it was correctly <strong>not</strong> selected</p>
      <dl>
      ${this.displayedAnswers.map((t=>e`
          <dt class="${t.correct?"incorrect":"correct"}">
            ${t.label}
          </dt>
          <dd>${t.unselectedFeedback}</dd>
        `))}
      </dl>
    </div>
  `:""}
          ${this.querySelector&&this.querySelector('[slot="hint"]')&&this.showAnswer&&!this.isCorrect()?e`
                <h4>Need a hint?</h4>
                <div>
                  <slot name="hint"></slot>
                </div>
              `:""}
          ${this.querySelector&&this.querySelector('[slot="evidence"]')&&this.showAnswer&&this.isCorrect()?e`
                <h4>Evidence</h4>
                <div>
                  <slot name="evidence"></slot>
                </div>
              `:""}
          <simple-toolbar-button
            ?disabled="${this.disabled||!this.showAnswer}"
            @click="${this.resetAnswer}"
            label="${this.t.tryAgain}"
          >
          </simple-toolbar-button>
        `}`}randomizeOptions(e){for(let t=e.length-1;t>0;t--){const r=Math.floor(Math.random()*(t+1));[e[t],e[r]]=[e[r],e[t]]}return e}handleDrag(e){const t=e.target.textContent.trim();e.dataTransfer.setData("text/plain",t),this.dragging=!0}handleDragEnd(e){const t=e.target.textContent.trim();e.dataTransfer.setData("text/plain",t),this.dragging=!1,this.dragEnter=!1,this.dragEnterAnswer=!1}allowDrop(e){e.preventDefault(),this.dragEnter=!0,this.dragEnterAnswer=!1}allowDropAnswer(e){e.preventDefault(),this.dragEnterAnswer=!0,this.dragEnter=!1}handleDrop(e){e.preventDefault(),this.dragging=!1,this.dragEnter=!1,this.dragEnterAnswer=!1;const t=e.dataTransfer.getData("text/plain");let r=this.answers.find((e=>e.label===t));const s=this.displayedAnswers.findIndex((e=>e.label===t)),a=this.selectedAnswers.findIndex((e=>e.label===t));-1!==s&&e.target&&"possible-container"!==e.target.getAttribute("id")?this.handleTagMove(r,"possible-container"):-1!==a&&e.target&&"user-choice-container"!==e.target.getAttribute("id")&&this.handleTagMove(r,"user-choice-container")}handleTagMove(e,t){"user-choice-container"===t?this.removeTag(e):this.addTag(e)}handleTagClick(e){1===this.selectedAnswers.filter((t=>t.label===e.label)).length?this.handleTagMove(e,"user-choice-container"):1===this.displayedAnswers.filter((t=>t.label===e.label)).length&&this.handleTagMove(e,"possible-container")}addTag(e){this.showAnswer||(this.selectedAnswers.push(e),this.displayedAnswers=this.displayedAnswers.filter((t=>t.label!==e.label)),this.requestUpdate())}removeTag(e){this.showAnswer||(this.selectedAnswers=this.selectedAnswers.filter((t=>t.label!==e.label)),this.displayedAnswers.push(e),this.requestUpdate())}resetAnswer(){this.showAnswer=!1,globalThis.dispatchEvent(new CustomEvent("simple-toast-hide",{bubbles:!0,composed:!0,cancelable:!1,detail:!1})),this.isCorrect()&&(this.displayedAnswers=[...this.answers],this.selectedAnswers=[],this.randomizeOptions(this.displayedAnswers))}static get properties(){return{...super.properties,dragging:{type:Boolean,reflect:!0},dragEnter:{type:Boolean,reflect:!0,attribute:"drag-enter"},dragEnterAnswer:{type:Boolean,reflect:!0,attribute:"drag-enter-answer"},selectedAnswers:{type:Array}}}static get haxProperties(){return new URL(`./lib/${this.tag}.haxProperties.json`,import.meta.url).href}}globalThis.customElements.define(TaggingQuestion.tag,TaggingQuestion);export{TaggingQuestion};