import{css as t,html as e,unsafeCSS as i}from"../../../lit/index.js";import{SimpleToastEl as a}from"../../simple-toast/lib/simple-toast-el.js";import"../../future-terminal-text/future-terminal-text.js";import"../../simple-icon/lib/simple-icons.js";import"../../simple-icon/simple-icon.js";import"../../hax-iconset/lib/simple-hax-iconset.js";const l=new URL("./images/SpeechBubbleL.svg",import.meta.url).href,s=new URL("./images/SpeechBubbleMiddle.svg",import.meta.url).href,o=new URL("./images/SpeechBubbleR.svg",import.meta.url).href;export class SuperDaemonToast extends a{static get tag(){return"super-daemon-toast"}constructor(){super(),this.awaitingMerlinInput=!1,this.windowControllers=new AbortController,this.text="Saved",this.merlin=!1,this.classStyle="",this.future=!1,this.duration=3e3,this.accentColor="grey",this.dark=!1,this.eventCallback=null,this.fire=!1,this.hat="coffee",this.walking=!1}static get styles(){return[super.styles,t`
        :host {
          --simple-toast-z-index: 100000002;
        }
        :host([opened]) {
          display: flex;
        }

        future-terminal-text {
          min-width: 300px;
          overflow-wrap: break-all;
          text-overflow: ellipsis;
          line-height: 36px;
          font-size: 18px;
          text-align: left;
          padding: 36px 0px;
          max-width: 50vw;
        }

        .merlin {
          --simple-icon-height: 100px;
          --simple-icon-width: 100px;
          background-color: var(--simple-colors-default-theme-accent-1, white);
          display: block;
          height: 150px;
          width: 100px;
          margin: 6px 0 0 0;
          padding: 16px;
        }
        .awaiting-input {
          --simple-icon-height: 75px;
          --simple-icon-width: 75px;
          width: 100px;
          margin: 6px 0px 0px;
          padding: 16px;
          background-color: var(--simple-colors-default-theme-accent-2, white);
          color: var(--simple-colors-default-theme-purple-6, purple);
          vertical-align: middle;
          display: inline-flex;
          height: 100px;
        }
        :host([hidden]) {
          display: none;
        }
        :host {
          --simple-toast-bottom: 0px;
          --simple-toast-bottom-offscreen: -284px;
          height: 142px;
          display: none;
          width: var(--simple-toast-width, auto);
          color: var(
            --simple-toast-color,
            var(--simple-colors-default-theme-accent-12, black)
          );
          background-color: transparent;
          top: var(--simple-toast-top);
          margin: var(--simple-toast-margin, 4px);
          padding: var(--simple-toast-padding, 4px);
          bottom: var(--simple-toast-bottom, 36px);
          left: var(--simple-toast-left, 0px);
          border: var(--simple-toast-border);
          z-index: var(--simple-toast-z-index, 100000000);
          font-size: var(--simple-toast-font-size, 18px);
          font-family: "Press Start 2P", sans-serif;
          font-weight: bold;
          text-align: center;
          vertical-align: middle;
        }
        .bubble {
          height: 142px;
          display: inline-flex;
        }
        .mid {
          line-height: 142px;
          background-color: white;
          background-repeat: repeat-x;
          background-image: url("${i(s)}");
        }
        .leftedge {
          background-image: url("${i(l)}");
          width: 24px;
          background-color: white;
          transform: scaleX(-1);
        }
        .rightedge {
          background-image: url("${i(o)}");
          width: 42px;
          background-color: white;
          transform: scaleX(-1.1);
        }
        :host([dark-mode]) .mid,
        :host([dark-mode]) .leftedge,
        :host([dark-mode]) .rightedge {
          filter: invert(1);
        }
      `]}hideSimpleToast(t){this.alwaysvisible||(this.style.animation="forcedfadeout 0.6s .3s",this.awaitingMerlinInput=!1,setTimeout((()=>{this.hide()}),0))}static get properties(){return{...super.properties,darkMode:{type:Boolean,reflect:!0,attribute:"dark-mode"},fire:{type:Boolean},hat:{type:String},walking:{type:Boolean},opened:{type:Boolean,reflect:!0},awaitingMerlinInput:{type:Boolean,attribute:"awaiting-merlin-input"},merlin:{type:Boolean},future:{type:Boolean},text:{type:String},classStyle:{type:String,attribute:"class-style"},duration:{type:Number},eventCallback:{type:String,attribute:"event-callback"}}}render(){return e` <div class="bubble">
      ${this.awaitingMerlinInput?e`<simple-icon-lite
            class="awaiting-input"
            icon="hax:loading"
          ></simple-icon-lite>`:e`
            <simple-icon
              class="merlin"
              icon="hax:wizard-hat"
              accent-color="purple"
            ></simple-icon>
          `}
      <span class="bubble rightedge"></span>
      <span class="bubble mid">
        <slot name="pre"></slot>
        ${this.future?e` <future-terminal-text
              fadein
              glitch
              glitch-max="3"
              glitch-duration="40"
            ></future-terminal-text>`:e`${this.text}`}
        <slot></slot>
      </span>
      <span class="bubble leftedge"></span>
    </div>`}updated(t){super.updated(t),t.has("text")&&this.future&&this.shadowRoot.querySelector("future-terminal-text")&&(this.shadowRoot.querySelector("future-terminal-text").innerText=this.text,this.shadowRoot.querySelector("future-terminal-text")._doGlitch())}connectedCallback(){super.connectedCallback(),globalThis.addEventListener("super-daemon-toast-hide",this.hideSimpleToast.bind(this),{signal:this.windowControllers.signal}),globalThis.addEventListener("super-daemon-toast-show",this.showSimpleToast.bind(this),{signal:this.windowControllers.signal})}disconnectedCallback(){this.windowControllers.abort(),super.disconnectedCallback()}showSimpleToast(t){for(;null!==this.firstChild;)this.removeChild(this.firstChild);setTimeout((()=>{t.detail.slot&&this.appendChild(t.detail.slot)}),0),this.duration=t.detail.duration?t.detail.duration:4e3,this.fire=!!t.detail.fire&&t.detail.fire,this.hat=t.detail.hat?t.detail.hat:"coffee",this.merlin=!!t.detail.merlin&&t.detail.merlin,this.walking=!!t.detail.walking&&t.detail.walking,this.text=t.detail.text?t.detail.text:"Saved",this.future=!!t.detail.future&&t.detail.future,this.classStyle=t.detail.classStyle?t.detail.classStyle:"",this.eventCallback=t.detail.eventCallback?t.detail.eventCallback:null,this.accentColor=t.detail.accentColor?t.detail.accentColor:"grey",this.alwaysvisible=!!t.detail.alwaysvisible&&t.detail.alwaysvisible,t.detail.awaitingMerlinInput&&this.duration?setTimeout((()=>{this.style.animation="none",this.awaitingMerlinInput=t.detail.awaitingMerlinInput}),this.duration/2):this.awaitingMerlinInput=!1,this.show()}show(){this.opened||(this.style.animation="fadein 0.3s, fadeout 0.6s "+this.duration/1e3+"s",this.opened=!0)}hide(){if(this.awaitingMerlinInput)this.style.animation="fadein 0.3s";else{if(this.eventCallback){const t=new CustomEvent(this.eventCallback,{bubbles:!0,cancelable:!0,detail:!0,composed:!0});this.dispatchEvent(t)}this.alwaysvisible?this.style.animation="fadein 0.3s":this.opened=!1}}}customElements.define(SuperDaemonToast.tag,SuperDaemonToast),globalThis.SuperDaemonToast=globalThis.SuperDaemonToast||{},globalThis.SuperDaemonToast.requestAvailability=()=>(globalThis.SuperDaemonToast.instance||(globalThis.SuperDaemonToast.instance=globalThis.document.createElement(SuperDaemonToast.tag),globalThis.document.body.appendChild(globalThis.SuperDaemonToast.instance)),globalThis.SuperDaemonToast.instance);export const SuperDaemonToastInstance=globalThis.SuperDaemonToast.requestAvailability();