import{html as e,css as t}from"../../../lit/index.js";import{I18NMixin as i}from"../../i18n-manager/lib/I18NMixin.js";import{mimeTypeToName as o}from"../../utils/utils.js";import{SimpleColors as s}from"../../simple-colors/simple-colors.js";import"../../simple-fields/lib/simple-fields-field.js";import"../../simple-icon/lib/simple-icons.js";import"../../simple-icon/lib/simple-icon-button-lite.js";import"../../hax-iconset/lib/simple-hax-iconset.js";import"../../simple-icon/simple-icon.js";import"../../simple-icon/lib/simple-icon-lite.js";export class SuperDaemonSearch extends(i(s)){static get tag(){return"super-daemon-search"}constructor(){super(),this.focused=!1,this.icon="hardware:keyboard-return",this.iconAccent="purple",this.voiceSearch=!1,this.programSearch="",this.mini=!1,this.wand=!1,this.loading=!1,this.listeningForInput=!1,this.commandContext="*",this.value=null,this.disabled=!1,this.dragover=!1,this.droppable=!1,this.droppableType=null,this.t=this.t||{},this.t={...this.t,voiceSearch:"Voice search",filterCommands:"Filter commands",commands:"Commands"},this.possibleActions=[]}static get properties(){return{icon:{type:String},disabled:{type:Boolean,reflect:!0},iconAccent:{type:String,attribute:"icon-accent"},voiceSearch:{type:Boolean,reflect:!0,attribute:"voice-search"},possibleActions:{type:Array},listeningForInput:{type:Boolean,reflect:!0,attribute:"listening-for-input"},droppable:{type:Boolean,reflect:!0},dragover:{type:Boolean,reflect:!0},droppableType:{type:String,attribute:"droppable-type"},value:{type:String},mini:{type:Boolean,reflect:!0},wand:{type:Boolean,reflect:!0},programName:{type:String,attribute:"program-name"},commandContext:{type:String,attribute:"command-context"},focused:{type:Boolean,reflect:!0}}}voiceSearchClick(){if(!this.disabled){const e=globalThis.SuperDaemonManager.requestAvailability();this.listeningForInput?e.listeningForInput=!1:(e.hal.speak("How may I help you?",e.santaMode).then((t=>{e.playSound(),e.listeningForInput=!0})),this.focusInput())}}_inputKeydown(e){if(!this.disabled)switch(e.key){case"!":case"/":case"\\":case">":case"<":"\\"===e.key&&""==this.value||"!"===e.key&&""==this.value?(this.commandContext="/",e.preventDefault()):"<"===e.key&&""==this.value?(this.commandContext=">",e.preventDefault()):""==this.value&&(this.commandContext=e.key,e.preventDefault());break;case"Backspace":""==this.programSearch&&this.programName?(this.dispatchEvent(new CustomEvent("super-daemon-run-program",{bubbles:!0,cancelable:!0,composed:!0,detail:!1})),e.preventDefault()):!this.programName&&""==this.value&&this.commandContext&&(this.commandContext="*",e.preventDefault())}}inputfilterChanged(e){switch(e.target.value){case"!":case"/":case"\\":case">":case"<":"\\"===e.target.value&&""==this.value||"!"===e.target.value&&""==this.value?(this.commandContext="/",e.preventDefault()):"<"===e.target.value&&""==this.value?(this.commandContext=">",e.preventDefault()):""==this.value&&(this.commandContext=e.target.value,e.preventDefault()),e.target.value="";break;default:this.disabled||(e.stopPropagation(),e.stopImmediatePropagation(),this.value=e.target.value)}}render(){return e` ${"*"!=this.commandContext?e`<simple-icon-lite
            title="${this.getActiveTitle(this.commandContext)}"
            icon="${this.getActiveIcon(this.commandContext)}"
            class="user-context-icon"
          ></simple-icon-lite>`:""}
      ${this.programName?e`<span class="program">${this.programName}</span>`:""}
      <simple-fields-field
        id="inputfilter"
        ?disabled="${this.disabled}"
        @value-changed="${this.inputfilterChanged}"
        @keydown="${this._inputKeydown}"
        @focus="${this.fieldFocus}"
        @blur="${this.fieldFocusLoss}"
        .value="${this.value}"
        aria-controls="filter"
        label="${this.t.filterCommands}"
        type="text"
        auto-validate=""
        autofocus
        part="filter"
      ></simple-fields-field>
      ${this.voiceSearch?e`<simple-icon-button-lite
            class="voice ${this.listeningForInput?"listening":""}"
            @click="${this.voiceSearchClick}"
            icon="${this.listeningForInput?"hax:loading":"settings-voice"}"
            ?dark="${this.dark}"
            title="${this.t.voiceSearch}"
          ></simple-icon-button-lite>`:""}`}suggestPossibleAction(e=!1){return e?`📂 Drop '${o(e)}' here for options`:this.randomOption(this.possibleActions)}randomOption(e=[]){return e.length>0?e[Math.floor(Math.random()*Math.floor(e.length))]:void 0}firstUpdated(e){super.firstUpdated&&super.firstUpdated(e),this.shadowRoot.querySelector("#inputfilter").placeholder=this.suggestPossibleAction()}updated(e){if(super.updated(e),e.has("focused")&&this.dispatchEvent(new CustomEvent("focused-changed",{composed:!0,detail:{value:this.focused}})),e.has("wand"))if(this.wand){const e=globalThis.SuperDaemonManager.requestAvailability();e.opened?this.possibleActions=["🧑 Submit your ideas💡","📁 Drop files here 📄","🕵 Type what you want to do"]:this.possibleActions=[`🧙‍♂️ ${e.key1} + ${e.key2} opens Merlin`,"🔮 Click to do anything!","📁 Drop files here 📄"]}else this.possibleActions=["🔮 Insert blocks","🕵 Find media 📺"];e.has("droppableType")&&this.shadowRoot&&(this.shadowRoot.querySelector("#inputfilter").placeholder=this.suggestPossibleAction(this.droppableType)),e.has("droppable")&&!this.droppable&&(this.dragover=!1),e.has("value")&&void 0!==e.get("value")&&this.dispatchEvent(new CustomEvent("value-changed",{composed:!0,detail:{value:this.value}})),e.has("listeningForInput")&&this.dispatchEvent(new CustomEvent("listening-for-input-changed",{composed:!0,detail:{value:this.listeningForInput}})),e.has("commandContext")&&this.dispatchEvent(new CustomEvent("command-context-changed",{composed:!0,detail:{value:this.commandContext}}))}fieldFocusLoss(e){this.focused=!1}fieldFocus(e){this.focused=!0}focusInput(){setTimeout((()=>{this.shadowRoot.querySelector("#inputfilter").focus(),this.shadowRoot.querySelector("#inputfilter").cursorAtEnd()}),0)}selectInput(){setTimeout((()=>{this.shadowRoot.querySelector("#inputfilter").select()}),0)}static get styles(){let e=[];return super.styles&&(e=super.styles),[e,t`
        :host {
          display: flex;
          margin: 0;
        }
        :host([droppable]) {
          outline-offset: -4px;
          outline: 4px solid rgba(255, 0, 255, 0.1);
        }
        :host([droppable]),
        :host([droppable]) .voice,
        :host([droppable]) simple-fields-field {
          --simple-fields-placeholder-font-weight: bold;
          --simple-fields-placeholder-opacity: 0.8;
          --simple-fields-placeholder-color: var(--ddd-theme-default-coalyGray);
          background-color: rgba(255, 0, 255, 0.05);
        }
        :host([droppable][dragover]) {
          outline: 4px dashed rgba(255, 0, 255, 0.2);
        }
        :host([droppable][dragover]),
        :host([droppable][dragover]) .voice,
        :host([droppable][dragover]) simple-fields-field {
          background-color: rgba(255, 0, 255, 0.1);
        }
        :host([disabled]) {
          pointer-events: none;
        }
        :host .icon {
          display: inline-flex;
          --simple-icon-height: 50px;
          --simple-icon-width: 100px;
        }
        .voice {
          --simple-icon-height: 50px;
          --simple-icon-width: 100px;
          --simple-icon-button-border-radius: 0;
          color: var(--simple-colors-default-theme-grey-10, grey);
          transition: color 0.6s ease-in-out;
          margin: 0 16px 0 4px;
        }
        :host([mini]) .voice {
          --simple-icon-height: 24px;
          --simple-icon-width: 24px;
        }
        .voice:hover,
        .voice:focus {
          color: var(--simple-colors-default-theme-purple-6, purple);
        }
        .voice.listening {
          color: var(--simple-colors-default-theme-purple-4, purple);
        }

        .user-context-icon {
          display: inline-flex;
          --simple-icon-height: 50px;
          --simple-icon-width: 30px;
        }
        :host([mini]) .user-context-icon {
          --simple-icon-height: 32px;
          --simple-icon-width: 32px;
          margin-top: 8px;
          margin-left: 6px;
        }
        .program {
          display: inline-flex;
          font-family: "Roboto Mono", monospace;
          color: var(--simple-colors-default-theme-grey-1, white);
          background-color: var(--simple-colors-default-theme-grey-12, black);
          line-break: anywhere;
          word-break: break-all;
          word-wrap: break-word;
          text-overflow: clip;
          overflow: hidden;
          line-height: 16px;
          height: 16px;
          padding: 2px 4px;
          margin: 16px 0 0 -2px;
          font-size: 10px;
          width: 100%;
          max-width: 100px;
        }
        :host([mini]) .program {
          line-height: 24px;
          font-size: 12px;
          max-width: 8px;
          height: 24px;
          margin: 0px;
          padding: 0px 4px 0px 2px;
          font-weight: bold;
          font-style: italic;
        }
        simple-fields-field {
          line-height: 40px;
          padding: 8px;
          color: var(--simple-colors-default-theme-grey-12, black);
          background-color: var(--simple-colors-default-theme-grey-1, white);
          line-height: normal;
          font-family: inherit;
          width: var(--super-daemon-search-width, 240px);
          margin: 4px 0 0 0;
          min-width: 100px;
          --simple-fields-background-color: transparent;
          --simple-fields-placeholder-opacity: 0.4;
          --simple-fields-placeholder-color: var(
            --simple-colors-default-theme-purple-12,
            purple
          );
        }
        simple-tag:hover,
        simple-tag:focus {
          cursor: pointer;
          outline: 1px solid var(--simple-colors-default-theme-grey-10, black);
          outline-offset: 4px;
        }
        :host([mini]) simple-fields-field::part(option-input) {
          font-size: 12px;
          --simple-fields-text-align: left;
        }
        :host([mini][wand]) simple-fields-field::part(option-input) {
          font-size: 14px;
        }
        simple-fields-field::part(option-input) {
          padding: 0px 2px;
          font-size: 24px;
        }
        simple-fields-field::part(label) {
          opacity: 0;
          height: 0;
          width: 0;
          position: absolute;
          pointer-events: none;
        }

        @media screen and (max-width: 800px) {
          .voice {
            --simple-icon-height: 30px;
            --simple-icon-width: 30px;
          }
          .search {
            margin: 8px;
          }
          simple-fields-field::part(option-input) {
            font-size: 14px;
            line-height: 20px;
          }
          simple-fields-field {
            line-height: 20px;
            width: var(--super-daemon-search-width, 100px);
          }
          .search .icon {
            display: none;
          }
        }
        :host([mini]) {
          color: var(--simple-colors-default-theme-grey-12, black);
          background-color: var(--simple-colors-default-theme-grey-1, white);
        }
        :host([mini]) .search .icon {
          display: none;
        }
      `]}getActiveTitle(e){switch(e){case"/":return this.t.slashCommandsActive;case">":return this.t.developerConsoleActive}return""}getActiveIcon(e){switch(e){case"/":return"hax:wand";case">":return"hax:console-line"}return""}}customElements.define(SuperDaemonSearch.tag,SuperDaemonSearch);