import{html as e,css as t}from"../../../lit/index.js";import"../../simple-icon/lib/simple-icons.js";import"../../simple-icon/lib/simple-icon-lite.js";import"../../simple-fields/lib/simple-tag.js";import{SimpleColors as i}from"../../simple-colors/simple-colors.js";export class SuperDaemonRow extends i{constructor(){super(),this.title=null,this.path=null,this.icon=null,this.image=null,this.textCharacter=null,this.eventName=null,this.more=!1,this.showDetails=!1,this.value={},this.tags=[],this.shadowRootOptions={...i.shadowRootOptions,delegatesFocus:!0},this.active=!1}static get tag(){return"super-daemon-row"}static get properties(){return{...super.properties,title:{type:String},path:{type:String},icon:{type:String},mini:{type:Boolean,reflect:!0},image:{type:String},textCharacter:{type:String,attribute:"text-character"},more:{type:Boolean},showDetails:{type:Boolean},eventName:{type:String,attribute:"event-name"},value:{type:Object},tags:{type:Array},active:{type:Boolean,reflect:!0}}}static get styles(){let e=[];return super.styles&&(e=super.styles),[e,t`
        :host {
          display: block;
          margin: 8px 16px;
          color: var(--simple-colors-default-theme-accent-12, black);
          background-color: var(--simple-colors-default-theme-accent-1, white);
        }
        :host([active]) {
          cursor: pointer;
          border-radius: 4px;
          background-color: var(
            --super-daemon-row-hover,
            rgba(0, 100, 200, 0.1)
          );
          outline: 1px solid black;
        }
        :host([mini]) {
          margin: 0;
          --super-daemon-row-label: 14px;
          --super-daemon-row-path: 10px;
        }
        button {
          display: flex;
          padding: 8px;
          width: 100%;
          border-radius: 0;
          color: var(--simple-colors-default-theme-accent-12, black);
          background-color: var(--simple-colors-default-theme-accent-1, white);
          border: none;
          align-items: middle;
          justify-content: space-between;
          background-color: transparent;
        }
        :host([mini]) button {
          padding: 4px;
          justify-content: flex-start;
          align-items: center;
        }
        .result-icon {
          display: inline-flex;
          --simple-icon-height: var(--super-daemon-row-icon, 50px);
          --simple-icon-width: var(--super-daemon-row-icon, 50px);
        }
        :host([mini]) .result-icon {
          --simple-icon-height: var(--super-daemon-row-icon, 20px);
          --simple-icon-width: var(--super-daemon-row-icon, 20px);
        }
        .result-image {
          display: inline-flex;
          height: 64px;
          width: 100px;
        }
        .result-textCharacter {
          display: inline-flex;
          max-height: 64px;
          max-width: 100px;
          font-size: 42px;
        }
        :host([mini]) .result-textCharacter {
          font-size: 20px;
          height: 20px;
          width: 20px;
        }
        :host([mini]) .result-image {
          height: 32px;
          width: 50px;
        }
        .label-wrap {
          margin-left: 16px;
          min-width: 70%;
          overflow: hidden;
          text-align: left;
        }
        :host([mini]) .label-wrap {
          width: 100%;
          margin-left: 12px;
        }
        .tags {
          line-height: 32px;
          height: 64px;
          text-align: left;
          overflow: hidden;
        }
        :host([mini]) .tags {
          display: none;
        }
        .label-wrap .action {
          font-size: var(--super-daemon-row-label, 32px);
          font-weight: bold;
          max-width: 90%;
          word-break: break-all;
          overflow: hidden;
          line-height: var(--super-daemon-row-label, 32px);
          height: var(--super-daemon-row-label, 32px);
        }
        :host([mini]) .label-wrap .action {
          max-width: unset;
        }
        .label-wrap .path {
          font-size: var(--super-daemon-row-path, 20px);
          font-style: italic;
          margin-top: 6px;
          overflow-wrap: break-word;
          word-break: break-all;
          overflow: hidden;
          max-width: 80%;
          line-height: var(--super-daemon-row-path, 20px);
          height: var(--super-daemon-row-path, 20px);
        }
        :host([mini]) .label-wrap .path {
          max-width: unset;
        }
        .more {
          --simple-icon-width: 40px;
          --simple-icon-height: 40px;
          width: 40px;
          height: 40px;
          display: block;
        }
        summary {
          display: none;
        }
        @keyframes details-show {
          from {
            opacity: 0;
            transform: var(--details-translate, translateY(-0.5em));
          }
          to {
            opacity: 1;
            transform: var(--details-translate, translateY(0));
          }
        }

        details[open] {
          padding: 0 16px 16px 16px;
          animation: details-show 100ms ease-in-out;
          line-height: 16px;
          font-size: 12px;
        }
      `]}keyEvent(e){"Enter"!==e.code&&"Space"!==e.code||(this.selected(),e.preventDefault(),e.stopPropagation(),e.stopImmediatePropagation())}clickEvent(e){this.selected()}selected(){this.dispatchEvent(new CustomEvent("super-daemon-row-selected",{composed:!0,bubbles:!0,cancelable:!0,detail:this})),this.dispatchEvent(new CustomEvent(this.eventName,{composed:!0,bubbles:!0,cancelable:!0,detail:this.value})),"super-daemon-run-program"!==this.eventName&&this.dispatchEvent(new CustomEvent("super-daemon-close",{composed:!0,bubbles:!0,cancelable:!0,detail:this}))}_focusIn(e){this.active=!0}_focusOut(e){this.active=!1}focus(){this.shadowRoot.querySelector("button").focus()}pickColor(e){return 0===e?"blue":"orange"}render(){return e`
      <button
        part="button"
        @click="${this.clickEvent}"
        @keydown="${this.keyEvent}"
        @mouseover="${this._focusIn}"
        @mouseout="${this._focusOut}"
        @focusin="${this._focusIn}"
        @focusout="${this._focusOut}"
      >
        ${this.icon?e`<simple-icon-lite
              icon="${this.icon}"
              class="result-icon"
            ></simple-icon-lite>`:""}
        ${this.image?e`<img src="${this.image}" class="result-image" alt="" />`:""}
        ${this.textCharacter?e`<span class="result-textCharacter"
              >${this.textCharacter}</span
            >`:""}
        <div class="label-wrap" part="label-wrap">
          <div class="action" part="action">${this.title}</div>
          <div class="path" part="path">${this.path}</div>
        </div>
        <div class="tags" part="tags">
          ${this.tags.map(((t,i)=>e` <simple-tag
                accent-color="${this.pickColor(i)}"
                value="${t}"
                part="tag tag-${i}"
              ></simple-tag>`))}
        </div>
        ${this.more?e`<simple-icon-button
              class="more"
              ?dark="${this.dark}"
              accent-color="${this.accentColor}"
              label="More details"
              icon="more-vert"
              aria-controls="details"
              @click="${this.toggleDetailsClick}"
              @keydown="${this.toggleDetailsKey}"
            ></simple-icon-button>`:e`<div class="more"></div>`}
      </button>
      ${this.more?e`<details
            id="details"
            ?open="${this.showDetails}"
            @toggle="${this.openChanged}"
          >
            <summary>Details</summary>
            <div>
              <slot></slot>
            </div>
          </details>`:""}
    `}toggleDetailsKey(e){"Enter"!==e.key&&"Space"!==e.key||(this.showDetails=!this.showDetails,e.preventDefault(),e.stopPropagation(),e.stopImmediatePropagation())}toggleDetailsClick(e){this.showDetails=!this.showDetails,e.preventDefault(),e.stopPropagation(),e.stopImmediatePropagation()}openChanged(e){this.showDetails=e.target.open}}customElements.define(SuperDaemonRow.tag,SuperDaemonRow);