import{html as t,css as e}from"../../lit/index.js";import{remoteLinkBehavior as o}from"../utils/lib/remoteLinkBehavior.js";import{SimpleIconsetStore as i}from"../simple-icon/lib/simple-iconset.js";import{I18NMixin as r}from"../i18n-manager/lib/I18NMixin.js";import"../simple-icon/simple-icon.js";import{DDD as n}from"../d-d-d/d-d-d.js";import{DDDMarginPadding as d,DDDBorders as s}from"../d-d-d/lib/DDDStyles.js";i.registerIconset("stopnoteicons",`${new URL("./stop-note.js",import.meta.url).href}/../lib/svgs/stopnoteicons/`);export const StopNoteIconList={stop:"stopnoteicons:stop-icon",warning:"stopnoteicons:warning-icon",success:"stopnoteicons:confirm-icon",info:"stopnoteicons:book-icon"};class StopNote extends(r(o(n))){static get styles(){return[super.styles,s,d,e`
        :host {
          display: block;
          color: black;
          width: auto;
          --background-color: var(
            --ddd-component-stop-note-icon-background,
            var(--ddd-theme-default-errorLight)
          );
          --accent-color: var(
            --ddd-component-stop-note-text-background,
            var(--ddd-theme-default-error)
          );
          margin: var(--ddd-spacing-5) 0;
        }

        simple-icon {
          --simple-icon-height: var(--ddd-icon-4xl);
          --simple-icon-width: var(--ddd-icon-4xl);
        }

        :host([icon="stopnoteicons:stop-icon"]) {
          --accent-color: var(--ddd-theme-default-original87Pink);
          --background-color: var(--ddd-theme-default-errorLight);
        }
        :host([status="stop"]) {
          --accent-color: var(--ddd-theme-default-original87Pink);
          --background-color: var(--ddd-theme-default-errorLight);
        }

        :host([icon="stopnoteicons:warning-icon"]) {
          --accent-color: var(--ddd-theme-default-keystoneYellow);
          --background-color: var(--ddd-theme-default-warningLight);
        }
        :host([status="warning"]) {
          --accent-color: var(--ddd-theme-default-keystoneYellow);
          --background-color: var(--ddd-theme-default-warningLight);
        }

        :host([icon="stopnoteicons:confirm-icon"]) {
          --accent-color: light-dark(
            var(--ddd-theme-default-success),
            var(--ddd-theme-default-opportunityGreen)
          );
          --background-color: var(--ddd-theme-default-successLight);
        }
        :host([status="success"]) {
          --accent-color: light-dark(
            var(--ddd-theme-default-success),
            var(--ddd-theme-default-opportunityGreen)
          );
          --background-color: var(--ddd-theme-default-successLight);
        }

        :host([icon="stopnoteicons:book-icon"]) {
          --accent-color: light-dark(
            var(--ddd-theme-default-info),
            var(--ddd-theme-default-skyBlue)
          );
          --background-color: var(--ddd-theme-default-infoLight);
        }
        :host([status="info"]) {
          --accent-color: light-dark(
            var(--ddd-theme-default-info),
            var(--ddd-theme-default-skyBlue)
          );
          --background-color: var(--ddd-theme-default-infoLight);
        }

        .container {
          display: flex;
          width: auto;
        }

        .message_wrap {
          padding: var(--ddd-spacing-1) var(--ddd-spacing-6);
          flex: 1 1 auto;
          transition: background-color 0.3s ease-in-out;
          background-color: var(
            --ddd-component-stop-note-text-background,
            var(--background-color)
          );
          border-right: var(--ddd-border-lg);
          border-color: var(
            --ddd-component-stop-note-border,
            var(--accent-color)
          );
        }

        .message_wrap > * {
          margin-bottom: var(--ddd-spacing-2);
        }

        .main_message {
          padding-bottom: 0;
        }

        :host([title=""]) .secondary_message {
          display: flex;
          height: 60%;
          align-items: center;
          margin-top: auto;
          font-size: var(--ddd-font-size-s);
          width: 100%;
          font-weight: var(--ddd-font-weight-bold);
        }

        .secondary_message {
          width: 100%;
          font-weight: var(--ddd-font-weight-regular);
        }

        a:-webkit-any-link {
          text-decoration: none;
        }
        a:hover {
          text-decoration: underline;
        }

        .svg {
          display: flex;
          justify-content: center;
        }

        .svg_wrap {
          display: flex;
          align-items: center;
          justify-content: center;
          transition: background-color 0.3s ease-in-out;
          background-color: var(
            --ddd-component-stop-note-icon-background,
            var(--accent-color)
          );
          padding: var(--ddd-spacing-2);
          width: auto;
        }

        .mt-2 {
          margin-top: var(--ddd-spacing-2);
        }

        .mt-5 {
          margin-top: var(--ddd-spacing-5);
        }

        .link {
          margin-bottom: var(--ddd-spacing-1);
        }
      `]}render(){return t`
      <div class="container">
        <div class="svg_wrap">
          <div class="svg">
            <simple-icon icon="${this.icon}" no-colorize></simple-icon>
          </div>
        </div>
        <div class="message_wrap">
          <h3 class="main_message ${this.url?"mt-2":"mt-5"}" id="title">
            ${this.title}
          </h3>
          <div class="secondary_message">
            <slot></slot>
            <slot name="message"></slot>
          </div>
          ${this.url?t`
                <div class="link">
                  <a href="${this.url}" id="link">
                    ${this.t.moreInformation} &gt;
                  </a>
                </div>
              `:""}
        </div>
      </div>
    `}static get tag(){return"stop-note"}constructor(){super(),this.url=null,this.title="",this.status=null,this.accentColor="grey",this.icon="stopnoteicons:stop-icon",this.t={moreInformation:"More Information"},this.registerLocalization({context:this,basePath:import.meta.url,locales:["es"]})}static get properties(){return{...super.properties,title:{type:String,reflect:!0},url:{type:String},icon:{type:String,reflect:!0},status:{type:String,reflect:!0}}}updated(t){super.updated&&super.updated(t),t.forEach(((t,e)=>{"url"==e&&(this.remoteLinkURL=this[e]),"status"==e&&this[e]&&StopNoteIconList[this[e]]&&(this.icon=StopNoteIconList[this[e]])}))}firstUpdated(t){super.firstUpdated&&super.firstUpdated(t),this.remoteLinkTarget=this.shadowRoot.querySelector("#link"),null===this.status&&this.icon&&Object.keys(StopNoteIconList).map((t=>{StopNoteIconList[t]===this.icon&&(this.status=t)}))}haxHooks(){return{editModeChanged:"haxeditModeChanged",activeElementChanged:"haxactiveElementChanged"}}haxeditModeChanged(t){super.haxeditModeChanged&&super.haxeditModeChanged(t),this._haxstate=t}haxactiveElementChanged(t,e){super.haxactiveElementChanged&&super.haxactiveElementChanged(t,e);let o=this.shadowRoot.querySelector("#title");return e&&null===this.getAttribute("data-hax-lock")?o.setAttribute("contenteditable",!0):(o.removeAttribute("contenteditable"),this.title=o.innerText),!1}static get haxProperties(){return new URL(`./lib/${this.tag}.haxProperties.json`,import.meta.url).href}}customElements.define(StopNote.tag,StopNote);export{StopNote};