/**
 * Copyright 2021 The Pennsylvania State University
 * @license Apache-2.0, see License.md for full text.
 */
import{html as t,css as e}from"../../lit/index.js";import"../simple-icon/lib/simple-icon-button.js";import"../simple-icon/simple-icon.js";import{SimpleColors as r}from"../simple-colors/simple-colors.js";class StarRating extends r{static get tag(){return"star-rating"}static get styles(){return[super.styles,e`
        :host {
          display: block;
          font-size: 12px;
          font-weight: normal;
          --star-rating-padding-left: 12px;
          --star-rating-margin: 0;
          --star-rating-size: 24px;
        }
        .wrapper {
          display: inline-flex;
        }
        .stars {
          background-color: var(
            --star-rating-background-color,
            var(--simple-colors-default-theme-grey-9)
          );
        }
        simple-icon,
        simple-icon-button {
          --simple-icon-color: var(
            --star-rating-color,
            var(--simple-colors-default-theme-accent-7)
          );
          --simple-icon-height: var(--star-rating-size, 24px);
          --simple-icon-width: var(--star-rating-size, 24px);
        }
        .rating {
          padding-left: var(--star-rating-padding-left);
          margin: var(--star-rating-margin);
          line-height: var(--star-rating-size, 24px);
          vertical-align: center;
        }
        :host(:not([interactive])) simple-icon-button::part(button) {
          cursor: unset;
        }
      `]}static get properties(){return{...super.properties,score:{type:Number},possible:{type:Number},interactive:{type:Boolean,reflect:!0},numStars:{type:Number,attribute:"num-stars"},_calPercent:{type:Number}}}constructor(){super(),this._calPercent=0,this.numStars=5,this.score=10,this.possible=100,this.dark=!0,this.contrast=0,this.accentColor="yellow"}render(){return t`
      <div class="wrapper">
        <div class="stars">
          ${this.renderStar(this.numStars,this.interactive)}
        </div>
        <div class="rating">
          ${this._calPercent} (${this.score}/${this.possible})
        </div>
      </div>
    `}renderStar(e,r){if(0===e)return t``;let s=0;const i=[];for(;s<e;){let a="star";s+1<=e*this._calPercent||(a=e*this._calPercent-(s+1)<-.01&&e*this._calPercent-(s+1)>=-.5?"star-half":"star-border"),r?i.push(t`<simple-icon-button
            @click="${this.interactiveEvent}"
            icon="${a}"
            accent-color="${this.accentColor}"
            ?dark="${this.dark}"
            contrast="${this.contrast}"
            class="star"
            data-value="${Number(s+1)}"
          ></simple-icon-button>`):i.push(t`<simple-icon
            icon="${a}"
            accent-color="${this.accentColor}"
            ?dark="${this.dark}"
            contrast="${this.contrast}"
            class="star"
          ></simple-icon>`),s++}return i}interactiveEvent(t){this.dispatchEvent(new CustomEvent("star-rating-click",{bubbles:!0,cancelable:!0,detail:{value:t.target.getAttribute("data-value")}}))}updated(t){super.updated&&super.updated(t),t.forEach(((t,e)=>{0===this.possible&&(this.possible=1),["score","possible"].includes(e)&&0!==this.possible&&(this._calPercent=Math.round(this.score/this.possible*100)/100)}))}}customElements.define(StarRating.tag,StarRating);export{StarRating};