/**
 * Copyright 2023 The Pennsylvania State University
 * @license Apache-2.0, see License.md for full text.
 */
import{LitElement as e,html as t,css as i}from"../../lit/index.js";class SpotifyEmbed extends e{constructor(){super(),this.source=null,this.theme=null,this.size="normal",this.playlistid=null,this.type=null,this.editing=!1}static get properties(){return{source:{type:String},theme:{type:String},size:{type:String},playlistid:{type:String,attribute:!1},type:{type:String,attribute:!1},editing:{type:Boolean,reflect:!0}}}static get styles(){return[i`
        :host {
          display: block;
        }
        :host([editing]) .container {
          z-index: 1;
        }
        :host([editing]) iframe {
          z-index: -1;
          pointer-events: none;
        }
      `]}render(){return t`
      <div class="container">
        <iframe
          src="https://open.spotify.com/embed/${this.type}/${this.playlistid}?utm_source=generator${this.theme?`&theme=${this.theme}`:""}"
          title="Spotify Song Embed"
          height="${"normal"==this.size?"352":"152"}"
          style="border-radius:12px"
          width="100%"
          part="iframe"
          frameborder="0"
          allow="autoplay; clipboard-write; encrypted-media; fullscreen; picture-in-picture"
          loading="lazy"
          decoding="async"
          fetchpriority="low"
        ></iframe>
      </div>
    `}static get tag(){return"spotify-embed"}updated(e){super.updated&&super.updated(e),e.forEach(((e,t)=>{if("source"===t&&this[t]){let e=this[t].split("/").pop().split("?")[0];this.playlistid=e,this[t].includes("/album/")?this.type="album":this[t].includes("/track/")&&(this.type="track")}}))}haxHooks(){return{preProcessNodeToContent:"haxpreProcessNodeToContent",editModeChanged:"haxeditModeChanged",activeElementChanged:"haxactiveElementChanged"}}async haxpreProcessNodeToContent(e){return e.editing=!1,e}haxactiveElementChanged(e,t){return this.editing=!0,e.editing=!0,e}haxeditModeChanged(e){this.editing=e}static get haxProperties(){return new URL(`./lib/${this.tag}.haxProperties.json`,import.meta.url).href}}customElements.define(SpotifyEmbed.tag,SpotifyEmbed);export{SpotifyEmbed};