import{html as t,css as e,nothing as s}from"../../lit/index.js";import{QuestionElement as r}from"../multiple-choice/lib/QuestionElement.js";import"../simple-icon/lib/simple-icons.js";import"../simple-toolbar/lib/simple-toolbar-button.js";import"../simple-toast/simple-toast.js";import"../grid-plate/grid-plate.js";import"./lib/sorting-option.js";export class SortingQuestion extends r{static get tag(){return"sorting-question"}getOptions(t=""){if(this.shadowRoot)return t?this.shadowRoot.querySelectorAll(`sorting-option[${t}]`):this.shadowRoot.querySelectorAll("sorting-option")}constructor(){super(),this.randomize=!0,this.numberCorrect=0,this.quizName="default",this.question="Put the following in order",this.t={numCorrectLeft:"You have",numCorrectRight:"correct",checkAnswer:"Check answer",tryAgain:"Try again"},this.registerLocalization({context:this,localesPath:new URL("../locales/sorting-question.es.json",import.meta.url).href+"/../",locales:["he","ja","es"]})}checkAnswerCallback(){this.showAnswer=!0}resetAnswer(){if(this.getOptions("incorrect")){const t=this.getOptions("incorrect")[0];t&&setTimeout((()=>{t.shadowRoot.querySelector("#downArrow").shadowRoot.querySelector("button").focus()}),0)}if(this.showAnswer=!1,globalThis.dispatchEvent(new CustomEvent("simple-toast-hide",{bubbles:!0,composed:!0,cancelable:!1,detail:!1})),this.getOptions().forEach((t=>{t.disabled=!1,t.incorrect=null,t.correct=null})),this.numberCorrect===this.answers.length){this.displayedAnswers=[],this.answers.forEach((t=>{t.userGuess=""}));const t=JSON.parse(JSON.stringify(this.answers));setTimeout((()=>{this.answers=[...t]}),0)}this.numberCorrect=0}static get properties(){return{...super.properties,numberCorrect:{type:Number}}}updated(t){super.updated&&super.updated(t),t.forEach(((t,e)=>{if("showAnswer"===e)if(this.showAnswer){var s=0;let t=this.getOptions();for(var r=0;r<this.answers.length;r++)t[r].innerText===this.answers[r].label&&r===this.answers[r].order?(s+=1,t[r].correct=!0,t[r].incorrect=null):(t[r].correct=null,t[r].incorrect=!0),t[r].disabled=!0;this.numberCorrect=s;let e=globalThis.document.createElement("simple-icon-lite"),o={},i="simple-toast-show";globalThis.HAXCMSToast&&(i="haxcms-toast-show",e.style.setProperty("--simple-icon-height","40px"),e.style.setProperty("--simple-icon-width","40px"),e.style.height="150px",e.style.marginLeft="8px"),this.shadowRoot.querySelector("#feedback").focus();let n=this.numberCorrect===this.answers.length;n?(this.__toastColor="green",this.__toastIcon="icons:thumb-up",this.__toastText=this.correctText,this.makeItRain(),this.playSound("success"),o.hat="party"):(this.__toastColor="red",this.__toastIcon="icons:thumb-down",this.__toastText=`${this.t.numCorrectLeft} ${this.numberCorrect} of ${this.answers.length} ${this.t.numCorrectRight}`,this.playSound("error"),o.fire=!0),e.icon=this.__toastIcon,e.style.marginLeft="16px",e.accentColor=this.__toastColor,e.dark=!0,globalThis.dispatchEvent(new CustomEvent(i,{bubbles:!0,composed:!0,cancelable:!0,detail:{text:this.__toastText,accentColor:this.__toastColor,duration:3e3,slot:e,...o}}));let a={activityDisplay:"answered",objectName:this.quizName,resultSuccess:n};this.dispatchEvent(new CustomEvent("user-engagement",{bubbles:!0,composed:!0,cancelable:!1,detail:a}))}else this.getOptions().forEach((t=>{t.disabled=!1}));"disabled"===e&&this.shadowRoot&&(this.disabled?this.getOptions().forEach((t=>{t.disabled=!0,t.correct=null,t.incorrect=null})):this.getOptions().forEach((t=>{t.disabled=!1})))}))}static get styles(){return[super.styles,e`
        :host {
          display: block;
          min-width: 160px;
          padding: var(--ddd-spacing-8);
          border: var(--ddd-border-md);
          border-radius: var(--ddd-radius-xs);
          transition: all 0.3s ease-in-out;
        }
        :host(:focus),
        :host(:focus-within),
        :host(:hover) {
          border-color: var(--simple-colors-default-theme-accent-12);
        }

        simple-toolbar-button {
          font-size: var(--ddd-font-size-xs);
          font-family: var(--ddd-font-navigation);
          transition: all 0.3s ease-in-out;
          border: none;
          border-radius: var(--ddd-radius-xs);
        }
        simple-toolbar-button {
          background-color: var(
            --ddd-theme-primary,
            var(--ddd-theme-default-link)
          );
          color: var(
            --lowContrast-override,
            var(--ddd-theme-bgContrast, white)
          );
        }
        simple-toolbar-button[disabled] {
          background-color: light-dark(
            var(--ddd-theme-default-limestoneLight),
            var(--ddd-theme-default-slateGray)
          );
          color: light-dark(black, white);
          opacity: 0.7;
        }
        :host simple-toolbar-button:hover::part(button),
        :host simple-toolbar-button:focus::part(button),
        :host simple-toolbar-button:focus-within::part(button),
        :host simple-toolbar-button:active::part(button) {
          cursor: pointer;
          box-shadow: var(--ddd-boxShadow-sm);
          border-color: black;
        }
        simple-toolbar-button::part(button) {
          border: var(--ddd-border-sm);
          border-radius: var(--ddd-radius-xs);
          padding: var(--ddd-spacing-2);
        }
        simple-toolbar-button::part(label) {
          font-size: var(--ddd-font-size-s);
          font-family: var(--ddd-font-navigation);
          padding: 0;
          margin: 0;
        }
        #check {
          margin-right: var(--ddd-spacing-4);
        }
        .options {
          margin-bottom: var(--ddd-spacing-6);
          border-radius: var(--ddd-radius-xs);
          border: var(--ddd-border-xs);
        }

        #buttons {
          display: flex;
          justify-content: center;
          align-items: center;
        }
        h3 {
          padding: 0;
          margin: 0 0 var(--ddd-spacing-8) 0;
          font-family: var(--ddd-font-navigation);
        }
        sorting-option img {
          border: var(--ddd-border-sm);
          border-radius: var(--ddd-radius-sm);
          box-shadow: var(--ddd-boxShadow-sm);
          margin-right: var(--ddd-spacing-4);
        }
      `]}renderInteraction(){return t`
      <fieldset class="options">
        ${this.displayedAnswers.map((e=>t`<sorting-option ?disabled="${this.disabled}"
              >${e.image?t`<img src="${e.image}" alt="${e.alt}" />`:s}${e.label}</sorting-option
            >`))}
      </fieldset>
    `}inactiveCase(){return!0}renderDirections(){return t`<p>
      Place the items in the correct order either by clicking the up and down
      arrows or drag and drop. When you believe you have them in the correct
      order, test your answer by selecting
      <strong>${this.t.checkAnswer}</strong>. You will get feedback just below
      here indicating correctness of your answer.
    </p>`}renderFeedback(){return t` ${this.edit?this.renderEditModeFeedbackAreas():t`
          ${this.showAnswer&&this.numberCorrect!==this.answers.length?t` <p class="feedback">
                  ${this.t.numCorrectLeft} ${this.numberCorrect} out of
                  ${this.answers.length} ${this.t.numCorrectRight}
                </p>
                ${this.querySelector&&this.querySelector('[slot="feedbackIncorrect"]')?t`<slot name="feedbackIncorrect"></slot>`:""}`:""}
          ${this.showAnswer&&this.numberCorrect===this.answers.length?t` <p class="feedback">${this.correctText}</p>
                ${this.querySelector&&this.querySelector('[slot="feedbackCorrect"]')?t`<slot name="feedbackCorrect"></slot>`:""}`:""}
          ${this.querySelector&&this.querySelector('[slot="hint"]')&&this.showAnswer&&this.numberCorrect!==this.answers.length?t`
                <h4>Need a hint?</h4>
                <div>
                  <slot name="hint"></slot>
                </div>
              `:""}
          ${this.querySelector&&this.querySelector('[slot="evidence"]')&&this.showAnswer&&this.numberCorrect===this.answers.length?t`
                <h4>Evidence</h4>
                <div>
                  <slot name="evidence"></slot>
                </div>
              `:""}
          <simple-toolbar-button
            ?disabled="${this.disabled||!this.showAnswer}"
            @click="${this.resetAnswer}"
            label="${this.t.tryAgain}"
          >
          </simple-toolbar-button>
        `}`}static get haxProperties(){return new URL(`./lib/${this.tag}.haxProperties.json`,import.meta.url).href}haxinlineContextMenu(t){t.ceButtons=[{icon:"icons:add",callback:"haxClickInlineAdd",label:"Add answer"},{icon:"icons:remove",callback:"haxClickInlineRemove",label:"Remove answer"},{icon:"lrn:edit",callback:"haxToggleEdit",label:"Toggle editing feedback blocks"}]}haxClickInlineAdd(t){this.resetAnswer(),this.displayedAnswers=[];let e=this.answers;return e.push({label:"Next"}),this.answers=[...e],!0}haxClickInlineRemove(t){if(this.answers.length>0){this.resetAnswer(),this.displayedAnswers=[];let t=this.answers;return t.pop(),this.answers=[...t],!0}}}globalThis.customElements.define(SortingQuestion.tag,SortingQuestion);