/**
 * Copyright 2019 The Pennsylvania State University
 * @license Apache-2.0, see License.md for full text.
 */
import{html as t,css as e,LitElement as i}from"../../lit/index.js";import"../simple-icon/lib/simple-icon-lite.js";import"../simple-icon/lib/simple-icons.js";import"../hax-iconset/lib/simple-hax-iconset.js";class SocialShareLink extends i{static get styles(){return[e`
        :host {
          display: inline;
        }

        :host([hidden]) {
          display: none;
        }

        a {
          display: inline-flex;
          align-items: center;
          color: var(--social-share-link-color, inherit);
          transition: all 0.5s;
          margin: 5px;
          padding: var(--social-share-button-padding, 0px);
          border-radius: var(--social-share-button-border-radius, 0px);
        }

        a:visited {
          color: var(--social-share-visited-link-color, inherit);
        }

        a:focus,
        a:hover {
          color: var(--social-share-link-hover-color, inherit);
        }

        :host([disabled]) a,
        :host([disabled]) a:focus,
        :host([disabled]) a:hover,
        :host([disabled]) a:visited {
          color: var(--social-share-disabled-link-color, #ddd);
        }

        :host([button-style]) a {
          padding: var(--social-share-button-padding, 5px 10px);
          border-radius: var(--social-share-button-border-radius, 3px);
          color: var(--social-share-button-color, white);
          background-color: var(--social-share-button-bg, #0066ff);
          text-decoration: none;
          transition: all 0.5s;
        }

        :host([button-style]) a:visited {
          color: var(--social-share-visited-button-color, white);
        }

        :host([button-style]) a:focus,
        :host([button-style]) a:hover {
          color: var(--social-share-button-hover-color, white);
          background-color: var(--social-share-button-hover-bg, #0044ee);
        }

        :host([button-style][disabled]) a,
        :host([button-style][disabled]) a:focus,
        :host([button-style][disabled]) a:hover,
        :host([button-style][disabled]) a:visited {
          color: var(--social-share-disabled-button-color, #ddd);
          background-color: var(--social-share-disabled-button-bg, #666);
        }

        simple-icon-lite {
          margin-right: 5px;
        }

        a.text-only simple-icon-lite {
          display: none;
        }

        a.icon-only .linktext {
          position: absolute;
          left: -999999px;
          top: 0;
          height: 0;
          width: 0;
          overflow: hidden;
        }

        a.icon-only simple-icon-lite {
          margin-right: 0;
        }
      `]}render(){return t` <a
      href="${this.__href}"
      ?disabled="${!this.__href}"
      class="${this.mode}"
      rel="noopener noreferrer"
      target="_blank"
    >
      <simple-icon-lite
        ?dark="${this.dark}"
        contrast="4"
        aria-hidden="true"
        icon="${this.__icon}"
        ?hidden="${!this.__showIcon}"
      ></simple-icon-lite>
      <span class="linktext">${this.__linkText}</span>
    </a>`}static get properties(){return{...super.properties,buttonStyle:{type:Boolean,reflect:!0,attribute:"button-style"},image:{type:String},message:{type:String},mode:{type:String},text:{type:String},type:{type:String},url:{type:String},__href:{type:String},__icon:{type:String},__linkText:{type:String},__showIcon:{type:Boolean}}}static get tag(){return"social-share-link"}constructor(){super(),this.buttonStyle=!1,this.image="",this.message="",this.mode=null,this.text=null,this.type="Twitter",this.url=null}updated(t){t.forEach(((t,e)=>{"type"==e&&(this.__icon=this._getIcon(this.type)),["text","type"].includes(e)&&(this.__linkText=this._getLinkText(this.text,this.type)),["image","message","type","url"].includes(e)&&(this.__href=this._getHref(this.image,this.message,this.type,this.url)),"mode"==e&&(this.__showIcon="icon-only"==this.mode)}))}_getHref(t,e,i,o){let s;switch(i){case"Facebook":s=null!==o&&"https://www.facebook.com/sharer/sharer.php?u="+o;break;case"LinkedIn":s=null!==o?"&url="+o:"",s=null!==s&&"https://www.linkedin.com/shareArticle?mini=true"+s;break;case"Pinterest":s=(null!==o?"&url="+o:"")+(null!==e?"&description="+e:"")+(null!==t?"&media="+t:""),s=null!==s&&"http://pinterest.com/pin/create/button/?"+s.substring(1);break;case"Twitter":s=null!==e?"text="+e+" "+o:o,s=null!==s&&"http://twitter.com/intent/tweet?"+s}return encodeURI(s)}_getLinkText(t,e){return null!==t?t:"Share via "+e}_getIcon(t){return"mdi-social:"+t.toLowerCase()}}customElements.define(SocialShareLink.tag,SocialShareLink);export{SocialShareLink};