/**
 * Copyright 2021 The Pennsylvania State University
 * @license Apache-2.0, see License.md for full text.
 */
import{LitElement as t,html as s,css as i}from"../../lit/index.js";import"./lib/simple-toolbar-more-button.js";import"./lib/simple-toolbar-field.js";import"./lib/simple-toolbar-button-group.js";import{SimpleToolbarGlobalProperties as o}from"./lib/simple-toolbar-button.js";const SimpleToolbarBehaviors=function(t){return class extends t{static get tag(){return"simple-toolbar"}static get stickyStyles(){return[i`
          :host([sticky]) {
            position: sticky;
            top: 0;
          }
        `]}static get baseStyles(){return[i`
          :host {
            position: relative;
            display: flex;
            align-items: flex-start;
            opacity: 1;
            z-index: 2;
            margin: 0;
            justify-content: space-between;
            background-color: var(--simple-toolbar-bg);
            font-size: inherit;
            margin: 0;
            padding: 0;
            transition: all 0.5s;
            transition: z-index 0s;
          }
          :host([hidden]) {
            z-index: -1;
            visibility: hidden;
            opacity: 0;
            height: 0;
          }
          :host([disabled]) {
            opacity: 0.6;
            pointer-events: none;
          }
          :host(:focus-within) {
            border: 1px solid
              var(
                --simple-toolbar-hover-border-color,
                var(--simple-toolbar-button-hover-border-color)
              );
          }
          #buttons {
            flex-wrap: wrap;
            display: flex;
            justify-content: flex-start;
            flex: 1 1 auto;
            overflow-y: visible;
          }
          #morebutton {
            flex: 0 0 auto;
          }
          ::slotted(.group) {
            display: flex;
            flex-wrap: wrap;
            justify-content: space-evenly;
            align-items: stretch;
            margin: 0;
            flex: 0 1 auto;
            overflow-y: visible;
            border-width: 0px;
            border-style: solid;
            padding: var(--simple-toolbar-group-padding, 0 3px);
            border-color: var(
              --simple-toolbar-border-color,
              var(--simple-toolbar-group-border-color, transparent)
            );
          }
          ::slotted(.group:not(:last-child)) {
            border-right-width: var(
              --simple-toolbar-group-border-width,
              var(--simple-toolbar-border-width, 1px)
            );
          }
          ::slotted(*:hover),
          ::slotted(*:focus-wthin) {
            z-index: var(--simple-toolbar-focus-z-index, 100);
            transition: z-index 0s;
          }
          :host([collapsed]:not([always-expanded]))
            ::slotted(*[collapse-hide]) {
            display: none !important;
          }
        `]}static get styles(){return[...this.baseStyles,...this.stickyStyles]}static get properties(){return{...o,alwaysExpanded:{name:"alwaysExpanded",type:Boolean,attribute:"always-expanded",reflect:!0},ariaControls:{name:"ariaControls",type:String,attribute:"aria-controls",reflect:!0},ariaLabel:{name:"ariaLabel",type:String,attribute:"aria-label",reflect:!0},collapsed:{name:"collapsed",type:Boolean,attribute:"collapsed",reflect:!0},config:{name:"config",type:Array,attribute:"config"},id:{name:"id",type:String,attribute:"id",reflect:!0},moreShortcuts:{name:"moreShortcuts",attribute:"more-shortcuts",type:Object},shortcutKeys:{name:"shortcutKeys",attribute:"shortcut-keys",type:Object},sticky:{name:"sticky",type:Boolean,attribute:"sticky",reflect:!0},__buttons:{name:"__buttons",type:Array},collapseDisabled:{type:Boolean,attribute:"collapse-disabled",reflect:!0},__focused:{name:"__focused",type:Boolean},__hovered:{name:"__hovered",type:Boolean}}}render(){return this.toolbarTemplate}get buttons(){return this.__buttons}get focused(){return this.__focused}get hovered(){return this.__hovered}get moreButton(){return s` <simple-toolbar-more-button
        id="morebutton"
        align-horizontal="${this.alignHorizontal}"
        align-vertical="${this.alignVertical}"
        aria-controls="buttons"
        class="button"
        @click="${t=>this.collapsed=!this.collapsed}"
        ?disabled=${this.collapseDisabled}
        @toggle="${t=>this.collapsed=!this.collapsed}"
        ?hidden=${this.collapseDisabled}
        icon="${this.icon}"
        icon-position="${this.iconPosition}"
        label="${this.label}"
        shortcut="${this.shortcut}"
        ?show-text-label="${this.showTextLabel}"
        ?toggled="${!this.collapsed}"
        toggled-icon="${this.toggledIcon}"
        toggled-label="${this.toggledLabel}"
        toggled-tooltip="${this.toggledTooltip}"
        tooltip-direction="${this.tooltipDirection}"
        part="morebutton"
      >
      </simple-toolbar-more-button>`}get toolbarTemplate(){return s`
        <div
          id="buttons"
          class="${!this.alwaysExpanded&&this.collapsed?"collapsed":""}"
          part="buttons"
        >
          <slot></slot>
        </div>
        ${this.alwaysExpanded?"":this.moreButton}
      `}constructor(){super(),this.windowControllers=new AbortController,this.collapsed=!0,this.collapseDisabled=!1,this.config=[],this.__buttons=[],this.__focused=!1,this.__hovered=!1,this.alignVertical="center",this.alignHorizontal="center",this.icon="more-vert",this.label="More Buttons",this.toggledLabel="Less Buttons",this.iconPosition="left",this.showTextLabel=!1,this.shortcut="ctrl+shift+;",this.sticky=!1,this.shortcutKeys={},this._handleResize=this._handleResize.bind(this),this.addEventListener("register-button",this._handleButtonRegister),this.addEventListener("deregister-button",this._handleButtonDeregister),this.addEventListener("update-button-registry",this._handleButtonUpdate),this.addEventListener("toggle-toolbar",this._handleToggleToolbar)}connectedCallback(){super.connectedCallback(),this.collapsed&&globalThis.addEventListener("resize",this._handleResize,{signal:this.windowControllers.signal}),this.addEventListener("keypress",this._handleShortcutKeys)}disconnectedCallback(){this.collapsed&&this.windowControllers.abort(),this.removeEventListener("keypress",this._handleShortcutKeys),super.disconnectedCallback()}firstUpdated(t){this.setAttribute("aria-live","polite"),this.setAttribute("role","toolbar"),this.onfocus=t=>this.__focused=!0,this.onblur=t=>this.__focused=!1,this.onmouseover=t=>this.__hovered=!0,this.onmouseout=t=>this.__hovered=!1,this.addEventListener("keydown",this._handleKeydown),super.firstUpdated&&super.firstUpdated(t)}updated(t){super.updated&&super.updated(t),t.forEach(((t,e)=>{"config"===e&&this.updateToolbar(),"collapsed"===e&&(this.collapsed?(this.resizeToolbar(),this.windowControllers=new AbortController,globalThis.addEventListener("resize",this._handleResize,{signal:this.windowControllers.signal})):this.windowControllers.abort()),"hidden"===e&&this.setAttribute("aria-hidden",this.hidden?"true":"false")})),!this.currentItem&&this.buttons&&this.setCurrentItem(this.buttons[0]),this.resizeToolbar()}addButton(t,e){let s=this._renderButton(t);return(e=e||this).appendChild(s),s}addButtonGroup(t={},e){if(!t.buttons||t.buttons.length<1)return;let s=this._renderButtonGroup(t);return(e||this).appendChild(s),this._addConfigItems(t.buttons,s),s}clearToolbar(){this.innerHTML="",this.__buttons=[],this.shortcutKeys={},this.shortcutKeys[this.shortcut]=this.shadowRoot?this.shadowRoot.querySelector("#morebutton"):void 0}deregisterButton(t){this.__buttons=this.__buttons.filter((e=>e!==t)),(t.shortcutKeys||"").split(" ").forEach((t=>delete this.shortcutKeys[t])),t.removeEventListener("blur",(e=>this._handleFocusChange(t))),t.removeEventListener("focus",(e=>this._handleFocusChange(t)))}registerButton(t){this.__buttons.push(t),this.__buttons=[...new Set(this.__buttons)],(t.shortcutKeys||"").split(" ").forEach((e=>this.shortcutKeys[e]=t)),"menuitem"!==t.role&&(t.isCurrentItem=!1),t.addEventListener("blur",(e=>this._handleFocusChange(t))),t.addEventListener("focus",(e=>this._handleFocusChange(t))),this.currentItem||this.setCurrentItem(t)}resizeToolbar(){if(this.alwaysExpanded)return;if(!this.collapsed)return;let t=[...this.children||[]],e=!0;t.forEach((t=>{t.removeAttribute&&t.removeAttribute("collapse-hide"),t.offsetTop&&t.offsetTop>0?(t.setAttribute("collapse-hide",!0),e=!1):e||t.setAttribute("collapse-hide",!0)})),this.collapseDisabled=!!e,this.currentItem||this.setCurrentItem(this.firstItem)}get firstItem(){return this.mainItems?this.mainItems[0]:void 0}get nextItem(){return this.getItem()}get previousItem(){return this.getItem(-1)}get lastItem(){return this.buttons?this.mainItems[this.mainItems.length-1]:void 0}get mainItems(){return this.buttons.filter((t=>"menuitem"!==t.role))}getItemIndex(t=this.currentItem){let e=-1;return this.mainItems.forEach(((s,i)=>{s===t&&(e=i)})),e}getItem(t=1){let e=this.getItemIndex(this.currentItem)+t;return!this.mainItems||e<0||this.mainItems.length<=e?void 0:this.mainItems[e]}setCurrentItem(t){this.currentItem&&(this.currentItem.isCurrentItem=!1),t&&t.closest("[collapse-hide=true]")&&(this.collapsed=!1),this.currentItem=t,this.currentItem&&(this.currentItem.isCurrentItem=!0)}focusOn(t){let e=t&&t.closest("[collapse-hide=true]");this.currentItem.close&&this.currentItem.close(!0),this.setCurrentItem(t),e?setTimeout((()=>this.currentItem.focus()),300):this.currentItem.focus()}updateButton(t){t&&this.deregisterButton(t),t&&this.registerButton(t)}updateToolbar(t=this.config){this&&this.config&&0!=this.config.length&&(this.clearToolbar(),"object"!=typeof this.config&&(this.config=JSON.parse(t)),this._addConfigItems(this.config),this.resizeToolbar())}_addConfigItems(t=this.config,e=this){(t||[]).forEach((t=>{"button-group"===t.type||"simple-toolbar-button-group"===t.type?this.addButtonGroup(t,e):this.addButton(t,e)}))}get keyCode(){return{TAB:9,ENTER:13,ESC:27,SPACE:32,PAGEUP:33,PAGEDOWN:34,END:35,HOME:36,LEFT:37,UP:38,RIGHT:39,DOWN:40}}_handleKeydown(t){let e,s=!1;if(!this._shortcutKeysMatch(t)){switch(t.keyCode){case this.keyCode.RIGHT:for(e=this.nextItem||this.firstItem;e&&e.disabled;)this.currentItem=e,e=this.nextItem||this.firstItem;this.focusOn(this.nextItem||this.firstItem),s=!0;break;case this.keyCode.LEFT:for(e=this.previousItem||this.lastItem;e&&e.disabled;)this.currentItem=e,e=this.previousItem||this.lastItem;this.focusOn(this.previousItem||this.lastItem),s=!0;break;case this.keyCode.HOME:for(e=this.firstItem;e&&e.disabled;)this.currentItem=e,e=this.firstItem;this.focusOn(this.firstItem),s=!0;break;case this.keyCode.END:for(e=this.lastItem;e&&e.disabled;)this.currentItem=e,e=this.lastItem;this.focusOn(this.lastItem),s=!0;break;case this.keyCode.UP:for(e=this.previousItem||this.lastItem;e&&e.disabled;)this.currentItem=e,e=this.previousItem||this.lastItem;this.focusOn(this.previousItem||this.lastItem),s=!0;break;case this.keyCode.DOWN:for(e=this.nextItem||this.firstItem;e&&e.disabled;)this.currentItem=e,e=this.nextItem||this.firstItem;this.focusOn(this.nextItem||this.firstItem),s=!0}s&&(t.stopPropagation(),t.preventDefault())}}_handleFocusChange(){this.__focused=this.contains(document.activeElement)}_handleButtonRegister(t){t.stopPropagation(),this.registerButton(t.detail),this.resizeToolbar()}_handleButtonDeregister(t){t.stopPropagation(),this.deregisterButton(t.detail),this.resizeToolbar()}_handleButtonUpdate(t){t.stopPropagation(),this.updateButton(t.detail)}_handleResize(t){this.resizeToolbar()}_handleShortcutKeys(t){let e=this._shortcutKeysMatch(t);e&&(t.preventDefault(),this.shortcutKeys[e]._handleShortcutKeys(t,e),this.dispatchEvent(new CustomEvent("shortcut-key-pressed",{bubbles:!0,cancelable:!0,composed:!0,detail:{...t.detail,button:this,shortcutKey:this}})))}_handleToggleToolbar(t){this.collapsed=t.detail&&void 0!==t.detail?t.detail:!this.collapsed}_renderButton(t){let e=globalThis.document.createElement(t.type);return Object.keys(t).forEach((s=>e[s]=t[s])),e.addEventListener("button-command",this._handleButton),e}_renderButtonGroup(t){let e=t.type&&"simpletoolbar-button-group"===t.type?t.type:"div",s=globalThis.document.createElement(e);return s.setAttribute("class","group"),Object.keys(t).forEach((e=>s[e]=t[e])),s}_shortcutKeysMatch(t){let s=!1;return Object.keys(this.shortcutKeys||{}).forEach((i=>{let o=(i||"").toLowerCase().split("+"),r=o.includes("alt"),n=o.includes("ctrl"),l=o.includes("meta")||o.includes("cmd"),a=o.includes("shift"),h=t.shiftKey&&t.code>65&&t.code<91,d=o.filter((t=>1==t.length)).map((t=>h?t.toUpperCase():t)),u=d[0];r===t.altKey&&(n===t.ctrlKey||n===globalThis.navigator.platform==="MacIntel"&&e.metaKey)&&l===t.metaKey&&a===t.shiftKey&&(t.key?t.key===u:!u)&&(s=i)})),s}}};class SimpleToolbar extends(SimpleToolbarBehaviors(t)){}customElements.define("simple-toolbar",SimpleToolbar);export{SimpleToolbar,SimpleToolbarBehaviors};