import{LitElement as t,html as e,css as o}from"../../../lit/index.js";import{A11yMenuButtonBehaviors as i}from"../../a11y-menu-button/a11y-menu-button.js";import{SimpleToolbarButtonBehaviors as s}from"./simple-toolbar-button.js";import{normalizeEventPath as r}from"../../utils/utils.js";import"./simple-toolbar-menu-item.js";const SimpleToolbarMenuBehaviors=function(t){return class extends(i(s(t))){static get simpleButtonCoreStyles(){return[...super.simpleButtonCoreStyles,o`
          :host {
            --icon-offset-left: 12px;
          }
          #menubutton {
            display: flex;
            flex-wrap: none;
            align-items: center;
            min-width: calc(42px - var(--icon-offset-left));
            padding-right: var(--icon-offset-left);
          }
          #dropdownicon {
            --simple-icon-height: 18px;
            --simple-icon-width: 18px;
            position: absolute;
            left: 2px;
          }
        `]}constructor(){super(),this.tooltipDirection="top"}static get simpleButtonLayoutStyles(){return[...super.simpleButtonLayoutStyles,o`
          #menu {
            width: var(--simple-toolbar-button-width);
            min-width: var(--simple-toolbar-button-min-width);
          }
        `]}static get simpleButtonThemeStyles(){return[...super.simpleButtonThemeStyles,o`
          :host([expanded]) absolute-position-behavior {
            border-style: solid;
            border-width: var(
              --simple-toolbar-button-border-width,
              var(--simple-toolbar-border-width, 1px)
            );
            border-color: var(
              --simple-toolbar-button-border-color,
              var(--simple-toolbar-border-color, inherit)
            );
            background-color: var(--simple-toolbar-button-bg, white);
            box-shadow: var(--simple-toolbar-menu-list-box-shadow, unset);
          }
        `]}static get styles(){return[...super.menuButtonCoreStyles,...this.simpleButtonCoreStyles,...this.iconStyles,...this.labelStyles,...this.tooltipStyles,...this.simpleButtonLayoutStyles,...this.simpleButtonThemeStyles]}get buttonTemplate(){return e`
        <button
          id="menubutton"
          aria-haspopup="true"
          aria-controls="menu"
          ?disabled="${this.disabled}"
          aria-expanded="${this.expanded?"true":"false"}"
          @blur="${this._handleBlur}"
          part="button"
          tabindex="${this.isCurrentItem?1:-1}"
        >
          ${this.buttonInnerTemplate}
          <simple-icon-lite
            id="dropdownicon"
            icon="arrow-drop-down"
            aria-hidden="true"
            part="dropdown-icon"
          ></simple-icon-lite>
        </button>
        ${this.tooltipTemplate}
      `}get buttonInnerTemplate(){return super.buttonInnerTemplate}get tooltipTemplate(){return this.tooltipVisible?e`<simple-tooltip
            id="tooltip"
            for="menubutton"
            position="${this.tooltipDirection||"top"}"
            part="tooltip"
            fit-to-visible-bounds
            >${this.currentTooltip||this.currentLabel}</simple-tooltip
          >`:""}static get tag(){return"simple-toolbar-menu"}static get properties(){return{...super.properties}}get focusableElement(){return this.shadowRoot&&this.shadowRoot.querySelector("#menubutton")?this.shadowRoot.querySelector("#menubutton"):void 0}_excludeEvent(t){let e=(r(t)||[])[0];return!(!e.closest("simple-toolbar-field")||"BUTTON"!==e.tagName)}_handleFocus(t){s._handleFocus&&s._handleFocus(t),i._handleFocus&&i._handleFocus(t)}_handleBlur(t){s._handleBlur&&s._handleBlur(t),i._handleBlur&&i._handleBlur(t),this.isCurrentItem||setTimeout(this.close(),300)}addItem(t){if(this.getItemIndex(t)<0){let e=this.itemListeners;this.__menuItems=this.__menuItems||[],this.__menuItems.push(t),Object.keys(e).forEach((o=>(t.focusableElement||t).addEventListener(o,e[o].bind(this))))}}removeItem(t){if(this.getItemIndex(t)<0){let e=this.itemListeners;Object.keys(e).forEach((o=>(t.focusableElement||t).removeEventListener(o,e[o].bind(this)))),this.__menuItems&&(this.__menuItems=[...this.menuItems.filter((e=>t!==e))])}}}};class SimpleToolbarMenu extends(SimpleToolbarMenuBehaviors(t)){}customElements.define(SimpleToolbarMenu.tag,SimpleToolbarMenu);export{SimpleToolbarMenu,SimpleToolbarMenuBehaviors};