/**
 * Copyright 2019 Penn State University
 * @license Apache-2.0, see License.md for full text.
 */
import{LitElement as t,html as e,css as o}from"../../../lit/index.js";import{SimpleToolbarButtonBehaviors as i}from"./simple-toolbar-button.js";class SimpleToolbarField extends(i(t)){static get tag(){return"simple-toolbar-field"}static get styles(){return[super.styles,o`
        :host([full-display]) {
          min-width: 100px;
          display: block;
          padding-right: 3px;
          overflow: visible;
        }
        *[part="button"] {
          height: auto;
          width: auto;
          align-self: stretch;
          flex: 1 1 auto;
        }
        *[part="button"]:hover {
          opacity: 1;
        }
        *[part="button"]:hover > *:not([part="field"]) {
          opacity: var(--simple-toolbar-button-hover-opacity, 0.8);
        }
        :host([full-display]) *[part="button"] {
          border-width: 0;
        }
        :host(:focus-within) *[part="button"] {
          color: var(--simple-toolbar-button-hover-color);
          background-color: var(--simple-toolbar-button-hover-bg);
          border-color: var(--simple-toolbar-button-hover-border-color);
          opacity: var(--simple-toolbar-button-hover-opacity, 0.8);
        }
        *[part="field"] {
          width: 0;
          height: 0;
          flex: 0 0 0px;
          display: flex;
          align-items: center;
          overflow: visible;
        }
        :host([icon-position="top"]) *[part="field"],
        :host([icon-position="bottom"]) *[part="field"] {
          flex-direction: column;
        }
        :host([align-horizontal="left"]) *[part="field"] {
          align-items: flex-start;
        }
        :host([align-horizontal="right"]) *[part="field"] {
          align-items: flex-end;
        }
        ::slotted(*) {
          width: 10px;
          flex: 1 1 auto;
        }
        :host(:not([full-display])) ::slotted(*) {
          flex: 0 0 auto;
          width: 0px;
          opacity: 0;
          padding: 0;
          transition:
            width ease-in-out 0.5s,
            opacity 0.5s ease-in-out 0s;
        }
        :host([is-current-item]:not([full-display])) ::slotted(:focus) {
          width: 100px;
          opacity: 1;
          padding: unset;
          transition: width ease-in-out 0.5s;
        }
      `]}constructor(){super(),this.fullDisplay=!1,this.addEventListener("click",this.toggleFocus),this.observer.observe(this,{childList:!0,subtree:!0})}static get properties(){return{...super.properties,fullDisplay:{type:Boolean,attribute:"full-display",reflect:!0}}}get buttonTemplate(){return this.fullDisplay?e` <div
            id="button"
            class="simple-toolbar-button"
            ?disabled="${this.disabled}"
            part="button"
          >
            ${this.buttonInnerTemplate}
            <slot></slot>
          </div>
          ${this.tooltipFullDisplayTemplate}`:e` <div
            id="button"
            class="simple-toolbar-button"
            ?disabled="${this.disabled}"
            part="button"
          >
            ${this.buttonInnerTemplate}
            <span part="field">
              <slot></slot>
            </span>
          </div>
          ${this.tooltipTemplate}`}get tooltipFullDisplayTemplate(){return this.tooltipVisible?e`<simple-tooltip
          id="tooltip"
          for="${this.hasIcon?"icon":"label"}"
          offset="5"
          position="right"
          part="tooltip"
          fit-to-visible-bounds
          >${this.currentTooltip||this.currentLabel}</simple-tooltip
        >`:""}get focusableElement(){return this.querySelector("*:not([disabled]):not([hidden])")}toggleFocus(t){this.focusableElement.clientWidth>10?this.focusableElement.blur():this.focus()}updated(t){super.updated&&super.updated(t),t.forEach(((t,e)=>{"isCurrentItem"===e&&this.focusableElement&&this.focusableElement.setAttribute("tabindex",this.isCurrentItem?0:-1)}))}get observer(){return new MutationObserver((t=>this._watchChildren(t)))}_watchChildren(t){this.focusableElement&&this.focusableElement.setAttribute("tabindex",this.isCurrentItem?0:-1)}}customElements.define(SimpleToolbarField.tag,SimpleToolbarField);export{SimpleToolbarField};