/**
 * Copyright 2019 Penn State University
 * @license Apache-2.0, see License.md for full text.
 */
import{LitElement as t,html as o,css as e}from"../../../lit/index.js";import"../../simple-icon/lib/simple-icon-lite.js";import"../../simple-icon/lib/simple-icons.js";import"../../simple-tooltip/simple-tooltip.js";import{DDDPulseEffectSuper as i}from"../../d-d-d/d-d-d.js";export const SimpleToolbarGlobalProperties={alignHorizontal:{attribute:"align-horizontal",reflect:!0,type:String},alignVertical:{attribute:"align-vertical",reflect:!0,type:String},disabled:{name:"disabled",type:Boolean,attribute:"disabled",reflect:!0},hidden:{name:"hidden",type:Boolean,attribute:"hidden",reflect:!0},icon:{type:String,attribute:"icon",reflect:!0},iconPosition:{type:String,attribute:"icon-position",reflect:!0},label:{type:String},showTextLabel:{name:"showTextLabel",type:Boolean,attribute:"show-text-label"},showTooltip:{attribute:"show-tooltip",type:Boolean,reflect:!0},toggledIcon:{attribute:"toggled-icon",type:String},toggledLabel:{attribute:"toggled-label",type:String},toggledTooltip:{attribute:"toggled-tooltip",type:String},tooltipDirection:{type:String,attribute:"tooltip-direction",reflect:!0}};const SimpleToolbarButtonBehaviors=function(t){return class extends t{static get tag(){return"simple-toolbar-button"}static get properties(){return{...super.properties,...SimpleToolbarGlobalProperties,controls:{type:String,attribute:"controls",reflect:!0},describedby:{type:String,attribute:"describedby"},isCurrentItem:{type:Boolean,attribute:"is-current-item",reflect:!0},radio:{attribute:"radio",type:Boolean,reflect:!0},shortcutKeys:{attribute:"shortcut-keys",type:String},target:{type:Object},toggles:{type:Boolean},toggled:{attribute:"toggled",type:Boolean}}}constructor(){super(),this.iconPosition="left",this.alignVertical="center",this.alignHorizontal="center",this.disabled=!1,this.showTextLabel=!1,this.toggled=!1,this.toggles=!1,this.radio=!1,this.shortcutKeys="",this.isCurrentItem=!0}get button(){return this.__button||(this.__button=this.shadowRoot&&this.shadowRoot.querySelector("button[part=button]")?this.shadowRoot.querySelector("button[part=button]"):void 0),this.__button}get currentLabel(){return this._defaultOrToggled(this.label,this.toggledLabel,this.isToggled)}get currentIcon(){return this._defaultOrToggled(this.icon,this.toggledIcon,this.isToggled)}get currentTooltip(){return this._defaultOrToggled(this.tooltip,this.toggledTootip,this.isToggled)||this.currentLabel}get isToggled(){return(!!this.toggles||!!this.radio)&!!this.toggled}connectedCallback(){super.connectedCallback(),this.dispatchEvent(new CustomEvent("register-button",{bubbles:!0,cancelable:!0,composed:!0,detail:this}))}disconnectedCallback(){this.dispatchEvent(new CustomEvent("deregister-button",{bubbles:!0,cancelable:!0,composed:!0,detail:this})),super.disconnectedCallback()}focus(){this.focusableElement&&!this.disabled&&(this.isCurrentItem=!0,this.focusableElement.focus())}_defaultOrToggled(t,o){return this._uniqueText(o)&&this.isToggled?o:t}_handleClick(t){this.disabled||this.toggle()}_handleBlur(t){}_handleFocus(t){}_handleKeydown(t){}_handleKeys(t){}_handleShortcutKeys(t,o){}toggle(){(this.toggles||this.radio)&&(this.toggled=!this.toggled),this.dispatchEvent(new CustomEvent("button-toggled",{bubbles:!0,cancelable:!0,composed:!0,detail:this}))}click(t){this._handleClick(t)}updateButtonRegistry(){this.dispatchEvent(new CustomEvent("update-button-registry",{bubbles:!0,cancelable:!0,composed:!0,detail:this}))}get focusableElement(){return this.shadowRoot&&this.shadowRoot.querySelector("#button")?this.shadowRoot.querySelector("#button"):void 0}get hasLabel(){return this._uniqueText(this.currentLabel)}get hasIcon(){return this._uniqueText(this.currentIcon)}get hasTooltip(){return this._uniqueText(this.currentTooltip)}get labelVisible(){return(!this.hasIcon||this.showTextLabel)&&this.hasLabel}get tooltipVisible(){return(this.hasTooltip||this.hasLabel)&&(this.showTooltip||!this.labelVisible||this._uniqueText(this.currentLabel,this.currentTooltip))}_uniqueText(t="",o=""){return String(t||"").trim()!==String(o||"").trim()}get iconTemplate(){return this.hasIcon?o`<simple-icon-lite
            id="icon"
            aria-hidden="true"
            icon="${this.currentIcon}"
            part="icon"
          ></simple-icon-lite>`:""}get labelTemplate(){return this.hasLabel?o`<span
            id="label"
            class="${this.labelVisible?"":"offscreen"}"
            part="label"
            >${this.currentLabel}</span
          >`:""}get tooltipTemplate(){return this.tooltipVisible?o`<simple-tooltip
            id="tooltip"
            for="button"
            position="${this.tooltipDirection||"bottom"}"
            part="tooltip"
            fit-to-visible-bounds
            >${this.currentTooltip||this.currentLabel}</simple-tooltip
          >`:""}get buttonInnerTemplate(){return"right"===this.iconPosition||"bottom"===this.iconPosition?o`${this.labelTemplate} ${this.iconTemplate}`:o`${this.iconTemplate} ${this.labelTemplate}`}get buttonTemplate(){return this.radio?o` <button
              id="button"
              aria-checked="${this.isToggled?"true":"false"}"
              aria-describedby="${this.describedby&&""!==this.describedby?this.describedby:void 0}"
              class="simple-toolbar-button"
              ?disabled="${this.disabled}"
              ?controls="${this.controls}"
              @click="${this._handleClick}"
              @keypress="${this._handleKeys}"
              @keydown="${this._handleKeydown}"
              @blur="${this._handleBlur}"
              @focus="${this._handleFocus}"
              part="button"
              role="radio"
              tabindex="${this.isCurrentItem?0:-1}"
            >
              ${this.buttonInnerTemplate}
            </button>
            ${this.tooltipTemplate}`:this.toggles?o` <button
                id="button"
                aria-pressed="${this.isToggled?"true":"false"}"
                aria-describedby="${this.describedby&&""!==this.describedby?this.describedby:void 0}"
                class="simple-toolbar-button"
                ?disabled="${this.disabled}"
                ?controls="${this.controls}"
                @click="${this._handleClick}"
                @keypress="${this._handleKeys}"
                @blur="${this._handleBlur}"
                @focus="${this._handleFocus}"
                part="button"
                tabindex="${this.isCurrentItem?0:-1}"
              >
                ${this.buttonInnerTemplate}
              </button>
              ${this.tooltipTemplate}`:o` <button
                id="button"
                aria-describedby="${this.describedby&&""!==this.describedby?this.describedby:void 0}"
                class="simple-toolbar-button"
                ?disabled="${this.disabled}"
                ?controls="${this.controls}"
                @click="${this._handleClick}"
                @keypress="${this._handleKeys}"
                @blur="${this._handleBlur}"
                @focus="${this._handleFocus}"
                part="button"
                tabindex="${this.isCurrentItem?0:-1}"
              >
                ${this.buttonInnerTemplate}
              </button>
              ${this.tooltipTemplate}`}render(){return o`${this.buttonTemplate}`}static get labelStyles(){return[e`
          #label {
            padding: 0 var(--simple-toolbar-button-label-padding, 2px);
            white-space: var(--simple-toolbar-button-label-white-space, normal);
          }
          .offscreen {
            position: absolute;
            left: -999999px;
            top: 0;
            height: 0;
            width: 0;
            overflow: hidden;
          }
        `]}static get iconStyles(){return[e`
          #icon:not([icon]) {
            display: none;
          }
          #icon[icon] {
            width: var(
              --simple-toolbar-button-width,
              var(--simple-toolbar-button-height, 24px)
            );
            height: var(--simple-toolbar-button-height, 24px);
            flex: 0 0 auto;
          }
        `]}static get tooltipStyles(){return[e`
          simple-tooltip {
            z-index: -1;
          }
          :host(:hover),
          :host(:focus-within) {
            z-index: var(--simple-toolbar-button-z-index, 2);
          }
          :host(:hover) simple-tooltip,
          :host(:focus-within) simple-tooltip {
            z-index: var(--simple-toolbar-button-z-index, 2);
          }
        `]}static get simpleButtonCoreStyles(){return[e`
          :host {
            display: inline-flex;
            white-space: nowrap;
            z-index: 1;
          }
          :host(:hover),
          :host(:focus-wthin) {
            z-index: var(--simple-toolbar-focus-z-index, 100) !important;
          }
          :host([hidden]) {
            z-index: -1;
            visibility: hidden;
            opacity: 0;
            height: 0;
            overflow: hidden;
          }
          :host([disabled]) {
            pointer-events: none;
          }
          *[part="button"] {
            display: flex;
            margin: 0;
            white-space: nowrap;
            width: 100%;
            height: 100%;
          }
        `]}static get simpleButtonLayoutStyles(){return[e`
          :host {
            font-family: var(--ddd-font-navigation, sans-serif);
            font-size: 13px;
            flex: 0 1 auto;
            min-width: var(
              --simple-toolbar-button-min-width,
              var(
                --simple-toolbar-button-width,
                var(--simple-toolbar-button-height, 24px)
              )
            );
            z-index: 1;
          }
          :host(:hover) {
            z-index: 2;
          }
          :host(:focus-within),
          :host(:focus) {
            z-index: 3;
          }
          *[part="button"] {
            font-family: inherit;
            font-size: inherit;
            min-width: var(
              --simple-toolbar-button-min-width,
              var(
                --simple-toolbar-button-width,
                var(--simple-toolbar-button-height, 24px)
              )
            );
            min-height: var(--simple-toolbar-button-height, 24px);
            padding: var(--simple-toolbar-button-padding, 1px);
            flex: var(--simple-toolbar-button-flex, 0 0 auto);
            align-items: var(--simple-toolbar-button-align, center);
            justify-content: var(--simple-toolbar-button-justify, center);
          }
          :host([icon-position="top"]) *[part="button"],
          :host([icon-position="bottom"]) *[part="button"] {
            flex-direction: column;
          }
          :host([align-vertical="top"][icon-position="left"]) *[part="button"],
          :host([align-vertical="top"][icon-position="right"]) *[part="button"],
          :host([align-horizontal="left"][icon-position="top"])
            *[part="button"],
          :host([align-horizontal="left"][icon-position="bottom"])
            *[part="button"] {
            align-items: flex-start;
          }
          :host([align-vertical="bottom"][icon-position="left"])
            *[part="button"],
          :host([align-vertical="bottom"][icon-position="right"])
            *[part="button"],
          :host([align-horizontal="right"][icon-position="top"])
            *[part="button"],
          :host([align-horizontal="right"][icon-position="bottom"])
            *[part="button"] {
            align-items: flex-end;
          }
          :host([align-horizontal="left"][icon-position="left"])
            *[part="button"],
          :host([align-horizontal="left"][icon-position="right"])
            *[part="button"],
          :host([align-vertical="top"][icon-position="top"]) *[part="button"],
          :host([align-vertical="top"][icon-position="bottom"])
            *[part="button"] {
            justify-content: flex-start;
          }
          :host([align-horizontal="right"][icon-position="left"])
            *[part="button"],
          :host([align-horizontal="right"][icon-position="right"])
            *[part="button"],
          :host([align-vertical="bottom"][icon-position="top"])
            *[part="button"],
          :host([align-vertical="bottom"][icon-position="bottom"])
            *[part="button"] {
            justify-content: flex-end;
          }
        `]}static get simpleButtonThemeStyles(){return[e`
          *[part="button"] {
            color: var(--simple-toolbar-button-color);
            border-color: var(
              --simple-toolbar-button-border-color,
              var(--simple-toolbar-border-color, transparent)
            );
            background-color: var(--simple-toolbar-button-bg, transparent);
            opacity: var(--simple-toolbar-button-opacity, 1);
            border-width: var(
              --simple-toolbar-button-border-width,
              var(--simple-toolbar-border-width, 1px)
            );
            border-radius: var(--simple-toolbar-border-radius, 3px);
            border-style: solid;
            text-transform: unset;
          }
          :host([radio]) *[part="button"] {
            border-radius: var(--simple-toolbar-radio-border-radius, 0px);
          }
          :host([radio]:last-of-type) *[part="button"] {
            border-top-right-radius: var(--simple-toolbar-border-radius, 3px);
            border-bottom-right-radius: var(
              --simple-toolbar-border-radius,
              3px
            );
          }
          :host([radio]:first-of-type) *[part="button"] {
            border-top-left-radius: var(--simple-toolbar-border-radius, 3px);
            border-bottom-left-radius: var(--simple-toolbar-border-radius, 3px);
          }
          *[part="button"][aria-checked="true"],
          *[part="button"][aria-pressed="true"] {
            color: var(--simple-toolbar-button-toggled-color);
            border-color: var(--simple-toolbar-button-toggled-border-color);
            background-color: var(--simple-toolbar-button-toggled-bg);
            opacity: var(--simple-toolbar-button-toggled-opacity, 0.8);
          }
          *[part="button"]:focus,
          *[part="button"]:hover {
            color: var(--simple-toolbar-button-hover-color);
            background-color: var(--simple-toolbar-button-hover-bg);
            border-color: var(--simple-toolbar-button-hover-border-color);
            opacity: var(--simple-toolbar-button-hover-opacity, 0.8);
          }
          *[part="button"][disabled] {
            cursor: not-allowed;
            color: var(--simple-toolbar-button-disabled-color, unset);
            background-color: var(--simple-toolbar-button-disabled-bg, unset);
            border-color: var(
              --simple-toolbar-button-disabled-border-color,
              unset
            );
            opacity: var(--simple-toolbar-button-disabled-opacity, 0.5);
          }
        `]}static get styles(){let t=[];return super.styles&&(t=super.styles),[t,this.iconStyles,this.labelStyles,this.tooltipStyles,this.simpleButtonCoreStyles,this.simpleButtonLayoutStyles,this.simpleButtonThemeStyles]}}};class SimpleToolbarButton extends(SimpleToolbarButtonBehaviors(i(t))){}customElements.define(SimpleToolbarButton.tag,SimpleToolbarButton);export{SimpleToolbarButton,SimpleToolbarButtonBehaviors};