/**
 * Copyright 2021 The Pennsylvania State University
 * @license Apache-2.0, see License.md for full text.
 */
import{LitElement as t,html as e,css as i}from"../../../lit/index.js";import{SimpleToolbarBehaviors as o}from"../simple-toolbar.js";const SimpleButtonGridBehaviors=function(t){return class extends(o(t)){static get tag(){return"simple-toolbar-grid"}static get baseStyles(){return[i`
          :host {
            padding: 0;
            margin: 0;
            max-width: 100%;
            display: flex;
            overflow: hidden;
            flex-direction: column;
            align-items: stretch;
            overflow: hidden !important;
            --simple-button-grid-cols: var(
              --simple-toolbar-button-min-width,
              var(
                --simple-toolbar-button-width,
                var(--simple-toolbar-button-height, 24px)
              )
            );
            transition: all 0.5s;
            transition: z-index 0s;
          }
          :host([hidden]) {
            z-index: -1;
            visibility: hidden;
            opacity: 0;
            height: 0;
          }
          #grid {
            flex: 1 1 auto;
            max-width: 100%;
            overflow: auto;
          }

          #buttons {
            flex: 0 1 100%;
            max-width: 100%;
            display: flex;
            flex-wrap: wrap;
            --simple-toolbar-button-flex: var(
              --simple-toolbar-button-grid-flex,
              1 1 100%
            );
          }
          #buttons {
            display: grid;
            overflow: visible;
            grid-gap: var(--simple-button-grid-margin, 4px);
            grid-template-columns: repeat(
              auto-fill,
              minmax(
                calc(
                  var(--simple-button-grid-cols) - 2 *
                    var(--simple-button-grid-margin, 4px)
                ),
                1fr
              )
            );
          }
          :host([collapsed]:not([always-expanded]))
            ::slotted(*[collapse-hide]) {
            display: none !important;
          }
        `]}static get properties(){return{...super.properties,columns:{type:Number,attribute:"columns"},rows:{type:Number,attribute:"rows"},disableAutogrow:{type:Boolean,attribute:"disable-autogrow",reflect:!0}}}get gridStyles(){let t=[];return this.columns&&t.push(`--simple-button-grid-cols:${100/this.columns}%`),t.join(";")}get toolbarTemplate(){return e`
        <div id="grid">
          <div
            id="buttons"
            class="${!this.alwaysExpanded&&this.collapsed?"collapsed":""}"
            style="${this.gridStyles}"
            part="buttons"
          >
            <slot></slot>
            ${this.alwaysExpanded?"":this.moreButton}
          </div>
        </div>
      `}_bottom(t){return t&&t.offsetTop&&t.clientHeight?t.offsetTop+t.clientHeight:void 0}resizeToolbar(){if(this.alwaysExpanded)return;let t,e=this.shadowRoot?this.shadowRoot.querySelector("#morebutton"):void 0,i=(this._bottom(e),this._bottom(this)),o=[...this.children||[]],s=!0,l=[];o.forEach((e=>{if(e.removeAttribute&&e.removeAttribute("collapse-hide"),0==l.length)l.unshift(e.offsetTop);else{let o=e.offsetTop>l[0];o&&l.unshift(e.offsetTop),this.rows&&l.length>this.rows||!this.rows&&o&&this._bottom(e)>i?(e.setAttribute("collapse-hide",!0),s=!1):s?t=e:e.setAttribute("collapse-hide",!0)}})),this.collapseDisabled=s&&!(e&&t&&this._bottom(e)>i),!this.collapseDisabled&&t&&t.setAttribute("collapse-hide",!0)}constructor(){super()}}};class SimpleButtonGrid extends(SimpleButtonGridBehaviors(t)){}customElements.define("simple-button-grid",SimpleButtonGrid);export{SimpleButtonGrid,SimpleButtonGridBehaviors};