/**
 * Copyright 2018 The Pennsylvania State University
 * @license Apache-2.0, see License.md for full text.
 */
import{html as t,css as e}from"../../lit/index.js";import{SimpleColors as s}from"../simple-colors/simple-colors.js";import"./lib/simple-toast-el.js";globalThis.SimpleToast=globalThis.SimpleToast||{},globalThis.SimpleToast.requestAvailability=()=>(!globalThis.SimpleToast.instance&&globalThis.document&&(globalThis.SimpleToast.instance=globalThis.document.createElement("simple-toast"),globalThis.document.body.appendChild(globalThis.SimpleToast.instance)),globalThis.SimpleToast.instance);class SimpleToast extends s{static get styles(){return[super.styles,e`
        :host {
          display: block;
        }

        :host([hidden]) {
          display: none;
        }

        simple-toast-el {
          box-shadow: 0 2px 5px 0 rgba(0, 0, 0, 0.26);
          width: var(--simple-toast-width, auto);
          color: var(
            --simple-toast-color,
            var(--simple-colors-default-theme-accent-1, white)
          );
          background-color: var(
            --simple-toast-bg,
            var(--simple-colors-default-theme-accent-12, black)
          );
          top: var(--simple-toast-top);
          margin: var(--simple-toast-margin, 8px);
          padding: var(--simple-toast-padding, 16px);
          left: var(--simple-toast-left, 36px);
          bottom: var(--simple-toast-bottom, 36px);
          right: var(--simple-toast-right);
          border: var(--simple-toast-border);
          z-index: var(--simple-toast-z-index, 1000);
          font-size: var(--simple-toast-font-size);
        }

        button {
          margin-left: 8px;
        }
      `]}render(){return t` <simple-toast-el
      id="toast"
      accent-color="${this.accentColor}"
      ?dark="${this.dark}"
      text="${this.text}"
      duration="${this.duration}"
      ?opened="${this.opened}"
      @opened-changed="${this.openedChanged}"
      .class="${this.classStyle}"
    >
      <slot></slot>
      <button .hidden="${!this.closeButton}" @click="${this.hide}">
        ${this.closeText}
      </button>
    </simple-toast-el>`}static get properties(){return{...super.properties,opened:{type:Boolean,reflect:!0},text:{type:String},classStyle:{type:String,attribute:"class-style"},closeText:{type:String,attribute:"close-text"},duration:{type:Number},eventCallback:{type:String,attribute:"event-callback"},closeButton:{type:Boolean,reflect:!0,attribute:"close-button"}}}static get tag(){return"simple-toast"}constructor(){super(),this.windowControllers=new AbortController,this.setDefaultToast()}connectedCallback(){super.connectedCallback(),globalThis.addEventListener("simple-toast-hide",this.hideSimpleToast.bind(this),{signal:this.windowControllers.signal}),globalThis.addEventListener("simple-toast-show",this.showSimpleToast.bind(this),{signal:this.windowControllers.signal})}disconnectedCallback(){this.windowControllers.abort(),super.disconnectedCallback()}hideSimpleToast(t){this.hide()}openedChanged(t){this.opened=t.detail.value}setDefaultToast(){for(this.opened=!1,this.text="Saved",this.classStyle="",this.closeText="Close",this.duration=3e3,this.accentColor="grey",this.dark=!1,this.eventCallback=null,this.closeButton=!0;null!==this.firstChild;)this.removeChild(this.firstChild)}showSimpleToast(t){this.setDefaultToast(),t.detail.duration&&(this.duration=t.detail.duration),t.detail.text&&(this.text=t.detail.text),t.detail.classStyle&&(this.classStyle=t.detail.classStyle),t.detail.closeText&&(this.closeText=t.detail.closeText),t.detail.closeButton&&(this.closeButton=t.detail.closeButton),t.detail.eventCallback&&(this.eventCallback=t.detail.eventCallback),t.detail.slot&&this.appendChild(t.detail.slot),t.detail.accentColor&&(this.accentColor=t.detail.accentColor),t.detail.dark&&(this.dark=t.detail.dark),this.show()}show(t){this.opened=!0}hide(t){if(this.eventCallback){const t=new CustomEvent(this.eventCallback,{bubbles:!0,cancelable:!0,detail:!0,composed:!0});this.dispatchEvent(t)}this.opened=!1}}customElements.define(SimpleToast.tag,SimpleToast);export{SimpleToast};