import{html as t,css as e}from"../../../lit/index.js";import{DDD as o}from"../../d-d-d/d-d-d.js";class SimpleToastEl extends o{static get tag(){return"simple-toast-el"}static get styles(){return[super.styles,e`
        :host {
          display: none;
          justify-content: center;
          position: fixed;
          min-width: 100px;
          text-align: center;
          color: var(--simple-colors-default-theme-accent-1, white);
          background-color: var(--simple-colors-default-theme-accent-12, black);
          border-radius: var(--simple-toast-border-radius, 2px);
          border: var(--simple-toast-border, none);
          font-size: var(--simple-toast-font-size, 1em);
          font-family: var(--simple-toast-font-family, sans-serif);
        }
        :host(.show) {
          display: flex;
        }
        @-webkit-keyframes fadein {
          from {
            display: flex;
            bottom: var(--simple-toast-bottom-offscreen, 0px);
            opacity: 0;
          }
          to {
            display: flex;
            bottom: var(--simple-toast-bottom, 40px);
            opacity: 1;
          }
        }
        @keyframes fadein {
          from {
            display: flex;
            bottom: var(--simple-toast-bottom-offscreen, 0px);
            opacity: 0;
          }
          to {
            display: flex;
            bottom: var(--simple-toast-bottom, 40px);
            opacity: 1;
          }
        }
        @-webkit-keyframes fadeout {
          from {
            display: flex;
            bottom: var(--simple-toast-bottom, 40px);
            opacity: 1;
          }
          to {
            display: flex;
            bottom: var(--simple-toast-bottom-offscreen, 0px);
            opacity: 0;
          }
        }
        @keyframes fadeout {
          from {
            display: flex;
            bottom: var(--simple-toast-bottom, 40px);
            opacity: 1;
          }
          to {
            display: flex;
            bottom: var(--simple-toast-bottom-offscreen, 0px);
            opacity: 0;
          }
        }
        @-webkit-keyframes forcedfadeout {
          from {
            display: flex;
            bottom: var(--simple-toast-bottom, 40px);
            opacity: 1;
          }
          to {
            display: flex;
            bottom: var(--simple-toast-bottom-offscreen, 0px);
            opacity: 0;
          }
        }
        @keyframes forcedfadeout {
          from {
            display: flex;
            bottom: var(--simple-toast-bottom, 40px);
            opacity: 1;
          }
          to {
            display: flex;
            bottom: var(--simple-toast-bottom-offscreen, 0px);
            opacity: 0;
          }
        }
      `]}static get properties(){return{...super.properties,text:{type:String},alwaysvisible:{type:Boolean},duration:{type:Number},opened:{type:Boolean,reflect:!0}}}_onAnimationEnd(t){"fadeout"!=t.animationName&&"forcedfadeout"!=t.animationName||this.hide()}constructor(){super(),this.text="",this.alwaysvisible=!1,this.duration=3e3,this.opened=!1,this.addEventListener("animationend",this._onAnimationEnd)}updated(t){super.updated(t),t.forEach(((t,e)=>{"opened"===e&&void 0!==t&&(this.dispatchEvent(new CustomEvent("opened-changed",{detail:{value:this[e]}})),this[e]?this.show(this.text):(this.style.animation="none",setTimeout((()=>{this.alwaysvisible||this.awaitingMerlinInput?this.style.animation="fadein 0.3s":this.style.animation="fadein 0.3s, fadeout 0.6s "+this.duration/1e3+"s"}),600))),"duration"===e&&this[e]&&(this.alwaysvisible||this.awaitingMerlinInput?this.style.animation="fadein 0.3s":this.style.animation="fadein 0.3s, fadeout 0.6s "+this[e]/1e3+"s")}))}render(){return t`<span><span>${this.text}</span><slot></slot></span>`}firstUpdated(t){super.updated(t),this.style.setProperty("aria-live","assertive"),this.style.setProperty("role","alert"),this.style.setProperty("aria-atomic","true"),this.style.setProperty("aria-relevant","all")}hide(){this.classList.remove("show"),this.opened=!1}show(t=""){this.text=t,this.classList.add("show")}}customElements.define(SimpleToastEl.tag,SimpleToastEl);export{SimpleToastEl};