/**
 * Copyright 2018 The Pennsylvania State University
 * @license Apache-2.0, see License.md for full text.
 */
import{LitElement as t,html as e,css as i}from"../../lit/index.js";import"../simple-fields/lib/simple-fields-field.js";import"../simple-icon/lib/simple-icon-lite.js";import"../simple-icon/lib/simple-icons.js";import"../simple-tooltip/simple-tooltip.js";import"./lib/simple-search-content.js";import"./lib/simple-search-match.js";class SimpleSearch extends t{static get styles(){return[i`
        :host {
          display: flex;
          align-items: flex-end;
          justify-content: space-between;
          width: 100%;
          background-color: var(
            --simple-search-input-background-color,
            transparent
          );
        }

        #input {
          flex-grow: 2;
          margin-right: 4px;
          padding: var(--simple-search-padding, unset);
          margin: var(--simple-search-margin, unset);
          color: var(--simple-search-input-text-color, #000);
          --simple-fields-color: var(--simple-search-input-text-color, #000);
          --simple-fields-container-color: var(
            --simple-search-input-placeholder-color,
            #222
          );
          --simple-fields-background-color: var(
            --simple-fields-input-background-color,
            transparent
          );
          --simple-icon-color: var(
            --simple-search-input-placeholder-color,
            #222
          );
        }

        #xofy {
          margin: 8px;
        }

        button {
          margin: 8px 0 8px;
          border-style: solid;
          border-width: 1px;
          border-color: var(--simple-search-button-border-color, #ccc);
          color: var(--simple-search-button-color, #111);
          background-color: var(--simple-search-button-bg-color, #eee);
          border-color: var(--simple-search-button-border-color, #ccc);
        }

        button:not([disabled]):focus,
        button:not([disabled]):hover {
          cursor: pointer;
          color: var(--simple-search-button-hover-color, #000);
          background-color: var(--simple-search-button-hover-bg-color, #fff);
          border-color: var(--simple-search-button-hover-border-color, #ddd);
        }

        button[disabled] {
          cursor: not-allowed;
          color: var(--simple-search-button-disabled-color, #999);
          background-color: var(--simple-search-button-disabled-bg-color, #eee);
          border-color: var(--simple-search-button-disabled-border-color, #ccc);
        }

        button:not([controls]) {
          display: none;
        }

        #searchnav {
          flex: 1 0 auto;
        }

        #searchnav button {
          display: inline;
          flex: 1 0 auto;
        }

        *[shrink-hide] {
          display: none;
        }
      `]}render(){return e` <simple-fields-field
        id="input"
        label="${this.searchInputLabel}"
        ?inline="${this.inline||this.noLabelFloat}"
        @value-changed="${this._handleChange}"
      >
        <simple-icon-lite
          icon="${this.searchInputIcon}"
          slot="${this.inline?"label-prefix":"prefix"}"
        ></simple-icon-lite>
      </simple-fields-field>
      <div id="xofy" ?shrink-hide="${this._hasNoSearch(this.searchTerms)}">
        ${this._getResultsSpan(this.resultPointer,this.resultCount)}
      </div>
      <div id="searchnav" ?shrink-hide="${this._hasNoSearch(this.searchTerms)}">
        <button
          id="prev"
          aria-label="${this.prevButtonLabel}"
          role="button"
          controls="${this.controls}"
          tabindex="0"
          ?disabled="${this.__hidePrev}"
          @click="${this._navigateResults}"
        >
          <simple-icon-lite icon="${this.prevButtonIcon}"></simple-icon-lite>
        </button>
        <simple-tooltip for="prev">${this.prevButtonLabel}</simple-tooltip>
        <button
          id="next"
          aria-label="${this.nextButtonLabel}"
          role="button"
          controls="${this.controls}"
          tabindex="0"
          ?disabled="${this.__hideNext}"
          @click="${this._navigateResults}"
        >
          <simple-icon-lite icon="${this.nextButtonIcon}"></simple-icon-lite>
        </button>
        <simple-tooltip for="next">${this.nextButtonLabel}</simple-tooltip>
      </div>`}static get properties(){return{...super.properties,alwaysFloatLabel:{attribute:"always-float-label",type:Boolean},caseSensitive:{attribute:"case-sensitive",type:Boolean},controls:{attribute:"controls",type:String},inline:{attribute:"inline",type:Boolean},nextButtonIcon:{attribute:"next-button-icon",type:String},nextButtonLabel:{attribute:"next-button-label",type:String},noLabelFloat:{attribute:"no-label-float",type:Boolean},prevButtonIcon:{attribute:"prev-button-icon",type:String},prevButtonLabel:{attribute:"prev-button-label",type:String},resultCount:{attribute:"result-count",type:Number},resultPointer:{attribute:"result-pointer",type:Number},selector:{attribute:"selector",type:String},searchInputIcon:{attribute:"search-input-icon",type:String},searchInputLabel:{attribute:"search-input-label",type:String},searchTerms:{attribute:"search-terms",type:Array},target:{type:Object},__hideNext:{type:Boolean},__hidePrev:{type:Boolean}}}static get tag(){return"simple-search"}constructor(){super(),this.alwaysFloatLabel=!1,this.caseSensitive=null,this.controls=null,this.nextButtonIcon="arrow-forward",this.nextButtonLabel="next result",this.noLabelFloat=!1,this.prevButtonIcon="arrow-back",this.prevButtonLabel="previous result",this.resultCount=0,this.resultPointer=0,this.searchInputIcon="search",this.searchInputLabel="search",this.searchTerms=[],this.target=null,this.selector=null,this.__hideNext=!0,this.__hidePrev=!0}updated(t){t.forEach(((t,e)=>{"resultPointer"!==e&&"resultCount"!==e||this._getNavDisabled(this.resultPointer,this.resultCount)}))}_handleChange(t){let e=this.selector?` ${this.selector}`:"",i=this.controls?this.getRootNode().querySelectorAll(`#${this.controls}${e}`):null;this._getSearchText(),this.resultCount=0,this.resultPointer=0,i.forEach((t=>{this._searchSelection(t)})),this.dispatchEvent(new CustomEvent("simple-search",{detail:{search:this,content:t}}))}_searchSelection(t){t&&t.innerHTML&&(t.innerHTML=this.findMatches(t.innerHTML))}_hasNoSearch(t){return t.length<1}_getResultsSpan(t,e){return e>0&&t>0?t+"/"+e:e>0?e:"0"}_navigateResults(t){let e="next"===t.currentTarget.id?1:-1;this.resultPointer+e>0&&this.resultPointer+e<=this.resultCount&&(this.resultPointer+=e,this.dispatchEvent(new CustomEvent("goto-result",{detail:this.resultPointer})))}_getNavDisabled(t,e){this.__hidePrev=this._isNavButtonDisabled(t,e,-1),this.__hideNext=this._isNavButtonDisabled(t,e)}_isNavButtonDisabled(t,e,i=1){return!e||0===e||t+i<=0||t+i>e}_getSearchText(){let t=this.shadowRoot.querySelector("#input").value,e=new Array;if(null!=t){e=t.split(/[\"\']/gm);for(let t=0;t<e.length;t++)e[t]=e[t].trim(),""===e[t]&&e.splice(t,1)}this.searchTerms=e.slice(0)}findMatches(t){return this.resultPointer=0,t=t.replace(/<\/?simple-search-match[^>]*>/g,""),this.searchTerms.forEach((e=>{let i=this.caseSensitive?"gm":"gim",r=new RegExp("\\b("+e+")\\b",i);t=t.replace(r,(t=>(this.resultCount++,`<simple-search-match tabindex="0" match-number="${this.resultCount}">${t}</simple-search-match>`)))})),t}}customElements.define(SimpleSearch.tag,SimpleSearch);export{SimpleSearch};