/**
 * Copyright 2019 The Pennsylvania State University
 * @license Apache-2.0, see License.md for full text.
 */
import{LitElement as o,html as t,css as e}from"../../lit/index.js";import{AbsolutePositionBehavior as i}from"../absolute-position-behavior/absolute-position-behavior.js";class SimplePopover extends i{static get styles(){return[super.styles,e`
        :host([hidden]) {
          display: none;
        }

        :host > div {
          display: flex;
          flex-direction: column-reverse;
          justify-content: stretch;
          z-index: 1;
        }

        :host([position="left"]) > div {
          justify-content: flex-start;
          flex-direction: row;
        }

        :host([position="right"]) > div {
          justify-content: flex-end;
          flex-direction: row-reverse;
        }

        :host([position="top"]) > div {
          flex-direction: column;
        }

        :host > div > * {
          width: 100%;
        }

        :host([position="left"]) > div > *,
        :host([position="right"]) > div > * {
          width: unset;
        }

        :host {
          pointer-events: none;
        }

        #content {
          margin: 0;
          pointer-events: all;
          padding: var(--simple-popover-padding, 10px);
          color: var(--simple-popover-color, #222);
          background-color: var(--simple-popover-background-color, white);
          border: var(
            --simple-popover-border,
            1px solid var(--simple-popover-border-color, #bbb)
          );
          border-radius: var(--simple-popover-border-radius, 3px);
          box-shadow: var(
            --simple-popover-box-shadow,
            rgba(60, 64, 67, 0.3) 0px 4px 8px 3px
          );
          min-height: var(--simple-popover-min-height, 20px);
          max-height: var(--simple-popover-max-height, 200px);
          scroll-behavior: smooth;
        }

        #pointer-outer {
          margin: -1px;
        }

        #pointer {
          width: 20px;
          height: 20px;
          position: relative;
          overflow: hidden;
          flex: 0 0 20px;
        }

        #pointer:after {
          content: "";
          position: absolute;
          width: 10px;
          height: 10px;
          background-color: var(--simple-popover-background-color, white);
          border: 1px solid var(--simple-popover-border-color, #bbb);
          transform: rotate(45deg);
          top: 15px;
          left: 5px;
        }

        :host([position="top"]) #pointer:after {
          top: -5px;
          left: 5px;
        }

        :host([position="right"]) #pointer:after {
          top: 5px;
          left: 15px;
        }

        :host([position="left"]) #pointer:after {
          top: 5px;
          left: -5px;
        }
      `]}render(){return t` <div>
      <div id="content" role="alertdialog" part="simple-popover-content">
        <slot></slot>
      </div>
      <div id="pointer-outer">
        <div id="pointer" .style=${this._getMargins(this.__positions)}></div>
      </div>
    </div>`}constructor(){super(),this.offset=-10,this.fitToVisibleBounds=!0}static get tag(){return"simple-popover"}_getMargins(o){if(o&&o.target){let t=this.getBoundingClientRect(),e="bottom"===this.position||"top"===this.position,i=e?t.width:t.height,r=e?t.left:t.top,p=(e?o.target.left:o.target.top)+(e?o.target.width/2:o.target.height/2)-10,s=Math.min(i-20,Math.max(0,p-r));return e?`margin: 0 0 0 ${s}px;`:`margin: ${s}px 0 0 0;`}return""}}customElements.define(SimplePopover.tag,SimplePopover);export{SimplePopover};