import{html as o,css as e,LitElement as t}from"../../../lit/index.js";import"../simple-popover.js";class SimplePopoverManager extends t{constructor(){super(),this.popover=null,this.opened=!1,this.context=null,this.orientation="tb",this.position="bottom",this.__ignore=!1}static get styles(){return[e`
        simple-popover {
          font-family: var(--simple-tour-font-family, unset);
          font-size: var(--simple-tour-font-size, 14px);
          max-width: var(--simple-popover-manager-max-width, 200px);
          min-width: var(--simple-popover-manager-min-width, 200px);
          display: flex;
          --simple-popover-padding: 0;
          --simple-icon-button-border: 1px solid
            var(--simple-tour-border-color, #ddd);
          --simple-icon-button-border-radius: 3px;
        }
        simple-popover[hidden] {
          display: none !important;
        }
        .heading {
          font-size: var(--simple-tour-titlebar-font-size, 14px);
          flex: 0 0 auto;
          background-color: var(
            --simple-tour-titlebar-background-color,
            #f0f4f8
          );
          border-bottom: 1px solid var(--simple-tour-border-color, #ddd);
          line-height: 130%;
          padding: var(--simple-tour-padding-sm, 2px)
            var(--simple-tour-padding-sm, 2px)
            var(--simple-tour-padding-sm, 2px)
            var(--simple-tour-padding-lg, 10px);
          display: flex;
          align-items: center;
          justify-content: space-between;
          position: sticky;
          top: 0;
        }
        .body {
          flex: 1 1 auto;
          padding: var(--simple-tour-padding-sm, 2px)
            var(--simple-tour-padding-lg, 10px);
          background-color: var(--simple-tour-background-color, #fff);
        }
        .nav {
          flex: 0 0 auto;
          margin: 0;
          padding: 0;
          display: flex;
          align-items: center;
          justify-content: space-between;
          position: sticky;
          bottom: 0;
          background-color: var(--simple-tour-background-color, #fff);
        }
        ::slotted(.title) {
          font-size: var(--simple-tour-titlebar-font-size, 14px);
          margin: 0 calc(2 * var(--simple-tour-padding-sm, 2px)) 0 0;
          line-height: 100%;
        }
        ::slotted(.subheading) {
          font-size: var(--simple-tour-subheading-font-size, 16px);
        }
        ::slotted([slot="body"]) {
          margin: var(--simple-tour-padding-sm, 2px) 0;
        }
        ::slotted(simple-icon-button-lite) {
          flex: 1 1 auto;
          background-color: var(--simple-tour-background-color, #fff);
        }
        ::slotted(simple-icon-button-lite[slot="heading"]) {
          flex: 0 0 auto;
        }
        ::slotted(simple-icon-button-lite:focus-within),
        ::slotted(simple-icon-button-lite:hover) {
          --simple-icon-button-border: 1px solid #000;
        }
      `]}render(){return o`
      <simple-popover
        auto
        part="simple-popover"
        ?hidden="${!this.opened}"
        position="${this.position}"
        fit-to-visible-bounds
      >
        <div class="heading" part="simple-popover-heading">
          <slot name="heading"></slot>
        </div>
        <div class="body" part="simple-popover-body">
          <slot name="body"></slot>
        </div>
        <div class="nav" part="simple-popover-nav">
          <slot name="nav"></slot>
        </div>
      </simple-popover>
    `}static get properties(){return{position:{type:String},opened:{type:Boolean},orientation:{type:String},popover:{type:Object}}}updated(o){o.forEach(((o,e)=>{["opened","position","orientation"].includes(e)&&(clearTimeout(this.timer),this.timer=setTimeout((()=>{this.shadowRoot&&this.popover&&this.popover.updatePosition&&this.popover.updatePosition()}),0))}))}setPopover(o,e,t=null,i="tb",p){if(this.__ignore)this.__ignore=!1,setTimeout((()=>{this.shadowRoot&&this.popover&&this.popover.updatePosition&&this.popover.updatePosition()}),100);else{let s;e!==this.popover.target&&(this.context&&this.context.managerReset&&o!==this.context&&(this.context.managerReset(),this.__ignore=!0),this.context=o,this.setAttribute("mode",p||""),this.popover.target=null,this.popover.target=e);let r=e.getBoundingClientRect();s="tb"==i?r.y>globalThis.innerHeight/2?"top":"bottom":r.x>globalThis.innerWidth/2?"left":"right",this.orientation=i,this.position=s,null!=t&&(this.opened=t)}}firstUpdated(){this.popover=this.shadowRoot.querySelector("simple-popover")}}customElements.define("simple-popover-manager",SimplePopoverManager);export{SimplePopoverManager};globalThis.SimplePopoverManager=globalThis.SimplePopoverManager||{},globalThis.SimplePopoverManager.requestAvailability=()=>(globalThis.SimplePopoverManager.instance||(globalThis.SimplePopoverManager.instance=globalThis.document.createElement("simple-popover-manager"),globalThis.document.body.appendChild(globalThis.SimplePopoverManager.instance)),globalThis.SimplePopoverManager.instance),globalThis.SimplePopoverManager.requestAvailability();