/**
 * Copyright 2019 The Pennsylvania State University
 * @license Apache-2.0, see License.md for full text.
 */
import{LitElement as e,html as t,css as o}from"../../lit/index.js";import"../simple-icon/lib/simple-icons.js";import"../simple-icon/lib/simple-icon-lite.js";import"../simple-icon/lib/simple-icon-button-lite.js";import{DDDSuper as i}from"../d-d-d/d-d-d.js";const l=["--simple-modal-resize","--simple-modal-width","--simple-modal-z-index","--simple-modal-height","--simple-modal-min-width","--simple-modal-min-height","--simple-modal-max-width","--simple-modal-max-height","--simple-modal-titlebar-color","--simple-modal-titlebar-height","--simple-modal-titlebar-line-height","--simple-modal-titlebar-background","--simple-modal-titlebar-padding","--simple-modal-header-color","--simple-modal-header-background","--simple-modal-header-padding","--simple-modal-content-container-color","--simple-modal-content-container-background","--simple-modal-content-padding","--simple-modal-buttons-color","--simple-modal-buttons-background","--simple-modal-buttons-padding","--simple-modal-button-color","--simple-modal-button-background"];class SimpleModal extends e{static get styles(){return[o`
        :host {
          display: block;
        }

        :host([hidden]) {
          display: none;
        }

        #titlebar {
          margin-top: 0;
          padding: var(
            --simple-modal-titlebar-padding,
            0px var(--ddd-spacing-4)
          );
          display: flex;
          align-items: center;
          justify-content: space-between;
          background-color: var(
            --simple-modal-titlebar-background,
            var(--ddd-theme-default-limestoneLight)
          );
          height: var(--simple-modal-titlebar-height, unset);
          line-height: var(--simple-modal-titlebar-line-height, unset);
          color: var(--ddd-theme-default-nittanyNavy);
          font-size: var(--ddd-theme-h3-font-size);
        }

        #headerbar {
          margin: 0;
          padding: var(--simple-modal-header-padding, 0px var(--ddd-spacing-4));
        }

        #close {
          top: 0;
          border: var(--simple-modal-titlebar-button-border, none);
          padding: var(
            --simple-modal-titlebar-button-padding,
            var(--ddd-spacing-3) 0
          );
          min-width: unset;
          text-transform: none;
          background-color: transparent;
          color: var(--ddd-theme-default-nittanyNavy);
          --simple-icon-width: var(--ddd-icon-sm);
          --simple-icon-height: var(--ddd-icon-sm);
        }

        #close simple-icon-lite {
          --simple-icon-height: var(
            --simple-modal-titlebar-icon-height,
            --ddd-icon-3xs
          );
          --simple-icon-width: var(
            --simple-modal-titlebar-icon-width,
            --ddd-icon-3xs
          );
        }

        #simple-modal-content {
          flex-grow: 1;
          padding: var(
            --simple-modal-content-padding,
            var(--ddd-spacing-2) var(--ddd-spacing-4) var(--ddd-spacing-4)
          );
          margin: 0;
          color: var(--simple-modal-content-container-color, #222);
          background-color: var(
            --simple-modal-content-container-background,
            #fff
          );
        }

        .buttons {
          padding: 0;
          padding: var(--simple-modal-buttons-padding, 0);
          margin: var(--ddd-spacing-2);
          background-color: var(--simple-modal-buttons-background);
        }

        .buttons ::slotted(*) {
          padding: 0 var(--ddd-spacing-4) var(--ddd-spacing-4);
          margin: 0;
          color: var(--simple-modal-button-color, --simple-modal-buttons-color);
          background-color: var(
            --simple-modal-button-background,
            --simple-modal-buttons-background
          );
        }
        web-dialog {
          --dialog-border-radius: var(--ddd-radius-sm);
          z-index: var(--simple-modal-z-index, 1) !important;
          padding: 0;
        }
        web-dialog::part(dialog) {
          background-color: light-dark(
            var(--ddd-accent-6),
            var(--ddd-primary-4)
          );
          min-height: var(--simple-modal-min-height, unset);
          min-width: var(--simple-modal-min-width, unset);
          z-index: var(--simple-modal-z-index, 1000);
          resize: var(--simple-modal-resize, unset);
          padding: 0;
          --dialog-height: var(--simple-modal-height, auto);
          --dialog-width: var(--simple-modal-width, 75vw);
          --dialog-max-width: var(--simple-modal-max-width, 100vw);
          --dialog-max-height: var(--simple-modal-max-height, 100vh);
        }
        web-dialog.style-scope.simple-modal {
          display: none !important;
        }
        web-dialog[open].style-scope.simple-modal {
          display: flex !important;
          position: fixed !important;
          margin: auto;
        }
        :host([resize="none"]) web-dialog[open].style-scope.simple-modal,
        :host([resize="horizontal"]) web-dialog[open].style-scope.simple-modal {
          top: calc(50% - var(--simple-modal-height, auto) / 2);
        }
        :host([resize="none"]) web-dialog[open].style-scope.simple-modal,
        :host([resize="vertical"]) web-dialog[open].style-scope.simple-modal {
          left: calc(50% - var(--simple-modal-width, 75vw) / 2);
        }

        .full {
          background-color: var(--ddd-theme-default-limestoneLight);
        }

        div.empty {
          background-color: transparent;
        }
      `]}render(){return t` <web-dialog
      id="dialog"
      center
      role="dialog"
      part="dialog"
      aria-describedby="simple-modal-content"
      aria-label="${this._getAriaLabel(this.title)}"
      aria-labelledby="${this._getAriaLabelledby(this.title)}"
      aria-modal="true"
      ?open="${this.opened}"
      @open="${this.open}"
      @close="${this.close}"
    >
      <div id="titlebar" part="titlebar" class=${this.title?"full":"empty"}>
        <h3 id="simple-modal-title" ?hidden="${!this.title}" part="title" class=${this.title?"hr-vert":""}>
          ${this.title}
        </h3>
        <div></div>
        ${this.modal?"":t`<simple-icon-button-lite
                id="close"
                dark
                icon="${this.closeIcon}"
                @click="${this.close}"
                label="${this.closeLabel}"
                part="close"
              >
              </simple-icon-button-lite>`}
      </div>
      <h5 id="headerbar" part="headerbar"><slot name="header"></slot></h4>
      <p id="simple-modal-content" part="content">
        <slot name="content"></slot>
      </p>
      <slot name="custom" part="custom"></slot>
      <div class="buttons" part="buttons">
        <slot name="buttons"></slot>
      </div>
    </web-dialog>`}static get properties(){return{...super.properties,title:{type:String},opened:{type:Boolean,reflect:!0},closeLabel:{attribute:"close-label",type:String},closeIcon:{type:String,attribute:"close-icon"},invokedBy:{type:Object},modal:{type:Boolean},mode:{type:String,reflect:!0}}}static get tag(){return"simple-modal"}constructor(){super(),this.windowControllers=new AbortController,this.title="",this.opened=!1,this.closeLabel="Close",this.closeIcon="close",this.modal=!1}firstUpdated(){import("../../web-dialog/index.js").then((e=>{setTimeout((()=>{this.shadowRoot.querySelector("web-dialog").shadowRoot.querySelector("#backdrop").style.backgroundColor="var(--ddd-theme-default-potential70)"}),0)}))}updated(e){e.forEach(((e,t)=>{"opened"==t&&this._openedChanged(this[t])}))}connectedCallback(){super.connectedCallback(),this.close=this.close.bind(this),this.showEvent=this.showEvent.bind(this),setTimeout((()=>{globalThis.addEventListener("simple-modal-hide",this.close,{signal:this.windowControllers.signal}),globalThis.addEventListener("simple-modal-show",this.showEvent,{signal:this.windowControllers.signal})}),0)}disconnectedCallback(){this.windowControllers.abort(),super.disconnectedCallback()}showEvent(e){globalThis.dispatchEvent(new CustomEvent("simple-toast-hide",{bubbles:!0,composed:!0,cancelable:!1,detail:!1})),this.opened?(this.innerHTML="",setTimeout((()=>{this.show(e.detail.title,e.detail.mode,e.detail.elements,e.detail.invokedBy,e.detail.id,e.detail.modalClass,e.detail.styles,e.detail.clone,e.detail.modal)}),0)):this.show(e.detail.title,e.detail.mode,e.detail.elements,e.detail.invokedBy,e.detail.id,e.detail.modalClass,e.detail.styles,e.detail.clone,e.detail.modal)}show(e,t,o,i,a=null,d=null,s=null,n=!1,r=!1){let m;this.invokedBy=i,this.modal=r,this.title=e,this.mode=t;let c=["header","content","buttons","custom"];for(var p in a?this.setAttribute("id",a):this.removeAttribute("id"),this.setAttribute("style",""),s&&l.forEach((e=>{this.style.setProperty(e,s[e]||"inherit")})),d?this.setAttribute("class",d):this.removeAttribute("class"),c)o[c[p]]&&(m=n?o[c[p]].cloneNode(!0):o[c[p]],m.setAttribute("slot",c[p]),this.appendChild(m));this.opened=!0}close(){this.opened=!1,globalThis.ShadyCSS&&!globalThis.ShadyCSS.nativeShadow&&(this.shadowRoot.querySelector("web-dialog").shadowRoot.querySelector("#backdrop").style.position="relative")}open(){this.opened=!0;const e=this.shadowRoot.querySelector("web-dialog");this.modal?(e.$backdrop.removeEventListener("click",e.onBackdropClick),e.removeEventListener("keydown",e.onKeyDown,{capture:!0})):(e.$backdrop.addEventListener("click",e.onBackdropClick),e.addEventListener("keydown",e.onKeyDown,{capture:!0,passive:!0})),globalThis.ShadyCSS&&!globalThis.ShadyCSS.nativeShadow&&(this.shadowRoot.querySelector("web-dialog").shadowRoot.querySelector("#backdrop").style.position="fixed",this.shadowRoot.querySelector("web-dialog").shadowRoot.querySelector("#backdrop").style.top=0,this.shadowRoot.querySelector("web-dialog").shadowRoot.querySelector("#backdrop").style.bottom=0,this.shadowRoot.querySelector("web-dialog").shadowRoot.querySelector("#backdrop").style.left=0,this.shadowRoot.querySelector("web-dialog").shadowRoot.querySelector("#backdrop").style.right=0)}_openedChanged(e){if(void 0===e||e){if(e){this.querySelectorAll("[dialog-dismiss]").forEach((e=>{e.addEventListener("click",(e=>{const t=new CustomEvent("simple-modal-dismissed",{bubbles:!0,composed:!0,cancelable:!0,detail:{opened:!1,invokedBy:this.invokedBy}});this.dispatchEvent(t),this.close()}))})),this.querySelectorAll("[dialog-confirm]").forEach((e=>{e.addEventListener("click",(e=>{const t=new CustomEvent("simple-modal-confirmed",{composed:!0,bubbles:!0,cancelable:!0,detail:{opened:!1,invokedBy:this.invokedBy}});this.dispatchEvent(t),this.close()}))}));const e=new CustomEvent("simple-modal-opened",{bubbles:!0,composed:!0,cancelable:!0,detail:{opened:!0,invokedBy:this.invokedBy}});this.dispatchEvent(e)}}else{for(this.title="";null!==this.firstChild;)this.removeChild(this.firstChild);this.invokedBy&&setTimeout((()=>{this.invokedBy.focus()}),500);const e=new CustomEvent("simple-modal-closed",{bubbles:!0,cancelable:!0,detail:{opened:!1,invokedBy:this.invokedBy}});this.dispatchEvent(e)}}_getAriaLabelledby(e){return e?"simple-modal-title":null}_getAriaLabel(e){return e?null:"Modal Dialog"}}customElements.define(SimpleModal.tag,SimpleModal);export{SimpleModal,l as SimpleModalCssVars};globalThis.SimpleModal=globalThis.SimpleModal||{},globalThis.SimpleModal.requestAvailability=()=>(!globalThis.SimpleModal.instance&&globalThis.document&&globalThis.document.body&&(globalThis.SimpleModal.instance=globalThis.document.createElement("simple-modal"),globalThis.document.body.appendChild(globalThis.SimpleModal.instance)),globalThis.SimpleModal.instance);export const SimpleModalStore=globalThis.SimpleModal.requestAvailability();