/**
 * Copyright 2019 The Pennsylvania State University
 * @license Apache-2.0, see License.md for full text.
 */
import{css as e,html as i}from"../../lit/index.js";import{SimpleColors as t}from"../simple-colors/simple-colors.js";import"../simple-progress/simple-progress.js";import"../simple-fields/lib/simple-fields-field.js";class SimpleLogin extends t{static get styles(){return[super.styles,e`
        :host {
          display: block;
        }

        :host([hidden]) {
          display: none;
        }

        #loginform {
          width: var(--login-form-width, 450px);
          height: var(--login-form-height, auto);
          --simple-camera-snap-color: var(--login-form-color, #36bed4);
          --simple-camera-snap-error: var(--login-form-error, red);
          --simple-camera-snap-background: var(--login-form-background, white);
          --simple-camera-snap-border-radius: var(
            --login-form-image-bnorder-radius,
            100%
          );
          box-shadow:
            0 12px 16px 1px rgba(0, 0, 0, 0.14),
            0 4px 22px 3px rgba(0, 0, 0, 0.12),
            0 6px 7px -4px rgba(0, 0, 0, 0.4);
        }

        #loginformcontent {
          padding: var(--login-form-padding, 48px);
        }

        #loginformcontent > * {
          margin-top: var(
            --login-form-margin-top,
            var(--login-form-margin, 8px)
          );
          margin-bottom: var(
            --login-form-margin-bottom,
            var(--login-form-margin, 8px)
          );
        }

        #loginbtn,
        #buttons ::slotted(button) {
          cursor: pointer;
          width: var(--login-btn-width, auto);
          margin: var(--login-btn-margin, 24px auto 0);
          display: var(--login-btn-display, inline-flex);
        }

        #loginbtn[disabled] {
          background-color: var(
            --login-btn-disabled-background-color,
            var(--simple-colors-default-theme-accent-12, #000000)
          );
        }

        h1 {
          margin: 0;
        }

        h2 {
          margin: 0;
        }

        simple-progress {
          width: 100%;
        }

        ::slotted(simple-login-avatar) {
          margin: 0 auto;
        }

        #errormsg {
          margin-top: 16px;
          color: var(--login-error-label-color, var(--error-color));
        }
      `]}render(){return i` <div id="loginform">
      <simple-progress ?disabled="${!this.loading}"></simple-progress>
      <div id="loginformcontent">
        ${this.title?i`<h1>${this.title}</h1>`:""}
        ${this.subtitle?i`<h2>${this.subtitle}</h2>`:""}
        <div id="errormsg">${this.errorMsg}</div>
        <slot></slot>
        <simple-fields-field
          id="userinput"
          value="${this.username}"
          @value-changed="${this._usernameChanged}"
          type="text"
          ?disabled="${this.loading}"
          label="${this.userInputLabel}"
          required
          error-message="${this.userInputErrMsg}"
        ></simple-fields-field>
        <simple-fields-field
          id="passinput"
          required
          value="${this.password}"
          @value-changed="${this._passwordChanged}"
          ?disabled="${this.loading}"
          type="password"
          label="${this.passwordInputLabel}"
          error-message="${this.passwordInputErrMsg}"
        ></simple-fields-field>
        <button
          @click="${this._login}"
          ?disabled="${this.loading}"
          id="loginbtn"
        >
          ${this.loginBtnText}
        </button>
        <span id="buttons"><slot name="buttons"></slot></span>
      </div>
    </div>`}static get properties(){return{...super.properties,title:String,subtitle:String,errorMsg:String,username:{type:String},password:{type:String},loading:{type:Boolean},userInputLabel:{type:String,attribute:"user-input-label"},userInputErrMsg:{type:String},passwordInputLabel:{type:String,attribute:"password-input-label"},passwordInputErrMsg:{type:String},loginBtnText:{type:String,attribute:"login-btn-text"}}}static get tag(){return"simple-login"}constructor(){super(),this.password="",this.username="",this.loading=!1,this.userInputLabel="User name",this.userInputErrMsg="User name required",this.passwordInputLabel="Password",this.passwordInputErrMsg="Password required",this.loginBtnText="Login"}updated(e){super.updated(),e.forEach(((e,i)=>{["username","password"].includes(i)&&this.dispatchEvent(new CustomEvent(`${i}-changed`,{detail:{value:this[i]}}))}))}firstUpdated(e){super.firstUpdated&&super.firstUpdated(e),setTimeout((()=>{this.shadowRoot.querySelector("#loginform").addEventListener("keypress",this._keyPressLogin.bind(this))}),0)}_keyPressLogin(e){if(13==e.keyCode)return this._login(),!1}_passwordChanged(e){this.password=e.detail.value}_usernameChanged(e){this.username=e.detail.value}_login(){this.shadowRoot.querySelector("#userinput").validate()&&this.shadowRoot.querySelector("#passinput").validate()&&this.dispatchEvent(new CustomEvent("simple-login-login",{cancelable:!0,bubbles:!0,composed:!0,detail:{u:this.shadowRoot.querySelector("#userinput").value,p:this.shadowRoot.querySelector("#passinput").value}}))}}customElements.define(SimpleLogin.tag,SimpleLogin);export{SimpleLogin};